(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    189284,       5942]
NotebookOptionsPosition[    182031,       5765]
NotebookOutlinePosition[    182688,       5789]
CellTagsIndexPosition[    182645,       5786]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "This", " ", "file", " ", "performs", " ", "the", " ", "calculation", " ",
      "of", " ", "the", " ", "Fourier", " ", "transform", " ", "at", " ", 
     "frequencies", " ", "not", " ", "divisible", " ", "by", " ", "p"}], ",", 
    " ", 
    RowBox[{
    "then", " ", "obtains", " ", "the", " ", "L_p", " ", "estimates", " ", 
     "in", " ", "Theorem", " ", "1"}]}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.7413480220814037`*^9, 
  3.74134805318194*^9}},ExpressionUUID->"d188cbeb-305c-4527-b0f3-\
d7afe43a130e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "First", " ", "the", " ", "exponential", " ", "sums", " ", "labeled", 
      " ", "script"}], "-", 
     RowBox[{"M", 
      RowBox[{"(", 
       RowBox[{"x", ",", " ", 
        RowBox[{"\\", "xi"}]}], ")"}], " ", "are", " ", "loaded"}]}], ",", 
    " ", 
    RowBox[{"sorted", " ", "by", " ", 
     RowBox[{"frequency", " ", "\\", "xi"}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "First", " ", "load", " ", "these", " ", "sums", " ", "for", " ", 
    "frequencies", " ", "above", " ", "the", " ", "orbit", " ", "OD12"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"D12orbit", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "-", "1"}], ")"}], "^", "3"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "15", ")"}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "-", "1"}], ")"}], "^", "3"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "15", ")"}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "-", "1"}], ")"}], "^", "3"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "14", ")"}]}], "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "-", "1"}], ")"}], "^", "3"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "14", ")"}]}], "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "-", "1"}], ")"}], "^", "3"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}], "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "-", "1"}], ")"}], "^", "3"}]}], "*", 
          RowBox[{
           RowBox[{"p", "^", 
            RowBox[{"(", "15", ")"}]}], "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "15", ")"}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "14", ")"}]}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "-", "1"}], ")"}], "^", "3"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "14", ")"}]}]}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}]}]}], "}"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], 
          RowBox[{"p", "^", 
           RowBox[{"(", "15", ")"}]}]}], ",", "0", ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "-", "1"}], ")"}], "^", "3"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "14", ")"}]}]}], ",", " ", 
         RowBox[{"2", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "14", ")"}]}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "-", "1"}], ")"}], "^", "3"}]}], 
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}]}]}], "}"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "15", ")"}]}], "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "14", ")"}]}], "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], ",", " ", "0", ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}], "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "15", ")"}]}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "*", "p"}], "-", "1"}], ")"}], "/", "2"}]}], ",", 
         " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "*", 
          RowBox[{
           RowBox[{"p", "^", 
            RowBox[{"(", "15", ")"}]}], "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "14", ")"}]}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "-", "1"}], ")"}], "^", "3"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "14", ")"}]}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", "^", "2"}], "-", "p", "+", "1"}], ")"}]}]}], "}"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "*", 
          RowBox[{
           RowBox[{"p", "^", 
            RowBox[{"(", "15", ")"}]}], "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "*", 
          RowBox[{
           RowBox[{"p", "^", 
            RowBox[{"(", "15", ")"}]}], "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "14", ")"}]}]}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "14", ")"}]}]}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}]}]}], "}"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "15", ")"}]}]}], ",", " ", "0", ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "14", ")"}]}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "14", ")"}]}], "*", 
          RowBox[{"(", 
           RowBox[{"p", "-", "2"}], ")"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "-", "1"}], ")"}], "^", "3"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}]}]}], "}"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"{", 
        RowBox[{
         RowBox[{"p", "^", 
          RowBox[{"(", "15", ")"}]}], ",", " ", "0", ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "14", ")"}]}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", "2"}], "*", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "14", ")"}]}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "*", "p"}], "-", "1"}], ")"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{"p", "^", 
          RowBox[{"(", "15", ")"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "14", ")"}]}]}], ",", " ", "0", ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}]}]}], "}"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
          RowBox[{
           RowBox[{"p", "^", 
            RowBox[{"(", "15", ")"}]}], "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
          RowBox[{
           RowBox[{"p", "^", 
            RowBox[{"(", "15", ")"}]}], "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "14", ")"}]}]}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "14", ")"}]}]}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}]}]}], "}"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0", ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "14", ")"}]}]}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}]}]}], "}"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0", ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "14", ")"}]}]}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}]}]}], "}"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}]}]}], "}"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0", ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "14", ")"}]}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}]}]}], "}"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0", ",", " ", 
         RowBox[{"p", "^", 
          RowBox[{"(", "14", ")"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}]}]}], "}"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0", ",", "0", ",", " ", 
         RowBox[{"p", "^", 
          RowBox[{"(", "13", ")"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0", ",", "0", ",", "0"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0", ",", "0", ",", "0"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0", ",", "0", ",", "0"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0", ",", "0", ",", "0"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0", ",", "0", ",", "0"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0", ",", "0", ",", "0"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0", ",", "0", ",", "0"}], 
        "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"MatrixForm", "[", "D12orbit", "]"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"v", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", "1", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Now", " ", "calculate", " ", "the", " ", "Fourier", " ", "transform", 
     " ", "on", " ", "the", " ", "orbit", " ", "OD12", " ", "by", " ", 
     "taking", " ", "the", " ", "sum"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"D12orbitSum", " ", "=", " ", 
     RowBox[{"D12orbit", ".", "v"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "object", " ", "stores", " ", "the", " ", "square", " ", 
     "of", " ", "the", " ", "frequencies", " ", "for", " ", "the", " ", 
     "purpose", " ", "of", " ", "taking", " ", "the", " ", 
     RowBox[{"L", "^", "2"}], " ", "norm"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"D12orbitSum2", " ", "=", " ", 
     RowBox[{"D12orbitSum", " ", "*", " ", "D12orbitSum"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"Simplify", "[", "D12orbitSum", "]"}], "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"Simplify", "[", "D12orbitSum2", "]"}], "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"MatrixForm", "[", 
     RowBox[{"Simplify", "[", 
      RowBox[{"D12orbitSum", "/", 
       RowBox[{"p", "^", 
        RowBox[{"(", "12", ")"}]}]}], "]"}], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.734858325678835*^9, 3.734858547056175*^9}, {
  3.734858600976489*^9, 3.734858757670731*^9}, {3.734858842438274*^9, 
  3.734859020581135*^9}, {3.7348592426597767`*^9, 3.734859438722561*^9}, {
  3.7348595945536413`*^9, 3.734859841864192*^9}, {3.734859882516698*^9, 
  3.734859898156002*^9}, {3.734859951759479*^9, 3.734860003103036*^9}, {
  3.734865280701516*^9, 3.7348653223972387`*^9}, {3.736714791185791*^9, 
  3.736714821009197*^9}, {3.7367152027357073`*^9, 3.7367152374793043`*^9}, {
  3.741348057280805*^9, 3.741348113785996*^9}, {3.7413481608053226`*^9, 
  3.74134821794132*^9}},ExpressionUUID->"65dda1b3-8862-472c-a41d-\
a8ad41151648"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "15"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "15"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"]}], " ", 
       SuperscriptBox["p", "14"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"]}], " ", 
       SuperscriptBox["p", "14"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"]}], " ", 
       SuperscriptBox["p", "13"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p"}], ")"}]}]},
     {
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "15"]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "15"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p"}], ")"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "14"]}], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"]}], " ", 
       SuperscriptBox["p", "14"]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "13"]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "15"]}], "0", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"]}], " ", 
       SuperscriptBox["p", "14"]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "14"]}], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"]}], " ", 
       SuperscriptBox["p", "13"]}]},
     {"0", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}], " ", 
       SuperscriptBox["p", "15"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p"}], ")"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "14"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p"}], ")"}]}], "0", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "13"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p"}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "p"}], ")"}], " ", 
       SuperscriptBox["p", "15"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "p"}]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}], " ", 
       SuperscriptBox["p", "15"]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "14"]}], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"]}], " ", 
       SuperscriptBox["p", "14"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}], " ", 
       SuperscriptBox["p", "13"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}], " ", 
       SuperscriptBox["p", "15"]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}], " ", 
       SuperscriptBox["p", "15"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}], " ", 
       SuperscriptBox["p", "14"]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "14"]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "13"]}]},
     {
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}], " ", 
       SuperscriptBox["p", "15"]}], "0", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "14"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "p"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "p"}], ")"}], " ", 
       SuperscriptBox["p", "14"]}], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"]}], " ", 
       SuperscriptBox["p", "13"]}]},
     {
      SuperscriptBox["p", "15"], "0", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}], " ", 
       SuperscriptBox["p", "14"]}], 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "p"}], ")"}], " ", 
       SuperscriptBox["p", "14"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "p"}], ")"}], " ", 
       SuperscriptBox["p", "13"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "p"}]}], ")"}]}]},
     {"0", 
      SuperscriptBox["p", "15"], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}], " ", 
       SuperscriptBox["p", "14"]}], "0", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}], " ", 
       SuperscriptBox["p", "13"]}]},
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "15"]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "15"]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "14"]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "14"]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "13"]}]},
     {"0", "0", "0", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "14"]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "13"]}]},
     {"0", "0", "0", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}], " ", 
       SuperscriptBox["p", "14"]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "13"]}]},
     {"0", "0", "0", "0", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}], " ", 
       SuperscriptBox["p", "13"]}]},
     {"0", "0", "0", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}], " ", 
       SuperscriptBox["p", "14"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}], " ", 
       SuperscriptBox["p", "13"]}]},
     {"0", "0", "0", 
      SuperscriptBox["p", "14"], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "p"}], ")"}], " ", 
       SuperscriptBox["p", "13"]}]},
     {"0", "0", "0", "0", 
      SuperscriptBox["p", "13"]},
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{{3.734859834144434*^9, 3.734859842396255*^9}, 
   3.7348598988658123`*^9, {3.73485998408537*^9, 3.7348600034768744`*^9}, {
   3.734865297329453*^9, 3.734865323439487*^9}, 3.736714823734893*^9, 
   3.73671524207285*^9},ExpressionUUID->"c6a6fd5f-abf4-40c1-acda-\
696d812f0a63"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["p", "13"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["p", "2"]}], ")"}], "3"]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "13"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "p"}]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "13"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "p"}]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox["p", "13"], "-", 
       SuperscriptBox["p", "15"]}]},
     {
      RowBox[{
       SuperscriptBox["p", "13"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["p", "3"]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox["p", "13"], "-", 
       SuperscriptBox["p", "15"]}]},
     {
      RowBox[{
       SuperscriptBox["p", "13"], "-", 
       SuperscriptBox["p", "15"]}]},
     {
      SuperscriptBox["p", "13"]},
     {
      SuperscriptBox["p", "13"]},
     {
      RowBox[{
       SuperscriptBox["p", "13"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["p", "2"]}], ")"}], "2"]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "13"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p"}], ")"}]}]},
     {
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}]}], " ", 
       SuperscriptBox["p", "13"]}]},
     {
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}]}], " ", 
       SuperscriptBox["p", "13"]}]},
     {
      RowBox[{
       SuperscriptBox["p", "13"], "-", 
       SuperscriptBox["p", "15"]}]},
     {
      SuperscriptBox["p", "13"]},
     {
      SuperscriptBox["p", "13"]},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{{3.734859834144434*^9, 3.734859842396255*^9}, 
   3.7348598988658123`*^9, {3.73485998408537*^9, 3.7348600034768744`*^9}, {
   3.734865297329453*^9, 3.734865323439487*^9}, 3.736714823734893*^9, 
   3.736715242077796*^9},ExpressionUUID->"3a579c9b-d367-4913-be70-\
b64fdaaaa9c1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SuperscriptBox["p", "26"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["p", "2"]}], ")"}], "6"]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
       SuperscriptBox["p", "26"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"2", " ", "p"}]}], ")"}], "2"]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
       SuperscriptBox["p", "26"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"2", " ", "p"}]}], ")"}], "2"]}]},
     {
      RowBox[{
       SuperscriptBox["p", "26"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["p", "2"]}], ")"}], "2"]}]},
     {
      RowBox[{
       SuperscriptBox["p", "26"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["p", "2"]}], "+", 
          SuperscriptBox["p", "3"]}], ")"}], "2"]}]},
     {
      RowBox[{
       SuperscriptBox["p", "26"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["p", "2"]}], ")"}], "2"]}]},
     {
      RowBox[{
       SuperscriptBox["p", "26"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["p", "2"]}], ")"}], "2"]}]},
     {
      SuperscriptBox["p", "26"]},
     {
      SuperscriptBox["p", "26"]},
     {
      RowBox[{
       SuperscriptBox["p", "26"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["p", "2"]}], ")"}], "4"]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
       SuperscriptBox["p", "26"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "26"]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "26"]}]},
     {
      RowBox[{
       SuperscriptBox["p", "26"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["p", "2"]}], ")"}], "2"]}]},
     {
      SuperscriptBox["p", "26"]},
     {
      SuperscriptBox["p", "26"]},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{{3.734859834144434*^9, 3.734859842396255*^9}, 
   3.7348598988658123`*^9, {3.73485998408537*^9, 3.7348600034768744`*^9}, {
   3.734865297329453*^9, 3.734865323439487*^9}, 3.736714823734893*^9, 
   3.7367152420803013`*^9},ExpressionUUID->"06ee8b90-0882-4cac-a3de-\
88cbf867cffb"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"-", "p"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["p", "2"]}], ")"}], "3"]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "p"}]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "p"}]}], ")"}]}]},
     {
      RowBox[{"p", "-", 
       SuperscriptBox["p", "3"]}]},
     {
      RowBox[{"p", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["p", "3"]}], "+", 
       SuperscriptBox["p", "4"]}]},
     {
      RowBox[{"p", "-", 
       SuperscriptBox["p", "3"]}]},
     {
      RowBox[{"p", "-", 
       SuperscriptBox["p", "3"]}]},
     {"p"},
     {"p"},
     {
      RowBox[{"p", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["p", "2"]}], ")"}], "2"]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p"}], ")"}]}]},
     {
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}]}], " ", "p"}]},
     {
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}]}], " ", "p"}]},
     {
      RowBox[{"p", "-", 
       SuperscriptBox["p", "3"]}]},
     {"p"},
     {"p"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{{3.734859834144434*^9, 3.734859842396255*^9}, 
   3.7348598988658123`*^9, {3.73485998408537*^9, 3.7348600034768744`*^9}, {
   3.734865297329453*^9, 3.734865323439487*^9}, 3.736714823734893*^9, 
   3.736715242082755*^9},ExpressionUUID->"08e96283-3564-4106-afc4-\
6c898f57aed5"]
}, Open  ]]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{
  3.7348653502432404`*^9},ExpressionUUID->"c9b4c26d-4c91-465c-b792-\
2bdb2dd191d6"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "This", " ", "variable", " ", "stores", " ", "the", " ", "absolute", " ", 
    "value", " ", "of", " ", "the", " ", "Fourier", " ", "transform", " ", 
    "on", " ", "the", " ", "D12", " ", "orbit"}], ",", " ", 
   RowBox[{
   "for", " ", "the", " ", "purpose", " ", "of", " ", "taking", " ", "the", 
    " ", "L1", " ", "norm"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.741348230746004*^9, 
  3.7413482552205477`*^9}},ExpressionUUID->"e5fa6e96-47a5-44e0-85d3-\
8f0bedab843d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ABSD12Sums", " ", "=", " ", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         RowBox[{
          SuperscriptBox["p", "13"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["p", "2"]}], ")"}], "3"]}]},
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
          SuperscriptBox["p", "13"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", "p"}]}], ")"}]}]},
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
          SuperscriptBox["p", "13"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", "p"}]}], ")"}]}]},
        {
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["p", "13"]}], "+", 
          SuperscriptBox["p", "15"]}]},
        {
         RowBox[{
          SuperscriptBox["p", "13"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            SuperscriptBox["p", "3"]}], ")"}]}]},
        {
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["p", "13"]}], "+", 
          SuperscriptBox["p", "15"]}]},
        {
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["p", "13"]}], "+", 
          SuperscriptBox["p", "15"]}]},
        {
         SuperscriptBox["p", "13"]},
        {
         SuperscriptBox["p", "13"]},
        {
         RowBox[{
          SuperscriptBox["p", "13"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SuperscriptBox["p", "2"]}], ")"}], "2"]}]},
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
          SuperscriptBox["p", "13"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "p"}], ")"}]}]},
        {
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "p"}], ")"}], " ", 
          SuperscriptBox["p", "13"]}]},
        {
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "p"}], ")"}], " ", 
          SuperscriptBox["p", "13"]}]},
        {
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["p", "13"]}], "+", 
          SuperscriptBox["p", "15"]}]},
        {
         SuperscriptBox["p", "13"]},
        {
         SuperscriptBox["p", "13"]},
        {"0"},
        {"0"},
        {"0"},
        {"0"},
        {"0"},
        {"0"},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "vector", " ", "stores", " ", "the", " ", "indicator", " ", 
    "function", " ", "of", " ", "the", " ", "support"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SuppD12Sums", " ", "=", " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1"},
       {"1"},
       {"1"},
       {"1"},
       {"1"},
       {"1"},
       {"1"},
       {"1"},
       {"1"},
       {"1"},
       {"1"},
       {"1"},
       {"1"},
       {"1"},
       {"1"},
       {"1"},
       {"0"},
       {"0"},
       {"0"},
       {"0"},
       {"0"},
       {"0"},
       {"0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7367729200178127`*^9, 3.7367729770328693`*^9}, {
  3.736775728337124*^9, 3.736775795487012*^9}, {3.7413482613738728`*^9, 
  3.7413482792607327`*^9}},ExpressionUUID->"57aead23-3bda-4914-9b3a-\
8e09396d7fbb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "This", " ", "variable", " ", "stores", " ", "the", " ", "exponential", 
     " ", "sums", " ", "marked", " ", "script"}], "-", 
    RowBox[{
    "M", " ", "with", " ", "frequences", " ", "xi", " ", "from", " ", "orbit",
      " ", "OD11"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"D11orbit", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
          RowBox[{
           RowBox[{"p", "^", 
            RowBox[{"(", "13", ")"}]}], "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "-", "1"}], ")"}], "^", "2"}]}], "*", 
          RowBox[{
           RowBox[{"p", "^", 
            RowBox[{"(", "13", ")"}]}], "/", "2"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
          RowBox[{
           RowBox[{"p", "^", 
            RowBox[{"(", "13", ")"}]}], "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "-", "1"}], ")"}], "^", "2"}]}], "*", 
          RowBox[{
           RowBox[{"p", "^", 
            RowBox[{"(", "13", ")"}]}], "/", "2"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "*", 
          RowBox[{
           RowBox[{"p", "^", 
            RowBox[{"(", "13", ")"}]}], "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}], "*", 
          RowBox[{
           RowBox[{"p", "^", 
            RowBox[{"(", "13", ")"}]}], "/", "2"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "*", 
          RowBox[{
           RowBox[{"p", "^", 
            RowBox[{"(", "13", ")"}]}], "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"p", "^", 
            RowBox[{"(", "13", ")"}]}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}], "*", 
          RowBox[{
           RowBox[{"p", "^", 
            RowBox[{"(", "13", ")"}]}], "/", "2"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
          RowBox[{
           RowBox[{"p", "^", 
            RowBox[{"(", "13", ")"}]}], "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "-", "1"}], ")"}], "^", "2"}]}], "*", 
          RowBox[{
           RowBox[{"p", "^", 
            RowBox[{"(", "13", ")"}]}], "/", "2"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "-", "1"}], ")"}], "^", "3"}]}], "*", 
          RowBox[{
           RowBox[{"p", "^", 
            RowBox[{"(", "13", ")"}]}], "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], "*", 
          RowBox[{
           RowBox[{"p", "^", 
            RowBox[{"(", "13", ")"}]}], "/", "2"}]}]}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", "1", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "variable", " ", "stores", " ", "the", " ", "Fourier", " ", 
     "transform", " ", "by", " ", "taking", " ", "the", " ", "sum", " ", 
     "above"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"D11orbitSum", " ", "=", " ", 
     RowBox[{"D11orbit", ".", "w"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "This", " ", "variable", " ", "stores", " ", "the", " ", "square", " ", 
      "of", " ", "the", " ", "entries"}], ",", " ", 
     RowBox[{"for", " ", "taking", " ", "the", " ", "L2", " ", "norm"}]}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"D11orbitSum2", " ", "=", " ", 
     RowBox[{"D11orbitSum", "*", "D11orbitSum"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"Simplify", "[", "D11orbitSum", "]"}], "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"Simplify", "[", "D11orbitSum2", "]"}], "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{
       RowBox[{"Simplify", "[", "D11orbitSum", "]"}], "/", 
       RowBox[{"p", "^", 
        RowBox[{"(", "12", ")"}]}]}], "]"}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.73486069882876*^9, 3.734860843533615*^9}, {
   3.7348609579886723`*^9, 3.7348610779328814`*^9}, 3.734861335571032*^9, {
   3.734861682576664*^9, 3.734861703159182*^9}, {3.734865843785245*^9, 
   3.734865854169107*^9}, {3.736700099738777*^9, 3.736700100162652*^9}, {
   3.736714841281783*^9, 3.7367148670029287`*^9}, {3.736715261214829*^9, 
   3.736715289702511*^9}, {3.741348404396674*^9, 
   3.7413484877235107`*^9}},ExpressionUUID->"181a5985-0a23-4cea-8a42-\
875e31ed8149"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "p"}], ")"}], " ", 
       SuperscriptBox["p", "14"]}]},
     {
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}]}], " ", 
       SuperscriptBox["p", "14"]}]},
     {"0"},
     {
      RowBox[{"-", 
       SuperscriptBox["p", "14"]}]},
     {
      SuperscriptBox["p", "14"]},
     {"0"},
     {"0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.734861703471588*^9, 3.7348658547342157`*^9, 
  3.7367002199189463`*^9, 3.7367003065205193`*^9, 3.736714884403365*^9, 
  3.736715290288266*^9},ExpressionUUID->"153e401d-02a3-4c4e-814f-\
01d73a0d52e6"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "28"]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "28"]}]},
     {"0"},
     {
      SuperscriptBox["p", "28"]},
     {
      SuperscriptBox["p", "28"]},
     {"0"},
     {"0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.734861703471588*^9, 3.7348658547342157`*^9, 
  3.7367002199189463`*^9, 3.7367003065205193`*^9, 3.736714884403365*^9, 
  3.736715290290416*^9},ExpressionUUID->"1c85ae4e-bca5-4d5e-94c2-\
24c058013dd0"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "p"}], ")"}], " ", 
       SuperscriptBox["p", "2"]}]},
     {
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}]}], " ", 
       SuperscriptBox["p", "2"]}]},
     {"0"},
     {
      RowBox[{"-", 
       SuperscriptBox["p", "2"]}]},
     {
      SuperscriptBox["p", "2"]},
     {"0"},
     {"0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.734861703471588*^9, 3.7348658547342157`*^9, 
  3.7367002199189463`*^9, 3.7367003065205193`*^9, 3.736714884403365*^9, 
  3.736715290292485*^9},ExpressionUUID->"5fe6e31a-7898-416b-b140-\
b0340fdcb600"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "This", " ", "variable", " ", "stores", " ", "the", " ", "absolute", " ", 
     "value", " ", "of", " ", "the", " ", "Fourier", " ", "transform"}], ",", 
    " ", 
    RowBox[{
    "for", " ", "the", " ", "purpose", " ", "of", " ", "taking", " ", "the", 
     " ", "L1", " ", "norm"}]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.741348501527225*^9, 
  3.741348520610835*^9}},ExpressionUUID->"42f09f6c-592e-4dfc-a48d-\
cbe35bc50399"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ABSD11Sums", " ", "=", " ", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"0"},
        {"0"},
        {"0"},
        {"0"},
        {"0"},
        {"0"},
        {"0"},
        {"0"},
        {"0"},
        {"0"},
        {"0"},
        {"0"},
        {"0"},
        {
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "p"}], ")"}], " ", 
          SuperscriptBox["p", "14"]}]},
        {
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "p"}], ")"}], " ", 
          SuperscriptBox["p", "14"]}]},
        {"0"},
        {
         SuperscriptBox["p", "14"]},
        {
         SuperscriptBox["p", "14"]},
        {"0"},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "variable", " ", "stores", " ", "an", " ", "indicator", " ", 
    "function", " ", "of", " ", "the", " ", "support", " ", "of", " ", "the", 
    " ", "Fourier", " ", "transform"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SuppD11Sums", " ", "=", " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0"},
       {"0"},
       {"0"},
       {"0"},
       {"0"},
       {"0"},
       {"0"},
       {"0"},
       {"0"},
       {"0"},
       {"0"},
       {"0"},
       {"0"},
       {"1"},
       {"1"},
       {"0"},
       {"1"},
       {"1"},
       {"0"},
       {"0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";"}]}], "Input",
 CellChangeTimes->{{3.736773136284829*^9, 3.73677315192789*^9}, {
  3.736775808831277*^9, 3.736775835033643*^9}, {3.7413485310193853`*^9, 
  3.741348548682811*^9}},ExpressionUUID->"22095fc0-f023-47eb-a923-\
f1467ebe6a72"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7348613235836477`*^9, 3.734861331569497*^9}, 
   3.734861680607544*^9},ExpressionUUID->"6660df3f-b9bf-4945-8bd9-\
4c4453bad9e0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "This", " ", "variable", " ", "stores", " ", "the", " ", "exponential", 
     " ", "sums", " ", "marked", " ", "script"}], "-", 
    RowBox[{
    "M", " ", "with", " ", "frequences", " ", "xi", " ", "from", " ", "orbit",
      " ", "OD2"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"D2orbit", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
          RowBox[{
           RowBox[{"p", "^", 
            RowBox[{"(", "13", ")"}]}], "/", "2"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"p", "^", 
            RowBox[{"(", "13", ")"}]}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "*", 
          RowBox[{
           RowBox[{"p", "^", 
            RowBox[{"(", "13", ")"}]}], "/", "2"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "-", "1"}], ")"}], "^", "2"}]}], "*", 
          RowBox[{
           RowBox[{"p", "^", 
            RowBox[{"(", "13", ")"}]}], "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}], "*", 
          RowBox[{
           RowBox[{"p", "^", 
            RowBox[{"(", "13", ")"}]}], "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "-", "1"}], ")"}], "^", "2"}]}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
          RowBox[{"p", "^", 
           RowBox[{"(", "13", ")"}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}]}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"u", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", "1", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "variable", " ", "stores", " ", "the", " ", "Fourier", " ", 
     "transform", " ", "above", " ", "the", " ", "orbit", " ", "OD2"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"D2orbitSum", " ", "=", " ", 
     RowBox[{"D2orbit", ".", "u"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "variable", " ", "stores", " ", "the", " ", "square", " ", 
     "of", " ", "the", " ", "Fourier", " ", "transform", " ", "for", " ", 
     "the", " ", "purpose", " ", "of", " ", "calculating", " ", "the", " ", 
     "L2", " ", "norm"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"D2orbitSum2", " ", "=", " ", 
     RowBox[{"D2orbitSum", "*", "D2orbitSum"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"Simplify", "[", "D2orbitSum", "]"}], "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"Simplify", "[", "D2orbitSum2", "]"}], "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{
       RowBox[{"Simplify", "[", "D2orbitSum", "]"}], "/", 
       RowBox[{"p", "^", 
        RowBox[{"(", "12", ")"}]}]}], "]"}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7348621259134197`*^9, 3.734862267620047*^9}, {
  3.734862370803445*^9, 3.734862488251346*^9}, {3.734862539564135*^9, 
  3.734862560129751*^9}, {3.734865870521048*^9, 3.734865876480949*^9}, {
  3.7367149057132998`*^9, 3.736714929992741*^9}, {3.7367153026225986`*^9, 
  3.736715329006225*^9}, {3.736763026798234*^9, 3.73676303088402*^9}, {
  3.7413485704673*^9, 3.7413485855148783`*^9}, {3.741348618450328*^9, 
  3.74134871458574*^9}},ExpressionUUID->"3bad400d-483f-41a2-8db7-\
c157308987bf"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "p"}], ")"}], " ", 
       SuperscriptBox["p", "14"]}]},
     {
      RowBox[{"-", 
       SuperscriptBox["p", "14"]}]},
     {
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}]}], " ", 
       SuperscriptBox["p", "14"]}]},
     {
      SuperscriptBox["p", "14"]},
     {"0"},
     {"0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.734862560573099*^9, 3.734865877055848*^9, 
  3.736700897109127*^9, 3.736714930814748*^9, 3.7367153295732737`*^9, 
  3.736763032144641*^9},ExpressionUUID->"00b45092-19b5-496a-9803-\
48300d8323c7"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "28"]}]},
     {
      SuperscriptBox["p", "28"]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "28"]}]},
     {
      SuperscriptBox["p", "28"]},
     {"0"},
     {"0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.734862560573099*^9, 3.734865877055848*^9, 
  3.736700897109127*^9, 3.736714930814748*^9, 3.7367153295732737`*^9, 
  3.736763032146761*^9},ExpressionUUID->"8f75e68e-686a-40b3-ae3a-\
8e002376ea7d"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {"0"},
     {
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "p"}], ")"}], " ", 
       SuperscriptBox["p", "2"]}]},
     {
      RowBox[{"-", 
       SuperscriptBox["p", "2"]}]},
     {
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}]}], " ", 
       SuperscriptBox["p", "2"]}]},
     {
      SuperscriptBox["p", "2"]},
     {"0"},
     {"0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.734862560573099*^9, 3.734865877055848*^9, 
  3.736700897109127*^9, 3.736714930814748*^9, 3.7367153295732737`*^9, 
  3.7367630321485777`*^9},ExpressionUUID->"51aa9329-6359-434e-ac47-\
a045967d823b"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "variable", " ", "stores", " ", "the", " ", "absolute", " ", 
    "value", " ", "of", " ", "the", " ", "FT", " ", "for", " ", "the", " ", 
    "purpose", " ", "of", " ", "taking", " ", "the", " ", "L1", " ", "norm"}],
    " ", "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"ABSD2Sums", " ", "=", " ", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0"},
         {"0"},
         {"0"},
         {"0"},
         {"0"},
         {
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], " ", 
           SuperscriptBox["p", "14"]}]},
         {
          SuperscriptBox["p", "14"]},
         {
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], " ", 
           SuperscriptBox["p", "14"]}]},
         {
          SuperscriptBox["p", "14"]},
         {"0"},
         {"0"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "variable", " ", "stores", " ", "an", " ", "indicator", " ", 
     "function", " ", "for", " ", "the", " ", "support", " ", "of", " ", 
     "the", " ", "FT"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SuppD2Sums", " ", "=", " ", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0"},
         {"0"},
         {"0"},
         {"0"},
         {"0"},
         {"1"},
         {"1"},
         {"1"},
         {"1"},
         {"0"},
         {"0"}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ";"}], "\[IndentingNewLine]"}]}]], "Input",\

 CellChangeTimes->{{3.736773174310515*^9, 3.7367731928957653`*^9}, {
  3.7367758469846897`*^9, 3.736775884585216*^9}, {3.741348725210281*^9, 
  3.741348762889176*^9}},ExpressionUUID->"3e09d136-0fb5-46c0-97f4-\
4b31b70cbb05"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "variable", " ", "calculates", " ", "the", " ", "L2", " ", 
    "norm", " ", "squared", " ", "of", " ", "the", " ", "indicator", " ", 
    "function", " ", "of", " ", "the", " ", "maximal", " ", "set", " ", "in", 
    " ", "time", " ", 
    RowBox[{"domain", " ", "--"}], " ", "this", " ", "is", " ", "just", " ", 
    "the", " ", "count", " ", "of", " ", "maximal", " ", "elements"}], " ", 
   "*)"}], 
  RowBox[{"L2plancherel", " ", "=", " ", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"p", "^", 
      RowBox[{"(", "36", ")"}]}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "/", "p"}], " ", "*", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], " ", "*", " ", 
        RowBox[{"p", "^", "2"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"p", "^", "2"}], "+", "p", "+", "1"}], ")"}]}], " ", "+", 
       " ", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "/", "p"}], " ", "*", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], " ", "*", " ", 
        RowBox[{"p", "^", "3"}], " ", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"p", "^", "2"}], " ", "+", " ", "p", "+", "1"}], ")"}]}], 
       "+", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "/", 
         RowBox[{"p", "^", "2"}]}], " ", "*", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], " ", "*", " ", 
        RowBox[{"p", "^", "4"}], " ", "*", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "^", "2"}], " ", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", "^", "2"}], " ", "+", " ", "p", "+", "1"}], ")"}], 
         "/", "2"}]}], " ", "+", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", "^", "2"}], "-", "1"}], ")"}], "/", 
         RowBox[{"p", "^", "2"}]}], " ", "*", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], " ", "*", 
        RowBox[{"p", "^", "4"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", "^", "2"}], "+", "p", "+", "1"}], ")"}], "/", "2"}]}],
        " ", "+", " ", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "/", "p"}], " ", "*", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], " ", "*", " ", 
        RowBox[{"p", "^", "4"}], " ", "*", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "^", "2"}], " ", "*", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", "^", "2"}], " ", "+", " ", "p", "+", "1"}], ")"}], 
         "/", "2"}]}], "+", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "/", "p"}], " ", "*", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], " ", "*", " ", 
        RowBox[{"p", "^", "4"}], " ", "*", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "^", "2"}], " ", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", "^", "2"}], " ", "+", " ", "p", " ", "+", " ", "1"}], 
          ")"}], "/", "2"}]}], " ", "+", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "4"}], " ", "*", " ", 
        RowBox[{"p", "^", "4"}], " ", "*", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "^", "2"}], " ", "*", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"p", "^", "2"}], "+", "p", "+", "1"}], ")"}]}]}], ")"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.736708611127714*^9, 3.7367088446510973`*^9}, {
   3.736708918034441*^9, 3.736709114810502*^9}, {3.736709151723027*^9, 
   3.736709154554433*^9}, 3.736709883614223*^9, 3.7367100275101547`*^9, {
   3.736710213963222*^9, 3.736710214234968*^9}, {3.7367637339128942`*^9, 
   3.736763753679286*^9}, {3.736770444522276*^9, 3.736770444792705*^9}, {
   3.741348770697885*^9, 
   3.741348812545595*^9}},ExpressionUUID->"af4d4f4c-6d12-4bba-a5cf-\
0b33c7c0c340"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["p", "37"], "+", 
  SuperscriptBox["p", "38"], "-", 
  RowBox[{"3", " ", 
   SuperscriptBox["p", "39"]}], "-", 
  RowBox[{"3", " ", 
   SuperscriptBox["p", "40"]}], "+", 
  SuperscriptBox["p", "41"], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["p", "42"]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["p", "43"]}], "-", 
  RowBox[{"2", " ", 
   SuperscriptBox["p", "44"]}], "-", 
  RowBox[{"2", " ", 
   SuperscriptBox["p", "45"]}], "-", 
  SuperscriptBox["p", "46"], "+", 
  SuperscriptBox["p", "48"]}]], "Output",
 CellChangeTimes->{{3.736709102680966*^9, 3.736709115381422*^9}, 
   3.736709155554945*^9, 3.7367098850103397`*^9, 3.736710028543355*^9, 
   3.736710215541041*^9, {3.7367637360419617`*^9, 3.736763754339924*^9}, 
   3.736770445609516*^9},ExpressionUUID->"ac1a9665-e504-443b-8e3b-\
2cf6c2b3ab52"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "This", " ", "variable", " ", "stores", " ", "the", " ", "sizes", " ", 
      "of", " ", "the", " ", "20", " ", "mod"}], "-", 
     RowBox[{"p", " ", "orbits"}]}], ",", " ", 
    RowBox[{
    "in", " ", "the", " ", "order", " ", "listed", " ", "in", " ", "the", " ",
      "paper"}]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.7413488161012278`*^9, 
  3.7413488682563143`*^9}},ExpressionUUID->"a39ffe3a-93e0-4fac-9f2b-\
8a53832c3f87"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"modPorbitsizes", " ", "=", " ", "\[IndentingNewLine]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "1", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"p", "-", "1"}], ")"}], "*", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"p", "^", "2"}], " ", "+", " ", "p", " ", "+", " ", "1"}], 
       ")"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"p", "-", "1"}], ")"}], "*", "p", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}], "^", "2"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", "^", "2"}], " ", "+", " ", "p", " ", "+", " ", "1"}], 
        ")"}], "/", "2"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", "p", "*", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", "^", "2"}], "+", "p", "+", "1"}], ")"}], "/", "2"}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
      RowBox[{"p", "^", "2"}], "*", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"p", "^", "2"}], "+", "p", "+", "1"}], ")"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", "p", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}], "^", "2"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"p", "^", "2"}], "+", "p", "+", "1"}], ")"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
      RowBox[{"p", "^", "3"}], "*", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"p", "^", "2"}], "+", "p", "+", "1"}], ")"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
      RowBox[{"p", "^", "2"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}], "^", "2"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", "^", "2"}], "+", "p", "+", "1"}], ")"}], "/", "2"}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], "*", 
      RowBox[{"p", "^", "2"}], "*", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", "^", "2"}], "+", "p", "+", "1"}], ")"}], "/", "2"}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], "*", 
      RowBox[{"p", "^", "2"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}], "^", "2"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"p", "^", "2"}], "+", "p", "+", "1"}], ")"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], "*", 
      RowBox[{"p", "^", "3"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}], "^", "2"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"p", "^", "2"}], "+", "p", "+", "1"}], ")"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
      RowBox[{"p", "^", "4"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}], "^", "2"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", "^", "2"}], "+", "p", "+", "1"}], ")"}], "/", "2"}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], "*", 
      RowBox[{"p", "^", "4"}], "*", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", "^", "2"}], "+", "p", "+", "1"}], ")"}], "/", "2"}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], "*", 
      RowBox[{"p", "^", "4"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}], "^", "2"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", "^", "2"}], "+", "p", "+", "1"}], ")"}], "/", "2"}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], "*", 
      RowBox[{"p", "^", "4"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}], "^", "2"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", "^", "2"}], "+", "p", "+", "1"}], ")"}], "/", "2"}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "^", "4"}], "*", 
      RowBox[{"p", "^", "4"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}], "^", "2"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", "^", "2"}], "+", "p", "+", "1"}], ")"}], "/", "24"}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "^", "4"}], "*", 
      RowBox[{"p", "^", "4"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}], "^", "2"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", "^", "2"}], "+", "p", "+", "1"}], ")"}], "/", "4"}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "^", "4"}], "*", 
      RowBox[{"p", "^", "4"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}], "^", "2"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", "^", "2"}], "+", "p", "+", "1"}], ")"}], "/", "8"}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "^", "4"}], "*", 
      RowBox[{"p", "^", "4"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}], "^", "2"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", "^", "2"}], "+", "p", "+", "1"}], ")"}], "/", "3"}]}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "^", "4"}], "*", 
      RowBox[{"p", "^", "4"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}], "^", "2"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", "^", "2"}], "+", "p", "+", "1"}], ")"}], "/", "4"}]}], 
     "}"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.736710521073048*^9, 3.736710585673252*^9}, {
  3.736710621070509*^9, 3.736711143161474*^9}, {3.736711227257514*^9, 
  3.7367114018805723`*^9}},ExpressionUUID->"eae3167b-6283-442e-9d09-\
59a36409f0a9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "p"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p", "+", 
       SuperscriptBox["p", "2"]}], ")"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "p"}], ")"}], " ", "p", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p", "+", 
       SuperscriptBox["p", "2"]}], ")"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p", "+", 
       SuperscriptBox["p", "2"]}], ")"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
     SuperscriptBox["p", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p", "+", 
       SuperscriptBox["p", "2"]}], ")"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p", "+", 
       SuperscriptBox["p", "2"]}], ")"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
     SuperscriptBox["p", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p", "+", 
       SuperscriptBox["p", "2"]}], ")"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
     SuperscriptBox["p", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p", "+", 
       SuperscriptBox["p", "2"]}], ")"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
     SuperscriptBox["p", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p", "+", 
       SuperscriptBox["p", "2"]}], ")"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
     SuperscriptBox["p", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p", "+", 
       SuperscriptBox["p", "2"]}], ")"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
     SuperscriptBox["p", "3"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p", "+", 
       SuperscriptBox["p", "2"]}], ")"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
     SuperscriptBox["p", "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p", "+", 
       SuperscriptBox["p", "2"]}], ")"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
     SuperscriptBox["p", "4"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p", "+", 
       SuperscriptBox["p", "2"]}], ")"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
     SuperscriptBox["p", "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p", "+", 
       SuperscriptBox["p", "2"]}], ")"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
     SuperscriptBox["p", "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p", "+", 
       SuperscriptBox["p", "2"]}], ")"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "24"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
     SuperscriptBox["p", "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p", "+", 
       SuperscriptBox["p", "2"]}], ")"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
     SuperscriptBox["p", "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p", "+", 
       SuperscriptBox["p", "2"]}], ")"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "8"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
     SuperscriptBox["p", "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p", "+", 
       SuperscriptBox["p", "2"]}], ")"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
     SuperscriptBox["p", "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p", "+", 
       SuperscriptBox["p", "2"]}], ")"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
     SuperscriptBox["p", "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "p", "+", 
       SuperscriptBox["p", "2"]}], ")"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.736711144417035*^9, 
  3.736711406791726*^9},ExpressionUUID->"5cc2f35a-e0f6-41bc-bd6a-\
4d4f774e580d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Next", " ", "the", " ", "orbit", " ", "sizes", " ", "of", " ", "the", 
     " ", "relevant", " ", "mod", " ", 
     RowBox[{"p", "^", "2"}], " ", "orbits", " ", "are", " ", "calculated", 
     " ", "using", " ", "the", " ", 
     RowBox[{"formula", ":", " ", 
      RowBox[{"mod", " ", 
       RowBox[{"p", "^", "2"}], " ", "orbit", " ", "size"}]}]}], " ", "=", 
    " ", 
    RowBox[{
     RowBox[{"p", "^", 
      RowBox[{"(", 
       RowBox[{"dim", " ", "V_x"}], ")"}]}], " ", "*", " ", 
     RowBox[{"(", 
      RowBox[{"mod", " ", "p", " ", "orbit", " ", "size"}], ")"}], " ", "*", 
     " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"V", "/", "Vx"}], " ", "orbit", " ", "size"}], ")"}]}]}], 
   "*)"}], " "}]], "Input",
 CellChangeTimes->{{3.741349205429719*^9, 
  3.741349303893664*^9}},ExpressionUUID->"e885de1f-47bb-4f19-a463-\
4cd3b58beb65"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"OrbitOD12size", " ", "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"p", "-", "1"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{"p", "+", "1"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"p", "^", "2"}], "+", "p", "+", "1"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dimVD12", " ", "=", " ", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"OD12OrbitSizes", " ", "=", "\[IndentingNewLine]", 
   RowBox[{"OrbitOD12size", "*", 
    RowBox[{"p", "^", 
     RowBox[{"(", "dimVD12", ")"}]}], "*", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "*", "p", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{"p", "/", "2"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", "p", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", "p", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], "*", "p", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], "*", "p", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "*", 
        RowBox[{"p", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{"p", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{"p", "^", "3"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{"p", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], "*", 
        RowBox[{"p", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], "*", 
        RowBox[{"p", "^", "3"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "*", 
        RowBox[{"p", "^", "4"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{"p", "^", "4"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], "*", 
        RowBox[{"p", "^", "4"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "/", "4"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], "*", 
        RowBox[{"p", "^", "4"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "/", "4"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{
         RowBox[{"p", "^", "4"}], "/", "2"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], "*", 
        RowBox[{"p", "^", "4"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "/", "4"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], "*", 
        RowBox[{"p", "^", "4"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "/", "4"}]}], "}"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"MatrixForm", "[", "OD12OrbitSizes", "]"}], "]"}], ";"}]}], "Input",\

 CellChangeTimes->{{3.7367117161746798`*^9, 3.7367122076893044`*^9}, {
  3.736712272273456*^9, 3.736712505495983*^9}, {3.736769489047552*^9, 
  3.736769489254877*^9}, {3.7367695576390963`*^9, 3.736769629142643*^9}, {
  3.741353466574046*^9, 
  3.7413535191727867`*^9}},ExpressionUUID->"ab244b07-8d76-4c3a-8d7f-\
168f13d71115"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "p"}], ")"}], " ", 
       SuperscriptBox["p", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "5"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "5"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "5"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "5"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
       SuperscriptBox["p", "5"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
       SuperscriptBox["p", "5"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "6"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "6"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "7"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "6"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
       SuperscriptBox["p", "6"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
       SuperscriptBox["p", "7"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "8"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "8"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
       SuperscriptBox["p", "8"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
       SuperscriptBox["p", "8"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "8"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
       SuperscriptBox["p", "8"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
       SuperscriptBox["p", "8"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.741353487314958*^9, 3.741353519573955*^9}, 
   3.741353602995624*^9},ExpressionUUID->"d1202487-4a22-4c66-86b8-\
e53f22a95498"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"OrbitOD11size", " ", "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", "2"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{"p", "-", "1"}], ")"}], "*", "p", "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}], "^", "2"}], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"p", "^", "2"}], "+", "p", "+", "1"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dimVD11", " ", "=", " ", "6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"OD11OrbitSizes", " ", "=", " ", "\[IndentingNewLine]", 
   RowBox[{"OrbitOD11size", "*", 
    RowBox[{"p", "^", "dimVD11"}], "*", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "*", 
        RowBox[{"p", "^", "3"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{"p", "^", "3"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], "*", 
        RowBox[{
         RowBox[{"p", "^", "3"}], "/", "4"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{"p", "^", "3"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], "*", 
        RowBox[{
         RowBox[{"p", "^", "3"}], "/", "2"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], "*", 
        RowBox[{
         RowBox[{"p", "^", "3"}], "/", "4"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"2", "*", 
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "*", "p"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{"p", "^", "2"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"2", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", "p"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"2", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", "p"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], "*", 
        RowBox[{"p", "^", "2"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"2", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], "*", "p"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"2", "*", 
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "/", "2"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "/", "2"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"2", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "2"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], "/", "2"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "3"}], "/", "2"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"p", "-", "1"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", "1", "}"}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"MatrixForm", "[", "OD11OrbitSizes", "]"}], "]"}], ";"}]}], "Input",\

 CellChangeTimes->{{3.73671252856733*^9, 3.736712821380375*^9}, {
  3.736712868860264*^9, 3.7367129756113377`*^9}, {3.736713009371196*^9, 
  3.736713107802758*^9}, {3.736769673005225*^9, 3.73676977823663*^9}, {
  3.736771536633841*^9, 3.736771537104763*^9}, {3.74135407102577*^9, 
  3.7413540843207417`*^9}},ExpressionUUID->"758ef7ec-6c3e-424e-a53a-\
0efce2bfe34e"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "10"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "10"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "8"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
       SuperscriptBox["p", "10"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "10"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
       SuperscriptBox["p", "10"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "8"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
       SuperscriptBox["p", "10"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "8"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "9"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "8"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "8"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
       SuperscriptBox["p", "9"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
       SuperscriptBox["p", "8"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "7"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "7"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "7"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "7"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
       SuperscriptBox["p", "7"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
       SuperscriptBox["p", "7"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "7"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "p"}], ")"}], " ", 
       SuperscriptBox["p", "7"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{
  3.741354084640588*^9},ExpressionUUID->"c5ca5f06-f828-4fcf-9221-\
e21e326b693a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"OrbitOD2", " ", "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", "2"}], ")"}], "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", "p", "*", 
    RowBox[{"(", 
     RowBox[{"p", "+", "1"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"p", "^", "2"}], "+", "p", "+", "1"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dimVD2", " ", "=", " ", "6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"OD2OrbitSizes", " ", "=", "\[IndentingNewLine]", 
   RowBox[{"OrbitOD2", " ", "*", " ", 
    RowBox[{"p", "^", "dimVD2"}], "*", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "*", 
        RowBox[{"p", "^", "3"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{"p", "^", "3"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{"p", "^", "3"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "*", 
        RowBox[{"p", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{"p", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "}"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "/", "2"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"p", "-", "1"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", "1", "}"}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"MatrixForm", "[", "OD2OrbitSizes", "]"}], "]"}], ";"}]}], "Input",\

 CellChangeTimes->{{3.736713297859147*^9, 3.736713546407289*^9}, {
  3.736769835579514*^9, 3.736769882299284*^9}, {3.741354803940632*^9, 
  3.741354823219949*^9}},ExpressionUUID->"c39d3e9f-1fa2-43f1-aa01-\
fd97a03b2cca"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "10"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
       SuperscriptBox["p", "10"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
       SuperscriptBox["p", "10"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "9"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
       SuperscriptBox["p", "9"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "7"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
       SuperscriptBox["p", "7"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "7"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", 
       SuperscriptBox["p", "7"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", 
       SuperscriptBox["p", "7"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", 
       SuperscriptBox["p", "7"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "p", "+", 
         SuperscriptBox["p", "2"]}], ")"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{
  3.741354823768292*^9},ExpressionUUID->"cf2f06bc-ae75-418e-ae00-\
e55b4c3f2492"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "The", " ", "FT", " ", "at", " ", "frequencies", " ", "divisible", " ", 
    "by", " ", "p", " ", "is", " ", "loaded", " ", "from", " ", "the", " ", 
    "mod", " ", "p", " ", 
    RowBox[{"file", ".", "  ", "This"}], " ", "is", " ", "scaled", " ", 
    "down", " ", "by", " ", 
    RowBox[{"p", "^", 
     RowBox[{"(", 
      RowBox[{"-", "12"}], ")"}]}]}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.741349744273033*^9, 3.741349755090598*^9}, {
  3.741349795146317*^9, 3.7413498010582542`*^9}, {3.74134992870539*^9, 
  3.741349936817408*^9}},ExpressionUUID->"92ff2755-2fb1-4724-bdec-\
ceffb992090b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"modpFT", " ", "=", " ", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", "p", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "4"]}], "+", 
            SuperscriptBox["p", "5"]}], ")"}]}]},
        {
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"]}], " ", "p", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "p"}], ")"}], "4"]}]},
        {
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"]}], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "p"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}]}], ")"}]}]},
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}]}], ")"}]}]},
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}]}], ")"}]}]},
        {
         RowBox[{"p", "+", 
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["p", "3"]}], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["p", "4"]}], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox["p", "5"]}], "-", 
          SuperscriptBox["p", "7"]}]},
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}]}], ")"}]}]},
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}]}], ")"}]}]},
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}]}], ")"}]}]},
        {
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "p", "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            SuperscriptBox["p", "3"]}], ")"}]}]},
        {
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "p", "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            SuperscriptBox["p", "3"]}], ")"}]}]},
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "p"}]}], ")"}]}]},
        {
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}]}], " ", "p", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "p"}], ")"}], "2"]}]},
        {
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "p", "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            SuperscriptBox["p", "3"]}], ")"}]}]},
        {
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "p", "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            SuperscriptBox["p", "3"]}], ")"}]}]},
        {
         RowBox[{"p", "+", 
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["p", "3"]}]},
        {
         RowBox[{"p", "+", 
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["p", "3"]}]},
        {
         RowBox[{"p", "+", 
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["p", "3"]}]},
        {
         RowBox[{"p", "+", 
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["p", "3"]}]},
        {
         RowBox[{"p", "+", 
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["p", "3"]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{" ", 
    RowBox[{
     RowBox[{
     "This", " ", "stores", " ", "the", " ", "FT", " ", "at", " ", 
      "frequencies", " ", "divisible", " ", "by", " ", "p", " ", "for", " ", 
      "the", " ", "function", " ", "1", "_max"}], " ", "-", " ", 
     RowBox[{
     "1.", "  ", "The", " ", "only", " ", "difference", " ", "is", " ", "at", 
      " ", "the", " ", "0", " ", 
      RowBox[{"orbit", "."}]}]}], ")"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"nonmaxpFT", " ", "=", " ", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", "p", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"3", " ", "p"}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["p", "2"]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["p", "3"]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["p", "4"]}], "+", 
             SuperscriptBox["p", "5"]}], ")"}]}], "-", 
          RowBox[{"p", "^", 
           RowBox[{"(", "12", ")"}]}]}]},
        {
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"]}], " ", "p", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "p"}], ")"}], "4"]}]},
        {
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"]}], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "p"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}]}], ")"}]}]},
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}]}], ")"}]}]},
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}]}], ")"}]}]},
        {
         RowBox[{"p", "+", 
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["p", "3"]}], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["p", "4"]}], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox["p", "5"]}], "-", 
          SuperscriptBox["p", "7"]}]},
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}]}], ")"}]}]},
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}]}], ")"}]}]},
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}]}], ")"}]}]},
        {
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "p", "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            SuperscriptBox["p", "3"]}], ")"}]}]},
        {
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "p", "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            SuperscriptBox["p", "3"]}], ")"}]}]},
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "p"}]}], ")"}]}]},
        {
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}]}], " ", "p", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "p"}], ")"}], "2"]}]},
        {
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "p", "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            SuperscriptBox["p", "3"]}], ")"}]}]},
        {
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "p", "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            SuperscriptBox["p", "3"]}], ")"}]}]},
        {
         RowBox[{"p", "+", 
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["p", "3"]}]},
        {
         RowBox[{"p", "+", 
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["p", "3"]}]},
        {
         RowBox[{"p", "+", 
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["p", "3"]}]},
        {
         RowBox[{"p", "+", 
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["p", "3"]}]},
        {
         RowBox[{"p", "+", 
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["p", "3"]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "This", " ", "variable", " ", "stores", " ", "the", " ", "squares", " ", 
     "of", " ", "the", " ", "entries", " ", "of", " ", "the", " ", "non"}], 
    "-", 
    RowBox[{"maximal", " ", "FT"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"nonmaxpFT2", " ", "=", " ", 
    RowBox[{"nonmaxpFT", " ", "*", " ", "nonmaxpFT"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "variable", " ", "stores", " ", "the", " ", "squares", " ", 
    "of", " ", "the", " ", "entries", " ", "of", " ", "the", " ", "maximal", 
    " ", "FT"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"modpFT2", " ", "=", " ", 
    RowBox[{"modpFT", "*", "modpFT"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "This", " ", "variable", " ", "stores", " ", "the", " ", "absolute", " ", 
     "value", " ", "of", " ", "the", " ", "entries", " ", "of", " ", "the", 
     " ", "maximal", " ", "FT"}], ",", " ", 
    RowBox[{
    "for", " ", "the", " ", "purpose", " ", "of", " ", "taking", " ", "the", 
     " ", "L1", " ", "norm"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ABSmodpFT", " ", "=", 
    TagBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", "p", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "4"]}], "+", 
            SuperscriptBox["p", "5"]}], ")"}]}]},
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", "p", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "p"}], ")"}], "4"]}]},
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "p"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}]}], ")"}]}]},
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}]}], ")"}]}]},
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}]}], ")"}]}]},
        {
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            SuperscriptBox["p", "2"], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "3"]}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "4"]}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "5"]}], "-", 
            SuperscriptBox["p", "7"]}], ")"}]}]},
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}]}], ")"}]}]},
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}]}], ")"}]}]},
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}]}], ")"}]}]},
        {
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "p", "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            SuperscriptBox["p", "3"]}], ")"}]}]},
        {
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "p", "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            SuperscriptBox["p", "3"]}], ")"}]}]},
        {
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "p"}]}], ")"}]}]},
        {
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "p"}], ")"}], " ", "p", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "p"}], ")"}], "2"]}]},
        {
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "p", "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            SuperscriptBox["p", "3"]}], ")"}]}]},
        {
         RowBox[{"p", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "p", "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            SuperscriptBox["p", "3"]}], ")"}]}]},
        {
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            SuperscriptBox["p", "2"], "-", 
            SuperscriptBox["p", "3"]}], ")"}]}]},
        {
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            SuperscriptBox["p", "2"], "-", 
            SuperscriptBox["p", "3"]}], ")"}]}]},
        {
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            SuperscriptBox["p", "2"], "-", 
            SuperscriptBox["p", "3"]}], ")"}]}]},
        {
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            SuperscriptBox["p", "2"], "-", 
            SuperscriptBox["p", "3"]}], ")"}]}]},
        {
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            SuperscriptBox["p", "2"], "-", 
            SuperscriptBox["p", "3"]}], ")"}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "This", " ", "variable", " ", "stores", " ", "the", " ", "absolute", " ",
       "value", " ", "of", " ", "the", " ", "entries", " ", "of", " ", "the", 
      " ", "non"}], "-", 
     RowBox[{"maximal", " ", "FT"}]}], ",", " ", 
    RowBox[{
    "for", " ", "the", " ", "purpose", " ", "of", " ", "taking", " ", "the", 
     " ", "L1", " ", "norm"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ABSnonmaxpFT", " ", "=", " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"p", "^", 
          RowBox[{"(", "12", ")"}]}], "-", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "p"}], ")"}], "4"], " ", "p", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "p"}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "4"]}], "+", 
            SuperscriptBox["p", "5"]}], ")"}]}]}]},
       {
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", "p", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", "p"}], ")"}], "4"]}]},
       {
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "p"}], ")"}], "3"], " ", "p", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"4", " ", "p"}], "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "3"]}]}], ")"}]}]},
       {
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"3", " ", "p"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}]}], ")"}]}]},
       {
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"3", " ", "p"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}]}], ")"}]}]},
       {
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           SuperscriptBox["p", "2"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["p", "3"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["p", "4"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["p", "5"]}], "-", 
           SuperscriptBox["p", "7"]}], ")"}]}]},
       {
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"3", " ", "p"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}]}], ")"}]}]},
       {
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"3", " ", "p"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}]}], ")"}]}]},
       {
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"3", " ", "p"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}]}], ")"}]}]},
       {
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "p", "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           SuperscriptBox["p", "3"]}], ")"}]}]},
       {
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "p", "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           SuperscriptBox["p", "3"]}], ")"}]}]},
       {
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "p"}], ")"}], "2"], " ", "p", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"3", " ", "p"}]}], ")"}]}]},
       {
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "p"}], ")"}], " ", "p", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", "p"}], ")"}], "2"]}]},
       {
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "p", "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           SuperscriptBox["p", "3"]}], ")"}]}]},
       {
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "p", "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           SuperscriptBox["p", "3"]}], ")"}]}]},
       {
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           SuperscriptBox["p", "2"], "-", 
           SuperscriptBox["p", "3"]}], ")"}]}]},
       {
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           SuperscriptBox["p", "2"], "-", 
           SuperscriptBox["p", "3"]}], ")"}]}]},
       {
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           SuperscriptBox["p", "2"], "-", 
           SuperscriptBox["p", "3"]}], ")"}]}]},
       {
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           SuperscriptBox["p", "2"], "-", 
           SuperscriptBox["p", "3"]}], ")"}]}]},
       {
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           SuperscriptBox["p", "2"], "-", 
           SuperscriptBox["p", "3"]}], ")"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";"}]}], "Input",
 CellChangeTimes->{{3.736714497252186*^9, 3.7367145096346483`*^9}, {
  3.7367153883764677`*^9, 3.736715400197502*^9}, {3.736763110844192*^9, 
  3.736763285552973*^9}, {3.736765500054656*^9, 3.7367655046000566`*^9}, {
  3.736773306367393*^9, 3.736773333415854*^9}, {3.736773365527327*^9, 
  3.7367734353587847`*^9}, {3.73677546656733*^9, 3.736775532019891*^9}, {
  3.73677650338513*^9, 3.736776530159049*^9}, {3.741349865654004*^9, 
  3.7413499234249573`*^9}, {3.741349992715035*^9, 3.741350061852364*^9}, {
  3.741350120124241*^9, 
  3.7413501247141113`*^9}},ExpressionUUID->"84c3f190-9b3b-41d5-b15b-\
074c53834bdf"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "equation", " ", "checks", " ", "Plancherel", " ", "for", " ",
     "the", " ", "maximal", " ", "function"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.741350145008237*^9, 
  3.741350192487864*^9}},ExpressionUUID->"61fe3b3c-9dd4-4567-b12e-\
8843f40554ae"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Transpose", "[", "D12orbitSum2", "]"}], ".", "OD12OrbitSizes"}],
     " ", "+", " ", 
    RowBox[{
     RowBox[{"Transpose", "[", "D11orbitSum2", "]"}], ".", "OD11OrbitSizes"}],
     " ", "+", " ", 
    RowBox[{
     RowBox[{"Transpose", "[", "D2orbitSum2", "]"}], ".", "OD2OrbitSizes"}], 
    " ", "+", " ", 
    RowBox[{
     RowBox[{"p", "^", 
      RowBox[{"(", "24", ")"}]}], "*", 
     RowBox[{
      RowBox[{"Transpose", "[", "modpFT2", "]"}], ".", "modPorbitsizes"}]}]}],
    "]"}], " "}]], "Input",
 CellChangeTimes->{{3.7367624548368073`*^9, 3.736762469172776*^9}, {
  3.7367625166614*^9, 3.736762644310995*^9}, {3.736762683645131*^9, 
  3.736762829691587*^9}, {3.736763062915659*^9, 3.736763063730008*^9}, {
  3.736763293017302*^9, 3.736763294640483*^9}, {3.736763503943757*^9, 
  3.736763529671048*^9}, {3.736764383099649*^9, 
  3.736764394170863*^9}},ExpressionUUID->"f6a1074a-ae45-404e-95ef-\
cafdb76d44ac"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox["p", "37"], "+", 
    SuperscriptBox["p", "38"], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["p", "39"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["p", "40"]}], "+", 
    SuperscriptBox["p", "41"], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["p", "42"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["p", "43"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["p", "44"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["p", "45"]}], "-", 
    SuperscriptBox["p", "46"], "+", 
    SuperscriptBox["p", "48"]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.736762570627907*^9, {3.736762623379833*^9, 3.736762644750716*^9}, 
   3.736762693783682*^9, 3.7367627247068996`*^9, 3.736762830847744*^9, {
   3.736763050741261*^9, 3.73676306413797*^9}, 3.736763295310543*^9, {
   3.7367635063529882`*^9, 3.7367635299809523`*^9}, {3.7367643841452427`*^9, 
   3.736764395128645*^9}, 3.7367655165098677`*^9, 3.7367698932654743`*^9, 
   3.7367715544196033`*^9},ExpressionUUID->"2cb4c86c-d787-4160-99be-\
daa516db6335"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
   "This", " ", "equation", " ", "obtains", " ", "the", " ", "L2", " ", 
    "norm", " ", "square", " ", "of", " ", "the", " ", "non"}], "-", 
   RowBox[{"maximal", " ", "indicator", " ", "function"}]}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.741350196840938*^9, 
  3.7413502181755533`*^9}},ExpressionUUID->"18f3a94c-aa81-4780-9a96-\
96a8a337f03b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Transpose", "[", "D12orbitSum2", "]"}], ".", "OD12OrbitSizes"}],
     " ", "+", " ", 
    RowBox[{
     RowBox[{"Transpose", "[", "D11orbitSum2", "]"}], ".", "OD11OrbitSizes"}],
     " ", "+", " ", 
    RowBox[{
     RowBox[{"Transpose", "[", "D2orbitSum2", "]"}], ".", "OD2OrbitSizes"}], 
    " ", "+", " ", 
    RowBox[{
     RowBox[{"p", "^", 
      RowBox[{"(", "24", ")"}]}], "*", 
     RowBox[{
      RowBox[{"Transpose", "[", "nonmaxpFT2", "]"}], ".", 
      "modPorbitsizes"}]}]}], "]"}], " ", "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.736775560802003*^9, 
  3.73677558103141*^9}},ExpressionUUID->"05ff6b81-cbc5-4a76-8be4-\
f178b0ef0d05"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["p", "37"]}], "-", 
    SuperscriptBox["p", "38"], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["p", "39"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["p", "40"]}], "-", 
    SuperscriptBox["p", "41"], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["p", "42"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["p", "43"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["p", "44"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["p", "45"]}], "+", 
    SuperscriptBox["p", "46"]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.736775585784451*^9},ExpressionUUID->"e2460f7c-b2a4-4f5f-8152-\
54ddd76f2534"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "This", " ", "equation", " ", "calculates", " ", "the", " ", "L1", " ", 
   "norm", " ", "of", " ", "the", " ", "FT", " ", "of", " ", "the", " ", 
   "maximal", " ", "function"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.7413502639421186`*^9, 
  3.741350280519042*^9}},ExpressionUUID->"53d99efb-da6c-44d3-b7db-\
fc601359a651"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"L1norm", " ", "=", " ", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "ABSD12Sums", "]"}], ".", "OD12OrbitSizes"}], 
     " ", "+", " ", 
     RowBox[{
      RowBox[{"Transpose", "[", "ABSD11Sums", "]"}], ".", "OD11OrbitSizes"}], 
     " ", "+", " ", 
     RowBox[{
      RowBox[{"Transpose", "[", "ABSD2Sums", "]"}], ".", "OD2OrbitSizes"}], 
     " ", "+", " ", 
     RowBox[{
      RowBox[{"p", "^", 
       RowBox[{"(", "12", ")"}]}], "*", 
      RowBox[{
       RowBox[{"Transpose", "[", "ABSmodpFT", "]"}], ".", 
       "modPorbitsizes"}]}]}], "]"}]}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{
  3.736773558647954*^9, {3.736774005145987*^9, 3.736774078241809*^9}, {
   3.736774360056828*^9, 
   3.736774364623886*^9}},ExpressionUUID->"1584bb03-92e8-4a77-9fff-\
fffe02e51acd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["p", "13"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["p", "14"]}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["p", "15"]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["p", "16"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["p", "17"]}], "+", 
    RowBox[{"11", " ", 
     SuperscriptBox["p", "18"]}], "+", 
    SuperscriptBox["p", "19"], "-", 
    RowBox[{"21", " ", 
     SuperscriptBox["p", "20"]}], "-", 
    RowBox[{"9", " ", 
     SuperscriptBox["p", "21"]}], "+", 
    RowBox[{"22", " ", 
     SuperscriptBox["p", "22"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["p", "23"]}], "-", 
    SuperscriptBox["p", "24"], "-", 
    RowBox[{"19", " ", 
     SuperscriptBox["p", "25"]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["p", "26"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["p", "27"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["p", "28"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["p", "29"]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.736774083182867*^9, 
  3.736774366508934*^9},ExpressionUUID->"e9b5e540-6d4a-47e8-875a-\
90943b12479f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "This", " ", "equation", " ", "calculates", " ", "the", " ", "L1", " ", 
     "norm", " ", "of", " ", "the", " ", "FT", " ", "of", " ", "the", " ", 
     "non"}], "-", 
    RowBox[{"maximal", " ", "function"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"L1nonmaxnorm", " ", "=", " ", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "ABSD12Sums", "]"}], ".", "OD12OrbitSizes"}], 
     " ", "+", " ", 
     RowBox[{
      RowBox[{"Transpose", "[", "ABSD11Sums", "]"}], ".", "OD11OrbitSizes"}], 
     " ", "+", " ", 
     RowBox[{
      RowBox[{"Transpose", "[", "ABSD2Sums", "]"}], ".", "OD2OrbitSizes"}], 
     " ", "+", " ", 
     RowBox[{
      RowBox[{"p", "^", 
       RowBox[{"(", "12", ")"}]}], "*", 
      RowBox[{
       RowBox[{"Transpose", "[", "ABSnonmaxpFT", "]"}], ".", 
       "modPorbitsizes"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.736776546898699*^9, 3.736776567284329*^9}, {
  3.736776598964449*^9, 3.736776604653023*^9}, {3.7413502847752333`*^9, 
  3.7413503000953293`*^9}},ExpressionUUID->"db23bced-fb98-4990-a788-\
1cbacfeb974e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox["p", "14"], "+", 
    SuperscriptBox["p", "15"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["p", "16"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["p", "17"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["p", "18"]}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["p", "19"]}], "-", 
    RowBox[{"17", " ", 
     SuperscriptBox["p", "20"]}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["p", "21"]}], "+", 
    RowBox[{"24", " ", 
     SuperscriptBox["p", "22"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["p", "23"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["p", "24"]}], "-", 
    RowBox[{"19", " ", 
     SuperscriptBox["p", "25"]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["p", "26"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["p", "27"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["p", "28"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["p", "29"]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.736776605082465*^9},ExpressionUUID->"234724dd-9cfc-42d3-9fd8-\
62a89c4e635f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
   "This", " ", "equation", " ", "calculates", " ", "the", " ", "size", " ", 
    "of", " ", "the", " ", "support", " ", "of", " ", "the", " ", "FT", " ", 
    "of", " ", "the", " ", "maximal", " ", "and", " ", "non"}], "-", 
   RowBox[{"maximal", " ", "functions"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.741350362235095*^9, 
  3.741350381630324*^9}},ExpressionUUID->"97bdc0b0-9c02-4737-a9e9-\
b429da4e39a3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Supp", " ", "=", " ", 
  RowBox[{"Expand", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Transpose", "[", "SuppD12Sums", "]"}], ".", "OD12OrbitSizes"}], 
    " ", "+", " ", 
    RowBox[{
     RowBox[{"Transpose", "[", "SuppD11Sums", "]"}], ".", "OD11OrbitSizes"}], 
    " ", "+", " ", 
    RowBox[{
     RowBox[{"Transpose", "[", "SuppD2Sums", "]"}], ".", "OD2OrbitSizes"}], 
    " ", "+", " ", 
    RowBox[{"p", "^", 
     RowBox[{"(", "12", ")"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7367759133389997`*^9, 
  3.736775949872673*^9}},ExpressionUUID->"d1d01334-dd0b-44b2-bd27-\
7df457f46223"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["p", "8"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["p", "10"]}], "-", 
    SuperscriptBox["p", "12"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["p", "13"]}], "+", 
    SuperscriptBox["p", "14"], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["p", "15"]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.736775950607786*^9},ExpressionUUID->"5a2dcc32-5984-4478-ad3d-\
e9afef163849"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", "D12orbitSum2", "]"}], ".", "OD12OrbitSizes"}], 
   "]"}], " "}]], "Input",
 CellChangeTimes->{{3.7367712641620073`*^9, 
  3.736771268273058*^9}},ExpressionUUID->"11828974-16fd-455d-8f09-\
2cc88123c9fa"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["p", "37"]}], "-", 
    SuperscriptBox["p", "38"], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["p", "39"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["p", "41"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["p", "42"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["p", "43"]}], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["p", "44"]}], "+", 
    SuperscriptBox["p", "45"], "+", 
    SuperscriptBox["p", "46"]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.736771259779769*^9, 
  3.7367712686384773`*^9}},ExpressionUUID->"1393cd01-131b-491e-a07b-\
b4746ab8745e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", "D11orbitSum2", "]"}], ".", "OD11OrbitSizes"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.736771287309856*^9, 
  3.7367712892807837`*^9}},ExpressionUUID->"3c004c0a-b179-44c1-838c-\
264838c8ab0b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    FractionBox[
     SuperscriptBox["p", "36"], "2"], "-", 
    SuperscriptBox["p", "37"], "+", 
    FractionBox[
     SuperscriptBox["p", "39"], "2"], "+", 
    FractionBox[
     SuperscriptBox["p", "40"], "2"], "-", 
    SuperscriptBox["p", "42"], "+", 
    FractionBox[
     SuperscriptBox["p", "43"], "2"]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7367712900971107`*^9},ExpressionUUID->"c0f6b5ab-8427-4280-b29b-\
0d10c53a1550"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.736764389289071*^9, 
  3.736764391440928*^9}},ExpressionUUID->"ca5fbd0e-a85d-47d8-ac7d-\
3e791d8731cd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", "D2orbitSum2", "]"}], ".", "OD2OrbitSizes"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.736771413311702*^9, 
  3.736771416159972*^9}},ExpressionUUID->"f271897c-2849-4f5d-8dd7-\
259178bddbf0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    FractionBox[
     SuperscriptBox["p", "36"], "2"], "-", 
    FractionBox[
     SuperscriptBox["p", "37"], "2"], "-", 
    SuperscriptBox["p", "38"], "+", 
    FractionBox[
     SuperscriptBox["p", "39"], "2"], "+", 
    SuperscriptBox["p", "40"], "+", 
    FractionBox[
     SuperscriptBox["p", "41"], "2"], "-", 
    SuperscriptBox["p", "42"], "-", 
    FractionBox[
     SuperscriptBox["p", "43"], "2"], "+", 
    FractionBox[
     SuperscriptBox["p", "44"], "2"]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.736771416521782*^9},ExpressionUUID->"92362261-a80c-4dca-b470-\
406607df8943"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"p", "^", 
     RowBox[{"(", "24", ")"}]}], "*", 
    RowBox[{
     RowBox[{"Transpose", "[", "modpFT2", "]"}], ".", "modPorbitsizes"}]}], 
   "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.736771470859837*^9, 
  3.736771481127737*^9}},ExpressionUUID->"3f2e8b08-4c23-492b-ae06-\
49a958037748"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["p", "36"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["p", "38"]}], "+", 
    SuperscriptBox["p", "39"], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["p", "40"]}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["p", "41"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["p", "42"]}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["p", "43"]}], "+", 
    SuperscriptBox["p", "44"], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["p", "45"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["p", "46"]}], "+", 
    SuperscriptBox["p", "48"]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.736771481597234*^9},ExpressionUUID->"2827a2e7-7934-4563-90d4-\
87232bc77794"]
}, Open  ]]
},
WindowSize->{1011, 770},
WindowMargins->{{Automatic, -243}, {Automatic, 110}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperOrientation"->"Portrait",
"PaperSize"->{Automatic, Automatic},
"PostScriptOutputFile"->"",
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->True,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{54, 54}, {72, 72}}},
FrontEndVersion->"11.1 for Linux x86 (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 616, 15, 79, "Input", "ExpressionUUID" -> \
"d188cbeb-305c-4527-b0f3-d7afe43a130e"],
Cell[CellGroupData[{
Cell[1199, 39, 17718, 499, 857, "Input", "ExpressionUUID" -> \
"65dda1b3-8862-472c-a41d-a8ad41151648"],
Cell[CellGroupData[{
Cell[18942, 542, 10831, 361, 502, "Print", "ExpressionUUID" -> \
"c6a6fd5f-abf4-40c1-acda-696d812f0a63"],
Cell[29776, 905, 3337, 119, 476, "Print", "ExpressionUUID" -> \
"3a579c9b-d367-4913-be70-b64fdaaaa9c1"],
Cell[33116, 1026, 3920, 138, 488, "Print", "ExpressionUUID" -> \
"06ee8b90-0882-4cac-a3de-88cbf867cffb"],
Cell[37039, 1166, 2793, 101, 455, "Print", "ExpressionUUID" -> \
"08e96283-3564-4106-afc4-6c898f57aed5"]
}, Open  ]]
}, Open  ]],
Cell[39859, 1271, 149, 3, 55, "Input", "ExpressionUUID" -> \
"c9b4c26d-4c91-465c-b792-2bdb2dd191d6"],
Cell[40011, 1276, 534, 12, 56, "Input", "ExpressionUUID" -> \
"e5fa6e96-47a5-44e0-85d3-8f0bedab843d"],
Cell[40548, 1290, 4882, 167, 965, "Input", "ExpressionUUID" -> \
"57aead23-3bda-4914-9b3a-8e09396d7fbb"],
Cell[CellGroupData[{
Cell[45455, 1461, 8135, 228, 676, "Input", "ExpressionUUID" -> \
"181a5985-0a23-4cea-8a42-875e31ed8149"],
Cell[CellGroupData[{
Cell[53615, 1693, 1396, 53, 377, "Print", "ExpressionUUID" -> \
"153e401d-02a3-4c4e-814f-01d73a0d52e6"],
Cell[55014, 1748, 1411, 53, 377, "Print", "ExpressionUUID" -> \
"1c85ae4e-bca5-4d5e-94c2-24c058013dd0"],
Cell[56428, 1803, 1392, 53, 377, "Print", "ExpressionUUID" -> \
"5fe6e31a-7898-416b-b140-b0340fdcb600"]
}, Open  ]]
}, Open  ]],
Cell[57847, 1860, 531, 13, 78, "Input", "ExpressionUUID" -> \
"42f09f6c-592e-4dfc-a48d-cbe35bc50399"],
Cell[58381, 1875, 2757, 97, 800, "Input", "ExpressionUUID" -> \
"22095fc0-f023-47eb-a923-f1467ebe6a72"],
Cell[61141, 1974, 177, 3, 32, "Input", "ExpressionUUID" -> \
"6660df3f-b9bf-4945-8bd9-4c4453bad9e0"],
Cell[CellGroupData[{
Cell[61343, 1981, 6658, 185, 468, "Input", "ExpressionUUID" -> \
"3bad400d-483f-41a2-8db7-c157308987bf"],
Cell[CellGroupData[{
Cell[68026, 2170, 1284, 44, 215, "Print", "ExpressionUUID" -> \
"00b45092-19b5-496a-9803-48300d8323c7"],
Cell[69313, 2216, 1299, 44, 215, "Print", "ExpressionUUID" -> \
"8f75e68e-686a-40b3-ae3a-8e002376ea7d"],
Cell[70615, 2262, 1282, 44, 215, "Print", "ExpressionUUID" -> \
"51aa9329-6359-434e-ac47-a045967d823b"]
}, Open  ]]
}, Open  ]],
Cell[71924, 2310, 2916, 88, 549, "Input", "ExpressionUUID" -> \
"3e09d136-0fb5-46c0-97f4-4b31b70cbb05"],
Cell[CellGroupData[{
Cell[74865, 2402, 5001, 134, 253, "Input", "ExpressionUUID" -> \
"af4d4f4c-6d12-4bba-a5cf-0b33c7c0c340"],
Cell[79869, 2538, 854, 23, 34, "Output", "ExpressionUUID" -> \
"ac1a9665-e504-443b-8e3b-2cf6c2b3ab52"]
}, Open  ]],
Cell[80738, 2564, 553, 14, 78, "Input", "ExpressionUUID" -> \
"a39ffe3a-93e0-4fac-9f2b-8a53832c3f87"],
Cell[CellGroupData[{
Cell[81316, 2582, 8042, 256, 492, "Input", "ExpressionUUID" -> \
"eae3167b-6283-442e-9d09-59a36409f0a9"],
Cell[89361, 2840, 7636, 254, 297, "Output", "ExpressionUUID" -> \
"5cc2f35a-e0f6-41bc-bd6a-4d4f774e580d"]
}, Open  ]],
Cell[97012, 3097, 959, 26, 78, "Input", "ExpressionUUID" -> \
"e885de1f-47bb-4f19-a463-4cd3b58beb65"],
Cell[CellGroupData[{
Cell[97996, 3127, 7077, 220, 631, "Input", "ExpressionUUID" -> \
"ab244b07-8d76-4c3a-8d7f-168f13d71115"],
Cell[105076, 3349, 9908, 325, 597, "Print", "ExpressionUUID" -> \
"d1202487-4a22-4c66-86b8-e53f22a95498"]
}, Open  ]],
Cell[CellGroupData[{
Cell[115021, 3679, 4907, 146, 562, "Input", "ExpressionUUID" -> \
"758ef7ec-6c3e-424e-a53a-0efce2bfe34e"],
Cell[119931, 3827, 8890, 291, 541, "Print", "ExpressionUUID" -> \
"c5ca5f06-f828-4fcf-9221-e21e326b693a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[128858, 4123, 3566, 109, 355, "Input", "ExpressionUUID" -> \
"c39d3e9f-1fa2-43f1-aa01-fd97a03b2cca"],
Cell[132427, 4234, 5226, 169, 313, "Print", "ExpressionUUID" -> \
"cf2f06bc-ae75-418e-ae00-e55b4c3f2492"]
}, Open  ]],
Cell[137668, 4406, 689, 15, 77, "Input", "ExpressionUUID" -> \
"92ff2755-2fb1-4724-bdec-ceffb992090b"],
Cell[138360, 4423, 28487, 853, 2252, "Input", "ExpressionUUID" -> \
"84c3f190-9b3b-41d5-b15b-074c53834bdf"],
Cell[166850, 5278, 357, 8, 55, "Input", "ExpressionUUID" -> \
"61fe3b3c-9dd4-4567-b12e-8843f40554ae"],
Cell[CellGroupData[{
Cell[167232, 5290, 1010, 25, 55, "Input", "ExpressionUUID" -> \
"f6a1074a-ae45-404e-95ef-cafdb76d44ac"],
Cell[168245, 5317, 1113, 28, 41, "Output", "ExpressionUUID" -> \
"2cb4c86c-d787-4160-99be-daa516db6335"]
}, Open  ]],
Cell[169373, 5348, 415, 10, 32, "Input", "ExpressionUUID" -> \
"18f3a94c-aa81-4780-9a96-96a8a337f03b"],
Cell[CellGroupData[{
Cell[169813, 5362, 750, 21, 77, "Input", "ExpressionUUID" -> \
"05ff6b81-cbc5-4a76-8be4-f178b0ef0d05"],
Cell[170566, 5385, 726, 23, 41, "Output", "ExpressionUUID" -> \
"e2460f7c-b2a4-4f5f-8152-54ddd76f2534"]
}, Open  ]],
Cell[171307, 5411, 378, 8, 32, "Input", "ExpressionUUID" -> \
"53d99efb-da6c-44d3-b7db-fc601359a651"],
Cell[CellGroupData[{
Cell[171710, 5423, 870, 24, 77, "Input", "ExpressionUUID" -> \
"1584bb03-92e8-4a77-9fff-fffe02e51acd"],
Cell[172583, 5449, 1225, 38, 71, "Output", "ExpressionUUID" -> \
"e9b5e540-6d4a-47e8-875a-90943b12479f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[173845, 5492, 1183, 31, 99, "Input", "ExpressionUUID" -> \
"db23bced-fb98-4990-a788-1cbacfeb974e"],
Cell[175031, 5525, 1139, 36, 41, "Output", "ExpressionUUID" -> \
"234724dd-9cfc-42d3-9fd8-62a89c4e635f"]
}, Open  ]],
Cell[176185, 5564, 476, 10, 55, "Input", "ExpressionUUID" -> \
"97bdc0b0-9c02-4737-a9e9-b429da4e39a3"],
Cell[CellGroupData[{
Cell[176686, 5578, 628, 17, 55, "Input", "ExpressionUUID" -> \
"d1d01334-dd0b-44b2-bd27-7df457f46223"],
Cell[177317, 5597, 499, 16, 41, "Output", "ExpressionUUID" -> \
"5a2dcc32-5984-4478-ad3d-e9afef163849"]
}, Open  ]],
Cell[CellGroupData[{
Cell[177853, 5618, 295, 8, 32, "Input", "ExpressionUUID" -> \
"11828974-16fd-455d-8f09-2cc88123c9fa"],
Cell[178151, 5628, 694, 21, 41, "Output", "ExpressionUUID" -> \
"1393cd01-131b-491e-a07b-b4746ab8745e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[178882, 5654, 274, 7, 32, "Input", "ExpressionUUID" -> \
"3c004c0a-b179-44c1-838c-264838c8ab0b"],
Cell[179159, 5663, 499, 16, 56, "Output", "ExpressionUUID" -> \
"c0f6b5ab-8427-4280-b29b-0d10c53a1550"]
}, Open  ]],
Cell[179673, 5682, 152, 3, 32, "Input", "ExpressionUUID" -> \
"ca5fbd0e-a85d-47d8-ac7d-3e791d8731cd"],
Cell[CellGroupData[{
Cell[179850, 5689, 270, 7, 32, "Input", "ExpressionUUID" -> \
"f271897c-2849-4f5d-8dd7-259178bddbf0"],
Cell[180123, 5698, 656, 21, 56, "Output", "ExpressionUUID" -> \
"92362261-a80c-4dca-b470-406607df8943"]
}, Open  ]],
Cell[CellGroupData[{
Cell[180816, 5724, 407, 11, 77, "Input", "ExpressionUUID" -> \
"3f2e8b08-4c23-492b-ae06-49a958037748"],
Cell[181226, 5737, 789, 25, 41, "Output", "ExpressionUUID" -> \
"2827a2e7-7934-4563-90d4-87232bc77794"]
}, Open  ]]
}
]
*)

