(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    155991,       4757]
NotebookOptionsPosition[    152655,       4673]
NotebookOutlinePosition[    153151,       4692]
CellTagsIndexPosition[    153108,       4689]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "This", " ", "file", " ", "checks", " ", "the", " ", "calculation", " ", 
    "of", " ", "the", " ", "Fourier", " ", "transform", " ", "at", " ", 
    "frequencies", " ", "divisible", " ", "by", " ", "p"}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "First", " ", "load", " ", "the", " ", "matrix", " ", "M", " ", "from", 
     " ", "Taniguchi"}], "-", 
    RowBox[{
     RowBox[{"Thorne", "'"}], "s", " ", "work"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"phi2", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "2"}], "+", "q", "+", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bm3", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "2"}], "-", "3"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b1", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "2"}], " ", "+", " ", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b2", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "2"}], " ", "+", " ", "2"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b3", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "2"}], " ", "+", " ", "3"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b7", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "2"}], " ", "+", " ", "7"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b23", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "2"}], " ", "+", " ", "23"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a1", " ", "=", " ", 
     RowBox[{"q", "-", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a2", " ", "=", " ", 
     RowBox[{"q", "-", "3"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a3", " ", "=", " ", 
     RowBox[{
      RowBox[{"2", "*", "q"}], " ", "-", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a4", " ", "=", " ", 
     RowBox[{
      RowBox[{"2", "*", "q"}], " ", "+", " ", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a5", " ", "=", " ", 
     RowBox[{
      RowBox[{"2", "*", "q"}], " ", "-", "3"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a6", " ", "=", " ", 
     RowBox[{
      RowBox[{"3", "*", "q"}], " ", "-", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a7", " ", "=", " ", 
     RowBox[{
      RowBox[{"3", "*", "q"}], " ", "+", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a8", " ", "=", " ", 
     RowBox[{
      RowBox[{"5", "*", "q"}], " ", "-", "7"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c1", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "2"}], " ", "-", " ", "q", " ", "-", " ", "1"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c2", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "2"}], " ", "-", " ", "q", "+", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c3", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "2"}], " ", "-", " ", 
      RowBox[{"2", "*", "q"}], " ", "-", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c4", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "2"}], " ", "+", " ", 
      RowBox[{"2", "*", "q"}], " ", "-", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c5", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "2"}], " ", "-", " ", 
      RowBox[{"2", "*", "q"}], "+", "3"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c6", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "2"}], " ", "-", " ", 
      RowBox[{"4", "*", "q"}], "-", "1"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c7", " ", "=", " ", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"q", "^", "2"}]}], " ", "+", " ", "q", "+", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c8", " ", "=", " ", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"q", "^", "2"}]}], " ", "+", " ", 
      RowBox[{"2", "*", "q"}], " ", "+", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c9", " ", "=", " ", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"q", "^", "2"}]}], " ", "-", " ", 
      RowBox[{"5", "*", "q"}], " ", "-", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c10", " ", "=", " ", 
     RowBox[{
      RowBox[{"3", "*", 
       RowBox[{"q", "^", "2"}]}], " ", "-", " ", "q", " ", "-", " ", "1"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c11", " ", "=", " ", 
     RowBox[{
      RowBox[{"3", "*", 
       RowBox[{"q", "^", "2"}]}], " ", "-", " ", 
      RowBox[{"2", "*", "q"}], " ", "+", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c12", " ", "=", " ", 
     RowBox[{
      RowBox[{"3", "*", 
       RowBox[{"q", "^", "2"}]}], " ", "+", " ", 
      RowBox[{"3", "*", "q"}], " ", "+", " ", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d1", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "3"}], " ", "-", "q", "-", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d2", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "3"}], " ", "-", 
      RowBox[{"q", "^", "2"}], " ", "+", " ", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d3", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "3"}], " ", "-", " ", 
      RowBox[{"q", "^", "2"}], " ", "-", "q", "-", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d4", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "3"}], " ", "+", " ", 
      RowBox[{"q", "^", "2"}], " ", "-", "q", "+", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d5", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "3"}], " ", "-", " ", 
      RowBox[{"q", "^", "2"}], " ", "-", 
      RowBox[{"2", "*", "q"}], " ", "-", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d6", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "3"}], " ", "+", 
      RowBox[{"q", "^", "2"}], " ", "-", 
      RowBox[{"3", "*", "q"}], "-", "1"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d7", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "3"}], " ", "-", 
      RowBox[{"2", "*", 
       RowBox[{"q", "^", "2"}]}], "+", "q", "+", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d8", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "3"}], " ", "-", 
      RowBox[{"2", "*", 
       RowBox[{"q", "^", "2"}]}], " ", "+", " ", 
      RowBox[{"2", "*", "q"}], "-", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d9", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "3"}], " ", "-", 
      RowBox[{"4", "*", 
       RowBox[{"q", "^", "2"}]}], " ", "+", " ", "q", "+", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d10", " ", "=", " ", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"q", "^", "3"}]}], " ", "-", 
      RowBox[{"q", "^", "2"}], " ", "-", 
      RowBox[{"2", "*", "q"}], " ", "-", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"e1", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "4"}], " ", "+", " ", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"e2", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "4"}], " ", "-", " ", 
      RowBox[{"q", "^", "3"}], " ", "+", " ", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"e3", " ", "=", " ", 
     RowBox[{
      RowBox[{"q", "^", "4"}], " ", "+", " ", 
      RowBox[{"2", "*", 
       RowBox[{"q", "^", "3"}]}], " ", "-", 
      RowBox[{"2", "*", 
       RowBox[{"q", "^", "2"}]}], "-", 
      RowBox[{"2", "*", "q"}], " ", "-", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"e4", " ", "=", " ", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"q", "^", "4"}]}], " ", "-", " ", 
      RowBox[{"2", "*", 
       RowBox[{"q", "^", "3"}]}], "-", 
      RowBox[{"q", "^", "2"}], " ", "+", " ", "q", "+", "1"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"powers", " ", "=", " ", 
     RowBox[{"Array", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"q", "-", "1"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"#1", "-", "1"}], ")"}]}], "*", 
         RowBox[{"q", "^", 
          RowBox[{"(", 
           RowBox[{"#2", "-", "1"}], ")"}]}], " ", "*", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"q", "+", "1"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"#3", "-", "1"}], ")"}]}]}], "&"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "5", ",", "5"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"powers", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2", ",", "3"}], "]"}], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.734631633478466*^9, 3.734631646715763*^9}, {
   3.734631740763258*^9, 3.734631765011018*^9}, {3.734631854410544*^9, 
   3.734631860802662*^9}, {3.734631898954311*^9, 3.734632318655961*^9}, 
   3.734690802477973*^9, {3.734691006268468*^9, 3.7346910670043*^9}, {
   3.734691115435802*^9, 3.734691133395665*^9}, {3.73469117148416*^9, 
   3.734691224003254*^9}, {3.7346912550997677`*^9, 3.734691255875476*^9}, {
   3.734693283344111*^9, 3.734693289567737*^9}, {3.7413475936067553`*^9, 
   3.741347649800404*^9}},ExpressionUUID->"23388703-d4fd-4796-8d38-\
e38934172339"],

Cell[BoxData[
 RowBox[{"q", " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "q"}], ")"}], "2"]}]], "Print",
 CellChangeTimes->{
  3.734691134345212*^9, {3.734691185241857*^9, 3.734691224784532*^9}, 
   3.734691256621154*^9, 3.734693461374*^9, 3.736691602775527*^9, 
   3.736765454603034*^9, 
   3.741610074078937*^9},ExpressionUUID->"caa671cf-a15e-4a89-a1be-\
bd5ea82906b0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"This", " ", "is", " ", "the", " ", "matrix", " ", "M"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Mmatrix", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "3", ",", "3"}], "]"}], "]"}], "*", "phi2"}], 
         ",", " ", 
         RowBox[{
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "4", ",", "3"}], "]"}], "]"}], "*", "phi2"}], 
         ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "3"}], "]"}], "]"}], "*", "phi2"}], 
         ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "5", ",", "2"}], "]"}], "]"}], "*", "phi2"}], 
         ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "5", ",", "3"}], "]"}], "]"}], "*", "phi2"}], 
         ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "5", ",", "3"}], "]"}], "]"}], "*", "phi2"}], 
         ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "24"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"5", ",", "5", ",", "3"}], "]"}], "]"}], "*", "phi2"}], 
         ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "4"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"5", ",", "5", ",", "3"}], "]"}], "]"}], "*", "phi2"}], 
         ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "8"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"5", ",", "5", ",", "3"}], "]"}], "]"}], "*", "phi2"}], 
         ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "3"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"5", ",", "5", ",", "3"}], "]"}], "]"}], "*", "phi2"}], 
         ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "4"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"5", ",", "5", ",", "3"}], "]"}], "]"}], "*", "phi2"}]}], 
        "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "3", ",", "3"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "4", ",", "2"}], "]"}], "]"}], "*", "c1"}], ",",
          " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}], "*", "c1"}], ",",
          " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "1"}], "]"}], "]"}], "*", "phi2"}], 
         ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "5", ",", "2"}], "]"}], "]"}], "*", "a4"}], ",",
          " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "3"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "24"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "5", ",", "2"}], "]"}], "]"}], "*", "c10"}], 
         ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "4"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "5", ",", "2"}], "]"}], "]"}], "*", "c1"}], ",",
          " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "8"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "5", ",", "2"}], "]"}], "]"}], "*", "phi2"}], 
         ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "3"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "5", ",", "3"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "4"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "5", ",", "2"}], "]"}], "]"}], "*", "phi2"}]}], 
        "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "3", ",", "2"}], "]"}], "]"}], "*", "c1"}], ",",
          " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"powers", "[", 
            RowBox[{"[", 
             RowBox[{"3", ",", "4", ",", "1"}], "]"}], "]"}]}], "*", "a7"}], 
         ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}], "*", "d6"}], ",",
          " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "1"}], "]"}], "]"}], "*", "c6"}], ",",
          " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "1"}], "]"}], "]"}], "*", "c3"}], ",",
          " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "24"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "5", ",", "1"}], "]"}], "]"}], "*", "c9"}], ",",
          " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "4"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "5", ",", "1"}], "]"}], "]"}], "*", "a7"}], ",",
          " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "8"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"5", ",", "5", ",", "1"}], "]"}], "]"}], "*", "a4"}], ",",
          " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "3"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "5", ",", "3"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "4"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "5", ",", "2"}], "]"}], "]"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"powers", "[", 
            RowBox[{"[", 
             RowBox[{"3", ",", "3", ",", "2"}], "]"}], "]"}]}], "*", "phi2"}],
          ",", " ", 
         RowBox[{"-", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "4", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}], "*", "b1"}], ",",
          " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}], "*", "d3"}], ",",
          " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}], "*", "b1"}], ",",
          " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "24"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "5", ",", "2"}], "]"}], "]"}], "*", "a3"}], ",",
          " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "4"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "8"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "2"}], "]"}], "]"}], "*", "c7"}], ",",
          " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "3"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "5", ",", "3"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "4"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "3"}], "]"}], "]"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"powers", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "3", ",", "2"}], "]"}], "]"}], ",", " ", 
         RowBox[{"powers", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "4", ",", "2"}], "]"}], "]"}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "24"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "2"}], "]"}], "]"}], "*", "a3"}], ",",
          " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "4"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "8"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "2"}], "]"}], "]"}], "*", "a3"}], ",",
          " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "3"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "3"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "4"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "2"}], "]"}], "]"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"powers", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "3", ",", "1"}], "]"}], "]"}]}], "*", "c1"}], 
         ",", " ", 
         RowBox[{
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "4", ",", "1"}], "]"}], "]"}], "*", "d7"}], ",",
          " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}], "*", "c3"}], ",",
          " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}], "*", "d9"}], ",",
          " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}], "*", "d7"}], ",",
          " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "24"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "1"}], "]"}], "]"}], "*", "a3", "*", 
          "a7"}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "4"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "5", ",", "1"}], "]"}], "]"}], "*", "a4"}], ",",
          " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "8"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "5", ",", "1"}], "]"}], "]"}], "*", "a4"}], ",",
          " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "3"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "4"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "2"}], "]"}], "]"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "3", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"powers", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "4", ",", "2"}], "]"}], "]"}]}], "*", "a1"}], 
         ",", " ", 
         RowBox[{"-", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", "0", 
         ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}], "*", "a2"}], ",",
          " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "6"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", "0", 
         ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "3"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         "0"}], "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"powers", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "3", ",", "2"}], "]"}], "]"}], ",", " ", 
         RowBox[{"-", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "4", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "1"}], "]"}], "]"}], "*", "a4"}], ",",
          " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "24"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "1"}], "]"}], "]"}], "*", "c11"}], 
         ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "4"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "8"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "1"}], "]"}], "]"}], "*", "c3"}], ",",
          " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "3"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "4"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "3"}], "]"}], "]"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"powers", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "3", ",", "2"}], "]"}], "]"}], ",", " ", 
         RowBox[{"-", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "4", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}], "*", "a3"}], ",",
          " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "24"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "2"}], "]"}], "]"}], "*", "a6"}], ",",
          " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "4"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}], "*", "c4"}], ",",
          " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "8"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "3"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "3"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "4"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}], "*", "b1"}]}], 
        "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "3", ",", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "4", ",", "1"}], "]"}], "]"}], "*", "b1"}], ",",
          " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"4", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "24"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}], "*", "a3", "*", 
          "a6"}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "4"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "8"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}], "*", "a3"}], ",",
          " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "3"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "4"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "3", ",", "1"}], "]"}], "]"}], "*", "b1"}], ",",
          " ", 
         RowBox[{
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "4", ",", "1"}], "]"}], "]"}], "*", "d8"}], ",",
          " ", 
         RowBox[{"-", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", "0", 
         ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}], "*", "a5"}], ",",
          " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "6"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}], "*", "a3"}], ",",
          " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", "0", 
         ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "3"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", "0"}], 
        "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "3", ",", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", "2"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "4", ",", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "5", ",", "1"}], "]"}], "]"}], "*", "c5"}], ",",
          " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"powers", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}]}], "*", "a1"}], 
         ",", " ", 
         RowBox[{"powers", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "4"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "4"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", "0", 
         ",", " ", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"powers", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "3", ",", "2"}], "]"}], "]"}], ",", " ", "0", 
         ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "5", ",", "1"}], "]"}], "]"}], "*", "bm3"}], 
         ",", " ", "0", ",", " ", 
         RowBox[{"powers", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}], ",", " ", "0", 
         ",", " ", "0", ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", "0", 
         ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"powers", "[", 
          RowBox[{"[", 
           RowBox[{"4", ",", "3", ",", "1"}], "]"}], "]"}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"powers", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "4", ",", "1"}], "]"}], "]"}]}], "*", "a5"}], 
         ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"powers", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "5", ",", "1"}], "]"}], "]"}]}], "*", "a1"}], 
         ",", " ", "0", ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "5", ",", "1"}], "]"}], "]"}], "*", "a8"}], ",",
          " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", "0", 
         ",", " ", "0", ",", " ", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"3", ",", "3", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{"powers", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "4", ",", "1"}], "]"}], "]"}], ",", " ", 
         RowBox[{"powers", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "5", ",", "1"}], "]"}], "]"}], ",", " ", 
         RowBox[{"powers", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "5", ",", "1"}], "]"}], "]"}], "*", "a2"}], ",",
          " ", "0", ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "2"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", "0", 
         ",", " ", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"powers", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "3", ",", "1"}], "]"}], "]"}]}], "*", "a3", 
          "*", "a6"}], ",", " ", 
         RowBox[{"4", "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "4", ",", "1"}], "]"}], "]"}], "*", "a3"}], ",",
          " ", 
         RowBox[{"3", "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", "0", 
         ",", " ", 
         RowBox[{
          RowBox[{"-", "6"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", "0", 
         ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "24"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "5", ",", "1"}], "]"}], "]"}], "*", "b23"}], 
         ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "4"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "8"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "3"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "4"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"powers", "[", 
          RowBox[{"[", 
           RowBox[{"2", ",", "3", ",", "1"}], "]"}], "]"}], ",", " ", 
         RowBox[{
          RowBox[{"-", "2"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "4", ",", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{"powers", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "5", ",", "1"}], "]"}], "]"}], ",", " ", "0", 
         ",", " ", 
         RowBox[{"-", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{"-", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "24"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "4"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "5", ",", "1"}], "]"}], "]"}], "*", "b3"}], ",",
          " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "8"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "3"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "4"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "3", ",", "2"}], "]"}], "]"}], "*", "a3"}], ",",
          " ", "0", ",", " ", 
         RowBox[{"powers", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "5", ",", "1"}], "]"}], "]"}], ",", " ", 
         RowBox[{
          RowBox[{"-", "2"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", "0", 
         ",", " ", 
         RowBox[{
          RowBox[{"-", "2"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "24"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "4"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "8"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "5", ",", "1"}], "]"}], "]"}], "*", "b7"}], ",",
          " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "3"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "4"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "3", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{"-", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "4", ",", "2"}], "]"}], "]"}]}], ",", " ", "0", 
         ",", "0", ",", "0", ",", "0", ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "24"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "4"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "8"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "3"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "5", ",", "1"}], "]"}], "]"}], "*", "b2"}], ",",
          " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "4"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "3", ",", "2"}], "]"}], "]"}]}], ",", " ", "0", 
         ",", "0", ",", " ", 
         RowBox[{"-", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "5", ",", "1"}], "]"}], "]"}]}], ",", " ", "0", 
         ",", "0", ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "24"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "4"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "8"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1", "/", "3"}], ")"}]}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "5", ",", "2"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "4"}], ")"}], "*", 
          RowBox[{"powers", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "5", ",", "1"}], "]"}], "]"}], "*", "b3"}]}], 
        "}"}]}], "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"MatrixForm", "[", "Mmatrix", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.734688319734911*^9, 3.734688425260132*^9}, {
   3.734688461876129*^9, 3.734688587835525*^9}, {3.734688619259305*^9, 
   3.734688631803165*^9}, {3.734688715890822*^9, 3.7346889043782187`*^9}, {
   3.734689196929524*^9, 3.734689308960816*^9}, {3.734689418936064*^9, 
   3.734689446255938*^9}, {3.734689490727716*^9, 3.7346895129518147`*^9}, 
   3.7346895608954477`*^9, {3.734689599383272*^9, 3.734689679271224*^9}, {
   3.734689711238966*^9, 3.734689766830044*^9}, {3.734689982014029*^9, 
   3.7346899845013523`*^9}, {3.73469007310106*^9, 3.734690075917141*^9}, {
   3.73469015090876*^9, 3.7346901530610447`*^9}, {3.734691958969286*^9, 
   3.7346919683825274`*^9}, {3.734692094645823*^9, 3.73469213377826*^9}, {
   3.734692170469558*^9, 3.734692202365514*^9}, {3.734692254373147*^9, 
   3.73469226913284*^9}, {3.7346924286678553`*^9, 3.734692536043373*^9}, {
   3.734692683915264*^9, 3.734692779082123*^9}, {3.734692902281472*^9, 
   3.7346930573609*^9}, {3.734693297032361*^9, 3.734693428894579*^9}, {
   3.734694929205271*^9, 3.734695061076604*^9}, {3.734695094725223*^9, 
   3.734695250564475*^9}, {3.734695428227544*^9, 3.734695606378808*^9}, {
   3.734695675706429*^9, 3.734695787122141*^9}, {3.73469585688939*^9, 
   3.734696075312559*^9}, {3.734696112872634*^9, 3.734696212872179*^9}, {
   3.7346962621837797`*^9, 3.7346967509375553`*^9}, {3.7346967959092407`*^9, 
   3.7346968341731987`*^9}, {3.734696868549076*^9, 3.734696886100965*^9}, {
   3.73469695484374*^9, 3.734697001996479*^9}, {3.734697054628192*^9, 
   3.734697509090369*^9}, {3.734697818048221*^9, 3.734698139870901*^9}, {
   3.7346981958859243`*^9, 3.734698450669615*^9}, {3.734698676780216*^9, 
   3.734699218674882*^9}, {3.734699258890336*^9, 3.734699444641844*^9}, {
   3.7346997140963*^9, 3.734699862215085*^9}, {3.734699895462941*^9, 
   3.734699903774856*^9}, {3.734699979767084*^9, 3.734700254798134*^9}, {
   3.734700295894431*^9, 3.7347003109025097`*^9}, 3.736690212844668*^9, {
   3.7367654388076057`*^9, 3.7367654389561577`*^9}, {3.7413476590939407`*^9, 
   3.741347665935869*^9}},ExpressionUUID->"bea524a0-ac10-4228-a28f-\
fcbe4e21c708"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "q"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "q"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "q"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "q"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "q"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "24"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "4"], " ", 
       SuperscriptBox["q", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "q"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "4"], " ", 
       SuperscriptBox["q", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "q"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "8"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "4"], " ", 
       SuperscriptBox["q", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "q"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "4"], " ", 
       SuperscriptBox["q", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "q"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "4"], " ", 
       SuperscriptBox["q", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "q"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}]},
     {
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"]}], " ", 
       SuperscriptBox["q", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "q"}], ")"}], "2"]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", "q", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", "q", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "q"}]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "q"}], ")"}], "2"]}], 
      RowBox[{
       FractionBox["1", "24"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", "q", "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["q", "2"]}]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", "q", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "8"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "3"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "q"}], ")"}], "2"]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", "q", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"]}], " ", 
       SuperscriptBox["q", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", "q"}]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{"3", " ", "q"}], "+", 
         SuperscriptBox["q", "2"], "+", 
         SuperscriptBox["q", "3"]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{"4", " ", "q"}], "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{"2", " ", "q"}], "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "24"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{"5", " ", "q"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "2"]}]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", "q"}]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "8"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "4"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "q"}]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "3"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "q"}], ")"}], "2"]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}]},
     {
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"]}], " ", 
       SuperscriptBox["q", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"]}], " ", 
       SuperscriptBox["q", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", "q", "-", 
         SuperscriptBox["q", "2"], "+", 
         SuperscriptBox["q", "3"]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "24"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "q"}]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       FractionBox["1", "8"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q", "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "2"]}]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "3"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "q"}], ")"}], "2"]}], 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "q"}], ")"}], "2"]}]},
     {
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "24"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "q"}]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "8"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "q"}]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "q"}], ")"}], "2"]}], 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}]},
     {
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}]}], " ", 
       SuperscriptBox["q", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", "q", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "2"]}], "+", 
         SuperscriptBox["q", "3"]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{"2", " ", "q"}], "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q", "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["q", "2"]}], "+", 
         SuperscriptBox["q", "3"]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "2"]}], "+", 
         SuperscriptBox["q", "3"]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "24"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "q"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", "q"}]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "q"}]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "8"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "q"}]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}]},
     {
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"]}], " ", 
       SuperscriptBox["q", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "q"}], ")"}]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}]}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], "0", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", "q"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       FractionBox["1", "6"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], "0", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], "0"},
     {
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"]}], " ", 
       SuperscriptBox["q", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "q"}]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "24"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", " ", "q"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["q", "2"]}]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "8"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{"2", " ", "q"}], "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "q"}], ")"}], "2"]}]},
     {
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"]}], " ", 
       SuperscriptBox["q", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "q"}]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "24"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"3", " ", "q"}]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "q"}], "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "8"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "q"}], ")"}], "2"]}], 
      RowBox[{
       FractionBox["1", "3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}]},
     {
      RowBox[{"-", 
       SuperscriptBox["q", "2"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "4"]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "24"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "q"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"3", " ", "q"}]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"]}], 
      RowBox[{
       FractionBox["1", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "q"}]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "3"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}]},
     {
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["q", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         RowBox[{"2", " ", "q"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "2"]}], "+", 
         SuperscriptBox["q", "3"]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}]}], " ", 
       SuperscriptBox["q", "4"]}], "0", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         RowBox[{"2", " ", "q"}]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"]}], 
      RowBox[{
       FractionBox["1", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "q"}]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"]}], "0", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "3"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], "0"},
     {
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"]}], " ", 
       SuperscriptBox["q", "2"]}], 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "3"]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"3", "-", 
         RowBox[{"2", " ", "q"}], "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"]}], 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "q"}], ")"}]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"]}], 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"]}], 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
       SuperscriptBox["q", "4"]}], "0", "0"},
     {
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], "0", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], "0", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], "0", "0", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], "0", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
       SuperscriptBox["q", "2"]}], 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}]}], " ", 
       SuperscriptBox["q", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         RowBox[{"2", " ", "q"}]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "q"}], ")"}]}], " ", 
       SuperscriptBox["q", "4"]}], "0", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "7"}], "+", 
         RowBox[{"5", " ", "q"}]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"]}], "0", "0", "0"},
     {
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"]}], " ", 
       SuperscriptBox["q", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "3"]}], 
      SuperscriptBox["q", "4"], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"]}], "0", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"]}], "0", "0"},
     {
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["q", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "q"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"3", " ", "q"}]}], ")"}]}], 
      RowBox[{"4", " ", 
       SuperscriptBox["q", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "q"}]}], ")"}]}], 
      RowBox[{"3", " ", 
       SuperscriptBox["q", "4"]}], "0", 
      RowBox[{
       RowBox[{"-", "6"}], " ", 
       SuperscriptBox["q", "4"]}], "0", 
      RowBox[{
       FractionBox["1", "24"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"23", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       FractionBox["1", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}]},
     {
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "2"]}], 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["q", "3"]}], 
      SuperscriptBox["q", "4"], "0", 
      RowBox[{"-", 
       SuperscriptBox["q", "4"]}], 
      RowBox[{"-", 
       SuperscriptBox["q", "4"]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "24"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "8"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "3"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox["q", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "q"}]}], ")"}]}], "0", 
      SuperscriptBox["q", "4"], 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["q", "4"]}], "0", 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["q", "4"]}], 
      RowBox[{
       FractionBox["1", "24"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       FractionBox["1", "8"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"7", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}]},
     {
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["q", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["q", "3"]}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], "0", "0", "0", "0", 
      RowBox[{
       FractionBox["1", "24"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       FractionBox["1", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       FractionBox["1", "3"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}]},
     {
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["q", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], "0", "0", 
      RowBox[{"-", 
       SuperscriptBox["q", "4"]}], "0", "0", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "24"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "8"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "3"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q"}], ")"}]}], 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox["q", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", 
         SuperscriptBox["q", "2"]}], ")"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{
  3.734700311644821*^9, 3.736691609519463*^9, {3.736765440760499*^9, 
   3.736765459718484*^9}, 
   3.741610077428256*^9},ExpressionUUID->"8cb1135f-9f6e-41aa-9a32-\
4f9550900d4f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "This", " ", "is", " ", "the", " ", "density", " ", "of", " ", "maximal", 
     " ", "elements", " ", "in", " ", "orbits", " ", "listed", " ", "as", " ", 
     RowBox[{"follows", ":", " ", "O14"}]}], ",", " ", "O131", ",", " ", 
    "O1212", ",", " ", "O22", ",", " ", "O1211", ",", " ", "O122", ",", " ", 
    "O1111", ",", " ", "O112", ",", " ", "O22", ",", " ", "O13", ",", " ", 
    "O4"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Densities", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"q", "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}], "*", 
         RowBox[{"(", 
          RowBox[{"q", "-", "1"}], ")"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"q", "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}], "*", 
         RowBox[{"(", 
          RowBox[{"q", "-", "1"}], ")"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"q", "^", 
          RowBox[{"(", 
           RowBox[{"-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"q", "-", "1"}], ")"}], "^", "2"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"q", "^", 
          RowBox[{"(", 
           RowBox[{"-", "2"}], ")"}]}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", "^", "2"}], "-", "1"}], ")"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"q", "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}], "*", 
         RowBox[{"(", 
          RowBox[{"q", "-", "1"}], ")"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"q", "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}], "*", 
         RowBox[{"(", 
          RowBox[{"q", "-", "1"}], ")"}]}], "}"}], ",", " ", 
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", "1", "}"}], ",", " ", 
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", "1", "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "The", " ", "Fourier", " ", "transform", " ", "is", " ", "the", " ", 
      "linear", " ", "combination", " ", "of", " ", "the", " ", "orbital", 
      " ", "exponential", " ", "sums"}], ",", " ", 
     RowBox[{
     "weighted", " ", "by", " ", "the", " ", "density", " ", "of", " ", 
      "maximal", " ", "elements"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FT", " ", "=", " ", 
     RowBox[{"Mmatrix", ".", "Densities"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"Simplify", "[", "FT", "]"}], "]"}], "]"}], ";"}]}]}]], "Input",\

 CellChangeTimes->{{3.736692263360519*^9, 3.736692483277011*^9}, {
  3.736692533753182*^9, 3.736692572557229*^9}, {3.7413476740937862`*^9, 
  3.741347697133471*^9}, {3.7413478387852592`*^9, 3.741347913375072*^9}, {
  3.7416103901461277`*^9, 
  3.741610392769712*^9}},ExpressionUUID->"61fdbe91-0f4e-494e-82ae-\
ba857bdfd897"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "4"], " ", "q", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "q"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", "q"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["q", "3"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "4"]}], "+", 
         SuperscriptBox["q", "5"]}], ")"}]}]},
     {
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"]}], " ", "q", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "q"}], ")"}], "4"]}]},
     {
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"]}], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"4", " ", "q"}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "3"]}]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", "q"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "2"]}]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", "q"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "2"]}]}], ")"}]}]},
     {
      RowBox[{"q", "+", 
       SuperscriptBox["q", "2"], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["q", "3"]}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["q", "4"]}], "+", 
       RowBox[{"5", " ", 
        SuperscriptBox["q", "5"]}], "-", 
       SuperscriptBox["q", "7"]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", "q"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "2"]}]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", "q"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "2"]}]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", "q"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "2"]}]}], ")"}]}]},
     {
      RowBox[{"q", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q", "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["q", "2"]}], "+", 
         SuperscriptBox["q", "3"]}], ")"}]}]},
     {
      RowBox[{"q", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q", "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["q", "2"]}], "+", 
         SuperscriptBox["q", "3"]}], ")"}]}]},
     {
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", "q"}]}], ")"}]}]},
     {
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "q"}], ")"}]}], " ", "q", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "q"}], ")"}], "2"]}]},
     {
      RowBox[{"q", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q", "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["q", "2"]}], "+", 
         SuperscriptBox["q", "3"]}], ")"}]}]},
     {
      RowBox[{"q", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "q", "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["q", "2"]}], "+", 
         SuperscriptBox["q", "3"]}], ")"}]}]},
     {
      RowBox[{"q", "+", 
       SuperscriptBox["q", "2"], "-", 
       SuperscriptBox["q", "3"]}]},
     {
      RowBox[{"q", "+", 
       SuperscriptBox["q", "2"], "-", 
       SuperscriptBox["q", "3"]}]},
     {
      RowBox[{"q", "+", 
       SuperscriptBox["q", "2"], "-", 
       SuperscriptBox["q", "3"]}]},
     {
      RowBox[{"q", "+", 
       SuperscriptBox["q", "2"], "-", 
       SuperscriptBox["q", "3"]}]},
     {
      RowBox[{"q", "+", 
       SuperscriptBox["q", "2"], "-", 
       SuperscriptBox["q", "3"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.7366924837066793`*^9, 3.736692573191536*^9, 3.736765464593315*^9, {
   3.7416100810521193`*^9, 
   3.741610084276691*^9}},ExpressionUUID->"c1991dfd-eb52-4d92-a546-\
44d4ca1bad8f"],

Cell[BoxData[
 RowBox[{
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "q"}], ")"}], "4"], " ", "q", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "q"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"3", " ", "q"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["q", "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["q", "3"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["q", "4"]}], "+", 
          SuperscriptBox["q", "5"]}], ")"}]}]},
      {
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"]}], " ", "q", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "q"}], ")"}], "4"]}]},
      {
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"]}], " ", "q", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"4", " ", "q"}], "+", 
          RowBox[{"6", " ", 
           SuperscriptBox["q", "2"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["q", "3"]}]}], ")"}]}]},
      {
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", "q", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"3", " ", "q"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["q", "2"]}]}], ")"}]}]},
      {
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", "q", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"3", " ", "q"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["q", "2"]}]}], ")"}]}]},
      {
       RowBox[{"q", "+", 
        SuperscriptBox["q", "2"], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["q", "3"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["q", "4"]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["q", "5"]}], "-", 
        SuperscriptBox["q", "7"]}]},
      {
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", "q", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"3", " ", "q"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["q", "2"]}]}], ")"}]}]},
      {
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", "q", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"3", " ", "q"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["q", "2"]}]}], ")"}]}]},
      {
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", "q", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"3", " ", "q"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["q", "2"]}]}], ")"}]}]},
      {
       RowBox[{"q", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "q", "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["q", "2"]}], "+", 
          SuperscriptBox["q", "3"]}], ")"}]}]},
      {
       RowBox[{"q", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "q", "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["q", "2"]}], "+", 
          SuperscriptBox["q", "3"]}], ")"}]}]},
      {
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", "q", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"3", " ", "q"}]}], ")"}]}]},
      {
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "q"}], ")"}]}], " ", "q", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "q"}], ")"}], "2"]}]},
      {
       RowBox[{"q", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "q", "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["q", "2"]}], "+", 
          SuperscriptBox["q", "3"]}], ")"}]}]},
      {
       RowBox[{"q", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "q", "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["q", "2"]}], "+", 
          SuperscriptBox["q", "3"]}], ")"}]}]},
      {
       RowBox[{"q", "+", 
        SuperscriptBox["q", "2"], "-", 
        SuperscriptBox["q", "3"]}]},
      {
       RowBox[{"q", "+", 
        SuperscriptBox["q", "2"], "-", 
        SuperscriptBox["q", "3"]}]},
      {
       RowBox[{"q", "+", 
        SuperscriptBox["q", "2"], "-", 
        SuperscriptBox["q", "3"]}]},
      {
       RowBox[{"q", "+", 
        SuperscriptBox["q", "2"], "-", 
        SuperscriptBox["q", "3"]}]},
      {
       RowBox[{"q", "+", 
        SuperscriptBox["q", "2"], "-", 
        SuperscriptBox["q", "3"]}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "\[LineSeparator]"}]], "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.7366924837066793`*^9, 3.736692573191536*^9, 
  3.736765464593315*^9, 
  3.7416100810521193`*^9},ExpressionUUID->"eb6d6ffc-3283-4d92-9737-\
cfb9d64e1808"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.741610089391848*^9, 3.741610127579077*^9}, {
  3.741610410394669*^9, 
  3.7416104177687693`*^9}},ExpressionUUID->"1f07bf10-b1b7-4a6d-8a9c-\
afecfdf6d05e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
    SuperscriptBox["q", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "q"}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "q", "+", 
      SuperscriptBox["q", "2"]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"]}], " ", 
    SuperscriptBox["q", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "q"}], ")"}], "2"]}], ",", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"], " ", 
    SuperscriptBox["q", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "q"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", "q", "+", 
      SuperscriptBox["q", "2"]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"]}], " ", 
    SuperscriptBox["q", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "q"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "q", "+", 
      SuperscriptBox["q", "2"]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
    SuperscriptBox["q", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "q"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "q"}], ")"}]}], " ", 
    SuperscriptBox["q", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", "q", "+", 
      SuperscriptBox["q", "2"]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"]}], " ", 
    SuperscriptBox["q", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "q"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
    SuperscriptBox["q", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "q"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
    SuperscriptBox["q", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "q"}], ")"}]}], ",", 
   RowBox[{"-", 
    SuperscriptBox["q", "2"]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
    SuperscriptBox["q", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["q", "2"]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"]}], " ", 
    SuperscriptBox["q", "2"]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
    SuperscriptBox["q", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "q"}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "q"}], ")"}], "3"], " ", 
    SuperscriptBox["q", "2"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "q"}], ")"}], "2"]}], " ", 
    SuperscriptBox["q", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "q"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["q", "2"]}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "q"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"3", " ", "q"}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "q"}], ")"}], " ", 
    SuperscriptBox["q", "2"]}], ",", 
   RowBox[{
    SuperscriptBox["q", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "q"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "q"}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["q", "2"]}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "q"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["q", "2"]}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "q"}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.741610128344364*^9},ExpressionUUID->"89d1e4a8-3ed1-4aa7-8777-\
f1b48c745e9d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
   "The", " ", "code", " ", "below", " ", "is", " ", "not", " ", "used", " ", 
    "in", " ", "the", " ", "proof"}], ",", " ", 
   RowBox[{
   "but", " ", "checks", " ", "Plancherel", " ", "for", " ", "the", " ", 
    "mod", " ", "p", " ", "orbital", " ", "exponential", " ", "sums", " ", 
    "used"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.741612467221258*^9, 
  3.741612511790663*^9}},ExpressionUUID->"970c2817-420a-4f95-9ecd-\
8293115d1d61"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FTO14", " ", "=", " ", 
   RowBox[{"Mmatrix", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "1"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FTO131", " ", "=", " ", 
   RowBox[{"Mmatrix", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", " ", "2"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FTO1212", " ", "=", " ", 
   RowBox[{"Mmatrix", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", " ", "3"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FTO22", " ", "=", " ", 
   RowBox[{"Mmatrix", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "4"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FTO1211", " ", "=", " ", 
   RowBox[{"Mmatrix", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "5"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FTO122", " ", "=", " ", 
   RowBox[{"Mmatrix", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "6"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FTO1111", " ", "=", " ", 
   RowBox[{"Mmatrix", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", " ", "7"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FTO112", " ", "=", " ", 
   RowBox[{"Mmatrix", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "8"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FTO22s", " ", "=", " ", 
   RowBox[{"Mmatrix", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "9"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FTO13", " ", "=", " ", 
   RowBox[{"Mmatrix", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", " ", "10"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FTO4", " ", "=", " ", 
   RowBox[{"Mmatrix", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", " ", "11"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SquareFTO14", " ", "=", " ", 
   RowBox[{"FTO14", " ", "*", " ", "FTO14"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SquareFTO131", " ", "=", " ", 
   RowBox[{"FTO131", " ", "*", " ", "FTO131"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SquareFTO1212", " ", "=", " ", 
   RowBox[{"FTO1212", " ", "*", " ", "FTO1212"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SquareFTO22", " ", "=", " ", 
   RowBox[{"FTO22", " ", "*", " ", "FTO22"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SquareFTO1211", " ", "=", " ", 
   RowBox[{"FTO1211", "*", "FTO1211"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SquareFTO122", " ", "=", " ", 
   RowBox[{"FTO122", " ", "*", " ", "FTO122"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SquareFTO1111", " ", "=", " ", 
   RowBox[{"FTO1111", "*", "FTO1111"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SquareFTO112", " ", "=", " ", 
   RowBox[{"FTO112", " ", "*", " ", "FTO112"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SquareFTO22s", " ", "=", " ", 
   RowBox[{"FTO22s", " ", "*", " ", "FTO22s"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SquareFTO13", " ", "=", " ", 
   RowBox[{"FTO13", " ", "*", " ", "FTO13"}]}], ";"}], "\[IndentingNewLine]", 

 RowBox[{
  RowBox[{
   RowBox[{"SquareFTO4", " ", "=", " ", 
    RowBox[{"FTO4", " ", "*", " ", "FTO4"}]}], ";"}], "\n", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "This", " ", "variable", " ", "stores", " ", "the", " ", "sizes", " ", 
      "of", " ", "the", " ", "20", " ", "mod"}], "-", 
     RowBox[{"p", " ", "orbits"}]}], ",", " ", 
    RowBox[{
    "in", " ", "the", " ", "order", " ", "listed", " ", "in", " ", "the", " ",
      "paper"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"modPorbitsizes", " ", "=", " ", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"q", "-", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"q", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"q", "^", "2"}], " ", "+", " ", "q", " ", "+", " ", "1"}], 
         ")"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"q", "-", "1"}], ")"}], "*", "q", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", "^", "2"}], " ", "+", " ", "q", " ", "+", " ", "1"}], 
          ")"}], "/", "2"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "-", "1"}], ")"}], "^", "2"}], "*", "q", "*", 
        RowBox[{"(", 
         RowBox[{"q", "+", "1"}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", "^", "2"}], "+", "q", "+", "1"}], ")"}], "/", "2"}]}],
        "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "-", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{"q", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"q", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"q", "^", "2"}], "+", "q", "+", "1"}], ")"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "-", "1"}], ")"}], "^", "2"}], "*", "q", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"q", "^", "2"}], "+", "q", "+", "1"}], ")"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "-", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{"q", "^", "3"}], "*", 
        RowBox[{"(", 
         RowBox[{"q", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"q", "^", "2"}], "+", "q", "+", "1"}], ")"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "-", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{"q", "^", "2"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", "^", "2"}], "+", "q", "+", "1"}], ")"}], "/", "2"}]}],
        "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "-", "1"}], ")"}], "^", "3"}], "*", 
        RowBox[{"q", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"q", "+", "1"}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", "^", "2"}], "+", "q", "+", "1"}], ")"}], "/", "2"}]}],
        "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "-", "1"}], ")"}], "^", "3"}], "*", 
        RowBox[{"q", "^", "2"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"q", "^", "2"}], "+", "q", "+", "1"}], ")"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "-", "1"}], ")"}], "^", "3"}], "*", 
        RowBox[{"q", "^", "3"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"q", "^", "2"}], "+", "q", "+", "1"}], ")"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "-", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{"q", "^", "4"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", "^", "2"}], "+", "q", "+", "1"}], ")"}], "/", "2"}]}],
        "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "-", "1"}], ")"}], "^", "3"}], "*", 
        RowBox[{"q", "^", "4"}], "*", 
        RowBox[{"(", 
         RowBox[{"q", "+", "1"}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", "^", "2"}], "+", "q", "+", "1"}], ")"}], "/", "2"}]}],
        "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "-", "1"}], ")"}], "^", "3"}], "*", 
        RowBox[{"q", "^", "4"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", "^", "2"}], "+", "q", "+", "1"}], ")"}], "/", "2"}]}],
        "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "-", "1"}], ")"}], "^", "3"}], "*", 
        RowBox[{"q", "^", "4"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", "^", "2"}], "+", "q", "+", "1"}], ")"}], "/", "2"}]}],
        "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "-", "1"}], ")"}], "^", "4"}], "*", 
        RowBox[{"q", "^", "4"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", "^", "2"}], "+", "q", "+", "1"}], ")"}], "/", 
         "24"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "-", "1"}], ")"}], "^", "4"}], "*", 
        RowBox[{"q", "^", "4"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", "^", "2"}], "+", "q", "+", "1"}], ")"}], "/", "4"}]}],
        "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "-", "1"}], ")"}], "^", "4"}], "*", 
        RowBox[{"q", "^", "4"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", "^", "2"}], "+", "q", "+", "1"}], ")"}], "/", "8"}]}],
        "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "-", "1"}], ")"}], "^", "4"}], "*", 
        RowBox[{"q", "^", "4"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", "^", "2"}], "+", "q", "+", "1"}], ")"}], "/", "3"}]}],
        "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "-", "1"}], ")"}], "^", "4"}], "*", 
        RowBox[{"q", "^", "4"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "1"}], ")"}], "^", "2"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", "^", "2"}], "+", "q", "+", "1"}], ")"}], "/", "4"}]}],
        "}"}]}], "}"}]}], ";"}], "\n"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.741610176959197*^9, 3.741610300546053*^9}, {
  3.7416104194429398`*^9, 3.741610420161283*^9}, {3.741610497968911*^9, 
  3.7416105178487577`*^9}, {3.7416106575350018`*^9, 3.741610815762183*^9}, {
  3.741610900043161*^9, 3.741610914548914*^9}, {3.741611184552796*^9, 
  3.7416111987442408`*^9}, {3.741611496514303*^9, 3.7416116302959557`*^9}, {
  3.741612437544191*^9, 
  3.741612438447773*^9}},ExpressionUUID->"65ba0067-1253-4173-8763-\
130d40e2510b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"PlancherelFTO14", " ", "=", " ", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "modPorbitsizes", "]"}], ".", "SquareFTO14"}],
      "-", 
     RowBox[{
      RowBox[{"q", "^", "12"}], "*", " ", 
      RowBox[{"modPorbitsizes", "[", 
       RowBox[{"[", "10", "]"}], "]"}]}]}], " ", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PlancherelFTO131", " ", "=", " ", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "modPorbitsizes", "]"}], ".", 
      "SquareFTO131"}], "-", 
     RowBox[{
      RowBox[{"q", "^", "12"}], "*", " ", 
      RowBox[{"modPorbitsizes", "[", 
       RowBox[{"[", "11", "]"}], "]"}]}]}], " ", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PlancherelFTO1212", " ", "=", " ", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "modPorbitsizes", "]"}], ".", 
      "SquareFTO1212"}], " ", "-", 
     RowBox[{
      RowBox[{"q", "^", "12"}], "*", " ", 
      RowBox[{"modPorbitsizes", "[", 
       RowBox[{"[", "12", "]"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PlancherelFTO22", " ", "=", " ", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "modPorbitsizes", "]"}], ".", "SquareFTO22"}],
      " ", "-", 
     RowBox[{
      RowBox[{"q", "^", "12"}], "*", " ", 
      RowBox[{"modPorbitsizes", "[", 
       RowBox[{"[", "13", "]"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PlancherelFTO1211", " ", "=", " ", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "modPorbitsizes", "]"}], ".", 
      "SquareFTO1211"}], " ", "-", 
     RowBox[{
      RowBox[{"q", "^", "12"}], "*", " ", 
      RowBox[{"modPorbitsizes", "[", 
       RowBox[{"[", "14", "]"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PlancherelFTO122", " ", "=", " ", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "modPorbitsizes", "]"}], ".", 
      "SquareFTO122"}], " ", "-", 
     RowBox[{
      RowBox[{"q", "^", "12"}], "*", " ", 
      RowBox[{"modPorbitsizes", "[", 
       RowBox[{"[", "15", "]"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PlancherelFTO1111", " ", "=", " ", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "modPorbitsizes", "]"}], ".", 
      "SquareFTO1111"}], " ", "-", 
     RowBox[{
      RowBox[{"q", "^", "12"}], "*", " ", 
      RowBox[{"modPorbitsizes", "[", 
       RowBox[{"[", "16", "]"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PlancherelFTO112", " ", "=", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "modPorbitsizes", "]"}], ".", 
      "SquareFTO112"}], " ", "-", 
     RowBox[{
      RowBox[{"q", "^", "12"}], "*", " ", 
      RowBox[{"modPorbitsizes", "[", 
       RowBox[{"[", "17", "]"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PlancherelFTO22s", " ", "=", " ", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "modPorbitsizes", "]"}], ".", 
      "SquareFTO22s"}], " ", "-", 
     RowBox[{
      RowBox[{"q", "^", "12"}], "*", " ", 
      RowBox[{"modPorbitsizes", "[", 
       RowBox[{"[", "18", "]"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PlancherelFTO13", " ", "=", " ", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "modPorbitsizes", "]"}], ".", "SquareFTO13"}],
      " ", "-", 
     RowBox[{
      RowBox[{"q", "^", "12"}], "*", " ", 
      RowBox[{"modPorbitsizes", "[", 
       RowBox[{"[", "19", "]"}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PlancherelFTO4", " ", "=", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "modPorbitsizes", "]"}], ".", "SquareFTO4"}], 
     "  ", "-", 
     RowBox[{
      RowBox[{"q", "^", "12"}], "*", " ", 
      RowBox[{"modPorbitsizes", "[", 
       RowBox[{"[", "20", "]"}], "]"}]}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7416109322572947`*^9, 3.7416110131860733`*^9}, {
  3.7416110439283667`*^9, 3.7416111456958323`*^9}, {3.741611202839241*^9, 
  3.741611222119412*^9}, {3.741611307966633*^9, 3.741611403470201*^9}, {
  3.741611717012611*^9, 3.741611774868169*^9}, {3.74161239738555*^9, 
  3.741612405928854*^9}},ExpressionUUID->"d13e2852-01ab-4bc5-8dd6-\
cf126356a307"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", "PlancherelFTO14", " ", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "PlancherelFTO131", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "PlancherelFTO1212", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", "PlancherelFTO22", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "PlancherelFTO1211", "]"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "PlancherelFTO122", "]"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "PlancherelFTO1111", "]"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "PlancherelFTO112", "]"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "PlancherelFTO22s", "]"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "PlancherelFTO13", "]"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", "PlancherelFTO4", "]"}], ";"}], " "}]}], "Input",
 CellChangeTimes->{{3.7416113208843737`*^9, 3.741611326630265*^9}, {
  3.7416118061529837`*^9, 
  3.741611952802414*^9}},ExpressionUUID->"b7798ef5-31af-4dfe-bae5-\
ec3103f459be"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Print",
 CellChangeTimes->{{3.741611327106573*^9, 3.7416113808935432`*^9}, 
   3.74161163904793*^9, 3.7416117225747223`*^9, 3.741611953308722*^9, 
   3.7416124107756777`*^9, 
   3.741612444054055*^9},ExpressionUUID->"68b6d60e-d429-4fe2-a20a-\
286995dac027"],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Print",
 CellChangeTimes->{{3.741611327106573*^9, 3.7416113808935432`*^9}, 
   3.74161163904793*^9, 3.7416117225747223`*^9, 3.741611953308722*^9, 
   3.7416124107756777`*^9, 
   3.7416124440554667`*^9},ExpressionUUID->"206ef090-4496-40c4-ad1c-\
7af577ffb300"],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Print",
 CellChangeTimes->{{3.741611327106573*^9, 3.7416113808935432`*^9}, 
   3.74161163904793*^9, 3.7416117225747223`*^9, 3.741611953308722*^9, 
   3.7416124107756777`*^9, 
   3.741612444056683*^9},ExpressionUUID->"b081bbbb-208b-4bc8-957d-\
8c7282bc25dc"],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Print",
 CellChangeTimes->{{3.741611327106573*^9, 3.7416113808935432`*^9}, 
   3.74161163904793*^9, 3.7416117225747223`*^9, 3.741611953308722*^9, 
   3.7416124107756777`*^9, 
   3.741612444057852*^9},ExpressionUUID->"3c96cd9a-e01c-48cf-b8b8-\
8557988b3d6a"],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Print",
 CellChangeTimes->{{3.741611327106573*^9, 3.7416113808935432`*^9}, 
   3.74161163904793*^9, 3.7416117225747223`*^9, 3.741611953308722*^9, 
   3.7416124107756777`*^9, 
   3.741612444058922*^9},ExpressionUUID->"5bcb11ad-099b-4eac-bcaf-\
7560b8e127c0"],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Print",
 CellChangeTimes->{{3.741611327106573*^9, 3.7416113808935432`*^9}, 
   3.74161163904793*^9, 3.7416117225747223`*^9, 3.741611953308722*^9, 
   3.7416124107756777`*^9, 
   3.741612444060026*^9},ExpressionUUID->"21db35e1-2a73-4abc-a13b-\
0ff8d70ce96a"],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Print",
 CellChangeTimes->{{3.741611327106573*^9, 3.7416113808935432`*^9}, 
   3.74161163904793*^9, 3.7416117225747223`*^9, 3.741611953308722*^9, 
   3.7416124107756777`*^9, 
   3.7416124440611897`*^9},ExpressionUUID->"515cba7d-0ef5-4b41-96c8-\
e3747d173d6b"],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Print",
 CellChangeTimes->{{3.741611327106573*^9, 3.7416113808935432`*^9}, 
   3.74161163904793*^9, 3.7416117225747223`*^9, 3.741611953308722*^9, 
   3.7416124107756777`*^9, 
   3.741612444062242*^9},ExpressionUUID->"9bd4a277-6ed6-446d-89a1-\
2a38ee430414"],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Print",
 CellChangeTimes->{{3.741611327106573*^9, 3.7416113808935432`*^9}, 
   3.74161163904793*^9, 3.7416117225747223`*^9, 3.741611953308722*^9, 
   3.7416124107756777`*^9, 
   3.74161244406334*^9},ExpressionUUID->"8f477c29-9327-4014-bb97-\
0972755c1b45"],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Print",
 CellChangeTimes->{{3.741611327106573*^9, 3.7416113808935432`*^9}, 
   3.74161163904793*^9, 3.7416117225747223`*^9, 3.741611953308722*^9, 
   3.7416124107756777`*^9, 
   3.741612444064443*^9},ExpressionUUID->"b483ab94-9835-468f-9ddd-\
d37413d391da"],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Print",
 CellChangeTimes->{{3.741611327106573*^9, 3.7416113808935432`*^9}, 
   3.74161163904793*^9, 3.7416117225747223`*^9, 3.741611953308722*^9, 
   3.7416124107756777`*^9, 
   3.74161244406564*^9},ExpressionUUID->"461b8a62-869d-4b56-b69c-\
f9ea2cfb7d9f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.741611409810424*^9, 3.741611418413774*^9}, {
  3.741611792436051*^9, 
  3.7416117980912237`*^9}},ExpressionUUID->"0c012775-62bd-455e-9c30-\
aa7ea02b4804"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "q"}], ")"}], "4"], " ", 
   SuperscriptBox["q", "4"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "q"}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "q", "+", 
     SuperscriptBox["q", "2"]}], ")"}]}], "}"}]], "Print",
 CellChangeTimes->{3.7416114192365503`*^9, 
  3.741611653900189*^9},ExpressionUUID->"e8d22979-3be8-4165-baa5-\
406199c98d4c"]
}, Open  ]]
},
WindowSize->{1834, 712},
WindowMargins->{{15, Automatic}, {Automatic, 130}},
PrintingOptions->{"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->True,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{54, 54}, {72, 72}}},
FrontEndVersion->"11.1 for Linux x86 (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 9648, 288, 1066, "Input", "ExpressionUUID" -> \
"23388703-d4fd-4796-8d38-e38934172339"],
Cell[10231, 312, 389, 10, 26, "Print", "ExpressionUUID" -> \
"caa671cf-a15e-4a89-a1be-bd5ea82906b0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10657, 327, 46494, 1262, 1301, "Input", "ExpressionUUID" -> \
"bea524a0-ac10-4228-a28f-fcbe4e21c708"],
Cell[57154, 1591, 52021, 1710, 565, "Print", "ExpressionUUID" -> \
"8cb1135f-9f6e-41aa-9a32-4f9550900d4f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[109212, 3306, 3216, 87, 126, "Input", "ExpressionUUID" -> \
"61fdbe91-0f4e-494e-82ae-ba857bdfd897"],
Cell[CellGroupData[{
Cell[112453, 3397, 5895, 196, 458, "Print", "ExpressionUUID" -> \
"c1991dfd-eb52-4d92-a546-44d4ca1bad8f"],
Cell[118351, 3595, 6087, 196, 492, "Print", "ExpressionUUID" -> \
"eb6d6ffc-3283-4d92-9737-cfb9d64e1808"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[124487, 3797, 203, 4, 32, "Input", "ExpressionUUID" -> \
"1f07bf10-b1b7-4a6d-8a9c-afecfdf6d05e"],
Cell[124693, 3803, 4551, 164, 71, "Output", "ExpressionUUID" -> \
"89d1e4a8-3ed1-4aa7-8777-f1b48c745e9d"]
}, Open  ]],
Cell[129259, 3970, 512, 12, 34, "Input", "ExpressionUUID" -> \
"970c2817-420a-4f95-9ecd-8293115d1d61"],
Cell[129774, 3984, 12693, 381, 1110, "Input", "ExpressionUUID" -> \
"65ba0067-1253-4173-8763-130d40e2510b"],
Cell[142470, 4367, 4650, 137, 264, "Input", "ExpressionUUID" -> \
"d13e2852-01ab-4bc5-8dd6-cf126356a307"],
Cell[CellGroupData[{
Cell[147145, 4508, 1358, 43, 264, "Input", "ExpressionUUID" -> \
"b7798ef5-31af-4dfe-bae5-ec3103f459be"],
Cell[CellGroupData[{
Cell[148528, 4555, 299, 6, 24, "Print", "ExpressionUUID" -> \
"68b6d60e-d429-4fe2-a20a-286995dac027"],
Cell[148830, 4563, 301, 6, 24, "Print", "ExpressionUUID" -> \
"206ef090-4496-40c4-ad1c-7af577ffb300"],
Cell[149134, 4571, 299, 6, 24, "Print", "ExpressionUUID" -> \
"b081bbbb-208b-4bc8-957d-8c7282bc25dc"],
Cell[149436, 4579, 299, 6, 24, "Print", "ExpressionUUID" -> \
"3c96cd9a-e01c-48cf-b8b8-8557988b3d6a"],
Cell[149738, 4587, 299, 6, 24, "Print", "ExpressionUUID" -> \
"5bcb11ad-099b-4eac-bcaf-7560b8e127c0"],
Cell[150040, 4595, 299, 6, 24, "Print", "ExpressionUUID" -> \
"21db35e1-2a73-4abc-a13b-0ff8d70ce96a"],
Cell[150342, 4603, 301, 6, 24, "Print", "ExpressionUUID" -> \
"515cba7d-0ef5-4b41-96c8-e3747d173d6b"],
Cell[150646, 4611, 299, 6, 24, "Print", "ExpressionUUID" -> \
"9bd4a277-6ed6-446d-89a1-2a38ee430414"],
Cell[150948, 4619, 298, 6, 24, "Print", "ExpressionUUID" -> \
"8f477c29-9327-4014-bb97-0972755c1b45"],
Cell[151249, 4627, 299, 6, 24, "Print", "ExpressionUUID" -> \
"b483ab94-9835-468f-9ddd-d37413d391da"],
Cell[151551, 4635, 298, 6, 24, "Print", "ExpressionUUID" -> \
"461b8a62-869d-4b56-b69c-f9ea2cfb7d9f"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[151898, 4647, 203, 4, 32, "Input", "ExpressionUUID" -> \
"0c012775-62bd-455e-9c30-aa7ea02b4804"],
Cell[152104, 4653, 535, 17, 42, "Print", "ExpressionUUID" -> \
"e8d22979-3be8-4165-baa5-406199c98d4c"]
}, Open  ]]
}
]
*)

