(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     71839,       2154]
NotebookOptionsPosition[     67608,       2042]
NotebookOutlinePosition[     67943,       2057]
CellTagsIndexPosition[     67900,       2054]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "This", " ", "file", " ", "checks", " ", "the", " ", "stabilizers", " ", 
    "of", " ", "the", " ", "modulo", " ", "p", " ", "orbits"}], ",", " ", 
   RowBox[{
   "all", " ", "zeros", " ", "means", " ", "that", " ", "the", " ", "form", 
    " ", "is", " ", "unchanged"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.74117336620107*^9, 3.741173382538455*^9}, {
  3.7411737318402452`*^9, 
  3.741173738272189*^9}},ExpressionUUID->"425ba406-7e62-4307-9943-\
c287e38a6958"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Check", " ", "of", " ", "stabilizer", " ", "of", " ", "standard", " ", 
    "representative", " ", "of", " ", "orbit", " ", "OD12"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"e", ",", "f", ",", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", "x"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", "y"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"t", "^", "2"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A", " ", "-", " ", "A2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B", "-", "B2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"A3", ",", " ", "B3"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.73359167771329*^9, 3.7335917747592487`*^9}, {
  3.7411734117392*^9, 
  3.741173437411269*^9}},ExpressionUUID->"75f1091b-899f-4fec-8585-\
a39a99a794dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}],
  SequenceForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, {{0, 0, 0}, {0, 0, 0}, {0, 
   0, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.733591775574552*^9, 3.741173440966989*^9, 
  3.7411735590648518`*^9},ExpressionUUID->"b760cac6-0b6e-45e3-bd59-\
a63e58314ca5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Check", " ", "of", " ", "stabilizer", " ", "of", " ", "standard", " ", 
     "representative", " ", "of", " ", "orbit", " ", "OD11"}], ",", " ", 
    RowBox[{"part", " ", "1"}]}], "*)"}], " ", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "s", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "0", ",", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", "x"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", "y"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"s", "*", "t"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A", " ", "-", " ", "A2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B", "-", "B2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"A3", ",", " ", "B3"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.73359179150347*^9, 3.733591848783021*^9}, {
  3.74117345355663*^9, 
  3.741173470418407*^9}},ExpressionUUID->"b676be80-b7ca-4cab-8579-\
5663902a356a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}],
  SequenceForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, {{0, 0, 0}, {0, 0, 0}, {0, 
   0, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.741172954581862*^9, 
  3.741173555173291*^9},ExpressionUUID->"644cf5c1-f5ce-44ae-8411-\
6a456e5bb7e3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Check", " ", "of", " ", "stabilizer", " ", "of", " ", "standard", " ", 
     "representative", " ", "of", " ", "orbit", " ", "OD11"}], ",", " ", 
    RowBox[{"part", " ", "2"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "0", ",", "s"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "t", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", "x"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", "y"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"s", "*", "t"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A", " ", "-", " ", "A2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B", "-", "B2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"A3", ",", " ", "B3"}], "]"}], "\[IndentingNewLine]"}]}]], "Input",\

 CellChangeTimes->{{3.741172920871333*^9, 3.7411729455097113`*^9}, {
  3.7411734810926447`*^9, 
  3.7411734837622547`*^9}},ExpressionUUID->"57cd8ca4-9e5b-4671-a358-\
8397b64bc305"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}],
  SequenceForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, {{0, 0, 0}, {0, 0, 0}, {0, 
   0, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.733591850076385*^9, 3.741172957825219*^9, 
  3.741173552299737*^9},ExpressionUUID->"21e20651-c0ba-4e29-bfe2-\
0a9c143885e9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Check", " ", "of", " ", "stabilizer", " ", "of", " ", "standard", " ", 
     "representative", " ", "of", " ", "orbit", " ", "OD2"}], ",", " ", 
    RowBox[{"part", " ", "1"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", "ell"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "c", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", 
         RowBox[{"ell", " ", "*", "e"}], ",", "c"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", "x"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", "y"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "^", "2"}], " ", "-", " ", 
        RowBox[{"ell", " ", "*", " ", 
         RowBox[{"e", "^", "2"}]}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A", " ", "-", " ", "A2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B", "-", "B2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"A3", ",", " ", "B3"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7335906653060637`*^9, 3.733590912516749*^9}, {
  3.7335909463335*^9, 3.7335911024596148`*^9}, {3.733591150763879*^9, 
  3.733591288490711*^9}, {3.73359132497198*^9, 3.733591362154263*^9}, {
  3.733591684545039*^9, 3.733591689360148*^9}, {3.7411731299727983`*^9, 
  3.7411731319487247`*^9}, {3.7411734882836647`*^9, 
  3.7411734999461308`*^9}},ExpressionUUID->"4619bf8a-3101-4dc2-af27-\
a179db3952c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}],
  SequenceForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, {{0, 0, 0}, {0, 0, 0}, {0, 
   0, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733590913169796*^9, 3.73359112478192*^9, {3.733591165895705*^9, 
   3.733591223134499*^9}, {3.733591262813055*^9, 3.7335912890580187`*^9}, {
   3.733591337441613*^9, 3.7335913635519648`*^9}, 3.7411731323284883`*^9, 
   3.7411735496611547`*^9},ExpressionUUID->"08b0a8a9-47b9-4e6f-88d8-\
5fbc2ed66044"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Check", " ", "of", " ", "stabilizer", " ", "of", " ", "standard", " ", 
     "representative", " ", "of", " ", "orbit", " ", "OD2"}], ",", " ", 
    RowBox[{"part", " ", "2"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", "ell"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "c", ",", "e"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", 
         RowBox[{
          RowBox[{"-", "ell"}], " ", "*", "e"}], ",", 
         RowBox[{"-", "c"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", "x"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", "y"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "^", "2"}], " ", "-", " ", 
        RowBox[{"ell", " ", "*", " ", 
         RowBox[{"e", "^", "2"}]}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A", " ", "-", " ", "A2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B", "-", "B2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"A3", ",", " ", "B3"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.741173507474415*^9, 
  3.741173514050433*^9}},ExpressionUUID->"1ca9b016-60e3-4bea-80ac-\
07b96beb71e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}],
  SequenceForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, {{0, 0, 0}, {0, 0, 0}, {0, 
   0, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.7411731349615307`*^9, 
  3.741173547309828*^9},ExpressionUUID->"0a80e372-29f1-4e75-a56d-\
dfb821c8d013"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{
  3.7411731115483913`*^9},ExpressionUUID->"fe5a6be1-e692-4b50-96f8-\
77e98497a295"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Check", " ", "of", " ", "stabilizer", " ", "of", " ", "standard", " ", 
    "representative", " ", "of", " ", "orbit", " ", "OCs"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "s", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "c", ",", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"t", "^", "2"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "c"}], "/", 
       RowBox[{"(", 
        RowBox[{"s", " ", "*", " ", 
         RowBox[{"t", "^", "2"}]}], ")"}]}], ")"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"s", "*", "t"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A", " ", "-", " ", "A2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B", "-", "B2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"A3", ",", " ", "B3"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.733591523433132*^9, 3.7335916212166977`*^9}, {
  3.733591696800634*^9, 3.733591700191904*^9}, {3.741173520148941*^9, 
  3.741173526851111*^9}},ExpressionUUID->"e84c3152-942e-4787-8ebe-\
ec644ed876ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}],
  SequenceForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, {{0, 0, 0}, {0, 0, 0}, {0, 
   0, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7335916030954313`*^9, 3.733591621697773*^9}, 
   3.741173162179916*^9, 
   3.741173544438105*^9},ExpressionUUID->"3aa1cb26-2a59-432d-ad09-\
1e63f6e3e31c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Check", " ", "of", " ", "stabilizer", " ", "of", " ", "standard", " ", 
    "representative", " ", "of", " ", "orbit", " ", "O14"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], "*", "a", "*", 
          RowBox[{"s", "/", "t"}]}], ",", "t", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "a", ",", 
         RowBox[{
          RowBox[{"t", "^", "2"}], "/", "s"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{
      RowBox[{"s", "^", "2"}], "/", 
      RowBox[{"(", 
       RowBox[{"t", "^", "4"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"t", "^", "2"}], "/", "s"}]}], " ", "+", " ", 
         RowBox[{"a", "^", "2"}]}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"s", "^", "2"}], "/", 
       RowBox[{"t", "^", "6"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"t", "^", "2"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A", " ", "-", " ", "A2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B", "-", "B2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"A3", ",", " ", "B3"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.733591919326653*^9, 3.733592045389813*^9}, {
  3.74117353427566*^9, 
  3.741173542057974*^9}},ExpressionUUID->"f9d74fe6-3417-47e8-a3e1-\
f272ee8b5cbc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}],
  SequenceForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, {{0, 0, 0}, {0, 0, 0}, {0, 
   0, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.733592047086761*^9, 
  3.7411731710614977`*^9},ExpressionUUID->"c0b517ad-918a-4d2a-99c9-\
727a1313d024"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Check", " ", "of", " ", "stabilizer", " ", "of", " ", "standard", " ", 
    "representative", " ", "of", " ", "orbit", " ", "O131"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "t", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{
          RowBox[{"t", "^", "2"}], "/", "s"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"s", "/", 
      RowBox[{"(", 
       RowBox[{"t", "^", "3"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", 
     RowBox[{
      RowBox[{"-", "a"}], "/", 
      RowBox[{"t", "^", "3"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"t", "^", "2"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A", " ", "-", " ", "A2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B", "-", "B2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"A3", ",", " ", "B3"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.733592068925807*^9, 3.733592161084978*^9}, {
  3.7411735710433283`*^9, 
  3.741173577761775*^9}},ExpressionUUID->"79c2c2d9-aeaf-4fbb-8b50-\
f3b3e599d25b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}],
  SequenceForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, {{0, 0, 0}, {0, 0, 0}, {0, 
   0, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.733592161685513*^9, 
  3.741173187839683*^9},ExpressionUUID->"435ae827-f7a8-430e-8a63-\
2527e708b8b4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Check", " ", "of", " ", "stabilizer", " ", "of", " ", "standard", " ", 
     "representative", " ", "of", " ", "orbit", " ", "O1212"}], ",", " ", 
    RowBox[{"part", " ", "1"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "s", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"t", "^", "2"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"r", "*", "s"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A", " ", "-", " ", "A2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B", "-", "B2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"A3", ",", " ", "B3"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.733592191996876*^9, 3.733592323412257*^9}, {
  3.741173224133198*^9, 3.741173230116129*^9}, {3.741173581371332*^9, 
  3.741173599297352*^9}},ExpressionUUID->"1981b08f-fcca-4625-9d5b-\
bdf420301fd4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}],
  SequenceForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, {{0, 0, 0}, {0, 0, 0}, {0, 
   0, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7335923009344683`*^9, 3.7335923238841887`*^9}, {
   3.7411732074749804`*^9, 3.741173230667303*^9}, 
   3.7411737275294437`*^9},ExpressionUUID->"5fe0e34a-35b5-49b6-a516-\
98f4f0479ab6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Check", " ", "of", " ", "stabilizer", " ", "of", " ", "standard", " ", 
     "representative", " ", "of", " ", "orbit", " ", "O1212"}], ",", " ", 
    RowBox[{"part", " ", "2"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "r", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"s", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"t", "^", "2"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"r", "*", "s"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A", " ", "-", " ", "A2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B", "-", "B2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"A3", ",", " ", "B3"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.741173603723254*^9, 
  3.741173617713286*^9}},ExpressionUUID->"06474944-57ad-4a31-99d7-\
45716dfebb2b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}],
  SequenceForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, {{0, 0, 0}, {0, 0, 0}, {0, 
   0, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741173234383415*^9},ExpressionUUID->"a93031a9-d763-4cf3-a94e-\
1dd4d9e1e82e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Check", " ", "of", " ", "stabilizer", " ", "of", " ", "standard", " ", 
     "representative", " ", "of", " ", "orbit", " ", "O22"}], ",", " ", 
    RowBox[{"part", " ", "1"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"c", ",", "e", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ell", "*", "e"}], ",", "c", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "s"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"s", "^", "2"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "^", "2"}], " ", "-", " ", 
        RowBox[{"ell", " ", "*", " ", 
         RowBox[{"e", "^", "2"}]}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A", " ", "-", " ", "A2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B", "-", "B2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"A3", ",", " ", "B3"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.733592401171504*^9, 3.733592490066882*^9}, {
  3.7411732543479357`*^9, 3.741173256619707*^9}, {3.741173624043062*^9, 
  3.741173638465384*^9}},ExpressionUUID->"adf60859-411e-4762-8864-\
526ae687dfb7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}],
  SequenceForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, {{0, 0, 0}, {0, 0, 0}, {0, 
   0, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.733592475297531*^9, 3.7335924912221327`*^9}, 
   3.7411732570779552`*^9, 3.741173308435954*^9, 
   3.741173724255015*^9},ExpressionUUID->"45182ee9-0d8b-4279-bb5c-\
a10932fbd4b6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Check", " ", "of", " ", "stabilizer", " ", "of", " ", "standard", " ", 
     "representative", " ", "of", " ", "orbit", " ", "O22"}], ",", " ", 
    RowBox[{"part", " ", "2"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"c", ",", "e", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "ell"}], "*", "e"}], ",", 
         RowBox[{"-", "c"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "s"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"s", "^", "2"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "^", "2"}], " ", "-", " ", 
        RowBox[{"ell", " ", "*", " ", 
         RowBox[{"e", "^", "2"}]}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A", " ", "-", " ", "A2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B", "-", "B2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"A3", ",", " ", "B3"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.741173642858713*^9, 
  3.741173650297216*^9}},ExpressionUUID->"d073af81-45f2-43bd-baec-\
ff668d662f35"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}],
  SequenceForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, {{0, 0, 0}, {0, 0, 0}, {0, 
   0, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.7411732508288918`*^9, 3.741173305161065*^9, 
  3.7411737210580482`*^9},ExpressionUUID->"827907e9-b5aa-4967-833e-\
a0c62b5ed54a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Check", " ", "of", " ", "stabilizer", " ", "of", " ", "standard", " ", 
     "representative", " ", "of", " ", "orbit", " ", "O1211"}], ",", " ", 
    RowBox[{"part", " ", "1"}]}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "t", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"t", "^", "2"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"s", "*", "t"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A", " ", "-", " ", "A2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B", "-", "B2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"A3", ",", " ", "B3"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.733592525562799*^9, 3.733592604251422*^9}, 
   3.741173335043324*^9, {3.741173655490769*^9, 
   3.741173666553356*^9}},ExpressionUUID->"238dbc69-4ca8-46c7-9ab2-\
89a338210f34"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}],
  SequenceForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, {{0, 0, 0}, {0, 0, 0}, {0, 
   0, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7335925974975557`*^9, 3.7335926046213913`*^9}, 
   3.7411733355072803`*^9, 
   3.7411737179879227`*^9},ExpressionUUID->"6d471139-687b-4784-9547-\
e56d1024c283"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Check", " ", "of", " ", "stabilizer", " ", "of", " ", "standard", " ", 
     "representative", " ", "of", " ", "orbit", " ", "O1211"}], ",", " ", 
    RowBox[{"part", " ", "2"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "t"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"t", "^", "2"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"s", "*", "t"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A", " ", "-", " ", "A2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B", "-", "B2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"A3", ",", " ", "B3"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.741173671754549*^9, 
  3.7411736806891747`*^9}},ExpressionUUID->"d170aaba-c391-49f8-b036-\
510289c5cf09"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}],
  SequenceForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, {{0, 0, 0}, {0, 0, 0}, {0, 
   0, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.741173338336907*^9, 
  3.74117371503631*^9},ExpressionUUID->"d32c01c9-6423-4cbc-9390-53b43e23aaed"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Check", " ", "of", " ", "stabilizer", " ", "of", " ", "standard", " ", 
     "representative", " ", "of", " ", "orbit", " ", "O122"}], ",", " ", 
    RowBox[{"part", " ", "1"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", "ell"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "t", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"t", "^", "2"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"s", "*", "t"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A", " ", "-", " ", "A2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B", "-", "B2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"A3", ",", " ", "B3"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.733592647354113*^9, 3.733592684923101*^9}, {
  3.7411736859466667`*^9, 
  3.741173694256888*^9}},ExpressionUUID->"b558ba4c-ae76-4849-9ec7-\
0a50616a6f45"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}],
  SequenceForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, {{0, 0, 0}, {0, 0, 0}, {0, 
   0, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.733592659194799*^9, 3.733592685520442*^9}, 
   3.7411733450800543`*^9, 
   3.741173712604*^9},ExpressionUUID->"72c6d52d-2807-4794-a239-970d0689c230"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Check", " ", "of", " ", "stabilizer", " ", "of", " ", "standard", " ", 
     "representative", " ", "of", " ", "orbit", " ", "O122"}], ",", " ", 
    RowBox[{"part", " ", "2"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", "ell"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "t"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"t", "^", "2"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"s", "*", "t"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A", " ", "-", " ", "A2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B", "-", "B2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"A3", ",", " ", "B3"}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.741173358426931*^9, {3.741173698362496*^9, 
   3.7411737059449797`*^9}},ExpressionUUID->"cbc00f49-543c-4433-b4a7-\
5d8b49df76ab"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "\[InvisibleSpace]", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}],
  SequenceForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, {{0, 0, 0}, {0, 0, 0}, {0, 
   0, 0}}],
  Editable->False]], "Print",
 CellChangeTimes->{3.741173358969317*^9, 
  3.741173710104219*^9},ExpressionUUID->"27ab352a-4d99-48a9-8b1e-\
2351376a0698"]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{Automatic, 550}, {8, Automatic}},
FrontEndVersion->"11.1 for Linux x86 (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 529, 12, 56, "Input", "ExpressionUUID" -> \
"425ba406-7e62-4307-9943-c287e38a6958"],
Cell[CellGroupData[{
Cell[1112, 36, 2986, 85, 355, "Input", "ExpressionUUID" -> \
"75f1091b-899f-4fec-8585-a39a99a794dc"],
Cell[4101, 123, 844, 25, 26, "Print", "ExpressionUUID" -> \
"b760cac6-0b6e-45e3-bd59-a63e58314ca5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4982, 153, 3107, 88, 356, "Input", "ExpressionUUID" -> \
"b676be80-b7ca-4cab-8579-5663902a356a"],
Cell[8092, 243, 820, 25, 26, "Print", "ExpressionUUID" -> \
"644cf5c1-f5ce-44ae-8411-6a456e5bb7e3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8949, 273, 3135, 89, 378, "Input", "ExpressionUUID" -> \
"57cd8ca4-9e5b-4671-a358-8397b64bc305"],
Cell[12087, 364, 842, 25, 26, "Print", "ExpressionUUID" -> \
"21e20651-c0ba-4e29-bfe2-0a9c143885e9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12966, 394, 3465, 94, 356, "Input", "ExpressionUUID" -> \
"4619bf8a-3101-4dc2-af27-a179db3952c8"],
Cell[16434, 490, 1021, 28, 26, "Print", "ExpressionUUID" -> \
"08b0a8a9-47b9-4e6f-88d8-5fbc2ed66044"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17492, 523, 3215, 91, 356, "Input", "ExpressionUUID" -> \
"1ca9b016-60e3-4bea-80ac-07b96beb71e4"],
Cell[20710, 616, 822, 25, 26, "Print", "ExpressionUUID" -> \
"0a80e372-29f1-4e75-a56d-dfb821c8d013"]
}, Open  ]],
Cell[21547, 644, 130, 3, 32, "Input", "ExpressionUUID" -> \
"fe5a6be1-e692-4b50-96f8-77e98497a295"],
Cell[CellGroupData[{
Cell[21702, 651, 3352, 97, 355, "Input", "ExpressionUUID" -> \
"e84c3152-942e-4787-8ebe-ec644ed876ba"],
Cell[25057, 750, 873, 26, 26, "Print", "ExpressionUUID" -> \
"3aa1cb26-2a59-432d-ad09-1e63f6e3e31c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25967, 781, 3633, 107, 355, "Input", "ExpressionUUID" -> \
"f9d74fe6-3417-47e8-a3e1-f272ee8b5cbc"],
Cell[29603, 890, 822, 25, 26, "Print", "ExpressionUUID" -> \
"c0b517ad-918a-4d2a-99c9-727a1313d024"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30462, 920, 3327, 97, 355, "Input", "ExpressionUUID" -> \
"79c2c2d9-aeaf-4fbb-8b50-f3b3e599d25b"],
Cell[33792, 1019, 820, 25, 26, "Print", "ExpressionUUID" -> \
"435ae827-f7a8-430e-8a63-2527e708b8b4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34649, 1049, 3232, 91, 356, "Input", "ExpressionUUID" -> \
"1981b08f-fcca-4625-9d5b-bdf420301fd4"],
Cell[37884, 1142, 903, 26, 26, "Print", "ExpressionUUID" -> \
"5fe0e34a-35b5-49b6-a516-98f4f0479ab6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38824, 1173, 3137, 90, 356, "Input", "ExpressionUUID" -> \
"06474944-57ad-4a31-99d7-45716dfebb2b"],
Cell[41964, 1265, 798, 25, 26, "Print", "ExpressionUUID" -> \
"a93031a9-d763-4cf3-a94e-1dd4d9e1e82e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42799, 1295, 3341, 94, 356, "Input", "ExpressionUUID" -> \
"adf60859-411e-4762-8864-526ae687dfb7"],
Cell[46143, 1391, 897, 26, 26, "Print", "ExpressionUUID" -> \
"45182ee9-0d8b-4279-bb5c-a10932fbd4b6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47077, 1422, 3295, 95, 356, "Input", "ExpressionUUID" -> \
"d073af81-45f2-43bd-baec-ff668d662f35"],
Cell[50375, 1519, 846, 25, 26, "Print", "ExpressionUUID" -> \
"827907e9-b5aa-4967-833e-a0c62b5ed54a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51258, 1549, 3209, 91, 356, "Input", "ExpressionUUID" -> \
"238dbc69-4ca8-46c7-9ab2-89a338210f34"],
Cell[54470, 1642, 879, 26, 26, "Print", "ExpressionUUID" -> \
"6d471139-687b-4784-9547-e56d1024c283"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55386, 1673, 3186, 91, 356, "Input", "ExpressionUUID" -> \
"d170aaba-c391-49f8-b036-510289c5cf09"],
Cell[58575, 1766, 817, 24, 26, "Print", "ExpressionUUID" -> \
"d32c01c9-6423-4cbc-9390-53b43e23aaed"]
}, Open  ]],
Cell[CellGroupData[{
Cell[59429, 1795, 3215, 92, 356, "Input", "ExpressionUUID" -> \
"b558ba4c-ae76-4849-9ec7-0a50616a6f45"],
Cell[62647, 1889, 868, 25, 26, "Print", "ExpressionUUID" -> \
"72c6d52d-2807-4794-a239-970d0689c230"]
}, Open  ]],
Cell[CellGroupData[{
Cell[63552, 1919, 3217, 93, 356, "Input", "ExpressionUUID" -> \
"cbc00f49-543c-4433-b4a7-5d8b49df76ab"],
Cell[66772, 2014, 820, 25, 26, "Print", "ExpressionUUID" -> \
"27ab352a-4d99-48a9-8b1e-2351376a0698"]
}, Open  ]]
}
]
*)

