(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     76984,       2052]
NotebookOptionsPosition[     73610,       1972]
NotebookOutlinePosition[     73944,       1987]
CellTagsIndexPosition[     73901,       1984]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "This", " ", "file", " ", "calculates", " ", "the", " ", "inner", " ", 
    "product", " ", "pairings", " ", "for", " ", "the", " ", "mod", " ", "p", 
    " ", "orbits", " ", "O22", " ", "and", " ", "OD11"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22", ",", " ", "a11", ",", " ", "a12", ",", " ", "a13", ",", " ",
       "a21", ",", " ", "a22", ",", " ", "a23", ",", " ", "a31", ",", " ", 
      "a32", ",", " ", "a33", ",", " ", "b11", ",", " ", "b12", ",", " ", 
      "b21", ",", " ", "b22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O22", " ", "=", " ", "Ox"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OD11", " ", "=", " ", "Oxi"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Gact3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", 
         RowBox[{"lam", " ", "*", " ", "ell", " ", "*", " ", "c"}], ",", " ", 
         "a13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", 
         RowBox[{"lam", " ", "*", " ", "a"}], ",", "a23"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "a33"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Gact2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"b11", ",", " ", "b12"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "b22"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x01", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x02", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "x01", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "x02", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.733834040192012*^9, 3.73383417454156*^9}, {
  3.73383429054252*^9, 3.733834334668531*^9}, {3.7338369238216963`*^9, 
  3.733836959732308*^9}, {3.7338375934586*^9, 3.733837605217167*^9}, {
  3.733837648713428*^9, 3.733837681840667*^9}, {3.733844525192297*^9, 
  3.73384453085526*^9}, {3.7338447984548264`*^9, 3.733844888060855*^9}, {
  3.733952241066725*^9, 3.733952256226048*^9}, {3.741340106770097*^9, 
  3.741340119057629*^9}},ExpressionUUID->"0ab6eecb-85a6-43a5-b259-\
6da0e11b6e77"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0"},
       {"0", 
        RowBox[{"-", "ell"}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{1, 0, 0}, {0, -$CellContext`ell, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.733836933925782*^9, 3.733836960154544*^9}, 
   3.733837683012678*^9, 3.73384332478533*^9, 3.733844540632078*^9, 
   3.733848105406208*^9, 3.7338482845334167`*^9, 3.7338553231148663`*^9, 
   3.73395225755704*^9, 
   3.7339527833221607`*^9},ExpressionUUID->"5ac7d6e1-95ad-4201-bf71-\
bf0f4f653971"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"xiTable", " ", "=", " ", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"2", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"3", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"4", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"5", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"6", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "ell"}], ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"7", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"8", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"9", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"10", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"11", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"12", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"13", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"14", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"15", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"ell", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"16", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"17", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"18", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"ell", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"19", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"20", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Length", "[", "xiTable", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.733838846527213*^9, 3.7338389816092587`*^9}, {
  3.733840103914178*^9, 3.733840549544438*^9}, {3.733841144204008*^9, 
  3.7338411725242*^9}, {3.7338413258745413`*^9, 3.733841449707015*^9}, {
  3.733841647641047*^9, 3.73384165992979*^9}, {3.733841696696742*^9, 
  3.7338417267768*^9}, {3.733841759687078*^9, 3.733841842029541*^9}, {
  3.7338419005518093`*^9, 3.733841964896893*^9}, {3.7338420077764807`*^9, 
  3.733842494494863*^9}, {3.7338425291580353`*^9, 3.73384253410826*^9}, {
  3.733842581916871*^9, 3.7338425987478943`*^9}, {3.7338430232754297`*^9, 
  3.733843031201666*^9}, {3.733844913873358*^9, 3.7338453491727448`*^9}, {
  3.733845380445448*^9, 3.7338454511606073`*^9}, {3.733855265609296*^9, 
  3.733855265864771*^9}},ExpressionUUID->"a1328c47-477e-4819-a4f3-\
770f5c69c665"],

Cell[BoxData["20"], "Print",
 CellChangeTimes->{
  3.733842534647914*^9, {3.733842587078554*^9, 3.733842599520444*^9}, 
   3.733843032008008*^9, 3.733843272133623*^9, 3.733844546037567*^9, 
   3.7338454536065407`*^9, 3.733848287081184*^9, 3.7338552668739157`*^9, 
   3.733855325586875*^9, 3.733952261029447*^9, 
   3.733952786367536*^9},ExpressionUUID->"3e96c9fa-cb68-432c-87aa-\
22990e6404bb"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"xiTable", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.733843261533099*^9, 
  3.7338432667507677`*^9}},ExpressionUUID->"fac583cf-f81b-45d6-af06-\
be36a7bf82cf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Input",
 CellChangeTimes->{
  3.73384545735244*^9},ExpressionUUID->"17c19ae3-8b14-4a7b-87d3-a9785c6879a7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.733845457474152*^9, 
  3.7338482900547237`*^9},ExpressionUUID->"919909dd-249c-43e6-9c55-\
2fec822414af"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", " ", 
   RowBox[{"i", "\[LessEqual]", 
    RowBox[{"Length", "[", "xiTable", "]"}]}], ",", " ", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Orbit", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"xi11", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", " ", "2"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xi12", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "3"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"xiACT31", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi11", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT32", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi12", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT1", " ", "=", " ", 
     RowBox[{
      RowBox[{"b11", " ", "*", " ", "xiACT31"}], " ", "+", " ", 
      RowBox[{"b12", " ", "*", " ", "xiACT32"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT2", " ", "=", " ", 
     RowBox[{"b22", " ", "*", " ", "xiACT32"}]}], ";", "\[IndentingNewLine]", 
    
    RowBox[{"Pairing", " ", "=", " ", 
     RowBox[{
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x01", "]"}], ".", "xiACT1"}], "]"}], "+", 
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x02", "]"}], ".", "xiACT2"}], "]"}]}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"Orbit", ",", " ", "\"\<\\n\>\"", ",", 
      RowBox[{"MatrixForm", "[", "xi11", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "xi12", "]"}], ",", "\"\<\\n\>\"", ",", " ", 
      
      RowBox[{"Expand", "[", "Pairing", "]"}], ",", " ", "\"\<\\n\>\""}], 
     "]"}], ";"}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.7338344558294764`*^9, 3.733834473411776*^9}, {
   3.733836101706242*^9, 3.733836173825585*^9}, {3.7338362479212427`*^9, 
   3.733836338560684*^9}, {3.7338364006081953`*^9, 3.7338364411760187`*^9}, 
   3.733836754125835*^9, {3.733836844957556*^9, 3.733836903589159*^9}, {
   3.733836976822104*^9, 3.733837134583942*^9}, {3.733837278606353*^9, 
   3.7338373093731728`*^9}, {3.7338430584741707`*^9, 3.733843230695416*^9}, {
   3.7338433049029493`*^9, 3.733843379702538*^9}, {3.733843573077908*^9, 
   3.733843576709671*^9}, {3.733845464068016*^9, 3.733845483700639*^9}, {
   3.733848262016873*^9, 3.733848265786736*^9}, {3.733952282581514*^9, 
   3.733952284872563*^9}, {3.733952635170582*^9, 
   3.7339526824060087`*^9}},ExpressionUUID->"f2152389-cce6-4840-babe-\
ef53273317ac"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{
     SuperscriptBox["a13", "2"], " ", "b22"}], "-", 
    RowBox[{
     SuperscriptBox["a23", "2"], " ", "b22", " ", "ell"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[1, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a13^2 \
$CellContext`b22 - $CellContext`a23^2 $CellContext`b22 $CellContext`ell, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733952789907468*^9},ExpressionUUID->"7b9cd1e6-2694-4e27-8802-\
ea344ad6cbdc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{
     SuperscriptBox["a13", "2"], " ", "b22"}], "-", 
    RowBox[{
     SuperscriptBox["a23", "2"], " ", "b22", " ", "ell"}], "-", 
    RowBox[{"2", " ", "a", " ", "a23", " ", "b22", " ", "ell", " ", "lam"}], 
    "+", 
    RowBox[{"2", " ", "a13", " ", "b22", " ", "c", " ", "ell", " ", "lam"}]}],
    "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[2, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 1}}], 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a13^2 \
$CellContext`b22 - $CellContext`a23^2 $CellContext`b22 $CellContext`ell - 
   2 $CellContext`a $CellContext`a23 $CellContext`b22 $CellContext`ell \
$CellContext`lam + 
   2 $CellContext`a13 $CellContext`b22 $CellContext`c $CellContext`ell \
$CellContext`lam, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733952789908923*^9},ExpressionUUID->"6821d715-59c3-49cc-8a9b-\
54f39cd76026"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "0", "1"},
       {"1", "1", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"2", " ", "a", " ", "a13", " ", "b22"}], "+", 
    RowBox[{
     SuperscriptBox["a13", "2"], " ", "b22"}], "-", 
    RowBox[{
     SuperscriptBox["a23", "2"], " ", "b22", " ", "ell"}], "-", 
    RowBox[{"2", " ", "a23", " ", "b22", " ", "c", " ", "ell"}], "-", 
    RowBox[{"2", " ", "a", " ", "a23", " ", "b22", " ", "ell", " ", "lam"}], 
    "+", 
    RowBox[{"2", " ", "a13", " ", "b22", " ", "c", " ", "ell", " ", "lam"}]}],
    "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[3, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 1}, {0, 0, 1}, {1, 1, 1}}], 
   "\n", $CellContext`a33^2 $CellContext`b12 + 
   2 $CellContext`a $CellContext`a13 $CellContext`b22 + $CellContext`a13^2 \
$CellContext`b22 - $CellContext`a23^2 $CellContext`b22 $CellContext`ell - 
   2 $CellContext`a23 $CellContext`b22 $CellContext`c $CellContext`ell - 
   2 $CellContext`a $CellContext`a23 $CellContext`b22 $CellContext`ell \
$CellContext`lam + 
   2 $CellContext`a13 $CellContext`b22 $CellContext`c $CellContext`ell \
$CellContext`lam, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733952789911495*^9},ExpressionUUID->"250c348c-2db6-455e-a776-\
443da73204e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"-", "ell"}], "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{
     SuperscriptBox["a13", "2"], " ", "b22"}], "-", 
    RowBox[{
     SuperscriptBox["a23", "2"], " ", "b22", " ", "ell"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22", " ", 
     SuperscriptBox["ell", "2"], " ", 
     SuperscriptBox["lam", "2"]}], "-", 
    RowBox[{"b22", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["ell", "3"], " ", 
     SuperscriptBox["lam", "2"]}]}], "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[4, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, -$CellContext`ell, 0}, {0, 0, 1}}], 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a13^2 \
$CellContext`b22 - $CellContext`a23^2 $CellContext`b22 $CellContext`ell + \
$CellContext`a^2 $CellContext`b22 $CellContext`ell^2 $CellContext`lam^2 - \
$CellContext`b22 $CellContext`c^2 $CellContext`ell^3 $CellContext`lam^2, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733952789913823*^9},ExpressionUUID->"632f280c-2e41-4ab3-8fc6-\
73f2b0ea0e19"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", 
        RowBox[{"-", "ell"}], "0"},
       {"1", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"2", " ", "a", " ", "a13", " ", "b22"}], "+", 
    RowBox[{
     SuperscriptBox["a13", "2"], " ", "b22"}], "-", 
    RowBox[{
     SuperscriptBox["a23", "2"], " ", "b22", " ", "ell"}], "-", 
    RowBox[{"2", " ", "a23", " ", "b22", " ", "c", " ", "ell"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22", " ", 
     SuperscriptBox["ell", "2"], " ", 
     SuperscriptBox["lam", "2"]}], "-", 
    RowBox[{"b22", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["ell", "3"], " ", 
     SuperscriptBox["lam", "2"]}]}], "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[5, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 1}, {0, -$CellContext`ell, 0}, {1, 0, 1}}], 
   "\n", $CellContext`a33^2 $CellContext`b12 + 
   2 $CellContext`a $CellContext`a13 $CellContext`b22 + $CellContext`a13^2 \
$CellContext`b22 - $CellContext`a23^2 $CellContext`b22 $CellContext`ell - 
   2 $CellContext`a23 $CellContext`b22 $CellContext`c $CellContext`ell + \
$CellContext`a^2 $CellContext`b22 $CellContext`ell^2 $CellContext`lam^2 - \
$CellContext`b22 $CellContext`c^2 $CellContext`ell^3 $CellContext`lam^2, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7339527899162693`*^9},ExpressionUUID->"dc766e2f-b37e-4895-a1fa-\
3e1035711d1d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "ell"}], "0", "0"},
       {"0", 
        RowBox[{"-", "ell"}], "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{
     SuperscriptBox["a13", "2"], " ", "b22"}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22", " ", "ell"}], "-", 
    RowBox[{
     SuperscriptBox["a23", "2"], " ", "b22", " ", "ell"}], "+", 
    RowBox[{"b22", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["ell", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22", " ", 
     SuperscriptBox["ell", "2"], " ", 
     SuperscriptBox["lam", "2"]}], "-", 
    RowBox[{"b22", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["ell", "3"], " ", 
     SuperscriptBox["lam", "2"]}]}], "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[6, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{-$CellContext`ell, 0, 0}, {0, -$CellContext`ell, 0}, {0, 0, 
     1}}], "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a13^2 \
$CellContext`b22 - $CellContext`a^2 $CellContext`b22 $CellContext`ell - \
$CellContext`a23^2 $CellContext`b22 $CellContext`ell + $CellContext`b22 \
$CellContext`c^2 $CellContext`ell^2 + $CellContext`a^2 $CellContext`b22 \
$CellContext`ell^2 $CellContext`lam^2 - $CellContext`b22 $CellContext`c^2 \
$CellContext`ell^3 $CellContext`lam^2, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733952789918787*^9},ExpressionUUID->"0fbddd8d-2e87-426a-9c02-\
d11e69be9d26"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "a", " ", "a23", " ", "b22", " ", "ell", " ", 
     "lam"}], "+", 
    RowBox[{"2", " ", "a13", " ", "b22", " ", "c", " ", "ell", " ", "lam"}]}],
    "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[7, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}}], 
   "\n", (-2) $CellContext`a $CellContext`a23 $CellContext`b22 \
$CellContext`ell $CellContext`lam + 
   2 $CellContext`a13 $CellContext`b22 $CellContext`c $CellContext`ell \
$CellContext`lam, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733952789921019*^9},ExpressionUUID->"ea8960f9-58bc-46e7-ba8e-\
6b061ce983ac"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "0", "1"},
       {"1", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", "a", " ", "a13", " ", "b22"}], "-", 
    RowBox[{"2", " ", "a23", " ", "b22", " ", "c", " ", "ell"}], "-", 
    RowBox[{"2", " ", "a", " ", "a23", " ", "b22", " ", "ell", " ", "lam"}], 
    "+", 
    RowBox[{"2", " ", "a13", " ", "b22", " ", "c", " ", "ell", " ", "lam"}]}],
    "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[8, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 1}, {0, 0, 1}, {1, 1, 0}}], "\n", 
   2 $CellContext`a $CellContext`a13 $CellContext`b22 - 
   2 $CellContext`a23 $CellContext`b22 $CellContext`c $CellContext`ell - 
   2 $CellContext`a $CellContext`a23 $CellContext`b22 $CellContext`ell \
$CellContext`lam + 
   2 $CellContext`a13 $CellContext`b22 $CellContext`c $CellContext`ell \
$CellContext`lam, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733952789923047*^9},ExpressionUUID->"acfc7616-0eb1-45d6-89d5-\
301c2e2d316d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22"}], "-", 
    RowBox[{"b22", " ", 
     SuperscriptBox["c", "2"], " ", "ell"}], "-", 
    RowBox[{"2", " ", "a", " ", "a23", " ", "b22", " ", "ell", " ", "lam"}], 
    "+", 
    RowBox[{"2", " ", "a13", " ", "b22", " ", "c", " ", "ell", " ", "lam"}]}],
    "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[9, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{1, 0, 0}, {0, 0, 1}, {0, 1, 0}}], 
   "\n", $CellContext`a^2 $CellContext`b22 - $CellContext`b22 \
$CellContext`c^2 $CellContext`ell - 
   2 $CellContext`a $CellContext`a23 $CellContext`b22 $CellContext`ell \
$CellContext`lam + 
   2 $CellContext`a13 $CellContext`b22 $CellContext`c $CellContext`ell \
$CellContext`lam, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733952789925084*^9},ExpressionUUID->"9642b6cb-4765-4b67-907f-\
9111d57a929c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "-", 
    RowBox[{"2", " ", "a", " ", "a23", " ", "b22", " ", "ell", " ", "lam"}], 
    "+", 
    RowBox[{"2", " ", "a13", " ", "b22", " ", "c", " ", "ell", " ", "lam"}]}],
    "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[10, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11 - 
   2 $CellContext`a $CellContext`a23 $CellContext`b22 $CellContext`ell \
$CellContext`lam + 
   2 $CellContext`a13 $CellContext`b22 $CellContext`c $CellContext`ell \
$CellContext`lam, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733952789927101*^9},ExpressionUUID->"53dd1e37-7ee6-4622-ae7f-\
cc48d0643b8a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"11", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "0", "1"},
       {"1", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{"2", " ", "a", " ", "a13", " ", "b22"}], "-", 
    RowBox[{"2", " ", "a23", " ", "b22", " ", "c", " ", "ell"}], "-", 
    RowBox[{"2", " ", "a", " ", "a23", " ", "b22", " ", "ell", " ", "lam"}], 
    "+", 
    RowBox[{"2", " ", "a13", " ", "b22", " ", "c", " ", "ell", " ", "lam"}]}],
    "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[11, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 1}, {0, 0, 1}, {1, 1, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11 + 
   2 $CellContext`a $CellContext`a13 $CellContext`b22 - 
   2 $CellContext`a23 $CellContext`b22 $CellContext`c $CellContext`ell - 
   2 $CellContext`a $CellContext`a23 $CellContext`b22 $CellContext`ell \
$CellContext`lam + 
   2 $CellContext`a13 $CellContext`b22 $CellContext`c $CellContext`ell \
$CellContext`lam, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733952789929119*^9},ExpressionUUID->"c9961410-015b-4ade-9bef-\
be1f5e46ffb5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"12", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22"}], "-", 
    RowBox[{"b22", " ", 
     SuperscriptBox["c", "2"], " ", "ell"}], "-", 
    RowBox[{"2", " ", "a", " ", "a23", " ", "b22", " ", "ell", " ", "lam"}], 
    "+", 
    RowBox[{"2", " ", "a13", " ", "b22", " ", "c", " ", "ell", " ", "lam"}]}],
    "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[12, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{1, 0, 0}, {0, 0, 1}, {0, 1, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11 + $CellContext`a^2 \
$CellContext`b22 - $CellContext`b22 $CellContext`c^2 $CellContext`ell - 
   2 $CellContext`a $CellContext`a23 $CellContext`b22 $CellContext`ell \
$CellContext`lam + 
   2 $CellContext`a13 $CellContext`b22 $CellContext`c $CellContext`ell \
$CellContext`lam, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733952789931188*^9},ExpressionUUID->"0f6256a4-c22f-429f-91f7-\
6e987c438e4c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"13", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "2"]}], " ", "b22", " ", "ell", " ", 
     SuperscriptBox["lam", "2"]}], "+", 
    RowBox[{"b22", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["ell", "2"], " ", 
     SuperscriptBox["lam", "2"]}]}], "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[13, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   "\n", -$CellContext`a^2 $CellContext`b22 $CellContext`ell \
$CellContext`lam^2 + $CellContext`b22 $CellContext`c^2 $CellContext`ell^2 \
$CellContext`lam^2, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733952789933185*^9},ExpressionUUID->"de375b86-e6f3-4c87-a772-\
582b67682b42"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"14", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22"}], "-", 
    RowBox[{"b22", " ", 
     SuperscriptBox["c", "2"], " ", "ell"}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22", " ", "ell", " ", 
     SuperscriptBox["lam", "2"]}], "+", 
    RowBox[{"b22", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["ell", "2"], " ", 
     SuperscriptBox["lam", "2"]}]}], "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[14, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{1, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   "\n", $CellContext`a^2 $CellContext`b22 - $CellContext`b22 \
$CellContext`c^2 $CellContext`ell - $CellContext`a^2 $CellContext`b22 \
$CellContext`ell $CellContext`lam^2 + $CellContext`b22 $CellContext`c^2 \
$CellContext`ell^2 $CellContext`lam^2, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.73395278993521*^9},ExpressionUUID->"e8257cba-77cc-4ca2-812a-f06e258596c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"15", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"ell", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22", " ", "ell"}], "-", 
    RowBox[{"b22", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["ell", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22", " ", "ell", " ", 
     SuperscriptBox["lam", "2"]}], "+", 
    RowBox[{"b22", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["ell", "2"], " ", 
     SuperscriptBox["lam", "2"]}]}], "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[15, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{$CellContext`ell, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   "\n", $CellContext`a^2 $CellContext`b22 $CellContext`ell - \
$CellContext`b22 $CellContext`c^2 $CellContext`ell^2 - $CellContext`a^2 \
$CellContext`b22 $CellContext`ell $CellContext`lam^2 + $CellContext`b22 \
$CellContext`c^2 $CellContext`ell^2 $CellContext`lam^2, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733952789937255*^9},ExpressionUUID->"5f78f1c4-9e96-45e7-b9e1-\
c4fd2bb09d9f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"16", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22", " ", "ell", " ", 
     SuperscriptBox["lam", "2"]}], "+", 
    RowBox[{"b22", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["ell", "2"], " ", 
     SuperscriptBox["lam", "2"]}]}], "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[16, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11 - $CellContext`a^2 \
$CellContext`b22 $CellContext`ell $CellContext`lam^2 + $CellContext`b22 \
$CellContext`c^2 $CellContext`ell^2 $CellContext`lam^2, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733952789939322*^9},ExpressionUUID->"f7925011-5e3d-4db8-9ba2-\
decda554bdd8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"17", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22"}], "-", 
    RowBox[{"b22", " ", 
     SuperscriptBox["c", "2"], " ", "ell"}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22", " ", "ell", " ", 
     SuperscriptBox["lam", "2"]}], "+", 
    RowBox[{"b22", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["ell", "2"], " ", 
     SuperscriptBox["lam", "2"]}]}], "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[17, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{1, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11 + $CellContext`a^2 \
$CellContext`b22 - $CellContext`b22 $CellContext`c^2 $CellContext`ell - \
$CellContext`a^2 $CellContext`b22 $CellContext`ell $CellContext`lam^2 + \
$CellContext`b22 $CellContext`c^2 $CellContext`ell^2 $CellContext`lam^2, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7339527899413767`*^9},ExpressionUUID->"280a7be7-9307-4cc9-8a18-\
c7c21c897fb6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"18", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"ell", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\"\<\\\\n\>\"", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22", " ", "ell"}], "-", 
    RowBox[{"b22", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["ell", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22", " ", "ell", " ", 
     SuperscriptBox["lam", "2"]}], "+", 
    RowBox[{"b22", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["ell", "2"], " ", 
     SuperscriptBox["lam", "2"]}]}], "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[18, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{$CellContext`ell, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11 + $CellContext`a^2 \
$CellContext`b22 $CellContext`ell - $CellContext`b22 $CellContext`c^2 \
$CellContext`ell^2 - $CellContext`a^2 $CellContext`b22 $CellContext`ell \
$CellContext`lam^2 + $CellContext`b22 $CellContext`c^2 $CellContext`ell^2 \
$CellContext`lam^2, "\n"],
  Editable->False]], "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.73395278994355*^9, {3.733953688129801*^9, 
   3.733953688537622*^9}},ExpressionUUID->"9b0f0887-6e0b-4f4f-8c77-\
2d3bc960c568"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"19", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a33", "2"], " ", "b11"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[19, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7339527899459*^9},ExpressionUUID->"74c29962-3ca5-49f6-9fd3-288d0304d005"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"20", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "0", "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[20, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], "\n", 0, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733952789947901*^9},ExpressionUUID->"5853d700-7be0-4199-863b-\
83e1f1fa9187"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.733952828996748*^9, 
  3.733952830725919*^9}},ExpressionUUID->"60f32dbf-accb-412f-97df-\
b6ee19b79ae1"]
},
WindowSize->{808, 911},
WindowMargins->{{Automatic, 9}, {15, Automatic}},
FrontEndVersion->"11.1 for Linux x86 (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 3283, 81, 284, "Input", "ExpressionUUID" -> \
"0ab6eecb-85a6-43a5-b259-6da0e11b6e77"],
Cell[3866, 105, 1835, 49, 59, "Print", "ExpressionUUID" -> \
"08077e0e-729b-4e16-a5e6-7320d5850752"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5738, 159, 14641, 404, 538, "Input", "ExpressionUUID" -> \
"9fe06720-3558-4fe6-9464-07b17374b7ac"],
Cell[20382, 565, 394, 7, 24, "Print", "ExpressionUUID" -> \
"52f35dd6-9262-43f2-a574-cf91d489f7d3"]
}, Open  ]],
Cell[20791, 575, 248, 6, 55, "Input", "ExpressionUUID" -> \
"e4ff5596-c823-4f11-a03d-d31e1c605520"],
Cell[CellGroupData[{
Cell[21064, 585, 677, 20, 34, "Input", "ExpressionUUID" -> \
"8c22f9a0-3982-4ca0-ae89-dc5e202c2511"],
Cell[21744, 607, 705, 21, 34, "Output", "ExpressionUUID" -> \
"ff16eea8-9cb2-4924-859c-14f6912736a0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22486, 633, 2884, 64, 286, "Input", "ExpressionUUID" -> \
"c287deb0-0435-4237-b664-25fa33fbae39"],
Cell[CellGroupData[{
Cell[25395, 701, 2115, 56, 129, "Print", "ExpressionUUID" -> \
"f63884f6-14bd-4186-96d1-e47365271cf7"],
Cell[27513, 759, 2472, 63, 129, "Print", "ExpressionUUID" -> \
"2c1916d1-ccaa-42a5-bd90-7b6fae9d9c60"],
Cell[29988, 824, 2733, 67, 149, "Print", "ExpressionUUID" -> \
"4cda7fdd-d3bf-4fa7-a31f-9b8789c886d8"],
Cell[32724, 893, 2589, 66, 129, "Print", "ExpressionUUID" -> \
"6578d65a-8142-450e-93fb-3c9b99af71bd"],
Cell[35316, 961, 2852, 70, 151, "Print", "ExpressionUUID" -> \
"5adeb218-82b4-4120-a864-ce9bc6c81984"],
Cell[38171, 1033, 2924, 74, 151, "Print", "ExpressionUUID" -> \
"d67d6c33-83e0-45bc-8582-2b475502fa33"],
Cell[41098, 1109, 2150, 56, 127, "Print", "ExpressionUUID" -> \
"445cf591-9c07-457f-8acb-d578c9e4a73d"],
Cell[43251, 1167, 2386, 59, 127, "Print", "ExpressionUUID" -> \
"4a092544-b03f-4dbd-9924-61413b0083c0"],
Cell[45640, 1228, 2360, 61, 129, "Print", "ExpressionUUID" -> \
"51118107-dc8d-42ce-a103-59ea20be2aec"],
Cell[48003, 1291, 2235, 58, 129, "Print", "ExpressionUUID" -> \
"c77abce8-1a1d-4714-9211-274cd8674b86"],
Cell[50241, 1351, 2496, 62, 129, "Print", "ExpressionUUID" -> \
"f5827eb4-de39-47dc-a873-153176e7a74f"],
Cell[52740, 1415, 2466, 63, 129, "Print", "ExpressionUUID" -> \
"40247263-568a-437a-8c25-a03a4deb13b4"],
Cell[55209, 1480, 2200, 58, 129, "Print", "ExpressionUUID" -> \
"1bb1e00a-b829-421b-aed3-fcd3726503ae"],
Cell[57412, 1540, 2405, 61, 129, "Print", "ExpressionUUID" -> \
"ff79ed3e-1068-499a-a6e7-071904b2ae48"],
Cell[59820, 1603, 2483, 63, 129, "Print", "ExpressionUUID" -> \
"bee36658-a9cf-435d-a8d3-b94344aff592"],
Cell[62306, 1668, 2281, 59, 129, "Print", "ExpressionUUID" -> \
"4f5433dc-34d8-4f8f-b8bb-5d3a1f970cc8"],
Cell[64590, 1729, 2514, 64, 129, "Print", "ExpressionUUID" -> \
"3e8a2d41-621b-49d9-8d30-106cc733ca10"],
Cell[67107, 1795, 2690, 69, 129, "Print", "ExpressionUUID" -> \
"89b20dbd-faeb-4158-8f02-4a2b37e6beae"],
Cell[69800, 1866, 1858, 49, 129, "Print", "ExpressionUUID" -> \
"239697fb-5457-4fe6-b30e-ef0c7f98376b"],
Cell[71661, 1917, 1766, 46, 127, "Print", "ExpressionUUID" -> \
"28cfb82b-1ec6-412c-aa30-3a98481ebc7c"]
}, Open  ]]
}, Open  ]],
Cell[73454, 1967, 152, 3, 32, "Input", "ExpressionUUID" -> \
"8ba1fce9-2128-44c7-91fd-6bfed2507434"]
}
]
*)

