(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    110264,       2847]
NotebookOptionsPosition[    106567,       2761]
NotebookOutlinePosition[    106902,       2776]
CellTagsIndexPosition[    106859,       2773]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "This", " ", "file", " ", "calculates", " ", "the", " ", "inner", " ", 
    "product", " ", "pairings", " ", "for", " ", "the", " ", "mod", " ", "p", 
    " ", "orbits", " ", "O14", " ", "and", " ", "OD12"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "y", ",", "A11", ",", " ", "A12", ",", " ", "A13", ",", 
      " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ",
       "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", 
      "B21", ",", " ", "B22", ",", " ", "a11", ",", " ", "a12", ",", " ", 
      "a13", ",", " ", "a21", ",", " ", "a22", ",", " ", "a23", ",", " ", 
      "a31", ",", " ", "a32", ",", " ", "a33", ",", " ", "b11", ",", " ", 
      "b12", ",", " ", "b21", ",", " ", "b22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O14", " ", "=", " ", "Ox"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OD12", " ", "=", " ", "Oxi"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Gact3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a11", ",", " ", "a12", ",", " ", "a13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "c", ",", "d"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Gact2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"b11", ",", " ", "b12"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "b22"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x01", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x02", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x11", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"eps4", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x12", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi01", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi02", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi0ACT31", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi01", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi0ACT32", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi02", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi0ACT1", " ", "=", " ", 
     RowBox[{
      RowBox[{"b11", " ", "*", " ", "xi0ACT31"}], " ", "+", " ", 
      RowBox[{"b12", " ", "*", " ", "xi0ACT32"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi0ACT2", " ", "=", " ", 
     RowBox[{"b22", " ", "*", " ", "xi0ACT32"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Pairing0", " ", "=", " ", 
     RowBox[{
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x11", "]"}], ".", "xi0ACT1"}], "]"}], "+", 
      
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x12", "]"}], ".", "xi0ACT2"}], "]"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "x01", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "x02", "]"}], ",", " ", "Pairing0"}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.733834040192012*^9, 3.73383417454156*^9}, {
   3.73383429054252*^9, 3.733834334668531*^9}, {3.7338369238216963`*^9, 
   3.733836959732308*^9}, {3.7338375934586*^9, 3.733837605217167*^9}, {
   3.733837648713428*^9, 3.733837681840667*^9}, {3.733844525192297*^9, 
   3.73384453085526*^9}, 3.7338457926959047`*^9, {3.733845828423773*^9, 
   3.73384592720748*^9}, {3.7338459814150887`*^9, 3.733846011950898*^9}, {
   3.733846531316143*^9, 3.733846535339695*^9}, {3.733846672106317*^9, 
   3.73384680649897*^9}, {3.7338468499142237`*^9, 3.733846857625437*^9}, {
   3.7338485083510847`*^9, 3.733848527694816*^9}, {3.733849502026189*^9, 
   3.733849587161031*^9}, {3.733851668484419*^9, 3.733851669131956*^9}, {
   3.733851702628295*^9, 3.733851710163824*^9}, {3.733851809155324*^9, 
   3.7338518093069983`*^9}, {3.741345362437518*^9, 
   3.7413453686132927`*^9}},ExpressionUUID->"c9977329-e313-46e0-9db4-\
fb4e0a65f05f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        FractionBox["1", "2"]},
       {"0", "1", "0"},
       {
        FractionBox["1", "2"], "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a11", "2"], " ", "b11", " ", "eps4"}]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 
      Rational[1, 2]}, {0, 1, 0}, {
      Rational[1, 2], 0, 
      0}}], $CellContext`a11^2 $CellContext`b11 $CellContext`eps4],
  Editable->False]], "Print",
 CellChangeTimes->{{3.733836933925782*^9, 3.733836960154544*^9}, 
   3.733837683012678*^9, 3.73384332478533*^9, 3.733844540632078*^9, {
   3.733846762552989*^9, 3.7338467820719023`*^9}, 3.7338468595660267`*^9, 
   3.733848534520564*^9, 3.733849610963228*^9, 3.733851824375997*^9, 
   3.734171730858614*^9},ExpressionUUID->"9eed0be0-2640-405c-aebe-\
524d99add3fd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"xiTable", " ", "=", " ", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"2", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"3", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           RowBox[{"1", "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"1", "/", "2"}], ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"4", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"5", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"6", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"7", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           RowBox[{"1", "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"1", "/", "2"}], ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"8", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"9", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"10", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"11", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"12", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"13", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"14", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"15", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"16", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"17", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"18", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"19", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"20", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "ell", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"21", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"22", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"23", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"24", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "y"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "y", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Length", "[", "xiTable", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.733838846527213*^9, 3.7338389816092587`*^9}, {
  3.733840103914178*^9, 3.733840549544438*^9}, {3.733841144204008*^9, 
  3.7338411725242*^9}, {3.7338413258745413`*^9, 3.733841449707015*^9}, {
  3.733841647641047*^9, 3.73384165992979*^9}, {3.733841696696742*^9, 
  3.7338417267768*^9}, {3.733841759687078*^9, 3.733841842029541*^9}, {
  3.7338419005518093`*^9, 3.733841964896893*^9}, {3.7338420077764807`*^9, 
  3.733842494494863*^9}, {3.7338425291580353`*^9, 3.73384253410826*^9}, {
  3.733842581916871*^9, 3.7338425987478943`*^9}, {3.7338430232754297`*^9, 
  3.733843031201666*^9}},ExpressionUUID->"6a07159d-6c15-49d5-8b12-\
f6990b7a6484"],

Cell[BoxData["24"], "Print",
 CellChangeTimes->{
  3.733842534647914*^9, {3.733842587078554*^9, 3.733842599520444*^9}, 
   3.733843032008008*^9, 3.733843272133623*^9, 3.733844546037567*^9, 
   3.733847018462346*^9, 3.7338485405006533`*^9, 3.7338496218311653`*^9, 
   3.733851834391245*^9, 
   3.734171735078446*^9},ExpressionUUID->"824589dc-72e2-4460-acdc-\
772e9261c8c5"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"xiTable", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.733843261533099*^9, 
  3.7338432667507677`*^9}},ExpressionUUID->"ad6cde9f-696e-4c0f-9938-\
1eaba3ddff47"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Input",
 CellChangeTimes->{
  3.7338470227121477`*^9},ExpressionUUID->"41edfbdb-73d7-42f5-abc8-\
924a4925e039"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.733847022813574*^9},ExpressionUUID->"dc384c40-c5a9-47ed-85b6-\
940b54e8ab2d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", " ", 
   RowBox[{"i", "\[LessEqual]", 
    RowBox[{"Length", "[", "xiTable", "]"}]}], ",", " ", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Orbit", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"xi11", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", " ", "2"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xi12", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "3"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"xiACT31", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi11", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT32", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi12", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT1", " ", "=", " ", 
     RowBox[{
      RowBox[{"b11", " ", "*", " ", "xiACT31"}], " ", "+", " ", 
      RowBox[{"b12", " ", "*", " ", "xiACT32"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT2", " ", "=", " ", 
     RowBox[{"b22", " ", "*", " ", "xiACT32"}]}], ";", "\[IndentingNewLine]", 
    
    RowBox[{"Pairing", " ", "=", " ", 
     RowBox[{
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x01", "]"}], ".", "xiACT1"}], "]"}], "+", 
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x02", "]"}], ".", "xiACT2"}], "]"}]}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"Orbit", ",", " ", "\"\<\\n\>\"", ",", 
      RowBox[{"MatrixForm", "[", "xi11", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "xi12", "]"}], ",", "\"\<\\n\>\"", ",", " ", 
      
      RowBox[{"Simplify", "[", "Pairing", "]"}], ",", " ", "\"\<\\n\>\"", ",",
       " ", 
      RowBox[{"Simplify", "[", 
       RowBox[{"Pairing", " ", "+", " ", "Pairing0"}], "]"}], ",", " ", 
      "\"\<\\n\>\""}], "]"}], ";"}]}], "\[IndentingNewLine]", "]"}]], "Input",\

 CellChangeTimes->{{3.7338344558294764`*^9, 3.733834473411776*^9}, {
   3.733836101706242*^9, 3.733836173825585*^9}, {3.7338362479212427`*^9, 
   3.733836338560684*^9}, {3.7338364006081953`*^9, 3.7338364411760187`*^9}, 
   3.733836754125835*^9, {3.733836844957556*^9, 3.733836903589159*^9}, {
   3.733836976822104*^9, 3.733837134583942*^9}, {3.733837278606353*^9, 
   3.7338373093731728`*^9}, {3.7338430584741707`*^9, 3.733843230695416*^9}, {
   3.7338433049029493`*^9, 3.733843379702538*^9}, {3.733843573077908*^9, 
   3.733843576709671*^9}, {3.733846898073357*^9, 3.7338469204337587`*^9}, {
   3.7338485461031847`*^9, 3.733848549839365*^9}, {3.733849636003745*^9, 
   3.733849650393408*^9}},ExpressionUUID->"b62d1123-ad39-4f4b-a51d-\
9682bb27b277"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "0", "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a11", "2"], " ", "b11", " ", "eps4"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[1, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], "\n", 0, 
   "\n", $CellContext`a11^2 $CellContext`b11 $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.734171739917055*^9},ExpressionUUID->"d185f7f5-3523-451d-8628-\
2bcfb7662264"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"b11", " ", 
    SuperscriptBox["d", "2"]}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"b11", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["d", "2"], "+", 
      RowBox[{
       SuperscriptBox["a11", "2"], " ", "eps4"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[2, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   "\n", $CellContext`b11 $CellContext`d^2, 
   "\n", $CellContext`b11 ($CellContext`d^2 + $CellContext`a11^2 \
$CellContext`eps4), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.734171739919321*^9},ExpressionUUID->"bad78564-9390-4cf7-b1f9-\
8706dd3cdd7c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", 
        FractionBox["1", "2"]},
       {"0", 
        FractionBox["1", "2"], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"b11", " ", "c", " ", "d"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"b11", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"c", " ", "d"}], "+", 
      RowBox[{
       SuperscriptBox["a11", "2"], " ", "eps4"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[3, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 
      Rational[1, 2]}, {0, 
      Rational[1, 2], 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   "\n", $CellContext`b11 $CellContext`c $CellContext`d, 
   "\n", $CellContext`b11 ($CellContext`c $CellContext`d + $CellContext`a11^2 \
$CellContext`eps4), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.734171739921586*^9},ExpressionUUID->"b27df25d-b239-4104-95ab-\
a998d87e4f49"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"-", "ell"}], "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"b11", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["d", "2"], "-", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", "ell"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"b11", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["d", "2"], "-", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", "ell"}], "+", 
      RowBox[{
       SuperscriptBox["a11", "2"], " ", "eps4"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[4, "\n", 
   MatrixForm[{{0, 0, 0}, {0, -$CellContext`ell, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   "\n", $CellContext`b11 ($CellContext`d^2 - $CellContext`c^2 \
$CellContext`ell), 
   "\n", $CellContext`b11 ($CellContext`d^2 - $CellContext`c^2 \
$CellContext`ell + $CellContext`a11^2 $CellContext`eps4), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.734171739923901*^9},ExpressionUUID->"c8d28eba-4d3e-48d6-9382-\
31b7783a3a79"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "0", "0"},
       {"1", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"d", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a11", " ", "b22"}], "+", 
      RowBox[{"b11", " ", "d"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a11", " ", "b22", " ", "d"}], "+", 
    RowBox[{"b11", " ", 
     SuperscriptBox["d", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a11", "2"], " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[5, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}}], 
   "\n", $CellContext`d ($CellContext`a11 $CellContext`b22 + $CellContext`b11 \
$CellContext`d), 
   "\n", $CellContext`a11 $CellContext`b22 $CellContext`d + $CellContext`b11 \
$CellContext`d^2 + $CellContext`a11^2 $CellContext`b11 $CellContext`eps4, 
   "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.7341717399262657`*^9},ExpressionUUID->"7d5c6e65-8ee5-4601-8452-\
f92e5c8d2fa5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "0", "0"},
       {"1", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"b11", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"a11", " ", "b22", " ", "d"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a11", " ", "b22", " ", "d"}], "+", 
    RowBox[{"b11", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["c", "2"], "+", 
       RowBox[{
        SuperscriptBox["a11", "2"], " ", "eps4"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[6, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}}], 
   "\n", $CellContext`b11 $CellContext`c^2 + $CellContext`a11 \
$CellContext`b22 $CellContext`d, 
   "\n", $CellContext`a11 $CellContext`b22 $CellContext`d + $CellContext`b11 \
($CellContext`c^2 + $CellContext`a11^2 $CellContext`eps4), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.734171739928388*^9},ExpressionUUID->"f3948c13-88b1-4f8a-8d11-\
dbc2e4cac329"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", 
        FractionBox["1", "2"]},
       {"0", 
        FractionBox["1", "2"], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "0", "0"},
       {"1", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a11", " ", "b22"}], "+", 
      RowBox[{"b11", " ", "c"}]}], ")"}], " ", "d"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a11", " ", "b22", " ", "d"}], "+", 
    RowBox[{"b11", " ", "c", " ", "d"}], "+", 
    RowBox[{
     SuperscriptBox["a11", "2"], " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[7, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 
      Rational[1, 2]}, {0, 
      Rational[1, 2], 0}}], 
   MatrixForm[{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}}], 
   "\n", ($CellContext`a11 $CellContext`b22 + $CellContext`b11 \
$CellContext`c) $CellContext`d, 
   "\n", $CellContext`a11 $CellContext`b22 $CellContext`d + $CellContext`b11 \
$CellContext`c $CellContext`d + $CellContext`a11^2 $CellContext`b11 \
$CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.734171739930437*^9},ExpressionUUID->"fef3ad91-3ba3-4928-90d3-\
bcc15d5ddb39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "0", "0"},
       {"1", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a11", " ", "b22", " ", "d"}], "+", 
    RowBox[{"b11", " ", "c", " ", 
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"2", " ", "d"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a11", " ", "b22", " ", "d"}], "+", 
    RowBox[{"b11", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["c", "2"], "+", 
       RowBox[{"2", " ", "c", " ", "d"}], "+", 
       RowBox[{
        SuperscriptBox["a11", "2"], " ", "eps4"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[8, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 1, 1}, {0, 1, 0}}], 
   MatrixForm[{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}}], 
   "\n", $CellContext`a11 $CellContext`b22 $CellContext`d + $CellContext`b11 \
$CellContext`c ($CellContext`c + 2 $CellContext`d), 
   "\n", $CellContext`a11 $CellContext`b22 $CellContext`d + $CellContext`b11 \
($CellContext`c^2 + 
     2 $CellContext`c $CellContext`d + $CellContext`a11^2 $CellContext`eps4), 
   "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.734171739932653*^9},ExpressionUUID->"3c2149f1-ba1b-4aca-b7b0-\
fe5ba610ba20"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"-", "ell"}], "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "0", "0"},
       {"1", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a11", " ", "b22", " ", "d"}], "+", 
    RowBox[{"b11", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["d", "2"], "-", 
       RowBox[{
        SuperscriptBox["c", "2"], " ", "ell"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a11", " ", "b22", " ", "d"}], "+", 
    RowBox[{"b11", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["d", "2"], "-", 
       RowBox[{
        SuperscriptBox["c", "2"], " ", "ell"}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a11", "2"], " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[9, "\n", 
   MatrixForm[{{0, 0, 0}, {0, -$CellContext`ell, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}}], 
   "\n", $CellContext`a11 $CellContext`b22 $CellContext`d + $CellContext`b11 \
($CellContext`d^2 - $CellContext`c^2 $CellContext`ell), 
   "\n", $CellContext`a11 $CellContext`b22 $CellContext`d + $CellContext`b11 \
($CellContext`d^2 - $CellContext`c^2 $CellContext`ell) + $CellContext`a11^2 \
$CellContext`b11 $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.734171739934939*^9},ExpressionUUID->"b9189008-57ca-426e-9b57-\
bb56feb3cf47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "0", "0"},
       {"1", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"a11", " ", "b22", " ", "d"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"a11", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b22", " ", "d"}], "+", 
      RowBox[{"a11", " ", "b11", " ", "eps4"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[10, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}}], 
   "\n", $CellContext`a11 $CellContext`b22 $CellContext`d, 
   "\n", $CellContext`a11 ($CellContext`b22 $CellContext`d + $CellContext`a11 \
$CellContext`b11 $CellContext`eps4), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.734171739937107*^9},ExpressionUUID->"fbd1c4c6-57a2-4bc3-869f-\
66be59ab872e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"11", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b22"}], "+", 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a13", " ", "b22"}], "+", 
       RowBox[{"b12", " ", "d"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b22"}], "+", 
    RowBox[{"a13", " ", "b22", " ", "d"}], "+", 
    RowBox[{"b12", " ", 
     SuperscriptBox["d", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a11", "2"], " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[11, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   "\n", $CellContext`b^2 $CellContext`b22 + $CellContext`d ($CellContext`a13 \
$CellContext`b22 + $CellContext`b12 $CellContext`d), 
   "\n", $CellContext`b^2 $CellContext`b22 + $CellContext`a13 \
$CellContext`b22 $CellContext`d + $CellContext`b12 $CellContext`d^2 + \
$CellContext`a11^2 $CellContext`b11 $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.734171739991741*^9},ExpressionUUID->"73e314a9-9db1-4df3-b241-\
0e625b66ba64"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"12", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b22"}], "+", 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a13", " ", "b22"}], "+", 
       RowBox[{"2", " ", "b11", " ", "c"}], "+", 
       RowBox[{"b12", " ", "d"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b22"}], "+", 
    RowBox[{"a13", " ", "b22", " ", "d"}], "+", 
    RowBox[{"2", " ", "b11", " ", "c", " ", "d"}], "+", 
    RowBox[{"b12", " ", 
     SuperscriptBox["d", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a11", "2"], " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[12, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   "\n", $CellContext`b^2 $CellContext`b22 + $CellContext`d ($CellContext`a13 \
$CellContext`b22 + 
     2 $CellContext`b11 $CellContext`c + $CellContext`b12 $CellContext`d), 
   "\n", $CellContext`b^2 $CellContext`b22 + $CellContext`a13 \
$CellContext`b22 $CellContext`d + 
   2 $CellContext`b11 $CellContext`c $CellContext`d + $CellContext`b12 \
$CellContext`d^2 + $CellContext`a11^2 $CellContext`b11 $CellContext`eps4, 
   "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.7341717399937677`*^9},ExpressionUUID->"7553fc40-2848-4f83-a8fb-\
2ac326d06e92"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"13", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b22"}], "+", 
    RowBox[{"b11", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a13", " ", "b22"}], "+", 
       RowBox[{"b12", " ", "d"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b22"}], "+", 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a13", " ", "b22"}], "+", 
       RowBox[{"b12", " ", "d"}]}], ")"}]}], "+", 
    RowBox[{"b11", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["c", "2"], "+", 
       RowBox[{
        SuperscriptBox["a11", "2"], " ", "eps4"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[13, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   "\n", $CellContext`b^2 $CellContext`b22 + $CellContext`b11 \
$CellContext`c^2 + $CellContext`d ($CellContext`a13 $CellContext`b22 + \
$CellContext`b12 $CellContext`d), 
   "\n", $CellContext`b^2 $CellContext`b22 + $CellContext`d ($CellContext`a13 \
$CellContext`b22 + $CellContext`b12 $CellContext`d) + $CellContext`b11 \
($CellContext`c^2 + $CellContext`a11^2 $CellContext`eps4), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.734171739995468*^9},ExpressionUUID->"b92ade20-e767-4cc1-bb39-\
f401250b49d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"14", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1", "0"},
       {"1", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b22"}], "+", 
    RowBox[{"a11", " ", "b22", " ", "c"}], "+", 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a13", " ", "b22"}], "+", 
       RowBox[{"b12", " ", "d"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b22"}], "+", 
    RowBox[{"a11", " ", "b22", " ", "c"}], "+", 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a13", " ", "b22"}], "+", 
       RowBox[{"b12", " ", "d"}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a11", "2"], " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[14, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 1, 0}, {1, 0, 0}, {0, 0, 1}}], 
   "\n", $CellContext`b^2 $CellContext`b22 + $CellContext`a11 \
$CellContext`b22 $CellContext`c + $CellContext`d ($CellContext`a13 \
$CellContext`b22 + $CellContext`b12 $CellContext`d), 
   "\n", $CellContext`b^2 $CellContext`b22 + $CellContext`a11 \
$CellContext`b22 $CellContext`c + $CellContext`d ($CellContext`a13 \
$CellContext`b22 + $CellContext`b12 $CellContext`d) + $CellContext`a11^2 \
$CellContext`b11 $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.734171739997237*^9},ExpressionUUID->"7e8aa84e-3b3d-4213-a43e-\
5d87cbc3205f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"15", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1", "0"},
       {"1", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b22"}], "+", 
    RowBox[{"a11", " ", "b22", " ", "c"}], "+", 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a13", " ", "b22"}], "+", 
       RowBox[{"2", " ", "b11", " ", "c"}], "+", 
       RowBox[{"b12", " ", "d"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b22"}], "+", 
    RowBox[{"a11", " ", "b22", " ", "c"}], "+", 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a13", " ", "b22"}], "+", 
       RowBox[{"2", " ", "b11", " ", "c"}], "+", 
       RowBox[{"b12", " ", "d"}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a11", "2"], " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[15, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}}], 
   MatrixForm[{{0, 1, 0}, {1, 0, 0}, {0, 0, 1}}], 
   "\n", $CellContext`b^2 $CellContext`b22 + $CellContext`a11 \
$CellContext`b22 $CellContext`c + $CellContext`d ($CellContext`a13 \
$CellContext`b22 + 
     2 $CellContext`b11 $CellContext`c + $CellContext`b12 $CellContext`d), 
   "\n", $CellContext`b^2 $CellContext`b22 + $CellContext`a11 \
$CellContext`b22 $CellContext`c + $CellContext`d ($CellContext`a13 \
$CellContext`b22 + 
     2 $CellContext`b11 $CellContext`c + $CellContext`b12 $CellContext`d) + \
$CellContext`a11^2 $CellContext`b11 $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.734171739999029*^9},ExpressionUUID->"316f52f8-e46c-4bdc-82af-\
7cd25b68a391"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"16", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1", "0"},
       {"1", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b22"}], "+", 
    RowBox[{"a11", " ", "b22", " ", "c"}], "+", 
    RowBox[{"b11", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"a13", " ", "b22", " ", "d"}], "+", 
    RowBox[{"b12", " ", 
     SuperscriptBox["d", "2"]}]}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b22"}], "+", 
    RowBox[{"a11", " ", "b22", " ", "c"}], "+", 
    RowBox[{"b11", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"a13", " ", "b22", " ", "d"}], "+", 
    RowBox[{"b12", " ", 
     SuperscriptBox["d", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a11", "2"], " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[16, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 1, 0}, {1, 0, 0}, {0, 0, 1}}], 
   "\n", $CellContext`b^2 $CellContext`b22 + $CellContext`a11 \
$CellContext`b22 $CellContext`c + $CellContext`b11 $CellContext`c^2 + \
$CellContext`a13 $CellContext`b22 $CellContext`d + $CellContext`b12 \
$CellContext`d^2, 
   "\n", $CellContext`b^2 $CellContext`b22 + $CellContext`a11 \
$CellContext`b22 $CellContext`c + $CellContext`b11 $CellContext`c^2 + \
$CellContext`a13 $CellContext`b22 $CellContext`d + $CellContext`b12 \
$CellContext`d^2 + $CellContext`a11^2 $CellContext`b11 $CellContext`eps4, 
   "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.7341717400007887`*^9},ExpressionUUID->"ba0d09e7-0cb1-4c70-8425-\
4e317e80c83f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"17", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", "a", " ", "b", " ", "b22"}], "+", 
    RowBox[{"a13", " ", "b22", " ", "c"}], "+", 
    RowBox[{"a12", " ", "b22", " ", "d"}], "+", 
    RowBox[{"2", " ", "b12", " ", "c", " ", "d"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", "a", " ", "b", " ", "b22"}], "+", 
    RowBox[{"a13", " ", "b22", " ", "c"}], "+", 
    RowBox[{"a12", " ", "b22", " ", "d"}], "+", 
    RowBox[{"2", " ", "b12", " ", "c", " ", "d"}], "+", 
    RowBox[{
     SuperscriptBox["a11", "2"], " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[17, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}}], "\n", 
   2 $CellContext`a $CellContext`b $CellContext`b22 + $CellContext`a13 \
$CellContext`b22 $CellContext`c + $CellContext`a12 $CellContext`b22 \
$CellContext`d + 2 $CellContext`b12 $CellContext`c $CellContext`d, "\n", 
   2 $CellContext`a $CellContext`b $CellContext`b22 + $CellContext`a13 \
$CellContext`b22 $CellContext`c + $CellContext`a12 $CellContext`b22 \
$CellContext`d + 
   2 $CellContext`b12 $CellContext`c $CellContext`d + $CellContext`a11^2 \
$CellContext`b11 $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.734171740002553*^9},ExpressionUUID->"e2fe3744-ad75-4ade-b0db-\
cd41bec90be0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"18", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", "a", " ", "b", " ", "b22"}], "+", 
    RowBox[{"a13", " ", "b22", " ", "c"}], "+", 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a12", " ", "b22"}], "+", 
       RowBox[{"2", " ", "b12", " ", "c"}], "+", 
       RowBox[{"b11", " ", "d"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", "a", " ", "b", " ", "b22"}], "+", 
    RowBox[{"a13", " ", "b22", " ", "c"}], "+", 
    RowBox[{"a12", " ", "b22", " ", "d"}], "+", 
    RowBox[{"2", " ", "b12", " ", "c", " ", "d"}], "+", 
    RowBox[{"b11", " ", 
     SuperscriptBox["d", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a11", "2"], " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[18, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}}], "\n", 
   2 $CellContext`a $CellContext`b $CellContext`b22 + $CellContext`a13 \
$CellContext`b22 $CellContext`c + $CellContext`d ($CellContext`a12 \
$CellContext`b22 + 
     2 $CellContext`b12 $CellContext`c + $CellContext`b11 $CellContext`d), 
   "\n", 2 $CellContext`a $CellContext`b $CellContext`b22 + $CellContext`a13 \
$CellContext`b22 $CellContext`c + $CellContext`a12 $CellContext`b22 \
$CellContext`d + 
   2 $CellContext`b12 $CellContext`c $CellContext`d + $CellContext`b11 \
$CellContext`d^2 + $CellContext`a11^2 $CellContext`b11 $CellContext`eps4, 
   "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.734171740004244*^9},ExpressionUUID->"3c564b17-a0ac-4520-b198-\
df1cc4e97d64"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"19", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", "a", " ", "b", " ", "b22"}], "+", 
    RowBox[{"a13", " ", "b22", " ", "c"}], "+", 
    RowBox[{"b11", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"a12", " ", "b22", " ", "d"}], "+", 
    RowBox[{"2", " ", "b12", " ", "c", " ", "d"}], "+", 
    RowBox[{"b11", " ", 
     SuperscriptBox["d", "2"]}]}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", "a", " ", "b", " ", "b22"}], "+", 
    RowBox[{"a13", " ", "b22", " ", "c"}], "+", 
    RowBox[{"b11", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"a12", " ", "b22", " ", "d"}], "+", 
    RowBox[{"2", " ", "b12", " ", "c", " ", "d"}], "+", 
    RowBox[{"b11", " ", 
     SuperscriptBox["d", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a11", "2"], " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[19, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 1, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}}], "\n", 
   2 $CellContext`a $CellContext`b $CellContext`b22 + $CellContext`a13 \
$CellContext`b22 $CellContext`c + $CellContext`b11 $CellContext`c^2 + \
$CellContext`a12 $CellContext`b22 $CellContext`d + 
   2 $CellContext`b12 $CellContext`c $CellContext`d + $CellContext`b11 \
$CellContext`d^2, "\n", 
   2 $CellContext`a $CellContext`b $CellContext`b22 + $CellContext`a13 \
$CellContext`b22 $CellContext`c + $CellContext`b11 $CellContext`c^2 + \
$CellContext`a12 $CellContext`b22 $CellContext`d + 
   2 $CellContext`b12 $CellContext`c $CellContext`d + $CellContext`b11 \
$CellContext`d^2 + $CellContext`a11^2 $CellContext`b11 $CellContext`eps4, 
   "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.73417174000598*^9},ExpressionUUID->"d88b6294-7a06-47f4-ae1c-\
81f11f974568"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"20", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "ell", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", "a", " ", "b", " ", "b22"}], "+", 
    RowBox[{"a13", " ", "b22", " ", "c"}], "+", 
    RowBox[{"a12", " ", "b22", " ", "d"}], "+", 
    RowBox[{"2", " ", "b12", " ", "c", " ", "d"}], "+", 
    RowBox[{"b11", " ", 
     SuperscriptBox["d", "2"]}], "+", 
    RowBox[{"b11", " ", 
     SuperscriptBox["c", "2"], " ", "ell"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", "a", " ", "b", " ", "b22"}], "+", 
    RowBox[{"a13", " ", "b22", " ", "c"}], "+", 
    RowBox[{"a12", " ", "b22", " ", "d"}], "+", 
    RowBox[{"2", " ", "b12", " ", "c", " ", "d"}], "+", 
    RowBox[{"b11", " ", 
     SuperscriptBox["d", "2"]}], "+", 
    RowBox[{"b11", " ", 
     SuperscriptBox["c", "2"], " ", "ell"}], "+", 
    RowBox[{
     SuperscriptBox["a11", "2"], " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[20, "\n", 
   MatrixForm[{{0, 0, 0}, {0, $CellContext`ell, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}}], "\n", 
   2 $CellContext`a $CellContext`b $CellContext`b22 + $CellContext`a13 \
$CellContext`b22 $CellContext`c + $CellContext`a12 $CellContext`b22 \
$CellContext`d + 
   2 $CellContext`b12 $CellContext`c $CellContext`d + $CellContext`b11 \
$CellContext`d^2 + $CellContext`b11 $CellContext`c^2 $CellContext`ell, "\n", 
   2 $CellContext`a $CellContext`b $CellContext`b22 + $CellContext`a13 \
$CellContext`b22 $CellContext`c + $CellContext`a12 $CellContext`b22 \
$CellContext`d + 
   2 $CellContext`b12 $CellContext`c $CellContext`d + $CellContext`b11 \
$CellContext`d^2 + $CellContext`b11 $CellContext`c^2 $CellContext`ell + \
$CellContext`a11^2 $CellContext`b11 $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.7341717400076923`*^9},ExpressionUUID->"c4e0fbd1-071b-4d3f-8113-\
1d4dacc2a84f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"21", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"-", "ell"}], "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b22"}], "+", 
    RowBox[{"a13", " ", "b22", " ", "d"}], "+", 
    RowBox[{"b12", " ", 
     SuperscriptBox["d", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22", " ", "ell"}], "-", 
    RowBox[{"a12", " ", "b22", " ", "c", " ", "ell"}], "-", 
    RowBox[{"b12", " ", 
     SuperscriptBox["c", "2"], " ", "ell"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b22"}], "+", 
    RowBox[{"a13", " ", "b22", " ", "d"}], "+", 
    RowBox[{"b12", " ", 
     SuperscriptBox["d", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22", " ", "ell"}], "-", 
    RowBox[{"a12", " ", "b22", " ", "c", " ", "ell"}], "-", 
    RowBox[{"b12", " ", 
     SuperscriptBox["c", "2"], " ", "ell"}], "+", 
    RowBox[{
     SuperscriptBox["a11", "2"], " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[21, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, -$CellContext`ell, 0}, {0, 0, 1}}], 
   "\n", $CellContext`b^2 $CellContext`b22 + $CellContext`a13 \
$CellContext`b22 $CellContext`d + $CellContext`b12 $CellContext`d^2 - \
$CellContext`a^2 $CellContext`b22 $CellContext`ell - $CellContext`a12 \
$CellContext`b22 $CellContext`c $CellContext`ell - $CellContext`b12 \
$CellContext`c^2 $CellContext`ell, 
   "\n", $CellContext`b^2 $CellContext`b22 + $CellContext`a13 \
$CellContext`b22 $CellContext`d + $CellContext`b12 $CellContext`d^2 - \
$CellContext`a^2 $CellContext`b22 $CellContext`ell - $CellContext`a12 \
$CellContext`b22 $CellContext`c $CellContext`ell - $CellContext`b12 \
$CellContext`c^2 $CellContext`ell + $CellContext`a11^2 $CellContext`b11 \
$CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.7341717400256977`*^9},ExpressionUUID->"a306eee7-e38c-4ff9-b808-\
ddc162008069"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"22", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"-", "ell"}], "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b22"}], "+", 
    RowBox[{"b11", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"a13", " ", "b22", " ", "d"}], "+", 
    RowBox[{"b12", " ", 
     SuperscriptBox["d", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22", " ", "ell"}], "-", 
    RowBox[{"a12", " ", "b22", " ", "c", " ", "ell"}], "-", 
    RowBox[{"b12", " ", 
     SuperscriptBox["c", "2"], " ", "ell"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b22"}], "+", 
    RowBox[{"a13", " ", "b22", " ", "d"}], "+", 
    RowBox[{"b12", " ", 
     SuperscriptBox["d", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22", " ", "ell"}], "-", 
    RowBox[{"a12", " ", "b22", " ", "c", " ", "ell"}], "-", 
    RowBox[{"b12", " ", 
     SuperscriptBox["c", "2"], " ", "ell"}], "+", 
    RowBox[{"b11", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["c", "2"], "+", 
       RowBox[{
        SuperscriptBox["a11", "2"], " ", "eps4"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[22, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, -$CellContext`ell, 0}, {0, 0, 1}}], 
   "\n", $CellContext`b^2 $CellContext`b22 + $CellContext`b11 \
$CellContext`c^2 + $CellContext`a13 $CellContext`b22 $CellContext`d + \
$CellContext`b12 $CellContext`d^2 - $CellContext`a^2 $CellContext`b22 \
$CellContext`ell - $CellContext`a12 $CellContext`b22 $CellContext`c \
$CellContext`ell - $CellContext`b12 $CellContext`c^2 $CellContext`ell, 
   "\n", $CellContext`b^2 $CellContext`b22 + $CellContext`a13 \
$CellContext`b22 $CellContext`d + $CellContext`b12 $CellContext`d^2 - \
$CellContext`a^2 $CellContext`b22 $CellContext`ell - $CellContext`a12 \
$CellContext`b22 $CellContext`c $CellContext`ell - $CellContext`b12 \
$CellContext`c^2 $CellContext`ell + $CellContext`b11 ($CellContext`c^2 + \
$CellContext`a11^2 $CellContext`eps4), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.734171740029605*^9},ExpressionUUID->"3ad62824-4847-4f32-bfa3-\
153f04e5b86f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"23", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"-", "ell"}], "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b22"}], "+", 
    RowBox[{"a13", " ", "b22", " ", "d"}], "+", 
    RowBox[{"2", " ", "b11", " ", "c", " ", "d"}], "+", 
    RowBox[{"b12", " ", 
     SuperscriptBox["d", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22", " ", "ell"}], "-", 
    RowBox[{"a12", " ", "b22", " ", "c", " ", "ell"}], "-", 
    RowBox[{"b12", " ", 
     SuperscriptBox["c", "2"], " ", "ell"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b22"}], "+", 
    RowBox[{"a13", " ", "b22", " ", "d"}], "+", 
    RowBox[{"2", " ", "b11", " ", "c", " ", "d"}], "+", 
    RowBox[{"b12", " ", 
     SuperscriptBox["d", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22", " ", "ell"}], "-", 
    RowBox[{"a12", " ", "b22", " ", "c", " ", "ell"}], "-", 
    RowBox[{"b12", " ", 
     SuperscriptBox["c", "2"], " ", "ell"}], "+", 
    RowBox[{
     SuperscriptBox["a11", "2"], " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[23, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, -$CellContext`ell, 0}, {0, 0, 1}}], 
   "\n", $CellContext`b^2 $CellContext`b22 + $CellContext`a13 \
$CellContext`b22 $CellContext`d + 
   2 $CellContext`b11 $CellContext`c $CellContext`d + $CellContext`b12 \
$CellContext`d^2 - $CellContext`a^2 $CellContext`b22 $CellContext`ell - \
$CellContext`a12 $CellContext`b22 $CellContext`c $CellContext`ell - \
$CellContext`b12 $CellContext`c^2 $CellContext`ell, 
   "\n", $CellContext`b^2 $CellContext`b22 + $CellContext`a13 \
$CellContext`b22 $CellContext`d + 
   2 $CellContext`b11 $CellContext`c $CellContext`d + $CellContext`b12 \
$CellContext`d^2 - $CellContext`a^2 $CellContext`b22 $CellContext`ell - \
$CellContext`a12 $CellContext`b22 $CellContext`c $CellContext`ell - \
$CellContext`b12 $CellContext`c^2 $CellContext`ell + $CellContext`a11^2 \
$CellContext`b11 $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.73417174003135*^9},ExpressionUUID->"3336fdba-f9ef-416e-a2ca-\
de09f53676d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"24", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", "y"},
       {"0", "y", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"-", "ell"}], "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b22"}], "+", 
    RowBox[{"a13", " ", "b22", " ", "d"}], "+", 
    RowBox[{"b12", " ", 
     SuperscriptBox["d", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22", " ", "ell"}], "-", 
    RowBox[{"a12", " ", "b22", " ", "c", " ", "ell"}], "-", 
    RowBox[{"b12", " ", 
     SuperscriptBox["c", "2"], " ", "ell"}], "+", 
    RowBox[{"b11", " ", "c", " ", 
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"2", " ", "d", " ", "y"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b22"}], "+", 
    RowBox[{"a13", " ", "b22", " ", "d"}], "+", 
    RowBox[{"b12", " ", 
     SuperscriptBox["d", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22", " ", "ell"}], "-", 
    RowBox[{"a12", " ", "b22", " ", "c", " ", "ell"}], "-", 
    RowBox[{"b12", " ", 
     SuperscriptBox["c", "2"], " ", "ell"}], "+", 
    RowBox[{"b11", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["c", "2"], "+", 
       RowBox[{
        SuperscriptBox["a11", "2"], " ", "eps4"}], "+", 
       RowBox[{"2", " ", "c", " ", "d", " ", "y"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[24, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 1, $CellContext`y}, {0, $CellContext`y, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, -$CellContext`ell, 0}, {0, 0, 1}}], 
   "\n", $CellContext`b^2 $CellContext`b22 + $CellContext`a13 \
$CellContext`b22 $CellContext`d + $CellContext`b12 $CellContext`d^2 - \
$CellContext`a^2 $CellContext`b22 $CellContext`ell - $CellContext`a12 \
$CellContext`b22 $CellContext`c $CellContext`ell - $CellContext`b12 \
$CellContext`c^2 $CellContext`ell + $CellContext`b11 $CellContext`c \
($CellContext`c + 2 $CellContext`d $CellContext`y), 
   "\n", $CellContext`b^2 $CellContext`b22 + $CellContext`a13 \
$CellContext`b22 $CellContext`d + $CellContext`b12 $CellContext`d^2 - \
$CellContext`a^2 $CellContext`b22 $CellContext`ell - $CellContext`a12 \
$CellContext`b22 $CellContext`c $CellContext`ell - $CellContext`b12 \
$CellContext`c^2 $CellContext`ell + $CellContext`b11 ($CellContext`c^2 + \
$CellContext`a11^2 $CellContext`eps4 + 
     2 $CellContext`c $CellContext`d $CellContext`y), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.734171740042841*^9},ExpressionUUID->"349d159e-d74d-412f-9230-\
96987a8b0c26"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{Automatic, 82}, {Automatic, 55}},
FrontEndVersion->"11.1 for Linux x86 (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 6154, 162, 491, "Input", "ExpressionUUID" -> \
"c9977329-e313-46e0-9db4-fb4e0a65f05f"],
Cell[6737, 186, 2087, 55, 79, "Print", "ExpressionUUID" -> \
"0731c5ef-e5a4-4f39-9cac-0051f6856ffc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8861, 246, 17369, 484, 630, "Input", "ExpressionUUID" -> \
"7e10fed4-c36c-4733-a6ec-9bda41d7a9a2"],
Cell[26233, 732, 372, 7, 24, "Print", "ExpressionUUID" -> \
"bbcd691f-31c8-4e70-b11d-ed004b4b14a2"]
}, Open  ]],
Cell[26620, 742, 248, 6, 55, "Input", "ExpressionUUID" -> \
"ad27cb4f-9564-45f3-8ce2-fc57db6af033"],
Cell[CellGroupData[{
Cell[26893, 752, 682, 21, 34, "Input", "ExpressionUUID" -> \
"bd5c4dfb-516d-4738-9825-ce147615a580"],
Cell[27578, 775, 681, 21, 34, "Output", "ExpressionUUID" -> \
"6a805c00-faf9-4ea5-8139-ccd4e6305f81"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28296, 801, 2978, 67, 286, "Input", "ExpressionUUID" -> \
"ac7d3656-f490-4a1a-8b7f-962c89898aaf"],
Cell[CellGroupData[{
Cell[31299, 872, 2259, 55, 150, "Print", "ExpressionUUID" -> \
"383840fe-132b-416f-aaba-f8186e9008f8"],
Cell[33561, 929, 2469, 63, 157, "Print", "ExpressionUUID" -> \
"267eca07-46a4-432f-9247-3359457b5f2c"],
Cell[36033, 994, 2572, 66, 182, "Print", "ExpressionUUID" -> \
"7a523dd6-b3f3-42d7-b7a1-a81225718d7e"],
Cell[38608, 1062, 2766, 71, 165, "Print", "ExpressionUUID" -> \
"464c5d1c-c162-4d9b-8eec-395cd35c4a88"],
Cell[41377, 1135, 2707, 68, 150, "Print", "ExpressionUUID" -> \
"cd3b8568-323b-4f25-b825-0f095983821d"],
Cell[44087, 1205, 2707, 68, 157, "Print", "ExpressionUUID" -> \
"eb6dfa2b-2077-488f-8ce2-788c4e3ca3ef"],
Cell[46797, 1275, 2793, 71, 176, "Print", "ExpressionUUID" -> \
"4ec29bbb-cb2d-4220-99c4-d5a8c39fa805"],
Cell[49593, 1348, 2897, 73, 156, "Print", "ExpressionUUID" -> \
"bc7df006-9b4d-41c6-b97e-9cec734952fd"],
Cell[52493, 1423, 3033, 76, 165, "Print", "ExpressionUUID" -> \
"2cd3ce28-1fdb-40db-906d-8f56bf0904cc"],
Cell[55529, 1501, 2486, 61, 147, "Print", "ExpressionUUID" -> \
"782fa14f-d11b-4ca3-b6be-60b3cdc1497e"],
Cell[58018, 1564, 2924, 73, 151, "Print", "ExpressionUUID" -> \
"a86b745f-b396-4db8-a235-db2b4bce07fc"],
Cell[60945, 1639, 3134, 78, 151, "Print", "ExpressionUUID" -> \
"4813aecd-3f81-4fdd-9761-1649e1594b00"],
Cell[64082, 1719, 3187, 82, 157, "Print", "ExpressionUUID" -> \
"fd94d496-9949-46f5-bfa3-d979a8da4fca"],
Cell[67272, 1803, 3165, 79, 151, "Print", "ExpressionUUID" -> \
"374b3ca3-c9d1-4cf0-b756-2fa67f4dc2f8"],
Cell[70440, 1884, 3349, 83, 151, "Print", "ExpressionUUID" -> \
"14c73b4b-6649-4521-b92b-8e339b809f59"],
Cell[73792, 1969, 3299, 81, 151, "Print", "ExpressionUUID" -> \
"227b4c64-0766-41bc-8ddf-497739f61daa"],
Cell[77094, 2052, 3127, 72, 150, "Print", "ExpressionUUID" -> \
"7ed551e8-7e17-42a2-af6c-9818b29b14df"],
Cell[80224, 2126, 3352, 80, 150, "Print", "ExpressionUUID" -> \
"b6b1d17e-9911-4603-8a58-6734e327869f"],
Cell[83579, 2208, 3536, 83, 151, "Print", "ExpressionUUID" -> \
"8d2d8efd-01c5-44c3-943b-434fa14d7237"],
Cell[87118, 2293, 3612, 83, 151, "Print", "ExpressionUUID" -> \
"9a56060a-0908-420f-8390-40b75e2424cd"],
Cell[90733, 2378, 3717, 88, 151, "Print", "ExpressionUUID" -> \
"efc83ea0-d54f-4c0f-9732-bc23ffd72540"],
Cell[94453, 2468, 3939, 94, 157, "Print", "ExpressionUUID" -> \
"76d6b659-884b-47af-870e-9ed4063535cc"],
Cell[98395, 2564, 3938, 92, 151, "Print", "ExpressionUUID" -> \
"faab8db0-f9a0-4f23-8df2-c0540d61296a"],
Cell[102336, 2658, 4203, 99, 179, "Print", "ExpressionUUID" -> \
"08b34cb8-2654-4c0e-ba6c-cd8b898048af"]
}, Open  ]]
}, Open  ]]
}
]
*)

