(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     93837,       2404]
NotebookOptionsPosition[     90358,       2322]
NotebookOutlinePosition[     90692,       2337]
CellTagsIndexPosition[     90649,       2334]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "This", " ", "file", " ", "calculates", " ", "the", " ", "inner", " ", 
    "product", " ", "pairings", " ", "for", " ", "the", " ", "mod", " ", "p", 
    " ", "orbits", " ", "O14", " ", "and", " ", "OD11"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "y", ",", "A11", ",", " ", "A12", ",", " ", "A13", ",", 
      " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ",
       "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", 
      "B21", ",", " ", "B22", ",", " ", "a11", ",", " ", "a12", ",", " ", 
      "a13", ",", " ", "a21", ",", " ", "a22", ",", " ", "a23", ",", " ", 
      "a31", ",", " ", "a32", ",", " ", "a33", ",", " ", "b11", ",", " ", 
      "b12", ",", " ", "b21", ",", " ", "b22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O14", " ", "=", " ", "Ox"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OD11", " ", "=", " ", "Oxi"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Gact3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a11", ",", " ", "a12", ",", " ", "a13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"a21", ",", "a22", ",", "a23"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "a33"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Gact2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"b11", ",", " ", "b12"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "b22"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x01", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x02", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x11", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"eps4", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x12", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi01", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi02", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi0ACT31", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi01", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi0ACT32", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi02", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi0ACT1", " ", "=", " ", 
     RowBox[{
      RowBox[{"b11", " ", "*", " ", "xi0ACT31"}], " ", "+", " ", 
      RowBox[{"b12", " ", "*", " ", "xi0ACT32"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi0ACT2", " ", "=", " ", 
     RowBox[{"b22", " ", "*", " ", "xi0ACT32"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Pairing0", " ", "=", " ", 
     RowBox[{
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x11", "]"}], ".", "xi0ACT1"}], "]"}], "+", 
      
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x12", "]"}], ".", "xi0ACT2"}], "]"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "x01", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "x02", "]"}], ",", " ", "Pairing0"}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.733834040192012*^9, 3.73383417454156*^9}, {
   3.73383429054252*^9, 3.733834334668531*^9}, {3.7338369238216963`*^9, 
   3.733836959732308*^9}, {3.7338375934586*^9, 3.733837605217167*^9}, {
   3.733837648713428*^9, 3.733837681840667*^9}, {3.733844525192297*^9, 
   3.73384453085526*^9}, 3.7338457926959047`*^9, {3.733845828423773*^9, 
   3.73384592720748*^9}, {3.7338459814150887`*^9, 3.733846011950898*^9}, {
   3.733846531316143*^9, 3.733846535339695*^9}, {3.733846672106317*^9, 
   3.73384680649897*^9}, {3.7338468499142237`*^9, 3.733846857625437*^9}, {
   3.7338485083510847`*^9, 3.733848527694816*^9}, {3.733849502026189*^9, 
   3.733849587161031*^9}, {3.733851668484419*^9, 3.733851669131956*^9}, {
   3.733851702628295*^9, 3.733851710163824*^9}, {3.733851809155324*^9, 
   3.7338518093069983`*^9}, {3.733852109834218*^9, 3.7338521483085537`*^9}, {
   3.733852974551132*^9, 3.733852975304755*^9}, {3.736682031985713*^9, 
   3.736682032136848*^9}, {3.741346272095496*^9, 
   3.741346277934662*^9}},ExpressionUUID->"3c8a540e-0b39-4e87-9e3a-\
45fa18da5cf9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        FractionBox["1", "2"]},
       {"0", "1", "0"},
       {
        FractionBox["1", "2"], "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   RowBox[{"a11", " ", "a12", " ", "b11", " ", "eps4"}]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 
      Rational[1, 2]}, {0, 1, 0}, {
      Rational[1, 2], 0, 
      0}}], $CellContext`a11 $CellContext`a12 $CellContext`b11 \
$CellContext`eps4],
  Editable->False]], "Print",
 CellChangeTimes->{{3.733836933925782*^9, 3.733836960154544*^9}, 
   3.733837683012678*^9, 3.73384332478533*^9, 3.733844540632078*^9, {
   3.733846762552989*^9, 3.7338467820719023`*^9}, 3.7338468595660267`*^9, 
   3.733848534520564*^9, 3.733849610963228*^9, 3.733851824375997*^9, 
   3.733852150875904*^9, 3.733852976507539*^9, 
   3.734183519619767*^9},ExpressionUUID->"4dd71806-70bf-4f70-a85f-\
d9e13d4c08db"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"xiTable", " ", "=", " ", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"2", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"3", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"4", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"5", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"6", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "ell"}], ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"7", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"8", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"9", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"10", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"11", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"12", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"13", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"14", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"15", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"ell", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"16", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"17", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"18", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"ell", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"19", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"20", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Length", "[", "xiTable", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.733838846527213*^9, 3.7338389816092587`*^9}, {
   3.733840103914178*^9, 3.733840549544438*^9}, {3.733841144204008*^9, 
   3.7338411725242*^9}, {3.7338413258745413`*^9, 3.733841449707015*^9}, {
   3.733841647641047*^9, 3.73384165992979*^9}, {3.733841696696742*^9, 
   3.7338417267768*^9}, {3.733841759687078*^9, 3.733841842029541*^9}, {
   3.7338419005518093`*^9, 3.733841964896893*^9}, {3.7338420077764807`*^9, 
   3.733842494494863*^9}, {3.7338425291580353`*^9, 3.73384253410826*^9}, {
   3.733842581916871*^9, 3.7338425987478943`*^9}, {3.7338430232754297`*^9, 
   3.733843031201666*^9}, 3.7338520788959827`*^9, {3.733854888677005*^9, 
   3.733854888891575*^9}},ExpressionUUID->"d57deebf-1798-451d-8c59-\
03dd574c8813"],

Cell[BoxData["20"], "Print",
 CellChangeTimes->{
  3.733842534647914*^9, {3.733842587078554*^9, 3.733842599520444*^9}, 
   3.733843032008008*^9, 3.733843272133623*^9, 3.733844546037567*^9, 
   3.733847018462346*^9, 3.7338485405006533`*^9, 3.7338496218311653`*^9, 
   3.733851834391245*^9, 3.733852160509601*^9, 3.7338548996964417`*^9, 
   3.734183520092486*^9},ExpressionUUID->"e2782899-3efa-408a-9e08-\
c55fbcfa4d88"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"xiTable", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.733843261533099*^9, 
  3.7338432667507677`*^9}},ExpressionUUID->"ad6cde9f-696e-4c0f-9938-\
1eaba3ddff47"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Input",
 CellChangeTimes->{
  3.7338470227121477`*^9},ExpressionUUID->"41edfbdb-73d7-42f5-abc8-\
924a4925e039"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.733847022813574*^9},ExpressionUUID->"dc384c40-c5a9-47ed-85b6-\
940b54e8ab2d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", " ", 
   RowBox[{"i", "\[LessEqual]", 
    RowBox[{"Length", "[", "xiTable", "]"}]}], ",", " ", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Orbit", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"xi11", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", " ", "2"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xi12", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "3"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"xiACT31", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi11", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT32", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi12", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT1", " ", "=", " ", 
     RowBox[{
      RowBox[{"b11", " ", "*", " ", "xiACT31"}], " ", "+", " ", 
      RowBox[{"b12", " ", "*", " ", "xiACT32"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT2", " ", "=", " ", 
     RowBox[{"b22", " ", "*", " ", "xiACT32"}]}], ";", "\[IndentingNewLine]", 
    
    RowBox[{"Pairing", " ", "=", " ", 
     RowBox[{
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x01", "]"}], ".", "xiACT1"}], "]"}], "+", 
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x02", "]"}], ".", "xiACT2"}], "]"}]}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"Orbit", ",", " ", "\"\<\\n\>\"", ",", 
      RowBox[{"MatrixForm", "[", "xi11", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "xi12", "]"}], ",", "\"\<\\n\>\"", ",", " ", 
      
      RowBox[{"Simplify", "[", "Pairing", "]"}], ",", " ", "\"\<\\n\>\"", ",",
       " ", 
      RowBox[{"Simplify", "[", 
       RowBox[{"Pairing", " ", "+", " ", "Pairing0"}], "]"}], ",", " ", 
      "\"\<\\n\>\""}], "]"}], ";"}]}], "\[IndentingNewLine]", "]"}]], "Input",\

 CellChangeTimes->{{3.7338344558294764`*^9, 3.733834473411776*^9}, {
   3.733836101706242*^9, 3.733836173825585*^9}, {3.7338362479212427`*^9, 
   3.733836338560684*^9}, {3.7338364006081953`*^9, 3.7338364411760187`*^9}, 
   3.733836754125835*^9, {3.733836844957556*^9, 3.733836903589159*^9}, {
   3.733836976822104*^9, 3.733837134583942*^9}, {3.733837278606353*^9, 
   3.7338373093731728`*^9}, {3.7338430584741707`*^9, 3.733843230695416*^9}, {
   3.7338433049029493`*^9, 3.733843379702538*^9}, {3.733843573077908*^9, 
   3.733843576709671*^9}, {3.733846898073357*^9, 3.7338469204337587`*^9}, {
   3.7338485461031847`*^9, 3.733848549839365*^9}, {3.733849636003745*^9, 
   3.733849650393408*^9}},ExpressionUUID->"b41f4c0b-48ce-4da6-a961-\
2055109dd660"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{
     SuperscriptBox["a23", "2"], " ", "b22"}], "+", 
    RowBox[{"a13", " ", "a33", " ", "b22"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{
     SuperscriptBox["a23", "2"], " ", "b22"}], "+", 
    RowBox[{"a13", " ", "a33", " ", "b22"}], "+", 
    RowBox[{"a11", " ", "a12", " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[1, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a23^2 \
$CellContext`b22 + $CellContext`a13 $CellContext`a33 $CellContext`b22, 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a23^2 \
$CellContext`b22 + $CellContext`a13 $CellContext`a33 $CellContext`b22 + \
$CellContext`a11 $CellContext`a12 $CellContext`b11 $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.734183521100431*^9},ExpressionUUID->"77fa0405-215a-4658-905e-\
fe16b52b4749"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"a23", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "a22"}], "+", "a23"}], ")"}], " ", "b22"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a12", "+", "a13"}], ")"}], " ", "a33", " ", "b22"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"2", " ", "a22", " ", "a23", " ", "b22"}], "+", 
    RowBox[{
     SuperscriptBox["a23", "2"], " ", "b22"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a12", "+", "a13"}], ")"}], " ", "a33", " ", "b22"}], "+", 
    RowBox[{"a11", " ", "a12", " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[2, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 1}}], 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a23 (
     2 $CellContext`a22 + $CellContext`a23) $CellContext`b22 + \
($CellContext`a12 + $CellContext`a13) $CellContext`a33 $CellContext`b22, 
   "\n", $CellContext`a33^2 $CellContext`b12 + 
   2 $CellContext`a22 $CellContext`a23 $CellContext`b22 + $CellContext`a23^2 \
$CellContext`b22 + ($CellContext`a12 + $CellContext`a13) $CellContext`a33 \
$CellContext`b22 + $CellContext`a11 $CellContext`a12 $CellContext`b11 \
$CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.7341835211542187`*^9},ExpressionUUID->"ff465496-6f23-4f23-9039-\
d7fd816dc0d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "0", "1"},
       {"1", "1", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"a23", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "a21"}], "+", 
       RowBox[{"2", " ", "a22"}], "+", "a23"}], ")"}], " ", "b22"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a11", "+", "a12", "+", "a13"}], ")"}], " ", "a33", " ", 
     "b22"}]}], "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"2", " ", "a21", " ", "a23", " ", "b22"}], "+", 
    RowBox[{"2", " ", "a22", " ", "a23", " ", "b22"}], "+", 
    RowBox[{
     SuperscriptBox["a23", "2"], " ", "b22"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a11", "+", "a12", "+", "a13"}], ")"}], " ", "a33", " ", 
     "b22"}], "+", 
    RowBox[{"a11", " ", "a12", " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[3, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 1}, {0, 0, 1}, {1, 1, 1}}], 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a23 (
     2 $CellContext`a21 + 
     2 $CellContext`a22 + $CellContext`a23) $CellContext`b22 + \
($CellContext`a11 + $CellContext`a12 + $CellContext`a13) $CellContext`a33 \
$CellContext`b22, "\n", $CellContext`a33^2 $CellContext`b12 + 
   2 $CellContext`a21 $CellContext`a23 $CellContext`b22 + 
   2 $CellContext`a22 $CellContext`a23 $CellContext`b22 + $CellContext`a23^2 \
$CellContext`b22 + ($CellContext`a11 + $CellContext`a12 + $CellContext`a13) \
$CellContext`a33 $CellContext`b22 + $CellContext`a11 $CellContext`a12 \
$CellContext`b11 $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.734183521156137*^9},ExpressionUUID->"505a576c-c266-4941-89f6-\
6de30c9a4428"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"-", "ell"}], "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"a13", " ", "a33", " ", "b22"}], "+", 
    RowBox[{"b22", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a23", "2"], "-", 
       RowBox[{
        SuperscriptBox["a22", "2"], " ", "ell"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{
     SuperscriptBox["a23", "2"], " ", "b22"}], "+", 
    RowBox[{"a13", " ", "a33", " ", "b22"}], "-", 
    RowBox[{
     SuperscriptBox["a22", "2"], " ", "b22", " ", "ell"}], "+", 
    RowBox[{"a11", " ", "a12", " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[4, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, -$CellContext`ell, 0}, {0, 0, 1}}], 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a13 \
$CellContext`a33 $CellContext`b22 + $CellContext`b22 ($CellContext`a23^2 - \
$CellContext`a22^2 $CellContext`ell), 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a23^2 \
$CellContext`b22 + $CellContext`a13 $CellContext`a33 $CellContext`b22 - \
$CellContext`a22^2 $CellContext`b22 $CellContext`ell + $CellContext`a11 \
$CellContext`a12 $CellContext`b11 $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.7341835211577044`*^9},ExpressionUUID->"e67a7528-1fd3-416d-a872-\
b23c247afeb8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", 
        RowBox[{"-", "ell"}], "0"},
       {"1", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a11", "+", "a13"}], ")"}], " ", "a33", " ", "b22"}], "+", 
    RowBox[{"b22", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "a21", " ", "a23"}], "+", 
       SuperscriptBox["a23", "2"], "-", 
       RowBox[{
        SuperscriptBox["a22", "2"], " ", "ell"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"2", " ", "a21", " ", "a23", " ", "b22"}], "+", 
    RowBox[{
     SuperscriptBox["a23", "2"], " ", "b22"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a11", "+", "a13"}], ")"}], " ", "a33", " ", "b22"}], "-", 
    RowBox[{
     SuperscriptBox["a22", "2"], " ", "b22", " ", "ell"}], "+", 
    RowBox[{"a11", " ", "a12", " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[5, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 1}, {0, -$CellContext`ell, 0}, {1, 0, 1}}], 
   "\n", $CellContext`a33^2 $CellContext`b12 + ($CellContext`a11 + \
$CellContext`a13) $CellContext`a33 $CellContext`b22 + $CellContext`b22 (
     2 $CellContext`a21 $CellContext`a23 + $CellContext`a23^2 - \
$CellContext`a22^2 $CellContext`ell), 
   "\n", $CellContext`a33^2 $CellContext`b12 + 
   2 $CellContext`a21 $CellContext`a23 $CellContext`b22 + $CellContext`a23^2 \
$CellContext`b22 + ($CellContext`a11 + $CellContext`a13) $CellContext`a33 \
$CellContext`b22 - $CellContext`a22^2 $CellContext`b22 $CellContext`ell + \
$CellContext`a11 $CellContext`a12 $CellContext`b11 $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.7341835211594954`*^9},ExpressionUUID->"d303cd0d-8bb4-4071-aa5d-\
0a5b238e3a63"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "ell"}], "0", "0"},
       {"0", 
        RowBox[{"-", "ell"}], "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"a13", " ", "a33", " ", "b22"}], "+", 
    RowBox[{"b22", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a23", "2"], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a21", "2"], "+", 
          SuperscriptBox["a22", "2"]}], ")"}], " ", "ell"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"a13", " ", "a33", " ", "b22"}], "+", 
    RowBox[{"b22", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a23", "2"], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a21", "2"], "+", 
          SuperscriptBox["a22", "2"]}], ")"}], " ", "ell"}]}], ")"}]}], "+", 
    RowBox[{"a11", " ", "a12", " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[6, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{-$CellContext`ell, 0, 0}, {0, -$CellContext`ell, 0}, {0, 0, 
     1}}], "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a13 \
$CellContext`a33 $CellContext`b22 + $CellContext`b22 ($CellContext`a23^2 - \
($CellContext`a21^2 + $CellContext`a22^2) $CellContext`ell), 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a13 \
$CellContext`a33 $CellContext`b22 + $CellContext`b22 ($CellContext`a23^2 - \
($CellContext`a21^2 + $CellContext`a22^2) $CellContext`ell) + \
$CellContext`a11 $CellContext`a12 $CellContext`b11 $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.734183521161175*^9},ExpressionUUID->"fb0b0cfb-0287-483e-b053-\
6e119a751b50"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "a22", " ", "a23"}], "+", 
      RowBox[{"a12", " ", "a33"}]}], ")"}], " ", "b22"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", "a22", " ", "a23", " ", "b22"}], "+", 
    RowBox[{"a12", " ", "a33", " ", "b22"}], "+", 
    RowBox[{"a11", " ", "a12", " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[7, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}}], 
   "\n", (2 $CellContext`a22 $CellContext`a23 + $CellContext`a12 \
$CellContext`a33) $CellContext`b22, "\n", 
   2 $CellContext`a22 $CellContext`a23 $CellContext`b22 + $CellContext`a12 \
$CellContext`a33 $CellContext`b22 + $CellContext`a11 $CellContext`a12 \
$CellContext`b11 $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.7341835211627073`*^9},ExpressionUUID->"71b320f4-1270-4a49-917c-\
ba7754814f97"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "0", "1"},
       {"1", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "a21", " ", "a23"}], "+", 
      RowBox[{"2", " ", "a22", " ", "a23"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a11", "+", "a12"}], ")"}], " ", "a33"}]}], ")"}], " ", 
    "b22"}], "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", "a21", " ", "a23", " ", "b22"}], "+", 
    RowBox[{"2", " ", "a22", " ", "a23", " ", "b22"}], "+", 
    RowBox[{"a11", " ", "a33", " ", "b22"}], "+", 
    RowBox[{"a12", " ", "a33", " ", "b22"}], "+", 
    RowBox[{"a11", " ", "a12", " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[8, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 1}, {0, 0, 1}, {1, 1, 0}}], 
   "\n", (2 $CellContext`a21 $CellContext`a23 + 
    2 $CellContext`a22 $CellContext`a23 + ($CellContext`a11 + \
$CellContext`a12) $CellContext`a33) $CellContext`b22, "\n", 
   2 $CellContext`a21 $CellContext`a23 $CellContext`b22 + 
   2 $CellContext`a22 $CellContext`a23 $CellContext`b22 + $CellContext`a11 \
$CellContext`a33 $CellContext`b22 + $CellContext`a12 $CellContext`a33 \
$CellContext`b22 + $CellContext`a11 $CellContext`a12 $CellContext`b11 \
$CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.734183521164153*^9},ExpressionUUID->"bc62ef5d-9ac2-40e4-bad7-\
2cc1738ec031"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a21", "2"], "+", 
      RowBox[{"2", " ", "a22", " ", "a23"}], "+", 
      RowBox[{"a12", " ", "a33"}]}], ")"}], " ", "b22"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a21", "2"], " ", "b22"}], "+", 
    RowBox[{"2", " ", "a22", " ", "a23", " ", "b22"}], "+", 
    RowBox[{"a12", " ", "a33", " ", "b22"}], "+", 
    RowBox[{"a11", " ", "a12", " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[9, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{1, 0, 0}, {0, 0, 1}, {0, 1, 0}}], 
   "\n", ($CellContext`a21^2 + (
      2 $CellContext`a22) $CellContext`a23 + $CellContext`a12 \
$CellContext`a33) $CellContext`b22, 
   "\n", $CellContext`a21^2 $CellContext`b22 + ((
      2 $CellContext`a22) $CellContext`a23) $CellContext`b22 + \
($CellContext`a12 $CellContext`a33) $CellContext`b22 + (($CellContext`a11 \
$CellContext`a12) $CellContext`b11) $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.734183521165626*^9},ExpressionUUID->"c3fec486-f5a6-4159-83ab-\
1f071420dd39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{"2", " ", "a22", " ", "a23", " ", "b22"}], "+", 
    RowBox[{"a12", " ", "a33", " ", "b22"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{"2", " ", "a22", " ", "a23", " ", "b22"}], "+", 
    RowBox[{"a12", " ", "a33", " ", "b22"}], "+", 
    RowBox[{"a11", " ", "a12", " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[10, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11 + 
   2 $CellContext`a22 $CellContext`a23 $CellContext`b22 + $CellContext`a12 \
$CellContext`a33 $CellContext`b22, "\n", $CellContext`a33^2 $CellContext`b11 + 
   2 $CellContext`a22 $CellContext`a23 $CellContext`b22 + $CellContext`a12 \
$CellContext`a33 $CellContext`b22 + $CellContext`a11 $CellContext`a12 \
$CellContext`b11 $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.734183521167098*^9},ExpressionUUID->"32b79553-aff1-45c6-8bd3-\
79b44c355a04"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"11", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "0", "1"},
       {"1", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"a21", "+", "a22"}], ")"}], " ", "a23", " ", "b22"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a11", "+", "a12"}], ")"}], " ", "a33", " ", "b22"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{"2", " ", "a21", " ", "a23", " ", "b22"}], "+", 
    RowBox[{"2", " ", "a22", " ", "a23", " ", "b22"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a11", "+", "a12"}], ")"}], " ", "a33", " ", "b22"}], "+", 
    RowBox[{"a11", " ", "a12", " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[11, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 1}, {0, 0, 1}, {1, 1, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11 + 
   2 ($CellContext`a21 + $CellContext`a22) $CellContext`a23 $CellContext`b22 + \
($CellContext`a11 + $CellContext`a12) $CellContext`a33 $CellContext`b22, 
   "\n", $CellContext`a33^2 $CellContext`b11 + 
   2 $CellContext`a21 $CellContext`a23 $CellContext`b22 + 
   2 $CellContext`a22 $CellContext`a23 $CellContext`b22 + ($CellContext`a11 + \
$CellContext`a12) $CellContext`a33 $CellContext`b22 + $CellContext`a11 \
$CellContext`a12 $CellContext`b11 $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.734183521168569*^9},ExpressionUUID->"8b9f8807-f13d-4a72-b667-\
1c954d624927"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"12", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a21", "2"], "+", 
       RowBox[{"2", " ", "a22", " ", "a23"}]}], ")"}], " ", "b22"}], "+", 
    RowBox[{"a12", " ", "a33", " ", "b22"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{
     SuperscriptBox["a21", "2"], " ", "b22"}], "+", 
    RowBox[{"2", " ", "a22", " ", "a23", " ", "b22"}], "+", 
    RowBox[{"a12", " ", "a33", " ", "b22"}], "+", 
    RowBox[{"a11", " ", "a12", " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[12, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{1, 0, 0}, {0, 0, 1}, {0, 1, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11 + ($CellContext`a21^2 + 
     2 $CellContext`a22 $CellContext`a23) $CellContext`b22 + $CellContext`a12 \
$CellContext`a33 $CellContext`b22, 
   "\n", $CellContext`a33^2 $CellContext`b11 + $CellContext`a21^2 \
$CellContext`b22 + 
   2 $CellContext`a22 $CellContext`a23 $CellContext`b22 + $CellContext`a12 \
$CellContext`a33 $CellContext`b22 + $CellContext`a11 $CellContext`a12 \
$CellContext`b11 $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.734183521170076*^9},ExpressionUUID->"ac0f1b77-c1c1-484b-a04e-\
26c8c8f42a65"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"13", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a22", "2"], " ", "b22"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a22", "2"], " ", "b22"}], "+", 
    RowBox[{"a11", " ", "a12", " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[13, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   "\n", $CellContext`a22^2 $CellContext`b22, 
   "\n", $CellContext`a22^2 $CellContext`b22 + $CellContext`a11 \
$CellContext`a12 $CellContext`b11 $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.734183521171496*^9},ExpressionUUID->"3c0fd642-3f37-43f9-a4db-\
4edb49195e3e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"14", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a21", "2"], "+", 
      SuperscriptBox["a22", "2"]}], ")"}], " ", "b22"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a21", "2"], "+", 
       SuperscriptBox["a22", "2"]}], ")"}], " ", "b22"}], "+", 
    RowBox[{"a11", " ", "a12", " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[14, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{1, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   "\n", ($CellContext`a21^2 + $CellContext`a22^2) $CellContext`b22, 
   "\n", ($CellContext`a21^2 + $CellContext`a22^2) $CellContext`b22 + \
$CellContext`a11 $CellContext`a12 $CellContext`b11 $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.734183521172846*^9},ExpressionUUID->"c627b72e-5f62-49a0-bd0d-\
4323d51cbcc5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"15", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"ell", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"b22", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a22", "2"], "+", 
      RowBox[{
       SuperscriptBox["a21", "2"], " ", "ell"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a22", "2"], " ", "b22"}], "+", 
    RowBox[{
     SuperscriptBox["a21", "2"], " ", "b22", " ", "ell"}], "+", 
    RowBox[{"a11", " ", "a12", " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[15, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{$CellContext`ell, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   "\n", $CellContext`b22 ($CellContext`a22^2 + $CellContext`a21^2 \
$CellContext`ell), 
   "\n", $CellContext`a22^2 $CellContext`b22 + $CellContext`a21^2 \
$CellContext`b22 $CellContext`ell + $CellContext`a11 $CellContext`a12 \
$CellContext`b11 $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.7341835211742687`*^9},ExpressionUUID->"8c27ea69-ae10-4734-a89f-\
f2a803a04fea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"16", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{
     SuperscriptBox["a22", "2"], " ", "b22"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{
     SuperscriptBox["a22", "2"], " ", "b22"}], "+", 
    RowBox[{"a11", " ", "a12", " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[16, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11 + $CellContext`a22^2 \
$CellContext`b22, 
   "\n", $CellContext`a33^2 $CellContext`b11 + $CellContext`a22^2 \
$CellContext`b22 + $CellContext`a11 $CellContext`a12 $CellContext`b11 \
$CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.734183521175618*^9},ExpressionUUID->"4e2a0bbe-6769-4be9-906f-\
8946ebffc7a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"17", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a21", "2"], "+", 
       SuperscriptBox["a22", "2"]}], ")"}], " ", "b22"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a21", "2"], "+", 
       SuperscriptBox["a22", "2"]}], ")"}], " ", "b22"}], "+", 
    RowBox[{"a11", " ", "a12", " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[17, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{1, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11 + ($CellContext`a21^2 + \
$CellContext`a22^2) $CellContext`b22, 
   "\n", $CellContext`a33^2 $CellContext`b11 + ($CellContext`a21^2 + \
$CellContext`a22^2) $CellContext`b22 + $CellContext`a11 $CellContext`a12 \
$CellContext`b11 $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.734183521177001*^9},ExpressionUUID->"341c3393-2625-4b2f-afd3-\
5a7fb99d6150"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"18", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"ell", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{"b22", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a22", "2"], "+", 
       RowBox[{
        SuperscriptBox["a21", "2"], " ", "ell"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{
     SuperscriptBox["a22", "2"], " ", "b22"}], "+", 
    RowBox[{
     SuperscriptBox["a21", "2"], " ", "b22", " ", "ell"}], "+", 
    RowBox[{"a11", " ", "a12", " ", "b11", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[18, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{$CellContext`ell, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11 + $CellContext`b22 \
($CellContext`a22^2 + $CellContext`a21^2 $CellContext`ell), 
   "\n", $CellContext`a33^2 $CellContext`b11 + $CellContext`a22^2 \
$CellContext`b22 + $CellContext`a21^2 $CellContext`b22 $CellContext`ell + \
$CellContext`a11 $CellContext`a12 $CellContext`b11 $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.7341835211784983`*^9},ExpressionUUID->"0f13d563-45fd-44c7-bd90-\
d252659db2a2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"19", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a33", "2"], " ", "b11"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"b11", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a33", "2"], "+", 
      RowBox[{"a11", " ", "a12", " ", "eps4"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[19, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11, 
   "\n", $CellContext`b11 ($CellContext`a33^2 + $CellContext`a11 \
$CellContext`a12 $CellContext`eps4), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.7341835211799297`*^9},ExpressionUUID->"986bdc88-61e9-4c94-8db8-\
b97d4794e2aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"20", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "0", "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"a11", " ", "a12", " ", "b11", " ", "eps4"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[20, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], "\n", 0, 
   "\n", $CellContext`a11 $CellContext`a12 $CellContext`b11 $CellContext`eps4,
    "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.734183521181234*^9},ExpressionUUID->"b7e74437-e877-4d3d-850b-\
1e08ccbf178c"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.733853378040228*^9, 
  3.7338533898349113`*^9}},ExpressionUUID->"074ff94a-b3a4-45e5-bbf8-\
88d5cfa1f5a5"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.733853387306457*^9, 
  3.7338533873217497`*^9}},ExpressionUUID->"80dca7f9-6c2d-4b59-ac73-\
5ee767cfdaeb"]
},
WindowSize->{808, 911},
WindowMargins->{{Automatic, 29}, {3, Automatic}},
FrontEndVersion->"11.1 for Linux x86 (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 6345, 166, 469, "Input", "ExpressionUUID" -> \
"812ba2ba-fe05-44c9-8fc7-34cef85fb4b9"],
Cell[6928, 190, 2138, 56, 79, "Print", "ExpressionUUID" -> \
"3064d4ea-a6d5-4a10-9630-47ff199b8cfe"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9103, 251, 14575, 403, 538, "Input", "ExpressionUUID" -> \
"fb76f0a9-bd65-4af2-ac7f-979b0b8acc5f"],
Cell[23681, 656, 418, 7, 24, "Print", "ExpressionUUID" -> \
"ec4beac4-02ce-4a25-a6c3-4a1b9dccb24e"]
}, Open  ]],
Cell[24114, 666, 248, 6, 55, "Input", "ExpressionUUID" -> \
"a6cba442-83af-4cbe-80c9-ed99a9adeaad"],
Cell[CellGroupData[{
Cell[24387, 676, 682, 21, 34, "Input", "ExpressionUUID" -> \
"87a9477f-79b2-4a0d-8098-a6258de006b2"],
Cell[25072, 699, 681, 21, 34, "Output", "ExpressionUUID" -> \
"d17036f2-841b-4021-83ae-eb8a5fb2796c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25790, 725, 2978, 67, 286, "Input", "ExpressionUUID" -> \
"8f36e8e2-f1be-43cd-9008-94f098dcbb60"],
Cell[CellGroupData[{
Cell[28793, 796, 2981, 71, 151, "Print", "ExpressionUUID" -> \
"23152fc8-d102-4bf2-b4f1-a7d3152c6a6d"],
Cell[31777, 869, 3369, 81, 151, "Print", "ExpressionUUID" -> \
"b5b80298-3946-4d75-a673-efcea50a1925"],
Cell[35149, 952, 3622, 86, 173, "Print", "ExpressionUUID" -> \
"48f191d8-fb94-441d-8d6d-be89c268cb33"],
Cell[38774, 1040, 3319, 80, 158, "Print", "ExpressionUUID" -> \
"c939358f-66d4-4bbc-a99e-d7948d513887"],
Cell[42096, 1122, 3687, 88, 158, "Print", "ExpressionUUID" -> \
"37c31eb8-1448-4116-93b7-0b52af6f909a"],
Cell[45786, 1212, 3621, 89, 165, "Print", "ExpressionUUID" -> \
"51879d52-8dc3-4ea7-9689-118d94b4f995"],
Cell[49410, 1303, 2817, 67, 147, "Print", "ExpressionUUID" -> \
"9554b247-a03a-4b42-945d-19f3f4968067"],
Cell[52230, 1372, 3216, 75, 147, "Print", "ExpressionUUID" -> \
"e748bc0d-3da3-4b27-ba5d-b270733bddc6"],
Cell[55449, 1449, 3006, 72, 158, "Print", "ExpressionUUID" -> \
"c94073b4-2ace-4836-a791-7f3d9bc1727d"],
Cell[58458, 1523, 3011, 70, 151, "Print", "ExpressionUUID" -> \
"4ef25bfd-f3d2-44e2-9ff7-3ddb11238918"],
Cell[61472, 1595, 3363, 79, 151, "Print", "ExpressionUUID" -> \
"63e427d7-1169-464a-87b8-80af54a8e7d4"],
Cell[64838, 1676, 3248, 78, 158, "Print", "ExpressionUUID" -> \
"fba1eb7e-fe6c-4a19-b37d-08856bcd4b91"],
Cell[68089, 1756, 2547, 62, 151, "Print", "ExpressionUUID" -> \
"5d66e284-14b2-4e25-9bd8-08fcc2f446eb"],
Cell[70639, 1820, 2762, 68, 165, "Print", "ExpressionUUID" -> \
"92647e78-adcc-49a7-b402-ed64363f01ae"],
Cell[73404, 1890, 2856, 70, 158, "Print", "ExpressionUUID" -> \
"65e18e4e-c68a-4cab-a7a7-f9fab34c7bc8"],
Cell[76263, 1962, 2775, 69, 151, "Print", "ExpressionUUID" -> \
"a81d609e-c7c7-4972-9d63-5f01c51ce2b2"],
Cell[79041, 2033, 2993, 75, 165, "Print", "ExpressionUUID" -> \
"c6c5711c-9603-416c-872f-95d2d6c736e0"],
Cell[82037, 2110, 3084, 75, 158, "Print", "ExpressionUUID" -> \
"7fe13a75-7b0a-402e-8af0-56daf868b9dc"],
Cell[85124, 2187, 2551, 63, 157, "Print", "ExpressionUUID" -> \
"6bdb7508-c7d0-4b89-8469-01764fbeafb0"],
Cell[87678, 2252, 2338, 56, 147, "Print", "ExpressionUUID" -> \
"f75dc48d-fa2f-4d61-a9ce-eb0924c23fe8"]
}, Open  ]]
}, Open  ]],
Cell[90043, 2312, 154, 3, 32, "Input", "ExpressionUUID" -> \
"6cdf359b-649b-4553-95f1-dfc4ae76dc82"],
Cell[90200, 2317, 154, 3, 32, "Input", "ExpressionUUID" -> \
"cc872c58-eb03-4a80-b8c1-64ecafa63544"]
}
]
*)

