(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     32757,        861]
NotebookOptionsPosition[     30964,        811]
NotebookOutlinePosition[     31297,        826]
CellTagsIndexPosition[     31254,        823]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "x", ",", " ", "y", ",", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ",
     "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", 
    "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21",
     ",", " ", "B22", ",", " ", "a11", ",", " ", "a12", ",", " ", "a13", ",", 
    " ", "a21", ",", " ", "a22", ",", " ", "a23", ",", " ", "a31", ",", " ", 
    "a32", ",", " ", "a33", ",", " ", "b11", ",", " ", "b12", ",", " ", "b21",
     ",", " ", "b22", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", 
    "d", ",", " ", "e"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"O14", " ", "=", " ", "Ox"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"O14", " ", "=", " ", "Oxi"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b11", " ", "=", " ", "d"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b22", " ", "=", " ", "e"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Gact3", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", " ", "a12", ",", " ", "a13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "b", ",", "a23"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "c"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Gact2", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b11", ",", " ", "b12"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "b22"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x01", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x02", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"1", "/", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x11", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"eps4", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x12", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xi01", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xi02", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xi0ACT31", " ", "=", " ", 
   RowBox[{"Gact3", ".", "xi01", ".", 
    RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xi0ACT32", " ", "=", " ", 
   RowBox[{"Gact3", ".", "xi02", ".", 
    RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xi0ACT1", " ", "=", " ", 
   RowBox[{
    RowBox[{"b11", " ", "*", " ", "xi0ACT31"}], " ", "+", " ", 
    RowBox[{"b12", " ", "*", " ", "xi0ACT32"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xi0ACT2", " ", "=", " ", 
   RowBox[{"b22", " ", "*", " ", "xi0ACT32"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Pairing0", " ", "=", " ", 
   RowBox[{
    RowBox[{"Tr", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", "x11", "]"}], ".", "xi0ACT1"}], "]"}], "+", 
    RowBox[{"Tr", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", "x12", "]"}], ".", "xi0ACT2"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
    RowBox[{"MatrixForm", "[", "x01", "]"}], ",", " ", 
    RowBox[{"MatrixForm", "[", "x02", "]"}], ",", " ", "Pairing0"}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.733834040192012*^9, 3.73383417454156*^9}, {
   3.73383429054252*^9, 3.733834334668531*^9}, {3.7338369238216963`*^9, 
   3.733836959732308*^9}, {3.7338375934586*^9, 3.733837605217167*^9}, {
   3.733837648713428*^9, 3.733837681840667*^9}, {3.733844525192297*^9, 
   3.73384453085526*^9}, 3.7338457926959047`*^9, {3.733845828423773*^9, 
   3.73384592720748*^9}, {3.7338459814150887`*^9, 3.733846011950898*^9}, {
   3.733846531316143*^9, 3.733846535339695*^9}, {3.733846672106317*^9, 
   3.73384680649897*^9}, {3.7338468499142237`*^9, 3.733846857625437*^9}, {
   3.7338485083510847`*^9, 3.733848527694816*^9}, {3.733849502026189*^9, 
   3.733849587161031*^9}, {3.733851668484419*^9, 3.733851669131956*^9}, {
   3.733851702628295*^9, 3.733851710163824*^9}, {3.733851809155324*^9, 
   3.7338518093069983`*^9}, {3.733852109834218*^9, 3.7338521483085537`*^9}, {
   3.733852974551132*^9, 3.733852975304755*^9}, {3.7338558722840242`*^9, 
   3.7338558784910707`*^9}, {3.733855926027398*^9, 3.7338560071784554`*^9}, {
   3.733856045882557*^9, 3.733856069393948*^9}, {3.7366829977423553`*^9, 
   3.736682997917397*^9}, {3.7413467489645348`*^9, 3.7413467527801733`*^9}, 
   3.741608805093364*^9},ExpressionUUID->"4b3f1573-c959-4f1d-b618-\
c60f33db4728"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        FractionBox["1", "2"]},
       {"0", "1", "0"},
       {
        FractionBox["1", "2"], "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", "b12"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a12", "2"], "-", 
         RowBox[{"2", " ", "a", " ", "a13"}]}], ")"}], " ", "d"}]}], ")"}], 
    " ", "eps4"}]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 
      Rational[1, 2]}, {0, 1, 0}, {
      Rational[1, 2], 0, 0}}], (
    2 $CellContext`a^2 $CellContext`b12 + ($CellContext`a12^2 - 
      2 $CellContext`a $CellContext`a13) $CellContext`d) $CellContext`eps4],
  Editable->False]], "Print",
 CellChangeTimes->{{3.733836933925782*^9, 3.733836960154544*^9}, 
   3.733837683012678*^9, 3.73384332478533*^9, 3.733844540632078*^9, {
   3.733846762552989*^9, 3.7338467820719023`*^9}, 3.7338468595660267`*^9, 
   3.733848534520564*^9, 3.733849610963228*^9, 3.733851824375997*^9, 
   3.733852150875904*^9, 3.733852976507539*^9, 3.733856071832325*^9, 
   3.7413467656440573`*^9},ExpressionUUID->"be7e433e-d750-4fdd-8d9c-\
c8d49627df88"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"xiTable", " ", "=", " ", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"2", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"3", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           RowBox[{"-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"4", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Length", "[", "xiTable", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.733838846527213*^9, 3.7338389816092587`*^9}, {
   3.733840103914178*^9, 3.733840549544438*^9}, {3.733841144204008*^9, 
   3.7338411725242*^9}, {3.7338413258745413`*^9, 3.733841449707015*^9}, {
   3.733841647641047*^9, 3.73384165992979*^9}, {3.733841696696742*^9, 
   3.7338417267768*^9}, {3.733841759687078*^9, 3.733841842029541*^9}, {
   3.7338419005518093`*^9, 3.733841964896893*^9}, {3.7338420077764807`*^9, 
   3.733842494494863*^9}, {3.7338425291580353`*^9, 3.73384253410826*^9}, {
   3.733842581916871*^9, 3.7338425987478943`*^9}, {3.7338430232754297`*^9, 
   3.733843031201666*^9}, 3.7338520788959827`*^9, {3.733854888677005*^9, 
   3.733854888891575*^9}, {3.733856185972526*^9, 
   3.73385623787916*^9}},ExpressionUUID->"a1578a4a-04c4-4956-b6e9-\
938c42817e25"],

Cell[BoxData["4"], "Print",
 CellChangeTimes->{
  3.733842534647914*^9, {3.733842587078554*^9, 3.733842599520444*^9}, 
   3.733843032008008*^9, 3.733843272133623*^9, 3.733844546037567*^9, 
   3.733847018462346*^9, 3.7338485405006533`*^9, 3.7338496218311653`*^9, 
   3.733851834391245*^9, 3.733852160509601*^9, 3.7338548996964417`*^9, 
   3.733856239948132*^9, 
   3.741346771281126*^9},ExpressionUUID->"e99a1044-c0a2-4839-8f40-\
99987f9f81aa"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"xiTable", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.733843261533099*^9, 
  3.7338432667507677`*^9}},ExpressionUUID->"ad6cde9f-696e-4c0f-9938-\
1eaba3ddff47"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Input",
 CellChangeTimes->{
  3.7338470227121477`*^9},ExpressionUUID->"41edfbdb-73d7-42f5-abc8-\
924a4925e039"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.733847022813574*^9},ExpressionUUID->"dc384c40-c5a9-47ed-85b6-\
940b54e8ab2d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", " ", 
   RowBox[{"i", "\[LessEqual]", 
    RowBox[{"Length", "[", "xiTable", "]"}]}], ",", " ", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Orbit", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"xi11", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", " ", "2"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xi12", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "3"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"xiACT31", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi11", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT32", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi12", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT1", " ", "=", " ", 
     RowBox[{
      RowBox[{"b11", " ", "*", " ", "xiACT31"}], " ", "+", " ", 
      RowBox[{"b12", " ", "*", " ", "xiACT32"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT2", " ", "=", " ", 
     RowBox[{"b22", " ", "*", " ", "xiACT32"}]}], ";", "\[IndentingNewLine]", 
    
    RowBox[{"Pairing", " ", "=", " ", 
     RowBox[{
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x01", "]"}], ".", "xiACT1"}], "]"}], "+", 
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x02", "]"}], ".", "xiACT2"}], "]"}]}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"Orbit", ",", " ", "\"\<\\n\>\"", ",", 
      RowBox[{"MatrixForm", "[", "xi11", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "xi12", "]"}], ",", "\"\<\\n\>\"", ",", " ", 
      
      RowBox[{"Expand", "[", "Pairing", "]"}], ",", " ", "\"\<\\n\>\"", ",", 
      " ", 
      RowBox[{"Expand", "[", 
       RowBox[{"Pairing", " ", "+", " ", "Pairing0"}], "]"}], ",", " ", 
      "\"\<\\n\>\""}], "]"}], ";"}]}], "\[IndentingNewLine]", "]"}]], "Input",\

 CellChangeTimes->{{3.7338344558294764`*^9, 3.733834473411776*^9}, {
   3.733836101706242*^9, 3.733836173825585*^9}, {3.7338362479212427`*^9, 
   3.733836338560684*^9}, {3.7338364006081953`*^9, 3.7338364411760187`*^9}, 
   3.733836754125835*^9, {3.733836844957556*^9, 3.733836903589159*^9}, {
   3.733836976822104*^9, 3.733837134583942*^9}, {3.733837278606353*^9, 
   3.7338373093731728`*^9}, {3.7338430584741707`*^9, 3.733843230695416*^9}, {
   3.7338433049029493`*^9, 3.733843379702538*^9}, {3.733843573077908*^9, 
   3.733843576709671*^9}, {3.733846898073357*^9, 3.7338469204337587`*^9}, {
   3.7338485461031847`*^9, 3.733848549839365*^9}, {3.733849636003745*^9, 
   3.733849650393408*^9}, {3.733856278948269*^9, 
   3.733856286370245*^9}},ExpressionUUID->"18fed3ab-4644-4176-a3c3-\
bba051731673"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"b12", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a23", "2"], " ", "e"}], "+", 
    RowBox[{"a13", " ", "c", " ", "e"}]}], "\[InvisibleSpace]", "\<\"\\n\"\>",
    "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"b12", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["a23", "2"], " ", "e"}], "+", 
    RowBox[{"a13", " ", "c", " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "b12", " ", "eps4"}], "+", 
    RowBox[{
     SuperscriptBox["a12", "2"], " ", "d", " ", "eps4"}], "-", 
    RowBox[{"2", " ", "a", " ", "a13", " ", "d", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[1, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   "\n", $CellContext`b12 $CellContext`c^2 + $CellContext`a23^2 \
$CellContext`e + $CellContext`a13 $CellContext`c $CellContext`e, 
   "\n", $CellContext`b12 $CellContext`c^2 + $CellContext`a23^2 \
$CellContext`e + $CellContext`a13 $CellContext`c $CellContext`e + 
   2 $CellContext`a^2 $CellContext`b12 $CellContext`eps4 + $CellContext`a12^2 \
$CellContext`d $CellContext`eps4 - 
   2 $CellContext`a $CellContext`a13 $CellContext`d $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.733856246562848*^9, 3.733856286853465*^9, 
   3.7413467737598*^9},ExpressionUUID->"e09a3038-3a1f-4831-bf41-9ed9f0183e39"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", "a23", " ", "b", " ", "e"}], "+", 
    RowBox[{"a12", " ", "c", " ", "e"}]}], "\[InvisibleSpace]", "\<\"\\n\"\>",
    "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", "a23", " ", "b", " ", "e"}], "+", 
    RowBox[{"a12", " ", "c", " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "b12", " ", "eps4"}], "+", 
    RowBox[{
     SuperscriptBox["a12", "2"], " ", "d", " ", "eps4"}], "-", 
    RowBox[{"2", " ", "a", " ", "a13", " ", "d", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[2, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}}], "\n", 
   2 $CellContext`a23 $CellContext`b $CellContext`e + $CellContext`a12 \
$CellContext`c $CellContext`e, "\n", 
   2 $CellContext`a23 $CellContext`b $CellContext`e + $CellContext`a12 \
$CellContext`c $CellContext`e + 
   2 $CellContext`a^2 $CellContext`b12 $CellContext`eps4 + $CellContext`a12^2 \
$CellContext`d $CellContext`eps4 - 
   2 $CellContext`a $CellContext`a13 $CellContext`d $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.733856246562848*^9, 3.733856286853465*^9, 
   3.7413467737626867`*^9},ExpressionUUID->"03e6b455-40f5-4f1a-b208-\
f249b63f4170"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{"-", "1"}]},
       {"0", "1", "0"},
       {
        RowBox[{"-", "1"}], "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["c", "2"], " ", "d"}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "e"}], "-", 
    RowBox[{"a", " ", "c", " ", "e"}]}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["c", "2"], " ", "d"}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "e"}], "-", 
    RowBox[{"a", " ", "c", " ", "e"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "b12", " ", "eps4"}], "+", 
    RowBox[{
     SuperscriptBox["a12", "2"], " ", "d", " ", "eps4"}], "-", 
    RowBox[{"2", " ", "a", " ", "a13", " ", "d", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[3, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, -1}, {0, 1, 0}, {-1, 0, 0}}], 
   "\n", $CellContext`c^2 $CellContext`d + $CellContext`b^2 $CellContext`e - \
$CellContext`a $CellContext`c $CellContext`e, 
   "\n", $CellContext`c^2 $CellContext`d + $CellContext`b^2 $CellContext`e - \
$CellContext`a $CellContext`c $CellContext`e + 
   2 $CellContext`a^2 $CellContext`b12 $CellContext`eps4 + $CellContext`a12^2 \
$CellContext`d $CellContext`eps4 - 
   2 $CellContext`a $CellContext`a13 $CellContext`d $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.733856246562848*^9, 3.733856286853465*^9, 
   3.741346773765793*^9},ExpressionUUID->"549d5045-218e-45a4-bc88-\
aa891e44a4dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "0", "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"], " ", "b12", " ", "eps4"}], "+", 
    RowBox[{
     SuperscriptBox["a12", "2"], " ", "d", " ", "eps4"}], "-", 
    RowBox[{"2", " ", "a", " ", "a13", " ", "d", " ", "eps4"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[4, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], "\n", 0, "\n", 
   2 $CellContext`a^2 $CellContext`b12 $CellContext`eps4 + $CellContext`a12^2 \
$CellContext`d $CellContext`eps4 - 
   2 $CellContext`a $CellContext`a13 $CellContext`d $CellContext`eps4, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.7338518373907623`*^9, 
   3.733852164208056*^9, 3.733852983672647*^9, 3.7338549028710747`*^9, 
   3.733856246562848*^9, 3.733856286853465*^9, 
   3.7413467737684727`*^9},ExpressionUUID->"206254a3-1d80-4d8a-b747-\
912f014bc47c"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.733853378040228*^9, 
  3.7338533898349113`*^9}},ExpressionUUID->"074ff94a-b3a4-45e5-bbf8-\
88d5cfa1f5a5"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.733853387306457*^9, 
  3.7338533873217497`*^9}},ExpressionUUID->"80dca7f9-6c2d-4b59-ac73-\
5ee767cfdaeb"]
},
WindowSize->{808, 712},
WindowMargins->{{Automatic, 3}, {3, Automatic}},
FrontEndVersion->"11.1 for Linux x86 (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 6159, 162, 494, "Input", "ExpressionUUID" -> \
"4b3f1573-c959-4f1d-b618-c60f33db4728"],
Cell[6742, 186, 2483, 66, 79, "Print", "ExpressionUUID" -> \
"be7e433e-d750-4fdd-8d9c-c8d49627df88"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9262, 257, 3795, 98, 170, "Input", "ExpressionUUID" -> \
"a1578a4a-04c4-4956-b6e9-938c42817e25"],
Cell[13060, 357, 443, 8, 24, "Print", "ExpressionUUID" -> \
"e99a1044-c0a2-4839-8f40-99987f9f81aa"]
}, Open  ]],
Cell[13518, 368, 248, 6, 55, "Input", "ExpressionUUID" -> \
"ad6cde9f-696e-4c0f-9938-1eaba3ddff47"],
Cell[CellGroupData[{
Cell[13791, 378, 682, 21, 34, "Input", "ExpressionUUID" -> \
"41edfbdb-73d7-42f5-abc8-924a4925e039"],
Cell[14476, 401, 681, 21, 34, "Output", "ExpressionUUID" -> \
"dc384c40-c5a9-47ed-85b6-940b54e8ab2d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15194, 427, 3024, 68, 286, "Input", "ExpressionUUID" -> \
"18fed3ab-4644-4176-a3c3-bba051731673"],
Cell[CellGroupData[{
Cell[18243, 499, 3279, 77, 151, "Print", "ExpressionUUID" -> \
"e09a3038-3a1f-4831-bf41-9ed9f0183e39"],
Cell[21525, 578, 3101, 72, 150, "Print", "ExpressionUUID" -> \
"03e6b455-40f5-4f1a-b208-f249b63f4170"],
Cell[24629, 652, 3309, 80, 151, "Print", "ExpressionUUID" -> \
"549d5045-218e-45a4-bc88-aa891e44a4dd"],
Cell[27941, 734, 2681, 63, 150, "Print", "ExpressionUUID" -> \
"206254a3-1d80-4d8a-b747-912f014bc47c"]
}, Open  ]]
}, Open  ]],
Cell[30649, 801, 154, 3, 32, "Input", "ExpressionUUID" -> \
"074ff94a-b3a4-45e5-bbf8-88d5cfa1f5a5"],
Cell[30806, 806, 154, 3, 32, "Input", "ExpressionUUID" -> \
"80dca7f9-6c2d-4b59-ac73-5ee767cfdaeb"]
}
]
*)

