(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     60696,       1566]
NotebookOptionsPosition[     58267,       1504]
NotebookOutlinePosition[     58600,       1519]
CellTagsIndexPosition[     58557,       1516]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "This", " ", "file", " ", "calculates", " ", "the", " ", "inner", " ", 
    "product", " ", "pairings", " ", "for", " ", "the", " ", "mod", " ", "p", 
    " ", "orbits", " ", "O131", " ", "and", " ", "OCs"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "y", ",", "A11", ",", " ", "A12", ",", " ", "A13", ",", 
      " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ",
       "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", 
      "B21", ",", " ", "B22", ",", " ", "a11", ",", " ", "a12", ",", " ", 
      "a13", ",", " ", "a21", ",", " ", "a22", ",", " ", "a23", ",", " ", 
      "a31", ",", " ", "a32", ",", " ", "a33", ",", " ", "b11", ",", " ", 
      "b12", ",", " ", "b21", ",", " ", "b22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O131", " ", "=", " ", "Ox"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OCs", " ", "=", " ", "Oxi"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Gact3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "a12", ",", " ", "a13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "b", ",", "a23"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "a33"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", "c"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "*", "c"}], ")"}], "/", "a"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Gact2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"b11", ",", " ", "b12"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "b22"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x01", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x02", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x11", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"eps3", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x12", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi01", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi02", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi0ACT31", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi01", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi0ACT32", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi02", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi0ACT1", " ", "=", " ", 
     RowBox[{
      RowBox[{"b11", " ", "*", " ", "xi0ACT31"}], " ", "+", " ", 
      RowBox[{"b12", " ", "*", " ", "xi0ACT32"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi0ACT2", " ", "=", " ", 
     RowBox[{"b22", " ", "*", " ", "xi0ACT32"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Pairing0", " ", "=", " ", 
     RowBox[{
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x11", "]"}], ".", "xi0ACT1"}], "]"}], "+", 
      
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x12", "]"}], ".", "xi0ACT2"}], "]"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "x01", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "x02", "]"}], ",", " ", "Pairing0"}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.733834040192012*^9, 3.73383417454156*^9}, {
   3.73383429054252*^9, 3.733834334668531*^9}, {3.7338369238216963`*^9, 
   3.733836959732308*^9}, {3.7338375934586*^9, 3.733837605217167*^9}, {
   3.733837648713428*^9, 3.733837681840667*^9}, {3.733844525192297*^9, 
   3.73384453085526*^9}, 3.7338457926959047`*^9, {3.733845828423773*^9, 
   3.73384592720748*^9}, {3.7338459814150887`*^9, 3.733846011950898*^9}, {
   3.733846531316143*^9, 3.733846535339695*^9}, {3.733846672106317*^9, 
   3.73384680649897*^9}, {3.7338468499142237`*^9, 3.733846857625437*^9}, {
   3.7338485083510847`*^9, 3.733848527694816*^9}, {3.733849502026189*^9, 
   3.733849587161031*^9}, {3.7338498747367563`*^9, 3.733849965183249*^9}, {
   3.733850009823165*^9, 3.733850022038636*^9}, {3.741344248059916*^9, 
   3.741344288404166*^9}},ExpressionUUID->"bfc00720-08a6-44b1-a95a-\
2765f32f30e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", 
        FractionBox["1", "2"]},
       {"0", 
        FractionBox["1", "2"], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        FractionBox["1", "2"]},
       {"0", "1", "0"},
       {
        FractionBox["1", "2"], "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], " ", "b12"}], "-", 
      RowBox[{"2", " ", "a", " ", "a12", " ", "c"}]}], ")"}], " ", "eps3"}]}],
  
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 
      Rational[1, 2]}, {0, 
      Rational[1, 2], 0}}], 
   MatrixForm[{{0, 0, 
      Rational[1, 2]}, {0, 1, 0}, {
      Rational[1, 2], 0, 0}}], ($CellContext`a^2 $CellContext`b12 - 
    2 $CellContext`a $CellContext`a12 $CellContext`c) $CellContext`eps3],
  Editable->False]], "Print",
 CellChangeTimes->{{3.733836933925782*^9, 3.733836960154544*^9}, 
   3.733837683012678*^9, 3.73384332478533*^9, 3.733844540632078*^9, {
   3.733846762552989*^9, 3.7338467820719023`*^9}, 3.7338468595660267`*^9, 
   3.733848534520564*^9, 3.733849610963228*^9, 3.733850030251683*^9, 
   3.734124211598181*^9},ExpressionUUID->"6ba91d19-4129-47b8-80b0-\
506fb3a5526c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"xiTable", " ", "=", " ", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"2", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"3", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"4", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"5", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           RowBox[{"1", "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"6", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"7", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"8", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"9", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"10", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"11", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Length", "[", "xiTable", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.733838846527213*^9, 3.7338389816092587`*^9}, {
  3.733840103914178*^9, 3.733840549544438*^9}, {3.733841144204008*^9, 
  3.7338411725242*^9}, {3.7338413258745413`*^9, 3.733841449707015*^9}, {
  3.733841647641047*^9, 3.73384165992979*^9}, {3.733841696696742*^9, 
  3.7338417267768*^9}, {3.733841759687078*^9, 3.733841842029541*^9}, {
  3.7338419005518093`*^9, 3.733841964896893*^9}, {3.7338420077764807`*^9, 
  3.733842494494863*^9}, {3.7338425291580353`*^9, 3.73384253410826*^9}, {
  3.733842581916871*^9, 3.7338425987478943`*^9}, {3.7338430232754297`*^9, 
  3.733843031201666*^9}, {3.733850541783244*^9, 
  3.7338507728200073`*^9}},ExpressionUUID->"d34bddc8-2160-4591-b91e-\
2b0a4f193ad0"],

Cell[BoxData["11"], "Print",
 CellChangeTimes->{
  3.733842534647914*^9, {3.733842587078554*^9, 3.733842599520444*^9}, 
   3.733843032008008*^9, 3.733843272133623*^9, 3.733844546037567*^9, 
   3.733847018462346*^9, 3.7338485405006533`*^9, 3.7338496218311653`*^9, 
   3.733850776721301*^9, 
   3.734124216524892*^9},ExpressionUUID->"337e4510-b979-4c71-bb5e-\
38df8da7ccf3"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"xiTable", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.733843261533099*^9, 
  3.7338432667507677`*^9}},ExpressionUUID->"ad6cde9f-696e-4c0f-9938-\
1eaba3ddff47"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Input",
 CellChangeTimes->{
  3.7338470227121477`*^9},ExpressionUUID->"41edfbdb-73d7-42f5-abc8-\
924a4925e039"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.733847022813574*^9},ExpressionUUID->"dc384c40-c5a9-47ed-85b6-\
940b54e8ab2d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", " ", 
   RowBox[{"i", "\[LessEqual]", 
    RowBox[{"Length", "[", "xiTable", "]"}]}], ",", " ", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Orbit", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"xi11", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", " ", "2"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xi12", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "3"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"xiACT31", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi11", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT32", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi12", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT1", " ", "=", " ", 
     RowBox[{
      RowBox[{"b11", " ", "*", " ", "xiACT31"}], " ", "+", " ", 
      RowBox[{"b12", " ", "*", " ", "xiACT32"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT2", " ", "=", " ", 
     RowBox[{"b22", " ", "*", " ", "xiACT32"}]}], ";", "\[IndentingNewLine]", 
    
    RowBox[{"Pairing", " ", "=", " ", 
     RowBox[{
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x01", "]"}], ".", "xiACT1"}], "]"}], "+", 
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x02", "]"}], ".", "xiACT2"}], "]"}]}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"Orbit", ",", " ", "\"\<\\n\>\"", ",", 
      RowBox[{"MatrixForm", "[", "xi11", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "xi12", "]"}], ",", "\"\<\\n\>\"", ",", " ", 
      
      RowBox[{"Expand", "[", "Pairing", "]"}], ",", " ", "\"\<\\n\>\"", ",", 
      " ", 
      RowBox[{"Expand", "[", 
       RowBox[{"Pairing", " ", "+", " ", "Pairing0"}], "]"}], ",", " ", 
      "\"\<\\n\>\""}], "]"}], ";"}]}], "\[IndentingNewLine]", "]"}]], "Input",\

 CellChangeTimes->{{3.7338344558294764`*^9, 3.733834473411776*^9}, {
   3.733836101706242*^9, 3.733836173825585*^9}, {3.7338362479212427`*^9, 
   3.733836338560684*^9}, {3.7338364006081953`*^9, 3.7338364411760187`*^9}, 
   3.733836754125835*^9, {3.733836844957556*^9, 3.733836903589159*^9}, {
   3.733836976822104*^9, 3.733837134583942*^9}, {3.733837278606353*^9, 
   3.7338373093731728`*^9}, {3.7338430584741707`*^9, 3.733843230695416*^9}, {
   3.7338433049029493`*^9, 3.733843379702538*^9}, {3.733843573077908*^9, 
   3.733843576709671*^9}, {3.733846898073357*^9, 3.7338469204337587`*^9}, {
   3.7338485461031847`*^9, 3.733848549839365*^9}, {3.733849636003745*^9, 
   3.733849650393408*^9}, {3.734126977937204*^9, 
   3.73412698785671*^9}},ExpressionUUID->"75c88af4-2ab8-42d1-bb19-\
e66a6a216567"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a23", " ", "a33", " ", "b12"}], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["a23", "2"], " ", "b", " ", "c"}], "a"], "+", 
    FractionBox[
     RowBox[{"a13", " ", "a33", " ", "b", " ", "c"}], "a"]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a23", " ", "a33", " ", "b12"}], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["a23", "2"], " ", "b", " ", "c"}], "a"], "+", 
    FractionBox[
     RowBox[{"a13", " ", "a33", " ", "b", " ", "c"}], "a"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b12", " ", "eps3"}], "-", 
    RowBox[{"2", " ", "a", " ", "a12", " ", "c", " ", "eps3"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[1, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   "\n", $CellContext`a23 $CellContext`a33 $CellContext`b12 + \
$CellContext`a^(-1) $CellContext`a23^2 $CellContext`b $CellContext`c + \
$CellContext`a^(-1) $CellContext`a13 $CellContext`a33 $CellContext`b \
$CellContext`c, 
   "\n", $CellContext`a23 $CellContext`a33 $CellContext`b12 + \
$CellContext`a^(-1) $CellContext`a23^2 $CellContext`b $CellContext`c + \
$CellContext`a^(-1) $CellContext`a13 $CellContext`a33 $CellContext`b \
$CellContext`c + $CellContext`a^2 $CellContext`b12 $CellContext`eps3 - 
   2 $CellContext`a $CellContext`a12 $CellContext`c $CellContext`eps3, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.733850817140573*^9, 
   3.7341242223472767`*^9, {3.73412698045439*^9, 
   3.7341269882640944`*^9}},ExpressionUUID->"1749abf4-3ccd-46b0-8c19-\
784035556026"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{
     SuperscriptBox["b", "3"], " ", "c"}], "a"], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["b", "3"], " ", "c"}], "a"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b12", " ", "eps3"}], "-", 
    RowBox[{"2", " ", "a", " ", "a12", " ", "c", " ", "eps3"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[2, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   "\n", $CellContext`a^(-1) $CellContext`b^3 $CellContext`c, 
   "\n", $CellContext`a^(-1) $CellContext`b^3 $CellContext`c + \
$CellContext`a^2 $CellContext`b12 $CellContext`eps3 - 
   2 $CellContext`a $CellContext`a12 $CellContext`c $CellContext`eps3, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.733850817140573*^9, 
   3.7341242223472767`*^9, {3.73412698045439*^9, 
   3.734126988266819*^9}},ExpressionUUID->"6af61ff8-06f2-4e31-9a97-\
11aba979fb68"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "1", "0"},
       {"1", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a33", " ", "b", " ", "c"}], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["b", "3"], " ", "c"}], "a"]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a33", " ", "b", " ", "c"}], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["b", "3"], " ", "c"}], "a"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b12", " ", "eps3"}], "-", 
    RowBox[{"2", " ", "a", " ", "a12", " ", "c", " ", "eps3"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[3, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 1}, {0, 1, 0}, {1, 0, 0}}], 
   "\n", $CellContext`a33 $CellContext`b $CellContext`c + $CellContext`a^(-1) \
$CellContext`b^3 $CellContext`c, 
   "\n", $CellContext`a33 $CellContext`b $CellContext`c + $CellContext`a^(-1) \
$CellContext`b^3 $CellContext`c + $CellContext`a^2 $CellContext`b12 \
$CellContext`eps3 - 
   2 $CellContext`a $CellContext`a12 $CellContext`c $CellContext`eps3, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.733850817140573*^9, 
   3.7341242223472767`*^9, {3.73412698045439*^9, 
   3.734126988269191*^9}},ExpressionUUID->"a54f4432-6473-49f0-8f72-\
5c88c8850a93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a23", " ", "a33", " ", "c"}], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["b", "3"], " ", "c"}], "a"]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a23", " ", "a33", " ", "c"}], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["b", "3"], " ", "c"}], "a"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b12", " ", "eps3"}], "-", 
    RowBox[{"2", " ", "a", " ", "a12", " ", "c", " ", "eps3"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[4, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   "\n", $CellContext`a23 $CellContext`a33 $CellContext`c + \
$CellContext`a^(-1) $CellContext`b^3 $CellContext`c, 
   "\n", $CellContext`a23 $CellContext`a33 $CellContext`c + \
$CellContext`a^(-1) $CellContext`b^3 $CellContext`c + $CellContext`a^2 \
$CellContext`b12 $CellContext`eps3 - 
   2 $CellContext`a $CellContext`a12 $CellContext`c $CellContext`eps3, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.733850817140573*^9, 
   3.7341242223472767`*^9, {3.73412698045439*^9, 
   3.734126988271433*^9}},ExpressionUUID->"8d182073-2bea-4ee5-8dfe-\
b200578d1dd5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", 
        FractionBox["1", "2"]},
       {"0", 
        FractionBox["1", "2"], "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a23", " ", "a33", " ", "b12"}], "+", 
    FractionBox[
     RowBox[{"a33", " ", "b", " ", "b12"}], "2"], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["a23", "2"], " ", "b", " ", "c"}], "a"], "+", 
    FractionBox[
     RowBox[{"a12", " ", "a33", " ", "b", " ", "c"}], 
     RowBox[{"2", " ", "a"}]], "+", 
    FractionBox[
     RowBox[{"a13", " ", "a33", " ", "b", " ", "c"}], "a"], "+", 
    FractionBox[
     RowBox[{"a23", " ", 
      SuperscriptBox["b", "2"], " ", "c"}], "a"]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a23", " ", "a33", " ", "b12"}], "+", 
    FractionBox[
     RowBox[{"a33", " ", "b", " ", "b12"}], "2"], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["a23", "2"], " ", "b", " ", "c"}], "a"], "+", 
    FractionBox[
     RowBox[{"a12", " ", "a33", " ", "b", " ", "c"}], 
     RowBox[{"2", " ", "a"}]], "+", 
    FractionBox[
     RowBox[{"a13", " ", "a33", " ", "b", " ", "c"}], "a"], "+", 
    FractionBox[
     RowBox[{"a23", " ", 
      SuperscriptBox["b", "2"], " ", "c"}], "a"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b12", " ", "eps3"}], "-", 
    RowBox[{"2", " ", "a", " ", "a12", " ", "c", " ", "eps3"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[5, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 
      Rational[1, 2]}, {0, 
      Rational[1, 2], 1}}], 
   "\n", $CellContext`a23 $CellContext`a33 $CellContext`b12 + 
   Rational[1, 
      2] $CellContext`a33 $CellContext`b $CellContext`b12 + \
$CellContext`a^(-1) $CellContext`a23^2 $CellContext`b $CellContext`c + 
   Rational[1, 
      2] $CellContext`a^(-1) $CellContext`a12 $CellContext`a33 $CellContext`b \
$CellContext`c + $CellContext`a^(-1) $CellContext`a13 $CellContext`a33 \
$CellContext`b $CellContext`c + $CellContext`a^(-1) $CellContext`a23 \
$CellContext`b^2 $CellContext`c, 
   "\n", $CellContext`a23 $CellContext`a33 $CellContext`b12 + 
   Rational[1, 
      2] $CellContext`a33 $CellContext`b $CellContext`b12 + \
$CellContext`a^(-1) $CellContext`a23^2 $CellContext`b $CellContext`c + 
   Rational[1, 
      2] $CellContext`a^(-1) $CellContext`a12 $CellContext`a33 $CellContext`b \
$CellContext`c + $CellContext`a^(-1) $CellContext`a13 $CellContext`a33 \
$CellContext`b $CellContext`c + $CellContext`a^(-1) $CellContext`a23 \
$CellContext`b^2 $CellContext`c + $CellContext`a^2 $CellContext`b12 \
$CellContext`eps3 - 
   2 $CellContext`a $CellContext`a12 $CellContext`c $CellContext`eps3, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.733850817140573*^9, 
   3.7341242223472767`*^9, {3.73412698045439*^9, 
   3.734126988274089*^9}},ExpressionUUID->"e7cf7e8f-56f2-4350-96ff-\
cb46e450419a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a33", " ", "b", " ", "b12"}], "+", 
    FractionBox[
     RowBox[{"a12", " ", "a33", " ", "b", " ", "c"}], "a"], "+", 
    FractionBox[
     RowBox[{"2", " ", "a23", " ", 
      SuperscriptBox["b", "2"], " ", "c"}], "a"]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a33", " ", "b", " ", "b12"}], "+", 
    FractionBox[
     RowBox[{"a12", " ", "a33", " ", "b", " ", "c"}], "a"], "+", 
    FractionBox[
     RowBox[{"2", " ", "a23", " ", 
      SuperscriptBox["b", "2"], " ", "c"}], "a"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b12", " ", "eps3"}], "-", 
    RowBox[{"2", " ", "a", " ", "a12", " ", "c", " ", "eps3"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[6, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}}], 
   "\n", $CellContext`a33 $CellContext`b $CellContext`b12 + \
$CellContext`a^(-1) $CellContext`a12 $CellContext`a33 $CellContext`b \
$CellContext`c + 
   2 $CellContext`a^(-1) $CellContext`a23 $CellContext`b^2 $CellContext`c, 
   "\n", $CellContext`a33 $CellContext`b $CellContext`b12 + \
$CellContext`a^(-1) $CellContext`a12 $CellContext`a33 $CellContext`b \
$CellContext`c + 
   2 $CellContext`a^(-1) $CellContext`a23 $CellContext`b^2 $CellContext`c + \
$CellContext`a^2 $CellContext`b12 $CellContext`eps3 - 
   2 $CellContext`a $CellContext`a12 $CellContext`c $CellContext`eps3, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.733850817140573*^9, 
   3.7341242223472767`*^9, {3.73412698045439*^9, 
   3.734126988277001*^9}},ExpressionUUID->"56c3d0a2-9403-45e6-933f-\
9dd7d5cdd942"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a33", " ", "b", " ", "b12"}], "+", 
    RowBox[{"a23", " ", "a33", " ", "c"}], "+", 
    FractionBox[
     RowBox[{"a12", " ", "a33", " ", "b", " ", "c"}], "a"], "+", 
    FractionBox[
     RowBox[{"2", " ", "a23", " ", 
      SuperscriptBox["b", "2"], " ", "c"}], "a"]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a33", " ", "b", " ", "b12"}], "+", 
    RowBox[{"a23", " ", "a33", " ", "c"}], "+", 
    FractionBox[
     RowBox[{"a12", " ", "a33", " ", "b", " ", "c"}], "a"], "+", 
    FractionBox[
     RowBox[{"2", " ", "a23", " ", 
      SuperscriptBox["b", "2"], " ", "c"}], "a"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b12", " ", "eps3"}], "-", 
    RowBox[{"2", " ", "a", " ", "a12", " ", "c", " ", "eps3"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[7, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}}], 
   "\n", $CellContext`a33 $CellContext`b $CellContext`b12 + $CellContext`a23 \
$CellContext`a33 $CellContext`c + $CellContext`a^(-1) $CellContext`a12 \
$CellContext`a33 $CellContext`b $CellContext`c + 
   2 $CellContext`a^(-1) $CellContext`a23 $CellContext`b^2 $CellContext`c, 
   "\n", $CellContext`a33 $CellContext`b $CellContext`b12 + $CellContext`a23 \
$CellContext`a33 $CellContext`c + $CellContext`a^(-1) $CellContext`a12 \
$CellContext`a33 $CellContext`b $CellContext`c + 
   2 $CellContext`a^(-1) $CellContext`a23 $CellContext`b^2 $CellContext`c + \
$CellContext`a^2 $CellContext`b12 $CellContext`eps3 - 
   2 $CellContext`a $CellContext`a12 $CellContext`c $CellContext`eps3, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.733850817140573*^9, 
   3.7341242223472767`*^9, {3.73412698045439*^9, 
   3.734126988279458*^9}},ExpressionUUID->"39583cf0-639e-4830-9753-\
aee7b8e3d3b0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"-", "ell"}], "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a23", " ", "a33", " ", "b12"}], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["a23", "2"], " ", "b", " ", "c"}], "a"], "+", 
    FractionBox[
     RowBox[{"a13", " ", "a33", " ", "b", " ", "c"}], "a"], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["b", "3"], " ", "c", " ", "ell"}], "a"]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a23", " ", "a33", " ", "b12"}], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["a23", "2"], " ", "b", " ", "c"}], "a"], "+", 
    FractionBox[
     RowBox[{"a13", " ", "a33", " ", "b", " ", "c"}], "a"], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["b", "3"], " ", "c", " ", "ell"}], "a"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b12", " ", "eps3"}], "-", 
    RowBox[{"2", " ", "a", " ", "a12", " ", "c", " ", "eps3"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[8, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, -$CellContext`ell, 0}, {0, 0, 1}}], 
   "\n", $CellContext`a23 $CellContext`a33 $CellContext`b12 + \
$CellContext`a^(-1) $CellContext`a23^2 $CellContext`b $CellContext`c + \
$CellContext`a^(-1) $CellContext`a13 $CellContext`a33 $CellContext`b \
$CellContext`c - $CellContext`a^(-1) $CellContext`b^3 $CellContext`c \
$CellContext`ell, 
   "\n", $CellContext`a23 $CellContext`a33 $CellContext`b12 + \
$CellContext`a^(-1) $CellContext`a23^2 $CellContext`b $CellContext`c + \
$CellContext`a^(-1) $CellContext`a13 $CellContext`a33 $CellContext`b \
$CellContext`c - $CellContext`a^(-1) $CellContext`b^3 $CellContext`c \
$CellContext`ell + $CellContext`a^2 $CellContext`b12 $CellContext`eps3 - 
   2 $CellContext`a $CellContext`a12 $CellContext`c $CellContext`eps3, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.733850817140573*^9, 
   3.7341242223472767`*^9, {3.73412698045439*^9, 
   3.734126988281983*^9}},ExpressionUUID->"b6c332cc-05f4-44cc-adbc-\
e66bb2b75d4b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "0", "0"},
       {"1", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"a33", " ", "b", " ", "c"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a33", " ", "b", " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b12", " ", "eps3"}], "-", 
    RowBox[{"2", " ", "a", " ", "a12", " ", "c", " ", "eps3"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[9, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}}], 
   "\n", $CellContext`a33 $CellContext`b $CellContext`c, 
   "\n", $CellContext`a33 $CellContext`b $CellContext`c + $CellContext`a^2 \
$CellContext`b12 $CellContext`eps3 - 
   2 $CellContext`a $CellContext`a12 $CellContext`c $CellContext`eps3, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.733850817140573*^9, 
   3.7341242223472767`*^9, {3.73412698045439*^9, 
   3.734126988284327*^9}},ExpressionUUID->"ad6a7ddd-128f-4eaf-aacb-\
7a845a839442"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"a23", " ", "a33", " ", "c"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a23", " ", "a33", " ", "c"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b12", " ", "eps3"}], "-", 
    RowBox[{"2", " ", "a", " ", "a12", " ", "c", " ", "eps3"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[10, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   "\n", $CellContext`a23 $CellContext`a33 $CellContext`c, 
   "\n", $CellContext`a23 $CellContext`a33 $CellContext`c + $CellContext`a^2 \
$CellContext`b12 $CellContext`eps3 - 
   2 $CellContext`a $CellContext`a12 $CellContext`c $CellContext`eps3, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.733850817140573*^9, 
   3.7341242223472767`*^9, {3.73412698045439*^9, 
   3.734126988286235*^9}},ExpressionUUID->"9dc0be71-805a-4782-b12d-\
9c0e47f55f2c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"11", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "0", "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b12", " ", "eps3"}], "-", 
    RowBox[{"2", " ", "a", " ", "a12", " ", "c", " ", "eps3"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[11, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], "\n", 0, 
   "\n", $CellContext`a^2 $CellContext`b12 $CellContext`eps3 - 
   2 $CellContext`a $CellContext`a12 $CellContext`c $CellContext`eps3, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.7338485503201227`*^9, {
   3.733849626197083*^9, 3.733849650790317*^9}, 3.733850817140573*^9, 
   3.7341242223472767`*^9, {3.73412698045439*^9, 
   3.734126988288151*^9}},ExpressionUUID->"aa9d27f9-44ef-470c-97b2-\
fa64b68ae032"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.734127002491044*^9, 
  3.734127004605843*^9}},ExpressionUUID->"70e9b971-851d-45be-b094-\
1b8a363ee7eb"]
},
WindowSize->{808, 911},
WindowMargins->{{Automatic, 3}, {3, Automatic}},
FrontEndVersion->"11.1 for Linux x86 (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 6467, 173, 537, "Input", "ExpressionUUID" -> \
"bfc00720-08a6-44b1-a95a-2765f32f30e5"],
Cell[7050, 197, 2351, 64, 79, "Print", "ExpressionUUID" -> \
"33e56300-3424-4509-87ac-ae4db243736a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9438, 266, 8460, 231, 331, "Input", "ExpressionUUID" -> \
"5c02da8c-188d-4129-a70b-984c0868f3bc"],
Cell[17901, 499, 372, 7, 24, "Print", "ExpressionUUID" -> \
"8928a42e-1090-497c-8536-b59472eff028"]
}, Open  ]],
Cell[18288, 509, 248, 6, 55, "Input", "ExpressionUUID" -> \
"71e5516c-1130-49f6-b406-8111687c5ace"],
Cell[CellGroupData[{
Cell[18561, 519, 682, 21, 34, "Input", "ExpressionUUID" -> \
"1002e9cc-592a-47ed-beed-7fa7fe18af6c"],
Cell[19246, 542, 681, 21, 34, "Output", "ExpressionUUID" -> \
"ec6846cf-b6a1-4103-9af2-ab1bded9601f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19964, 568, 3023, 68, 286, "Input", "ExpressionUUID" -> \
"8043eb78-7d91-4328-ad05-b4dc3ecb91f5"],
Cell[CellGroupData[{
Cell[23012, 640, 3367, 79, 197, "Print", "ExpressionUUID" -> \
"b3945e8f-1aa6-4b29-a4b9-d0cd5c0b1d54"],
Cell[26382, 721, 2734, 67, 197, "Print", "ExpressionUUID" -> \
"d21bb391-6e93-48d2-8456-0b96ca9facc0"],
Cell[29119, 790, 2947, 72, 197, "Print", "ExpressionUUID" -> \
"bf8c8078-24b4-43f3-b045-5558f6214c51"],
Cell[32069, 864, 2955, 72, 197, "Print", "ExpressionUUID" -> \
"ee679632-6120-425f-8c51-02382930422d"],
Cell[35027, 938, 4547, 110, 267, "Print", "ExpressionUUID" -> \
"08b44b52-8026-4c74-882f-789d7e913adf"],
Cell[39577, 1050, 3387, 80, 197, "Print", "ExpressionUUID" -> \
"306d5765-087a-4033-9136-3424ea8fb6a2"],
Cell[42967, 1132, 3587, 82, 197, "Print", "ExpressionUUID" -> \
"6505b4fb-a667-4415-800b-79632c638689"],
Cell[46557, 1216, 3751, 88, 197, "Print", "ExpressionUUID" -> \
"d49f8528-49df-425d-9ca6-88420b04191a"],
Cell[50311, 1306, 2646, 63, 150, "Print", "ExpressionUUID" -> \
"a691b3b5-b595-4e86-9fcb-896dc37f55dd"],
Cell[52960, 1371, 2656, 63, 150, "Print", "ExpressionUUID" -> \
"eee55d39-16f2-4e01-a09e-2bfb2247c256"],
Cell[55619, 1436, 2465, 59, 150, "Print", "ExpressionUUID" -> \
"7ccf775a-4b15-4cc9-8c14-ff1fac893bd0"]
}, Open  ]]
}, Open  ]],
Cell[58111, 1499, 152, 3, 32, "Input", "ExpressionUUID" -> \
"bb781d0c-dbfb-443d-aae4-603147f17da1"]
}
]
*)

