(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     67710,       1805]
NotebookOptionsPosition[     65172,       1741]
NotebookOutlinePosition[     65506,       1756]
CellTagsIndexPosition[     65463,       1753]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "This", " ", "file", " ", "calculates", " ", "the", " ", "inner", " ", 
    "product", " ", "pairings", " ", "for", " ", "the", " ", "mod", " ", "p", 
    " ", "orbits", " ", "O1212", " ", "and", " ", "OD2"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "y", ",", "A11", ",", " ", "A12", ",", " ", "A13", ",", 
      " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ",
       "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", 
      "B21", ",", " ", "B22", ",", " ", "a11", ",", " ", "a12", ",", " ", 
      "a13", ",", " ", "a21", ",", " ", "a22", ",", " ", "a23", ",", " ", 
      "a31", ",", " ", "a32", ",", " ", "a33", ",", " ", "b11", ",", " ", 
      "b12", ",", " ", "b21", ",", " ", "b22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O1212", " ", "=", " ", "Ox"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OD2", " ", "=", " ", "Oxi"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Gact3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", " ", 
         RowBox[{"ell", " ", "*", " ", "c"}], ",", " ", "a13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"c", "*", "lam"}], ",", 
         RowBox[{"a", "*", "lam"}], ",", "a23"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "a33"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Gact2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"b11", ",", " ", "b12"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "b22"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x01", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x02", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x11", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "y", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x12", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi01", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "ell"}], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi02", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi0ACT31", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi01", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi0ACT32", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi02", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi0ACT1", " ", "=", " ", 
     RowBox[{
      RowBox[{"b11", " ", "*", " ", "xi0ACT31"}], " ", "+", " ", 
      RowBox[{"b12", " ", "*", " ", "xi0ACT32"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi0ACT2", " ", "=", " ", 
     RowBox[{"b22", " ", "*", " ", "xi0ACT32"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Pairing0", " ", "=", " ", 
     RowBox[{
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x11", "]"}], ".", "xi0ACT1"}], "]"}], "+", 
      
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x12", "]"}], ".", "xi0ACT2"}], "]"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "x01", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "x02", "]"}], ",", " ", 
      RowBox[{"Simplify", "[", "Pairing0", "]"}]}], "]"}], ";"}]}]}]], "Input",\

 CellChangeTimes->{{3.733834040192012*^9, 3.73383417454156*^9}, {
   3.73383429054252*^9, 3.733834334668531*^9}, {3.7338369238216963`*^9, 
   3.733836959732308*^9}, {3.7338375934586*^9, 3.733837605217167*^9}, {
   3.733837648713428*^9, 3.733837681840667*^9}, {3.733844525192297*^9, 
   3.73384453085526*^9}, 3.7338457926959047`*^9, {3.733845828423773*^9, 
   3.73384592720748*^9}, {3.7338459814150887`*^9, 3.733846011950898*^9}, {
   3.733846531316143*^9, 3.733846535339695*^9}, {3.733846672106317*^9, 
   3.73384680649897*^9}, {3.7338468499142237`*^9, 3.733846857625437*^9}, {
   3.733847903868231*^9, 3.7338479040588093`*^9}, {3.7338480023732157`*^9, 
   3.733848019770886*^9}, {3.733848072212098*^9, 3.733848072578232*^9}, {
   3.733848121715375*^9, 3.7338481421537848`*^9}, {3.733848637280978*^9, 
   3.733848659806445*^9}, {3.7338487038624897`*^9, 3.733848742869643*^9}, {
   3.74155288746776*^9, 
   3.7415529212035522`*^9}},ExpressionUUID->"3200b7f7-d9a4-4163-92d7-\
cc927a6ec481"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["1", "2"], "0"},
       {
        FractionBox["1", "2"], "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "b11"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", "ell"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ell", " ", "x"}], "-", 
      RowBox[{
       SuperscriptBox["lam", "2"], " ", "y"}]}], ")"}]}]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 
      Rational[1, 2], 0}, {
      Rational[1, 2], 0, 0}, {0, 0, 
     0}}], -$CellContext`b11 ($CellContext`a^2 - $CellContext`c^2 \
$CellContext`ell) ($CellContext`ell $CellContext`x - $CellContext`lam^2 \
$CellContext`y)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.733836933925782*^9, 3.733836960154544*^9}, 
   3.733837683012678*^9, 3.73384332478533*^9, 3.733844540632078*^9, {
   3.733846762552989*^9, 3.7338467820719023`*^9}, 3.7338468595660267`*^9, 
   3.7338479164873123`*^9, 3.733848030916504*^9, 3.7338480766138353`*^9, 
   3.7338481888197117`*^9, {3.733848717441847*^9, 3.733848743222838*^9}, 
   3.734094555741987*^9, 
   3.7415529311627893`*^9},ExpressionUUID->"18a20979-9a94-414e-bad0-\
18aec8a02232"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"xiTable", " ", "=", " ", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"2", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"3", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"4", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"5", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"6", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"7", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"8", "a"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"8", "b"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "k", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"9", "a"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"9", "b"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "k", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"10", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"11", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Length", "[", "xiTable", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.733838846527213*^9, 3.7338389816092587`*^9}, {
   3.733840103914178*^9, 3.733840549544438*^9}, {3.733841144204008*^9, 
   3.7338411725242*^9}, {3.7338413258745413`*^9, 3.733841449707015*^9}, {
   3.733841647641047*^9, 3.73384165992979*^9}, {3.733841696696742*^9, 
   3.7338417267768*^9}, {3.733841759687078*^9, 3.733841842029541*^9}, {
   3.7338419005518093`*^9, 3.733841964896893*^9}, {3.7338420077764807`*^9, 
   3.733842494494863*^9}, {3.7338425291580353`*^9, 3.73384253410826*^9}, {
   3.733842581916871*^9, 3.7338425987478943`*^9}, {3.7338430232754297`*^9, 
   3.733843031201666*^9}, 3.733847895607904*^9, {3.733848808745322*^9, 
   3.733849030599485*^9}, {3.733849074789846*^9, 3.733849146351036*^9}, 
   3.734097017233979*^9},ExpressionUUID->"3e2f405d-ee61-4923-b8ec-\
744bc792dffe"],

Cell[BoxData["13"], "Print",
 CellChangeTimes->{
  3.733842534647914*^9, {3.733842587078554*^9, 3.733842599520444*^9}, 
   3.733843032008008*^9, 3.733843272133623*^9, 3.733844546037567*^9, 
   3.733847018462346*^9, 3.733848220181684*^9, 3.733849147074586*^9, 
   3.7340945595648727`*^9, 3.734097130327166*^9, 
   3.741552941944721*^9},ExpressionUUID->"d8f93fcf-e30b-4415-a399-\
1ff8e0264d3e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"xiTable", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.733843261533099*^9, 
  3.7338432667507677`*^9}},ExpressionUUID->"ad6cde9f-696e-4c0f-9938-\
1eaba3ddff47"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Input",
 CellChangeTimes->{
  3.7338470227121477`*^9},ExpressionUUID->"e58fd760-a846-4655-8f38-\
bed03272f3aa"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.733847022813574*^9},ExpressionUUID->"797d0e24-9e8e-44a9-8532-\
47695e7962c8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", " ", 
   RowBox[{"i", "\[LessEqual]", 
    RowBox[{"Length", "[", "xiTable", "]"}]}], ",", " ", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Orbit", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"xi11", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", " ", "2"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xi12", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "3"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"xiACT31", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi11", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT32", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi12", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT1", " ", "=", " ", 
     RowBox[{
      RowBox[{"b11", " ", "*", " ", "xiACT31"}], " ", "+", " ", 
      RowBox[{"b12", " ", "*", " ", "xiACT32"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT2", " ", "=", " ", 
     RowBox[{"b22", " ", "*", " ", "xiACT32"}]}], ";", "\[IndentingNewLine]", 
    
    RowBox[{"Pairing", " ", "=", " ", 
     RowBox[{
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x01", "]"}], ".", "xiACT1"}], "]"}], "+", 
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x02", "]"}], ".", "xiACT2"}], "]"}]}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"Orbit", ",", " ", "\"\<\\n\>\"", ",", 
      RowBox[{"MatrixForm", "[", "xi11", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "xi12", "]"}], ",", "\"\<\\n\>\"", ",", " ", 
      
      RowBox[{"Simplify", "[", "Pairing", "]"}], ",", " ", "\"\<\\n\>\"", ",",
       " ", 
      RowBox[{"Simplify", "[", 
       RowBox[{"Pairing", " ", "+", " ", "Pairing0"}], "]"}], ",", " ", 
      "\"\<\\n\>\""}], "]"}], ";"}]}], "\[IndentingNewLine]", "]"}]], "Input",\

 CellChangeTimes->{{3.7338344558294764`*^9, 3.733834473411776*^9}, {
   3.733836101706242*^9, 3.733836173825585*^9}, {3.7338362479212427`*^9, 
   3.733836338560684*^9}, {3.7338364006081953`*^9, 3.7338364411760187`*^9}, 
   3.733836754125835*^9, {3.733836844957556*^9, 3.733836903589159*^9}, {
   3.733836976822104*^9, 3.733837134583942*^9}, {3.733837278606353*^9, 
   3.7338373093731728`*^9}, {3.7338430584741707`*^9, 3.733843230695416*^9}, {
   3.7338433049029493`*^9, 3.733843379702538*^9}, {3.733843573077908*^9, 
   3.733843576709671*^9}, {3.733846898073357*^9, 3.7338469204337587`*^9}, {
   3.733848231211978*^9, 3.733848236313689*^9}, {3.733849173418449*^9, 
   3.733849187060631*^9}},ExpressionUUID->"0cd63eb5-4b57-4632-a76a-\
3772821b61ba"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"a13", " ", "a23", " ", "b22"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"a13", " ", "a23", " ", "b22"}], "-", 
    RowBox[{"b11", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       RowBox[{
        SuperscriptBox["c", "2"], " ", "ell"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ell", " ", "x"}], "-", 
       RowBox[{
        SuperscriptBox["lam", "2"], " ", "y"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[1, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a13 \
$CellContext`a23 $CellContext`b22, 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a13 \
$CellContext`a23 $CellContext`b22 - $CellContext`b11 ($CellContext`a^2 - \
$CellContext`c^2 $CellContext`ell) ($CellContext`ell $CellContext`x - \
$CellContext`lam^2 $CellContext`y), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741552945030733*^9},ExpressionUUID->"2b0e799a-5462-46a0-9f48-\
3e0c4b487674"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"a23", " ", "b22", " ", "c", " ", "ell"}], "+", 
    RowBox[{"a13", " ", "b22", " ", 
     RowBox[{"(", 
      RowBox[{"a23", "+", 
       RowBox[{"a", " ", "lam"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"a23", " ", "b22", " ", "c", " ", "ell"}], "+", 
    RowBox[{"a13", " ", "b22", " ", 
     RowBox[{"(", 
      RowBox[{"a23", "+", 
       RowBox[{"a", " ", "lam"}]}], ")"}]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b11", " ", "ell", " ", "x"}], "+", 
    RowBox[{"b11", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["ell", "2"], " ", "x"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b11", " ", 
     SuperscriptBox["lam", "2"], " ", "y"}], "-", 
    RowBox[{"b11", " ", 
     SuperscriptBox["c", "2"], " ", "ell", " ", 
     SuperscriptBox["lam", "2"], " ", "y"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[2, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 1}}], 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a23 \
$CellContext`b22 $CellContext`c $CellContext`ell + $CellContext`a13 \
$CellContext`b22 ($CellContext`a23 + $CellContext`a $CellContext`lam), 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a23 \
$CellContext`b22 $CellContext`c $CellContext`ell + $CellContext`a13 \
$CellContext`b22 ($CellContext`a23 + $CellContext`a $CellContext`lam) - \
$CellContext`a^2 $CellContext`b11 $CellContext`ell $CellContext`x + \
$CellContext`b11 $CellContext`c^2 $CellContext`ell^2 $CellContext`x + \
$CellContext`a^2 $CellContext`b11 $CellContext`lam^2 $CellContext`y - \
$CellContext`b11 $CellContext`c^2 $CellContext`ell $CellContext`lam^2 \
$CellContext`y, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7415529450851603`*^9},ExpressionUUID->"94331ac6-cfe2-468b-b11f-\
87dc9fc966cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1", "0"},
       {"1", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"a13", " ", "a23", " ", "b22"}], "+", 
    RowBox[{"b22", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       RowBox[{
        SuperscriptBox["c", "2"], " ", "ell"}]}], ")"}], " ", "lam"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"a13", " ", "a23", " ", "b22"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b22", " ", "lam"}], "+", 
    RowBox[{"b22", " ", 
     SuperscriptBox["c", "2"], " ", "ell", " ", "lam"}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b11", " ", "ell", " ", "x"}], "+", 
    RowBox[{"b11", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["ell", "2"], " ", "x"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b11", " ", 
     SuperscriptBox["lam", "2"], " ", "y"}], "-", 
    RowBox[{"b11", " ", 
     SuperscriptBox["c", "2"], " ", "ell", " ", 
     SuperscriptBox["lam", "2"], " ", "y"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[3, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 1, 0}, {1, 0, 0}, {0, 0, 1}}], 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a13 \
$CellContext`a23 $CellContext`b22 + $CellContext`b22 ($CellContext`a^2 + \
$CellContext`c^2 $CellContext`ell) $CellContext`lam, 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a13 \
$CellContext`a23 $CellContext`b22 + $CellContext`a^2 $CellContext`b22 \
$CellContext`lam + $CellContext`b22 $CellContext`c^2 $CellContext`ell \
$CellContext`lam - $CellContext`a^2 $CellContext`b11 $CellContext`ell \
$CellContext`x + $CellContext`b11 $CellContext`c^2 $CellContext`ell^2 \
$CellContext`x + $CellContext`a^2 $CellContext`b11 $CellContext`lam^2 \
$CellContext`y - $CellContext`b11 $CellContext`c^2 $CellContext`ell \
$CellContext`lam^2 $CellContext`y, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7415529450881157`*^9},ExpressionUUID->"954909cc-73d2-4a34-bfc4-\
6f34cce569c5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"b22", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a23", " ", "c", " ", "ell"}], "+", 
      RowBox[{"a", " ", "a13", " ", "lam"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a23", " ", "b22", " ", "c", " ", "ell"}], "+", 
    RowBox[{"a", " ", "a13", " ", "b22", " ", "lam"}], "+", 
    RowBox[{"b11", " ", 
     SuperscriptBox["c", "2"], " ", "ell", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ell", " ", "x"}], "-", 
       RowBox[{
        SuperscriptBox["lam", "2"], " ", "y"}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b11", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "ell"}], " ", "x"}], "+", 
       RowBox[{
        SuperscriptBox["lam", "2"], " ", "y"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[4, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}}], 
   "\n", $CellContext`b22 ($CellContext`a23 $CellContext`c $CellContext`ell + \
$CellContext`a $CellContext`a13 $CellContext`lam), 
   "\n", $CellContext`a23 $CellContext`b22 $CellContext`c $CellContext`ell + \
$CellContext`a $CellContext`a13 $CellContext`b22 $CellContext`lam + \
$CellContext`b11 $CellContext`c^2 $CellContext`ell ($CellContext`ell \
$CellContext`x - $CellContext`lam^2 $CellContext`y) + $CellContext`a^2 \
$CellContext`b11 (-$CellContext`ell $CellContext`x + $CellContext`lam^2 \
$CellContext`y), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741552945090214*^9},ExpressionUUID->"9b45ffe8-7e31-4e2c-ae05-\
00a15bf84855"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{"a23", " ", "b22", " ", "c", " ", "ell"}], "+", 
    RowBox[{"a", " ", "a13", " ", "b22", " ", "lam"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{"a23", " ", "b22", " ", "c", " ", "ell"}], "+", 
    RowBox[{"a", " ", "a13", " ", "b22", " ", "lam"}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b11", " ", "ell", " ", "x"}], "+", 
    RowBox[{"b11", " ", 
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["ell", "2"], " ", "x"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b11", " ", 
     SuperscriptBox["lam", "2"], " ", "y"}], "-", 
    RowBox[{"b11", " ", 
     SuperscriptBox["c", "2"], " ", "ell", " ", 
     SuperscriptBox["lam", "2"], " ", "y"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[5, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11 + $CellContext`a23 \
$CellContext`b22 $CellContext`c $CellContext`ell + $CellContext`a \
$CellContext`a13 $CellContext`b22 $CellContext`lam, 
   "\n", $CellContext`a33^2 $CellContext`b11 + $CellContext`a23 \
$CellContext`b22 $CellContext`c $CellContext`ell + $CellContext`a \
$CellContext`a13 $CellContext`b22 $CellContext`lam - $CellContext`a^2 \
$CellContext`b11 $CellContext`ell $CellContext`x + $CellContext`b11 \
$CellContext`c^2 $CellContext`ell^2 $CellContext`x + $CellContext`a^2 \
$CellContext`b11 $CellContext`lam^2 $CellContext`y - $CellContext`b11 \
$CellContext`c^2 $CellContext`ell $CellContext`lam^2 $CellContext`y, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741552945092319*^9},ExpressionUUID->"b18c0a40-ad12-49d5-a285-\
389c5ecd3a17"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"a", " ", "b22", " ", "c", " ", "ell", " ", "lam"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a", " ", "b22", " ", "c", " ", "ell", " ", "lam"}], "+", 
    RowBox[{"b11", " ", 
     SuperscriptBox["c", "2"], " ", "ell", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ell", " ", "x"}], "-", 
       RowBox[{
        SuperscriptBox["lam", "2"], " ", "y"}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b11", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "ell"}], " ", "x"}], "+", 
       RowBox[{
        SuperscriptBox["lam", "2"], " ", "y"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[6, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   "\n", $CellContext`a $CellContext`b22 $CellContext`c $CellContext`ell \
$CellContext`lam, 
   "\n", $CellContext`a $CellContext`b22 $CellContext`c $CellContext`ell \
$CellContext`lam + $CellContext`b11 $CellContext`c^2 $CellContext`ell \
($CellContext`ell $CellContext`x - $CellContext`lam^2 $CellContext`y) + \
$CellContext`a^2 $CellContext`b11 (-$CellContext`ell $CellContext`x + \
$CellContext`lam^2 $CellContext`y), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741552945094409*^9},ExpressionUUID->"b8085450-39b3-48c8-a568-\
891abfa1fdc3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{"a", " ", "b22", " ", "c", " ", "ell", " ", "lam"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{"a", " ", "b22", " ", "c", " ", "ell", " ", "lam"}], "+", 
    RowBox[{"b11", " ", 
     SuperscriptBox["c", "2"], " ", "ell", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ell", " ", "x"}], "-", 
       RowBox[{
        SuperscriptBox["lam", "2"], " ", "y"}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b11", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "ell"}], " ", "x"}], "+", 
       RowBox[{
        SuperscriptBox["lam", "2"], " ", "y"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[7, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11 + $CellContext`a \
$CellContext`b22 $CellContext`c $CellContext`ell $CellContext`lam, 
   "\n", $CellContext`a33^2 $CellContext`b11 + $CellContext`a \
$CellContext`b22 $CellContext`c $CellContext`ell $CellContext`lam + \
$CellContext`b11 $CellContext`c^2 $CellContext`ell ($CellContext`ell \
$CellContext`x - $CellContext`lam^2 $CellContext`y) + $CellContext`a^2 \
$CellContext`b11 (-$CellContext`ell $CellContext`x + $CellContext`lam^2 \
$CellContext`y), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741552945096423*^9},ExpressionUUID->"6c4d6866-e79f-4f5e-afc1-\
6598a1992fbd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"8", " ", "a"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1", "0"},
       {"1", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"b22", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", "ell"}]}], ")"}], " ", "lam"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["c", "2"], " ", "ell", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b22", " ", "lam"}], "+", 
       RowBox[{"b11", " ", "ell", " ", "x"}], "-", 
       RowBox[{"b11", " ", 
        SuperscriptBox["lam", "2"], " ", "y"}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b22", " ", "lam"}], "-", 
       RowBox[{"b11", " ", "ell", " ", "x"}], "+", 
       RowBox[{"b11", " ", 
        SuperscriptBox["lam", "2"], " ", "y"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[8 $CellContext`a, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 1, 0}, {1, 0, 0}, {0, 0, 0}}], 
   "\n", $CellContext`b22 ($CellContext`a^2 + $CellContext`c^2 \
$CellContext`ell) $CellContext`lam, 
   "\n", $CellContext`c^2 $CellContext`ell ($CellContext`b22 $CellContext`lam + \
$CellContext`b11 $CellContext`ell $CellContext`x - $CellContext`b11 \
$CellContext`lam^2 $CellContext`y) + $CellContext`a^2 ($CellContext`b22 \
$CellContext`lam - $CellContext`b11 $CellContext`ell $CellContext`x + \
$CellContext`b11 $CellContext`lam^2 $CellContext`y), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741552945117684*^9},ExpressionUUID->"c5a591a2-a12f-4a35-bcd1-\
d6fc749f0126"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"8", " ", "b"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "k", "0"},
       {"k", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"b22", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", "c", " ", "ell"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "k"}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", "ell", " ", "k"}]}], ")"}], " ", 
    "lam"}], "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a", " ", "b22", " ", "c", " ", "ell", " ", "lam"}], "+", 
    RowBox[{
     SuperscriptBox["c", "2"], " ", "ell", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b22", " ", "k", " ", "lam"}], "+", 
       RowBox[{"b11", " ", "ell", " ", "x"}], "-", 
       RowBox[{"b11", " ", 
        SuperscriptBox["lam", "2"], " ", "y"}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b22", " ", "k", " ", "lam"}], "-", 
       RowBox[{"b11", " ", "ell", " ", "x"}], "+", 
       RowBox[{"b11", " ", 
        SuperscriptBox["lam", "2"], " ", "y"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[8 $CellContext`b, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, $CellContext`k, 0}, {$CellContext`k, 1, 0}, {0, 0, 0}}], 
   "\n", $CellContext`b22 ($CellContext`a $CellContext`c $CellContext`ell + \
$CellContext`a^2 $CellContext`k + $CellContext`c^2 $CellContext`ell \
$CellContext`k) $CellContext`lam, 
   "\n", $CellContext`a $CellContext`b22 $CellContext`c $CellContext`ell \
$CellContext`lam + $CellContext`c^2 $CellContext`ell ($CellContext`b22 \
$CellContext`k $CellContext`lam + $CellContext`b11 $CellContext`ell \
$CellContext`x - $CellContext`b11 $CellContext`lam^2 $CellContext`y) + \
$CellContext`a^2 ($CellContext`b22 $CellContext`k $CellContext`lam - \
$CellContext`b11 $CellContext`ell $CellContext`x + $CellContext`b11 \
$CellContext`lam^2 $CellContext`y), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7415529451216717`*^9},ExpressionUUID->"e4f1642d-8e77-4351-9475-\
e1625002cbdf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"9", " ", "a"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1", "0"},
       {"1", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{"b22", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       RowBox[{
        SuperscriptBox["c", "2"], " ", "ell"}]}], ")"}], " ", "lam"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{
     SuperscriptBox["c", "2"], " ", "ell", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b22", " ", "lam"}], "+", 
       RowBox[{"b11", " ", "ell", " ", "x"}], "-", 
       RowBox[{"b11", " ", 
        SuperscriptBox["lam", "2"], " ", "y"}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b22", " ", "lam"}], "-", 
       RowBox[{"b11", " ", "ell", " ", "x"}], "+", 
       RowBox[{"b11", " ", 
        SuperscriptBox["lam", "2"], " ", "y"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[9 $CellContext`a, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 1, 0}, {1, 0, 0}, {0, 0, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11 + $CellContext`b22 \
($CellContext`a^2 + $CellContext`c^2 $CellContext`ell) $CellContext`lam, 
   "\n", $CellContext`a33^2 $CellContext`b11 + $CellContext`c^2 \
$CellContext`ell ($CellContext`b22 $CellContext`lam + $CellContext`b11 \
$CellContext`ell $CellContext`x - $CellContext`b11 $CellContext`lam^2 \
$CellContext`y) + $CellContext`a^2 ($CellContext`b22 $CellContext`lam - \
$CellContext`b11 $CellContext`ell $CellContext`x + $CellContext`b11 \
$CellContext`lam^2 $CellContext`y), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7415529451236277`*^9},ExpressionUUID->"dc1eff1e-aca1-4d04-9caa-\
42a2fd35bd36"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"9", " ", "b"}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "k", "0"},
       {"k", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{"b22", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "c", " ", "ell"}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", "k"}], "+", 
       RowBox[{
        SuperscriptBox["c", "2"], " ", "ell", " ", "k"}]}], ")"}], " ", 
     "lam"}]}], "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{"a", " ", "b22", " ", "c", " ", "ell", " ", "lam"}], "+", 
    RowBox[{
     SuperscriptBox["c", "2"], " ", "ell", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b22", " ", "k", " ", "lam"}], "+", 
       RowBox[{"b11", " ", "ell", " ", "x"}], "-", 
       RowBox[{"b11", " ", 
        SuperscriptBox["lam", "2"], " ", "y"}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b22", " ", "k", " ", "lam"}], "-", 
       RowBox[{"b11", " ", "ell", " ", "x"}], "+", 
       RowBox[{"b11", " ", 
        SuperscriptBox["lam", "2"], " ", "y"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[9 $CellContext`b, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, $CellContext`k, 0}, {$CellContext`k, 1, 0}, {0, 0, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11 + $CellContext`b22 \
($CellContext`a $CellContext`c $CellContext`ell + $CellContext`a^2 \
$CellContext`k + $CellContext`c^2 $CellContext`ell $CellContext`k) \
$CellContext`lam, 
   "\n", $CellContext`a33^2 $CellContext`b11 + $CellContext`a \
$CellContext`b22 $CellContext`c $CellContext`ell $CellContext`lam + \
$CellContext`c^2 $CellContext`ell ($CellContext`b22 $CellContext`k \
$CellContext`lam + $CellContext`b11 $CellContext`ell $CellContext`x - \
$CellContext`b11 $CellContext`lam^2 $CellContext`y) + $CellContext`a^2 \
($CellContext`b22 $CellContext`k $CellContext`lam - $CellContext`b11 \
$CellContext`ell $CellContext`x + $CellContext`b11 $CellContext`lam^2 \
$CellContext`y), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741552945133977*^9},ExpressionUUID->"40d35863-b3cb-4df5-bf2c-\
436528616619"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a33", "2"], " ", "b11"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"b11", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a33", "2"], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "ell"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ell", " ", "x"}], "-", 
         RowBox[{
          SuperscriptBox["lam", "2"], " ", "y"}]}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[10, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11, 
   "\n", $CellContext`b11 ($CellContext`a33^2 - ($CellContext`a^2 - \
$CellContext`c^2 $CellContext`ell) ($CellContext`ell $CellContext`x - \
$CellContext`lam^2 $CellContext`y)), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741552945191996*^9},ExpressionUUID->"f090a612-fa5f-4336-aceb-\
2c347ddf4ee8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"11", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "0", "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "b11"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", "ell"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ell", " ", "x"}], "-", 
      RowBox[{
       SuperscriptBox["lam", "2"], " ", "y"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[11, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], "\n", 0, 
   "\n", -$CellContext`b11 ($CellContext`a^2 - $CellContext`c^2 \
$CellContext`ell) ($CellContext`ell $CellContext`x - $CellContext`lam^2 \
$CellContext`y), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741552945194393*^9},ExpressionUUID->"b81e697f-6044-409b-a3c8-\
18c699c95d2e"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{Automatic, 36}, {3, Automatic}},
FrontEndVersion->"11.1 for Linux x86 (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 6374, 168, 491, "Input", "ExpressionUUID" -> \
"3200b7f7-d9a4-4163-92d7-cc927a6ec481"],
Cell[6957, 192, 2549, 69, 79, "Print", "ExpressionUUID" -> \
"18a20979-9a94-414e-bad0-18aec8a02232"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9543, 266, 9904, 271, 377, "Input", "ExpressionUUID" -> \
"3e2f405d-ee61-4923-b8ec-744bc792dffe"],
Cell[19450, 539, 392, 7, 24, "Print", "ExpressionUUID" -> \
"d8f93fcf-e30b-4415-a399-1ff8e0264d3e"]
}, Open  ]],
Cell[19857, 549, 248, 6, 55, "Input", "ExpressionUUID" -> \
"eaf8b8e9-c748-469c-94ca-bc698afee07f"],
Cell[CellGroupData[{
Cell[20130, 559, 682, 21, 34, "Input", "ExpressionUUID" -> \
"7678c60e-9e0b-4ca2-a03b-e90a46b03f83"],
Cell[20815, 582, 681, 21, 34, "Output", "ExpressionUUID" -> \
"d459720e-ffa9-47a7-a6b5-280f9049b1d4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21533, 608, 2976, 67, 286, "Input", "ExpressionUUID" -> \
"0cd63eb5-4b57-4632-a76a-3772821b61ba"],
Cell[CellGroupData[{
Cell[24534, 679, 2751, 73, 157, "Print", "ExpressionUUID" -> \
"2b0e799a-5462-46a0-9f48-3e0c4b487674"],
Cell[27288, 754, 3515, 86, 173, "Print", "ExpressionUUID" -> \
"94331ac6-cfe2-468b-b11f-87dc9fc966cc"],
Cell[30806, 842, 3588, 88, 180, "Print", "ExpressionUUID" -> \
"954909cc-73d2-4a34-bfc4-6f34cce569c5"],
Cell[34397, 932, 3097, 79, 156, "Print", "ExpressionUUID" -> \
"9b45ffe8-7e31-4e2c-ae05-00a15bf84855"],
Cell[37497, 1013, 3323, 79, 173, "Print", "ExpressionUUID" -> \
"b18c0a40-ad12-49d5-a285-389c5ecd3a17"],
Cell[40823, 1094, 2854, 73, 156, "Print", "ExpressionUUID" -> \
"b8085450-39b3-48c8-a568-891abfa1fdc3"],
Cell[43680, 1169, 3079, 79, 157, "Print", "ExpressionUUID" -> \
"6c4d6866-e79f-4f5e-afc1-6598a1992fbd"],
Cell[46762, 1250, 3055, 80, 165, "Print", "ExpressionUUID" -> \
"c5a591a2-a12f-4a35-bcd1-d6fc749f0126"],
Cell[49820, 1332, 3460, 86, 194, "Print", "ExpressionUUID" -> \
"e4f1642d-8e77-4351-9475-e1625002cbdf"],
Cell[53283, 1420, 3287, 86, 165, "Print", "ExpressionUUID" -> \
"dc1eff1e-aca1-4d04-9caa-42a2fd35bd36"],
Cell[56573, 1508, 3693, 93, 186, "Print", "ExpressionUUID" -> \
"40d35863-b3cb-4df5-bf2c-436528616619"],
Cell[60269, 1603, 2547, 69, 157, "Print", "ExpressionUUID" -> \
"f090a612-fa5f-4336-aceb-2c347ddf4ee8"],
Cell[62819, 1674, 2325, 63, 156, "Print", "ExpressionUUID" -> \
"b81e697f-6044-409b-a3c8-18c699c95d2e"]
}, Open  ]]
}, Open  ]]
}
]
*)

