(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    102600,       2640]
NotebookOptionsPosition[     99323,       2562]
NotebookOutlinePosition[     99657,       2577]
CellTagsIndexPosition[     99614,       2574]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "This", " ", "file", " ", "calculates", " ", "the", " ", "inner", " ", 
    "product", " ", "pairings", " ", "for", " ", "the", " ", "mod", " ", "p", 
    " ", "orbits", " ", "O1212", " ", "and", " ", "OD11"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "y", ",", "A11", ",", " ", "A12", ",", " ", "A13", ",", 
      " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ",
       "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", 
      "B21", ",", " ", "B22", ",", " ", "a11", ",", " ", "a12", ",", " ", 
      "a13", ",", " ", "a21", ",", " ", "a22", ",", " ", "a23", ",", " ", 
      "a31", ",", " ", "a32", ",", " ", "a33", ",", " ", "b11", ",", " ", 
      "b12", ",", " ", "b21", ",", " ", "b22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O1212", " ", "=", " ", "Ox"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OD11", " ", "=", " ", "Oxi"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Gact3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "lam"}], ")"}], "*", 
          RowBox[{"alpha", "/", "2"}]}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "lam"}], ")"}], "*", 
          RowBox[{"alpha", "/", "2"}]}], ",", " ", "a13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "lam"}], ")"}], "*", 
          RowBox[{"beta", "/", "2"}]}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "lam"}], ")"}], "*", 
          RowBox[{"beta", "/", "2"}]}], ",", "a23"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "a33"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Gact2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"b11", ",", " ", "b12"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "b22"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x01", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x02", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x11", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "y", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x12", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi01", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi02", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi0ACT31", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi01", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi0ACT32", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi02", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi0ACT1", " ", "=", " ", 
     RowBox[{
      RowBox[{"b11", " ", "*", " ", "xi0ACT31"}], " ", "+", " ", 
      RowBox[{"b12", " ", "*", " ", "xi0ACT32"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xi0ACT2", " ", "=", " ", 
     RowBox[{"b22", " ", "*", " ", "xi0ACT32"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Pairing0", " ", "=", " ", 
     RowBox[{
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x11", "]"}], ".", "xi0ACT1"}], "]"}], "+", 
      
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x12", "]"}], ".", "xi0ACT2"}], "]"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "x01", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "x02", "]"}], ",", " ", 
      RowBox[{"Simplify", "[", "Pairing0", "]"}]}], "]"}], ";"}]}]}]], "Input",\

 CellChangeTimes->{{3.733834040192012*^9, 3.73383417454156*^9}, {
   3.73383429054252*^9, 3.733834334668531*^9}, {3.7338369238216963`*^9, 
   3.733836959732308*^9}, {3.7338375934586*^9, 3.733837605217167*^9}, {
   3.733837648713428*^9, 3.733837681840667*^9}, {3.733844525192297*^9, 
   3.73384453085526*^9}, 3.7338457926959047`*^9, {3.733845828423773*^9, 
   3.73384592720748*^9}, {3.7338459814150887`*^9, 3.733846011950898*^9}, {
   3.733846531316143*^9, 3.733846535339695*^9}, {3.733846672106317*^9, 
   3.73384680649897*^9}, {3.7338468499142237`*^9, 3.733846857625437*^9}, {
   3.733847903868231*^9, 3.7338479040588093`*^9}, {3.7338480023732157`*^9, 
   3.733848019770886*^9}, {3.733848072212098*^9, 3.733848072578232*^9}, {
   3.733848121715375*^9, 3.7338481421537848`*^9}, {3.733858918033081*^9, 
   3.733858951856847*^9}, {3.733860931488112*^9, 3.733861008917292*^9}, {
   3.7338612445242863`*^9, 3.7338612505079*^9}, {3.741342013176806*^9, 
   3.741342014690138*^9}, {3.7413420554050922`*^9, 
   3.741342061391827*^9}},ExpressionUUID->"ed5c14b4-baee-4e25-bf95-\
f91dace5a6d4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["1", "2"], "0"},
       {
        FractionBox["1", "2"], "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   RowBox[{"b11", " ", "lam", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["alpha", "2"], " ", "x"}], "-", 
      RowBox[{
       SuperscriptBox["beta", "2"], " ", "y"}]}], ")"}]}]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 
      Rational[1, 2], 0}, {
      Rational[1, 2], 0, 0}, {0, 0, 
     0}}], $CellContext`b11 $CellContext`lam ($CellContext`alpha^2 \
$CellContext`x - $CellContext`beta^2 $CellContext`y)],
  Editable->False]], "Print",
 CellChangeTimes->{{3.733836933925782*^9, 3.733836960154544*^9}, 
   3.733837683012678*^9, 3.73384332478533*^9, 3.733844540632078*^9, {
   3.733846762552989*^9, 3.7338467820719023`*^9}, 3.7338468595660267`*^9, 
   3.7338479164873123`*^9, 3.733848030916504*^9, 3.7338480766138353`*^9, 
   3.7338481888197117`*^9, 3.733859078158535*^9, 3.733861018127672*^9, {
   3.733861251228076*^9, 3.733861266894752*^9}, 
   3.734026211058703*^9},ExpressionUUID->"a29a7185-6e4c-41bc-8f6e-\
f48668a056f5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"xiTable", " ", "=", " ", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}], ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"2", ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}], ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"3", ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}], ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"4", ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}], ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"5", ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}], ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"6", ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}], ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "ell"}], ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"7", ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}], ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"8", ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}], ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"9", ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}], ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"10", ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}], ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"11", ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}], ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"12", ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}], ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"13", ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}], ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"14", ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}], ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"15", ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}], ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"ell", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"16", ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}], ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"17", ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}], ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"18", ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}], ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"ell", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"19", ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}], ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"20", ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}], ",", " ", 
       RowBox[{"g3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ".", 
        RowBox[{"Transpose", "[", "g3", "]"}]}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Length", "[", "xiTable", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.733838846527213*^9, 3.7338389816092587`*^9}, {
   3.733840103914178*^9, 3.733840549544438*^9}, {3.733841144204008*^9, 
   3.7338411725242*^9}, {3.7338413258745413`*^9, 3.733841449707015*^9}, {
   3.733841647641047*^9, 3.73384165992979*^9}, {3.733841696696742*^9, 
   3.7338417267768*^9}, {3.733841759687078*^9, 3.733841842029541*^9}, {
   3.7338419005518093`*^9, 3.733841964896893*^9}, {3.7338420077764807`*^9, 
   3.733842494494863*^9}, {3.7338425291580353`*^9, 3.73384253410826*^9}, {
   3.733842581916871*^9, 3.7338425987478943`*^9}, {3.7338430232754297`*^9, 
   3.733843031201666*^9}, 3.733847895607904*^9, {3.7338589829466257`*^9, 
   3.733859053194273*^9}, {3.733859104075613*^9, 
   3.733859552813266*^9}},ExpressionUUID->"834eb323-7fcb-4c9e-b97b-\
8a4295a2784b"],

Cell[BoxData["20"], "Print",
 CellChangeTimes->{
  3.733842534647914*^9, {3.733842587078554*^9, 3.733842599520444*^9}, 
   3.733843032008008*^9, 3.733843272133623*^9, 3.733844546037567*^9, 
   3.733847018462346*^9, 3.733848220181684*^9, {3.733859054291884*^9, 
   3.733859080573854*^9}, 3.7338591209475946`*^9, 3.733859553676437*^9, 
   3.733861270819776*^9, 
   3.734026229927032*^9},ExpressionUUID->"eb4bd93e-b218-461f-85f0-\
a5d5587cd258"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"xiTable", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.733843261533099*^9, 
  3.7338432667507677`*^9}},ExpressionUUID->"ad6cde9f-696e-4c0f-9938-\
1eaba3ddff47"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Input",
 CellChangeTimes->{
  3.7338470227121477`*^9},ExpressionUUID->"aafacd0e-1939-407f-ba9d-\
4a72762303a9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.733847022813574*^9},ExpressionUUID->"7b5c4b8b-ec2f-4c29-ae37-\
38a84ddcc54a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", " ", 
   RowBox[{"i", "\[LessEqual]", 
    RowBox[{"Length", "[", "xiTable", "]"}]}], ",", " ", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Orbit", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"xi11", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", " ", "2"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xi12", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "3"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"xiACT31", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi11", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT32", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi12", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT1", " ", "=", " ", 
     RowBox[{
      RowBox[{"b11", " ", "*", " ", "xiACT31"}], " ", "+", " ", 
      RowBox[{"b12", " ", "*", " ", "xiACT32"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT2", " ", "=", " ", 
     RowBox[{"b22", " ", "*", " ", "xiACT32"}]}], ";", "\[IndentingNewLine]", 
    
    RowBox[{"Pairing", " ", "=", " ", 
     RowBox[{
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x01", "]"}], ".", "xiACT1"}], "]"}], "+", 
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x02", "]"}], ".", "xiACT2"}], "]"}]}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"Orbit", ",", " ", "\"\<\\n\>\"", ",", 
      RowBox[{"MatrixForm", "[", "xi11", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "xi12", "]"}], ",", "\"\<\\n\>\"", ",", " ", 
      
      RowBox[{"Simplify", "[", "Pairing", "]"}], ",", " ", "\"\<\\n\>\"", ",",
       " ", 
      RowBox[{"Simplify", "[", 
       RowBox[{"Pairing", " ", "+", " ", "Pairing0"}], "]"}], ",", " ", 
      "\"\<\\n\>\""}], "]"}], ";"}]}], "\[IndentingNewLine]", "]"}]], "Input",\

 CellChangeTimes->{{3.7338344558294764`*^9, 3.733834473411776*^9}, {
   3.733836101706242*^9, 3.733836173825585*^9}, {3.7338362479212427`*^9, 
   3.733836338560684*^9}, {3.7338364006081953`*^9, 3.7338364411760187`*^9}, 
   3.733836754125835*^9, {3.733836844957556*^9, 3.733836903589159*^9}, {
   3.733836976822104*^9, 3.733837134583942*^9}, {3.733837278606353*^9, 
   3.7338373093731728`*^9}, {3.7338430584741707`*^9, 3.733843230695416*^9}, {
   3.7338433049029493`*^9, 3.733843379702538*^9}, {3.733843573077908*^9, 
   3.733843576709671*^9}, {3.733846898073357*^9, 3.7338469204337587`*^9}, {
   3.733848231211978*^9, 3.733848236313689*^9}, {3.733859571055406*^9, 
   3.73385958938946*^9}},ExpressionUUID->"fc78d9b3-e024-43c5-a68f-\
46db329033bd"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"a13", " ", "a23", " ", "b22"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"a13", " ", "a23", " ", "b22"}], "+", 
    RowBox[{"b11", " ", "lam", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["alpha", "2"], " ", "x"}], "-", 
       RowBox[{
        SuperscriptBox["beta", "2"], " ", "y"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[1, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a13 \
$CellContext`a23 $CellContext`b22, 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a13 \
$CellContext`a23 $CellContext`b22 + $CellContext`b11 $CellContext`lam \
($CellContext`alpha^2 $CellContext`x - $CellContext`beta^2 $CellContext`y), 
   "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.733848237128996*^9, 
   3.73385912534591*^9, {3.733859561421958*^9, 3.73385958974291*^9}, 
   3.733861276680868*^9, 
   3.7340262390457783`*^9},ExpressionUUID->"5c4a04ab-57bd-4e95-905c-\
11ce9488f71e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "0", 
        RowBox[{"-", "1"}]},
       {"1", 
        RowBox[{"-", "1"}], "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"a23", " ", "alpha", " ", "b22", " ", "lam"}], "+", 
    RowBox[{"a13", " ", "b22", " ", 
     RowBox[{"(", 
      RowBox[{"a23", "-", 
       RowBox[{"beta", " ", "lam"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"a13", " ", "b22", " ", 
     RowBox[{"(", 
      RowBox[{"a23", "-", 
       RowBox[{"beta", " ", "lam"}]}], ")"}]}], "+", 
    RowBox[{"lam", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a23", " ", "alpha", " ", "b22"}], "+", 
       RowBox[{
        SuperscriptBox["alpha", "2"], " ", "b11", " ", "x"}], "-", 
       RowBox[{"b11", " ", 
        SuperscriptBox["beta", "2"], " ", "y"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[2, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 1}, {0, 0, -1}, {1, -1, 1}}], 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a23 \
$CellContext`alpha $CellContext`b22 $CellContext`lam + $CellContext`a13 \
$CellContext`b22 ($CellContext`a23 - $CellContext`beta $CellContext`lam), 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a13 \
$CellContext`b22 ($CellContext`a23 - $CellContext`beta $CellContext`lam) + \
$CellContext`lam ($CellContext`a23 $CellContext`alpha $CellContext`b22 + \
$CellContext`alpha^2 $CellContext`b11 $CellContext`x - $CellContext`b11 \
$CellContext`beta^2 $CellContext`y), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.733848237128996*^9, 
   3.73385912534591*^9, {3.733859561421958*^9, 3.73385958974291*^9}, 
   3.733861276680868*^9, 
   3.7340262391009912`*^9},ExpressionUUID->"375c3270-5898-42c0-bfe7-\
58c4763dfdf3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "2"},
       {"0", "0", "0"},
       {"2", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"a23", " ", "alpha", " ", "b22", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "lam"}], ")"}]}], "+", 
    RowBox[{"a13", " ", "b22", " ", 
     RowBox[{"(", 
      RowBox[{"a23", "+", "beta", "-", 
       RowBox[{"beta", " ", "lam"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"a23", " ", "alpha", " ", "b22"}], "+", 
    RowBox[{"a23", " ", "alpha", " ", "b22", " ", "lam"}], "+", 
    RowBox[{"a13", " ", "b22", " ", 
     RowBox[{"(", 
      RowBox[{"a23", "+", "beta", "-", 
       RowBox[{"beta", " ", "lam"}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["alpha", "2"], " ", "b11", " ", "lam", " ", "x"}], "-", 
    RowBox[{"b11", " ", 
     SuperscriptBox["beta", "2"], " ", "lam", " ", "y"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[3, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 2}, {0, 0, 0}, {2, 0, 1}}], 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a23 \
$CellContext`alpha $CellContext`b22 (
     1 + $CellContext`lam) + $CellContext`a13 $CellContext`b22 \
($CellContext`a23 + $CellContext`beta - $CellContext`beta $CellContext`lam), 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a23 \
$CellContext`alpha $CellContext`b22 + $CellContext`a23 $CellContext`alpha \
$CellContext`b22 $CellContext`lam + $CellContext`a13 $CellContext`b22 \
($CellContext`a23 + $CellContext`beta - $CellContext`beta $CellContext`lam) + \
$CellContext`alpha^2 $CellContext`b11 $CellContext`lam $CellContext`x - \
$CellContext`b11 $CellContext`beta^2 $CellContext`lam $CellContext`y, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.733848237128996*^9, 
   3.73385912534591*^9, {3.733859561421958*^9, 3.73385958974291*^9}, 
   3.733861276680868*^9, 
   3.734026239104006*^9},ExpressionUUID->"95704171-d0fa-49e9-9308-\
8d55b063b2c7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "ell"}], "ell", "0"},
       {"ell", 
        RowBox[{"-", "ell"}], "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"a13", " ", "a23", " ", "b22"}], "+", 
    RowBox[{"alpha", " ", "b22", " ", "beta", " ", "ell", " ", 
     SuperscriptBox["lam", "2"]}]}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"a13", " ", "a23", " ", "b22"}], "+", 
    RowBox[{"lam", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"alpha", " ", "b22", " ", "beta", " ", "ell", " ", "lam"}], 
       "+", 
       RowBox[{
        SuperscriptBox["alpha", "2"], " ", "b11", " ", "x"}], "-", 
       RowBox[{"b11", " ", 
        SuperscriptBox["beta", "2"], " ", "y"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[4, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{-$CellContext`ell, $CellContext`ell, 
      0}, {$CellContext`ell, -$CellContext`ell, 0}, {0, 0, 1}}], 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a13 \
$CellContext`a23 $CellContext`b22 + $CellContext`alpha $CellContext`b22 \
$CellContext`beta $CellContext`ell $CellContext`lam^2, 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a13 \
$CellContext`a23 $CellContext`b22 + $CellContext`lam ($CellContext`alpha \
$CellContext`b22 $CellContext`beta $CellContext`ell $CellContext`lam + \
$CellContext`alpha^2 $CellContext`b11 $CellContext`x - $CellContext`b11 \
$CellContext`beta^2 $CellContext`y), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.733848237128996*^9, 
   3.73385912534591*^9, {3.733859561421958*^9, 3.73385958974291*^9}, 
   3.733861276680868*^9, 
   3.734026239106139*^9},ExpressionUUID->"5d8a314f-4650-4741-9d12-\
dfeba0023957"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "ell"}], "ell", "1"},
       {"ell", 
        RowBox[{"-", "ell"}], "1"},
       {"1", "1", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"a13", " ", "b22", " ", 
     RowBox[{"(", 
      RowBox[{"a23", "+", "beta"}], ")"}]}], "+", 
    RowBox[{"alpha", " ", "b22", " ", 
     RowBox[{"(", 
      RowBox[{"a23", "+", 
       RowBox[{"beta", " ", "ell", " ", 
        SuperscriptBox["lam", "2"]}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"a23", " ", "alpha", " ", "b22"}], "+", 
    RowBox[{"a13", " ", "b22", " ", 
     RowBox[{"(", 
      RowBox[{"a23", "+", "beta"}], ")"}]}], "+", 
    RowBox[{"alpha", " ", "b22", " ", "beta", " ", "ell", " ", 
     SuperscriptBox["lam", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["alpha", "2"], " ", "b11", " ", "lam", " ", "x"}], "-", 
    RowBox[{"b11", " ", 
     SuperscriptBox["beta", "2"], " ", "lam", " ", "y"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[5, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{-$CellContext`ell, $CellContext`ell, 
      1}, {$CellContext`ell, -$CellContext`ell, 1}, {1, 1, 1}}], 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a13 \
$CellContext`b22 ($CellContext`a23 + $CellContext`beta) + $CellContext`alpha \
$CellContext`b22 ($CellContext`a23 + $CellContext`beta $CellContext`ell \
$CellContext`lam^2), 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a23 \
$CellContext`alpha $CellContext`b22 + $CellContext`a13 $CellContext`b22 \
($CellContext`a23 + $CellContext`beta) + $CellContext`alpha $CellContext`b22 \
$CellContext`beta $CellContext`ell $CellContext`lam^2 + $CellContext`alpha^2 \
$CellContext`b11 $CellContext`lam $CellContext`x - $CellContext`b11 \
$CellContext`beta^2 $CellContext`lam $CellContext`y, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.733848237128996*^9, 
   3.73385912534591*^9, {3.733859561421958*^9, 3.73385958974291*^9}, 
   3.733861276680868*^9, 
   3.734026239108378*^9},ExpressionUUID->"cb1d97b6-ddad-47e4-9c97-\
bd7b4701eaa3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"-", "2"}], " ", "ell"}], "0", "0"},
       {"0", 
        RowBox[{
         RowBox[{"-", "2"}], " ", "ell"}], "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"a13", " ", "a23", " ", "b22"}], "+", 
    RowBox[{"alpha", " ", "b22", " ", "beta", " ", "ell", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["lam", "2"]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b12"}], "+", 
    RowBox[{"a13", " ", "a23", " ", "b22"}], "-", 
    RowBox[{"alpha", " ", "b22", " ", "beta", " ", "ell"}], "+", 
    RowBox[{"alpha", " ", "b22", " ", "beta", " ", "ell", " ", 
     SuperscriptBox["lam", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["alpha", "2"], " ", "b11", " ", "lam", " ", "x"}], "-", 
    RowBox[{"b11", " ", 
     SuperscriptBox["beta", "2"], " ", "lam", " ", "y"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[6, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{(-2) $CellContext`ell, 0, 0}, {0, (-2) $CellContext`ell, 0}, {
     0, 0, 1}}], 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a13 \
$CellContext`a23 $CellContext`b22 + $CellContext`alpha $CellContext`b22 \
$CellContext`beta $CellContext`ell (-1 + $CellContext`lam^2), 
   "\n", $CellContext`a33^2 $CellContext`b12 + $CellContext`a13 \
$CellContext`a23 $CellContext`b22 - $CellContext`alpha $CellContext`b22 \
$CellContext`beta $CellContext`ell + $CellContext`alpha $CellContext`b22 \
$CellContext`beta $CellContext`ell $CellContext`lam^2 + $CellContext`alpha^2 \
$CellContext`b11 $CellContext`lam $CellContext`x - $CellContext`b11 \
$CellContext`beta^2 $CellContext`lam $CellContext`y, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.733848237128996*^9, 
   3.73385912534591*^9, {3.733859561421958*^9, 3.73385958974291*^9}, 
   3.733861276680868*^9, 
   3.734026239130584*^9},ExpressionUUID->"26591048-2e6d-42c5-8e07-\
ac4a4b016830"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "0", 
        RowBox[{"-", "1"}]},
       {"1", 
        RowBox[{"-", "1"}], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"b22", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a23", " ", "alpha"}], "-", 
      RowBox[{"a13", " ", "beta"}]}], ")"}], " ", "lam"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"lam", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a23", " ", "alpha", " ", "b22"}], "-", 
      RowBox[{"a13", " ", "b22", " ", "beta"}], "+", 
      RowBox[{
       SuperscriptBox["alpha", "2"], " ", "b11", " ", "x"}], "-", 
      RowBox[{"b11", " ", 
       SuperscriptBox["beta", "2"], " ", "y"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[7, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 1}, {0, 0, -1}, {1, -1, 0}}], 
   "\n", $CellContext`b22 ($CellContext`a23 $CellContext`alpha - \
$CellContext`a13 $CellContext`beta) $CellContext`lam, 
   "\n", $CellContext`lam ($CellContext`a23 $CellContext`alpha \
$CellContext`b22 - $CellContext`a13 $CellContext`b22 $CellContext`beta + \
$CellContext`alpha^2 $CellContext`b11 $CellContext`x - $CellContext`b11 \
$CellContext`beta^2 $CellContext`y), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.733848237128996*^9, 
   3.73385912534591*^9, {3.733859561421958*^9, 3.73385958974291*^9}, 
   3.733861276680868*^9, 
   3.734026239135154*^9},ExpressionUUID->"e259f8f9-9316-444e-b3bb-\
a1c1a9c56dcc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "2"},
       {"0", "0", "0"},
       {"2", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"b22", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "a13"}], " ", "beta", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "lam"}], ")"}]}], "+", 
      RowBox[{"a23", " ", "alpha", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "lam"}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "a13"}], " ", "b22", " ", "beta", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "lam"}], ")"}]}], "+", 
    RowBox[{"a23", " ", "alpha", " ", "b22", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "lam"}], ")"}]}], "+", 
    RowBox[{"b11", " ", "lam", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["alpha", "2"], " ", "x"}], "-", 
       RowBox[{
        SuperscriptBox["beta", "2"], " ", "y"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[8, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 2}, {0, 0, 0}, {2, 0, 0}}], 
   "\n", $CellContext`b22 (-$CellContext`a13 $CellContext`beta (-1 + \
$CellContext`lam) + $CellContext`a23 $CellContext`alpha (
      1 + $CellContext`lam)), 
   "\n", -$CellContext`a13 $CellContext`b22 $CellContext`beta (-1 + \
$CellContext`lam) + $CellContext`a23 $CellContext`alpha $CellContext`b22 (
     1 + $CellContext`lam) + $CellContext`b11 $CellContext`lam \
($CellContext`alpha^2 $CellContext`x - $CellContext`beta^2 $CellContext`y), 
   "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.733848237128996*^9, 
   3.73385912534591*^9, {3.733859561421958*^9, 3.73385958974291*^9}, 
   3.733861276680868*^9, 
   3.734026239136943*^9},ExpressionUUID->"eabefd90-4f83-4f62-b62a-\
243c9b7733f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "1", "1"},
       {"1", "1", 
        RowBox[{"-", "1"}]},
       {"1", 
        RowBox[{"-", "1"}], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"b22", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "a13"}], " ", "beta", " ", "lam"}], "+", 
      RowBox[{"alpha", " ", 
       RowBox[{"(", 
        RowBox[{"beta", "+", 
         RowBox[{"a23", " ", "lam"}]}], ")"}]}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"alpha", " ", "b22", " ", 
     RowBox[{"(", 
      RowBox[{"beta", "+", 
       RowBox[{"a23", " ", "lam"}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["alpha", "2"], " ", "b11", " ", "lam", " ", "x"}], "-", 
    RowBox[{"beta", " ", "lam", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a13", " ", "b22"}], "+", 
       RowBox[{"b11", " ", "beta", " ", "y"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[9, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{1, 1, 1}, {1, 1, -1}, {1, -1, 0}}], 
   "\n", $CellContext`b22 (-$CellContext`a13 $CellContext`beta \
$CellContext`lam + $CellContext`alpha ($CellContext`beta + $CellContext`a23 \
$CellContext`lam)), 
   "\n", $CellContext`alpha $CellContext`b22 ($CellContext`beta + \
$CellContext`a23 $CellContext`lam) + $CellContext`alpha^2 $CellContext`b11 \
$CellContext`lam $CellContext`x - $CellContext`beta $CellContext`lam \
($CellContext`a13 $CellContext`b22 + $CellContext`b11 $CellContext`beta \
$CellContext`y), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.733848237128996*^9, 
   3.73385912534591*^9, {3.733859561421958*^9, 3.73385958974291*^9}, 
   3.733861276680868*^9, 
   3.734026239145475*^9},ExpressionUUID->"57647a23-af67-4fa5-ad4a-\
4e5487dd7123"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "1", "1"},
       {"1", "1", 
        RowBox[{"-", "1"}]},
       {"1", 
        RowBox[{"-", "1"}], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "-", 
    RowBox[{"a13", " ", "b22", " ", "beta", " ", "lam"}], "+", 
    RowBox[{"alpha", " ", "b22", " ", 
     RowBox[{"(", 
      RowBox[{"beta", "+", 
       RowBox[{"a23", " ", "lam"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{"alpha", " ", "b22", " ", 
     RowBox[{"(", 
      RowBox[{"beta", "+", 
       RowBox[{"a23", " ", "lam"}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["alpha", "2"], " ", "b11", " ", "lam", " ", "x"}], "-", 
    RowBox[{"beta", " ", "lam", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a13", " ", "b22"}], "+", 
       RowBox[{"b11", " ", "beta", " ", "y"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[10, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{1, 1, 1}, {1, 1, -1}, {1, -1, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11 - $CellContext`a13 \
$CellContext`b22 $CellContext`beta $CellContext`lam + $CellContext`alpha \
$CellContext`b22 ($CellContext`beta + $CellContext`a23 $CellContext`lam), 
   "\n", $CellContext`a33^2 $CellContext`b11 + $CellContext`alpha \
$CellContext`b22 ($CellContext`beta + $CellContext`a23 $CellContext`lam) + \
$CellContext`alpha^2 $CellContext`b11 $CellContext`lam $CellContext`x - \
$CellContext`beta $CellContext`lam ($CellContext`a13 $CellContext`b22 + \
$CellContext`b11 $CellContext`beta $CellContext`y), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.733848237128996*^9, 
   3.73385912534591*^9, {3.733859561421958*^9, 3.73385958974291*^9}, 
   3.733861276680868*^9, 
   3.7340262391993504`*^9},ExpressionUUID->"c90411be-8aac-4ae4-b386-\
bdea13cdab02"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"11", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "2"},
       {"0", "0", "0"},
       {"2", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "-", 
    RowBox[{"a13", " ", "b22", " ", "beta", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "lam"}], ")"}]}], "+", 
    RowBox[{"a23", " ", "alpha", " ", "b22", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "lam"}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{"a13", " ", "b22", " ", "beta"}], "-", 
    RowBox[{"a13", " ", "b22", " ", "beta", " ", "lam"}], "+", 
    RowBox[{"a23", " ", "alpha", " ", "b22", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "lam"}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["alpha", "2"], " ", "b11", " ", "lam", " ", "x"}], "-", 
    RowBox[{"b11", " ", 
     SuperscriptBox["beta", "2"], " ", "lam", " ", "y"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[11, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 2}, {0, 0, 0}, {2, 0, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11 - $CellContext`a13 \
$CellContext`b22 $CellContext`beta (-1 + $CellContext`lam) + $CellContext`a23 \
$CellContext`alpha $CellContext`b22 (1 + $CellContext`lam), 
   "\n", $CellContext`a33^2 $CellContext`b11 + $CellContext`a13 \
$CellContext`b22 $CellContext`beta - $CellContext`a13 $CellContext`b22 \
$CellContext`beta $CellContext`lam + $CellContext`a23 $CellContext`alpha \
$CellContext`b22 (
     1 + $CellContext`lam) + $CellContext`alpha^2 $CellContext`b11 \
$CellContext`lam $CellContext`x - $CellContext`b11 $CellContext`beta^2 \
$CellContext`lam $CellContext`y, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.733848237128996*^9, 
   3.73385912534591*^9, {3.733859561421958*^9, 3.73385958974291*^9}, 
   3.733861276680868*^9, 
   3.734026239201076*^9},ExpressionUUID->"dca01c73-3dfe-46ce-8316-\
a2286c426cb6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"12", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "1", "1"},
       {"1", "1", 
        RowBox[{"-", "1"}]},
       {"1", 
        RowBox[{"-", "1"}], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "-", 
    RowBox[{"a13", " ", "b22", " ", "beta", " ", "lam"}], "+", 
    RowBox[{"alpha", " ", "b22", " ", 
     RowBox[{"(", 
      RowBox[{"beta", "+", 
       RowBox[{"a23", " ", "lam"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{"alpha", " ", "b22", " ", 
     RowBox[{"(", 
      RowBox[{"beta", "+", 
       RowBox[{"a23", " ", "lam"}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["alpha", "2"], " ", "b11", " ", "lam", " ", "x"}], "-", 
    RowBox[{"beta", " ", "lam", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a13", " ", "b22"}], "+", 
       RowBox[{"b11", " ", "beta", " ", "y"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[12, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{1, 1, 1}, {1, 1, -1}, {1, -1, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11 - $CellContext`a13 \
$CellContext`b22 $CellContext`beta $CellContext`lam + $CellContext`alpha \
$CellContext`b22 ($CellContext`beta + $CellContext`a23 $CellContext`lam), 
   "\n", $CellContext`a33^2 $CellContext`b11 + $CellContext`alpha \
$CellContext`b22 ($CellContext`beta + $CellContext`a23 $CellContext`lam) + \
$CellContext`alpha^2 $CellContext`b11 $CellContext`lam $CellContext`x - \
$CellContext`beta $CellContext`lam ($CellContext`a13 $CellContext`b22 + \
$CellContext`b11 $CellContext`beta $CellContext`y), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.733848237128996*^9, 
   3.73385912534591*^9, {3.733859561421958*^9, 3.73385958974291*^9}, 
   3.733861276680868*^9, 
   3.7340262392026443`*^9},ExpressionUUID->"1807732c-8e2a-489a-96f1-\
af0324326b1b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"13", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", 
        RowBox[{"-", "1"}], "0"},
       {
        RowBox[{"-", "1"}], "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "alpha"}], " ", "b22", " ", "beta", " ", 
    SuperscriptBox["lam", "2"]}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "lam"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"alpha", " ", "b22", " ", "beta", " ", "lam"}], "-", 
      RowBox[{
       SuperscriptBox["alpha", "2"], " ", "b11", " ", "x"}], "+", 
      RowBox[{"b11", " ", 
       SuperscriptBox["beta", "2"], " ", "y"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[13, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{1, -1, 0}, {-1, 1, 0}, {0, 0, 0}}], 
   "\n", -$CellContext`alpha $CellContext`b22 $CellContext`beta \
$CellContext`lam^2, 
   "\n", -$CellContext`lam ($CellContext`alpha $CellContext`b22 \
$CellContext`beta $CellContext`lam - $CellContext`alpha^2 $CellContext`b11 \
$CellContext`x + $CellContext`b11 $CellContext`beta^2 $CellContext`y), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.733848237128996*^9, 
   3.73385912534591*^9, {3.733859561421958*^9, 3.73385958974291*^9}, 
   3.733861276680868*^9, 
   3.7340262392040997`*^9},ExpressionUUID->"cff814fc-6a29-4016-8b10-\
3ec97548a866"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"14", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2", "0", "0"},
       {"0", "2", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "alpha"}], " ", "b22", " ", "beta", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "lam"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "lam"}], ")"}]}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "alpha"}], " ", "b22", " ", "beta", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["lam", "2"]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["alpha", "2"], " ", "b11", " ", "lam", " ", "x"}], "-", 
    RowBox[{"b11", " ", 
     SuperscriptBox["beta", "2"], " ", "lam", " ", "y"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[14, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{2, 0, 0}, {0, 2, 0}, {0, 0, 0}}], 
   "\n", -$CellContext`alpha $CellContext`b22 $CellContext`beta (-1 + \
$CellContext`lam) (1 + $CellContext`lam), 
   "\n", -$CellContext`alpha $CellContext`b22 $CellContext`beta (-1 + \
$CellContext`lam^2) + $CellContext`alpha^2 $CellContext`b11 $CellContext`lam \
$CellContext`x - $CellContext`b11 $CellContext`beta^2 $CellContext`lam \
$CellContext`y, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.733848237128996*^9, 
   3.73385912534591*^9, {3.733859561421958*^9, 3.73385958974291*^9}, 
   3.733861276680868*^9, 
   3.734026239205467*^9},ExpressionUUID->"a907cba4-f488-4074-bd13-\
1addd5185df4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"15", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"1", "+", "ell"}], 
        RowBox[{
         RowBox[{"-", "1"}], "+", "ell"}], "0"},
       {
        RowBox[{
         RowBox[{"-", "1"}], "+", "ell"}], 
        RowBox[{"1", "+", "ell"}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"alpha", " ", "b22", " ", "beta", " ", 
    RowBox[{"(", 
     RowBox[{"ell", "-", 
      SuperscriptBox["lam", "2"]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"alpha", " ", "b22", " ", "beta", " ", 
     RowBox[{"(", 
      RowBox[{"ell", "-", 
       SuperscriptBox["lam", "2"]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["alpha", "2"], " ", "b11", " ", "lam", " ", "x"}], "-", 
    RowBox[{"b11", " ", 
     SuperscriptBox["beta", "2"], " ", "lam", " ", "y"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[15, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{
     1 + $CellContext`ell, -1 + $CellContext`ell, 0}, {-1 + $CellContext`ell, 
      1 + $CellContext`ell, 0}, {0, 0, 0}}], 
   "\n", $CellContext`alpha $CellContext`b22 $CellContext`beta \
($CellContext`ell - $CellContext`lam^2), 
   "\n", $CellContext`alpha $CellContext`b22 $CellContext`beta \
($CellContext`ell - $CellContext`lam^2) + $CellContext`alpha^2 \
$CellContext`b11 $CellContext`lam $CellContext`x - $CellContext`b11 \
$CellContext`beta^2 $CellContext`lam $CellContext`y, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.733848237128996*^9, 
   3.73385912534591*^9, {3.733859561421958*^9, 3.73385958974291*^9}, 
   3.733861276680868*^9, 
   3.734026239206874*^9},ExpressionUUID->"08b44507-b2a5-44ec-8a81-\
2a2edabfaf88"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"16", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", 
        RowBox[{"-", "1"}], "0"},
       {
        RowBox[{"-", "1"}], "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "-", 
    RowBox[{"alpha", " ", "b22", " ", "beta", " ", 
     SuperscriptBox["lam", "2"]}]}], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "-", 
    RowBox[{"lam", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"alpha", " ", "b22", " ", "beta", " ", "lam"}], "-", 
       RowBox[{
        SuperscriptBox["alpha", "2"], " ", "b11", " ", "x"}], "+", 
       RowBox[{"b11", " ", 
        SuperscriptBox["beta", "2"], " ", "y"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[16, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{1, -1, 0}, {-1, 1, 0}, {0, 0, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11 - $CellContext`alpha \
$CellContext`b22 $CellContext`beta $CellContext`lam^2, 
   "\n", $CellContext`a33^2 $CellContext`b11 - $CellContext`lam \
($CellContext`alpha $CellContext`b22 $CellContext`beta $CellContext`lam - \
$CellContext`alpha^2 $CellContext`b11 $CellContext`x + $CellContext`b11 \
$CellContext`beta^2 $CellContext`y), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.733848237128996*^9, 
   3.73385912534591*^9, {3.733859561421958*^9, 3.73385958974291*^9}, 
   3.733861276680868*^9, 
   3.7340262392083483`*^9},ExpressionUUID->"e46c865d-590e-4c36-a845-\
4bacff53b879"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"17", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2", "0", "0"},
       {"0", "2", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "-", 
    RowBox[{"alpha", " ", "b22", " ", "beta", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["lam", "2"]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "-", 
    RowBox[{"alpha", " ", "b22", " ", "beta", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["lam", "2"]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["alpha", "2"], " ", "b11", " ", "lam", " ", "x"}], "-", 
    RowBox[{"b11", " ", 
     SuperscriptBox["beta", "2"], " ", "lam", " ", "y"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[17, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{2, 0, 0}, {0, 2, 0}, {0, 0, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11 - $CellContext`alpha \
$CellContext`b22 $CellContext`beta (-1 + $CellContext`lam^2), 
   "\n", $CellContext`a33^2 $CellContext`b11 - $CellContext`alpha \
$CellContext`b22 $CellContext`beta (-1 + $CellContext`lam^2) + \
$CellContext`alpha^2 $CellContext`b11 $CellContext`lam $CellContext`x - \
$CellContext`b11 $CellContext`beta^2 $CellContext`lam $CellContext`y, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.733848237128996*^9, 
   3.73385912534591*^9, {3.733859561421958*^9, 3.73385958974291*^9}, 
   3.733861276680868*^9, 
   3.734026239209908*^9},ExpressionUUID->"e9a69cef-4aa0-4452-bc85-\
2daa98ce4486"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"18", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"1", "+", "ell"}], 
        RowBox[{
         RowBox[{"-", "1"}], "+", "ell"}], "0"},
       {
        RowBox[{
         RowBox[{"-", "1"}], "+", "ell"}], 
        RowBox[{"1", "+", "ell"}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{"alpha", " ", "b22", " ", "beta", " ", 
     RowBox[{"(", 
      RowBox[{"ell", "-", 
       SuperscriptBox["lam", "2"]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a33", "2"], " ", "b11"}], "+", 
    RowBox[{"alpha", " ", "b22", " ", "beta", " ", 
     RowBox[{"(", 
      RowBox[{"ell", "-", 
       SuperscriptBox["lam", "2"]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["alpha", "2"], " ", "b11", " ", "lam", " ", "x"}], "-", 
    RowBox[{"b11", " ", 
     SuperscriptBox["beta", "2"], " ", "lam", " ", "y"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[18, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{
     1 + $CellContext`ell, -1 + $CellContext`ell, 0}, {-1 + $CellContext`ell, 
      1 + $CellContext`ell, 0}, {0, 0, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11 + $CellContext`alpha \
$CellContext`b22 $CellContext`beta ($CellContext`ell - $CellContext`lam^2), 
   "\n", $CellContext`a33^2 $CellContext`b11 + $CellContext`alpha \
$CellContext`b22 $CellContext`beta ($CellContext`ell - $CellContext`lam^2) + \
$CellContext`alpha^2 $CellContext`b11 $CellContext`lam $CellContext`x - \
$CellContext`b11 $CellContext`beta^2 $CellContext`lam $CellContext`y, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.733848237128996*^9, 
   3.73385912534591*^9, {3.733859561421958*^9, 3.73385958974291*^9}, 
   3.733861276680868*^9, 
   3.734026239211413*^9},ExpressionUUID->"a89f919e-0e6a-45da-9048-\
f123aa732958"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"19", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    SuperscriptBox["a33", "2"], " ", "b11"}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   RowBox[{"b11", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a33", "2"], "+", 
      RowBox[{
       SuperscriptBox["alpha", "2"], " ", "lam", " ", "x"}], "-", 
      RowBox[{
       SuperscriptBox["beta", "2"], " ", "lam", " ", "y"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[19, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   "\n", $CellContext`a33^2 $CellContext`b11, 
   "\n", $CellContext`b11 ($CellContext`a33^2 + $CellContext`alpha^2 \
$CellContext`lam $CellContext`x - $CellContext`beta^2 $CellContext`lam \
$CellContext`y), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.733848237128996*^9, 
   3.73385912534591*^9, {3.733859561421958*^9, 3.73385958974291*^9}, 
   3.733861276680868*^9, 
   3.73402623921281*^9},ExpressionUUID->"2fc51e5d-4656-4b0a-9768-\
7efcb02a4abe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"20", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", "0", "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"b11", " ", "lam", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["alpha", "2"], " ", "x"}], "-", 
      RowBox[{
       SuperscriptBox["beta", "2"], " ", "y"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[20, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], "\n", 0, 
   "\n", $CellContext`b11 $CellContext`lam ($CellContext`alpha^2 \
$CellContext`x - $CellContext`beta^2 $CellContext`y), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7338432314543047`*^9, {3.73384327873946*^9, 3.7338433800652037`*^9}, 
   3.733843577730768*^9, 3.733844559483007*^9, 3.733846922525243*^9, {
   3.733846997612009*^9, 3.733847026471179*^9}, 3.733848237128996*^9, 
   3.73385912534591*^9, {3.733859561421958*^9, 3.73385958974291*^9}, 
   3.733861276680868*^9, 
   3.734026239214072*^9},ExpressionUUID->"f3703069-1962-4d79-9c2d-\
9f0218354666"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{Automatic, 3}, {Automatic, 63}},
FrontEndVersion->"11.1 for Linux x86 (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 7257, 194, 537, "Input", "ExpressionUUID" -> \
"ed5c14b4-baee-4e25-bf95-f91dace5a6d4"],
Cell[7840, 218, 2410, 63, 79, "Print", "ExpressionUUID" -> \
"227479df-a7c5-4c4f-8651-fe56022b4903"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10287, 286, 18227, 484, 998, "Input", "ExpressionUUID" -> \
"c79c6611-0495-4309-81d3-1af20344294d"],
Cell[28517, 772, 442, 8, 24, "Print", "ExpressionUUID" -> \
"25eee25c-ec5c-40ed-8d27-3d9318b45acc"]
}, Open  ]],
Cell[28974, 783, 248, 6, 55, "Input", "ExpressionUUID" -> \
"27692df7-1989-478d-9039-1f87b19304be"],
Cell[CellGroupData[{
Cell[29247, 793, 682, 21, 34, "Input", "ExpressionUUID" -> \
"380049ee-d641-42c7-a422-d22d8451544f"],
Cell[29932, 816, 681, 21, 34, "Output", "ExpressionUUID" -> \
"3984a3ed-3283-4c9b-baf9-efab5db39df3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30650, 842, 2975, 67, 286, "Input", "ExpressionUUID" -> \
"c58c4ed3-3f3b-4464-83b4-dd3dbd93447c"],
Cell[CellGroupData[{
Cell[33650, 913, 2928, 74, 157, "Print", "ExpressionUUID" -> \
"ad373b08-051d-4aee-a929-b3ccb553fc85"],
Cell[36581, 989, 3507, 86, 157, "Print", "ExpressionUUID" -> \
"d185fe6f-c66b-4262-b1f7-2d6da06d4aca"],
Cell[40091, 1077, 3679, 86, 173, "Print", "ExpressionUUID" -> \
"386eed74-1cb7-4fcf-8046-5cf3b15dcbc0"],
Cell[43773, 1165, 3458, 83, 157, "Print", "ExpressionUUID" -> \
"2ae5c280-6538-4e8e-82df-3b287f708afb"],
Cell[47234, 1250, 3798, 90, 180, "Print", "ExpressionUUID" -> \
"7ccac72a-9a7f-473d-b46a-4e08913760e1"],
Cell[51035, 1342, 3692, 87, 180, "Print", "ExpressionUUID" -> \
"9a2103e6-2bce-4778-a8f2-743a3908e78c"],
Cell[54730, 1431, 3045, 75, 156, "Print", "ExpressionUUID" -> \
"66a73f6d-28e8-462b-930c-02352c47596d"],
Cell[57778, 1508, 3425, 88, 156, "Print", "ExpressionUUID" -> \
"792bfec7-0b8d-4784-9ed1-ef356d87e5f4"],
Cell[61206, 1598, 3340, 84, 150, "Print", "ExpressionUUID" -> \
"670c249a-cf59-44f1-8ea2-86d48ea2713b"],
Cell[64549, 1684, 3504, 85, 151, "Print", "ExpressionUUID" -> \
"fdca0b5e-e237-4bb3-92f6-1283cc5a5fd6"],
Cell[68056, 1771, 3567, 85, 173, "Print", "ExpressionUUID" -> \
"39a720e6-086d-447e-b456-2aa8e341721c"],
Cell[71626, 1858, 3504, 85, 151, "Print", "ExpressionUUID" -> \
"9064d0ef-74b9-4a9c-b75b-0d5c647efc59"],
Cell[75133, 1945, 2903, 72, 157, "Print", "ExpressionUUID" -> \
"48d909c3-f7a6-4ad0-9aaf-b58900b0816e"],
Cell[78039, 2019, 3082, 77, 156, "Print", "ExpressionUUID" -> \
"ffbe15ee-5475-45c1-86b6-b1d525949fec"],
Cell[81124, 2098, 3235, 80, 165, "Print", "ExpressionUUID" -> \
"3b3c4b88-1d28-4bf2-bf26-981e31ef249d"],
Cell[84362, 2180, 3109, 77, 157, "Print", "ExpressionUUID" -> \
"2068798f-ec78-47ab-a565-7f062d824736"],
Cell[87474, 2259, 3210, 79, 165, "Print", "ExpressionUUID" -> \
"82bfec68-0f64-42fc-979d-7845db43492b"],
Cell[90687, 2340, 3461, 85, 165, "Print", "ExpressionUUID" -> \
"41c0ccb4-8d83-4125-b444-e736c55f2dfe"],
Cell[94151, 2427, 2662, 67, 157, "Print", "ExpressionUUID" -> \
"f8470ada-6d10-4fef-9d0e-5d477b1d52cd"],
Cell[96816, 2496, 2479, 62, 156, "Print", "ExpressionUUID" -> \
"7d1b17f2-3be7-4cad-821b-eaf8009c95cc"]
}, Open  ]]
}, Open  ]]
}
]
*)

