(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     87819,       2370]
NotebookOptionsPosition[     84227,       2286]
NotebookOutlinePosition[     84563,       2301]
CellTagsIndexPosition[     84520,       2298]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "This", " ", "file", " ", "calculates", " ", "the", " ", "inner", " ", 
    "product", " ", "pairings", " ", "for", " ", "the", " ", "mod", " ", "p", 
    " ", "orbits", " ", "O1211", " ", "and", " ", "OD12"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22", ",", " ", "a11", ",", " ", "a12", ",", " ", "a13", ",", " ",
       "a21", ",", " ", "a22", ",", " ", "a23", ",", " ", "a31", ",", " ", 
      "a32", ",", " ", "a33", ",", " ", "b11", ",", " ", "b12", ",", " ", 
      "b21", ",", " ", "b22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O1211", " ", "=", " ", "Ox"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OD12", " ", "=", " ", "Oxi"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Gact3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a11", ",", " ", "a12", ",", " ", "a13"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "c", ",", "d"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Gact2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"b11", ",", " ", "b12"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "b22"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x01", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x02", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "x01", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "x02", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.733834040192012*^9, 3.73383417454156*^9}, {
  3.73383429054252*^9, 3.733834334668531*^9}, {3.7338369238216963`*^9, 
  3.733836959732308*^9}, {3.7338375934586*^9, 3.733837605217167*^9}, {
  3.733837648713428*^9, 3.733837681840667*^9}, {3.733921156216448*^9, 
  3.733921185511188*^9}, {3.7413381468711767`*^9, 
  3.741338214887586*^9}},ExpressionUUID->"b07255f4-13c2-4d8c-b68d-\
956209f13c17"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", 
        RowBox[{"-", "1"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        FractionBox["1", "2"]},
       {"0", "0", "0"},
       {
        FractionBox["1", "2"], "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 1, 0}, {0, 0, -1}}], 
   MatrixForm[{{0, 0, 
      Rational[1, 2]}, {0, 0, 0}, {
      Rational[1, 2], 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.733836933925782*^9, 3.733836960154544*^9}, 
   3.733837683012678*^9, 3.73384332478533*^9, 3.733848349601753*^9, 
   3.7338628487950687`*^9, {3.73392116445081*^9, 3.733921187395494*^9}, {
   3.733928790387925*^9, 
   3.733928806832704*^9}},ExpressionUUID->"a051fb2b-1d6f-4146-8f67-\
af4528d6dabe"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"xiTable", " ", "=", " ", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"2", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"3", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           RowBox[{"1", "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"1", "/", "2"}], ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"4", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"5", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"6", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"7", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           RowBox[{"1", "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"1", "/", "2"}], ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"8", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"9", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"10", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"11", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"12", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"13", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"14", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"15", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"16", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"17", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"18", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"19", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"20", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "ell", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"21", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"22", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"23", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"24", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "y"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "y", ",", "0"}], "}"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Length", "[", "xiTable", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.733838846527213*^9, 3.7338389816092587`*^9}, {
  3.733840103914178*^9, 3.733840549544438*^9}, {3.733841144204008*^9, 
  3.7338411725242*^9}, {3.7338413258745413`*^9, 3.733841449707015*^9}, {
  3.733841647641047*^9, 3.73384165992979*^9}, {3.733841696696742*^9, 
  3.7338417267768*^9}, {3.733841759687078*^9, 3.733841842029541*^9}, {
  3.7338419005518093`*^9, 3.733841964896893*^9}, {3.7338420077764807`*^9, 
  3.733842494494863*^9}, {3.7338425291580353`*^9, 3.73384253410826*^9}, {
  3.733842581916871*^9, 3.7338425987478943`*^9}, {3.7338430232754297`*^9, 
  3.733843031201666*^9}},ExpressionUUID->"da4691e6-976e-4baf-afbf-\
78153f7618e8"],

Cell[BoxData["24"], "Print",
 CellChangeTimes->{
  3.733842534647914*^9, {3.733842587078554*^9, 3.733842599520444*^9}, 
   3.733843032008008*^9, 3.733843272133623*^9, 3.733848352336399*^9, 
   3.7338628517136307`*^9, {3.73392879190082*^9, 
   3.733928803752822*^9}},ExpressionUUID->"8ef193e5-23ca-455b-bcf5-\
c7ef2dc0a0d3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"xiTable", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.733843261533099*^9, 
  3.7338432667507677`*^9}},ExpressionUUID->"9a46bc26-3619-41bf-96e2-\
96c6437fe30e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.733843267678919*^9, 
  3.733843274949566*^9}},ExpressionUUID->"6a650b9e-b4d1-4471-bea7-\
6fe2580dc5ed"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", " ", 
   RowBox[{"i", "\[LessEqual]", 
    RowBox[{"Length", "[", "xiTable", "]"}]}], ",", " ", 
   RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Orbit", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"xi11", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", " ", "2"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xi12", " ", "=", " ", 
     RowBox[{"xiTable", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "3"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"xiACT31", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi11", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT32", " ", "=", " ", 
     RowBox[{"Gact3", ".", "xi12", ".", 
      RowBox[{"Transpose", "[", "Gact3", "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT1", " ", "=", " ", 
     RowBox[{
      RowBox[{"b11", " ", "*", " ", "xiACT31"}], " ", "+", " ", 
      RowBox[{"b12", " ", "*", " ", "xiACT32"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"xiACT2", " ", "=", " ", 
     RowBox[{"b22", " ", "*", " ", "xiACT32"}]}], ";", "\[IndentingNewLine]", 
    
    RowBox[{"Pairing", " ", "=", " ", 
     RowBox[{
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x01", "]"}], ".", "xiACT1"}], "]"}], "+", 
      RowBox[{"Tr", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "x02", "]"}], ".", "xiACT2"}], "]"}]}]}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"Orbit", ",", " ", "\"\<\\n\>\"", ",", 
      RowBox[{"MatrixForm", "[", "xi11", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "xi12", "]"}], ",", "\"\<\\n\>\"", ",", " ", 
      
      RowBox[{"Simplify", "[", "Pairing", "]"}], ",", " ", "\"\<\\n\>\""}], 
     "]"}], ";"}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{{3.7338344558294764`*^9, 3.733834473411776*^9}, {
   3.733836101706242*^9, 3.733836173825585*^9}, {3.7338362479212427`*^9, 
   3.733836338560684*^9}, {3.7338364006081953`*^9, 3.7338364411760187`*^9}, 
   3.733836754125835*^9, {3.733836844957556*^9, 3.733836903589159*^9}, {
   3.733836976822104*^9, 3.733837134583942*^9}, {3.733837278606353*^9, 
   3.7338373093731728`*^9}, {3.7338430584741707`*^9, 3.733843230695416*^9}, {
   3.7338433049029493`*^9, 3.733843379702538*^9}, {3.733843573077908*^9, 
   3.733843576709671*^9}, {3.7338483592003508`*^9, 3.733848364952241*^9}, {
   3.733862817250311*^9, 3.733862840290019*^9}, 3.733928795121152*^9, 
   3.7339288267162523`*^9},ExpressionUUID->"d4794bab-cd7a-42d1-9e69-\
d0aa520540fb"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\\\n\"\>", 
   "\[InvisibleSpace]", "0", "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[1, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], "\n", 0, "\n"],
  Editable->False]], "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 3.7339288287335997`*^9}, 
   3.7339420481197433`*^9},ExpressionUUID->"a8c81e0b-9d82-44cc-9e63-\
55d771d5c36f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"b11", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["d", "2"]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[2, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   "\n", $CellContext`b11 ($CellContext`b^2 - $CellContext`d^2), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 
   3.7339288287357893`*^9}},ExpressionUUID->"c55e5db1-232d-4b48-83fd-\
b60c72553283"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", 
        FractionBox["1", "2"]},
       {"0", 
        FractionBox["1", "2"], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"b11", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", "b"}], "-", 
      RowBox[{"c", " ", "d"}]}], ")"}]}], "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[3, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 
      Rational[1, 2]}, {0, 
      Rational[1, 2], 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   "\n", $CellContext`b11 ($CellContext`a $CellContext`b - $CellContext`c \
$CellContext`d), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 
   3.733928828737865*^9}},ExpressionUUID->"82524a44-158f-458b-ba88-\
9246195b6ec9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"-", "ell"}], "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"b11", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["d", "2"], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}], " ", "ell"}]}], ")"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[4, "\n", 
   MatrixForm[{{0, 0, 0}, {0, -$CellContext`ell, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   "\n", $CellContext`b11 ($CellContext`b^2 - $CellContext`d^2 + \
(-$CellContext`a^2 + $CellContext`c^2) $CellContext`ell), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 
   3.7339288287400227`*^9}},ExpressionUUID->"5653e8c7-f29e-4f3b-bde8-\
8179be694e7a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "0", "0"},
       {"1", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b11"}], "+", 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a11", " ", "b22"}], "-", 
       RowBox[{"b11", " ", "d"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[5, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}}], 
   "\n", $CellContext`b^2 $CellContext`b11 + $CellContext`d ($CellContext`a11 \
$CellContext`b22 - $CellContext`b11 $CellContext`d), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 
   3.733928828742034*^9}},ExpressionUUID->"993fe2da-98a9-420a-902c-\
7c7aa6a13d01"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"6", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "0", "0"},
       {"1", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b11"}], "-", 
    RowBox[{"b11", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"a11", " ", "b22", " ", "d"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[6, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}}], 
   "\n", $CellContext`a^2 $CellContext`b11 - $CellContext`b11 \
$CellContext`c^2 + $CellContext`a11 $CellContext`b22 $CellContext`d, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 
   3.733928828744074*^9}},ExpressionUUID->"9d96ac0c-8381-486c-b087-\
73abfc7736ec"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"7", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", 
        FractionBox["1", "2"]},
       {"0", 
        FractionBox["1", "2"], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "0", "0"},
       {"1", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"a", " ", "b", " ", "b11"}], "+", 
    RowBox[{"a11", " ", "b22", " ", "d"}], "-", 
    RowBox[{"b11", " ", "c", " ", "d"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[7, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 
      Rational[1, 2]}, {0, 
      Rational[1, 2], 0}}], 
   MatrixForm[{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}}], 
   "\n", $CellContext`a $CellContext`b $CellContext`b11 + $CellContext`a11 \
$CellContext`b22 $CellContext`d - $CellContext`b11 $CellContext`c \
$CellContext`d, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 
   3.7339288287461348`*^9}},ExpressionUUID->"13c331d8-29c6-4212-acec-\
8dbea8c0ed36"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"8", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "0", "0"},
       {"1", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b11"}], "+", 
    RowBox[{"2", " ", "a", " ", "b", " ", "b11"}], "+", 
    RowBox[{"a11", " ", "b22", " ", "d"}], "-", 
    RowBox[{"b11", " ", "c", " ", 
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"2", " ", "d"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[8, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 1, 1}, {0, 1, 0}}], 
   MatrixForm[{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}}], 
   "\n", $CellContext`a^2 $CellContext`b11 + 
   2 $CellContext`a $CellContext`b $CellContext`b11 + $CellContext`a11 \
$CellContext`b22 $CellContext`d - $CellContext`b11 $CellContext`c \
($CellContext`c + 2 $CellContext`d), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 
   3.733928828801255*^9}},ExpressionUUID->"99f26a59-87e4-45df-ae82-\
416f1267bfa1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"9", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"-", "ell"}], "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "0", "0"},
       {"1", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b11"}], "+", 
    RowBox[{"a11", " ", "b22", " ", "d"}], "-", 
    RowBox[{"b11", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["d", "2"], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", "ell"}], "-", 
       RowBox[{
        SuperscriptBox["c", "2"], " ", "ell"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[9, "\n", 
   MatrixForm[{{0, 0, 0}, {0, -$CellContext`ell, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}}], 
   "\n", $CellContext`b^2 $CellContext`b11 + $CellContext`a11 \
$CellContext`b22 $CellContext`d - $CellContext`b11 ($CellContext`d^2 + \
$CellContext`a^2 $CellContext`ell - $CellContext`c^2 $CellContext`ell), "\n"],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 
   3.733928828803434*^9}},ExpressionUUID->"abfb3eb9-3d48-4ae4-9dd7-\
a8df6603505d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"10", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "0", "0"},
       {"1", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"a11", " ", "b22", " ", "d"}], "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[10, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}}], 
   "\n", $CellContext`a11 $CellContext`b22 $CellContext`d, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 
   3.7339288288050833`*^9}},ExpressionUUID->"78b6f848-d185-4591-94ce-\
85fdbbd40886"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"11", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b12"}], "+", 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a13", " ", "b22"}], "-", 
       RowBox[{"b12", " ", "d"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[11, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   "\n", $CellContext`b^2 $CellContext`b12 + $CellContext`d ($CellContext`a13 \
$CellContext`b22 - $CellContext`b12 $CellContext`d), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 
   3.733928828806615*^9}},ExpressionUUID->"90715058-fcbd-4c9e-bb64-\
7556486fcab6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"12", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", "a", " ", "b", " ", "b11"}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b12"}], "+", 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a13", " ", "b22"}], "-", 
       RowBox[{"2", " ", "b11", " ", "c"}], "-", 
       RowBox[{"b12", " ", "d"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[12, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], "\n", 
   2 $CellContext`a $CellContext`b $CellContext`b11 + $CellContext`b^2 \
$CellContext`b12 + $CellContext`d ($CellContext`a13 $CellContext`b22 - 
     2 $CellContext`b11 $CellContext`c - $CellContext`b12 $CellContext`d), 
   "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 
   3.7339288288081427`*^9}},ExpressionUUID->"664eb08d-82ea-4a6a-86b7-\
108fe405136b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"13", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b11"}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b12"}], "-", 
    RowBox[{"b11", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"a13", " ", "b22", " ", "d"}], "-", 
    RowBox[{"b12", " ", 
     SuperscriptBox["d", "2"]}]}], "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[13, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   "\n", $CellContext`a^2 $CellContext`b11 + $CellContext`b^2 \
$CellContext`b12 - $CellContext`b11 $CellContext`c^2 + $CellContext`a13 \
$CellContext`b22 $CellContext`d - $CellContext`b12 $CellContext`d^2, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 
   3.73392882880969*^9}},ExpressionUUID->"1ec3b543-63c2-4a17-ba40-\
3e2e31b511fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"14", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1", "0"},
       {"1", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b12"}], "+", 
    RowBox[{"a11", " ", "b22", " ", "c"}], "+", 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a13", " ", "b22"}], "-", 
       RowBox[{"b12", " ", "d"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[14, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 1, 0}, {1, 0, 0}, {0, 0, 1}}], 
   "\n", $CellContext`b^2 $CellContext`b12 + $CellContext`a11 \
$CellContext`b22 $CellContext`c + $CellContext`d ($CellContext`a13 \
$CellContext`b22 - $CellContext`b12 $CellContext`d), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 
   3.733928828811203*^9}},ExpressionUUID->"0512d4d6-2be6-4e3c-91b4-\
5d3c9724e9f0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"15", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1", "0"},
       {"1", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", "a", " ", "b", " ", "b11"}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b12"}], "+", 
    RowBox[{"a11", " ", "b22", " ", "c"}], "+", 
    RowBox[{"a13", " ", "b22", " ", "d"}], "-", 
    RowBox[{"2", " ", "b11", " ", "c", " ", "d"}], "-", 
    RowBox[{"b12", " ", 
     SuperscriptBox["d", "2"]}]}], "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[15, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}}], 
   MatrixForm[{{0, 1, 0}, {1, 0, 0}, {0, 0, 1}}], "\n", 
   2 $CellContext`a $CellContext`b $CellContext`b11 + $CellContext`b^2 \
$CellContext`b12 + $CellContext`a11 $CellContext`b22 $CellContext`c + \
$CellContext`a13 $CellContext`b22 $CellContext`d - 
   2 $CellContext`b11 $CellContext`c $CellContext`d - $CellContext`b12 \
$CellContext`d^2, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 
   3.73392882881273*^9}},ExpressionUUID->"2af6355b-b236-4fff-97ff-\
d1ae564e8a80"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"16", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1", "0"},
       {"1", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b11"}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b12"}], "+", 
    RowBox[{"a11", " ", "b22", " ", "c"}], "-", 
    RowBox[{"b11", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"a13", " ", "b22", " ", "d"}], "-", 
    RowBox[{"b12", " ", 
     SuperscriptBox["d", "2"]}]}], "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[16, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 1, 0}, {1, 0, 0}, {0, 0, 1}}], 
   "\n", $CellContext`a^2 $CellContext`b11 + $CellContext`b^2 \
$CellContext`b12 + $CellContext`a11 $CellContext`b22 $CellContext`c - \
$CellContext`b11 $CellContext`c^2 + $CellContext`a13 $CellContext`b22 \
$CellContext`d - $CellContext`b12 $CellContext`d^2, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 
   3.7339288288143044`*^9}},ExpressionUUID->"b273495a-32cd-4674-ae56-\
01c737954ff2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"17", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", "a", " ", "b", " ", "b12"}], "+", 
    RowBox[{"a13", " ", "b22", " ", "c"}], "+", 
    RowBox[{"a12", " ", "b22", " ", "d"}], "-", 
    RowBox[{"2", " ", "b12", " ", "c", " ", "d"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[17, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}}], "\n", 
   2 $CellContext`a $CellContext`b $CellContext`b12 + $CellContext`a13 \
$CellContext`b22 $CellContext`c + $CellContext`a12 $CellContext`b22 \
$CellContext`d - 2 $CellContext`b12 $CellContext`c $CellContext`d, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 
   3.733928828815859*^9}},ExpressionUUID->"a849ba1f-cfec-40b8-af14-\
369096073e00"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"18", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b11"}], "+", 
    RowBox[{"2", " ", "a", " ", "b", " ", "b12"}], "+", 
    RowBox[{"a13", " ", "b22", " ", "c"}], "+", 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a12", " ", "b22"}], "-", 
       RowBox[{"2", " ", "b12", " ", "c"}], "-", 
       RowBox[{"b11", " ", "d"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[18, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}}], 
   "\n", $CellContext`b^2 $CellContext`b11 + 
   2 $CellContext`a $CellContext`b $CellContext`b12 + $CellContext`a13 \
$CellContext`b22 $CellContext`c + $CellContext`d ($CellContext`a12 \
$CellContext`b22 - 
     2 $CellContext`b12 $CellContext`c - $CellContext`b11 $CellContext`d), 
   "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 
   3.7339288288173523`*^9}},ExpressionUUID->"033cbc4a-9175-451b-9764-\
83ca54f269be"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"19", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox["b", "2"]}], ")"}], " ", "b11"}], "+", 
    RowBox[{"2", " ", "a", " ", "b", " ", "b12"}], "-", 
    RowBox[{"2", " ", "b12", " ", "c", " ", "d"}], "+", 
    RowBox[{"b22", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a13", " ", "c"}], "+", 
       RowBox[{"a12", " ", "d"}]}], ")"}]}], "-", 
    RowBox[{"b11", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["c", "2"], "+", 
       SuperscriptBox["d", "2"]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[19, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 1, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}}], 
   "\n", ($CellContext`a^2 + $CellContext`b^2) $CellContext`b11 + 
   2 $CellContext`a $CellContext`b $CellContext`b12 - 
   2 $CellContext`b12 $CellContext`c $CellContext`d + $CellContext`b22 \
($CellContext`a13 $CellContext`c + $CellContext`a12 $CellContext`d) - \
$CellContext`b11 ($CellContext`c^2 + $CellContext`d^2), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 
   3.733928828818902*^9}},ExpressionUUID->"eb52180c-b593-4845-8448-\
24d80ba19827"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"20", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "ell", "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", "a", " ", "b", " ", "b12"}], "-", 
    RowBox[{"2", " ", "b12", " ", "c", " ", "d"}], "+", 
    RowBox[{"b22", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a13", " ", "c"}], "+", 
       RowBox[{"a12", " ", "d"}]}], ")"}]}], "+", 
    RowBox[{"b11", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", "ell"}]}], ")"}]}], "-", 
    RowBox[{"b11", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["d", "2"], "+", 
       RowBox[{
        SuperscriptBox["c", "2"], " ", "ell"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[20, "\n", 
   MatrixForm[{{0, 0, 0}, {0, $CellContext`ell, 0}, {0, 0, 1}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}}], "\n", 
   2 $CellContext`a $CellContext`b $CellContext`b12 - 
   2 $CellContext`b12 $CellContext`c $CellContext`d + $CellContext`b22 \
($CellContext`a13 $CellContext`c + $CellContext`a12 $CellContext`d) + \
$CellContext`b11 ($CellContext`b^2 + $CellContext`a^2 $CellContext`ell) - \
$CellContext`b11 ($CellContext`d^2 + $CellContext`c^2 $CellContext`ell), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 
   3.733928828820557*^9}},ExpressionUUID->"ded13691-94ff-4081-926f-\
279bfbdb3e47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"21", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"-", "ell"}], "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b12"}], "+", 
    RowBox[{"a13", " ", "b22", " ", "d"}], "-", 
    RowBox[{"b12", " ", 
     SuperscriptBox["d", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b12", " ", "ell"}], "-", 
    RowBox[{"a12", " ", "b22", " ", "c", " ", "ell"}], "+", 
    RowBox[{"b12", " ", 
     SuperscriptBox["c", "2"], " ", "ell"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[21, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, -$CellContext`ell, 0}, {0, 0, 1}}], 
   "\n", $CellContext`b^2 $CellContext`b12 + $CellContext`a13 \
$CellContext`b22 $CellContext`d - $CellContext`b12 $CellContext`d^2 - \
$CellContext`a^2 $CellContext`b12 $CellContext`ell - $CellContext`a12 \
$CellContext`b22 $CellContext`c $CellContext`ell + $CellContext`b12 \
$CellContext`c^2 $CellContext`ell, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 
   3.733928828822173*^9}},ExpressionUUID->"a95d107b-5ba0-4554-bc76-\
160e99c3faa2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"22", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"-", "ell"}], "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b12"}], "-", 
    RowBox[{"b11", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"a13", " ", "b22", " ", "d"}], "-", 
    RowBox[{"b12", " ", 
     SuperscriptBox["d", "2"]}], "-", 
    RowBox[{"a12", " ", "b22", " ", "c", " ", "ell"}], "+", 
    RowBox[{"b12", " ", 
     SuperscriptBox["c", "2"], " ", "ell"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"b11", "-", 
       RowBox[{"b12", " ", "ell"}]}], ")"}]}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[22, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, -$CellContext`ell, 0}, {0, 0, 1}}], 
   "\n", $CellContext`b^2 $CellContext`b12 - $CellContext`b11 \
$CellContext`c^2 + $CellContext`a13 $CellContext`b22 $CellContext`d - \
$CellContext`b12 $CellContext`d^2 - $CellContext`a12 $CellContext`b22 \
$CellContext`c $CellContext`ell + $CellContext`b12 $CellContext`c^2 \
$CellContext`ell + $CellContext`a^2 ($CellContext`b11 - $CellContext`b12 \
$CellContext`ell), "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 
   3.733928828842819*^9}},ExpressionUUID->"38e19aa6-2fe4-4bed-bc6d-\
cf4027cc276a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"23", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "1"},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"-", "ell"}], "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"2", " ", "a", " ", "b", " ", "b11"}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b12"}], "+", 
    RowBox[{"a13", " ", "b22", " ", "d"}], "-", 
    RowBox[{"2", " ", "b11", " ", "c", " ", "d"}], "-", 
    RowBox[{"b12", " ", 
     SuperscriptBox["d", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "b12", " ", "ell"}], "-", 
    RowBox[{"a12", " ", "b22", " ", "c", " ", "ell"}], "+", 
    RowBox[{"b12", " ", 
     SuperscriptBox["c", "2"], " ", "ell"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[23, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 0, 1}, {0, 1, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, -$CellContext`ell, 0}, {0, 0, 1}}], "\n", 
   2 $CellContext`a $CellContext`b $CellContext`b11 + $CellContext`b^2 \
$CellContext`b12 + $CellContext`a13 $CellContext`b22 $CellContext`d - 
   2 $CellContext`b11 $CellContext`c $CellContext`d - $CellContext`b12 \
$CellContext`d^2 - $CellContext`a^2 $CellContext`b12 $CellContext`ell - \
$CellContext`a12 $CellContext`b22 $CellContext`c $CellContext`ell + \
$CellContext`b12 $CellContext`c^2 $CellContext`ell, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 
   3.7339288288446074`*^9}},ExpressionUUID->"60cd26bf-d07a-427b-8f86-\
bddaba841bf5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"24", "\[InvisibleSpace]", "\<\"\\n\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", "y"},
       {"0", "y", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"-", "ell"}], "0"},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"\\n\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "b12"}], "-", 
    RowBox[{"b11", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{"a13", " ", "b22", " ", "d"}], "-", 
    RowBox[{"b12", " ", 
     SuperscriptBox["d", "2"]}], "-", 
    RowBox[{"a12", " ", "b22", " ", "c", " ", "ell"}], "+", 
    RowBox[{"b12", " ", 
     SuperscriptBox["c", "2"], " ", "ell"}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"b11", "-", 
       RowBox[{"b12", " ", "ell"}]}], ")"}]}], "+", 
    RowBox[{"2", " ", "a", " ", "b", " ", "b11", " ", "y"}], "-", 
    RowBox[{"2", " ", "b11", " ", "c", " ", "d", " ", "y"}]}], 
   "\[InvisibleSpace]", "\<\"\\n\"\>"}],
  SequenceForm[24, "\n", 
   MatrixForm[{{0, 0, 0}, {0, 1, $CellContext`y}, {0, $CellContext`y, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, -$CellContext`ell, 0}, {0, 0, 1}}], 
   "\n", $CellContext`b^2 $CellContext`b12 - $CellContext`b11 \
$CellContext`c^2 + $CellContext`a13 $CellContext`b22 $CellContext`d - \
$CellContext`b12 $CellContext`d^2 - $CellContext`a12 $CellContext`b22 \
$CellContext`c $CellContext`ell + $CellContext`b12 $CellContext`c^2 \
$CellContext`ell + $CellContext`a^2 ($CellContext`b11 - $CellContext`b12 \
$CellContext`ell) + 
   2 $CellContext`a $CellContext`b $CellContext`b11 $CellContext`y - 
   2 $CellContext`b11 $CellContext`c $CellContext`d $CellContext`y, "\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733862855033292*^9, {3.733928795897192*^9, 
   3.7339288288462467`*^9}},ExpressionUUID->"ff0c824c-3e83-4b92-acda-\
3efd10010045"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{Automatic, 100}, {Automatic, 59}},
FrontEndVersion->"11.1 for Linux x86 (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 3137, 78, 284, "Input", "ExpressionUUID" -> \
"b07255f4-13c2-4d8c-b68d-956209f13c17"],
Cell[3720, 102, 1912, 53, 79, "Print", "ExpressionUUID" -> \
"40ad2b62-f5bf-4434-98f7-2cc6b4eac8aa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5669, 160, 17369, 484, 630, "Input", "ExpressionUUID" -> \
"c378a6df-bb39-4369-adf9-3e7ca40d46af"],
Cell[23041, 646, 323, 6, 24, "Print", "ExpressionUUID" -> \
"b0159871-9021-4288-bcae-82cd6cd89dd8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23401, 657, 248, 6, 55, "Input", "ExpressionUUID" -> \
"76c115ff-e0db-4aeb-ba1c-88adcb2de11f"],
Cell[23652, 665, 705, 21, 34, "Output", "ExpressionUUID" -> \
"5728afba-95ca-4133-a8d1-c1806cdf0fab"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24394, 691, 2836, 63, 286, "Input", "ExpressionUUID" -> \
"f5a672e1-c59f-4624-b8d5-be046e5ec00d"],
Cell[CellGroupData[{
Cell[27255, 758, 1892, 49, 107, "Print", "ExpressionUUID" -> \
"a8c81e0b-9d82-44cc-9e63-55d771d5c36f"],
Cell[29150, 809, 2010, 54, 136, "Print", "ExpressionUUID" -> \
"2597f420-6c09-419f-b9aa-eeb4c0ec46da"],
Cell[31163, 865, 2124, 58, 153, "Print", "ExpressionUUID" -> \
"2aa4da74-bd4c-4fec-bf8b-704c80f334da"],
Cell[33290, 925, 2296, 62, 136, "Print", "ExpressionUUID" -> \
"bfa37aa7-f52b-4fe9-8240-2fdde1eab29b"],
Cell[35589, 989, 2161, 58, 129, "Print", "ExpressionUUID" -> \
"1ab5f2e0-7882-442d-acd8-4cea9247bd75"],
Cell[37753, 1049, 2124, 56, 129, "Print", "ExpressionUUID" -> \
"b810bff7-6c26-4560-886c-49d3aad1d6b3"],
Cell[39880, 1107, 2214, 59, 153, "Print", "ExpressionUUID" -> \
"c57bdca5-92a9-4a48-b5cb-19065db243ff"],
Cell[42097, 1168, 2336, 61, 129, "Print", "ExpressionUUID" -> \
"4189f51d-07b8-4faf-966c-12c5c24b8d0d"],
Cell[44436, 1231, 2430, 65, 136, "Print", "ExpressionUUID" -> \
"f8c2eda4-5784-4625-9225-2f8b713a4b7e"],
Cell[46869, 1298, 1907, 49, 127, "Print", "ExpressionUUID" -> \
"4735df07-8602-4ce6-bb72-f81a286931ae"],
Cell[48779, 1349, 2163, 58, 129, "Print", "ExpressionUUID" -> \
"3201015a-2e66-4946-bec7-f299d40e09c8"],
Cell[50945, 1409, 2369, 62, 129, "Print", "ExpressionUUID" -> \
"3be81a03-196d-4e9e-9263-7aa77e5074b2"],
Cell[53317, 1473, 2323, 60, 129, "Print", "ExpressionUUID" -> \
"e49b63d5-3fd9-4bb5-8d65-278bef464ebd"],
Cell[55643, 1535, 2265, 60, 129, "Print", "ExpressionUUID" -> \
"216e1e3d-5885-4ade-8171-d229004ae195"],
Cell[57911, 1597, 2445, 61, 129, "Print", "ExpressionUUID" -> \
"c7d1102f-a7a2-43d5-a5ca-d5b894b5ecc0"],
Cell[60359, 1660, 2428, 62, 129, "Print", "ExpressionUUID" -> \
"10caafaa-0c2f-49b9-92bc-9d422e7f1688"],
Cell[62790, 1724, 2244, 56, 127, "Print", "ExpressionUUID" -> \
"cef5813c-ce9b-449d-81cf-da4c61952488"],
Cell[65037, 1782, 2475, 65, 129, "Print", "ExpressionUUID" -> \
"7e48511d-8494-4f50-a37c-e39e1c5b8fcf"],
Cell[67515, 1849, 2699, 71, 136, "Print", "ExpressionUUID" -> \
"e1c5c197-0ff7-45b2-add3-72926f37f929"],
Cell[70217, 1922, 2810, 73, 136, "Print", "ExpressionUUID" -> \
"695aaeee-0cb2-4afa-ae53-58cc070d9cbd"],
Cell[73030, 1997, 2561, 65, 129, "Print", "ExpressionUUID" -> \
"da90bd6c-4a41-49a2-80b6-f84470042d61"],
Cell[75594, 2064, 2757, 71, 129, "Print", "ExpressionUUID" -> \
"c8587b88-0f32-4200-8e8c-eb621318acef"],
Cell[78354, 2137, 2783, 68, 129, "Print", "ExpressionUUID" -> \
"24dfbdcf-61e7-4fd9-a108-2ae742a48416"],
Cell[81140, 2207, 3059, 75, 151, "Print", "ExpressionUUID" -> \
"d6ac97af-e6ad-4dab-95fa-de8b0d955fc2"]
}, Open  ]]
}, Open  ]]
}
]
*)

