(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    299625,       7855]
NotebookOptionsPosition[    290607,       7649]
NotebookOutlinePosition[    290942,       7664]
CellTagsIndexPosition[    290899,       7661]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "file", " ", "checks", " ", "the", " ", "annihilator", " ", 
    "space", " ", "calculations", " ", "performed", " ", "in", " ", 
    "Appendix", " ", "A"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Each", " ", "calculation", " ", "first", " ", "checks", " ", "the", " ", 
     "outcome", " ", "of", " ", "the", " ", "action", " ", "on", " ", "the", 
     " ", "orbit", " ", "representative"}], ",", " ", 
    RowBox[{
    "and", " ", "then", " ", "attempts", " ", "to", " ", "solve", " ", "a", 
     " ", "system", " ", "of", " ", "equations", " ", "for", " ", "the", " ", 
     "span", " ", "of", " ", "the", " ", "tangent", " ", 
     RowBox[{"space", ".", "  ", "A"}], " ", "solution", " ", "proves", " ", 
     "that", " ", "the", " ", "space", " ", "spanned", " ", "is", " ", "at", 
     " ", "least", " ", "as", " ", "large", " ", "as", " ", "claimed"}]}], 
   "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Calculation", " ", "for", " ", "orbit", " ", "OD12"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
      "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
      "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
      "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OD12", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", " ", "+", " ", 
          RowBox[{"A11", "*", "x"}]}], " ", ",", 
         RowBox[{"A12", "*", "x"}], ",", 
         RowBox[{"A13", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A21", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A22", "*", "x"}]}], ",", 
         RowBox[{"A23", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A31", "*", "x"}], ",", 
         RowBox[{"A32", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A33", "*", "x"}]}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B11", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", 
     RowBox[{"B12", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", 
     RowBox[{"B21", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B22", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A2", "-", "A"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B2", "-", "B"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[LineSeparator]", 
   RowBox[{"Solve", "[", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"X33", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "3", ",", " ", "3"}], "]"}]}], " ", "&&", 
      "  ", 
      RowBox[{"Y13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y33", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "3", ",", " ", "3"}], "]"}]}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
      "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
       "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
       "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
       "B22"}], "}"}]}], "]"}], " "}]}]], "Input",
 CellChangeTimes->{{3.73359167771329*^9, 3.7335917747592487`*^9}, {
   3.7335928757537622`*^9, 3.733593001799844*^9}, {3.733593037231927*^9, 
   3.733593079929015*^9}, {3.7335931392807283`*^9, 3.733593197239018*^9}, {
   3.733596771169653*^9, 3.733596822648776*^9}, {3.733596921000082*^9, 
   3.733596969247678*^9}, {3.733597087439447*^9, 3.7335971256314077`*^9}, {
   3.733597186142908*^9, 3.733597257158031*^9}, 3.733599651962337*^9, 
   3.733599841686605*^9, {3.741179492352049*^9, 3.741179523929205*^9}, {
   3.741179578399563*^9, 3.741179588536525*^9}, {3.741179957228796*^9, 
   3.741179972541913*^9}, {3.741180041053074*^9, 3.741180041253957*^9}, {
   3.741180129621738*^9, 3.7411801330284033`*^9}, {3.741180361579597*^9, 
   3.7411805291054707`*^9}},ExpressionUUID->"6b9a84f7-bda9-4ff8-b9ef-\
105964ac347c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "B12"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "A13"},
       {"0", "0", "A23"},
       {"A13", "A23", 
        RowBox[{
         RowBox[{"2", " ", "A33"}], "+", "B22"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`B12}}], 
   MatrixForm[{{0, 0, $CellContext`A13}, {
     0, 0, $CellContext`A23}, {$CellContext`A13, $CellContext`A23, 
      2 $CellContext`A33 + $CellContext`B22}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7411800095855513`*^9, 3.7411800445017643`*^9, 
  3.741180457789956*^9, 
  3.741180615912303*^9},ExpressionUUID->"0b3e8778-6863-4b40-8a29-\
b21f921b7919"],

Cell[BoxData[
 TemplateBox[{
  "Solve","svars",
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"",2,
   257,17,15758455304263670798,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.74117997451399*^9, 3.741180009599723*^9, 
  3.741180044511983*^9, 3.741180457804646*^9, 
  3.7411806159221783`*^9},ExpressionUUID->"476bb10c-4210-479c-b14f-\
4a5617fabbcb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A13", "\[Rule]", "Y13"}], ",", 
    RowBox[{"A23", "\[Rule]", "Y23"}], ",", 
    RowBox[{"B12", "\[Rule]", "X33"}], ",", 
    RowBox[{"B22", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "A33"}], "+", "Y33"}]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.7411799745154467`*^9, 3.7411800096014433`*^9, 
  3.741180044513227*^9, 3.741180457805965*^9, 
  3.741180615923465*^9},ExpressionUUID->"f6389cf1-f3bf-43b7-bf0e-\
1b8ae5b73db7"]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{{3.741179759747016*^9, 3.7411798020318108`*^9}, 
   3.7411800346519423`*^9},ExpressionUUID->"1c09a611-37a9-4539-badb-\
91ea633ca539"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Calculation", " ", "for", " ", "orbit", " ", "OD11"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.741179808369708*^9, 
  3.741179818277514*^9}},ExpressionUUID->"d724082c-ce04-49ba-b0f9-\
124815af4468"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", "A22", 
    ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", "A33", ",", 
    " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"OD11", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"1", "/", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"1", "/", "2"}], ",", "0"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g3", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", " ", "+", " ", 
        RowBox[{"A11", "*", "x"}]}], " ", ",", 
       RowBox[{"A12", "*", "x"}], ",", 
       RowBox[{"A13", "*", "x"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"A21", "*", "x"}], ",", 
       RowBox[{"1", "+", 
        RowBox[{"A22", "*", "x"}]}], ",", 
       RowBox[{"A23", "*", "x"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"A31", "*", "x"}], ",", 
       RowBox[{"A32", "*", "x"}], ",", 
       RowBox[{"1", "+", 
        RowBox[{"A33", "*", "x"}]}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A1", " ", "=", " ", 
   RowBox[{"g3", ".", "A", ".", 
    RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B1", " ", "=", " ", 
   RowBox[{"g3", ".", "B", ".", 
    RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b11", " ", "=", " ", 
   RowBox[{"1", "+", 
    RowBox[{"B11", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b12", " ", "=", " ", 
   RowBox[{"B12", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b21", " ", "=", " ", 
   RowBox[{"B21", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b22", " ", "=", " ", 
   RowBox[{"1", "+", 
    RowBox[{"B22", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A2", " ", "=", 
   RowBox[{"Simplify", "[", " ", 
    RowBox[{
     RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
     RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B2", " ", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
     RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A3", " ", "=", " ", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A2", "-", "A"}], ")"}], "/", "x"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B3", " ", "=", " ", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"B2", "-", "B"}], ")"}], "/", "x"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
    RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
    RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Solve", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"X23", " ", "==", " ", 
      RowBox[{"Part", "[", 
       RowBox[{"A3", ",", "2", ",", "3"}], "]"}]}], "&&", " ", 
     RowBox[{"Y12", " ", "\[Equal]", " ", 
      RowBox[{"Part", "[", 
       RowBox[{"B3", ",", " ", "1", ",", " ", "2"}], "]"}]}], " ", "&&", " ", 
     
     RowBox[{"Y13", " ", "\[Equal]", " ", 
      RowBox[{"Part", "[", 
       RowBox[{"B3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
     
     RowBox[{"Y22", " ", "\[Equal]", " ", 
      RowBox[{"Part", "[", 
       RowBox[{"B3", ",", " ", "2", ",", " ", "2"}], "]"}]}], "&&", " ", 
     RowBox[{"Y23", " ", "\[Equal]", " ", 
      RowBox[{"Part", "[", 
       RowBox[{"B3", ",", " ", "2", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
     
     RowBox[{"Y33", " ", "\[Equal]", " ", 
      RowBox[{"Part", "[", 
       RowBox[{"B3", ",", " ", "3", ",", " ", "3"}], "]"}]}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
     "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
      "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
      "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
      "B22"}], "}"}]}], "]"}], " "}]}], "Input",
 CellChangeTimes->{{3.7335937814515553`*^9, 3.733593799851452*^9}, {
   3.733599644298493*^9, 3.7335996753270283`*^9}, {3.74118006800508*^9, 
   3.741180076366067*^9}, 
   3.741180329286273*^9},ExpressionUUID->"68250ddd-9b49-4174-9629-\
70ca5652c7fd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", 
        FractionBox["B12", "2"]},
       {"0", 
        FractionBox["B12", "2"], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["A13", "2"], 
        FractionBox["A12", "2"]},
       {
        FractionBox["A13", "2"], "A23", 
        RowBox[{
         FractionBox["A22", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B22", "2"]}]},
       {
        FractionBox["A12", "2"], 
        RowBox[{
         FractionBox["A22", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B22", "2"]}], "A32"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, Rational[1, 2] $CellContext`B12}, {
     0, Rational[1, 2] $CellContext`B12, 0}}], 
   MatrixForm[{{
     0, Rational[1, 2] $CellContext`A13, Rational[1, 2] $CellContext`A12}, {
     Rational[1, 2] $CellContext`A13, $CellContext`A23, 
      Rational[1, 2] $CellContext`A22 + Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B22}, {
     Rational[1, 2] $CellContext`A12, Rational[1, 2] $CellContext`A22 + 
      Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B22, $CellContext`A32}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7335938029496517`*^9, 3.733599644962996*^9, 
  3.733599675681305*^9, 3.741179923851603*^9, 3.741180078871346*^9, 
  3.741180331156743*^9, 
  3.7411806115327463`*^9},ExpressionUUID->"f1987d48-9d25-4add-9872-\
0386a0dc6d47"],

Cell[BoxData[
 TemplateBox[{
  "Solve","svars",
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"",2,
   238,16,15758455304263670798,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7411800788852167`*^9, 3.741180331159309*^9, 
  3.741180611543022*^9},ExpressionUUID->"027555a2-9cc3-46a7-8fdf-\
5bf95319ce75"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A12", "\[Rule]", 
     RowBox[{"2", " ", "Y13"}]}], ",", 
    RowBox[{"A13", "\[Rule]", 
     RowBox[{"2", " ", "Y12"}]}], ",", 
    RowBox[{"A23", "\[Rule]", "Y22"}], ",", 
    RowBox[{"A32", "\[Rule]", "Y33"}], ",", 
    RowBox[{"B12", "\[Rule]", 
     RowBox[{"2", " ", "X23"}]}], ",", 
    RowBox[{"B22", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "A22"}], "-", "A33", "+", 
      RowBox[{"2", " ", "Y23"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.74118007888663*^9, 3.741180331172345*^9, 
  3.7411806115444202`*^9},ExpressionUUID->"bf9dd8c5-62e3-4f40-bca7-\
f005d464210c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Calculation", " ", "for", " ", "orbit", " ", "OD2"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
      "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
      "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
      "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OD2", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", "ell"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", " ", "+", " ", 
          RowBox[{"A11", "*", "x"}]}], " ", ",", 
         RowBox[{"A12", "*", "x"}], ",", 
         RowBox[{"A13", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A21", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A22", "*", "x"}]}], ",", 
         RowBox[{"A23", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A31", "*", "x"}], ",", 
         RowBox[{"A32", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A33", "*", "x"}]}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B11", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", 
     RowBox[{"B12", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", 
     RowBox[{"B21", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B22", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A2", "-", "A"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B2", "-", "B"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[LineSeparator]", 
   RowBox[{"Solve", "[", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"X22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", " ", "2"}], "]"}]}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "3", ",", "3"}], "]"}], " ", "==", 
       RowBox[{
        RowBox[{"-", "ell"}], " ", "*", " ", "X22"}]}], " ", "&&", " ", 
      RowBox[{"Y12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "2"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "2"}], "]"}]}], "&&", " ", 
      RowBox[{"Y23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y33", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "3", ",", " ", "3"}], "]"}]}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
      "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
       "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
       "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
       "B22"}], "}"}]}], "]"}], " "}]}]], "Input",
 CellChangeTimes->{{3.733595082507434*^9, 3.7335951058112583`*^9}, 
   3.7335996314261312`*^9, {3.733600658976707*^9, 3.733600723176785*^9}, 
   3.733600790137896*^9, {3.7336008566431513`*^9, 3.7336009435769157`*^9}, {
   3.741180544682925*^9, 3.741180549257206*^9}, 
   3.741518782496426*^9},ExpressionUUID->"e53c8087-2031-4df3-b009-\
f711e87caa83"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "B12", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", "B12"}], " ", "ell"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "A12", 
        RowBox[{
         RowBox[{"-", "A13"}], " ", "ell"}]},
       {"A12", 
        RowBox[{
         RowBox[{"2", " ", "A22"}], "+", "B22"}], 
        RowBox[{"A32", "-", 
         RowBox[{"A23", " ", "ell"}]}]},
       {
        RowBox[{
         RowBox[{"-", "A13"}], " ", "ell"}], 
        RowBox[{"A32", "-", 
         RowBox[{"A23", " ", "ell"}]}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "A33", " ", "ell"}], "-", 
         RowBox[{"B22", " ", "ell"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, $CellContext`B12, 0}, {
     0, 0, -$CellContext`B12 $CellContext`ell}}], 
   MatrixForm[{{
     0, $CellContext`A12, -$CellContext`A13 $CellContext`ell}, \
{$CellContext`A12, 
      2 $CellContext`A22 + $CellContext`B22, $CellContext`A32 - \
$CellContext`A23 $CellContext`ell}, {-$CellContext`A13 $CellContext`ell, \
$CellContext`A32 - $CellContext`A23 $CellContext`ell, (-2) $CellContext`A33 \
$CellContext`ell - $CellContext`B22 $CellContext`ell}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733600845371673*^9, 3.733600889098926*^9, {3.733600931232766*^9, 
   3.733600943932493*^9}, 
   3.7415187839771852`*^9},ExpressionUUID->"f1b47a38-664a-46ea-8b96-\
19c06ca456e4"],

Cell[BoxData[
 TemplateBox[{
  "Solve","svars",
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"",2,
   19,1,15760678233849001608,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.733600845426985*^9, 3.733600889214624*^9, {3.733600931246756*^9, 
   3.733600943941572*^9}, 
   3.741518784075589*^9},ExpressionUUID->"9455c141-99ca-488f-941a-\
40eac4b07fa9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A12", "\[Rule]", "Y12"}], ",", 
    RowBox[{"A13", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["Y13", "ell"]}]}], ",", 
    RowBox[{"A22", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["B22", "2"]}], "+", 
      FractionBox["Y22", "2"]}]}], ",", 
    RowBox[{"A32", "\[Rule]", 
     RowBox[{
      RowBox[{"A23", " ", "ell"}], "+", "Y23"}]}], ",", 
    RowBox[{"A33", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["B22", "2"]}], "-", 
      FractionBox["Y33", 
       RowBox[{"2", " ", "ell"}]]}]}], ",", 
    RowBox[{"B12", "\[Rule]", "X22"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.733600845428897*^9, 3.7336008892242947`*^9, {3.733600931258792*^9, 
   3.7336009439431*^9}, 
   3.741518784077777*^9},ExpressionUUID->"a694f9fc-655e-4043-a413-\
797aef870d9a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Calculation", " ", "for", " ", "orbit", " ", "ODns"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
      "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
      "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
      "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ODns", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], ",", "0"}], "}"}]}], "}"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", " ", "+", " ", 
          RowBox[{"A11", "*", "x"}]}], " ", ",", 
         RowBox[{"A12", "*", "x"}], ",", 
         RowBox[{"A13", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A21", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A22", "*", "x"}]}], ",", 
         RowBox[{"A23", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A31", "*", "x"}], ",", 
         RowBox[{"A32", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A33", "*", "x"}]}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B11", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", 
     RowBox[{"B12", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", 
     RowBox[{"B21", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B22", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A2", "-", "A"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B2", "-", "B"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"X11", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "1"}], "]"}]}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", "2", ",", "3"}], "]"}], " ", "==", 
       RowBox[{
        RowBox[{"-", "  ", "X11"}], "/", "2"}]}], " ", "&&", " ", 
      RowBox[{"Y11", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "1"}], "]"}]}], " ", "&&", 
      RowBox[{"Y12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "2"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "2"}], "]"}]}], "&&", " ", 
      RowBox[{"Y23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y33", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "3", ",", " ", "3"}], "]"}]}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
      "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
       "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
       "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
       "B22"}], "}"}]}], "]"}], " "}]}]], "Input",
 CellChangeTimes->{{3.733595294602071*^9, 3.7335953448657207`*^9}, 
   3.733599621562696*^9, {3.733600988015665*^9, 3.7336009882333403`*^9}, {
   3.7336012315656033`*^9, 3.733601282334116*^9}, {3.73360132705517*^9, 
   3.733601328037538*^9}, 3.73360137640718*^9, {3.7411805555302343`*^9, 
   3.741180559473351*^9}},ExpressionUUID->"6f06c422-2647-456e-8dc2-\
4f9194d510b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"B12", "0", "0"},
       {"0", "0", 
        RowBox[{"-", 
         FractionBox["B12", "2"]}]},
       {"0", 
        RowBox[{"-", 
         FractionBox["B12", "2"]}], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"2", " ", "A11"}], "+", "B22"}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox["A13", "2"]}], "+", "A21"}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox["A12", "2"]}], "+", "A31"}]},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox["A13", "2"]}], "+", "A21"}], 
        RowBox[{"-", "A23"}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox["A22", "2"]}], "-", 
         FractionBox["A33", "2"], "-", 
         FractionBox["B22", "2"]}]},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox["A12", "2"]}], "+", "A31"}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox["A22", "2"]}], "-", 
         FractionBox["A33", "2"], "-", 
         FractionBox["B22", "2"]}], 
        RowBox[{"-", "A32"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`B12, 0, 0}, {
     0, 0, Rational[-1, 2] $CellContext`B12}, {
     0, Rational[-1, 2] $CellContext`B12, 0}}], 
   MatrixForm[{{
     2 $CellContext`A11 + $CellContext`B22, 
      Rational[-1, 2] $CellContext`A13 + $CellContext`A21, 
      Rational[-1, 2] $CellContext`A12 + $CellContext`A31}, {
     Rational[-1, 2] $CellContext`A13 + $CellContext`A21, -$CellContext`A23, 
      Rational[-1, 2] $CellContext`A22 + Rational[-1, 2] $CellContext`A33 + 
      Rational[-1, 2] $CellContext`B22}, {
     Rational[-1, 2] $CellContext`A12 + $CellContext`A31, 
      Rational[-1, 2] $CellContext`A22 + Rational[-1, 2] $CellContext`A33 + 
      Rational[-1, 2] $CellContext`B22, -$CellContext`A32}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7335953460191307`*^9, 3.733599622353468*^9, 
  3.733601282992628*^9, 3.7336013287948847`*^9, 3.733601378087232*^9, 
  3.741180608492597*^9},ExpressionUUID->"06f98dac-7e90-4f1c-94b7-\
d5fbd05186cb"],

Cell[BoxData[
 TemplateBox[{
  "Solve","svars",
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"",2,
   219,15,15758455304263670798,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.733601378131454*^9, 
  3.741180608531723*^9},ExpressionUUID->"7d3355d8-20da-4abd-849f-\
46c11878abbe"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A21", "\[Rule]", 
     RowBox[{
      FractionBox["A13", "2"], "+", "Y12"}]}], ",", 
    RowBox[{"A23", "\[Rule]", 
     RowBox[{"-", "Y22"}]}], ",", 
    RowBox[{"A31", "\[Rule]", 
     RowBox[{
      FractionBox["A12", "2"], "+", "Y13"}]}], ",", 
    RowBox[{"A32", "\[Rule]", 
     RowBox[{"-", "Y33"}]}], ",", 
    RowBox[{"A33", "\[Rule]", 
     RowBox[{
      RowBox[{"2", " ", "A11"}], "-", "A22", "-", "Y11", "-", 
      RowBox[{"2", " ", "Y23"}]}]}], ",", 
    RowBox[{"B12", "\[Rule]", "X11"}], ",", 
    RowBox[{"B22", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "A11"}], "+", "Y11"}]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.73360128302181*^9, 3.7336013288201237`*^9, 
  3.733601378133112*^9, 
  3.741180608534275*^9},ExpressionUUID->"d863a180-53c7-4558-8b42-\
42c3915ac403"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Calculation", " ", "for", " ", "orbit", " ", "OCs"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
      "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
      "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
      "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OCs", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", " ", "+", " ", 
          RowBox[{"A11", "*", "x"}]}], " ", ",", 
         RowBox[{"A12", "*", "x"}], ",", 
         RowBox[{"A13", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A21", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A22", "*", "x"}]}], ",", 
         RowBox[{"A23", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A31", "*", "x"}], ",", 
         RowBox[{"A32", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A33", "*", "x"}]}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B11", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", 
     RowBox[{"B12", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", 
     RowBox[{"B21", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B22", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A2", "-", "A"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B2", "-", "B"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"X13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X33", " ", "==", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "3", ",", " ", "3"}], "]"}]}], "&&", " ", 
      RowBox[{
       RowBox[{"X13", "/", "2"}], " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "2"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "2"}], "]"}]}], "&&", " ", 
      RowBox[{"Y23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y33", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "3", ",", " ", "3"}], "]"}]}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
      "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
       "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
       "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
       "B22"}], "}"}]}], "]"}], " ", "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.733595736335226*^9, 3.733595783574955*^9}, 
   3.733599615282296*^9, {3.733601028831479*^9, 3.733601028912595*^9}, {
   3.733601544027596*^9, 3.7336016556844587`*^9}, {3.741180565234292*^9, 
   3.741180568489225*^9}},ExpressionUUID->"8848bac7-6c06-4422-b570-\
ce467d31b380"],

Cell[BoxData[
 TemplateBox[{
  "Solve","svars",
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"",2,
   199,14,15758455304263670798,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.733601634426359*^9, 3.733601656403573*^9}, 
   3.741180605816305*^9},ExpressionUUID->"819d50c6-97ab-46c1-a958-\
db03a36b5a06"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A12", "\[Rule]", 
     RowBox[{"2", " ", "Y13"}]}], ",", 
    RowBox[{"A13", "\[Rule]", "X13"}], ",", 
    RowBox[{"A23", "\[Rule]", "Y22"}], ",", 
    RowBox[{"B11", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "A33"}], "+", "X33"}]}], ",", 
    RowBox[{"B12", "\[Rule]", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"X23", "-", "Y22"}], ")"}]}]}], ",", 
    RowBox[{"B21", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "A32"}], "+", "Y33"}]}], ",", 
    RowBox[{"B22", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "A22"}], "-", "A33", "+", 
      RowBox[{"2", " ", "Y23"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.733601634440696*^9, 3.733601656414502*^9}, 
   3.741180605828425*^9},ExpressionUUID->"1fd7e4fb-04c6-403f-b91f-\
7e1fbfcf0b1b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "A13"},
       {"0", "0", 
        RowBox[{"A23", "+", 
         FractionBox["B12", "2"]}]},
       {"A13", 
        RowBox[{"A23", "+", 
         FractionBox["B12", "2"]}], 
        RowBox[{
         RowBox[{"2", " ", "A33"}], "+", "B11"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["A13", "2"], 
        FractionBox["A12", "2"]},
       {
        FractionBox["A13", "2"], "A23", 
        RowBox[{
         FractionBox["A22", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B22", "2"]}]},
       {
        FractionBox["A12", "2"], 
        RowBox[{
         FractionBox["A22", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B22", "2"]}], 
        RowBox[{"A32", "+", "B21"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, $CellContext`A13}, {
     0, 0, $CellContext`A23 + 
      Rational[1, 2] $CellContext`B12}, {$CellContext`A13, $CellContext`A23 + 
      Rational[1, 2] $CellContext`B12, 
      2 $CellContext`A33 + $CellContext`B11}}], 
   MatrixForm[{{
     0, Rational[1, 2] $CellContext`A13, Rational[1, 2] $CellContext`A12}, {
     Rational[1, 2] $CellContext`A13, $CellContext`A23, 
      Rational[1, 2] $CellContext`A22 + Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B22}, {
     Rational[1, 2] $CellContext`A12, Rational[1, 2] $CellContext`A22 + 
      Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B22, $CellContext`A32 + $CellContext`B21}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.733595755494873*^9, 3.7335957850236692`*^9}, 
   3.733599616207254*^9, {3.7336016344447823`*^9, 3.7336016564176207`*^9}, 
   3.74118060583228*^9},ExpressionUUID->"3efac87f-9704-4483-8df2-\
4a4e99540e52"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Calculation", " ", "for", " ", "orbit", " ", "OCns"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
      "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
      "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
      "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OCns", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", " ", "+", " ", 
          RowBox[{"A11", "*", "x"}]}], " ", ",", 
         RowBox[{"A12", "*", "x"}], ",", 
         RowBox[{"A13", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A21", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A22", "*", "x"}]}], ",", 
         RowBox[{"A23", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A31", "*", "x"}], ",", 
         RowBox[{"A32", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A33", "*", "x"}]}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B11", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", 
     RowBox[{"B12", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", 
     RowBox[{"B21", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B22", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A2", "-", "A"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B2", "-", "B"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"X12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "2"}], "]"}]}], "&&", " ", 
      RowBox[{"X13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "3"}], "]"}]}], "&&", " ", 
      RowBox[{"X22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", " ", "2"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X33", " ", "==", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "3", ",", " ", "3"}], "]"}]}], "&&", "  ", 
      RowBox[{
       RowBox[{"2", "*", "X12"}], "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "1"}], "]"}]}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"X22", "/", "2"}], " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "2"}], "]"}]}], " ", "&&", 
      "  ", 
      RowBox[{"Y13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", 
      "  ", 
      RowBox[{"Y23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y33", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "3", ",", " ", "3"}], "]"}]}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
      "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
       "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
       "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
       "B22"}], "}"}]}], "]"}], " "}]}]], "Input",
 CellChangeTimes->{{3.733595924213896*^9, 3.733595964101692*^9}, 
   3.733599609210425*^9, {3.733601035967195*^9, 3.733601036216511*^9}, {
   3.733601721434455*^9, 3.733601722782187*^9}, {3.7336017578589163`*^9, 
   3.733601847994854*^9}, {3.741180574177264*^9, 
   3.74118058100103*^9}},ExpressionUUID->"64dbce0e-b596-4c9b-96ad-\
cdc7ed73ba1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["A13", "2"], 
        RowBox[{
         FractionBox["A12", "2"], "+", 
         FractionBox["B12", "2"]}]},
       {
        FractionBox["A13", "2"], "A23", 
        RowBox[{
         FractionBox["A22", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B11", "2"]}]},
       {
        RowBox[{
         FractionBox["A12", "2"], "+", 
         FractionBox["B12", "2"]}], 
        RowBox[{
         FractionBox["A22", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B11", "2"]}], "A32"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"A13", 
        FractionBox["A23", "2"], 
        RowBox[{
         FractionBox["A11", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B22", "2"]}]},
       {
        FractionBox["A23", "2"], "0", 
        RowBox[{
         FractionBox["A21", "2"], "+", 
         FractionBox["B21", "2"]}]},
       {
        RowBox[{
         FractionBox["A11", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B22", "2"]}], 
        RowBox[{
         FractionBox["A21", "2"], "+", 
         FractionBox["B21", "2"]}], "A31"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     0, Rational[1, 2] $CellContext`A13, Rational[1, 2] $CellContext`A12 + 
      Rational[1, 2] $CellContext`B12}, {
     Rational[1, 2] $CellContext`A13, $CellContext`A23, 
      Rational[1, 2] $CellContext`A22 + Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B11}, {
     Rational[1, 2] $CellContext`A12 + Rational[1, 2] $CellContext`B12, 
      Rational[1, 2] $CellContext`A22 + Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B11, $CellContext`A32}}], 
   MatrixForm[{{$CellContext`A13, Rational[1, 2] $CellContext`A23, 
      Rational[1, 2] $CellContext`A11 + Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B22}, {
     Rational[1, 2] $CellContext`A23, 0, Rational[1, 2] $CellContext`A21 + 
      Rational[1, 2] $CellContext`B21}, {
     Rational[1, 2] $CellContext`A11 + Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B22, Rational[1, 2] $CellContext`A21 + 
      Rational[1, 2] $CellContext`B21, $CellContext`A31}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733595970611772*^9, 3.7335996101881742`*^9, 
  3.73360184870934*^9, 
  3.741180602604504*^9},ExpressionUUID->"5d4c3af9-0dde-4348-a40e-\
e77ff865c263"],

Cell[BoxData[
 TemplateBox[{
  "Solve","svars",
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"",2,
   181,13,15758455304263670798,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.73360184875182*^9, 
  3.741180602653193*^9},ExpressionUUID->"b594e3bf-632e-49a7-928a-\
ff38e56549b2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A13", "\[Rule]", 
     RowBox[{"2", " ", "X12"}]}], ",", 
    RowBox[{"A23", "\[Rule]", "X22"}], ",", 
    RowBox[{"A31", "\[Rule]", "Y33"}], ",", 
    RowBox[{"A32", "\[Rule]", "X33"}], ",", 
    RowBox[{"B11", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "A22"}], "-", "A33", "+", 
      RowBox[{"2", " ", "X23"}]}]}], ",", 
    RowBox[{"B12", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "A12"}], "+", 
      RowBox[{"2", " ", "X13"}]}]}], ",", 
    RowBox[{"B21", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "A21"}], "+", 
      RowBox[{"2", " ", "Y23"}]}]}], ",", 
    RowBox[{"B22", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "A11"}], "-", "A33", "+", 
      RowBox[{"2", " ", "Y13"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.733601848754051*^9, 
  3.741180602655179*^9},ExpressionUUID->"940ad5e1-2088-42dd-9f8b-\
9fa6c01fb86a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Calculation", " ", "for", " ", "orbit", " ", "OB11"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
      "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
      "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
      "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OB11", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", " ", "+", " ", 
          RowBox[{"A11", "*", "x"}]}], " ", ",", 
         RowBox[{"A12", "*", "x"}], ",", 
         RowBox[{"A13", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A21", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A22", "*", "x"}]}], ",", 
         RowBox[{"A23", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A31", "*", "x"}], ",", 
         RowBox[{"A32", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A33", "*", "x"}]}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B11", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", 
     RowBox[{"B12", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", 
     RowBox[{"B21", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B22", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A2", "-", "A"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B2", "-", "B"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"X12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "2"}], "]"}]}], "&&", " ", 
      RowBox[{"X22", "\[Equal]", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", "2", ",", "2"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X33", " ", "==", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "3", ",", " ", "3"}], "]"}]}], "&&", 
      RowBox[{"Y13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "2"}], "]"}]}], "&&", " ", 
      RowBox[{"Y23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y33", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "3", ",", " ", "3"}], "]"}]}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
      "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
       "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
       "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
       "B22"}], "}"}]}], "]"}], " "}]}]], "Input",
 CellChangeTimes->{{3.733596140100863*^9, 3.733596164404357*^9}, 
   3.733599601945904*^9, {3.733601041791214*^9, 3.733601042032353*^9}, {
   3.733601895081215*^9, 3.733601896283972*^9}, {3.733601998577908*^9, 
   3.733602058369392*^9}, {3.741180588225634*^9, 
   3.741180593857239*^9}},ExpressionUUID->"1b037972-d937-4ef1-8996-\
11e2a008373e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "A12", "0"},
       {"A12", 
        RowBox[{
         RowBox[{"2", " ", "A22"}], "+", "B11"}], "A32"},
       {"0", "A32", "B12"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "A13"},
       {"0", "B21", "A23"},
       {"A13", "A23", 
        RowBox[{
         RowBox[{"2", " ", "A33"}], "+", "B22"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     0, $CellContext`A12, 0}, {$CellContext`A12, 
      2 $CellContext`A22 + $CellContext`B11, $CellContext`A32}, {
     0, $CellContext`A32, $CellContext`B12}}], 
   MatrixForm[{{0, 0, $CellContext`A13}, {
     0, $CellContext`B21, $CellContext`A23}, {$CellContext`A13, \
$CellContext`A23, 2 $CellContext`A33 + $CellContext`B22}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733596166432909*^9, 3.733599602998788*^9, 
  3.733602078122517*^9, 
  3.741180599380518*^9},ExpressionUUID->"fadba9d1-6a3c-4a92-93af-\
ac12ec350f01"],

Cell[BoxData[
 TemplateBox[{
  "Solve","svars",
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"",2,
   162,12,15758455304263670798,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.733602078161725*^9, 
  3.741180599434132*^9},ExpressionUUID->"fa714b87-2481-456f-be70-\
028ee9968045"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A12", "\[Rule]", "X12"}], ",", 
    RowBox[{"A13", "\[Rule]", "Y13"}], ",", 
    RowBox[{"A23", "\[Rule]", "Y23"}], ",", 
    RowBox[{"A32", "\[Rule]", "X23"}], ",", 
    RowBox[{"B11", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "A22"}], "+", "X22"}]}], ",", 
    RowBox[{"B12", "\[Rule]", "X33"}], ",", 
    RowBox[{"B21", "\[Rule]", "Y22"}], ",", 
    RowBox[{"B22", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "A33"}], "+", "Y33"}]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.733602078163096*^9, 
  3.741180599435796*^9},ExpressionUUID->"25686e7b-18bb-422c-91c2-\
2635efb7eb8b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Calculation", " ", "for", " ", "orbit", " ", "OB2"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
      "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
      "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
      "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OB2", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "ell"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", " ", "+", " ", 
          RowBox[{"A11", "*", "x"}]}], " ", ",", 
         RowBox[{"A12", "*", "x"}], ",", 
         RowBox[{"A13", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A21", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A22", "*", "x"}]}], ",", 
         RowBox[{"A23", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A31", "*", "x"}], ",", 
         RowBox[{"A32", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A33", "*", "x"}]}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B11", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", 
     RowBox[{"B12", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", 
     RowBox[{"B21", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B22", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A2", "-", "A"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B2", "-", "B"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"X12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "2"}], "]"}]}], "&&", " ", 
      RowBox[{"X13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "3"}], "]"}]}], "&&", " ", 
      RowBox[{"X22", "\[Equal]", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", "2", ",", "2"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X33", " ", "==", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "3", ",", " ", "3"}], "]"}]}], "&&", 
      RowBox[{
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "2"}], "]"}], " ", "\[Equal]", 
       " ", 
       RowBox[{"2", " ", "*", " ", "X13"}]}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"2", "*", "ell", " ", "*", " ", "X12"}], " ", "\[Equal]", " ", 
       
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "2"}], "]"}]}], "&&", " ", 
      RowBox[{"Y23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y33", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "3", ",", " ", "3"}], "]"}]}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
      "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
       "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
       "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
       "B22"}], "}"}]}], "]"}], " "}]}]], "Input",
 CellChangeTimes->{{3.7335962235003433`*^9, 3.7335962460840197`*^9}, 
   3.733599591929739*^9, {3.7336010462231913`*^9, 3.733601046456551*^9}, {
   3.73360211398403*^9, 3.733602185688266*^9}, {3.741180635145694*^9, 
   3.741180639001034*^9}},ExpressionUUID->"19a93e7b-a454-41dc-a5f7-\
69d24341f88b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["A13", "2"], 
        FractionBox["A12", "2"]},
       {
        FractionBox["A13", "2"], 
        RowBox[{"A23", "+", "B12"}], 
        RowBox[{
         FractionBox["A22", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B11", "2"]}]},
       {
        FractionBox["A12", "2"], 
        RowBox[{
         FractionBox["A22", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B11", "2"]}], 
        RowBox[{"A32", "+", 
         RowBox[{"B12", " ", "ell"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "A12", 
        RowBox[{"A13", " ", "ell"}]},
       {"A12", 
        RowBox[{
         RowBox[{"2", " ", "A22"}], "+", "B22"}], 
        RowBox[{"A32", "+", 
         FractionBox["B21", "2"], "+", 
         RowBox[{"A23", " ", "ell"}]}]},
       {
        RowBox[{"A13", " ", "ell"}], 
        RowBox[{"A32", "+", 
         FractionBox["B21", "2"], "+", 
         RowBox[{"A23", " ", "ell"}]}], 
        RowBox[{
         RowBox[{"2", " ", "A33", " ", "ell"}], "+", 
         RowBox[{"B22", " ", "ell"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     0, Rational[1, 2] $CellContext`A13, Rational[1, 2] $CellContext`A12}, {
     Rational[1, 2] $CellContext`A13, $CellContext`A23 + $CellContext`B12, 
      Rational[1, 2] $CellContext`A22 + Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B11}, {
     Rational[1, 2] $CellContext`A12, Rational[1, 2] $CellContext`A22 + 
      Rational[1, 2] $CellContext`A33 + 
      Rational[1, 
         2] $CellContext`B11, $CellContext`A32 + $CellContext`B12 \
$CellContext`ell}}], 
   MatrixForm[{{
     0, $CellContext`A12, $CellContext`A13 $CellContext`ell}, \
{$CellContext`A12, 2 $CellContext`A22 + $CellContext`B22, $CellContext`A32 + 
      Rational[1, 
         2] $CellContext`B21 + $CellContext`A23 $CellContext`ell}, \
{$CellContext`A13 $CellContext`ell, $CellContext`A32 + 
      Rational[1, 2] $CellContext`B21 + $CellContext`A23 $CellContext`ell, 
      2 $CellContext`A33 $CellContext`ell + $CellContext`B22 \
$CellContext`ell}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733596255466798*^9, 3.733599593208807*^9, 
  3.733602189320496*^9, 
  3.7411806432023287`*^9},ExpressionUUID->"215904c9-24e3-4698-a260-\
a250b99cd10c"],

Cell[BoxData[
 TemplateBox[{
  "Solve","svars",
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"",2,
   276,18,15758455304263670798,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.733602189373126*^9, 
  3.7411806432354*^9},ExpressionUUID->"032dfdfb-de83-40b2-a17f-6034f38de063"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A12", "\[Rule]", 
     RowBox[{"2", " ", "X13"}]}], ",", 
    RowBox[{"A13", "\[Rule]", 
     RowBox[{"2", " ", "X12"}]}], ",", 
    RowBox[{"A32", "\[Rule]", 
     RowBox[{
      RowBox[{"A23", " ", "ell"}], "-", 
      RowBox[{"ell", " ", "X22"}], "+", "X33"}]}], ",", 
    RowBox[{"A33", "\[Rule]", 
     RowBox[{"A22", "-", 
      FractionBox[
       RowBox[{
        RowBox[{"ell", " ", "Y22"}], "-", "Y33"}], 
       RowBox[{"2", " ", "ell"}]]}]}], ",", 
    RowBox[{"B11", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "A22"}], "-", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", "ell", " ", "X23"}], "-", 
        RowBox[{"ell", " ", "Y22"}], "+", "Y33"}], 
       RowBox[{"2", " ", "ell"}]]}]}], ",", 
    RowBox[{"B12", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "A23"}], "+", "X22"}]}], ",", 
    RowBox[{"B21", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", "A23", " ", "ell"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ell", " ", "X22"}], "-", "X33", "+", "Y23"}], ")"}]}]}]}], 
    ",", 
    RowBox[{"B22", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "A22"}], "+", "Y22"}]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.733602189375848*^9, 
  3.741180643236951*^9},ExpressionUUID->"94a0d2fd-54e6-4291-aadf-\
adef802f1f68"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Calculation", " ", "for", " ", "orbit", " ", "O14"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
      "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
      "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
      "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", "B11", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", "B12", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", "B21", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", "B22", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O14", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", " ", "+", " ", 
          RowBox[{"A11", "*", "x"}]}], " ", ",", 
         RowBox[{"A12", "*", "x"}], ",", 
         RowBox[{"A13", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A21", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A22", "*", "x"}]}], ",", 
         RowBox[{"A23", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A31", "*", "x"}], ",", 
         RowBox[{"A32", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A33", "*", "x"}]}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B11", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", 
     RowBox[{"B12", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", 
     RowBox[{"B21", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B22", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A2", "-", "A"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B2", "-", "B"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"X22", "\[Equal]", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", "2", ",", "2"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X33", " ", "==", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "3", ",", " ", "3"}], "]"}]}], "&&", " ", 
      RowBox[{"Y11", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "1"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "2"}], "]"}]}], "&&", 
      RowBox[{"Y13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "2"}], "]"}]}], "&&", " ", 
      RowBox[{"Y23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y33", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "3", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "3"}], "]"}], " ", "\[Equal]", 
       " ", 
       RowBox[{"Y11", " ", "+", 
        RowBox[{"X22", "/", "2"}]}]}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
      "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
       "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
       "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
       "B22"}], "}"}]}], "]"}], " "}]}]], "Input",
 CellChangeTimes->{{3.733598168408433*^9, 3.733598254023713*^9}, 
   3.733599585154594*^9, {3.7336010509912977`*^9, 3.7336010512565727`*^9}, {
   3.733602248159173*^9, 3.733602339503474*^9}, {3.7411806472659893`*^9, 
   3.741180651920858*^9}},ExpressionUUID->"4dde34a6-ad94-473b-afa2-\
f8797815d864"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{"A13", "+", 
         FractionBox["B12", "2"]}]},
       {"0", "B12", "A23"},
       {
        RowBox[{"A13", "+", 
         FractionBox["B12", "2"]}], "A23", 
        RowBox[{
         RowBox[{"2", " ", "A33"}], "+", "B11"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"A13", 
        RowBox[{"A12", "+", 
         FractionBox["A23", "2"]}], 
        RowBox[{
         FractionBox["A11", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B22", "2"]}]},
       {
        RowBox[{"A12", "+", 
         FractionBox["A23", "2"]}], 
        RowBox[{
         RowBox[{"2", " ", "A22"}], "+", "B22"}], 
        RowBox[{
         FractionBox["A21", "2"], "+", "A32"}]},
       {
        RowBox[{
         FractionBox["A11", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B22", "2"]}], 
        RowBox[{
         FractionBox["A21", "2"], "+", "A32"}], 
        RowBox[{"A31", "+", "B21"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, $CellContext`A13 + Rational[1, 2] $CellContext`B12}, {
     0, $CellContext`B12, $CellContext`A23}, {$CellContext`A13 + 
      Rational[1, 2] $CellContext`B12, $CellContext`A23, 
      2 $CellContext`A33 + $CellContext`B11}}], 
   MatrixForm[{{$CellContext`A13, $CellContext`A12 + 
      Rational[1, 2] $CellContext`A23, Rational[1, 2] $CellContext`A11 + 
      Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B22}, {$CellContext`A12 + 
      Rational[1, 2] $CellContext`A23, 2 $CellContext`A22 + $CellContext`B22, 
      Rational[1, 2] $CellContext`A21 + $CellContext`A32}, {
     Rational[1, 2] $CellContext`A11 + Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B22, 
      Rational[1, 
         2] $CellContext`A21 + $CellContext`A32, $CellContext`A31 + \
$CellContext`B21}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733598255360571*^9, 3.733599585856361*^9, 
  3.733602341632412*^9, 
  3.741180652899959*^9},ExpressionUUID->"82666bd1-36cf-46e8-823d-\
3dac09c0b5b6"],

Cell[BoxData[
 TemplateBox[{
  "Solve","svars",
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"",2,
   299,19,15758455304263670798,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.733602341685759*^9, 
  3.741180652948245*^9},ExpressionUUID->"a45b4823-975b-4f21-ace9-\
ac7f4fc82b8a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A12", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "X23"}], "+", 
        RowBox[{"2", " ", "Y12"}]}], ")"}]}]}], ",", 
    RowBox[{"A13", "\[Rule]", "Y11"}], ",", 
    RowBox[{"A23", "\[Rule]", "X23"}], ",", 
    RowBox[{"A32", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["A21", "2"]}], "+", "Y23"}]}], ",", 
    RowBox[{"A33", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "A11"}], "+", 
      RowBox[{"2", " ", "A22"}], "+", 
      RowBox[{"2", " ", "Y13"}], "-", "Y22"}]}], ",", 
    RowBox[{"B11", "\[Rule]", 
     RowBox[{
      RowBox[{"2", " ", "A11"}], "-", 
      RowBox[{"4", " ", "A22"}], "+", "X33", "-", 
      RowBox[{"4", " ", "Y13"}], "+", 
      RowBox[{"2", " ", "Y22"}]}]}], ",", 
    RowBox[{"B12", "\[Rule]", "X22"}], ",", 
    RowBox[{"B21", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "A31"}], "+", "Y33"}]}], ",", 
    RowBox[{"B22", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "A22"}], "+", "Y22"}]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.7336023416882*^9, 
  3.7411806529503593`*^9},ExpressionUUID->"99eee9f6-b9de-44fe-ac70-\
c245c247fb71"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Calculation", " ", "for", " ", "orbit", " ", "O131"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
      "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
      "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
      "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O131", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", " ", "+", " ", 
          RowBox[{"A11", "*", "x"}]}], " ", ",", 
         RowBox[{"A12", "*", "x"}], ",", 
         RowBox[{"A13", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A21", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A22", "*", "x"}]}], ",", 
         RowBox[{"A23", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A31", "*", "x"}], ",", 
         RowBox[{"A32", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A33", "*", "x"}]}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B11", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", 
     RowBox[{"B12", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", 
     RowBox[{"B21", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B22", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A2", "-", "A"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B2", "-", "B"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"X13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", 
      RowBox[{"X22", "\[Equal]", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", "2", ",", "2"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X33", " ", "==", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "3", ",", " ", "3"}], "]"}]}], "&&", " ", 
      RowBox[{"Y11", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "1"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "2"}], "]"}]}], "&&", 
      RowBox[{"Y13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "2"}], "]"}]}], "&&", " ", 
      RowBox[{"Y23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y33", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "3", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "2"}], "]"}], " ", "\[Equal]", 
       " ", 
       RowBox[{"Y11", "/", "2"}]}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
      "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
       "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
       "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
       "B22"}], "}"}]}], "]"}], " "}]}]], "Input",
 CellChangeTimes->{{3.733598453022933*^9, 3.733598517270309*^9}, {
  3.733601056518838*^9, 3.733601056719944*^9}, {3.7336023909422503`*^9, 
  3.733602392897993*^9}, {3.7336024920143833`*^9, 3.733602528022232*^9}, {
  3.741180658697805*^9, 
  3.7411806624486847`*^9}},ExpressionUUID->"bccd3a46-150a-439a-9dc8-\
55c0a55af905"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["A13", "2"], 
        RowBox[{
         FractionBox["A12", "2"], "+", 
         FractionBox["B12", "2"]}]},
       {
        FractionBox["A13", "2"], 
        RowBox[{"A23", "+", "B12"}], 
        RowBox[{
         FractionBox["A22", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B11", "2"]}]},
       {
        RowBox[{
         FractionBox["A12", "2"], "+", 
         FractionBox["B12", "2"]}], 
        RowBox[{
         FractionBox["A22", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B11", "2"]}], "A32"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"A13", 
        RowBox[{"A12", "+", 
         FractionBox["A23", "2"]}], 
        RowBox[{
         FractionBox["A11", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B22", "2"]}]},
       {
        RowBox[{"A12", "+", 
         FractionBox["A23", "2"]}], 
        RowBox[{
         RowBox[{"2", " ", "A22"}], "+", "B22"}], 
        RowBox[{
         FractionBox["A21", "2"], "+", "A32", "+", 
         FractionBox["B21", "2"]}]},
       {
        RowBox[{
         FractionBox["A11", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B22", "2"]}], 
        RowBox[{
         FractionBox["A21", "2"], "+", "A32", "+", 
         FractionBox["B21", "2"]}], "A31"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     0, Rational[1, 2] $CellContext`A13, Rational[1, 2] $CellContext`A12 + 
      Rational[1, 2] $CellContext`B12}, {
     Rational[1, 2] $CellContext`A13, $CellContext`A23 + $CellContext`B12, 
      Rational[1, 2] $CellContext`A22 + Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B11}, {
     Rational[1, 2] $CellContext`A12 + Rational[1, 2] $CellContext`B12, 
      Rational[1, 2] $CellContext`A22 + Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B11, $CellContext`A32}}], 
   MatrixForm[{{$CellContext`A13, $CellContext`A12 + 
      Rational[1, 2] $CellContext`A23, Rational[1, 2] $CellContext`A11 + 
      Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B22}, {$CellContext`A12 + 
      Rational[1, 2] $CellContext`A23, 2 $CellContext`A22 + $CellContext`B22, 
      Rational[1, 2] $CellContext`A21 + $CellContext`A32 + 
      Rational[1, 2] $CellContext`B21}, {
     Rational[1, 2] $CellContext`A11 + Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B22, 
      Rational[1, 2] $CellContext`A21 + $CellContext`A32 + 
      Rational[1, 2] $CellContext`B21, $CellContext`A31}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7335984675010757`*^9, 3.733598497148162*^9}, 
   3.733602528811473*^9, 
   3.741180663255301*^9},ExpressionUUID->"49da576a-383a-4dfe-bcbc-\
cb87c674ab86"],

Cell[BoxData[
 TemplateBox[{
  "Solve","svars",
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"",2,
   318,20,15758455304263670798,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.733602528845564*^9, 
  3.741180663301536*^9},ExpressionUUID->"b45bf57d-f5c2-45a7-a757-\
0febf304058b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A12", "\[Rule]", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "X13"}], "-", "X22", "+", 
        RowBox[{"2", " ", "Y12"}]}], ")"}]}]}], ",", 
    RowBox[{"A13", "\[Rule]", "Y11"}], ",", 
    RowBox[{"A23", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["2", "3"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "X13"}], "-", "X22", "-", "Y12"}], ")"}]}]}], ",", 
    RowBox[{"A31", "\[Rule]", "Y33"}], ",", 
    RowBox[{"A32", "\[Rule]", "X33"}], ",", 
    RowBox[{"A33", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "A11"}], "+", 
      RowBox[{"2", " ", "A22"}], "+", 
      RowBox[{"2", " ", "Y13"}], "-", "Y22"}]}], ",", 
    RowBox[{"B11", "\[Rule]", 
     RowBox[{"A11", "-", 
      RowBox[{"3", " ", "A22"}], "+", 
      RowBox[{"2", " ", "X23"}], "-", 
      RowBox[{"2", " ", "Y13"}], "+", "Y22"}]}], ",", 
    RowBox[{"B12", "\[Rule]", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", "X13"}], "+", "X22", "-", 
        RowBox[{"2", " ", "Y12"}]}], ")"}]}]}], ",", 
    RowBox[{"B21", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "A21"}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"X33", "-", "Y23"}], ")"}]}]}]}], ",", 
    RowBox[{"B22", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "A22"}], "+", "Y22"}]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.733602528847371*^9, 
  3.741180663303364*^9},ExpressionUUID->"d2047682-afb7-402d-bc78-\
e71f9d618511"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Calculation", " ", "for", " ", "orbit", " ", "O1212"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
      "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
      "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
      "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O1212", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", " ", "+", " ", 
          RowBox[{"A11", "*", "x"}]}], " ", ",", 
         RowBox[{"A12", "*", "x"}], ",", 
         RowBox[{"A13", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A21", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A22", "*", "x"}]}], ",", 
         RowBox[{"A23", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A31", "*", "x"}], ",", 
         RowBox[{"A32", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A33", "*", "x"}]}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B11", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", 
     RowBox[{"B12", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", 
     RowBox[{"B21", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B22", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A2", "-", "A"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B2", "-", "B"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"X12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "2"}], "]"}]}], " ", "&&", 
      RowBox[{"X13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "3"}], "]"}]}], "  ", "&&", 
      " ", 
      RowBox[{"X23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X33", " ", "==", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "3", ",", " ", "3"}], "]"}]}], "&&", " ", 
      RowBox[{"Y11", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "1"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "2"}], "]"}]}], "&&", 
      RowBox[{"Y13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "2"}], "]"}]}], "&&", " ", 
      RowBox[{"Y23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y33", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "3", ",", " ", "3"}], "]"}]}]}], " ", ",", 
     " ", 
     RowBox[{"{", 
      RowBox[{
      "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
       "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
       "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
       "B22"}], "}"}]}], "]"}], " "}]}]], "Input",
 CellChangeTimes->{{3.733598601509799*^9, 3.7335986412215843`*^9}, {
  3.7336010662072144`*^9, 3.733601066520276*^9}, {3.733602571516994*^9, 
  3.733602604238145*^9}, {3.7411806674178257`*^9, 
  3.741180673752501*^9}},ExpressionUUID->"7e0c2dab-9b15-4937-b5ec-\
2ce5f2997e63"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["B12", "2"], "A13"},
       {
        FractionBox["B12", "2"], "0", "A23"},
       {"A13", "A23", 
        RowBox[{
         RowBox[{"2", " ", "A33"}], "+", "B11"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"A12", 
        RowBox[{
         FractionBox["A11", "2"], "+", 
         FractionBox["A22", "2"], "+", 
         FractionBox["B22", "2"]}], 
        FractionBox["A32", "2"]},
       {
        RowBox[{
         FractionBox["A11", "2"], "+", 
         FractionBox["A22", "2"], "+", 
         FractionBox["B22", "2"]}], "A21", 
        FractionBox["A31", "2"]},
       {
        FractionBox["A32", "2"], 
        FractionBox["A31", "2"], "B21"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, Rational[1, 2] $CellContext`B12, $CellContext`A13}, {
     Rational[1, 2] $CellContext`B12, 
      0, $CellContext`A23}, {$CellContext`A13, $CellContext`A23, 
      2 $CellContext`A33 + $CellContext`B11}}], 
   MatrixForm[{{$CellContext`A12, Rational[1, 2] $CellContext`A11 + 
      Rational[1, 2] $CellContext`A22 + Rational[1, 2] $CellContext`B22, 
      Rational[1, 2] $CellContext`A32}, {
     Rational[1, 2] $CellContext`A11 + Rational[1, 2] $CellContext`A22 + 
      Rational[1, 2] $CellContext`B22, $CellContext`A21, 
      Rational[1, 2] $CellContext`A31}, {
     Rational[1, 2] $CellContext`A32, 
      Rational[1, 2] $CellContext`A31, $CellContext`B21}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7335986417915916`*^9, 3.733602605791493*^9, 
  3.733602642562557*^9, 
  3.741180675924737*^9},ExpressionUUID->"86d49f3a-2515-4289-9f7e-\
d1082aa35fa2"],

Cell[BoxData[
 TemplateBox[{
  "Solve","svars",
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"",2,
   337,21,15758455304263670798,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.733602605830406*^9, 3.7336026425955353`*^9, 
  3.741180675960791*^9},ExpressionUUID->"61327791-4caf-47e3-8cd4-\
082f395a0682"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A12", "\[Rule]", "Y11"}], ",", 
    RowBox[{"A13", "\[Rule]", "X13"}], ",", 
    RowBox[{"A21", "\[Rule]", "Y22"}], ",", 
    RowBox[{"A23", "\[Rule]", "X23"}], ",", 
    RowBox[{"A31", "\[Rule]", 
     RowBox[{"2", " ", "Y23"}]}], ",", 
    RowBox[{"A32", "\[Rule]", 
     RowBox[{"2", " ", "Y13"}]}], ",", 
    RowBox[{"B11", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "A33"}], "+", "X33"}]}], ",", 
    RowBox[{"B12", "\[Rule]", 
     RowBox[{"2", " ", "X12"}]}], ",", 
    RowBox[{"B21", "\[Rule]", "Y33"}], ",", 
    RowBox[{"B22", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "A11"}], "-", "A22", "+", 
      RowBox[{"2", " ", "Y12"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.733602605831934*^9, 3.733602642596875*^9, 
  3.74118067596179*^9},ExpressionUUID->"68e1c8b8-d8cf-4983-a1d9-ec5018cdd1e5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Calculation", " ", "for", " ", "orbit", " ", "O22"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
      "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
      "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
      "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O22", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", " ", "+", " ", 
          RowBox[{"A11", "*", "x"}]}], " ", ",", 
         RowBox[{"A12", "*", "x"}], ",", 
         RowBox[{"A13", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A21", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A22", "*", "x"}]}], ",", 
         RowBox[{"A23", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A31", "*", "x"}], ",", 
         RowBox[{"A32", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A33", "*", "x"}]}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B11", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", 
     RowBox[{"B12", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", 
     RowBox[{"B21", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B22", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A2", "-", "A"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B2", "-", "B"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"X11", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "1"}], "]"}]}], " ", "&&", 
      RowBox[{"X13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "3"}], "]"}]}], "  ", "&&", 
      " ", 
      RowBox[{"X23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X33", " ", "==", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "3", ",", " ", "3"}], "]"}]}], "&&", " ", 
      RowBox[{"Y11", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "1"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "2"}], "]"}]}], "&&", 
      RowBox[{"Y13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "2"}], "]"}]}], "&&", " ", 
      RowBox[{"Y23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y33", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "3", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "ell"}], " ", "*", " ", "X11"}], " ", "\[Equal]", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", "2"}], "]"}]}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
      "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
       "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
       "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
       "B22"}], "}"}]}], "]"}], " "}]}]], "Input",
 CellChangeTimes->{{3.733598714661007*^9, 3.733598732820917*^9}, {
  3.733601070287051*^9, 3.7336010705201893`*^9}, {3.733602752499928*^9, 
  3.733602805148654*^9}, {3.741180685449853*^9, 
  3.741180689136571*^9}},ExpressionUUID->"9614a7be-dd40-4ce5-b63f-\
e00a9c7dac6b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"B12", "0", "A13"},
       {"0", 
        RowBox[{
         RowBox[{"-", "B12"}], " ", "ell"}], "A23"},
       {"A13", "A23", 
        RowBox[{
         RowBox[{"2", " ", "A33"}], "+", "B11"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"2", " ", "A11"}], "+", "B22"}], 
        RowBox[{"A21", "-", 
         RowBox[{"A12", " ", "ell"}]}], "A31"},
       {
        RowBox[{"A21", "-", 
         RowBox[{"A12", " ", "ell"}]}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "A22", " ", "ell"}], "-", 
         RowBox[{"B22", " ", "ell"}]}], 
        RowBox[{
         RowBox[{"-", "A32"}], " ", "ell"}]},
       {"A31", 
        RowBox[{
         RowBox[{"-", "A32"}], " ", "ell"}], "B21"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`B12, 0, $CellContext`A13}, {
     0, -$CellContext`B12 $CellContext`ell, $CellContext`A23}, \
{$CellContext`A13, $CellContext`A23, 2 $CellContext`A33 + $CellContext`B11}}], 
   MatrixForm[{{
     2 $CellContext`A11 + $CellContext`B22, $CellContext`A21 - \
$CellContext`A12 $CellContext`ell, $CellContext`A31}, {$CellContext`A21 - \
$CellContext`A12 $CellContext`ell, (-2) $CellContext`A22 $CellContext`ell - \
$CellContext`B22 $CellContext`ell, -$CellContext`A32 $CellContext`ell}, \
{$CellContext`A31, -$CellContext`A32 $CellContext`ell, $CellContext`B21}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733598738426639*^9, 3.733602806699388*^9, 
  3.7411806898812857`*^9},ExpressionUUID->"6b26ad0c-2184-48b4-a2aa-\
a05be0dc600c"],

Cell[BoxData[
 TemplateBox[{
  "Solve","svars",
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"",2,
   356,22,15758455304263670798,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.733602806736155*^9, 
  3.74118068991181*^9},ExpressionUUID->"c8f3e4c4-395c-4761-8e83-26f6ad921a68"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A11", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["B22", "2"]}], "+", 
      FractionBox["Y11", "2"]}]}], ",", 
    RowBox[{"A13", "\[Rule]", "X13"}], ",", 
    RowBox[{"A21", "\[Rule]", 
     RowBox[{
      RowBox[{"A12", " ", "ell"}], "+", "Y12"}]}], ",", 
    RowBox[{"A22", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["B22", "2"]}], "-", 
      FractionBox["Y22", 
       RowBox[{"2", " ", "ell"}]]}]}], ",", 
    RowBox[{"A23", "\[Rule]", "X23"}], ",", 
    RowBox[{"A31", "\[Rule]", "Y13"}], ",", 
    RowBox[{"A32", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["Y23", "ell"]}]}], ",", 
    RowBox[{"B11", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "A33"}], "+", "X33"}]}], ",", 
    RowBox[{"B12", "\[Rule]", "X11"}], ",", 
    RowBox[{"B21", "\[Rule]", "Y33"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.733602806737965*^9, 
  3.741180689912745*^9},ExpressionUUID->"31025b37-d5d8-404d-b9f6-\
c3598e8a8124"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Calculation", " ", "for", " ", "orbit", " ", "O1211"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
      "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
      "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
      "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O1211", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", " ", "+", " ", 
          RowBox[{"A11", "*", "x"}]}], " ", ",", 
         RowBox[{"A12", "*", "x"}], ",", 
         RowBox[{"A13", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A21", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A22", "*", "x"}]}], ",", 
         RowBox[{"A23", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A31", "*", "x"}], ",", 
         RowBox[{"A32", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A33", "*", "x"}]}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B11", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", 
     RowBox[{"B12", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", 
     RowBox[{"B21", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B22", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A2", "-", "A"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B2", "-", "B"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"X12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "2"}], "]"}]}], " ", "&&", 
      RowBox[{"X13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", " ", "2"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X33", " ", "==", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "3", ",", " ", "3"}], "]"}]}], "&&", " ", 
      RowBox[{"Y11", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "1"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "2"}], "]"}]}], "&&", 
      RowBox[{"Y13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "2"}], "]"}]}], "&&", " ", 
      RowBox[{"Y23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y33", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "3", ",", " ", "3"}], "]"}]}]}], " ", ",", 
     " ", 
     RowBox[{"{", 
      RowBox[{
      "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
       "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
       "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
       "B22"}], "}"}]}], "]"}], " "}]}]], "Input",
 CellChangeTimes->{{3.73359884473216*^9, 3.733598883443809*^9}, {
  3.73360107518314*^9, 3.733601075496296*^9}, {3.733602817139627*^9, 
  3.733602864484489*^9}, {3.741180697137701*^9, 
  3.741180702936483*^9}},ExpressionUUID->"6c842502-c824-41cb-a4dd-\
7b1c214d53b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "A12", 
        RowBox[{
         RowBox[{"-", "A13"}], "+", 
         FractionBox["B12", "2"]}]},
       {"A12", 
        RowBox[{
         RowBox[{"2", " ", "A22"}], "+", "B11"}], 
        RowBox[{
         RowBox[{"-", "A23"}], "+", "A32"}]},
       {
        RowBox[{
         RowBox[{"-", "A13"}], "+", 
         FractionBox["B12", "2"]}], 
        RowBox[{
         RowBox[{"-", "A23"}], "+", "A32"}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "A33"}], "-", "B11"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"A13", 
        FractionBox["A23", "2"], 
        RowBox[{
         FractionBox["A11", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B22", "2"]}]},
       {
        FractionBox["A23", "2"], "B21", 
        FractionBox["A21", "2"]},
       {
        RowBox[{
         FractionBox["A11", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B22", "2"]}], 
        FractionBox["A21", "2"], 
        RowBox[{"A31", "-", "B21"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     0, $CellContext`A12, -$CellContext`A13 + 
      Rational[1, 2] $CellContext`B12}, {$CellContext`A12, 
      2 $CellContext`A22 + $CellContext`B11, -$CellContext`A23 + \
$CellContext`A32}, {-$CellContext`A13 + 
      Rational[1, 
         2] $CellContext`B12, -$CellContext`A23 + $CellContext`A32, (-2) \
$CellContext`A33 - $CellContext`B11}}], 
   MatrixForm[{{$CellContext`A13, Rational[1, 2] $CellContext`A23, 
      Rational[1, 2] $CellContext`A11 + Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B22}, {
     Rational[1, 2] $CellContext`A23, $CellContext`B21, 
      Rational[1, 2] $CellContext`A21}, {
     Rational[1, 2] $CellContext`A11 + Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B22, 
      Rational[1, 2] $CellContext`A21, $CellContext`A31 - $CellContext`B21}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733598884252315*^9, 3.7336028652487917`*^9, 
  3.7411807036192493`*^9},ExpressionUUID->"7b680a2c-0942-4bd5-bde4-\
220b9df11fd2"],

Cell[BoxData[
 TemplateBox[{
  "Solve","svars",
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"",2,
   375,23,15758455304263670798,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.733602865278802*^9, 
  3.741180703657997*^9},ExpressionUUID->"64bcd231-d10f-4ddd-8695-\
5d5a02569aeb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A12", "\[Rule]", "X12"}], ",", 
    RowBox[{"A13", "\[Rule]", "Y11"}], ",", 
    RowBox[{"A21", "\[Rule]", 
     RowBox[{"2", " ", "Y23"}]}], ",", 
    RowBox[{"A23", "\[Rule]", 
     RowBox[{"2", " ", "Y12"}]}], ",", 
    RowBox[{"A31", "\[Rule]", 
     RowBox[{"Y22", "+", "Y33"}]}], ",", 
    RowBox[{"A32", "\[Rule]", 
     RowBox[{"X23", "+", 
      RowBox[{"2", " ", "Y12"}]}]}], ",", 
    RowBox[{"A33", "\[Rule]", 
     RowBox[{"A22", "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "X22"}], "-", "X33"}], ")"}]}]}]}], ",", 
    RowBox[{"B11", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "A22"}], "+", "X22"}]}], ",", 
    RowBox[{"B12", "\[Rule]", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"X13", "+", "Y11"}], ")"}]}]}], ",", 
    RowBox[{"B21", "\[Rule]", "Y22"}], ",", 
    RowBox[{"B22", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "A11"}], "-", "A22", "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"X22", "+", "X33", "+", 
         RowBox[{"4", " ", "Y13"}]}], ")"}]}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.733602865280455*^9, 
  3.741180703659526*^9},ExpressionUUID->"58250219-bcc1-4a50-a651-\
276b581f2acb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Calculation", " ", "for", " ", "orbit", " ", "O122"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
      "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
      "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
      "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O122", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", "ell"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", " ", "+", " ", 
          RowBox[{"A11", "*", "x"}]}], " ", ",", 
         RowBox[{"A12", "*", "x"}], ",", 
         RowBox[{"A13", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A21", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A22", "*", "x"}]}], ",", 
         RowBox[{"A23", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A31", "*", "x"}], ",", 
         RowBox[{"A32", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A33", "*", "x"}]}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B11", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", 
     RowBox[{"B12", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", 
     RowBox[{"B21", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B22", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A2", "-", "A"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B2", "-", "B"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"X12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "2"}], "]"}]}], " ", "&&", 
      RowBox[{"X13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", " ", "2"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X33", " ", "==", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "3", ",", " ", "3"}], "]"}]}], "&&", " ", 
      RowBox[{"Y11", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "1"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "2"}], "]"}]}], "&&", 
      RowBox[{"Y13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "2"}], "]"}]}], "&&", " ", 
      RowBox[{"Y23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y33", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "3", ",", " ", "3"}], "]"}]}]}], " ", ",", 
     " ", 
     RowBox[{"{", 
      RowBox[{
      "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
       "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
       "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
       "B22"}], "}"}]}], "]"}], " "}]}]], "Input",
 CellChangeTimes->{{3.733599217177844*^9, 3.733599232073876*^9}, {
  3.733601080239113*^9, 3.733601080448103*^9}, {3.733602877555202*^9, 
  3.7336028783350782`*^9}, {3.741180709065653*^9, 
  3.7411807143363037`*^9}},ExpressionUUID->"36d32c8c-75ce-474c-87a4-\
bb443c3b2458"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "A12", 
        RowBox[{
         FractionBox["B12", "2"], "-", 
         RowBox[{"A13", " ", "ell"}]}]},
       {"A12", 
        RowBox[{
         RowBox[{"2", " ", "A22"}], "+", "B11"}], 
        RowBox[{"A32", "-", 
         RowBox[{"A23", " ", "ell"}]}]},
       {
        RowBox[{
         FractionBox["B12", "2"], "-", 
         RowBox[{"A13", " ", "ell"}]}], 
        RowBox[{"A32", "-", 
         RowBox[{"A23", " ", "ell"}]}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "A33", " ", "ell"}], "-", 
         RowBox[{"B11", " ", "ell"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"A13", 
        FractionBox["A23", "2"], 
        RowBox[{
         FractionBox["A11", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B22", "2"]}]},
       {
        FractionBox["A23", "2"], "B21", 
        FractionBox["A21", "2"]},
       {
        RowBox[{
         FractionBox["A11", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B22", "2"]}], 
        FractionBox["A21", "2"], 
        RowBox[{"A31", "-", 
         RowBox[{"B21", " ", "ell"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     0, $CellContext`A12, 
      Rational[1, 
         2] $CellContext`B12 - $CellContext`A13 $CellContext`ell}, \
{$CellContext`A12, 
      2 $CellContext`A22 + $CellContext`B11, $CellContext`A32 - \
$CellContext`A23 $CellContext`ell}, {
     Rational[1, 
         2] $CellContext`B12 - $CellContext`A13 $CellContext`ell, \
$CellContext`A32 - $CellContext`A23 $CellContext`ell, (-2) $CellContext`A33 \
$CellContext`ell - $CellContext`B11 $CellContext`ell}}], 
   MatrixForm[{{$CellContext`A13, Rational[1, 2] $CellContext`A23, 
      Rational[1, 2] $CellContext`A11 + Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B22}, {
     Rational[1, 2] $CellContext`A23, $CellContext`B21, 
      Rational[1, 2] $CellContext`A21}, {
     Rational[1, 2] $CellContext`A11 + Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B22, 
      Rational[1, 
        2] $CellContext`A21, $CellContext`A31 - $CellContext`B21 \
$CellContext`ell}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733599242139967*^9, 3.733602879101069*^9, 
  3.741180715307225*^9},ExpressionUUID->"a0735730-b5ea-4234-a703-\
49aa8efb7e05"],

Cell[BoxData[
 TemplateBox[{
  "Solve","svars",
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"",2,
   394,24,15758455304263670798,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.733602879131867*^9, 
  3.7411807153293858`*^9},ExpressionUUID->"1ba13ce7-f4b4-4233-a3ea-\
af97c81369ea"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A12", "\[Rule]", "X12"}], ",", 
    RowBox[{"A13", "\[Rule]", "Y11"}], ",", 
    RowBox[{"A21", "\[Rule]", 
     RowBox[{"2", " ", "Y23"}]}], ",", 
    RowBox[{"A22", "\[Rule]", 
     RowBox[{"A33", "-", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "ell"}], " ", "X22"}], "-", "X33"}], 
       RowBox[{"2", " ", "ell"}]]}]}], ",", 
    RowBox[{"A23", "\[Rule]", 
     RowBox[{"2", " ", "Y12"}]}], ",", 
    RowBox[{"A31", "\[Rule]", 
     RowBox[{
      RowBox[{"ell", " ", "Y22"}], "+", "Y33"}]}], ",", 
    RowBox[{"A32", "\[Rule]", 
     RowBox[{"X23", "+", 
      RowBox[{"2", " ", "ell", " ", "Y12"}]}]}], ",", 
    RowBox[{"B11", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "A33"}], "-", 
      FractionBox["X33", "ell"]}]}], ",", 
    RowBox[{"B12", "\[Rule]", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"X13", "+", 
        RowBox[{"ell", " ", "Y11"}]}], ")"}]}]}], ",", 
    RowBox[{"B21", "\[Rule]", "Y22"}], ",", 
    RowBox[{"B22", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "A11"}], "-", "A33", "+", 
      RowBox[{"2", " ", "Y13"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.733602879149218*^9, 
  3.741180715338086*^9},ExpressionUUID->"a1bfb886-404a-4706-b0bf-\
dc4acf957d12"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Calculation", " ", "for", " ", "orbit", " ", "O1111"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
      "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
      "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
      "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O1111", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], ",", "0"}], "}"}]}], "}"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], ",", "0"}], "}"}]}], "}"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", " ", "+", " ", 
          RowBox[{"A11", "*", "x"}]}], " ", ",", 
         RowBox[{"A12", "*", "x"}], ",", 
         RowBox[{"A13", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A21", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A22", "*", "x"}]}], ",", 
         RowBox[{"A23", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A31", "*", "x"}], ",", 
         RowBox[{"A32", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A33", "*", "x"}]}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B11", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", 
     RowBox[{"B12", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", 
     RowBox[{"B21", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B22", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A2", "-", "A"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B2", "-", "B"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"X11", " ", "==", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "1"}], "]"}]}], " ", "&&", 
      RowBox[{"X12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "2"}], "]"}]}], " ", "&&", 
      RowBox[{"X13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", " ", "2"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X33", " ", "==", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "3", ",", " ", "3"}], "]"}]}], "&&", " ", 
      RowBox[{"Y11", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "1"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "2"}], "]"}]}], "&&", 
      RowBox[{"Y13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "2"}], "]"}]}], "&&", " ", 
      RowBox[{"Y23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y33", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "3", ",", " ", "3"}], "]"}]}]}], " ", ",", 
     " ", 
     RowBox[{"{", 
      RowBox[{
      "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
       "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
       "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
       "B22"}], "}"}]}], "]"}], " "}]}]], "Input",
 CellChangeTimes->{{3.741456033360549*^9, 3.741456174111912*^9}, {
  3.741456461343508*^9, 
  3.741456462886451*^9}},ExpressionUUID->"c636cea5-b195-49cf-a1d3-\
e6a240c43a36"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"A13", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["A13", "2"]}], "+", 
         FractionBox["A23", "2"], "+", 
         FractionBox["B12", "2"]}], 
        RowBox[{
         FractionBox["A11", "2"], "-", 
         FractionBox["A12", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B11", "2"]}]},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox["A13", "2"]}], "+", 
         FractionBox["A23", "2"], "+", 
         FractionBox["B12", "2"]}], 
        RowBox[{"-", "A23"}], 
        RowBox[{
         FractionBox["A21", "2"], "-", 
         FractionBox["A22", "2"], "-", 
         FractionBox["A33", "2"], "-", 
         FractionBox["B11", "2"], "-", 
         FractionBox["B12", "2"]}]},
       {
        RowBox[{
         FractionBox["A11", "2"], "-", 
         FractionBox["A12", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B11", "2"]}], 
        RowBox[{
         FractionBox["A21", "2"], "-", 
         FractionBox["A22", "2"], "-", 
         FractionBox["A33", "2"], "-", 
         FractionBox["B11", "2"], "-", 
         FractionBox["B12", "2"]}], 
        RowBox[{"A31", "-", "A32"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"A12", 
        RowBox[{
         FractionBox["A11", "2"], "-", 
         FractionBox["A13", "2"], "+", 
         FractionBox["A22", "2"], "+", 
         FractionBox["B22", "2"]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox["A12", "2"]}], "+", 
         FractionBox["A32", "2"], "+", 
         FractionBox["B21", "2"]}]},
       {
        RowBox[{
         FractionBox["A11", "2"], "-", 
         FractionBox["A13", "2"], "+", 
         FractionBox["A22", "2"], "+", 
         FractionBox["B22", "2"]}], 
        RowBox[{"A21", "-", "A23"}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox["A22", "2"]}], "+", 
         FractionBox["A31", "2"], "-", 
         FractionBox["A33", "2"], "-", 
         FractionBox["B21", "2"], "-", 
         FractionBox["B22", "2"]}]},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox["A12", "2"]}], "+", 
         FractionBox["A32", "2"], "+", 
         FractionBox["B21", "2"]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox["A22", "2"]}], "+", 
         FractionBox["A31", "2"], "-", 
         FractionBox["A33", "2"], "-", 
         FractionBox["B21", "2"], "-", 
         FractionBox["B22", "2"]}], 
        RowBox[{"-", "A32"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`A13, Rational[-1, 2] $CellContext`A13 + 
      Rational[1, 2] $CellContext`A23 + Rational[1, 2] $CellContext`B12, 
      Rational[1, 2] $CellContext`A11 + Rational[-1, 2] $CellContext`A12 + 
      Rational[1, 2] $CellContext`A33 + Rational[1, 2] $CellContext`B11}, {
     Rational[-1, 2] $CellContext`A13 + Rational[1, 2] $CellContext`A23 + 
      Rational[1, 2] $CellContext`B12, -$CellContext`A23, 
      Rational[1, 2] $CellContext`A21 + Rational[-1, 2] $CellContext`A22 + 
      Rational[-1, 2] $CellContext`A33 + Rational[-1, 2] $CellContext`B11 + 
      Rational[-1, 2] $CellContext`B12}, {
     Rational[1, 2] $CellContext`A11 + Rational[-1, 2] $CellContext`A12 + 
      Rational[1, 2] $CellContext`A33 + Rational[1, 2] $CellContext`B11, 
      Rational[1, 2] $CellContext`A21 + Rational[-1, 2] $CellContext`A22 + 
      Rational[-1, 2] $CellContext`A33 + Rational[-1, 2] $CellContext`B11 + 
      Rational[-1, 
         2] $CellContext`B12, $CellContext`A31 - $CellContext`A32}}], 
   MatrixForm[{{$CellContext`A12, Rational[1, 2] $CellContext`A11 + 
      Rational[-1, 2] $CellContext`A13 + Rational[1, 2] $CellContext`A22 + 
      Rational[1, 2] $CellContext`B22, Rational[-1, 2] $CellContext`A12 + 
      Rational[1, 2] $CellContext`A32 + Rational[1, 2] $CellContext`B21}, {
     Rational[1, 2] $CellContext`A11 + Rational[-1, 2] $CellContext`A13 + 
      Rational[1, 2] $CellContext`A22 + 
      Rational[1, 2] $CellContext`B22, $CellContext`A21 - $CellContext`A23, 
      Rational[-1, 2] $CellContext`A22 + Rational[1, 2] $CellContext`A31 + 
      Rational[-1, 2] $CellContext`A33 + Rational[-1, 2] $CellContext`B21 + 
      Rational[-1, 2] $CellContext`B22}, {
     Rational[-1, 2] $CellContext`A12 + Rational[1, 2] $CellContext`A32 + 
      Rational[1, 2] $CellContext`B21, Rational[-1, 2] $CellContext`A22 + 
      Rational[1, 2] $CellContext`A31 + Rational[-1, 2] $CellContext`A33 + 
      Rational[-1, 2] $CellContext`B21 + 
      Rational[-1, 2] $CellContext`B22, -$CellContext`A32}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7414561835990133`*^9},ExpressionUUID->"d7f593cd-d7ee-48f4-a639-\
753d41939a04"],

Cell[BoxData[
 TemplateBox[{
  "Solve","svars",
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"",2,
   19,1,15760267409170846619,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.741456183632495*^9},ExpressionUUID->"9876ef69-35f4-44ac-82aa-\
a9f1a568189b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A12", "\[Rule]", "Y11"}], ",", 
    RowBox[{"A13", "\[Rule]", "X11"}], ",", 
    RowBox[{"A21", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "X22"}], "+", "Y22"}]}], ",", 
    RowBox[{"A22", "\[Rule]", 
     RowBox[{"A11", "-", "X11", "-", 
      RowBox[{"2", " ", "X12"}], "-", 
      RowBox[{"2", " ", "X13"}], "-", 
      RowBox[{"2", " ", "X22"}], "-", 
      RowBox[{"2", " ", "X23"}], "-", "Y11", "+", "Y22"}]}], ",", 
    RowBox[{"A23", "\[Rule]", 
     RowBox[{"-", "X22"}]}], ",", 
    RowBox[{"A31", "\[Rule]", 
     RowBox[{"X33", "-", "Y33"}]}], ",", 
    RowBox[{"A32", "\[Rule]", 
     RowBox[{"-", "Y33"}]}], ",", 
    RowBox[{"A33", "\[Rule]", 
     RowBox[{"A11", "-", "X11", "+", "X33", "-", "Y11", "-", 
      RowBox[{"2", " ", "Y12"}], "-", 
      RowBox[{"2", " ", "Y13"}], "-", 
      RowBox[{"2", " ", "Y23"}], "-", 
      RowBox[{"2", " ", "Y33"}]}]}], ",", 
    RowBox[{"B11", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "A11"}], "+", "X11", "+", 
      RowBox[{"2", " ", "X13"}], "-", "X33", "+", 
      RowBox[{"2", " ", "Y11"}], "+", 
      RowBox[{"2", " ", "Y12"}], "+", 
      RowBox[{"2", " ", "Y13"}], "+", 
      RowBox[{"2", " ", "Y23"}], "+", 
      RowBox[{"2", " ", "Y33"}]}]}], ",", 
    RowBox[{"B12", "\[Rule]", 
     RowBox[{"X11", "+", 
      RowBox[{"2", " ", "X12"}], "+", "X22"}]}], ",", 
    RowBox[{"B21", "\[Rule]", 
     RowBox[{"Y11", "+", 
      RowBox[{"2", " ", "Y13"}], "+", "Y33"}]}], ",", 
    RowBox[{"B22", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "A11"}], "+", 
      RowBox[{"2", " ", "X11"}], "+", 
      RowBox[{"2", " ", "X12"}], "+", 
      RowBox[{"2", " ", "X13"}], "+", 
      RowBox[{"2", " ", "X22"}], "+", 
      RowBox[{"2", " ", "X23"}], "+", "Y11", "+", 
      RowBox[{"2", " ", "Y12"}], "-", "Y22"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7414561836436977`*^9},ExpressionUUID->"65b3d361-0583-478a-abe5-\
7acb4bc908d1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Calculation", " ", "for", " ", "orbit", " ", "O112"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
      "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
      "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
      "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O112", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", "ell"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", " ", "+", " ", 
          RowBox[{"A11", "*", "x"}]}], " ", ",", 
         RowBox[{"A12", "*", "x"}], ",", 
         RowBox[{"A13", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A21", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A22", "*", "x"}]}], ",", 
         RowBox[{"A23", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A31", "*", "x"}], ",", 
         RowBox[{"A32", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A33", "*", "x"}]}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B11", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", 
     RowBox[{"B12", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", 
     RowBox[{"B21", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B22", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A2", "-", "A"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B2", "-", "B"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"X11", " ", "==", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "1"}], "]"}]}], " ", "&&", 
      RowBox[{"X12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "2"}], "]"}]}], " ", "&&", 
      RowBox[{"X13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", " ", "2"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X33", " ", "==", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "3", ",", " ", "3"}], "]"}]}], "&&", " ", 
      RowBox[{"Y11", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "1"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "2"}], "]"}]}], "&&", 
      RowBox[{"Y13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "2"}], "]"}]}], "&&", " ", 
      RowBox[{"Y23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y33", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "3", ",", " ", "3"}], "]"}]}]}], " ", ",", 
     " ", 
     RowBox[{"{", 
      RowBox[{
      "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
       "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
       "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
       "B22"}], "}"}]}], "]"}], " "}]}]], "Input",
 CellChangeTimes->{{3.741456230183126*^9, 3.741456344478609*^9}, {
  3.741456453383874*^9, 
  3.741456453566463*^9}},ExpressionUUID->"98586a44-283e-442f-a4b2-\
1beac68e88a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"B12", 
        FractionBox["A13", "2"], 
        FractionBox["A12", "2"]},
       {
        FractionBox["A13", "2"], 
        RowBox[{"A23", "-", "B12"}], 
        RowBox[{
         FractionBox["A22", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B11", "2"]}]},
       {
        FractionBox["A12", "2"], 
        RowBox[{
         FractionBox["A22", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B11", "2"]}], 
        RowBox[{"A32", "-", 
         RowBox[{"B12", " ", "ell"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"2", " ", "A11"}], "+", "B22"}], 
        RowBox[{
         RowBox[{"-", "A12"}], "+", "A21"}], 
        RowBox[{"A31", "-", 
         RowBox[{"A13", " ", "ell"}]}]},
       {
        RowBox[{
         RowBox[{"-", "A12"}], "+", "A21"}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "A22"}], "-", "B22"}], 
        RowBox[{
         RowBox[{"-", "A32"}], "+", 
         FractionBox["B21", "2"], "-", 
         RowBox[{"A23", " ", "ell"}]}]},
       {
        RowBox[{"A31", "-", 
         RowBox[{"A13", " ", "ell"}]}], 
        RowBox[{
         RowBox[{"-", "A32"}], "+", 
         FractionBox["B21", "2"], "-", 
         RowBox[{"A23", " ", "ell"}]}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "A33", " ", "ell"}], "-", 
         RowBox[{"B22", " ", "ell"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`B12, Rational[1, 2] $CellContext`A13, 
      Rational[1, 2] $CellContext`A12}, {
     Rational[1, 2] $CellContext`A13, $CellContext`A23 - $CellContext`B12, 
      Rational[1, 2] $CellContext`A22 + Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B11}, {
     Rational[1, 2] $CellContext`A12, Rational[1, 2] $CellContext`A22 + 
      Rational[1, 2] $CellContext`A33 + 
      Rational[1, 
         2] $CellContext`B11, $CellContext`A32 - $CellContext`B12 \
$CellContext`ell}}], 
   MatrixForm[{{
     2 $CellContext`A11 + $CellContext`B22, -$CellContext`A12 + \
$CellContext`A21, $CellContext`A31 - $CellContext`A13 $CellContext`ell}, \
{-$CellContext`A12 + $CellContext`A21, (-2) $CellContext`A22 - \
$CellContext`B22, -$CellContext`A32 + 
      Rational[1, 
         2] $CellContext`B21 - $CellContext`A23 $CellContext`ell}, \
{$CellContext`A31 - $CellContext`A13 $CellContext`ell, -$CellContext`A32 + 
      Rational[1, 
         2] $CellContext`B21 - $CellContext`A23 $CellContext`ell, (-2) \
$CellContext`A33 $CellContext`ell - $CellContext`B22 $CellContext`ell}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741456345248263*^9},ExpressionUUID->"77794697-2a30-45ab-a0fc-\
ead72a21f106"],

Cell[BoxData[
 TemplateBox[{
  "Solve","svars",
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"",2,
   38,2,15760267409170846619,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.7414563452779083`*^9},ExpressionUUID->"205b2960-e91f-4392-994f-\
b717680229a2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A11", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["B22", "2"]}], "+", 
      FractionBox["Y11", "2"]}]}], ",", 
    RowBox[{"A12", "\[Rule]", 
     RowBox[{"2", " ", "X13"}]}], ",", 
    RowBox[{"A13", "\[Rule]", 
     RowBox[{"2", " ", "X12"}]}], ",", 
    RowBox[{"A21", "\[Rule]", 
     RowBox[{
      RowBox[{"2", " ", "X13"}], "+", "Y12"}]}], ",", 
    RowBox[{"A22", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["B22", "2"]}], "-", 
      FractionBox["Y22", "2"]}]}], ",", 
    RowBox[{"A23", "\[Rule]", 
     RowBox[{"X11", "+", "X22"}]}], ",", 
    RowBox[{"A31", "\[Rule]", 
     RowBox[{
      RowBox[{"2", " ", "ell", " ", "X12"}], "+", "Y13"}]}], ",", 
    RowBox[{"A32", "\[Rule]", 
     RowBox[{
      RowBox[{"ell", " ", "X11"}], "+", "X33"}]}], ",", 
    RowBox[{"A33", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["B22", "2"]}], "-", 
      FractionBox["Y33", 
       RowBox[{"2", " ", "ell"}]]}]}], ",", 
    RowBox[{"B11", "\[Rule]", 
     RowBox[{"B22", "-", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", "ell", " ", "X23"}], "-", 
        RowBox[{"ell", " ", "Y22"}], "-", "Y33"}], 
       RowBox[{"2", " ", "ell"}]]}]}], ",", 
    RowBox[{"B12", "\[Rule]", "X11"}], ",", 
    RowBox[{"B21", "\[Rule]", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "ell", " ", "X11"}], "+", 
        RowBox[{"ell", " ", "X22"}], "+", "X33", "+", "Y23"}], ")"}]}]}]}], 
   "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.741456345292938*^9},ExpressionUUID->"02562f4d-6fb6-496d-99a9-\
8767456e63a8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Calculation", " ", "for", " ", "orbit", " ", "O22"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
      "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
      "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
      "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O22", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", "ell"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", " ", "+", " ", 
          RowBox[{"A11", "*", "x"}]}], " ", ",", 
         RowBox[{"A12", "*", "x"}], ",", 
         RowBox[{"A13", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A21", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A22", "*", "x"}]}], ",", 
         RowBox[{"A23", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A31", "*", "x"}], ",", 
         RowBox[{"A32", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A33", "*", "x"}]}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B11", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", 
     RowBox[{"B12", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", 
     RowBox[{"B21", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B22", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A2", "-", "A"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B2", "-", "B"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"X11", " ", "==", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "1"}], "]"}]}], " ", "&&", 
      RowBox[{"X12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "2"}], "]"}]}], " ", "&&", 
      RowBox[{"X13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", " ", "2"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X33", " ", "==", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "3", ",", " ", "3"}], "]"}]}], "&&", " ", 
      RowBox[{"Y11", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "1"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "2"}], "]"}]}], "&&", 
      RowBox[{"Y13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "2"}], "]"}]}], "&&", " ", 
      RowBox[{"Y23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y33", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "3", ",", " ", "3"}], "]"}]}]}], " ", ",", 
     " ", 
     RowBox[{"{", 
      RowBox[{
      "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
       "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
       "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
       "B22"}], "}"}]}], "]"}], " "}]}]], "Input",
 CellChangeTimes->{{3.741456394814886*^9, 3.741456401326469*^9}, 
   3.741456486096137*^9},ExpressionUUID->"72794dd7-69df-49d0-a7d4-\
6b1182a7f16b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"B12", 
        FractionBox["A13", "2"], 
        FractionBox["A12", "2"]},
       {
        FractionBox["A13", "2"], 
        RowBox[{"A23", "-", 
         RowBox[{"B12", " ", "ell"}]}], 
        RowBox[{
         FractionBox["A22", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B11", "2"]}]},
       {
        FractionBox["A12", "2"], 
        RowBox[{
         FractionBox["A22", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B11", "2"]}], 
        RowBox[{"A32", "-", 
         RowBox[{"B12", " ", "ell"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"2", " ", "A11"}], "+", "B22"}], 
        RowBox[{"A21", "-", 
         RowBox[{"A12", " ", "ell"}]}], 
        RowBox[{"A31", "-", 
         RowBox[{"A13", " ", "ell"}]}]},
       {
        RowBox[{"A21", "-", 
         RowBox[{"A12", " ", "ell"}]}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "A22", " ", "ell"}], "-", 
         RowBox[{"B22", " ", "ell"}]}], 
        RowBox[{
         FractionBox["B21", "2"], "-", 
         RowBox[{"A23", " ", "ell"}], "-", 
         RowBox[{"A32", " ", "ell"}]}]},
       {
        RowBox[{"A31", "-", 
         RowBox[{"A13", " ", "ell"}]}], 
        RowBox[{
         FractionBox["B21", "2"], "-", 
         RowBox[{"A23", " ", "ell"}], "-", 
         RowBox[{"A32", " ", "ell"}]}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "A33", " ", "ell"}], "-", 
         RowBox[{"B22", " ", "ell"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`B12, Rational[1, 2] $CellContext`A13, 
      Rational[1, 2] $CellContext`A12}, {
     Rational[1, 
        2] $CellContext`A13, $CellContext`A23 - $CellContext`B12 \
$CellContext`ell, Rational[1, 2] $CellContext`A22 + 
      Rational[1, 2] $CellContext`A33 + Rational[1, 2] $CellContext`B11}, {
     Rational[1, 2] $CellContext`A12, Rational[1, 2] $CellContext`A22 + 
      Rational[1, 2] $CellContext`A33 + 
      Rational[1, 
         2] $CellContext`B11, $CellContext`A32 - $CellContext`B12 \
$CellContext`ell}}], 
   MatrixForm[{{
     2 $CellContext`A11 + $CellContext`B22, $CellContext`A21 - \
$CellContext`A12 $CellContext`ell, $CellContext`A31 - $CellContext`A13 \
$CellContext`ell}, {$CellContext`A21 - $CellContext`A12 $CellContext`ell, \
(-2) $CellContext`A22 $CellContext`ell - $CellContext`B22 $CellContext`ell, 
      Rational[1, 
         2] $CellContext`B21 - $CellContext`A23 $CellContext`ell - \
$CellContext`A32 $CellContext`ell}, {$CellContext`A31 - $CellContext`A13 \
$CellContext`ell, 
      Rational[1, 
         2] $CellContext`B21 - $CellContext`A23 $CellContext`ell - \
$CellContext`A32 $CellContext`ell, (-2) $CellContext`A33 $CellContext`ell - \
$CellContext`B22 $CellContext`ell}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7414564023604727`*^9},ExpressionUUID->"e2d0470f-8ece-4574-8ae7-\
bf68bcc46f6f"],

Cell[BoxData[
 TemplateBox[{
  "Solve","svars",
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"",2,
   57,3,15760267409170846619,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.741456402386882*^9},ExpressionUUID->"bab52a19-c558-4ba4-82fe-\
f9162e49340b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A11", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["B22", "2"]}], "+", 
      FractionBox["Y11", "2"]}]}], ",", 
    RowBox[{"A12", "\[Rule]", 
     RowBox[{"2", " ", "X13"}]}], ",", 
    RowBox[{"A13", "\[Rule]", 
     RowBox[{"2", " ", "X12"}]}], ",", 
    RowBox[{"A21", "\[Rule]", 
     RowBox[{
      RowBox[{"2", " ", "ell", " ", "X13"}], "+", "Y12"}]}], ",", 
    RowBox[{"A22", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["B22", "2"]}], "-", 
      FractionBox["Y22", 
       RowBox[{"2", " ", "ell"}]]}]}], ",", 
    RowBox[{"A23", "\[Rule]", 
     RowBox[{
      RowBox[{"ell", " ", "X11"}], "+", "X22"}]}], ",", 
    RowBox[{"A31", "\[Rule]", 
     RowBox[{
      RowBox[{"2", " ", "ell", " ", "X12"}], "+", "Y13"}]}], ",", 
    RowBox[{"A32", "\[Rule]", 
     RowBox[{
      RowBox[{"ell", " ", "X11"}], "+", "X33"}]}], ",", 
    RowBox[{"A33", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["B22", "2"]}], "-", 
      FractionBox["Y33", 
       RowBox[{"2", " ", "ell"}]]}]}], ",", 
    RowBox[{"B11", "\[Rule]", 
     RowBox[{"B22", "-", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", "ell", " ", "X23"}], "-", "Y22", "-", 
        "Y33"}], 
       RowBox[{"2", " ", "ell"}]]}]}], ",", 
    RowBox[{"B12", "\[Rule]", "X11"}], ",", 
    RowBox[{"B21", "\[Rule]", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["ell", "2"], " ", "X11"}], "+", 
        RowBox[{"ell", " ", "X22"}], "+", 
        RowBox[{"ell", " ", "X33"}], "+", "Y23"}], ")"}]}]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.741456402398239*^9},ExpressionUUID->"278a53f1-478e-4684-a8cc-\
3702213e6b0e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Calculation", " ", "for", " ", "orbit", " ", "O13"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "Note", " ", "that", " ", "the", " ", "cubic", " ", "irreducible", " ", 
      "B3", " ", "may", " ", "be", " ", "put", " ", "in", " ", "the", " ", 
      "form", " ", 
      RowBox[{"X", "^", "3"}]}], " ", "+", " ", 
     RowBox[{"b3", " ", "X"}], " ", "+", " ", 
     RowBox[{
      RowBox[{"c3", ".", "  ", "The"}], " ", "quantity"}], " ", "-", 
     RowBox[{"4", 
      RowBox[{"b3", "^", "3"}]}], " ", "-", 
     RowBox[{"27", 
      RowBox[{"c3", "^", "2"}], " ", "is", " ", "the", " ", 
      "discriminant"}]}], ",", " ", 
    RowBox[{
     RowBox[{"which", " ", "is", " ", "non"}], "-", 
     RowBox[{"zero", " ", "since", " ", "B3", " ", "is", " ", 
      RowBox[{"irreducible", ".", "  ", "This"}], " ", "is", " ", "needed", 
      " ", 
      RowBox[{"below", "."}]}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
      "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
      "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
      "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O13", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", 
         RowBox[{"b3", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"b3", "/", "2"}], ",", "c3"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", " ", "+", " ", 
          RowBox[{"A11", "*", "x"}]}], " ", ",", 
         RowBox[{"A12", "*", "x"}], ",", 
         RowBox[{"A13", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A21", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A22", "*", "x"}]}], ",", 
         RowBox[{"A23", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A31", "*", "x"}], ",", 
         RowBox[{"A32", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A33", "*", "x"}]}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B11", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", 
     RowBox[{"B12", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", 
     RowBox[{"B21", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B22", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A2", "-", "A"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B2", "-", "B"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"X11", " ", "==", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "1"}], "]"}]}], " ", "&&", 
      RowBox[{"X12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "2"}], "]"}]}], " ", "&&", 
      RowBox[{"X13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", " ", "2"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X33", " ", "==", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "3", ",", " ", "3"}], "]"}]}], "&&", " ", 
      RowBox[{"Y11", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "1"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "2"}], "]"}]}], "&&", 
      RowBox[{"Y13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "2"}], "]"}]}], "&&", " ", 
      RowBox[{"Y23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y33", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "3", ",", " ", "3"}], "]"}]}]}], " ", ",", 
     " ", 
     RowBox[{"{", 
      RowBox[{
      "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
       "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
       "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
       "B22"}], "}"}]}], "]"}], " "}]}]], "Input",
 CellChangeTimes->{{3.741456438989855*^9, 3.7414564396941032`*^9}, {
  3.7414564930139933`*^9, 3.741456622452939*^9}, {3.741456728749695*^9, 
  3.741456730132661*^9}, {3.741457267857275*^9, 3.741457456823804*^9}, {
  3.741457724095272*^9, 3.7414577284548388`*^9}, {3.741457967404777*^9, 
  3.741458007035407*^9}},ExpressionUUID->"c475fa54-3151-4265-bef3-\
ffbd0cd9de2c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"A13", 
        RowBox[{
         RowBox[{"-", "A12"}], "+", 
         FractionBox["A23", "2"], "+", 
         FractionBox["B12", "2"]}], 
        RowBox[{
         FractionBox["A11", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B11", "2"]}]},
       {
        RowBox[{
         RowBox[{"-", "A12"}], "+", 
         FractionBox["A23", "2"], "+", 
         FractionBox["B12", "2"]}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "A22"}], "-", "B11"}], 
        RowBox[{
         FractionBox["A21", "2"], "-", "A32", "+", 
         FractionBox[
          RowBox[{"B12", " ", "b3"}], "2"]}]},
       {
        RowBox[{
         FractionBox["A11", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B11", "2"]}], 
        RowBox[{
         FractionBox["A21", "2"], "-", "A32", "+", 
         FractionBox[
          RowBox[{"B12", " ", "b3"}], "2"]}], 
        RowBox[{"A31", "+", 
         RowBox[{"B12", " ", "c3"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"A12", 
        RowBox[{
         FractionBox["A11", "2"], "+", 
         FractionBox["A22", "2"], "+", 
         FractionBox["B22", "2"], "+", 
         FractionBox[
          RowBox[{"A13", " ", "b3"}], "2"]}], 
        RowBox[{
         FractionBox["A32", "2"], "+", 
         FractionBox["B21", "2"], "+", 
         FractionBox[
          RowBox[{"A12", " ", "b3"}], "2"], "+", 
         RowBox[{"A13", " ", "c3"}]}]},
       {
        RowBox[{
         FractionBox["A11", "2"], "+", 
         FractionBox["A22", "2"], "+", 
         FractionBox["B22", "2"], "+", 
         FractionBox[
          RowBox[{"A13", " ", "b3"}], "2"]}], 
        RowBox[{"A21", "-", "B21", "+", 
         RowBox[{"A23", " ", "b3"}]}], 
        RowBox[{
         FractionBox["A31", "2"], "+", 
         FractionBox[
          RowBox[{"A22", " ", "b3"}], "2"], "+", 
         FractionBox[
          RowBox[{"A33", " ", "b3"}], "2"], "+", 
         FractionBox[
          RowBox[{"B22", " ", "b3"}], "2"], "+", 
         RowBox[{"A23", " ", "c3"}]}]},
       {
        RowBox[{
         FractionBox["A32", "2"], "+", 
         FractionBox["B21", "2"], "+", 
         FractionBox[
          RowBox[{"A12", " ", "b3"}], "2"], "+", 
         RowBox[{"A13", " ", "c3"}]}], 
        RowBox[{
         FractionBox["A31", "2"], "+", 
         FractionBox[
          RowBox[{"A22", " ", "b3"}], "2"], "+", 
         FractionBox[
          RowBox[{"A33", " ", "b3"}], "2"], "+", 
         FractionBox[
          RowBox[{"B22", " ", "b3"}], "2"], "+", 
         RowBox[{"A23", " ", "c3"}]}], 
        RowBox[{
         RowBox[{"A32", " ", "b3"}], "+", 
         RowBox[{"2", " ", "A33", " ", "c3"}], "+", 
         RowBox[{"B22", " ", "c3"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`A13, -$CellContext`A12 + 
      Rational[1, 2] $CellContext`A23 + Rational[1, 2] $CellContext`B12, 
      Rational[1, 2] $CellContext`A11 + Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B11}, {-$CellContext`A12 + 
      Rational[1, 2] $CellContext`A23 + 
      Rational[1, 
         2] $CellContext`B12, (-2) $CellContext`A22 - $CellContext`B11, 
      Rational[1, 2] $CellContext`A21 - $CellContext`A32 + 
      Rational[1, 2] $CellContext`B12 $CellContext`b3}, {
     Rational[1, 2] $CellContext`A11 + Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B11, 
      Rational[1, 2] $CellContext`A21 - $CellContext`A32 + 
      Rational[1, 
         2] $CellContext`B12 $CellContext`b3, $CellContext`A31 + \
$CellContext`B12 $CellContext`c3}}], 
   MatrixForm[{{$CellContext`A12, Rational[1, 2] $CellContext`A11 + 
      Rational[1, 2] $CellContext`A22 + Rational[1, 2] $CellContext`B22 + 
      Rational[1, 2] $CellContext`A13 $CellContext`b3, 
      Rational[1, 2] $CellContext`A32 + Rational[1, 2] $CellContext`B21 + 
      Rational[1, 
         2] $CellContext`A12 $CellContext`b3 + $CellContext`A13 \
$CellContext`c3}, {
     Rational[1, 2] $CellContext`A11 + Rational[1, 2] $CellContext`A22 + 
      Rational[1, 2] $CellContext`B22 + 
      Rational[1, 
         2] $CellContext`A13 $CellContext`b3, $CellContext`A21 - \
$CellContext`B21 + $CellContext`A23 $CellContext`b3, 
      Rational[1, 2] $CellContext`A31 + 
      Rational[1, 2] $CellContext`A22 $CellContext`b3 + 
      Rational[1, 2] $CellContext`A33 $CellContext`b3 + 
      Rational[1, 
         2] $CellContext`B22 $CellContext`b3 + $CellContext`A23 \
$CellContext`c3}, {
     Rational[1, 2] $CellContext`A32 + Rational[1, 2] $CellContext`B21 + 
      Rational[1, 
         2] $CellContext`A12 $CellContext`b3 + $CellContext`A13 \
$CellContext`c3, Rational[1, 2] $CellContext`A31 + 
      Rational[1, 2] $CellContext`A22 $CellContext`b3 + 
      Rational[1, 2] $CellContext`A33 $CellContext`b3 + 
      Rational[1, 
         2] $CellContext`B22 $CellContext`b3 + $CellContext`A23 \
$CellContext`c3, $CellContext`A32 $CellContext`b3 + 
      2 $CellContext`A33 $CellContext`c3 + $CellContext`B22 \
$CellContext`c3}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741456626960374*^9, 3.741456732283288*^9, 
  3.741457729490316*^9},ExpressionUUID->"242dd88b-cd9d-445e-9de3-\
4cd6598c9f10"],

Cell[BoxData[
 TemplateBox[{
  "Solve","svars",
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"",2,
   133,7,15760267409170846619,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.741456627546092*^9, 3.741456732416429*^9, 
  3.741457729571753*^9},ExpressionUUID->"b7b41f39-9c4c-4d17-adb5-\
b91894c298f2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A11", "\[Rule]", 
     RowBox[{"A33", "-", 
      FractionBox[
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["b3", "4"], " ", "X11"}], "+", 
        RowBox[{"30", " ", "b3", " ", 
         SuperscriptBox["c3", "2"], " ", "X11"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b3", "2"], " ", "c3", " ", "X12"}], "-", 
        RowBox[{"18", " ", 
         SuperscriptBox["c3", "2"], " ", "X13"}], "-", 
        RowBox[{"9", " ", 
         SuperscriptBox["c3", "2"], " ", "X22"}], "+", 
        RowBox[{"12", " ", "b3", " ", "c3", " ", "X23"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b3", "2"], " ", "X33"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b3", "2"], " ", "c3", " ", "Y11"}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["b3", "3"], " ", "Y12"}], "-", 
        RowBox[{"36", " ", 
         SuperscriptBox["c3", "2"], " ", "Y12"}], "-", 
        RowBox[{"12", " ", "b3", " ", "c3", " ", "Y13"}], "-", 
        RowBox[{"6", " ", "b3", " ", "c3", " ", "Y22"}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["b3", "2"], " ", "Y23"}], "+", 
        RowBox[{"18", " ", "c3", " ", "Y33"}]}], 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["b3", "3"]}], "+", 
        RowBox[{"27", " ", 
         SuperscriptBox["c3", "2"]}]}]]}]}], ",", 
    RowBox[{"A12", "\[Rule]", "Y11"}], ",", 
    RowBox[{"A13", "\[Rule]", "X11"}], ",", 
    RowBox[{"A21", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b3", "3"]}], "+", 
         RowBox[{"27", " ", 
          SuperscriptBox["c3", "2"]}]}]], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"5", " ", 
          SuperscriptBox["b3", "3"], " ", "c3", " ", "X11"}], "+", 
         RowBox[{"36", " ", 
          SuperscriptBox["c3", "3"], " ", "X11"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b3", "4"], " ", "X12"}], "+", 
         RowBox[{"24", " ", "b3", " ", 
          SuperscriptBox["c3", "2"], " ", "X12"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b3", "2"], " ", "c3", " ", "X13"}], "+", 
         RowBox[{
          SuperscriptBox["b3", "2"], " ", "c3", " ", "X22"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b3", "3"], " ", "X23"}], "-", 
         RowBox[{"18", " ", 
          SuperscriptBox["c3", "2"], " ", "X23"}], "-", 
         RowBox[{"3", " ", "b3", " ", "c3", " ", "X33"}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["b3", "4"], " ", "Y11"}], "+", 
         RowBox[{"42", " ", "b3", " ", 
          SuperscriptBox["c3", "2"], " ", "Y11"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b3", "2"], " ", "c3", " ", "Y12"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b3", "3"], " ", "Y13"}], "-", 
         RowBox[{"36", " ", 
          SuperscriptBox["c3", "2"], " ", "Y13"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b3", "3"], " ", "Y22"}], "-", 
         RowBox[{"18", " ", 
          SuperscriptBox["c3", "2"], " ", "Y22"}], "+", 
         RowBox[{"6", " ", "b3", " ", "c3", " ", "Y23"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b3", "2"], " ", "Y33"}]}], ")"}]}]}]}], ",", 
    RowBox[{"A22", "\[Rule]", 
     RowBox[{"A33", "-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b3", "3"]}], "+", 
         RowBox[{"27", " ", 
          SuperscriptBox["c3", "2"]}]}]], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b3", "4"], " ", "X11"}], "+", 
         RowBox[{"15", " ", "b3", " ", 
          SuperscriptBox["c3", "2"], " ", "X11"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b3", "2"], " ", "c3", " ", "X12"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b3", "3"], " ", "X13"}], "+", 
         RowBox[{"18", " ", 
          SuperscriptBox["c3", "2"], " ", "X13"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b3", "3"], " ", "X22"}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["c3", "2"], " ", "X22"}], "+", 
         RowBox[{"6", " ", "b3", " ", "c3", " ", "X23"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b3", "2"], " ", "X33"}], "+", 
         RowBox[{
          SuperscriptBox["b3", "2"], " ", "c3", " ", "Y11"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b3", "3"], " ", "Y12"}], "-", 
         RowBox[{"18", " ", 
          SuperscriptBox["c3", "2"], " ", "Y12"}], "-", 
         RowBox[{"6", " ", "b3", " ", "c3", " ", "Y13"}], "-", 
         RowBox[{"3", " ", "b3", " ", "c3", " ", "Y22"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b3", "2"], " ", "Y23"}], "+", 
         RowBox[{"9", " ", "c3", " ", "Y33"}]}], ")"}]}]}]}], ",", 
    RowBox[{"A23", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{
         SuperscriptBox["b3", "2"], " ", "c3", " ", "X11"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b3", "3"], " ", "X12"}], "-", 
        RowBox[{"18", " ", 
         SuperscriptBox["c3", "2"], " ", "X12"}], "-", 
        RowBox[{"6", " ", "b3", " ", "c3", " ", "X13"}], "-", 
        RowBox[{"3", " ", "b3", " ", "c3", " ", "X22"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["b3", "2"], " ", "X23"}], "+", 
        RowBox[{"9", " ", "c3", " ", "X33"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b3", "3"], " ", "Y11"}], "-", 
        RowBox[{"18", " ", 
         SuperscriptBox["c3", "2"], " ", "Y11"}], "+", 
        RowBox[{"6", " ", "b3", " ", "c3", " ", "Y12"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b3", "2"], " ", "Y13"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b3", "2"], " ", "Y22"}], "-", 
        RowBox[{"18", " ", "c3", " ", "Y23"}], "+", 
        RowBox[{"6", " ", "b3", " ", "Y33"}]}], 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["b3", "3"]}], "+", 
        RowBox[{"27", " ", 
         SuperscriptBox["c3", "2"]}]}]]}]}], ",", 
    RowBox[{"A31", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b3", "3"]}], "+", 
         RowBox[{"27", " ", 
          SuperscriptBox["c3", "2"]}]}]], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b3", "2"], " ", 
          SuperscriptBox["c3", "2"], " ", "X11"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b3", "3"], " ", "c3", " ", "X12"}], "+", 
         RowBox[{"36", " ", 
          SuperscriptBox["c3", "3"], " ", "X12"}], "-", 
         RowBox[{"6", " ", "b3", " ", 
          SuperscriptBox["c3", "2"], " ", "X13"}], "-", 
         RowBox[{"3", " ", "b3", " ", 
          SuperscriptBox["c3", "2"], " ", "X22"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b3", "2"], " ", "c3", " ", "X23"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b3", "3"], " ", "X33"}], "-", 
         RowBox[{"18", " ", 
          SuperscriptBox["c3", "2"], " ", "X33"}], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox["b3", "3"], " ", "c3", " ", "Y11"}], "+", 
         RowBox[{"36", " ", 
          SuperscriptBox["c3", "3"], " ", "Y11"}], "+", 
         RowBox[{"6", " ", "b3", " ", 
          SuperscriptBox["c3", "2"], " ", "Y12"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b3", "2"], " ", "c3", " ", "Y13"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b3", "2"], " ", "c3", " ", "Y22"}], "-", 
         RowBox[{"18", " ", 
          SuperscriptBox["c3", "2"], " ", "Y23"}], "+", 
         RowBox[{"6", " ", "b3", " ", "c3", " ", "Y33"}]}], ")"}]}]}]}], ",", 
    
    RowBox[{"A32", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["b3", "3"], " ", "c3", " ", "X11"}], "+", 
        RowBox[{"18", " ", 
         SuperscriptBox["c3", "3"], " ", "X11"}], "-", 
        RowBox[{"6", " ", "b3", " ", 
         SuperscriptBox["c3", "2"], " ", "X12"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["b3", "2"], " ", "c3", " ", "X13"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b3", "2"], " ", "c3", " ", "X22"}], "+", 
        RowBox[{"18", " ", 
         SuperscriptBox["c3", "2"], " ", "X23"}], "-", 
        RowBox[{"6", " ", "b3", " ", "c3", " ", "X33"}], "+", 
        RowBox[{"3", " ", "b3", " ", 
         SuperscriptBox["c3", "2"], " ", "Y11"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b3", "2"], " ", "c3", " ", "Y12"}], "-", 
        RowBox[{"18", " ", 
         SuperscriptBox["c3", "2"], " ", "Y13"}], "-", 
        RowBox[{"9", " ", 
         SuperscriptBox["c3", "2"], " ", "Y22"}], "+", 
        RowBox[{"12", " ", "b3", " ", "c3", " ", "Y23"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b3", "2"], " ", "Y33"}]}], 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["b3", "3"]}], "+", 
        RowBox[{"27", " ", 
         SuperscriptBox["c3", "2"]}]}]]}]}], ",", 
    RowBox[{"B11", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "A33"}], "-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b3", "3"]}], "+", 
         RowBox[{"27", " ", 
          SuperscriptBox["c3", "2"]}]}]], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b3", "4"], " ", "X11"}], "-", 
         RowBox[{"30", " ", "b3", " ", 
          SuperscriptBox["c3", "2"], " ", "X11"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b3", "2"], " ", "c3", " ", "X12"}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["b3", "3"], " ", "X13"}], "-", 
         RowBox[{"36", " ", 
          SuperscriptBox["c3", "2"], " ", "X13"}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["c3", "2"], " ", "X22"}], "-", 
         RowBox[{"12", " ", "b3", " ", "c3", " ", "X23"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b3", "2"], " ", "X33"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b3", "2"], " ", "c3", " ", "Y11"}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["b3", "3"], " ", "Y12"}], "+", 
         RowBox[{"36", " ", 
          SuperscriptBox["c3", "2"], " ", "Y12"}], "+", 
         RowBox[{"12", " ", "b3", " ", "c3", " ", "Y13"}], "+", 
         RowBox[{"6", " ", "b3", " ", "c3", " ", "Y22"}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["b3", "2"], " ", "Y23"}], "-", 
         RowBox[{"18", " ", "c3", " ", "Y33"}]}], ")"}]}]}]}], ",", 
    RowBox[{"B12", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b3", "2"]}], " ", "c3", " ", "X11"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b3", "3"], " ", "X12"}], "-", 
        RowBox[{"36", " ", 
         SuperscriptBox["c3", "2"], " ", "X12"}], "+", 
        RowBox[{"6", " ", "b3", " ", "c3", " ", "X13"}], "+", 
        RowBox[{"3", " ", "b3", " ", "c3", " ", "X22"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b3", "2"], " ", "X23"}], "-", 
        RowBox[{"9", " ", "c3", " ", "X33"}], "-", 
        RowBox[{"6", " ", 
         SuperscriptBox["b3", "3"], " ", "Y11"}], "-", 
        RowBox[{"36", " ", 
         SuperscriptBox["c3", "2"], " ", "Y11"}], "-", 
        RowBox[{"6", " ", "b3", " ", "c3", " ", "Y12"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["b3", "2"], " ", "Y13"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b3", "2"], " ", "Y22"}], "+", 
        RowBox[{"18", " ", "c3", " ", "Y23"}], "-", 
        RowBox[{"6", " ", "b3", " ", "Y33"}]}], 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["b3", "3"]}], "+", 
        RowBox[{"27", " ", 
         SuperscriptBox["c3", "2"]}]}]]}]}], ",", 
    RowBox[{"B21", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b3", "3"]}], "+", 
         RowBox[{"27", " ", 
          SuperscriptBox["c3", "2"]}]}]], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b3", "3"], " ", "c3", " ", "X11"}], "+", 
         RowBox[{"36", " ", 
          SuperscriptBox["c3", "3"], " ", "X11"}], "+", 
         RowBox[{"6", " ", "b3", " ", 
          SuperscriptBox["c3", "2"], " ", "X12"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b3", "2"], " ", "c3", " ", "X13"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b3", "2"], " ", "c3", " ", "X22"}], "-", 
         RowBox[{"18", " ", 
          SuperscriptBox["c3", "2"], " ", "X23"}], "+", 
         RowBox[{"6", " ", "b3", " ", "c3", " ", "X33"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b3", "4"], " ", "Y11"}], "+", 
         RowBox[{"24", " ", "b3", " ", 
          SuperscriptBox["c3", "2"], " ", "Y11"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b3", "2"], " ", "c3", " ", "Y12"}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["b3", "3"], " ", "Y13"}], "-", 
         RowBox[{"36", " ", 
          SuperscriptBox["c3", "2"], " ", "Y13"}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["c3", "2"], " ", "Y22"}], "-", 
         RowBox[{"12", " ", "b3", " ", "c3", " ", "Y23"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b3", "2"], " ", "Y33"}]}], ")"}]}]}]}], ",", 
    RowBox[{"B22", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "A33"}], "-", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["b3", "4"], " ", "X11"}], "-", 
        RowBox[{"18", " ", "b3", " ", 
         SuperscriptBox["c3", "2"], " ", "X11"}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["b3", "2"], " ", "c3", " ", "X12"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b3", "3"], " ", "X13"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b3", "3"], " ", "X22"}], "-", 
        RowBox[{"18", " ", "b3", " ", "c3", " ", "X23"}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["b3", "2"], " ", "X33"}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b3", "2"], " ", "c3", " ", "Y11"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["b3", "3"], " ", "Y12"}], "+", 
        RowBox[{"18", " ", "b3", " ", "c3", " ", "Y13"}], "+", 
        RowBox[{"9", " ", "b3", " ", "c3", " ", "Y22"}], "-", 
        RowBox[{"12", " ", 
         SuperscriptBox["b3", "2"], " ", "Y23"}], "-", 
        RowBox[{"27", " ", "c3", " ", "Y33"}]}], 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["b3", "3"]}], "+", 
        RowBox[{"27", " ", 
         SuperscriptBox["c3", "2"]}]}]]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.7414566275775423`*^9, 3.741456732439048*^9, 
  3.741457729584958*^9},ExpressionUUID->"9328c957-2160-4edc-b7f1-\
c7a58c81bcbe"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Calculation", " ", "for", " ", "orbit", " ", "O4"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "Note", " ", "that", " ", "the", " ", "quartic", " ", "irreducible", " ",
       "B4", " ", "may", " ", "be", " ", "put", " ", "in", " ", "the", " ", 
      "form", " ", 
      RowBox[{"X", "^", "4"}]}], " ", "+", " ", 
     RowBox[{"b4", " ", 
      RowBox[{"X", "^", "2"}]}], " ", "+", " ", "c4X", " ", "+", " ", 
     RowBox[{
      RowBox[{"d4", ".", " ", "The"}], " ", "discriminant", " ", "is", " ", 
      "256", " ", 
      RowBox[{"d4", "^", "3"}]}], " ", "-", 
     RowBox[{"128", 
      RowBox[{"b4", "^", "2"}], 
      RowBox[{"d4", "^", "2"}]}], " ", "+", " ", 
     RowBox[{"144", " ", 
      RowBox[{"b4c4", "^", "2"}], "d4"}], " ", "-", 
     RowBox[{"27", " ", 
      RowBox[{"c4", "^", "4"}]}], " ", "+", " ", 
     RowBox[{"16", " ", 
      RowBox[{"b4", "^", "4"}], "d4"}], " ", "-", 
     RowBox[{"4", " ", 
      RowBox[{"b4", "^", "3"}], " ", 
      RowBox[{"c4", "^", "2"}]}]}], ",", " ", 
    RowBox[{
     RowBox[{"which", " ", "is", " ", "non"}], "-", "vanishing"}], ",", " ", 
    RowBox[{"since", " ", "B4", " ", "is", " ", 
     RowBox[{"irreducible", ".", "  ", "This"}], " ", "is", " ", "needed", 
     " ", 
     RowBox[{"below", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", "x", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
      "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
      "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
      "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O4", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "b4", ",", 
         RowBox[{"c4", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"c4", "/", "2"}], ",", "d4"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", " ", "+", " ", 
          RowBox[{"A11", "*", "x"}]}], " ", ",", 
         RowBox[{"A12", "*", "x"}], ",", 
         RowBox[{"A13", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A21", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A22", "*", "x"}]}], ",", 
         RowBox[{"A23", "*", "x"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A31", "*", "x"}], ",", 
         RowBox[{"A32", "*", "x"}], ",", 
         RowBox[{"1", "+", 
          RowBox[{"A33", "*", "x"}]}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b11", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B11", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b12", " ", "=", " ", 
     RowBox[{"B12", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b21", " ", "=", " ", 
     RowBox[{"B21", "*", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b22", " ", "=", " ", 
     RowBox[{"1", "+", 
      RowBox[{"B22", "*", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"b11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b12", " ", "*", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"b21", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"b22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A2", "-", "A"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"B2", "-", "B"}], ")"}], "/", "x"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"X11", " ", "==", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "1"}], "]"}]}], " ", "&&", 
      RowBox[{"X12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "2"}], "]"}]}], " ", "&&", 
      RowBox[{"X13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", " ", "2"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "2", ",", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"X33", " ", "==", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"A3", ",", " ", "3", ",", " ", "3"}], "]"}]}], "&&", " ", 
      RowBox[{"Y11", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "1"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y12", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "2"}], "]"}]}], "&&", 
      RowBox[{"Y13", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "1", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y22", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "2"}], "]"}]}], "&&", " ", 
      RowBox[{"Y23", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "2", ",", " ", "3"}], "]"}]}], " ", "&&", " ", 
      RowBox[{"Y33", " ", "\[Equal]", " ", 
       RowBox[{"Part", "[", 
        RowBox[{"B3", ",", " ", "3", ",", " ", "3"}], "]"}]}]}], " ", ",", 
     " ", 
     RowBox[{"{", 
      RowBox[{
      "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", 
       "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", 
       "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
       "B22"}], "}"}]}], "]"}], " "}]}]], "Input",
 CellChangeTimes->{{3.741457488654963*^9, 3.741457509431054*^9}, {
  3.741457562319291*^9, 3.7414575978547163`*^9}, {3.7414577135849037`*^9, 
  3.74145771747787*^9}, {3.741457795704464*^9, 3.741457826405903*^9}, {
  3.741458014884231*^9, 3.741458038857668*^9}, {3.741458357905238*^9, 
  3.741458415025008*^9}, {3.741458474336432*^9, 
  3.741458478713422*^9}},ExpressionUUID->"5769ecdb-467c-4a3d-9d09-\
cbfbcae6f9f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"A13", "+", "B12"}], 
        RowBox[{
         RowBox[{"-", "A12"}], "+", 
         FractionBox["A23", "2"]}], 
        RowBox[{
         FractionBox["A11", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B11", "2"]}]},
       {
        RowBox[{
         RowBox[{"-", "A12"}], "+", 
         FractionBox["A23", "2"]}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "A22"}], "-", "B11", "+", 
         RowBox[{"B12", " ", "b4"}]}], 
        RowBox[{
         FractionBox["A21", "2"], "-", "A32", "+", 
         FractionBox[
          RowBox[{"B12", " ", "c4"}], "2"]}]},
       {
        RowBox[{
         FractionBox["A11", "2"], "+", 
         FractionBox["A33", "2"], "+", 
         FractionBox["B11", "2"]}], 
        RowBox[{
         FractionBox["A21", "2"], "-", "A32", "+", 
         FractionBox[
          RowBox[{"B12", " ", "c4"}], "2"]}], 
        RowBox[{"A31", "+", 
         RowBox[{"B12", " ", "d4"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"2", " ", "A11"}], "+", "B22"}], 
        RowBox[{"A21", "+", 
         RowBox[{"A12", " ", "b4"}], "+", 
         FractionBox[
          RowBox[{"A13", " ", "c4"}], "2"]}], 
        RowBox[{"A31", "+", 
         FractionBox["B21", "2"], "+", 
         FractionBox[
          RowBox[{"A12", " ", "c4"}], "2"], "+", 
         RowBox[{"A13", " ", "d4"}]}]},
       {
        RowBox[{"A21", "+", 
         RowBox[{"A12", " ", "b4"}], "+", 
         FractionBox[
          RowBox[{"A13", " ", "c4"}], "2"]}], 
        RowBox[{
         RowBox[{"-", "B21"}], "+", 
         RowBox[{"2", " ", "A22", " ", "b4"}], "+", 
         RowBox[{"B22", " ", "b4"}], "+", 
         RowBox[{"A23", " ", "c4"}]}], 
        RowBox[{
         RowBox[{"A32", " ", "b4"}], "+", 
         FractionBox[
          RowBox[{"A22", " ", "c4"}], "2"], "+", 
         FractionBox[
          RowBox[{"A33", " ", "c4"}], "2"], "+", 
         FractionBox[
          RowBox[{"B22", " ", "c4"}], "2"], "+", 
         RowBox[{"A23", " ", "d4"}]}]},
       {
        RowBox[{"A31", "+", 
         FractionBox["B21", "2"], "+", 
         FractionBox[
          RowBox[{"A12", " ", "c4"}], "2"], "+", 
         RowBox[{"A13", " ", "d4"}]}], 
        RowBox[{
         RowBox[{"A32", " ", "b4"}], "+", 
         FractionBox[
          RowBox[{"A22", " ", "c4"}], "2"], "+", 
         FractionBox[
          RowBox[{"A33", " ", "c4"}], "2"], "+", 
         FractionBox[
          RowBox[{"B22", " ", "c4"}], "2"], "+", 
         RowBox[{"A23", " ", "d4"}]}], 
        RowBox[{
         RowBox[{"A32", " ", "c4"}], "+", 
         RowBox[{"2", " ", "A33", " ", "d4"}], "+", 
         RowBox[{"B22", " ", "d4"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`A13 + $CellContext`B12, -$CellContext`A12 + 
      Rational[1, 2] $CellContext`A23, Rational[1, 2] $CellContext`A11 + 
      Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B11}, {-$CellContext`A12 + 
      Rational[1, 
         2] $CellContext`A23, (-2) $CellContext`A22 - $CellContext`B11 + \
$CellContext`B12 $CellContext`b4, 
      Rational[1, 2] $CellContext`A21 - $CellContext`A32 + 
      Rational[1, 2] $CellContext`B12 $CellContext`c4}, {
     Rational[1, 2] $CellContext`A11 + Rational[1, 2] $CellContext`A33 + 
      Rational[1, 2] $CellContext`B11, 
      Rational[1, 2] $CellContext`A21 - $CellContext`A32 + 
      Rational[1, 
         2] $CellContext`B12 $CellContext`c4, $CellContext`A31 + \
$CellContext`B12 $CellContext`d4}}], 
   MatrixForm[{{
     2 $CellContext`A11 + $CellContext`B22, $CellContext`A21 + \
$CellContext`A12 $CellContext`b4 + 
      Rational[1, 2] $CellContext`A13 $CellContext`c4, $CellContext`A31 + 
      Rational[1, 2] $CellContext`B21 + 
      Rational[1, 
         2] $CellContext`A12 $CellContext`c4 + $CellContext`A13 \
$CellContext`d4}, {$CellContext`A21 + $CellContext`A12 $CellContext`b4 + 
      Rational[1, 2] $CellContext`A13 $CellContext`c4, -$CellContext`B21 + 
      2 $CellContext`A22 $CellContext`b4 + $CellContext`B22 $CellContext`b4 + \
$CellContext`A23 $CellContext`c4, $CellContext`A32 $CellContext`b4 + 
      Rational[1, 2] $CellContext`A22 $CellContext`c4 + 
      Rational[1, 2] $CellContext`A33 $CellContext`c4 + 
      Rational[1, 
         2] $CellContext`B22 $CellContext`c4 + $CellContext`A23 \
$CellContext`d4}, {$CellContext`A31 + Rational[1, 2] $CellContext`B21 + 
      Rational[1, 
         2] $CellContext`A12 $CellContext`c4 + $CellContext`A13 \
$CellContext`d4, $CellContext`A32 $CellContext`b4 + 
      Rational[1, 2] $CellContext`A22 $CellContext`c4 + 
      Rational[1, 2] $CellContext`A33 $CellContext`c4 + 
      Rational[
        1, 2] $CellContext`B22 $CellContext`c4 + $CellContext`A23 \
$CellContext`d4, $CellContext`A32 $CellContext`c4 + 
      2 $CellContext`A33 $CellContext`d4 + $CellContext`B22 \
$CellContext`d4}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7414575999718933`*^9, 3.7414577460146093`*^9, {3.741457801316697*^9, 
   3.7414578275197277`*^9}},ExpressionUUID->"3c5c6bbe-4573-4337-9eea-\
a02bbfa43f1c"],

Cell[BoxData[
 TemplateBox[{
  "Solve","svars",
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"",2,
   190,10,15760267409170846619,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.7414576005319443`*^9, 3.741457746250555*^9, {3.74145780234377*^9, 
   3.741457827664196*^9}},ExpressionUUID->"a5fb4b9a-0034-4bb4-a71c-\
f70c97258bdf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A11", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["B22", "2"]}], "+", 
      FractionBox["Y11", "2"]}]}], ",", 
    RowBox[{"A12", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "3"], " ", "X11"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "3"], " ", "c4", " ", "d4", " ", "X11"}], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["c4", "3"], " ", "d4", " ", "X11"}], "+", 
          RowBox[{"32", " ", "b4", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "X11"}], "-", 
          RowBox[{"18", " ", 
           SuperscriptBox["c4", "4"], " ", "X12"}], "+", 
          RowBox[{"88", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "X12"}], "-", 
          RowBox[{"64", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "X12"}], "+", 
          RowBox[{"256", " ", 
           SuperscriptBox["d4", "3"], " ", "X12"}], "+", 
          RowBox[{"12", " ", "b4", " ", 
           SuperscriptBox["c4", "3"], " ", "X13"}], "-", 
          RowBox[{"48", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", "d4", " ", "X13"}], "-", 
          RowBox[{"64", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "X13"}], "+", 
          RowBox[{"6", " ", "b4", " ", 
           SuperscriptBox["c4", "3"], " ", "X22"}], "-", 
          RowBox[{"24", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", "d4", " ", "X22"}], "-", 
          RowBox[{"32", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "X22"}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "2"], " ", "X23"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["b4", "3"], " ", "d4", " ", "X23"}], "+", 
          RowBox[{"48", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "X23"}], "-", 
          RowBox[{"128", " ", "b4", " ", 
           SuperscriptBox["d4", "2"], " ", "X23"}], "-", 
          RowBox[{"18", " ", 
           SuperscriptBox["c4", "3"], " ", "X33"}], "+", 
          RowBox[{"64", " ", "b4", " ", "c4", " ", "d4", " ", "X33"}], "-", 
          RowBox[{"3", " ", "b4", " ", 
           SuperscriptBox["c4", "3"], " ", "Y11"}], "+", 
          RowBox[{"12", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", "d4", " ", "Y11"}], "+", 
          RowBox[{"16", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "Y11"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "2"], " ", "Y12"}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["b4", "3"], " ", "d4", " ", "Y12"}], "-", 
          RowBox[{"24", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "Y12"}], "+", 
          RowBox[{"64", " ", "b4", " ", 
           SuperscriptBox["d4", "2"], " ", "Y12"}], "+", 
          RowBox[{"18", " ", 
           SuperscriptBox["c4", "3"], " ", "Y13"}], "-", 
          RowBox[{"64", " ", "b4", " ", "c4", " ", "d4", " ", "Y13"}], "+", 
          RowBox[{"9", " ", 
           SuperscriptBox["c4", "3"], " ", "Y22"}], "-", 
          RowBox[{"32", " ", "b4", " ", "c4", " ", "d4", " ", "Y22"}], "-", 
          RowBox[{"12", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "Y23"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["b4", "2"], " ", "d4", " ", "Y23"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["d4", "2"], " ", "Y23"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", "Y33"}], "+", 
          RowBox[{"48", " ", "c4", " ", "d4", " ", "Y33"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["b4", "3"], " ", 
           SuperscriptBox["c4", "2"]}], "-", 
          RowBox[{"27", " ", 
           SuperscriptBox["c4", "4"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["b4", "4"], " ", "d4"}], "+", 
          RowBox[{"144", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "d4"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["d4", "2"]}], "+", 
          RowBox[{"256", " ", 
           SuperscriptBox["d4", "3"]}]}], ")"}]}], ")"}]}]}], ",", 
    RowBox[{"A13", "\[Rule]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           SuperscriptBox["b4", "3"], " ", 
           SuperscriptBox["c4", "2"], " ", "X11"}], "-", 
          RowBox[{"9", " ", 
           SuperscriptBox["c4", "4"], " ", "X11"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "4"], " ", "d4", " ", "X11"}], "+", 
          RowBox[{"50", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "X11"}], "-", 
          RowBox[{"48", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "X11"}], "+", 
          RowBox[{"64", " ", 
           SuperscriptBox["d4", "3"], " ", "X11"}], "-", 
          RowBox[{"6", " ", "b4", " ", 
           SuperscriptBox["c4", "3"], " ", "X12"}], "+", 
          RowBox[{"24", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", "d4", " ", "X12"}], "+", 
          RowBox[{"32", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "X12"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "2"], " ", "X13"}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["b4", "3"], " ", "d4", " ", "X13"}], "-", 
          RowBox[{"24", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "X13"}], "+", 
          RowBox[{"64", " ", "b4", " ", 
           SuperscriptBox["d4", "2"], " ", "X13"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "2"], " ", "X22"}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "3"], " ", "d4", " ", "X22"}], "-", 
          RowBox[{"12", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "X22"}], "+", 
          RowBox[{"32", " ", "b4", " ", 
           SuperscriptBox["d4", "2"], " ", "X22"}], "+", 
          RowBox[{"18", " ", 
           SuperscriptBox["c4", "3"], " ", "X23"}], "-", 
          RowBox[{"64", " ", "b4", " ", "c4", " ", "d4", " ", "X23"}], "-", 
          RowBox[{"6", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "X33"}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["b4", "2"], " ", "d4", " ", "X33"}], "-", 
          RowBox[{"64", " ", 
           SuperscriptBox["d4", "2"], " ", "X33"}], "-", 
          RowBox[{
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "2"], " ", "Y11"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["b4", "3"], " ", "d4", " ", "Y11"}], "+", 
          RowBox[{"6", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "Y11"}], "-", 
          RowBox[{"16", " ", "b4", " ", 
           SuperscriptBox["d4", "2"], " ", "Y11"}], "-", 
          RowBox[{"9", " ", 
           SuperscriptBox["c4", "3"], " ", "Y12"}], "+", 
          RowBox[{"32", " ", "b4", " ", "c4", " ", "d4", " ", "Y12"}], "+", 
          RowBox[{"6", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "Y13"}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["b4", "2"], " ", "d4", " ", "Y13"}], "+", 
          RowBox[{"64", " ", 
           SuperscriptBox["d4", "2"], " ", "Y13"}], "+", 
          RowBox[{"3", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "Y22"}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "2"], " ", "d4", " ", "Y22"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["d4", "2"], " ", "Y22"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", "Y23"}], "-", 
          RowBox[{"48", " ", "c4", " ", "d4", " ", "Y23"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["b4", "3"], " ", "Y33"}], "+", 
          RowBox[{"18", " ", 
           SuperscriptBox["c4", "2"], " ", "Y33"}], "-", 
          RowBox[{"16", " ", "b4", " ", "d4", " ", "Y33"}]}], ")"}]}], ")"}], 
      "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox["b4", "3"], " ", 
         SuperscriptBox["c4", "2"]}], "-", 
        RowBox[{"27", " ", 
         SuperscriptBox["c4", "4"]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["b4", "4"], " ", "d4"}], "+", 
        RowBox[{"144", " ", "b4", " ", 
         SuperscriptBox["c4", "2"], " ", "d4"}], "-", 
        RowBox[{"128", " ", 
         SuperscriptBox["b4", "2"], " ", 
         SuperscriptBox["d4", "2"]}], "+", 
        RowBox[{"256", " ", 
         SuperscriptBox["d4", "3"]}]}], ")"}]}]}], ",", 
    RowBox[{"A21", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "9"}], " ", 
           SuperscriptBox["c4", "5"], " ", "X11"}], "+", 
          RowBox[{"56", " ", "b4", " ", 
           SuperscriptBox["c4", "3"], " ", "d4", " ", "X11"}], "-", 
          RowBox[{"80", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "X11"}], "+", 
          RowBox[{"64", " ", "c4", " ", 
           SuperscriptBox["d4", "3"], " ", "X11"}], "+", 
          RowBox[{"12", " ", "b4", " ", 
           SuperscriptBox["c4", "4"], " ", "X12"}], "-", 
          RowBox[{"64", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "X12"}], "+", 
          RowBox[{"64", " ", 
           SuperscriptBox["b4", "3"], " ", 
           SuperscriptBox["d4", "2"], " ", "X12"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["c4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "X12"}], "-", 
          RowBox[{"256", " ", "b4", " ", 
           SuperscriptBox["d4", "3"], " ", "X12"}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "3"], " ", "X13"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["b4", "3"], " ", "c4", " ", "d4", " ", "X13"}], "-", 
          RowBox[{"24", " ", 
           SuperscriptBox["c4", "3"], " ", "d4", " ", "X13"}], "+", 
          RowBox[{"128", " ", "b4", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "X13"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "3"], " ", "X22"}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["b4", "3"], " ", "c4", " ", "d4", " ", "X22"}], "-", 
          RowBox[{"12", " ", 
           SuperscriptBox["c4", "3"], " ", "d4", " ", "X22"}], "+", 
          RowBox[{"64", " ", "b4", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "X22"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "3"], " ", 
           SuperscriptBox["c4", "2"], " ", "X23"}], "+", 
          RowBox[{"18", " ", 
           SuperscriptBox["c4", "4"], " ", "X23"}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["b4", "4"], " ", "d4", " ", "X23"}], "-", 
          RowBox[{"112", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "X23"}], "+", 
          RowBox[{"128", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "X23"}], "+", 
          RowBox[{"12", " ", "b4", " ", 
           SuperscriptBox["c4", "3"], " ", "X33"}], "-", 
          RowBox[{"48", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", "d4", " ", "X33"}], "-", 
          RowBox[{"64", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "X33"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "3"], " ", "Y11"}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "3"], " ", "c4", " ", "d4", " ", "Y11"}], "+", 
          RowBox[{"6", " ", 
           SuperscriptBox["c4", "3"], " ", "d4", " ", "Y11"}], "-", 
          RowBox[{"32", " ", "b4", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "Y11"}], "+", 
          RowBox[{"18", " ", 
           SuperscriptBox["c4", "4"], " ", "Y12"}], "-", 
          RowBox[{"88", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "Y12"}], "+", 
          RowBox[{"64", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "Y12"}], "-", 
          RowBox[{"256", " ", 
           SuperscriptBox["d4", "3"], " ", "Y12"}], "-", 
          RowBox[{"12", " ", "b4", " ", 
           SuperscriptBox["c4", "3"], " ", "Y13"}], "+", 
          RowBox[{"48", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", "d4", " ", "Y13"}], "+", 
          RowBox[{"64", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "Y13"}], "-", 
          RowBox[{"6", " ", "b4", " ", 
           SuperscriptBox["c4", "3"], " ", "Y22"}], "+", 
          RowBox[{"24", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", "d4", " ", "Y22"}], "+", 
          RowBox[{"32", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "Y22"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "2"], " ", "Y23"}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["b4", "3"], " ", "d4", " ", "Y23"}], "-", 
          RowBox[{"48", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "Y23"}], "+", 
          RowBox[{"128", " ", "b4", " ", 
           SuperscriptBox["d4", "2"], " ", "Y23"}], "+", 
          RowBox[{"18", " ", 
           SuperscriptBox["c4", "3"], " ", "Y33"}], "-", 
          RowBox[{"64", " ", "b4", " ", "c4", " ", "d4", " ", "Y33"}]}], 
         ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["b4", "3"], " ", 
           SuperscriptBox["c4", "2"]}], "-", 
          RowBox[{"27", " ", 
           SuperscriptBox["c4", "4"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["b4", "4"], " ", "d4"}], "+", 
          RowBox[{"144", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "d4"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["d4", "2"]}], "+", 
          RowBox[{"256", " ", 
           SuperscriptBox["d4", "3"]}]}], ")"}]}], ")"}]}]}], ",", 
    RowBox[{"A22", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["B22", "2"]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", "b4", " ", 
          SuperscriptBox["c4", "4"], " ", "X11"}], "-", 
         RowBox[{"32", " ", 
          SuperscriptBox["b4", "2"], " ", 
          SuperscriptBox["c4", "2"], " ", "d4", " ", "X11"}], "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["b4", "3"], " ", 
          SuperscriptBox["d4", "2"], " ", "X11"}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["c4", "2"], " ", 
          SuperscriptBox["d4", "2"], " ", "X11"}], "-", 
         RowBox[{"128", " ", "b4", " ", 
          SuperscriptBox["d4", "3"], " ", "X11"}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["b4", "2"], " ", 
          SuperscriptBox["c4", "3"], " ", "X12"}], "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["b4", "3"], " ", "c4", " ", "d4", " ", "X12"}], "-", 
         
         RowBox[{"24", " ", 
          SuperscriptBox["c4", "3"], " ", "d4", " ", "X12"}], "+", 
         RowBox[{"128", " ", "b4", " ", "c4", " ", 
          SuperscriptBox["d4", "2"], " ", "X12"}], "-", 
         RowBox[{"36", " ", 
          SuperscriptBox["c4", "4"], " ", "X13"}], "+", 
         RowBox[{"176", " ", "b4", " ", 
          SuperscriptBox["c4", "2"], " ", "d4", " ", "X13"}], "-", 
         RowBox[{"128", " ", 
          SuperscriptBox["b4", "2"], " ", 
          SuperscriptBox["d4", "2"], " ", "X13"}], "+", 
         RowBox[{"512", " ", 
          SuperscriptBox["d4", "3"], " ", "X13"}], "-", 
         RowBox[{"18", " ", 
          SuperscriptBox["c4", "4"], " ", "X22"}], "+", 
         RowBox[{"88", " ", "b4", " ", 
          SuperscriptBox["c4", "2"], " ", "d4", " ", "X22"}], "-", 
         RowBox[{"64", " ", 
          SuperscriptBox["b4", "2"], " ", 
          SuperscriptBox["d4", "2"], " ", "X22"}], "+", 
         RowBox[{"256", " ", 
          SuperscriptBox["d4", "3"], " ", "X22"}], "+", 
         RowBox[{"24", " ", "b4", " ", 
          SuperscriptBox["c4", "3"], " ", "X23"}], "-", 
         RowBox[{"96", " ", 
          SuperscriptBox["b4", "2"], " ", "c4", " ", "d4", " ", "X23"}], "-", 
         
         RowBox[{"128", " ", "c4", " ", 
          SuperscriptBox["d4", "2"], " ", "X23"}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["b4", "2"], " ", 
          SuperscriptBox["c4", "2"], " ", "X33"}], "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["b4", "3"], " ", "d4", " ", "X33"}], "+", 
         RowBox[{"48", " ", 
          SuperscriptBox["c4", "2"], " ", "d4", " ", "X33"}], "-", 
         RowBox[{"128", " ", "b4", " ", 
          SuperscriptBox["d4", "2"], " ", "X33"}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["c4", "4"], " ", "Y11"}], "-", 
         RowBox[{"44", " ", "b4", " ", 
          SuperscriptBox["c4", "2"], " ", "d4", " ", "Y11"}], "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["b4", "2"], " ", 
          SuperscriptBox["d4", "2"], " ", "Y11"}], "-", 
         RowBox[{"128", " ", 
          SuperscriptBox["d4", "3"], " ", "Y11"}], "-", 
         RowBox[{"12", " ", "b4", " ", 
          SuperscriptBox["c4", "3"], " ", "Y12"}], "+", 
         RowBox[{"48", " ", 
          SuperscriptBox["b4", "2"], " ", "c4", " ", "d4", " ", "Y12"}], "+", 
         
         RowBox[{"64", " ", "c4", " ", 
          SuperscriptBox["d4", "2"], " ", "Y12"}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["b4", "2"], " ", 
          SuperscriptBox["c4", "2"], " ", "Y13"}], "-", 
         RowBox[{"32", " ", 
          SuperscriptBox["b4", "3"], " ", "d4", " ", "Y13"}], "-", 
         RowBox[{"48", " ", 
          SuperscriptBox["c4", "2"], " ", "d4", " ", "Y13"}], "+", 
         RowBox[{"128", " ", "b4", " ", 
          SuperscriptBox["d4", "2"], " ", "Y13"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b4", "2"], " ", 
          SuperscriptBox["c4", "2"], " ", "Y22"}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["b4", "3"], " ", "d4", " ", "Y22"}], "-", 
         RowBox[{"24", " ", 
          SuperscriptBox["c4", "2"], " ", "d4", " ", "Y22"}], "+", 
         RowBox[{"64", " ", "b4", " ", 
          SuperscriptBox["d4", "2"], " ", "Y22"}], "+", 
         RowBox[{"36", " ", 
          SuperscriptBox["c4", "3"], " ", "Y23"}], "-", 
         RowBox[{"128", " ", "b4", " ", "c4", " ", "d4", " ", "Y23"}], "-", 
         RowBox[{"12", " ", "b4", " ", 
          SuperscriptBox["c4", "2"], " ", "Y33"}], "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["b4", "2"], " ", "d4", " ", "Y33"}], "-", 
         RowBox[{"128", " ", 
          SuperscriptBox["d4", "2"], " ", "Y33"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["b4", "3"], " ", 
            SuperscriptBox["c4", "2"]}], "-", 
           RowBox[{"27", " ", 
            SuperscriptBox["c4", "4"]}], "+", 
           RowBox[{"16", " ", 
            SuperscriptBox["b4", "4"], " ", "d4"}], "+", 
           RowBox[{"144", " ", "b4", " ", 
            SuperscriptBox["c4", "2"], " ", "d4"}], "-", 
           RowBox[{"128", " ", 
            SuperscriptBox["b4", "2"], " ", 
            SuperscriptBox["d4", "2"]}], "+", 
           RowBox[{"256", " ", 
            SuperscriptBox["d4", "3"]}]}], ")"}]}], ")"}]}]}]}], ",", 
    RowBox[{"A23", "\[Rule]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "3"], " ", "X11"}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "3"], " ", "c4", " ", "d4", " ", "X11"}], "+", 
          RowBox[{"6", " ", 
           SuperscriptBox["c4", "3"], " ", "d4", " ", "X11"}], "-", 
          RowBox[{"32", " ", "b4", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "X11"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["b4", "3"], " ", 
           SuperscriptBox["c4", "2"], " ", "X12"}], "-", 
          RowBox[{"9", " ", 
           SuperscriptBox["c4", "4"], " ", "X12"}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["b4", "4"], " ", "d4", " ", "X12"}], "+", 
          RowBox[{"56", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "X12"}], "-", 
          RowBox[{"64", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "X12"}], "-", 
          RowBox[{"12", " ", "b4", " ", 
           SuperscriptBox["c4", "3"], " ", "X13"}], "+", 
          RowBox[{"48", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", "d4", " ", "X13"}], "+", 
          RowBox[{"64", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "X13"}], "-", 
          RowBox[{"6", " ", "b4", " ", 
           SuperscriptBox["c4", "3"], " ", "X22"}], "+", 
          RowBox[{"24", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", "d4", " ", "X22"}], "+", 
          RowBox[{"32", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "X22"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "2"], " ", "X23"}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["b4", "3"], " ", "d4", " ", "X23"}], "-", 
          RowBox[{"48", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "X23"}], "+", 
          RowBox[{"128", " ", "b4", " ", 
           SuperscriptBox["d4", "2"], " ", "X23"}], "+", 
          RowBox[{"18", " ", 
           SuperscriptBox["c4", "3"], " ", "X33"}], "-", 
          RowBox[{"64", " ", "b4", " ", "c4", " ", "d4", " ", "X33"}], "+", 
          RowBox[{"3", " ", "b4", " ", 
           SuperscriptBox["c4", "3"], " ", "Y11"}], "-", 
          RowBox[{"12", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", "d4", " ", "Y11"}], "-", 
          RowBox[{"16", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "Y11"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "2"], " ", "Y12"}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["b4", "3"], " ", "d4", " ", "Y12"}], "+", 
          RowBox[{"24", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "Y12"}], "-", 
          RowBox[{"64", " ", "b4", " ", 
           SuperscriptBox["d4", "2"], " ", "Y12"}], "-", 
          RowBox[{"18", " ", 
           SuperscriptBox["c4", "3"], " ", "Y13"}], "+", 
          RowBox[{"64", " ", "b4", " ", "c4", " ", "d4", " ", "Y13"}], "-", 
          RowBox[{"9", " ", 
           SuperscriptBox["c4", "3"], " ", "Y22"}], "+", 
          RowBox[{"32", " ", "b4", " ", "c4", " ", "d4", " ", "Y22"}], "+", 
          RowBox[{"12", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "Y23"}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["b4", "2"], " ", "d4", " ", "Y23"}], "+", 
          RowBox[{"128", " ", 
           SuperscriptBox["d4", "2"], " ", "Y23"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", "Y33"}], "-", 
          RowBox[{"48", " ", "c4", " ", "d4", " ", "Y33"}]}], ")"}]}], ")"}], 
      "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox["b4", "3"], " ", 
         SuperscriptBox["c4", "2"]}], "-", 
        RowBox[{"27", " ", 
         SuperscriptBox["c4", "4"]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["b4", "4"], " ", "d4"}], "+", 
        RowBox[{"144", " ", "b4", " ", 
         SuperscriptBox["c4", "2"], " ", "d4"}], "-", 
        RowBox[{"128", " ", 
         SuperscriptBox["b4", "2"], " ", 
         SuperscriptBox["d4", "2"]}], "+", 
        RowBox[{"256", " ", 
         SuperscriptBox["d4", "3"]}]}], ")"}]}]}], ",", 
    RowBox[{"A31", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "9"}], " ", 
           SuperscriptBox["c4", "4"], " ", "d4", " ", "X11"}], "+", 
          RowBox[{"44", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "X11"}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["d4", "3"], " ", "X11"}], "+", 
          RowBox[{"128", " ", 
           SuperscriptBox["d4", "4"], " ", "X11"}], "+", 
          RowBox[{"12", " ", "b4", " ", 
           SuperscriptBox["c4", "3"], " ", "d4", " ", "X12"}], "-", 
          RowBox[{"48", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "X12"}], "-", 
          RowBox[{"64", " ", "c4", " ", 
           SuperscriptBox["d4", "3"], " ", "X12"}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "X13"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["b4", "3"], " ", 
           SuperscriptBox["d4", "2"], " ", "X13"}], "+", 
          RowBox[{"48", " ", 
           SuperscriptBox["c4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "X13"}], "-", 
          RowBox[{"128", " ", "b4", " ", 
           SuperscriptBox["d4", "3"], " ", "X13"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "X22"}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["b4", "3"], " ", 
           SuperscriptBox["d4", "2"], " ", "X22"}], "+", 
          RowBox[{"24", " ", 
           SuperscriptBox["c4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "X22"}], "-", 
          RowBox[{"64", " ", "b4", " ", 
           SuperscriptBox["d4", "3"], " ", "X22"}], "-", 
          RowBox[{"36", " ", 
           SuperscriptBox["c4", "3"], " ", "d4", " ", "X23"}], "+", 
          RowBox[{"128", " ", "b4", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "X23"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["b4", "3"], " ", 
           SuperscriptBox["c4", "2"], " ", "X33"}], "+", 
          RowBox[{"27", " ", 
           SuperscriptBox["c4", "4"], " ", "X33"}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["b4", "4"], " ", "d4", " ", "X33"}], "-", 
          RowBox[{"132", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "X33"}], "+", 
          RowBox[{"96", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "X33"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["d4", "3"], " ", "X33"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "Y11"}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "3"], " ", 
           SuperscriptBox["d4", "2"], " ", "Y11"}], "-", 
          RowBox[{"12", " ", 
           SuperscriptBox["c4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "Y11"}], "+", 
          RowBox[{"32", " ", "b4", " ", 
           SuperscriptBox["d4", "3"], " ", "Y11"}], "+", 
          RowBox[{"18", " ", 
           SuperscriptBox["c4", "3"], " ", "d4", " ", "Y12"}], "-", 
          RowBox[{"64", " ", "b4", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "Y12"}], "-", 
          RowBox[{"12", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "Y13"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "Y13"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["d4", "3"], " ", "Y13"}], "-", 
          RowBox[{"6", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "Y22"}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "Y22"}], "-", 
          RowBox[{"64", " ", 
           SuperscriptBox["d4", "3"], " ", "Y22"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", "d4", " ", "Y23"}], "+", 
          RowBox[{"96", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "Y23"}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "3"], " ", "d4", " ", "Y33"}], "-", 
          RowBox[{"36", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "Y33"}], "+", 
          RowBox[{"32", " ", "b4", " ", 
           SuperscriptBox["d4", "2"], " ", "Y33"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["b4", "3"], " ", 
           SuperscriptBox["c4", "2"]}], "-", 
          RowBox[{"27", " ", 
           SuperscriptBox["c4", "4"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["b4", "4"], " ", "d4"}], "+", 
          RowBox[{"144", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "d4"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["d4", "2"]}], "+", 
          RowBox[{"256", " ", 
           SuperscriptBox["d4", "3"]}]}], ")"}]}], ")"}]}]}], ",", 
    RowBox[{"A32", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"6", " ", "b4", " ", 
           SuperscriptBox["c4", "3"], " ", "d4", " ", "X11"}], "-", 
          RowBox[{"24", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "X11"}], "-", 
          RowBox[{"32", " ", "c4", " ", 
           SuperscriptBox["d4", "3"], " ", "X11"}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "X12"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["b4", "3"], " ", 
           SuperscriptBox["d4", "2"], " ", "X12"}], "+", 
          RowBox[{"48", " ", 
           SuperscriptBox["c4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "X12"}], "-", 
          RowBox[{"128", " ", "b4", " ", 
           SuperscriptBox["d4", "3"], " ", "X12"}], "-", 
          RowBox[{"36", " ", 
           SuperscriptBox["c4", "3"], " ", "d4", " ", "X13"}], "+", 
          RowBox[{"128", " ", "b4", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "X13"}], "-", 
          RowBox[{"18", " ", 
           SuperscriptBox["c4", "3"], " ", "d4", " ", "X22"}], "+", 
          RowBox[{"64", " ", "b4", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "X22"}], "+", 
          RowBox[{"24", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "X23"}], "-", 
          RowBox[{"64", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "X23"}], "+", 
          RowBox[{"256", " ", 
           SuperscriptBox["d4", "3"], " ", "X23"}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", "d4", " ", "X33"}], "-", 
          RowBox[{"96", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "X33"}], "+", 
          RowBox[{"9", " ", 
           SuperscriptBox["c4", "3"], " ", "d4", " ", "Y11"}], "-", 
          RowBox[{"32", " ", "b4", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "Y11"}], "-", 
          RowBox[{"12", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "Y12"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "Y12"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["d4", "3"], " ", "Y12"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", "d4", " ", "Y13"}], "+", 
          RowBox[{"96", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "Y13"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", "d4", " ", "Y22"}], "+", 
          RowBox[{"48", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "Y22"}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["b4", "3"], " ", "d4", " ", "Y23"}], "-", 
          RowBox[{"72", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "Y23"}], "+", 
          RowBox[{"64", " ", "b4", " ", 
           SuperscriptBox["d4", "2"], " ", "Y23"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["b4", "3"], " ", "c4", " ", "Y33"}], "+", 
          RowBox[{"27", " ", 
           SuperscriptBox["c4", "3"], " ", "Y33"}], "-", 
          RowBox[{"48", " ", "b4", " ", "c4", " ", "d4", " ", "Y33"}]}], 
         ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["b4", "3"], " ", 
           SuperscriptBox["c4", "2"]}], "-", 
          RowBox[{"27", " ", 
           SuperscriptBox["c4", "4"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["b4", "4"], " ", "d4"}], "+", 
          RowBox[{"144", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "d4"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["d4", "2"]}], "+", 
          RowBox[{"256", " ", 
           SuperscriptBox["d4", "3"]}]}], ")"}]}], ")"}]}]}], ",", 
    RowBox[{"A33", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["B22", "2"]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "6"}], " ", "b4", " ", 
          SuperscriptBox["c4", "4"], " ", "X11"}], "+", 
         RowBox[{"24", " ", 
          SuperscriptBox["b4", "2"], " ", 
          SuperscriptBox["c4", "2"], " ", "d4", " ", "X11"}], "+", 
         RowBox[{"32", " ", 
          SuperscriptBox["c4", "2"], " ", 
          SuperscriptBox["d4", "2"], " ", "X11"}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["b4", "2"], " ", 
          SuperscriptBox["c4", "3"], " ", "X12"}], "-", 
         RowBox[{"32", " ", 
          SuperscriptBox["b4", "3"], " ", "c4", " ", "d4", " ", "X12"}], "-", 
         
         RowBox[{"48", " ", 
          SuperscriptBox["c4", "3"], " ", "d4", " ", "X12"}], "+", 
         RowBox[{"128", " ", "b4", " ", "c4", " ", 
          SuperscriptBox["d4", "2"], " ", "X12"}], "+", 
         RowBox[{"36", " ", 
          SuperscriptBox["c4", "4"], " ", "X13"}], "-", 
         RowBox[{"128", " ", "b4", " ", 
          SuperscriptBox["c4", "2"], " ", "d4", " ", "X13"}], "+", 
         RowBox[{"18", " ", 
          SuperscriptBox["c4", "4"], " ", "X22"}], "-", 
         RowBox[{"64", " ", "b4", " ", 
          SuperscriptBox["c4", "2"], " ", "d4", " ", "X22"}], "-", 
         RowBox[{"24", " ", "b4", " ", 
          SuperscriptBox["c4", "3"], " ", "X23"}], "+", 
         RowBox[{"64", " ", 
          SuperscriptBox["b4", "2"], " ", "c4", " ", "d4", " ", "X23"}], "-", 
         
         RowBox[{"256", " ", "c4", " ", 
          SuperscriptBox["d4", "2"], " ", "X23"}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["b4", "2"], " ", 
          SuperscriptBox["c4", "2"], " ", "X33"}], "+", 
         RowBox[{"96", " ", 
          SuperscriptBox["c4", "2"], " ", "d4", " ", "X33"}], "-", 
         RowBox[{"9", " ", 
          SuperscriptBox["c4", "4"], " ", "Y11"}], "+", 
         RowBox[{"32", " ", "b4", " ", 
          SuperscriptBox["c4", "2"], " ", "d4", " ", "Y11"}], "+", 
         RowBox[{"12", " ", "b4", " ", 
          SuperscriptBox["c4", "3"], " ", "Y12"}], "-", 
         RowBox[{"32", " ", 
          SuperscriptBox["b4", "2"], " ", "c4", " ", "d4", " ", "Y12"}], "+", 
         
         RowBox[{"128", " ", "c4", " ", 
          SuperscriptBox["d4", "2"], " ", "Y12"}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["b4", "2"], " ", 
          SuperscriptBox["c4", "2"], " ", "Y13"}], "-", 
         RowBox[{"96", " ", 
          SuperscriptBox["c4", "2"], " ", "d4", " ", "Y13"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b4", "2"], " ", 
          SuperscriptBox["c4", "2"], " ", "Y22"}], "-", 
         RowBox[{"48", " ", 
          SuperscriptBox["c4", "2"], " ", "d4", " ", "Y22"}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["b4", "3"], " ", "c4", " ", "Y23"}], "+", 
         RowBox[{"72", " ", 
          SuperscriptBox["c4", "3"], " ", "Y23"}], "-", 
         RowBox[{"64", " ", "b4", " ", "c4", " ", "d4", " ", "Y23"}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["b4", "4"], " ", "Y33"}], "-", 
         RowBox[{"96", " ", "b4", " ", 
          SuperscriptBox["c4", "2"], " ", "Y33"}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["b4", "2"], " ", "d4", " ", "Y33"}], "-", 
         RowBox[{"256", " ", 
          SuperscriptBox["d4", "2"], " ", "Y33"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", 
            SuperscriptBox["b4", "3"], " ", 
            SuperscriptBox["c4", "2"]}], "-", 
           RowBox[{"27", " ", 
            SuperscriptBox["c4", "4"]}], "+", 
           RowBox[{"16", " ", 
            SuperscriptBox["b4", "4"], " ", "d4"}], "+", 
           RowBox[{"144", " ", "b4", " ", 
            SuperscriptBox["c4", "2"], " ", "d4"}], "-", 
           RowBox[{"128", " ", 
            SuperscriptBox["b4", "2"], " ", 
            SuperscriptBox["d4", "2"]}], "+", 
           RowBox[{"256", " ", 
            SuperscriptBox["d4", "3"]}]}], ")"}]}], ")"}]}]}]}], ",", 
    RowBox[{"B11", "\[Rule]", 
     RowBox[{"B22", "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "b4", " ", 
          SuperscriptBox["c4", "4"], " ", "X11"}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["b4", "2"], " ", 
          SuperscriptBox["c4", "2"], " ", "d4", " ", "X11"}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["c4", "2"], " ", 
          SuperscriptBox["d4", "2"], " ", "X11"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b4", "2"], " ", 
          SuperscriptBox["c4", "3"], " ", "X12"}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["b4", "3"], " ", "c4", " ", "d4", " ", "X12"}], "+", 
         
         RowBox[{"24", " ", 
          SuperscriptBox["c4", "3"], " ", "d4", " ", "X12"}], "-", 
         RowBox[{"64", " ", "b4", " ", "c4", " ", 
          SuperscriptBox["d4", "2"], " ", "X12"}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["b4", "3"], " ", 
          SuperscriptBox["c4", "2"], " ", "X13"}], "+", 
         RowBox[{"36", " ", 
          SuperscriptBox["c4", "4"], " ", "X13"}], "-", 
         RowBox[{"32", " ", 
          SuperscriptBox["b4", "4"], " ", "d4", " ", "X13"}], "-", 
         RowBox[{"224", " ", "b4", " ", 
          SuperscriptBox["c4", "2"], " ", "d4", " ", "X13"}], "+", 
         RowBox[{"256", " ", 
          SuperscriptBox["b4", "2"], " ", 
          SuperscriptBox["d4", "2"], " ", "X13"}], "-", 
         RowBox[{"512", " ", 
          SuperscriptBox["d4", "3"], " ", "X13"}], "-", 
         RowBox[{"9", " ", 
          SuperscriptBox["c4", "4"], " ", "X22"}], "+", 
         RowBox[{"32", " ", "b4", " ", 
          SuperscriptBox["c4", "2"], " ", "d4", " ", "X22"}], "+", 
         RowBox[{"12", " ", "b4", " ", 
          SuperscriptBox["c4", "3"], " ", "X23"}], "-", 
         RowBox[{"32", " ", 
          SuperscriptBox["b4", "2"], " ", "c4", " ", "d4", " ", "X23"}], "+", 
         
         RowBox[{"128", " ", "c4", " ", 
          SuperscriptBox["d4", "2"], " ", "X23"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b4", "2"], " ", 
          SuperscriptBox["c4", "2"], " ", "X33"}], "-", 
         RowBox[{"48", " ", 
          SuperscriptBox["c4", "2"], " ", "d4", " ", "X33"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b4", "3"], " ", 
          SuperscriptBox["c4", "2"], " ", "Y11"}], "-", 
         RowBox[{"9", " ", 
          SuperscriptBox["c4", "4"], " ", "Y11"}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["b4", "4"], " ", "d4", " ", "Y11"}], "+", 
         RowBox[{"56", " ", "b4", " ", 
          SuperscriptBox["c4", "2"], " ", "d4", " ", "Y11"}], "-", 
         RowBox[{"64", " ", 
          SuperscriptBox["b4", "2"], " ", 
          SuperscriptBox["d4", "2"], " ", "Y11"}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["d4", "3"], " ", "Y11"}], "-", 
         RowBox[{"6", " ", "b4", " ", 
          SuperscriptBox["c4", "3"], " ", "Y12"}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["b4", "2"], " ", "c4", " ", "d4", " ", "Y12"}], "-", 
         
         RowBox[{"64", " ", "c4", " ", 
          SuperscriptBox["d4", "2"], " ", "Y12"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b4", "2"], " ", 
          SuperscriptBox["c4", "2"], " ", "Y13"}], "+", 
         RowBox[{"48", " ", 
          SuperscriptBox["c4", "2"], " ", "d4", " ", "Y13"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b4", "2"], " ", 
          SuperscriptBox["c4", "2"], " ", "Y22"}], "+", 
         RowBox[{"24", " ", 
          SuperscriptBox["c4", "2"], " ", "d4", " ", "Y22"}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["b4", "3"], " ", "c4", " ", "Y23"}], "-", 
         RowBox[{"36", " ", 
          SuperscriptBox["c4", "3"], " ", "Y23"}], "+", 
         RowBox[{"32", " ", "b4", " ", "c4", " ", "d4", " ", "Y23"}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["b4", "4"], " ", "Y33"}], "+", 
         RowBox[{"48", " ", "b4", " ", 
          SuperscriptBox["c4", "2"], " ", "Y33"}], "-", 
         RowBox[{"64", " ", 
          SuperscriptBox["b4", "2"], " ", "d4", " ", "Y33"}], "+", 
         RowBox[{"128", " ", 
          SuperscriptBox["d4", "2"], " ", "Y33"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b4", "3"], " ", 
          SuperscriptBox["c4", "2"]}], "-", 
         RowBox[{"27", " ", 
          SuperscriptBox["c4", "4"]}], "+", 
         RowBox[{"16", " ", 
          SuperscriptBox["b4", "4"], " ", "d4"}], "+", 
         RowBox[{"144", " ", "b4", " ", 
          SuperscriptBox["c4", "2"], " ", "d4"}], "-", 
         RowBox[{"128", " ", 
          SuperscriptBox["b4", "2"], " ", 
          SuperscriptBox["d4", "2"]}], "+", 
         RowBox[{"256", " ", 
          SuperscriptBox["d4", "3"]}]}], ")"}]}]}]}], ",", 
    RowBox[{"B12", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"9", " ", 
           SuperscriptBox["c4", "4"], " ", "X11"}], "-", 
          RowBox[{"44", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "X11"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "X11"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["d4", "3"], " ", "X11"}], "-", 
          RowBox[{"12", " ", "b4", " ", 
           SuperscriptBox["c4", "3"], " ", "X12"}], "+", 
          RowBox[{"48", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", "d4", " ", "X12"}], "+", 
          RowBox[{"64", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "X12"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "2"], " ", "X13"}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["b4", "3"], " ", "d4", " ", "X13"}], "-", 
          RowBox[{"48", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "X13"}], "+", 
          RowBox[{"128", " ", "b4", " ", 
           SuperscriptBox["d4", "2"], " ", "X13"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "2"], " ", "X22"}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["b4", "3"], " ", "d4", " ", "X22"}], "-", 
          RowBox[{"24", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "X22"}], "+", 
          RowBox[{"64", " ", "b4", " ", 
           SuperscriptBox["d4", "2"], " ", "X22"}], "+", 
          RowBox[{"36", " ", 
           SuperscriptBox["c4", "3"], " ", "X23"}], "-", 
          RowBox[{"128", " ", "b4", " ", "c4", " ", "d4", " ", "X23"}], "-", 
          RowBox[{"12", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "X33"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["b4", "2"], " ", "d4", " ", "X33"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["d4", "2"], " ", "X33"}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "2"], " ", "Y11"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "3"], " ", "d4", " ", "Y11"}], "+", 
          RowBox[{"12", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "Y11"}], "-", 
          RowBox[{"32", " ", "b4", " ", 
           SuperscriptBox["d4", "2"], " ", "Y11"}], "-", 
          RowBox[{"18", " ", 
           SuperscriptBox["c4", "3"], " ", "Y12"}], "+", 
          RowBox[{"64", " ", "b4", " ", "c4", " ", "d4", " ", "Y12"}], "+", 
          RowBox[{"12", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "Y13"}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["b4", "2"], " ", "d4", " ", "Y13"}], "+", 
          RowBox[{"128", " ", 
           SuperscriptBox["d4", "2"], " ", "Y13"}], "+", 
          RowBox[{"6", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "Y22"}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["b4", "2"], " ", "d4", " ", "Y22"}], "+", 
          RowBox[{"64", " ", 
           SuperscriptBox["d4", "2"], " ", "Y22"}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", "Y23"}], "-", 
          RowBox[{"96", " ", "c4", " ", "d4", " ", "Y23"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "3"], " ", "Y33"}], "+", 
          RowBox[{"36", " ", 
           SuperscriptBox["c4", "2"], " ", "Y33"}], "-", 
          RowBox[{"32", " ", "b4", " ", "d4", " ", "Y33"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["b4", "3"], " ", 
           SuperscriptBox["c4", "2"]}], "-", 
          RowBox[{"27", " ", 
           SuperscriptBox["c4", "4"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["b4", "4"], " ", "d4"}], "+", 
          RowBox[{"144", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "d4"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["d4", "2"]}], "+", 
          RowBox[{"256", " ", 
           SuperscriptBox["d4", "3"]}]}], ")"}]}], ")"}]}]}], ",", 
    RowBox[{"B21", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "4"], " ", "X11"}], "-", 
          RowBox[{"16", " ", 
           SuperscriptBox["b4", "3"], " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "X11"}], "-", 
          RowBox[{"12", " ", 
           SuperscriptBox["c4", "4"], " ", "d4", " ", "X11"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["b4", "4"], " ", 
           SuperscriptBox["d4", "2"], " ", "X11"}], "+", 
          RowBox[{"80", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "X11"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["d4", "3"], " ", "X11"}], "+", 
          RowBox[{"18", " ", 
           SuperscriptBox["c4", "5"], " ", "X12"}], "-", 
          RowBox[{"136", " ", "b4", " ", 
           SuperscriptBox["c4", "3"], " ", "d4", " ", "X12"}], "+", 
          RowBox[{"256", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "X12"}], "-", 
          RowBox[{"12", " ", "b4", " ", 
           SuperscriptBox["c4", "4"], " ", "X13"}], "+", 
          RowBox[{"80", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "X13"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["b4", "3"], " ", 
           SuperscriptBox["d4", "2"], " ", "X13"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["c4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "X13"}], "+", 
          RowBox[{"512", " ", "b4", " ", 
           SuperscriptBox["d4", "3"], " ", "X13"}], "-", 
          RowBox[{"6", " ", "b4", " ", 
           SuperscriptBox["c4", "4"], " ", "X22"}], "+", 
          RowBox[{"40", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "X22"}], "-", 
          RowBox[{"64", " ", 
           SuperscriptBox["b4", "3"], " ", 
           SuperscriptBox["d4", "2"], " ", "X22"}], "-", 
          RowBox[{"64", " ", 
           SuperscriptBox["c4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "X22"}], "+", 
          RowBox[{"256", " ", "b4", " ", 
           SuperscriptBox["d4", "3"], " ", "X22"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "3"], " ", "X23"}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["b4", "3"], " ", "c4", " ", "d4", " ", "X23"}], "+", 
          RowBox[{"96", " ", 
           SuperscriptBox["c4", "3"], " ", "d4", " ", "X23"}], "-", 
          RowBox[{"384", " ", "b4", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "X23"}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "3"], " ", 
           SuperscriptBox["c4", "2"], " ", "X33"}], "-", 
          RowBox[{"36", " ", 
           SuperscriptBox["c4", "4"], " ", "X33"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["b4", "4"], " ", "d4", " ", "X33"}], "+", 
          RowBox[{"176", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "X33"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "X33"}], "+", 
          RowBox[{"3", " ", "b4", " ", 
           SuperscriptBox["c4", "4"], " ", "Y11"}], "-", 
          RowBox[{"20", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "Y11"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["b4", "3"], " ", 
           SuperscriptBox["d4", "2"], " ", "Y11"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["c4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "Y11"}], "-", 
          RowBox[{"128", " ", "b4", " ", 
           SuperscriptBox["d4", "3"], " ", "Y11"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "3"], " ", "Y12"}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["b4", "3"], " ", "c4", " ", "d4", " ", "Y12"}], "-", 
          RowBox[{"48", " ", 
           SuperscriptBox["c4", "3"], " ", "d4", " ", "Y12"}], "+", 
          RowBox[{"192", " ", "b4", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "Y12"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["b4", "3"], " ", 
           SuperscriptBox["c4", "2"], " ", "Y13"}], "+", 
          RowBox[{"36", " ", 
           SuperscriptBox["c4", "4"], " ", "Y13"}], "-", 
          RowBox[{"32", " ", 
           SuperscriptBox["b4", "4"], " ", "d4", " ", "Y13"}], "-", 
          RowBox[{"176", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "Y13"}], "+", 
          RowBox[{"128", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "Y13"}], "-", 
          RowBox[{"9", " ", 
           SuperscriptBox["c4", "4"], " ", "Y22"}], "+", 
          RowBox[{"56", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "Y22"}], "-", 
          RowBox[{"64", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["d4", "2"], " ", "Y22"}], "+", 
          RowBox[{"256", " ", 
           SuperscriptBox["d4", "3"], " ", "Y22"}], "+", 
          RowBox[{"12", " ", "b4", " ", 
           SuperscriptBox["c4", "3"], " ", "Y23"}], "-", 
          RowBox[{"64", " ", 
           SuperscriptBox["b4", "2"], " ", "c4", " ", "d4", " ", "Y23"}], "-", 
          RowBox[{"256", " ", "c4", " ", 
           SuperscriptBox["d4", "2"], " ", "Y23"}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["c4", "2"], " ", "Y33"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["b4", "3"], " ", "d4", " ", "Y33"}], "+", 
          RowBox[{"96", " ", 
           SuperscriptBox["c4", "2"], " ", "d4", " ", "Y33"}], "-", 
          RowBox[{"128", " ", "b4", " ", 
           SuperscriptBox["d4", "2"], " ", "Y33"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["b4", "3"], " ", 
           SuperscriptBox["c4", "2"]}], "-", 
          RowBox[{"27", " ", 
           SuperscriptBox["c4", "4"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["b4", "4"], " ", "d4"}], "+", 
          RowBox[{"144", " ", "b4", " ", 
           SuperscriptBox["c4", "2"], " ", "d4"}], "-", 
          RowBox[{"128", " ", 
           SuperscriptBox["b4", "2"], " ", 
           SuperscriptBox["d4", "2"]}], "+", 
          RowBox[{"256", " ", 
           SuperscriptBox["d4", "3"]}]}], ")"}]}], ")"}]}]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.741457600568186*^9, 3.741457746270009*^9, {3.7414578023693237`*^9, 
   3.74145782767905*^9}},ExpressionUUID->"76837cb8-8cd9-4862-9dab-\
751aaab18d8f"]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{102, Automatic}, {3, Automatic}},
FrontEndVersion->"11.1 for Linux x86 (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 6901, 172, 694, "Input", "ExpressionUUID" -> \
"6b9a84f7-bda9-4ff8-b9ef-105964ac347c"],
Cell[7484, 196, 1846, 50, 59, "Print", "ExpressionUUID" -> \
"0b3e8778-6863-4b40-8a29-b21f921b7919"],
Cell[9333, 248, 401, 9, 23, "Message", "ExpressionUUID" -> \
"476bb10c-4210-479c-b14f-4a5617fabbcb"],
Cell[9737, 259, 535, 15, 34, "Output", "ExpressionUUID" -> \
"f6389cf1-f3bf-43b7-bf0e-1b8ae5b73db7"]
}, Open  ]],
Cell[10287, 277, 198, 3, 55, "Input", "ExpressionUUID" -> \
"1c09a611-37a9-4539-badb-91ea633ca539"],
Cell[10488, 282, 247, 6, 32, "Input", "ExpressionUUID" -> \
"d724082c-ce04-49ba-b0f9-124815af4468"],
Cell[CellGroupData[{
Cell[10760, 292, 5283, 151, 517, "Input", "ExpressionUUID" -> \
"68250ddd-9b49-4174-9629-70ca5652c7fd"],
Cell[16046, 445, 2612, 69, 89, "Print", "ExpressionUUID" -> \
"f1987d48-9d25-4add-9872-0386a0dc6d47"],
Cell[18661, 516, 355, 8, 23, "Message", "ExpressionUUID" -> \
"027555a2-9cc3-46a7-8fdf-5bf95319ce75"],
Cell[19019, 526, 661, 18, 34, "Output", "ExpressionUUID" -> \
"bf9dd8c5-62e3-4f40-bca7-f005d464210c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19717, 549, 5939, 158, 562, "Input", "ExpressionUUID" -> \
"e53c8087-2031-4df3-b009-f711e87caa83"],
Cell[25659, 709, 2564, 70, 59, "Print", "ExpressionUUID" -> \
"f1b47a38-664a-46ea-8b96-19c06ca456e4"],
Cell[28226, 781, 405, 10, 23, "Message", "ExpressionUUID" -> \
"9455c141-99ca-488f-941a-40eac4b07fa9"],
Cell[28634, 793, 884, 27, 149, "Output", "ExpressionUUID" -> \
"a694f9fc-655e-4043-a413-797aef870d9a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29555, 825, 6183, 164, 562, "Input", "ExpressionUUID" -> \
"6f06c422-2647-456e-8dc2-4f9194d510b5"],
Cell[35741, 991, 3195, 87, 89, "Print", "ExpressionUUID" -> \
"06f98dac-7e90-4f1c-94b7-d5fbd05186cb"],
Cell[38939, 1080, 331, 8, 23, "Message", "ExpressionUUID" -> \
"7d3355d8-20da-4abd-849f-46c11878abbe"],
Cell[39273, 1090, 899, 27, 82, "Output", "ExpressionUUID" -> \
"d863a180-53c7-4558-8b42-42c3915ac403"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40209, 1122, 6006, 158, 562, "Input", "ExpressionUUID" -> \
"8848bac7-6c06-4422-b570-ce467d31b380"],
Cell[46218, 1282, 356, 8, 23, "Message", "ExpressionUUID" -> \
"819d50c6-97ab-46c1-a958-db03a36b5a06"],
Cell[46577, 1292, 867, 25, 57, "Output", "ExpressionUUID" -> \
"1fd7e4fb-04c6-403f-b91f-7e1fbfcf0b1b"],
Cell[47447, 1319, 2900, 76, 89, "Print", "ExpressionUUID" -> \
"3efac87f-9704-4483-8df2-4a4e99540e52"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50384, 1400, 6481, 172, 585, "Input", "ExpressionUUID" -> \
"64dbce0e-b596-4c9b-96ad-cdc7ed73ba1f"],
Cell[56868, 1574, 3570, 93, 89, "Print", "ExpressionUUID" -> \
"5d4c3af9-0dde-4348-a40e-e77ff865c263"],
Cell[60441, 1669, 330, 8, 23, "Message", "ExpressionUUID" -> \
"b594e3bf-632e-49a7-928a-ff38e56549b2"],
Cell[60774, 1679, 919, 27, 57, "Output", "ExpressionUUID" -> \
"940ad5e1-2088-42dd-9f8b-9fa6c01fb86a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61730, 1711, 5965, 158, 562, "Input", "ExpressionUUID" -> \
"1b037972-d937-4ef1-8996-11e2a008373e"],
Cell[67698, 1871, 2040, 55, 59, "Print", "ExpressionUUID" -> \
"fadba9d1-6a3c-4a92-93af-ac12ec350f01"],
Cell[69741, 1928, 331, 8, 23, "Message", "ExpressionUUID" -> \
"fa714b87-2481-456f-be70-028ee9968045"],
Cell[70075, 1938, 720, 21, 57, "Output", "ExpressionUUID" -> \
"25686e7b-18bb-422c-91c2-2635efb7eb8b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[70832, 1964, 6385, 169, 585, "Input", "ExpressionUUID" -> \
"19a93e7b-a454-41dc-a5f7-69d24341f88b"],
Cell[77220, 2135, 3441, 91, 89, "Print", "ExpressionUUID" -> \
"215904c9-24e3-4698-a260-a250b99cd10c"],
Cell[80664, 2228, 327, 7, 23, "Message", "ExpressionUUID" -> \
"032dfdfb-de83-40b2-a17f-6034f38de063"],
Cell[80994, 2237, 1483, 47, 113, "Output", "ExpressionUUID" -> \
"94a0d2fd-54e6-4291-aadf-adef802f1f68"]
}, Open  ]],
Cell[CellGroupData[{
Cell[82514, 2289, 6691, 176, 677, "Input", "ExpressionUUID" -> \
"4dde34a6-ad94-473b-afa2-f8797815d864"],
Cell[89208, 2467, 3179, 84, 89, "Print", "ExpressionUUID" -> \
"82666bd1-36cf-46e8-823d-3dac09c0b5b6"],
Cell[92390, 2553, 331, 8, 23, "Message", "ExpressionUUID" -> \
"a45b4823-975b-4f21-ace9-ac7f4fc82b8a"],
Cell[92724, 2563, 1274, 39, 105, "Output", "ExpressionUUID" -> \
"99eee9f6-b9de-44fe-ac70-c245c247fb71"]
}, Open  ]],
Cell[CellGroupData[{
Cell[94035, 2607, 6557, 173, 585, "Input", "ExpressionUUID" -> \
"bccd3a46-150a-439a-9dc8-55c0a55af905"],
Cell[100595, 2782, 3910, 101, 89, "Print", "ExpressionUUID" -> \
"49da576a-383a-4dfe-bcbc-cb87c674ab86"],
Cell[104508, 2885, 331, 8, 23, "Message", "ExpressionUUID" -> \
"b45bf57d-f5c2-45a7-a757-0febf304058b"],
Cell[104842, 2895, 1669, 51, 114, "Output", "ExpressionUUID" -> \
"d2047682-afb7-402d-bc78-e71f9d618511"]
}, Open  ]],
Cell[CellGroupData[{
Cell[106548, 2951, 6299, 167, 585, "Input", "ExpressionUUID" -> \
"7e0c2dab-9b15-4937-b5ec-2ce5f2997e63"],
Cell[112850, 3120, 2740, 72, 89, "Print", "ExpressionUUID" -> \
"86d49f3a-2515-4289-9f7e-d1082aa35fa2"],
Cell[115593, 3194, 355, 8, 23, "Message", "ExpressionUUID" -> \
"61327791-4caf-47e3-8cd4-082f395a0682"],
Cell[115951, 3204, 915, 24, 57, "Output", "ExpressionUUID" -> \
"68e1c8b8-d8cf-4983-a1d9-ec5018cdd1e5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[116903, 3233, 6454, 170, 585, "Input", "ExpressionUUID" -> \
"9614a7be-dd40-4ce5-b63f-e00a9c7dac6b"],
Cell[123360, 3405, 2689, 70, 59, "Print", "ExpressionUUID" -> \
"6b26ad0c-2184-48b4-a2aa-a05be0dc600c"],
Cell[126052, 3477, 328, 7, 23, "Message", "ExpressionUUID" -> \
"c8f3e4c4-395c-4761-8e83-26f6ad921a68"],
Cell[126383, 3486, 1066, 32, 92, "Output", "ExpressionUUID" -> \
"31025b37-d5d8-404d-b9f6-c3598e8a8124"]
}, Open  ]],
Cell[CellGroupData[{
Cell[127486, 3523, 6458, 169, 585, "Input", "ExpressionUUID" -> \
"6c842502-c824-41cb-a4dd-7b1c214d53b2"],
Cell[133947, 3694, 3222, 87, 89, "Print", "ExpressionUUID" -> \
"7b680a2c-0942-4bd5-bde4-220b9df11fd2"],
Cell[137172, 3783, 331, 8, 23, "Message", "ExpressionUUID" -> \
"64bcd231-d10f-4ddd-8695-5d5a02569aeb"],
Cell[137506, 3793, 1373, 41, 122, "Output", "ExpressionUUID" -> \
"58250219-bcc1-4a50-a651-276b581f2acb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[138916, 3839, 6468, 170, 585, "Input", "ExpressionUUID" -> \
"36d32c8c-75ce-474c-87a4-bb443c3b2458"],
Cell[145387, 4011, 3461, 94, 89, "Print", "ExpressionUUID" -> \
"a0735730-b5ea-4234-a703-49aa8efb7e05"],
Cell[148851, 4107, 333, 8, 23, "Message", "ExpressionUUID" -> \
"1ba13ce7-f4b4-4233-a3ea-af97c81369ea"],
Cell[149187, 4117, 1349, 40, 124, "Output", "ExpressionUUID" -> \
"a1bfb886-404a-4706-b0bf-dc4acf957d12"]
}, Open  ]],
Cell[CellGroupData[{
Cell[150573, 4162, 6769, 181, 585, "Input", "ExpressionUUID" -> \
"c636cea5-b195-49cf-a1d3-e6a240c43a36"],
Cell[157345, 4345, 5817, 143, 188, "Print", "ExpressionUUID" -> \
"d7f593cd-d7ee-48f4-a639-753d41939a04"],
Cell[163165, 4490, 307, 8, 23, "Message", "ExpressionUUID" -> \
"9876ef69-35f4-44ac-82aa-a9f1a568189b"],
Cell[163475, 4500, 2039, 55, 148, "Output", "ExpressionUUID" -> \
"65b3d361-0583-478a-abe5-7acb4bc908d1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[165551, 4560, 6535, 173, 585, "Input", "ExpressionUUID" -> \
"98586a44-283e-442f-a4b2-1beac68e88a6"],
Cell[172089, 4735, 3858, 104, 89, "Print", "ExpressionUUID" -> \
"77794697-2a30-45ab-a0fc-ead72a21f106"],
Cell[175950, 4841, 309, 8, 23, "Message", "ExpressionUUID" -> \
"205b2960-e91f-4392-994f-b717680229a2"],
Cell[176262, 4851, 1716, 53, 93, "Output", "ExpressionUUID" -> \
"02562f4d-6fb6-496d-99a9-8767456e63a8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[178015, 4909, 6509, 172, 516, "Input", "ExpressionUUID" -> \
"72794dd7-69df-49d0-a7d4-6b1182a7f16b"],
Cell[184527, 5083, 4087, 109, 89, "Print", "ExpressionUUID" -> \
"e2d0470f-8ece-4574-8ae7-bf68bcc46f6f"],
Cell[188617, 5194, 307, 8, 23, "Message", "ExpressionUUID" -> \
"bab52a19-c558-4ba4-82fe-f9162e49340b"],
Cell[188927, 5204, 1826, 57, 93, "Output", "ExpressionUUID" -> \
"278a53f1-478e-4684-a8cc-3702213e6b0e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[190790, 5266, 7709, 200, 561, "Input", "ExpressionUUID" -> \
"c475fa54-3151-4265-bef3-ffbd0cd9de2c"],
Cell[198502, 5468, 6357, 164, 89, "Print", "ExpressionUUID" -> \
"242dd88b-cd9d-445e-9de3-4cd6598c9f10"],
Cell[204862, 5634, 352, 8, 23, "Message", "ExpressionUUID" -> \
"b7b41f39-9c4c-4d17-adb5-b91894c298f2"],
Cell[205217, 5644, 15304, 376, 618, "Output", "ExpressionUUID" -> \
"9328c957-2160-4edc-b7f1-c7a58c81bcbe"]
}, Open  ]],
Cell[CellGroupData[{
Cell[220558, 6025, 8083, 209, 561, "Input", "ExpressionUUID" -> \
"5769ecdb-467c-4a3d-9d09-cbfbcae6f9f4"],
Cell[228644, 6236, 6278, 161, 89, "Print", "ExpressionUUID" -> \
"3c5c6bbe-4573-4337-9eea-a02bbfa43f1c"],
Cell[234925, 6399, 382, 9, 23, "Message", "ExpressionUUID" -> \
"a5fb4b9a-0034-4bb4-a71c-f70c97258bdf"],
Cell[235310, 6410, 55281, 1236, 1360, "Output", "ExpressionUUID" -> \
"76837cb8-8cd9-4862-9dab-751aaab18d8f"]
}, Open  ]]
}
]
*)

