(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    154635,       4093]
NotebookOptionsPosition[    148857,       3941]
NotebookOutlinePosition[    149191,       3956]
CellTagsIndexPosition[    149148,       3953]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "file", " ", "checks", " ", "the", " ", "calculation", " ", 
    "of", " ", "action", " ", "sets", " ", "given", " ", "in", " ", 
    "Appendix", " ", "B"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Determination", " ", "of", " ", "the", " ", "action", " ", "set", " ", 
    "for", " ", "the", " ", "pair", " ", 
    RowBox[{"(", 
     RowBox[{"O1211", ",", " ", "OD12"}], ")"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O1211", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OD12", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "A12", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A21", ",", " ", "A22", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A31", ",", " ", "A32", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Solve", " ", "A21"}], " ", "=", " ", 
     RowBox[{"A31", " ", "=", " ", "0"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "A12", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "A22", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "A32", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.733603881811367*^9, 3.733604137603126*^9}, {
   3.733604170891293*^9, 3.733604198122884*^9}, {3.7336054403800087`*^9, 
   3.7336054762674303`*^9}, {3.736970040771502*^9, 3.7369700417956448`*^9}, {
   3.736970090075706*^9, 3.736970092027542*^9}, {3.739180739159521*^9, 
   3.7391807644153643`*^9}, {3.741173932879264*^9, 3.741173935848414*^9}, {
   3.741174161429626*^9, 3.741174237934721*^9}, {3.7411750316443443`*^9, 
   3.741175065106799*^9}, 3.741175583721211*^9, {3.741175683679542*^9, 
   3.7411757227831573`*^9}, {3.741175802742607*^9, 
   3.7411758425337887`*^9}},ExpressionUUID->"24bf2db5-ca40-47c5-8a45-\
c12fd0940645"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         SuperscriptBox["A11", "2"], " ", "B11"}], 
        RowBox[{"A11", " ", "A21", " ", "B11"}], 
        RowBox[{"A11", " ", "A31", " ", "B11"}]},
       {
        RowBox[{"A11", " ", "A21", " ", "B11"}], 
        RowBox[{
         SuperscriptBox["A21", "2"], " ", "B11"}], 
        RowBox[{"A21", " ", "A31", " ", "B11"}]},
       {
        RowBox[{"A11", " ", "A31", " ", "B11"}], 
        RowBox[{"A21", " ", "A31", " ", "B11"}], 
        RowBox[{
         SuperscriptBox["A31", "2"], " ", "B11"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`A11^2 $CellContext`B11, $CellContext`A11 \
$CellContext`A21 $CellContext`B11, $CellContext`A11 $CellContext`A31 \
$CellContext`B11}, {$CellContext`A11 $CellContext`A21 $CellContext`B11, \
$CellContext`A21^2 $CellContext`B11, $CellContext`A21 $CellContext`A31 \
$CellContext`B11}, {$CellContext`A11 $CellContext`A31 $CellContext`B11, \
$CellContext`A21 $CellContext`A31 $CellContext`B11, $CellContext`A31^2 \
$CellContext`B11}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733605477720667*^9, 3.739180767264052*^9, 3.741174477943637*^9, 
   3.741175049063389*^9, 3.741175597569693*^9, {3.7411758170739803`*^9, 
   3.74117584338262*^9}},ExpressionUUID->"aa3db56b-283f-4d1d-8c23-\
01e4413fab23"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         SuperscriptBox["A11", "2"], " ", "B11"}], "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`A11^2 $CellContext`B11, 0, 0}, {0, 0, 0}, {0, 0, 
     0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733605477720667*^9, 3.739180767264052*^9, 3.741174477943637*^9, 
   3.741175049063389*^9, 3.741175597569693*^9, {3.7411758170739803`*^9, 
   3.741175843384934*^9}},ExpressionUUID->"1628308a-2673-4fc8-aa0b-\
dc95b770decb"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7336040005819197`*^9, 
  3.733604001915707*^9}},ExpressionUUID->"6763bfb3-ce06-41f5-ac09-\
a426d1db0c8b"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.741174333420225*^9, 3.741174333884205*^9}, 
   3.7411750177833977`*^9},ExpressionUUID->"543bf2c4-0eb1-4f0a-b9d6-\
302cd5b8260c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Determination", " ", "of", " ", "the", " ", "action", " ", "set", " ", 
    "for", " ", "the", " ", "pair", " ", 
    RowBox[{"(", 
     RowBox[{"O122", ",", " ", "OD12"}], ")"}]}], " ", "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O122", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OD12", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "A12", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A21", ",", " ", "A22", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A31", ",", " ", "A32", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Solve", " ", "A21"}], " ", "=", " ", 
     RowBox[{"A31", " ", "=", " ", "0"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "A12", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "A22", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "A32", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.733605520635244*^9, 3.7336055233309937`*^9}, {
   3.739180984073751*^9, 3.739181006613659*^9}, 3.741175019498588*^9, {
   3.741175135179203*^9, 3.7411751564668093`*^9}, {3.741175883167144*^9, 
   3.74117588766191*^9}},ExpressionUUID->"8297a62d-9cb5-4314-a1a4-\
5660b40add1c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         SuperscriptBox["A11", "2"], " ", "B11"}], 
        RowBox[{"A11", " ", "A21", " ", "B11"}], 
        RowBox[{"A11", " ", "A31", " ", "B11"}]},
       {
        RowBox[{"A11", " ", "A21", " ", "B11"}], 
        RowBox[{
         SuperscriptBox["A21", "2"], " ", "B11"}], 
        RowBox[{"A21", " ", "A31", " ", "B11"}]},
       {
        RowBox[{"A11", " ", "A31", " ", "B11"}], 
        RowBox[{"A21", " ", "A31", " ", "B11"}], 
        RowBox[{
         SuperscriptBox["A31", "2"], " ", "B11"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`A11^2 $CellContext`B11, $CellContext`A11 \
$CellContext`A21 $CellContext`B11, $CellContext`A11 $CellContext`A31 \
$CellContext`B11}, {$CellContext`A11 $CellContext`A21 $CellContext`B11, \
$CellContext`A21^2 $CellContext`B11, $CellContext`A21 $CellContext`A31 \
$CellContext`B11}, {$CellContext`A11 $CellContext`A31 $CellContext`B11, \
$CellContext`A21 $CellContext`A31 $CellContext`B11, $CellContext`A31^2 \
$CellContext`B11}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733605534765729*^9, 3.73918100746874*^9, 3.7411744738039503`*^9, {
   3.7411751362978773`*^9, 3.7411751584807873`*^9}, 
   3.741175888386294*^9},ExpressionUUID->"559cead5-b318-4a9b-b1ba-\
25dd588346a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         SuperscriptBox["A11", "2"], " ", "B11"}], "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`A11^2 $CellContext`B11, 0, 0}, {0, 0, 0}, {0, 0, 
     0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733605534765729*^9, 3.73918100746874*^9, 3.7411744738039503`*^9, {
   3.7411751362978773`*^9, 3.7411751584807873`*^9}, 
   3.741175888388856*^9},ExpressionUUID->"ed79ebde-40ed-4445-9bd8-\
b636ebd67f31"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.741174354444091*^9, 3.741174358140016*^9}, 
   3.741175010823831*^9},ExpressionUUID->"3dfa2d17-c72d-4939-a59e-\
b760f5ba6fe7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Determination", " ", "of", " ", "the", " ", "action", " ", "set", " ", 
    "for", " ", "the", " ", "pair", " ", 
    RowBox[{"(", 
     RowBox[{"O22", ",", " ", "OD11"}], ")"}]}], " ", "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", 
      "d"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O22", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OD11", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "b", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"c", ",", " ", "d", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A31", ",", " ", "A32", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Solve", "  ", "A31"}], " ", "=", " ", 
     RowBox[{"A32", " ", "=", " ", "0"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "b", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"c", ",", " ", "d", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", " ", 
         RowBox[{"c", " ", "*", "lam", "*", " ", "ell"}], ",", " ", "A13"}], 
        "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"c", ",", " ", 
         RowBox[{"a", "*", " ", "lam"}], ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.733605646530445*^9, 3.7336056984104013`*^9}, {
   3.733608543713759*^9, 3.733608584400038*^9}, {3.73918170892096*^9, 
   3.73918173339599*^9}, 3.741175012522768*^9, {3.7411751682669973`*^9, 
   3.741175241202142*^9}, {3.7411759345261*^9, 3.74117594165366*^9}, {
   3.7411760327573347`*^9, 
   3.741176070156642*^9}},ExpressionUUID->"0ec5abc2-128b-451e-8e56-\
c89aec7b6dba"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"2", " ", "a", " ", "b", " ", "B11"}], 
        RowBox[{
         RowBox[{"b", " ", "B11", " ", "c"}], "+", 
         RowBox[{"a", " ", "B11", " ", "d"}]}], 
        RowBox[{
         RowBox[{"a", " ", "A32", " ", "B11"}], "+", 
         RowBox[{"A31", " ", "b", " ", "B11"}]}]},
       {
        RowBox[{
         RowBox[{"b", " ", "B11", " ", "c"}], "+", 
         RowBox[{"a", " ", "B11", " ", "d"}]}], 
        RowBox[{"2", " ", "B11", " ", "c", " ", "d"}], 
        RowBox[{
         RowBox[{"A32", " ", "B11", " ", "c"}], "+", 
         RowBox[{"A31", " ", "B11", " ", "d"}]}]},
       {
        RowBox[{
         RowBox[{"a", " ", "A32", " ", "B11"}], "+", 
         RowBox[{"A31", " ", "b", " ", "B11"}]}], 
        RowBox[{
         RowBox[{"A32", " ", "B11", " ", "c"}], "+", 
         RowBox[{"A31", " ", "B11", " ", "d"}]}], 
        RowBox[{"2", " ", "A31", " ", "A32", " ", "B11"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     2 $CellContext`a $CellContext`b $CellContext`B11, $CellContext`b \
$CellContext`B11 $CellContext`c + $CellContext`a $CellContext`B11 \
$CellContext`d, $CellContext`a $CellContext`A32 $CellContext`B11 + \
$CellContext`A31 $CellContext`b $CellContext`B11}, {$CellContext`b \
$CellContext`B11 $CellContext`c + $CellContext`a $CellContext`B11 \
$CellContext`d, 
      2 $CellContext`B11 $CellContext`c $CellContext`d, $CellContext`A32 \
$CellContext`B11 $CellContext`c + $CellContext`A31 $CellContext`B11 \
$CellContext`d}, {$CellContext`a $CellContext`A32 $CellContext`B11 + \
$CellContext`A31 $CellContext`b $CellContext`B11, $CellContext`A32 \
$CellContext`B11 $CellContext`c + $CellContext`A31 $CellContext`B11 \
$CellContext`d, 2 $CellContext`A31 $CellContext`A32 $CellContext`B11}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733605716423895*^9, {3.733608545034822*^9, 3.73360858484206*^9}, 
   3.7391817362318697`*^9, 3.74117447036694*^9, 3.741175219678639*^9, {
   3.741175935682764*^9, 3.741175942540942*^9}, 
   3.7411760716182404`*^9},ExpressionUUID->"40025a86-fd2f-469b-8449-\
bd735f70df55"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"2", " ", "a", " ", "b", " ", "B11"}], 
        RowBox[{
         RowBox[{"b", " ", "B11", " ", "c"}], "+", 
         RowBox[{"a", " ", "B11", " ", "d"}]}], "0"},
       {
        RowBox[{
         RowBox[{"b", " ", "B11", " ", "c"}], "+", 
         RowBox[{"a", " ", "B11", " ", "d"}]}], 
        RowBox[{"2", " ", "B11", " ", "c", " ", "d"}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     2 $CellContext`a $CellContext`b $CellContext`B11, $CellContext`b \
$CellContext`B11 $CellContext`c + $CellContext`a $CellContext`B11 \
$CellContext`d, 
      0}, {$CellContext`b $CellContext`B11 $CellContext`c + $CellContext`a \
$CellContext`B11 $CellContext`d, 
      2 $CellContext`B11 $CellContext`c $CellContext`d, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733605716423895*^9, {3.733608545034822*^9, 3.73360858484206*^9}, 
   3.7391817362318697`*^9, 3.74117447036694*^9, 3.741175219678639*^9, {
   3.741175935682764*^9, 3.741175942540942*^9}, 
   3.741176071620929*^9},ExpressionUUID->"50564280-68a7-4e7d-82fc-\
60fea2461269"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"2", " ", "a", " ", "B11", " ", "c", " ", "ell", " ", "lam"}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B11", " ", "lam"}], "+", 
         RowBox[{"B11", " ", 
          SuperscriptBox["c", "2"], " ", "ell", " ", "lam"}]}], "0"},
       {
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B11", " ", "lam"}], "+", 
         RowBox[{"B11", " ", 
          SuperscriptBox["c", "2"], " ", "ell", " ", "lam"}]}], 
        RowBox[{"2", " ", "a", " ", "B11", " ", "c", " ", "lam"}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     2 $CellContext`a $CellContext`B11 $CellContext`c $CellContext`ell \
$CellContext`lam, $CellContext`a^2 $CellContext`B11 $CellContext`lam + \
$CellContext`B11 $CellContext`c^2 $CellContext`ell $CellContext`lam, 
      0}, {$CellContext`a^2 $CellContext`B11 $CellContext`lam + \
$CellContext`B11 $CellContext`c^2 $CellContext`ell $CellContext`lam, 
      2 $CellContext`a $CellContext`B11 $CellContext`c $CellContext`lam, 0}, {
     0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733605716423895*^9, {3.733608545034822*^9, 3.73360858484206*^9}, 
   3.7391817362318697`*^9, 3.74117447036694*^9, 3.741175219678639*^9, {
   3.741175935682764*^9, 3.741175942540942*^9}, 
   3.741176071623207*^9},ExpressionUUID->"55c0d76f-53ce-43ed-8c74-\
58ba8a5c01db"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.74117440090796*^9, 3.7411744049958353`*^9}, {
  3.7411749920637712`*^9, 
  3.741175000159841*^9}},ExpressionUUID->"dfac9571-7440-4b0e-b5a3-\
f6747dff692c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Determination", " ", "of", " ", "the", " ", "action", " ", "set", " ", 
    "for", " ", "the", " ", "pair", " ", 
    RowBox[{"(", 
     RowBox[{"O22", ",", " ", "OD2"}], ")"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", 
      "d"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O22", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OD2", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ell", ",", " ", "beta", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"beta", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "b", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"c", ",", " ", "d", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A31", ",", " ", "A32", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Solve", "  ", "A31"}], " ", "=", " ", 
     RowBox[{"A32", " ", "=", " ", "0"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "b", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"c", ",", " ", "d", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.733605851273281*^9, 3.733605860448895*^9}, 
   3.733605987186262*^9, {3.739182300308847*^9, 3.739182320444956*^9}, {
   3.741174994251725*^9, 3.741175002499016*^9}, {3.741175266178143*^9, 
   3.7411752905619993`*^9}, {3.741176182181528*^9, 3.741176204836093*^9}, 
   3.7411762518995457`*^9},ExpressionUUID->"0a9f9f0f-76c4-4577-8f41-\
4e0d28211652"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "B11"}], "+", 
         RowBox[{"2", " ", "a", " ", "b", " ", "B11", " ", "beta"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B11", " ", "ell"}]}], 
        RowBox[{
         RowBox[{"b", " ", "B11", " ", "beta", " ", "c"}], "+", 
         RowBox[{"b", " ", "B11", " ", "d"}], "+", 
         RowBox[{"a", " ", "B11", " ", "beta", " ", "d"}], "+", 
         RowBox[{"a", " ", "B11", " ", "c", " ", "ell"}]}], 
        RowBox[{
         RowBox[{"A32", " ", "b", " ", "B11"}], "+", 
         RowBox[{"a", " ", "A32", " ", "B11", " ", "beta"}], "+", 
         RowBox[{"A31", " ", "b", " ", "B11", " ", "beta"}], "+", 
         RowBox[{"a", " ", "A31", " ", "B11", " ", "ell"}]}]},
       {
        RowBox[{
         RowBox[{"b", " ", "B11", " ", "beta", " ", "c"}], "+", 
         RowBox[{"b", " ", "B11", " ", "d"}], "+", 
         RowBox[{"a", " ", "B11", " ", "beta", " ", "d"}], "+", 
         RowBox[{"a", " ", "B11", " ", "c", " ", "ell"}]}], 
        RowBox[{
         RowBox[{"2", " ", "B11", " ", "beta", " ", "c", " ", "d"}], "+", 
         RowBox[{"B11", " ", 
          SuperscriptBox["d", "2"]}], "+", 
         RowBox[{"B11", " ", 
          SuperscriptBox["c", "2"], " ", "ell"}]}], 
        RowBox[{
         RowBox[{"A32", " ", "B11", " ", "beta", " ", "c"}], "+", 
         RowBox[{"A32", " ", "B11", " ", "d"}], "+", 
         RowBox[{"A31", " ", "B11", " ", "beta", " ", "d"}], "+", 
         RowBox[{"A31", " ", "B11", " ", "c", " ", "ell"}]}]},
       {
        RowBox[{
         RowBox[{"A32", " ", "b", " ", "B11"}], "+", 
         RowBox[{"a", " ", "A32", " ", "B11", " ", "beta"}], "+", 
         RowBox[{"A31", " ", "b", " ", "B11", " ", "beta"}], "+", 
         RowBox[{"a", " ", "A31", " ", "B11", " ", "ell"}]}], 
        RowBox[{
         RowBox[{"A32", " ", "B11", " ", "beta", " ", "c"}], "+", 
         RowBox[{"A32", " ", "B11", " ", "d"}], "+", 
         RowBox[{"A31", " ", "B11", " ", "beta", " ", "d"}], "+", 
         RowBox[{"A31", " ", "B11", " ", "c", " ", "ell"}]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["A32", "2"], " ", "B11"}], "+", 
         RowBox[{"2", " ", "A31", " ", "A32", " ", "B11", " ", "beta"}], "+", 
         
         RowBox[{
          SuperscriptBox["A31", "2"], " ", "B11", " ", "ell"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`b^2 $CellContext`B11 + 
      2 $CellContext`a $CellContext`b $CellContext`B11 $CellContext`beta + \
$CellContext`a^2 $CellContext`B11 $CellContext`ell, $CellContext`b \
$CellContext`B11 $CellContext`beta $CellContext`c + $CellContext`b \
$CellContext`B11 $CellContext`d + $CellContext`a $CellContext`B11 \
$CellContext`beta $CellContext`d + $CellContext`a $CellContext`B11 \
$CellContext`c $CellContext`ell, $CellContext`A32 $CellContext`b \
$CellContext`B11 + $CellContext`a $CellContext`A32 $CellContext`B11 \
$CellContext`beta + $CellContext`A31 $CellContext`b $CellContext`B11 \
$CellContext`beta + $CellContext`a $CellContext`A31 $CellContext`B11 \
$CellContext`ell}, {$CellContext`b $CellContext`B11 $CellContext`beta \
$CellContext`c + $CellContext`b $CellContext`B11 $CellContext`d + \
$CellContext`a $CellContext`B11 $CellContext`beta $CellContext`d + \
$CellContext`a $CellContext`B11 $CellContext`c $CellContext`ell, 
      2 $CellContext`B11 $CellContext`beta $CellContext`c $CellContext`d + \
$CellContext`B11 $CellContext`d^2 + $CellContext`B11 $CellContext`c^2 \
$CellContext`ell, $CellContext`A32 $CellContext`B11 $CellContext`beta \
$CellContext`c + $CellContext`A32 $CellContext`B11 $CellContext`d + \
$CellContext`A31 $CellContext`B11 $CellContext`beta $CellContext`d + \
$CellContext`A31 $CellContext`B11 $CellContext`c $CellContext`ell}, \
{$CellContext`A32 $CellContext`b $CellContext`B11 + $CellContext`a \
$CellContext`A32 $CellContext`B11 $CellContext`beta + $CellContext`A31 \
$CellContext`b $CellContext`B11 $CellContext`beta + $CellContext`a \
$CellContext`A31 $CellContext`B11 $CellContext`ell, $CellContext`A32 \
$CellContext`B11 $CellContext`beta $CellContext`c + $CellContext`A32 \
$CellContext`B11 $CellContext`d + $CellContext`A31 $CellContext`B11 \
$CellContext`beta $CellContext`d + $CellContext`A31 $CellContext`B11 \
$CellContext`c $CellContext`ell, $CellContext`A32^2 $CellContext`B11 + 
      2 $CellContext`A31 $CellContext`A32 $CellContext`B11 $CellContext`beta + \
$CellContext`A31^2 $CellContext`B11 $CellContext`ell}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733605883334639*^9, 3.739182325157131*^9, 3.741174466567523*^9, 
   3.74117529155569*^9, {3.741176183477457*^9, 
   3.741176206013628*^9}},ExpressionUUID->"a81bf7d9-2085-4013-8f8e-\
1070dff946a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "B11"}], "+", 
         RowBox[{"2", " ", "a", " ", "b", " ", "B11", " ", "beta"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B11", " ", "ell"}]}], 
        RowBox[{
         RowBox[{"b", " ", "B11", " ", "beta", " ", "c"}], "+", 
         RowBox[{"b", " ", "B11", " ", "d"}], "+", 
         RowBox[{"a", " ", "B11", " ", "beta", " ", "d"}], "+", 
         RowBox[{"a", " ", "B11", " ", "c", " ", "ell"}]}], "0"},
       {
        RowBox[{
         RowBox[{"b", " ", "B11", " ", "beta", " ", "c"}], "+", 
         RowBox[{"b", " ", "B11", " ", "d"}], "+", 
         RowBox[{"a", " ", "B11", " ", "beta", " ", "d"}], "+", 
         RowBox[{"a", " ", "B11", " ", "c", " ", "ell"}]}], 
        RowBox[{
         RowBox[{"2", " ", "B11", " ", "beta", " ", "c", " ", "d"}], "+", 
         RowBox[{"B11", " ", 
          SuperscriptBox["d", "2"]}], "+", 
         RowBox[{"B11", " ", 
          SuperscriptBox["c", "2"], " ", "ell"}]}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`b^2 $CellContext`B11 + 
      2 $CellContext`a $CellContext`b $CellContext`B11 $CellContext`beta + \
$CellContext`a^2 $CellContext`B11 $CellContext`ell, $CellContext`b \
$CellContext`B11 $CellContext`beta $CellContext`c + $CellContext`b \
$CellContext`B11 $CellContext`d + $CellContext`a $CellContext`B11 \
$CellContext`beta $CellContext`d + $CellContext`a $CellContext`B11 \
$CellContext`c $CellContext`ell, 
      0}, {$CellContext`b $CellContext`B11 $CellContext`beta $CellContext`c + \
$CellContext`b $CellContext`B11 $CellContext`d + $CellContext`a \
$CellContext`B11 $CellContext`beta $CellContext`d + $CellContext`a \
$CellContext`B11 $CellContext`c $CellContext`ell, 
      2 $CellContext`B11 $CellContext`beta $CellContext`c $CellContext`d + \
$CellContext`B11 $CellContext`d^2 + $CellContext`B11 $CellContext`c^2 \
$CellContext`ell, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733605883334639*^9, 3.739182325157131*^9, 3.741174466567523*^9, 
   3.74117529155569*^9, {3.741176183477457*^9, 
   3.741176206017264*^9}},ExpressionUUID->"8cb27f26-5abf-42db-9159-\
c96c271ff4b8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Determination", " ", "of", " ", "the", " ", "action", " ", "set", " ", 
    "for", " ", "the", " ", "pair", " ", 
    RowBox[{"(", 
     RowBox[{"O1212", ",", " ", "OD12"}], ")"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", 
      "d"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O1212", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OD12", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "A12", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A21", ",", " ", "A22", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A31", ",", " ", "A32", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"Solve", " ", "B21"}], " ", "=", " ", "0"}], ",", "  ", 
     RowBox[{"A31", " ", "=", " ", 
      RowBox[{"A11A21", " ", "=", " ", "0"}]}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "A12", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A21", ",", " ", "A22", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "A32", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.733606308029896*^9, 3.7336063785181026`*^9}, {
   3.739183790819064*^9, 3.739183825434854*^9}, {3.741174443694429*^9, 
   3.7411744521956472`*^9}, {3.7411753095555067`*^9, 3.741175318401092*^9}, {
   3.741175398720649*^9, 3.741175399432618*^9}, 3.7411755092403708`*^9, {
   3.741176299539152*^9, 
   3.741176332778678*^9}},ExpressionUUID->"85560b02-052a-40b5-a69f-\
2c5d74275d43"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         SuperscriptBox["A11", "2"], " ", "B11"}], 
        RowBox[{"A11", " ", "A21", " ", "B11"}], 
        RowBox[{"A11", " ", "A31", " ", "B11"}]},
       {
        RowBox[{"A11", " ", "A21", " ", "B11"}], 
        RowBox[{
         SuperscriptBox["A21", "2"], " ", "B11"}], 
        RowBox[{"A21", " ", "A31", " ", "B11"}]},
       {
        RowBox[{"A11", " ", "A31", " ", "B11"}], 
        RowBox[{"A21", " ", "A31", " ", "B11"}], 
        RowBox[{
         SuperscriptBox["A31", "2"], " ", "B11"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`A11^2 $CellContext`B11, $CellContext`A11 \
$CellContext`A21 $CellContext`B11, $CellContext`A11 $CellContext`A31 \
$CellContext`B11}, {$CellContext`A11 $CellContext`A21 $CellContext`B11, \
$CellContext`A21^2 $CellContext`B11, $CellContext`A21 $CellContext`A31 \
$CellContext`B11}, {$CellContext`A11 $CellContext`A31 $CellContext`B11, \
$CellContext`A21 $CellContext`A31 $CellContext`B11, $CellContext`A31^2 \
$CellContext`B11}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7336063652962437`*^9, 3.733606379071175*^9}, 
   3.7391838264383717`*^9, 3.741173877874484*^9, 3.741174462617601*^9, 
   3.741176300181107*^9},ExpressionUUID->"4a896243-9f2b-41c2-8510-\
1d4c445cf723"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{
         SuperscriptBox["A21", "2"], " ", "B11"}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, $CellContext`A21^2 $CellContext`B11, 0}, {0, 0, 
     0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7336063652962437`*^9, 3.733606379071175*^9}, 
   3.7391838264383717`*^9, 3.741173877874484*^9, 3.741174462617601*^9, 
   3.741176300183835*^9},ExpressionUUID->"d32e4764-a649-4cbf-80e8-\
9b4b4852107c"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.7411739270125923`*^9, 
  3.741173927190843*^9}},ExpressionUUID->"b2f2703e-e866-410e-853d-\
29dc1f0d47e6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Determination", " ", "of", " ", "the", " ", "action", " ", "set", " ", 
    "for", " ", "the", " ", "pair", " ", 
    RowBox[{"(", 
     RowBox[{"O1212", ",", " ", "OD11"}], ")"}]}], " ", "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", 
      "d"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O1212", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OD11", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "A12", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A21", ",", " ", "A22", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A31", ",", " ", "A32", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Solve", " ", "A31"}], " ", "=", " ", 
     RowBox[{"A32", " ", "=", " ", "0"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "A12", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A21", ",", " ", "A22", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.733606463821232*^9, 3.733606486093235*^9}, {
   3.739184366258132*^9, 3.73918439007409*^9}, {3.741174495364382*^9, 
   3.741174504979204*^9}, {3.741176374756139*^9, 3.7411764022900133`*^9}, 
   3.741176442140291*^9},ExpressionUUID->"3c5a85ce-01fe-4143-bd8e-\
993fcca09ca3"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{
          SuperscriptBox["A11", "2"], " ", "B11"}], "-", 
         RowBox[{
          SuperscriptBox["A12", "2"], " ", "B11"}]}], 
        RowBox[{
         RowBox[{"A11", " ", "A21", " ", "B11"}], "-", 
         RowBox[{"A12", " ", "A22", " ", "B11"}]}], 
        RowBox[{
         RowBox[{"A11", " ", "A31", " ", "B11"}], "-", 
         RowBox[{"A12", " ", "A32", " ", "B11"}]}]},
       {
        RowBox[{
         RowBox[{"A11", " ", "A21", " ", "B11"}], "-", 
         RowBox[{"A12", " ", "A22", " ", "B11"}]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["A21", "2"], " ", "B11"}], "-", 
         RowBox[{
          SuperscriptBox["A22", "2"], " ", "B11"}]}], 
        RowBox[{
         RowBox[{"A21", " ", "A31", " ", "B11"}], "-", 
         RowBox[{"A22", " ", "A32", " ", "B11"}]}]},
       {
        RowBox[{
         RowBox[{"A11", " ", "A31", " ", "B11"}], "-", 
         RowBox[{"A12", " ", "A32", " ", "B11"}]}], 
        RowBox[{
         RowBox[{"A21", " ", "A31", " ", "B11"}], "-", 
         RowBox[{"A22", " ", "A32", " ", "B11"}]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["A31", "2"], " ", "B11"}], "-", 
         RowBox[{
          SuperscriptBox["A32", "2"], " ", "B11"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`A11^2 $CellContext`B11 - $CellContext`A12^2 \
$CellContext`B11, $CellContext`A11 $CellContext`A21 $CellContext`B11 - \
$CellContext`A12 $CellContext`A22 $CellContext`B11, $CellContext`A11 \
$CellContext`A31 $CellContext`B11 - $CellContext`A12 $CellContext`A32 \
$CellContext`B11}, {$CellContext`A11 $CellContext`A21 $CellContext`B11 - \
$CellContext`A12 $CellContext`A22 $CellContext`B11, $CellContext`A21^2 \
$CellContext`B11 - $CellContext`A22^2 $CellContext`B11, $CellContext`A21 \
$CellContext`A31 $CellContext`B11 - $CellContext`A22 $CellContext`A32 \
$CellContext`B11}, {$CellContext`A11 $CellContext`A31 $CellContext`B11 - \
$CellContext`A12 $CellContext`A32 $CellContext`B11, $CellContext`A21 \
$CellContext`A31 $CellContext`B11 - $CellContext`A22 $CellContext`A32 \
$CellContext`B11, $CellContext`A31^2 $CellContext`B11 - $CellContext`A32^2 \
$CellContext`B11}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733606501760504*^9, 3.739184390865855*^9, 3.74117451125852*^9, {
   3.741176375173767*^9, 3.741176403222457*^9}, 
   3.741176444665509*^9},ExpressionUUID->"d3a9960e-64f2-4799-bf34-\
b7d96d3a85b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{
          SuperscriptBox["A11", "2"], " ", "B11"}], "-", 
         RowBox[{
          SuperscriptBox["A12", "2"], " ", "B11"}]}], 
        RowBox[{
         RowBox[{"A11", " ", "A21", " ", "B11"}], "-", 
         RowBox[{"A12", " ", "A22", " ", "B11"}]}], "0"},
       {
        RowBox[{
         RowBox[{"A11", " ", "A21", " ", "B11"}], "-", 
         RowBox[{"A12", " ", "A22", " ", "B11"}]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["A21", "2"], " ", "B11"}], "-", 
         RowBox[{
          SuperscriptBox["A22", "2"], " ", "B11"}]}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`A11^2 $CellContext`B11 - $CellContext`A12^2 \
$CellContext`B11, $CellContext`A11 $CellContext`A21 $CellContext`B11 - \
$CellContext`A12 $CellContext`A22 $CellContext`B11, 
      0}, {$CellContext`A11 $CellContext`A21 $CellContext`B11 - \
$CellContext`A12 $CellContext`A22 $CellContext`B11, $CellContext`A21^2 \
$CellContext`B11 - $CellContext`A22^2 $CellContext`B11, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733606501760504*^9, 3.739184390865855*^9, 3.74117451125852*^9, {
   3.741176375173767*^9, 3.741176403222457*^9}, 
   3.741176444668659*^9},ExpressionUUID->"3efda3d7-1749-45d6-9549-\
2dc03e4e15ae"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Determination", " ", "of", " ", "the", " ", "action", " ", "set", " ", 
    "for", " ", "the", " ", "pair", " ", 
    RowBox[{"(", 
     RowBox[{"O1212", ",", " ", "OD2"}], ")"}]}], " ", "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", 
      "d"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O1212", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OD2", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "ell"}], ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "b", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"c", ",", " ", "d", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A31", ",", " ", "A32", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Solve", " ", "A31"}], " ", "=", " ", 
     RowBox[{"A32", " ", "=", " ", "0"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "b", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"c", ",", " ", "d", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Check", " ", "the", " ", "parametrization"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", " ", 
         RowBox[{"c", "*", "ell"}], ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"c", "*", " ", "lam"}], ",", " ", 
         RowBox[{"a", "*", "lam"}], ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.733607239968484*^9, 3.733607255144454*^9}, {
  3.7391858228165493`*^9, 3.7391858432084217`*^9}, {3.739186661940773*^9, 
  3.739186670835291*^9}, {3.7411745814758263`*^9, 3.7411745879789457`*^9}, {
  3.7411764537962313`*^9, 3.741176522835869*^9}, {3.7411765718735943`*^9, 
  3.74117657721698*^9}, {3.741176641297078*^9, 3.741176644328512*^9}, {
  3.741176716200615*^9, 
  3.741176759808983*^9}},ExpressionUUID->"d8413412-d696-4e64-aeca-\
eaa0325bde1a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "B11"}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B11", " ", "ell"}]}], 
        RowBox[{
         RowBox[{"b", " ", "B11", " ", "d"}], "-", 
         RowBox[{"a", " ", "B11", " ", "c", " ", "ell"}]}], 
        RowBox[{
         RowBox[{"A32", " ", "b", " ", "B11"}], "-", 
         RowBox[{"a", " ", "A31", " ", "B11", " ", "ell"}]}]},
       {
        RowBox[{
         RowBox[{"b", " ", "B11", " ", "d"}], "-", 
         RowBox[{"a", " ", "B11", " ", "c", " ", "ell"}]}], 
        RowBox[{
         RowBox[{"B11", " ", 
          SuperscriptBox["d", "2"]}], "-", 
         RowBox[{"B11", " ", 
          SuperscriptBox["c", "2"], " ", "ell"}]}], 
        RowBox[{
         RowBox[{"A32", " ", "B11", " ", "d"}], "-", 
         RowBox[{"A31", " ", "B11", " ", "c", " ", "ell"}]}]},
       {
        RowBox[{
         RowBox[{"A32", " ", "b", " ", "B11"}], "-", 
         RowBox[{"a", " ", "A31", " ", "B11", " ", "ell"}]}], 
        RowBox[{
         RowBox[{"A32", " ", "B11", " ", "d"}], "-", 
         RowBox[{"A31", " ", "B11", " ", "c", " ", "ell"}]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["A32", "2"], " ", "B11"}], "-", 
         RowBox[{
          SuperscriptBox["A31", "2"], " ", "B11", " ", "ell"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`b^2 $CellContext`B11 - $CellContext`a^2 \
$CellContext`B11 $CellContext`ell, $CellContext`b $CellContext`B11 \
$CellContext`d - $CellContext`a $CellContext`B11 $CellContext`c \
$CellContext`ell, $CellContext`A32 $CellContext`b $CellContext`B11 - \
$CellContext`a $CellContext`A31 $CellContext`B11 $CellContext`ell}, \
{$CellContext`b $CellContext`B11 $CellContext`d - $CellContext`a \
$CellContext`B11 $CellContext`c $CellContext`ell, $CellContext`B11 \
$CellContext`d^2 - $CellContext`B11 $CellContext`c^2 $CellContext`ell, \
$CellContext`A32 $CellContext`B11 $CellContext`d - $CellContext`A31 \
$CellContext`B11 $CellContext`c $CellContext`ell}, {$CellContext`A32 \
$CellContext`b $CellContext`B11 - $CellContext`a $CellContext`A31 \
$CellContext`B11 $CellContext`ell, $CellContext`A32 $CellContext`B11 \
$CellContext`d - $CellContext`A31 $CellContext`B11 $CellContext`c \
$CellContext`ell, $CellContext`A32^2 $CellContext`B11 - $CellContext`A31^2 \
$CellContext`B11 $CellContext`ell}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733607255820569*^9, 3.7391858440632467`*^9, 3.73918667175375*^9, 
   3.7411745892688932`*^9, {3.741176476204567*^9, 3.741176500641727*^9}, 
   3.74117673794912*^9},ExpressionUUID->"9b28c37f-50ed-4b48-93bf-\
2c92c280c0d1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "B11"}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B11", " ", "ell"}]}], 
        RowBox[{
         RowBox[{"b", " ", "B11", " ", "d"}], "-", 
         RowBox[{"a", " ", "B11", " ", "c", " ", "ell"}]}], "0"},
       {
        RowBox[{
         RowBox[{"b", " ", "B11", " ", "d"}], "-", 
         RowBox[{"a", " ", "B11", " ", "c", " ", "ell"}]}], 
        RowBox[{
         RowBox[{"B11", " ", 
          SuperscriptBox["d", "2"]}], "-", 
         RowBox[{"B11", " ", 
          SuperscriptBox["c", "2"], " ", "ell"}]}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`b^2 $CellContext`B11 - $CellContext`a^2 \
$CellContext`B11 $CellContext`ell, $CellContext`b $CellContext`B11 \
$CellContext`d - $CellContext`a $CellContext`B11 $CellContext`c \
$CellContext`ell, 
      0}, {$CellContext`b $CellContext`B11 $CellContext`d - $CellContext`a \
$CellContext`B11 $CellContext`c $CellContext`ell, $CellContext`B11 \
$CellContext`d^2 - $CellContext`B11 $CellContext`c^2 $CellContext`ell, 0}, {0,
      0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733607255820569*^9, 3.7391858440632467`*^9, 3.73918667175375*^9, 
   3.7411745892688932`*^9, {3.741176476204567*^9, 3.741176500641727*^9}, 
   3.741176737953164*^9},ExpressionUUID->"d223b6aa-12d1-4505-b4f8-\
9ea92616047d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "2"]}], " ", "B11", " ", "ell"}], "+", 
         RowBox[{"B11", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["ell", "2"]}]}], "0", "0"},
       {"0", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B11", " ", 
          SuperscriptBox["lam", "2"]}], "-", 
         RowBox[{"B11", " ", 
          SuperscriptBox["c", "2"], " ", "ell", " ", 
          SuperscriptBox["lam", "2"]}]}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{-$CellContext`a^2 $CellContext`B11 $CellContext`ell + \
$CellContext`B11 $CellContext`c^2 $CellContext`ell^2, 0, 0}, {
     0, $CellContext`a^2 $CellContext`B11 $CellContext`lam^2 - \
$CellContext`B11 $CellContext`c^2 $CellContext`ell $CellContext`lam^2, 0}, {0,
      0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733607255820569*^9, 3.7391858440632467`*^9, 3.73918667175375*^9, 
   3.7411745892688932`*^9, {3.741176476204567*^9, 3.741176500641727*^9}, 
   3.741176737988332*^9},ExpressionUUID->"251a758a-37a0-46c9-89ff-\
413d9873cc07"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Determination", " ", "of", " ", "the", " ", "action", " ", "set", " ", 
    "for", " ", "the", " ", "pair", " ", 
    RowBox[{"(", 
     RowBox[{"O131", ",", " ", "OD12"}], ")"}]}], " ", "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", 
      "d"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O131", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OD12", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "A12", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A21", ",", " ", "A22", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A31", ",", " ", "A32", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Solve", " ", "A21"}], " ", "=", " ", 
     RowBox[{"A31", " ", "=", " ", "0"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "A12", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "A22", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "A32", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.733607841467486*^9, 3.7336078674641247`*^9}, {
  3.739187693195972*^9, 3.739187712539877*^9}, {3.741174596420198*^9, 
  3.741174600970458*^9}, {3.741176783543434*^9, 
  3.741176809982992*^9}},ExpressionUUID->"0def8c1e-d5bb-439c-a175-\
8ea525da4ddf"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         SuperscriptBox["A11", "2"], " ", "B11"}], 
        RowBox[{"A11", " ", "A21", " ", "B11"}], 
        RowBox[{"A11", " ", "A31", " ", "B11"}]},
       {
        RowBox[{"A11", " ", "A21", " ", "B11"}], 
        RowBox[{
         SuperscriptBox["A21", "2"], " ", "B11"}], 
        RowBox[{"A21", " ", "A31", " ", "B11"}]},
       {
        RowBox[{"A11", " ", "A31", " ", "B11"}], 
        RowBox[{"A21", " ", "A31", " ", "B11"}], 
        RowBox[{
         SuperscriptBox["A31", "2"], " ", "B11"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         SuperscriptBox["A11", "2"], " ", "B21"}], 
        RowBox[{"A11", " ", "A21", " ", "B21"}], 
        RowBox[{"A11", " ", "A31", " ", "B21"}]},
       {
        RowBox[{"A11", " ", "A21", " ", "B21"}], 
        RowBox[{
         SuperscriptBox["A21", "2"], " ", "B21"}], 
        RowBox[{"A21", " ", "A31", " ", "B21"}]},
       {
        RowBox[{"A11", " ", "A31", " ", "B21"}], 
        RowBox[{"A21", " ", "A31", " ", "B21"}], 
        RowBox[{
         SuperscriptBox["A31", "2"], " ", "B21"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`A11^2 $CellContext`B11, $CellContext`A11 \
$CellContext`A21 $CellContext`B11, $CellContext`A11 $CellContext`A31 \
$CellContext`B11}, {$CellContext`A11 $CellContext`A21 $CellContext`B11, \
$CellContext`A21^2 $CellContext`B11, $CellContext`A21 $CellContext`A31 \
$CellContext`B11}, {$CellContext`A11 $CellContext`A31 $CellContext`B11, \
$CellContext`A21 $CellContext`A31 $CellContext`B11, $CellContext`A31^2 \
$CellContext`B11}}], 
   MatrixForm[{{$CellContext`A11^2 $CellContext`B21, $CellContext`A11 \
$CellContext`A21 $CellContext`B21, $CellContext`A11 $CellContext`A31 \
$CellContext`B21}, {$CellContext`A11 $CellContext`A21 $CellContext`B21, \
$CellContext`A21^2 $CellContext`B21, $CellContext`A21 $CellContext`A31 \
$CellContext`B21}, {$CellContext`A11 $CellContext`A31 $CellContext`B21, \
$CellContext`A21 $CellContext`A31 $CellContext`B21, $CellContext`A31^2 \
$CellContext`B21}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733607871020248*^9, 
  3.73918771353273*^9},ExpressionUUID->"1ffd70cf-1c45-44ab-99c1-a1de8ab58b93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         SuperscriptBox["A11", "2"], " ", "B11"}], "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`A11^2 $CellContext`B11, 0, 0}, {0, 0, 0}, {0, 0, 
     0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733607871020248*^9, 
  3.7391877135346107`*^9},ExpressionUUID->"74d5bb89-44d1-41b8-8781-\
50bddde3335b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Determination", " ", "of", " ", "the", " ", "action", " ", "set", " ", 
    "for", " ", "the", " ", "pair", " ", 
    RowBox[{"(", 
     RowBox[{"O131", ",", " ", "OCs"}], ")"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", 
      "d"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O131", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OCs", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{"-", "1"}], ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "A12", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A21", ",", " ", "A22", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B21", " ", "*", "A1"}], " ", "+", "  ", 
       RowBox[{"B22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Solve", " ", "A21"}], " ", "=", " ", 
     RowBox[{"B21", " ", "=", " ", "0"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "A12", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "A22", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", "*", " ", "B1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Solve", " ", "B22"}], " ", "=", " ", 
     RowBox[{"A22", "*", 
      RowBox[{"B11", "/", "A11"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "A12", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "b", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"c", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"c", "/", "a"}]}], ")"}], " ", "*", " ", "B1"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.73360790402857*^9, 3.733607921300136*^9}, {
  3.733608066517687*^9, 3.733608104443557*^9}, {3.733608505226869*^9, 
  3.733608505360886*^9}, {3.739188223003356*^9, 3.739188250226987*^9}, {
  3.7391901113194838`*^9, 3.7391901312630796`*^9}, {3.741174705922159*^9, 
  3.741174714969946*^9}, {3.7411749010688753`*^9, 3.741174934601643*^9}, {
  3.741176910744331*^9, 3.741176958967059*^9}, {3.741177096982646*^9, 
  3.741177134077215*^9}, {3.7411771791435413`*^9, 
  3.7411772185659*^9}},ExpressionUUID->"7ba65186-6af9-4ec6-ad8a-c7f7f9380361"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "A11", " ", "A12", " ", "B11"}], "+", 
         RowBox[{
          SuperscriptBox["A11", "2"], " ", "B12"}]}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "A12"}], " ", "A21", " ", "B11"}], "-", 
         RowBox[{"A11", " ", "A22", " ", "B11"}], "+", 
         RowBox[{"A11", " ", "A21", " ", "B12"}]}], "0"},
       {
        RowBox[{
         RowBox[{
          RowBox[{"-", "A12"}], " ", "A21", " ", "B11"}], "-", 
         RowBox[{"A11", " ", "A22", " ", "B11"}], "+", 
         RowBox[{"A11", " ", "A21", " ", "B12"}]}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "A21", " ", "A22", " ", "B11"}], "+", 
         RowBox[{
          SuperscriptBox["A21", "2"], " ", "B12"}]}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "A11", " ", "A12", " ", "B21"}], "+", 
         RowBox[{
          SuperscriptBox["A11", "2"], " ", "B22"}]}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "A12"}], " ", "A21", " ", "B21"}], "-", 
         RowBox[{"A11", " ", "A22", " ", "B21"}], "+", 
         RowBox[{"A11", " ", "A21", " ", "B22"}]}], "0"},
       {
        RowBox[{
         RowBox[{
          RowBox[{"-", "A12"}], " ", "A21", " ", "B21"}], "-", 
         RowBox[{"A11", " ", "A22", " ", "B21"}], "+", 
         RowBox[{"A11", " ", "A21", " ", "B22"}]}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "A21", " ", "A22", " ", "B21"}], "+", 
         RowBox[{
          SuperscriptBox["A21", "2"], " ", "B22"}]}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{(-2) $CellContext`A11 $CellContext`A12 $CellContext`B11 + \
$CellContext`A11^2 $CellContext`B12, -$CellContext`A12 $CellContext`A21 \
$CellContext`B11 - $CellContext`A11 $CellContext`A22 $CellContext`B11 + \
$CellContext`A11 $CellContext`A21 $CellContext`B12, 
      0}, {-$CellContext`A12 $CellContext`A21 $CellContext`B11 - \
$CellContext`A11 $CellContext`A22 $CellContext`B11 + $CellContext`A11 \
$CellContext`A21 $CellContext`B12, (-2) $CellContext`A21 $CellContext`A22 \
$CellContext`B11 + $CellContext`A21^2 $CellContext`B12, 0}, {0, 0, 0}}], 
   MatrixForm[{{(-2) $CellContext`A11 $CellContext`A12 $CellContext`B21 + \
$CellContext`A11^2 $CellContext`B22, -$CellContext`A12 $CellContext`A21 \
$CellContext`B21 - $CellContext`A11 $CellContext`A22 $CellContext`B21 + \
$CellContext`A11 $CellContext`A21 $CellContext`B22, 
      0}, {-$CellContext`A12 $CellContext`A21 $CellContext`B21 - \
$CellContext`A11 $CellContext`A22 $CellContext`B21 + $CellContext`A11 \
$CellContext`A21 $CellContext`B22, (-2) $CellContext`A21 $CellContext`A22 \
$CellContext`B21 + $CellContext`A21^2 $CellContext`B22, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733607923829731*^9, 3.733608068667889*^9, 3.73360810505973*^9, 
   3.733608507047495*^9, 3.739188252800354*^9, 3.7391901332079067`*^9, 
   3.741174719132142*^9, {3.7411749094158993`*^9, 3.741174935983266*^9}, 
   3.741176959489649*^9, 3.741177004653236*^9, 3.7411771348908052`*^9, 
   3.741177186212037*^9, 
   3.7411772193014593`*^9},ExpressionUUID->"df4c81c8-eece-4bc1-9533-\
9ea3e40b8fa7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "A11", " ", "A12", " ", "B11"}], "+", 
         RowBox[{
          SuperscriptBox["A11", "2"], " ", "B12"}]}], 
        RowBox[{
         RowBox[{"-", "A11"}], " ", "A22", " ", "B11"}], "0"},
       {
        RowBox[{
         RowBox[{"-", "A11"}], " ", "A22", " ", "B11"}], "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         SuperscriptBox["A11", "2"], " ", "B22"}], "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{(-2) $CellContext`A11 $CellContext`A12 $CellContext`B11 + \
$CellContext`A11^2 $CellContext`B12, -$CellContext`A11 $CellContext`A22 \
$CellContext`B11, 0}, {-$CellContext`A11 $CellContext`A22 $CellContext`B11, 0,
       0}, {0, 0, 0}}], 
   MatrixForm[{{$CellContext`A11^2 $CellContext`B22, 0, 0}, {0, 0, 0}, {0, 0, 
     0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733607923829731*^9, 3.733608068667889*^9, 3.73360810505973*^9, 
   3.733608507047495*^9, 3.739188252800354*^9, 3.7391901332079067`*^9, 
   3.741174719132142*^9, {3.7411749094158993`*^9, 3.741174935983266*^9}, 
   3.741176959489649*^9, 3.741177004653236*^9, 3.7411771348908052`*^9, 
   3.741177186212037*^9, 
   3.7411772193050013`*^9},ExpressionUUID->"0d65c9ff-393c-42c6-9ecd-\
99355db89f13"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "B12"}], "-", 
         RowBox[{"2", " ", "a", " ", "A12", " ", "c"}]}], 
        RowBox[{
         RowBox[{"-", "a"}], " ", "b", " ", "c"}], "0"},
       {
        RowBox[{
         RowBox[{"-", "a"}], " ", "b", " ", "c"}], "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"a", " ", "b", " ", "c"}], "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`a^2 $CellContext`B12 - 
      2 $CellContext`a $CellContext`A12 $CellContext`c, -$CellContext`a \
$CellContext`b $CellContext`c, 
      0}, {-$CellContext`a $CellContext`b $CellContext`c, 0, 0}, {0, 0, 0}}], 
   
   MatrixForm[{{$CellContext`a $CellContext`b $CellContext`c, 0, 0}, {0, 0, 
     0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733607923829731*^9, 3.733608068667889*^9, 3.73360810505973*^9, 
   3.733608507047495*^9, 3.739188252800354*^9, 3.7391901332079067`*^9, 
   3.741174719132142*^9, {3.7411749094158993`*^9, 3.741174935983266*^9}, 
   3.741176959489649*^9, 3.741177004653236*^9, 3.7411771348908052`*^9, 
   3.741177186212037*^9, 
   3.741177219307766*^9},ExpressionUUID->"aa09e481-06b8-4588-b993-\
feab4092fc2c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Determination", " ", "of", " ", "the", " ", "action", " ", "set", " ", 
    "for", " ", "the", " ", "pair", " ", 
    RowBox[{"(", 
     RowBox[{"O14", ",", " ", "OD12"}], ")"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", 
      "d"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O14", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OD12", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "A12", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A21", ",", "A22", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A31", ",", " ", "A32", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", "*", " ", "B1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Solve", " ", "A21"}], " ", "=", " ", 
     RowBox[{"A31", " ", "=", " ", "0"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "A12", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", "A22", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "A32", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", "*", " ", "B1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.741177231556888*^9, 3.741177259707897*^9}, {
  3.741177292133765*^9, 3.741177302811854*^9}, {3.741178131234226*^9, 
  3.741178178382691*^9}},ExpressionUUID->"02eb9d45-1644-4eef-a629-\
9f3f94603e9e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         SuperscriptBox["A11", "2"], " ", "B11"}], 
        RowBox[{"A11", " ", "A21", " ", "B11"}], 
        RowBox[{"A11", " ", "A31", " ", "B11"}]},
       {
        RowBox[{"A11", " ", "A21", " ", "B11"}], 
        RowBox[{
         SuperscriptBox["A21", "2"], " ", "B11"}], 
        RowBox[{"A21", " ", "A31", " ", "B11"}]},
       {
        RowBox[{"A11", " ", "A31", " ", "B11"}], 
        RowBox[{"A21", " ", "A31", " ", "B11"}], 
        RowBox[{
         SuperscriptBox["A31", "2"], " ", "B11"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`A11^2 $CellContext`B11, $CellContext`A11 \
$CellContext`A21 $CellContext`B11, $CellContext`A11 $CellContext`A31 \
$CellContext`B11}, {$CellContext`A11 $CellContext`A21 $CellContext`B11, \
$CellContext`A21^2 $CellContext`B11, $CellContext`A21 $CellContext`A31 \
$CellContext`B11}, {$CellContext`A11 $CellContext`A31 $CellContext`B11, \
$CellContext`A21 $CellContext`A31 $CellContext`B11, $CellContext`A31^2 \
$CellContext`B11}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7411772808499327`*^9, 3.741177304269907*^9}, 
   3.74117817877498*^9, 
   3.7411782158111687`*^9},ExpressionUUID->"3ce93fcd-f117-4173-a160-\
bd3e1331e0a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         SuperscriptBox["A11", "2"], " ", "B11"}], "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`A11^2 $CellContext`B11, 0, 0}, {0, 0, 0}, {0, 0, 
     0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7411772808499327`*^9, 3.741177304269907*^9}, 
   3.74117817877498*^9, 
   3.74117821581348*^9},ExpressionUUID->"2f6f1c35-b267-4f0b-a994-\
14769797d172"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Determination", " ", "of", " ", "the", " ", "action", " ", "set", " ", 
    "for", " ", "the", " ", "pair", " ", 
    RowBox[{"(", 
     RowBox[{"O14", ",", " ", "OD11"}], ")"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", 
      "d"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O14", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OD11", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "A12", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A21", ",", " ", "A22", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A31", ",", " ", "A32", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", "*", " ", "B1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Solve", " ", "A31"}], " ", "=", " ", 
     RowBox[{"A32", " ", "=", " ", "0"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "A12", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A21", ",", " ", "A22", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", "*", " ", "B1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.73360846920096*^9, 3.73360847680079*^9}, {
   3.73360867667161*^9, 3.7336087464075937`*^9}, {3.7411748575062933`*^9, 
   3.74117486553673*^9}, 3.741177238596157*^9, {3.741178827396267*^9, 
   3.741178890668209*^9}},ExpressionUUID->"90a02a47-3d97-453f-b963-\
c92655040e9c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"2", " ", "A11", " ", "A12", " ", "B11"}], 
        RowBox[{
         RowBox[{"A12", " ", "A21", " ", "B11"}], "+", 
         RowBox[{"A11", " ", "A22", " ", "B11"}]}], 
        RowBox[{
         RowBox[{"A12", " ", "A31", " ", "B11"}], "+", 
         RowBox[{"A11", " ", "A32", " ", "B11"}]}]},
       {
        RowBox[{
         RowBox[{"A12", " ", "A21", " ", "B11"}], "+", 
         RowBox[{"A11", " ", "A22", " ", "B11"}]}], 
        RowBox[{"2", " ", "A21", " ", "A22", " ", "B11"}], 
        RowBox[{
         RowBox[{"A22", " ", "A31", " ", "B11"}], "+", 
         RowBox[{"A21", " ", "A32", " ", "B11"}]}]},
       {
        RowBox[{
         RowBox[{"A12", " ", "A31", " ", "B11"}], "+", 
         RowBox[{"A11", " ", "A32", " ", "B11"}]}], 
        RowBox[{
         RowBox[{"A22", " ", "A31", " ", "B11"}], "+", 
         RowBox[{"A21", " ", "A32", " ", "B11"}]}], 
        RowBox[{"2", " ", "A31", " ", "A32", " ", "B11"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     2 $CellContext`A11 $CellContext`A12 $CellContext`B11, $CellContext`A12 \
$CellContext`A21 $CellContext`B11 + $CellContext`A11 $CellContext`A22 \
$CellContext`B11, $CellContext`A12 $CellContext`A31 $CellContext`B11 + \
$CellContext`A11 $CellContext`A32 $CellContext`B11}, {$CellContext`A12 \
$CellContext`A21 $CellContext`B11 + $CellContext`A11 $CellContext`A22 \
$CellContext`B11, 
      2 $CellContext`A21 $CellContext`A22 $CellContext`B11, $CellContext`A22 \
$CellContext`A31 $CellContext`B11 + $CellContext`A21 $CellContext`A32 \
$CellContext`B11}, {$CellContext`A12 $CellContext`A31 $CellContext`B11 + \
$CellContext`A11 $CellContext`A32 $CellContext`B11, $CellContext`A22 \
$CellContext`A31 $CellContext`B11 + $CellContext`A21 $CellContext`A32 \
$CellContext`B11, 2 $CellContext`A31 $CellContext`A32 $CellContext`B11}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.733608719501699*^9, 3.733608746798635*^9}, 
   3.741178891326723*^9},ExpressionUUID->"5e95ef46-fdc3-408c-888f-\
cbb0b153762d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"2", " ", "A11", " ", "A12", " ", "B11"}], 
        RowBox[{
         RowBox[{"A12", " ", "A21", " ", "B11"}], "+", 
         RowBox[{"A11", " ", "A22", " ", "B11"}]}], "0"},
       {
        RowBox[{
         RowBox[{"A12", " ", "A21", " ", "B11"}], "+", 
         RowBox[{"A11", " ", "A22", " ", "B11"}]}], 
        RowBox[{"2", " ", "A21", " ", "A22", " ", "B11"}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     2 $CellContext`A11 $CellContext`A12 $CellContext`B11, $CellContext`A12 \
$CellContext`A21 $CellContext`B11 + $CellContext`A11 $CellContext`A22 \
$CellContext`B11, 
      0}, {$CellContext`A12 $CellContext`A21 $CellContext`B11 + \
$CellContext`A11 $CellContext`A22 $CellContext`B11, 
      2 $CellContext`A21 $CellContext`A22 $CellContext`B11, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.733608719501699*^9, 3.733608746798635*^9}, 
   3.741178891328823*^9},ExpressionUUID->"acb319de-ea5e-4fee-968e-\
3476707a1893"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{
  3.7336084626008368`*^9},ExpressionUUID->"c53bdb42-70b8-4b2f-b2a8-\
b2acf1b28e03"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Determination", " ", "of", " ", "the", " ", "action", " ", "set", " ", 
    "for", " ", "the", " ", "pair", " ", 
    RowBox[{"(", 
     RowBox[{"O14", ",", " ", "O14"}], ")"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", 
      "d"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O14", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O14", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "A12", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "A22", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "A32", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", "  ", 
      RowBox[{"B22", "*", " ", "B1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Solve", " ", "A32"}], " ", "=", " ", "0"}], "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "A12", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "b", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "c"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"d", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", "  ", 
      RowBox[{"e", "*", " ", "B1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"Solve", " ", "c"}], " ", "=", " ", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "/", "a"}]}], ",", " ", 
     RowBox[{"e", " ", "=", " ", 
      RowBox[{
       RowBox[{"b", "^", "2"}], 
       RowBox[{"d", "/", 
        RowBox[{"a", "^", "2"}]}]}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "A12", ",", " ", "A13"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "b", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "/", "a"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"B11", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B12", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B11", "*", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "/", 
        RowBox[{"a", "^", "2"}]}], "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.7336088239508057`*^9, 3.733608917886339*^9}, {
   3.7391921164282627`*^9, 3.739192166556423*^9}, {3.739194754555359*^9, 
   3.739194773475815*^9}, 3.739194870796652*^9, {3.7391950379441643`*^9, 
   3.739195049091876*^9}, {3.741174869545953*^9, 3.741174879144689*^9}, {
   3.741174945169482*^9, 3.741174962418459*^9}, 3.741178946428771*^9, 
   3.74117901451763*^9, {3.741179082797366*^9, 3.741179138060959*^9}, {
   3.741179170507876*^9, 3.7411791721947327`*^9}, {3.741179370673492*^9, 
   3.741179384002267*^9}},ExpressionUUID->"cbf6d5de-6083-45a5-88dd-\
1c34b28dcb8d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{
          SuperscriptBox["A12", "2"], " ", "B11"}], "-", 
         RowBox[{"2", " ", "A11", " ", "A13", " ", "B11"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["A11", "2"], " ", "B12"}]}], 
        RowBox[{
         RowBox[{"A12", " ", "A22", " ", "B11"}], "-", 
         RowBox[{"A11", " ", "A23", " ", "B11"}]}], 
        RowBox[{
         RowBox[{"A12", " ", "A32", " ", "B11"}], "-", 
         RowBox[{"A11", " ", "A33", " ", "B11"}]}]},
       {
        RowBox[{
         RowBox[{"A12", " ", "A22", " ", "B11"}], "-", 
         RowBox[{"A11", " ", "A23", " ", "B11"}]}], 
        RowBox[{
         SuperscriptBox["A22", "2"], " ", "B11"}], 
        RowBox[{"A22", " ", "A32", " ", "B11"}]},
       {
        RowBox[{
         RowBox[{"A12", " ", "A32", " ", "B11"}], "-", 
         RowBox[{"A11", " ", "A33", " ", "B11"}]}], 
        RowBox[{"A22", " ", "A32", " ", "B11"}], 
        RowBox[{
         SuperscriptBox["A32", "2"], " ", "B11"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"2", " ", 
         SuperscriptBox["A11", "2"], " ", "B22"}], "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`A12^2 $CellContext`B11 - 
      2 $CellContext`A11 $CellContext`A13 $CellContext`B11 + 
      2 $CellContext`A11^2 $CellContext`B12, $CellContext`A12 \
$CellContext`A22 $CellContext`B11 - $CellContext`A11 $CellContext`A23 \
$CellContext`B11, $CellContext`A12 $CellContext`A32 $CellContext`B11 - \
$CellContext`A11 $CellContext`A33 $CellContext`B11}, {$CellContext`A12 \
$CellContext`A22 $CellContext`B11 - $CellContext`A11 $CellContext`A23 \
$CellContext`B11, $CellContext`A22^2 $CellContext`B11, $CellContext`A22 \
$CellContext`A32 $CellContext`B11}, {$CellContext`A12 $CellContext`A32 \
$CellContext`B11 - $CellContext`A11 $CellContext`A33 $CellContext`B11, \
$CellContext`A22 $CellContext`A32 $CellContext`B11, $CellContext`A32^2 \
$CellContext`B11}}], 
   MatrixForm[{{2 $CellContext`A11^2 $CellContext`B22, 0, 0}, {0, 0, 0}, {0, 
     0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733608920547846*^9, 3.739192170893115*^9, 3.739194774080024*^9, 
   3.739194871378977*^9, 3.7391950495940638`*^9, {3.7411749504509583`*^9, 
   3.7411749634356127`*^9}, 3.741179015117942*^9, 3.7411790880373487`*^9, 
   3.741179138788632*^9, 
   3.741179384748968*^9},ExpressionUUID->"9c6b2322-0d83-4541-b368-\
3f680f1d67d3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", "B12"}], "+", 
         RowBox[{
          SuperscriptBox["A12", "2"], " ", "d"}], "-", 
         RowBox[{"2", " ", "a", " ", "A13", " ", "d"}]}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "a"}], " ", "A23", " ", "d"}], "+", 
         RowBox[{"A12", " ", "b", " ", "d"}]}], 
        RowBox[{
         RowBox[{"-", "a"}], " ", "c", " ", "d"}]},
       {
        RowBox[{
         RowBox[{
          RowBox[{"-", "a"}], " ", "A23", " ", "d"}], "+", 
         RowBox[{"A12", " ", "b", " ", "d"}]}], 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "d"}], "0"},
       {
        RowBox[{
         RowBox[{"-", "a"}], " ", "c", " ", "d"}], "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", "e"}], "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     2 $CellContext`a^2 $CellContext`B12 + $CellContext`A12^2 $CellContext`d - 
      2 $CellContext`a $CellContext`A13 $CellContext`d, -$CellContext`a \
$CellContext`A23 $CellContext`d + $CellContext`A12 $CellContext`b \
$CellContext`d, -$CellContext`a $CellContext`c $CellContext`d}, \
{-$CellContext`a $CellContext`A23 $CellContext`d + $CellContext`A12 \
$CellContext`b $CellContext`d, $CellContext`b^2 $CellContext`d, 
      0}, {-$CellContext`a $CellContext`c $CellContext`d, 0, 0}}], 
   MatrixForm[{{2 $CellContext`a^2 $CellContext`e, 0, 0}, {0, 0, 0}, {0, 0, 
     0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733608920547846*^9, 3.739192170893115*^9, 3.739194774080024*^9, 
   3.739194871378977*^9, 3.7391950495940638`*^9, {3.7411749504509583`*^9, 
   3.7411749634356127`*^9}, 3.741179015117942*^9, 3.7411790880373487`*^9, 
   3.741179138788632*^9, 
   3.741179384751683*^9},ExpressionUUID->"32d692de-a9fb-4afc-ad6c-\
476f0c46e083"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{
          SuperscriptBox["A12", "2"], " ", "B11"}], "-", 
         RowBox[{"2", " ", "a", " ", "A13", " ", "B11"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", "B12"}]}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "a"}], " ", "A23", " ", "B11"}], "+", 
         RowBox[{"A12", " ", "b", " ", "B11"}]}], 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], " ", "B11"}]},
       {
        RowBox[{
         RowBox[{
          RowBox[{"-", "a"}], " ", "A23", " ", "B11"}], "+", 
         RowBox[{"A12", " ", "b", " ", "B11"}]}], 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "B11"}], "0"},
       {
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], " ", "B11"}], "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", "B11"}], "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`A12^2 $CellContext`B11 - 
      2 $CellContext`a $CellContext`A13 $CellContext`B11 + 
      2 $CellContext`a^2 $CellContext`B12, -$CellContext`a $CellContext`A23 \
$CellContext`B11 + $CellContext`A12 $CellContext`b $CellContext`B11, \
-$CellContext`b^2 $CellContext`B11}, {-$CellContext`a $CellContext`A23 \
$CellContext`B11 + $CellContext`A12 $CellContext`b $CellContext`B11, \
$CellContext`b^2 $CellContext`B11, 0}, {-$CellContext`b^2 $CellContext`B11, 0,
       0}}], 
   MatrixForm[{{2 $CellContext`b^2 $CellContext`B11, 0, 0}, {0, 0, 0}, {0, 0, 
     0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733608920547846*^9, 3.739192170893115*^9, 3.739194774080024*^9, 
   3.739194871378977*^9, 3.7391950495940638`*^9, {3.7411749504509583`*^9, 
   3.7411749634356127`*^9}, 3.741179015117942*^9, 3.7411790880373487`*^9, 
   3.741179138788632*^9, 
   3.741179384754075*^9},ExpressionUUID->"5df76fb1-2317-45bb-a5c8-\
da436c84774d"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{6, Automatic}, {Automatic, 55}},
FrontEndVersion->"11.1 for Linux x86 (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 5343, 136, 557, "Input", "ExpressionUUID" -> \
"24bf2db5-ca40-47c5-8a45-c12fd0940645"],
Cell[CellGroupData[{
Cell[5948, 162, 2589, 65, 68, "Print", "ExpressionUUID" -> \
"aa3db56b-283f-4d1d-8c23-01e4413fab23"],
Cell[8540, 229, 1824, 50, 62, "Print", "ExpressionUUID" -> \
"1628308a-2673-4fc8-aa0b-dc95b770decb"]
}, Open  ]]
}, Open  ]],
Cell[10391, 283, 154, 3, 32, "Input", "ExpressionUUID" -> \
"6763bfb3-ce06-41f5-ac09-a426d1db0c8b"],
Cell[10548, 288, 177, 3, 32, "Input", "ExpressionUUID" -> \
"543bf2c4-0eb1-4f0a-b9d6-302cd5b8260c"],
Cell[CellGroupData[{
Cell[10750, 295, 4650, 124, 446, "Input", "ExpressionUUID" -> \
"8297a62d-9cb5-4314-a1a4-5660b40add1c"],
Cell[CellGroupData[{
Cell[15425, 423, 2571, 65, 68, "Print", "ExpressionUUID" -> \
"559cead5-b318-4a9b-b1ba-25dd588346a7"],
Cell[17999, 490, 1805, 50, 62, "Print", "ExpressionUUID" -> \
"ed79ebde-40ed-4445-9bd8-b636ebd67f31"]
}, Open  ]]
}, Open  ]],
Cell[19831, 544, 175, 3, 32, "Input", "ExpressionUUID" -> \
"3dfa2d17-c72d-4939-a59e-b760f5ba6fe7"],
Cell[CellGroupData[{
Cell[20031, 551, 6228, 166, 606, "Input", "ExpressionUUID" -> \
"0ec5abc2-128b-451e-8e56-c89aec7b6dba"],
Cell[CellGroupData[{
Cell[26284, 721, 3379, 81, 59, "Print", "ExpressionUUID" -> \
"40025a86-fd2f-469b-8449-bd735f70df55"],
Cell[29666, 804, 2404, 62, 59, "Print", "ExpressionUUID" -> \
"50564280-68a7-4e7d-82fc-60fea2461269"],
Cell[32073, 868, 2707, 67, 65, "Print", "ExpressionUUID" -> \
"55c0d76f-53ce-43ed-8c74-58ba8a5c01db"]
}, Open  ]]
}, Open  ]],
Cell[34807, 939, 204, 4, 32, "Input", "ExpressionUUID" -> \
"dfac9571-7440-4b0e-b5a3-f6747dff692c"],
Cell[CellGroupData[{
Cell[35036, 947, 4791, 126, 469, "Input", "ExpressionUUID" -> \
"0a9f9f0f-76c4-4577-8f41-4e0d28211652"],
Cell[CellGroupData[{
Cell[39852, 1077, 6052, 125, 131, "Print", "ExpressionUUID" -> \
"a81bf7d9-2085-4013-8f8e-1070dff946a7"],
Cell[45907, 1204, 3532, 82, 65, "Print", "ExpressionUUID" -> \
"8cb27f26-5abf-42db-9159-c96c271ff4b8"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49488, 1292, 4915, 130, 470, "Input", "ExpressionUUID" -> \
"85560b02-052a-40b5-a69f-2c5d74275d43"],
Cell[CellGroupData[{
Cell[54428, 1426, 2567, 64, 68, "Print", "ExpressionUUID" -> \
"4a896243-9f2b-41c2-8510-1d4c445cf723"],
Cell[56998, 1492, 1801, 49, 62, "Print", "ExpressionUUID" -> \
"d32e4764-a649-4cbf-80e8-9b4b4852107c"]
}, Open  ]]
}, Open  ]],
Cell[58826, 1545, 208, 4, 77, "Input", "ExpressionUUID" -> \
"b2f2703e-e866-410e-853d-29dc1f0d47e6"],
Cell[CellGroupData[{
Cell[59059, 1553, 4737, 126, 469, "Input", "ExpressionUUID" -> \
"3c5a85ce-01fe-4143-bd8e-993fcca09ca3"],
Cell[CellGroupData[{
Cell[63821, 1683, 3756, 92, 68, "Print", "ExpressionUUID" -> \
"d3a9960e-64f2-4799-bf34-b7d96d3a85b6"],
Cell[67580, 1777, 2622, 68, 65, "Print", "ExpressionUUID" -> \
"3efda3d7-1749-45d6-9549-2dc03e4e15ae"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[70251, 1851, 6439, 170, 628, "Input", "ExpressionUUID" -> \
"d8413412-d696-4e64-aeca-eaa0325bde1a"],
Cell[CellGroupData[{
Cell[76715, 2025, 3966, 94, 68, "Print", "ExpressionUUID" -> \
"9b28c37f-50ed-4b48-93bf-2c92c280c0d1"],
Cell[80684, 2121, 2724, 70, 65, "Print", "ExpressionUUID" -> \
"d223b6aa-12d1-4505-b4f8-9ea92616047d"],
Cell[83411, 2193, 2462, 65, 65, "Print", "ExpressionUUID" -> \
"251a758a-37a0-46c9-89ff-413d9873cc07"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[85922, 2264, 5417, 148, 470, "Input", "ExpressionUUID" -> \
"0def8c1e-d5bb-439c-a175-8ea525da4ddf"],
Cell[CellGroupData[{
Cell[91364, 2416, 3335, 80, 68, "Print", "ExpressionUUID" -> \
"1ffd70cf-1c45-44ab-99c1-a1de8ab58b93"],
Cell[94702, 2498, 1704, 48, 62, "Print", "ExpressionUUID" -> \
"74d5bb89-44d1-41b8-8781-50bddde3335b"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[96455, 2552, 6641, 174, 607, "Input", "ExpressionUUID" -> \
"7ba65186-6af9-4ec6-ad8a-c7f7f9380361"],
Cell[CellGroupData[{
Cell[103121, 2730, 4441, 104, 65, "Print", "ExpressionUUID" -> \
"df4c81c8-eece-4bc1-9533-9ea3e40b8fa7"],
Cell[107565, 2836, 2515, 65, 62, "Print", "ExpressionUUID" -> \
"0d65c9ff-393c-42c6-9ecd-99355db89f13"],
Cell[110083, 2903, 2441, 64, 62, "Print", "ExpressionUUID" -> \
"aa09e481-06b8-4588-b993-feab4092fc2c"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[112573, 2973, 4608, 123, 447, "Input", "ExpressionUUID" -> \
"02eb9d45-1644-4eef-a629-9f3f94603e9e"],
Cell[CellGroupData[{
Cell[117206, 3100, 2522, 64, 68, "Print", "ExpressionUUID" -> \
"3ce93fcd-f117-4173-a160-bd3e1331e0a8"],
Cell[119731, 3166, 1753, 49, 62, "Print", "ExpressionUUID" -> \
"2f6f1c35-b267-4f0b-a994-14769797d172"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[121533, 3221, 4696, 125, 447, "Input", "ExpressionUUID" -> \
"90a02a47-3d97-453f-b963-c92655040e9c"],
Cell[CellGroupData[{
Cell[126254, 3350, 3312, 78, 59, "Print", "ExpressionUUID" -> \
"5e95ef46-fdc3-408c-888f-cbb0b153762d"],
Cell[129569, 3430, 2307, 59, 59, "Print", "ExpressionUUID" -> \
"acb319de-ea5e-4fee-968e-3476707a1893"]
}, Open  ]]
}, Open  ]],
Cell[131903, 3493, 130, 3, 32, "Input", "ExpressionUUID" -> \
"c53bdb42-70b8-4b2f-b2a8-b2acf1b28e03"],
Cell[CellGroupData[{
Cell[132058, 3500, 6905, 182, 718, "Input", "ExpressionUUID" -> \
"cbf6d5de-6083-45a5-88dd-1c34b28dcb8d"],
Cell[CellGroupData[{
Cell[138988, 3686, 3612, 87, 68, "Print", "ExpressionUUID" -> \
"9c6b2322-0d83-4541-b368-3f680f1d67d3"],
Cell[142603, 3775, 3082, 79, 65, "Print", "ExpressionUUID" -> \
"32d692de-a9fb-4afc-ad6c-476f0c46e083"],
Cell[145688, 3856, 3141, 81, 68, "Print", "ExpressionUUID" -> \
"5df76fb1-2317-45bb-a5c8-da436c84774d"]
}, Open  ]]
}, Open  ]]
}
]
*)

