(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     87702,       2495]
NotebookOptionsPosition[     83627,       2381]
NotebookOutlinePosition[     83962,       2396]
CellTagsIndexPosition[     83919,       2393]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "file", " ", "verifies", " ", "that", " ", "the", " ", 
    "action", " ", "by", " ", "P_x", " ", "on", " ", "x", " ", "is", " ", 
    "contained", " ", "in", " ", "the", " ", "tangent", " ", "space", " ", 
    "V_x"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Verification", " ", "for", " ", "orbit", " ", "OD12"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OD12", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "A12", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A21", ",", " ", "A22", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A31", ",", " ", "A32", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"B11", " ", "*", " ", "A1"}], " ", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"B21", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.733603881811367*^9, 3.733604137603126*^9}, {
  3.733604170891293*^9, 3.733604198122884*^9}, {3.7336054403800087`*^9, 
  3.7336054762674303`*^9}, {3.733673632099154*^9, 3.733673683457472*^9}, {
  3.7336737722487803`*^9, 3.733673780336542*^9}, {3.741181060189661*^9, 
  3.741181094006297*^9}, {3.7411811498289824`*^9, 
  3.741181245070026*^9}},ExpressionUUID->"ef4f39d3-3b7a-44d4-afa0-\
f7cecd1a2968"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "x"},
       {"0", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`x}}], 
   MatrixForm[{{0, 0, $CellContext`x}, {
     0, 0, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733605477720667*^9, 3.733673782399786*^9, 
  3.74118122418426*^9, 
  3.7411819142227993`*^9},ExpressionUUID->"6ee6199f-e32a-4213-a85e-\
a756c9e0fb43"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", 
        RowBox[{
         SuperscriptBox["A33", "2"], " ", "B22"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {
     0, 0, $CellContext`A33^2 $CellContext`B22}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733605477720667*^9, 3.733673782399786*^9, 
  3.74118122418426*^9, 
  3.741181914225088*^9},ExpressionUUID->"aa49d849-6811-43f1-8224-\
ca193db707b5"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7336040005819197`*^9, 
  3.733604001915707*^9}},ExpressionUUID->"6763bfb3-ce06-41f5-ac09-\
a426d1db0c8b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Verification", " ", "for", " ", "orbit", " ", "OD11"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OD11", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "x", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A21", ",", " ", "A22", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A31", ",", " ", "A32", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"B11", " ", "*", " ", "A1"}], " ", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"B21", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.733673831992045*^9, 3.733673868927936*^9}, {
  3.741181255085615*^9, 
  3.741181298902424*^9}},ExpressionUUID->"cbfaa0aa-bc80-4ad4-a4ef-\
8012f0b713ae"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "x"},
       {"0", "x", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`x}, {0, $CellContext`x, 0}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7336738764986*^9, 3.741181425125193*^9, 
  3.741181911763618*^9},ExpressionUUID->"a99f1f42-44d4-4b03-9de0-\
4a09d895eb18"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"A22", " ", "A23", " ", "B22"}], 
        RowBox[{
         FractionBox[
          RowBox[{"A23", " ", "A32", " ", "B22"}], "2"], "+", 
         FractionBox[
          RowBox[{"A22", " ", "A33", " ", "B22"}], "2"]}]},
       {"0", 
        RowBox[{
         FractionBox[
          RowBox[{"A23", " ", "A32", " ", "B22"}], "2"], "+", 
         FractionBox[
          RowBox[{"A22", " ", "A33", " ", "B22"}], "2"]}], 
        RowBox[{"A32", " ", "A33", " ", "B22"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {
     0, $CellContext`A22 $CellContext`A23 $CellContext`B22, 
      Rational[1, 2] $CellContext`A23 $CellContext`A32 $CellContext`B22 + 
      Rational[1, 2] $CellContext`A22 $CellContext`A33 $CellContext`B22}, {
     0, Rational[1, 2] $CellContext`A23 $CellContext`A32 $CellContext`B22 + 
      Rational[1, 
         2] $CellContext`A22 $CellContext`A33 $CellContext`B22, \
$CellContext`A32 $CellContext`A33 $CellContext`B22}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7336738764986*^9, 3.741181425125193*^9, 
  3.741181911766675*^9},ExpressionUUID->"8b12813c-2a80-4703-adad-\
2c6dd3dc3086"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Verification", " ", "for", " ", "orbit", " ", "OD2"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OD2", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "z", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{
          RowBox[{"-", "z"}], " ", "*", "ell"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", "ell"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A21", ",", " ", "A22", ",", " ", "A23"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A31", ",", " ", "A32", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"B11", " ", "*", " ", "A1"}], " ", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"B21", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.733673906711419*^9, 3.7336739294075403`*^9}, 
   3.741181302053212*^9, {3.741181332691701*^9, 3.7411813518675413`*^9}, {
   3.741181821723276*^9, 
   3.7411818263046913`*^9}},ExpressionUUID->"67f06e1a-6264-47d0-bc22-\
7a0f08ec4625"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "z", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", "ell"}], " ", "z"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, $CellContext`z, 0}, {
     0, 0, -$CellContext`ell $CellContext`z}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733673938483716*^9, 3.741181429675343*^9, 
  3.741181908933175*^9},ExpressionUUID->"0c06e061-42b5-4456-aaf9-\
6a159fa82248"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{
         RowBox[{
          SuperscriptBox["A22", "2"], " ", "B22"}], "-", 
         RowBox[{
          SuperscriptBox["A23", "2"], " ", "B22", " ", "ell"}]}], 
        RowBox[{
         RowBox[{"A22", " ", "A32", " ", "B22"}], "-", 
         RowBox[{"A23", " ", "A33", " ", "B22", " ", "ell"}]}]},
       {"0", 
        RowBox[{
         RowBox[{"A22", " ", "A32", " ", "B22"}], "-", 
         RowBox[{"A23", " ", "A33", " ", "B22", " ", "ell"}]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["A32", "2"], " ", "B22"}], "-", 
         RowBox[{
          SuperscriptBox["A33", "2"], " ", "B22", " ", "ell"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {
     0, $CellContext`A22^2 $CellContext`B22 - $CellContext`A23^2 \
$CellContext`B22 $CellContext`ell, $CellContext`A22 $CellContext`A32 \
$CellContext`B22 - $CellContext`A23 $CellContext`A33 $CellContext`B22 \
$CellContext`ell}, {
     0, $CellContext`A22 $CellContext`A32 $CellContext`B22 - $CellContext`A23 \
$CellContext`A33 $CellContext`B22 $CellContext`ell, $CellContext`A32^2 \
$CellContext`B22 - $CellContext`A33^2 $CellContext`B22 $CellContext`ell}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733673938483716*^9, 3.741181429675343*^9, 
  3.7411819089359903`*^9},ExpressionUUID->"96442c6e-f85f-4691-84f2-\
0db7c4e6a650"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Verification", " ", "for", " ", "orbit", " ", "OCs"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OCs", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "z"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "x", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"z", "/", "2"}], ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"z", "/", "2"}], ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A21", ",", " ", "A22", ",", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A31", ",", " ", "A32", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"B11", " ", "*", " ", "A1"}], " ", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"B21", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.733673953287292*^9, 3.733673975879385*^9}, 
   3.741181305580099*^9, {3.7411813563555*^9, 3.741181418395153*^9}, {
   3.741181830715289*^9, 
   3.7411818469207*^9}},ExpressionUUID->"2291bba3-4005-4dc8-bb67-\
1f58bd26193f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "z"},
       {"0", "0", "x"},
       {"z", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["z", "2"], "x"},
       {
        FractionBox["z", "2"], "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, $CellContext`z}, {
     0, 0, $CellContext`x}, {$CellContext`z, $CellContext`x, \
$CellContext`x}}], 
   MatrixForm[{{0, Rational[1, 2] $CellContext`z, $CellContext`x}, {
     Rational[1, 
        2] $CellContext`z, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733673984994516*^9, 3.741181441613351*^9, 
  3.741181905904654*^9},ExpressionUUID->"5b762231-b695-4b02-aed2-\
74ce624f6865"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", 
        RowBox[{
         SuperscriptBox["A33", "2"], " ", "B11"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", 
        FractionBox[
         RowBox[{"A22", " ", "A33", " ", "B22"}], "2"]},
       {"0", 
        FractionBox[
         RowBox[{"A22", " ", "A33", " ", "B22"}], "2"], 
        RowBox[{
         RowBox[{
          SuperscriptBox["A33", "2"], " ", "B21"}], "+", 
         RowBox[{"A32", " ", "A33", " ", "B22"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {
     0, 0, $CellContext`A33^2 $CellContext`B11}}], 
   MatrixForm[{{0, 0, 0}, {
     0, 0, Rational[
       1, 2] $CellContext`A22 $CellContext`A33 $CellContext`B22}, {
     0, Rational[
       1, 
        2] $CellContext`A22 $CellContext`A33 $CellContext`B22, \
$CellContext`A33^2 $CellContext`B21 + $CellContext`A32 $CellContext`A33 \
$CellContext`B22}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733673984994516*^9, 3.741181441613351*^9, 
  3.741181905907506*^9},ExpressionUUID->"96dcec2e-5947-4c5c-a65c-\
e7319a13a3e1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Verification", " ", "for", " ", "orbit", " ", "O14"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O14", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"y", "+", 
          RowBox[{"z", "/", "2"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "z", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"y", "+", 
          RowBox[{"z", "/", "2"}]}], ",", "x", ",", "x"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"y", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A21", ",", " ", "A22", ",", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A31", ",", " ", "A32", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"B11", " ", "*", " ", "A1"}], " ", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"B21", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.733674005655128*^9, 3.7336740341349077`*^9}, 
   3.741181309012868*^9, {3.741181452658844*^9, 3.741181488626807*^9}, {
   3.74118185108215*^9, 
   3.74118185372859*^9}},ExpressionUUID->"40accee2-fe34-428e-9347-\
2d32ebc9dbec"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{"y", "+", 
         FractionBox["z", "2"]}]},
       {"0", "z", "x"},
       {
        RowBox[{"y", "+", 
         FractionBox["z", "2"]}], "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"y", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, $CellContext`y + Rational[1, 2] $CellContext`z}, {
     0, $CellContext`z, $CellContext`x}, {$CellContext`y + 
      Rational[1, 2] $CellContext`z, $CellContext`x, $CellContext`x}}], 
   MatrixForm[{{$CellContext`y, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733674049753539*^9, 3.7411814941911917`*^9, 
  3.741181903451087*^9},ExpressionUUID->"2c609d75-6b15-44ef-be87-\
d20d8162aa4a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", 
        RowBox[{
         SuperscriptBox["A33", "2"], " ", "B11"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        FractionBox[
         RowBox[{"A11", " ", "A33", " ", "B22"}], "2"]},
       {"0", 
        RowBox[{
         SuperscriptBox["A22", "2"], " ", "B22"}], 
        RowBox[{
         RowBox[{"A22", " ", "A32", " ", "B22"}], "+", 
         FractionBox[
          RowBox[{"A21", " ", "A33", " ", "B22"}], "2"]}]},
       {
        FractionBox[
         RowBox[{"A11", " ", "A33", " ", "B22"}], "2"], 
        RowBox[{
         RowBox[{"A22", " ", "A32", " ", "B22"}], "+", 
         FractionBox[
          RowBox[{"A21", " ", "A33", " ", "B22"}], "2"]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["A33", "2"], " ", "B21"}], "+", 
         RowBox[{
          SuperscriptBox["A32", "2"], " ", "B22"}], "+", 
         RowBox[{"A31", " ", "A33", " ", "B22"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {
     0, 0, $CellContext`A33^2 $CellContext`B11}}], 
   MatrixForm[{{
     0, 0, Rational[
       1, 2] $CellContext`A11 $CellContext`A33 $CellContext`B22}, {
     0, $CellContext`A22^2 $CellContext`B22, $CellContext`A22 \
$CellContext`A32 $CellContext`B22 + 
      Rational[1, 2] $CellContext`A21 $CellContext`A33 $CellContext`B22}, {
     Rational[1, 
        2] $CellContext`A11 $CellContext`A33 $CellContext`B22, \
$CellContext`A22 $CellContext`A32 $CellContext`B22 + 
      Rational[1, 
         2] $CellContext`A21 $CellContext`A33 $CellContext`B22, \
$CellContext`A33^2 $CellContext`B21 + $CellContext`A32^2 $CellContext`B22 + \
$CellContext`A31 $CellContext`A33 $CellContext`B22}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733674049753539*^9, 3.7411814941911917`*^9, 
  3.7411819034539623`*^9},ExpressionUUID->"782ae0b9-d561-4f04-a507-\
b18d21d161cd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Verification", " ", "for", " ", "orbit", " ", "O131"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O131", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"z", "/", "2"}], ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"z", "/", "2"}], ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "x", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"z", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A21", ",", " ", "A22", ",", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"B11", " ", "*", " ", "A1"}], " ", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"B21", " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"B22", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7336869603755293`*^9, 3.7336870280073423`*^9}, 
   3.7411813120292053`*^9, {3.7411815037865343`*^9, 3.7411815392023373`*^9}, {
   3.7411818576819344`*^9, 
   3.7411818601525097`*^9}},ExpressionUUID->"e8aec9a9-bab3-42af-958b-\
2072dc12e807"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["z", "2"], "x"},
       {
        FractionBox["z", "2"], "x", "x"},
       {"0", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"z", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, Rational[1, 2] $CellContext`z, $CellContext`x}, {
     Rational[1, 2] $CellContext`z, $CellContext`x, $CellContext`x}, {
     0, $CellContext`x, $CellContext`x}}], 
   MatrixForm[{{$CellContext`z, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733687030733777*^9, 3.741181539937372*^9, 
  3.741181901125156*^9},ExpressionUUID->"52d533c3-3f94-4d64-b11a-\
be821a3c9672"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", 
        FractionBox[
         RowBox[{"A22", " ", "A33", " ", "B11"}], "2"]},
       {"0", 
        FractionBox[
         RowBox[{"A22", " ", "A33", " ", "B11"}], "2"], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        FractionBox[
         RowBox[{"A11", " ", "A33", " ", "B22"}], "2"]},
       {"0", 
        RowBox[{
         SuperscriptBox["A22", "2"], " ", "B22"}], 
        RowBox[{
         FractionBox[
          RowBox[{"A22", " ", "A33", " ", "B21"}], "2"], "+", 
         FractionBox[
          RowBox[{"A21", " ", "A33", " ", "B22"}], "2"]}]},
       {
        FractionBox[
         RowBox[{"A11", " ", "A33", " ", "B22"}], "2"], 
        RowBox[{
         FractionBox[
          RowBox[{"A22", " ", "A33", " ", "B21"}], "2"], "+", 
         FractionBox[
          RowBox[{"A21", " ", "A33", " ", "B22"}], "2"]}], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {
     0, 0, Rational[
       1, 2] $CellContext`A22 $CellContext`A33 $CellContext`B11}, {
     0, Rational[1, 2] $CellContext`A22 $CellContext`A33 $CellContext`B11, 
      0}}], 
   MatrixForm[{{
     0, 0, Rational[
       1, 2] $CellContext`A11 $CellContext`A33 $CellContext`B22}, {
     0, $CellContext`A22^2 $CellContext`B22, 
      Rational[1, 2] $CellContext`A22 $CellContext`A33 $CellContext`B21 + 
      Rational[1, 2] $CellContext`A21 $CellContext`A33 $CellContext`B22}, {
     Rational[1, 2] $CellContext`A11 $CellContext`A33 $CellContext`B22, 
      Rational[1, 2] $CellContext`A22 $CellContext`A33 $CellContext`B21 + 
      Rational[1, 2] $CellContext`A21 $CellContext`A33 $CellContext`B22, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733687030733777*^9, 3.741181539937372*^9, 
  3.741181901128303*^9},ExpressionUUID->"eaa39dfa-daf8-4e24-9463-\
b3aced7d4e81"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Verification", " ", "for", " ", "orbit", " ", "O1212"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O1212", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "A12", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A21", ",", " ", "A22", ",", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"B11", " ", "*", " ", "A1"}], " ", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.733687067722794*^9, 3.733687124071694*^9}, {
   3.7336871729433413`*^9, 3.733687191847107*^9}, 3.741181315132186*^9, {
   3.7411815454343224`*^9, 3.741181579202141*^9}, {3.741181864514112*^9, 
   3.7411818670965757`*^9}},ExpressionUUID->"30b2b264-8c06-4815-8ef3-\
59d605348ca3"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"x", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, 
      0, $CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}], 
   
   MatrixForm[{{$CellContext`x, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.73368719417117*^9, 3.741181585307345*^9, 
  3.741181898624963*^9},ExpressionUUID->"14fff6ad-7b22-476c-9384-\
7216849ff913"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", 
        RowBox[{
         SuperscriptBox["A33", "2"], " ", "B11"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"A11", " ", "A12", " ", "B22"}], 
        RowBox[{
         FractionBox[
          RowBox[{"A12", " ", "A21", " ", "B22"}], "2"], "+", 
         FractionBox[
          RowBox[{"A11", " ", "A22", " ", "B22"}], "2"]}], "0"},
       {
        RowBox[{
         FractionBox[
          RowBox[{"A12", " ", "A21", " ", "B22"}], "2"], "+", 
         FractionBox[
          RowBox[{"A11", " ", "A22", " ", "B22"}], "2"]}], 
        RowBox[{"A21", " ", "A22", " ", "B22"}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {
     0, 0, $CellContext`A33^2 $CellContext`B11}}], 
   MatrixForm[{{$CellContext`A11 $CellContext`A12 $CellContext`B22, 
      Rational[1, 2] $CellContext`A12 $CellContext`A21 $CellContext`B22 + 
      Rational[1, 2] $CellContext`A11 $CellContext`A22 $CellContext`B22, 0}, {
     Rational[1, 2] $CellContext`A12 $CellContext`A21 $CellContext`B22 + 
      Rational[1, 
         2] $CellContext`A11 $CellContext`A22 $CellContext`B22, \
$CellContext`A21 $CellContext`A22 $CellContext`B22, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.73368719417117*^9, 3.741181585307345*^9, 
  3.7411818986279087`*^9},ExpressionUUID->"83320dd9-308f-4b5b-9be1-\
85eaff8b558d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Verification", " ", "for", " ", "orbit", " ", "O22"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O22", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{
          RowBox[{"-", "z"}], "*", "ell"}], ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "A12", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"A21", ",", " ", "A22", ",", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"B11", " ", "*", " ", "A1"}], " ", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.733687234294774*^9, 3.733687253782686*^9}, 
   3.741181319492167*^9, {3.741181590593973*^9, 3.741181629913782*^9}, {
   3.741181870841566*^9, 
   3.74118187267241*^9}},ExpressionUUID->"dcd922f0-f041-49f3-9eb7-\
f417bb75f318"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"z", "0", "x"},
       {"0", 
        RowBox[{
         RowBox[{"-", "ell"}], " ", "z"}], "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"x", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`z, 0, $CellContext`x}, {
     0, -$CellContext`ell $CellContext`z, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}], 
   MatrixForm[{{$CellContext`x, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733687256315981*^9, 3.741181630569625*^9, 
  3.741181896038499*^9},ExpressionUUID->"ce2168d1-ede8-4242-bc31-\
c8ac72508931"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", 
        RowBox[{
         SuperscriptBox["A33", "2"], " ", "B11"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{
          SuperscriptBox["A11", "2"], " ", "B22"}], "-", 
         RowBox[{
          SuperscriptBox["A12", "2"], " ", "B22", " ", "ell"}]}], 
        RowBox[{
         RowBox[{"A11", " ", "A21", " ", "B22"}], "-", 
         RowBox[{"A12", " ", "A22", " ", "B22", " ", "ell"}]}], "0"},
       {
        RowBox[{
         RowBox[{"A11", " ", "A21", " ", "B22"}], "-", 
         RowBox[{"A12", " ", "A22", " ", "B22", " ", "ell"}]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["A21", "2"], " ", "B22"}], "-", 
         RowBox[{
          SuperscriptBox["A22", "2"], " ", "B22", " ", "ell"}]}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {
     0, 0, $CellContext`A33^2 $CellContext`B11}}], 
   MatrixForm[{{$CellContext`A11^2 $CellContext`B22 - $CellContext`A12^2 \
$CellContext`B22 $CellContext`ell, $CellContext`A11 $CellContext`A21 \
$CellContext`B22 - $CellContext`A12 $CellContext`A22 $CellContext`B22 \
$CellContext`ell, 
      0}, {$CellContext`A11 $CellContext`A21 $CellContext`B22 - \
$CellContext`A12 $CellContext`A22 $CellContext`B22 $CellContext`ell, \
$CellContext`A21^2 $CellContext`B22 - $CellContext`A22^2 $CellContext`B22 \
$CellContext`ell, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733687256315981*^9, 3.741181630569625*^9, 
  3.741181896041594*^9},ExpressionUUID->"6f27255a-f386-44c7-99e2-\
5db4221a171c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Verification", " ", "for", " ", "orbit", " ", "O1211"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O1211", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "A22", ",", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"B11", " ", "*", " ", "A1"}], " ", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7411816885855637`*^9, 3.7411817679694653`*^9}, {
  3.7411818762339354`*^9, 
  3.741181879248453*^9}},ExpressionUUID->"b7e6eca4-234f-4a4d-a782-\
3bee78f4c1aa"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"x", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}], 
   MatrixForm[{{$CellContext`x, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.741181749571865*^9, 3.741181777178525*^9}, 
   3.741181892266212*^9},ExpressionUUID->"0833b691-a232-4fa3-860a-\
5c60297b7c5c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{
         SuperscriptBox["A22", "2"], " ", "B11"}], "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["A33", "2"]}], " ", "B11"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        FractionBox[
         RowBox[{"A11", " ", "A33", " ", "B22"}], "2"]},
       {"0", "0", "0"},
       {
        FractionBox[
         RowBox[{"A11", " ", "A33", " ", "B22"}], "2"], "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, $CellContext`A22^2 $CellContext`B11, 0}, {
     0, 0, -$CellContext`A33^2 $CellContext`B11}}], 
   MatrixForm[{{
     0, 0, Rational[
       1, 2] $CellContext`A11 $CellContext`A33 $CellContext`B22}, {0, 0, 0}, {
     Rational[1, 2] $CellContext`A11 $CellContext`A33 $CellContext`B22, 0, 
      0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.741181749571865*^9, 3.741181777178525*^9}, 
   3.741181892268856*^9},ExpressionUUID->"470a8d6e-aa53-4c2e-9df3-\
d7789bcc7a7c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Verification", " ", "for", " ", "orbit", " ", "O122"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"O122", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", "ell"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"A11", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "A22", ",", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "A33"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"B11", " ", "*", " ", "A1"}], " ", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{"B22", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.741181797376844*^9, 3.74118180516855*^9}, {
  3.741181883474172*^9, 
  3.7411818865604467`*^9}},ExpressionUUID->"7d153d2e-ec9b-4b8c-9fc8-\
f6bd02cbb3cb"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"x", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}], 
   MatrixForm[{{$CellContext`x, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741181805632038*^9, 
  3.7411818896684237`*^9},ExpressionUUID->"b08cd892-86d4-499e-940b-\
a56353c2f314"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{
         SuperscriptBox["A22", "2"], " ", "B11"}], "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["A33", "2"]}], " ", "B11", " ", "ell"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        FractionBox[
         RowBox[{"A11", " ", "A33", " ", "B22"}], "2"]},
       {"0", "0", "0"},
       {
        FractionBox[
         RowBox[{"A11", " ", "A33", " ", "B22"}], "2"], "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, $CellContext`A22^2 $CellContext`B11, 0}, {
     0, 0, -$CellContext`A33^2 $CellContext`B11 $CellContext`ell}}], 
   MatrixForm[{{
     0, 0, Rational[
       1, 2] $CellContext`A11 $CellContext`A33 $CellContext`B22}, {0, 0, 0}, {
     Rational[1, 2] $CellContext`A11 $CellContext`A33 $CellContext`B22, 0, 
      0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741181805632038*^9, 
  3.741181889670952*^9},ExpressionUUID->"33df1a6d-8f13-4fd6-893b-\
89ab3e58d8f7"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{87, Automatic}, {38, Automatic}},
FrontEndVersion->"11.1 for Linux x86 (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 4333, 115, 422, "Input", "ExpressionUUID" -> \
"ef4f39d3-3b7a-44d4-afa0-f7cecd1a2968"],
Cell[CellGroupData[{
Cell[4938, 141, 1732, 48, 59, "Print", "ExpressionUUID" -> \
"6ee6199f-e32a-4213-a85e-a756c9e0fb43"],
Cell[6673, 191, 1748, 49, 62, "Print", "ExpressionUUID" -> \
"aa49d849-6811-43f1-8224-ca193db707b5"]
}, Open  ]]
}, Open  ]],
Cell[8448, 244, 154, 3, 32, "Input", "ExpressionUUID" -> \
"06cb437d-9ed5-49e9-a4e0-5de67eecb6db"],
Cell[CellGroupData[{
Cell[8627, 251, 3763, 106, 332, "Input", "ExpressionUUID" -> \
"cbfaa0aa-bc80-4ad4-a4ef-8012f0b713ae"],
Cell[CellGroupData[{
Cell[12415, 361, 1756, 47, 59, "Print", "ExpressionUUID" -> \
"a99f1f42-44d4-4b03-9de0-4a09d895eb18"],
Cell[14174, 410, 2473, 64, 79, "Print", "ExpressionUUID" -> \
"8b12813c-2a80-4703-adad-2c6dd3dc3086"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16696, 480, 3871, 108, 332, "Input", "ExpressionUUID" -> \
"67f06e1a-6264-47d0-bc22-7a0f08ec4625"],
Cell[CellGroupData[{
Cell[20592, 592, 1838, 50, 59, "Print", "ExpressionUUID" -> \
"0c06e061-42b5-4456-aaf9-6a159fa82248"],
Cell[22433, 644, 2672, 68, 65, "Print", "ExpressionUUID" -> \
"96442c6e-f85f-4691-84f2-0db7c4e6a650"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25154, 718, 3884, 109, 332, "Input", "ExpressionUUID" -> \
"2291bba3-4005-4dc8-bb67-1f58bd26193f"],
Cell[CellGroupData[{
Cell[29063, 831, 1898, 52, 75, "Print", "ExpressionUUID" -> \
"5b762231-b695-4b02-aed2-74ce624f6865"],
Cell[30964, 885, 2267, 63, 79, "Print", "ExpressionUUID" -> \
"96dcec2e-5947-4c5c-a65c-e7319a13a3e1"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33280, 954, 3952, 111, 332, "Input", "ExpressionUUID" -> \
"40accee2-fe34-428e-9347-2d32ebc9dbec"],
Cell[CellGroupData[{
Cell[37257, 1069, 2012, 53, 75, "Print", "ExpressionUUID" -> \
"2c609d75-6b15-44ef-be87-d20d8162aa4a"],
Cell[39272, 1124, 3043, 80, 89, "Print", "ExpressionUUID" -> \
"782ae0b9-d561-4f04-a507-b18d21d161cd"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42364, 1210, 3961, 111, 332, "Input", "ExpressionUUID" -> \
"e8aec9a9-bab3-42af-958b-2072dc12e807"],
Cell[CellGroupData[{
Cell[46350, 1325, 1928, 51, 75, "Print", "ExpressionUUID" -> \
"52d533c3-3f94-4d64-b11a-be821a3c9672"],
Cell[48281, 1378, 2969, 77, 89, "Print", "ExpressionUUID" -> \
"eaa39dfa-daf8-4e24-9463-b3aced7d4e81"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[51299, 1461, 3793, 105, 332, "Input", "ExpressionUUID" -> \
"30b2b264-8c06-4815-8ef3-59d605348ca3"],
Cell[CellGroupData[{
Cell[55117, 1570, 1848, 50, 59, "Print", "ExpressionUUID" -> \
"14fff6ad-7b22-476c-9384-7216849ff913"],
Cell[56968, 1622, 2574, 66, 79, "Print", "ExpressionUUID" -> \
"83320dd9-308f-4b5b-9be1-85eaff8b558d"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[59591, 1694, 3761, 106, 332, "Input", "ExpressionUUID" -> \
"dcd922f0-f041-49f3-9eb7-f417bb75f318"],
Cell[CellGroupData[{
Cell[63377, 1804, 1914, 51, 59, "Print", "ExpressionUUID" -> \
"ce2168d1-ede8-4242-bc31-c8ac72508931"],
Cell[65294, 1857, 2771, 71, 65, "Print", "ExpressionUUID" -> \
"6f27255a-f386-44c7-99e2-5db4221a171c"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[68114, 1934, 3691, 104, 332, "Input", "ExpressionUUID" -> \
"b7e6eca4-234f-4a4d-a782-3bee78f4c1aa"],
Cell[CellGroupData[{
Cell[71830, 2042, 1856, 49, 59, "Print", "ExpressionUUID" -> \
"0833b691-a232-4fa3-860a-5c60297b7c5c"],
Cell[73689, 2093, 2153, 59, 79, "Print", "ExpressionUUID" -> \
"470a8d6e-aa53-4c2e-9df3-d7789bcc7a7c"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[75891, 2158, 3690, 105, 332, "Input", "ExpressionUUID" -> \
"7d153d2e-ec9b-4b8c-9fc8-f6bd02cbb3cb"],
Cell[CellGroupData[{
Cell[79606, 2267, 1833, 49, 59, "Print", "ExpressionUUID" -> \
"b08cd892-86d4-499e-940b-a56353c2f314"],
Cell[81442, 2318, 2157, 59, 79, "Print", "ExpressionUUID" -> \
"33df1a6d-8f13-4fd6-893b-89ab3e58d8f7"]
}, Open  ]]
}, Open  ]]
}
]
*)

