(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    170839,       4633]
NotebookOptionsPosition[    164645,       4479]
NotebookOutlinePosition[    164980,       4494]
CellTagsIndexPosition[    164937,       4491]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "This", " ", "file", " ", "verifies", " ", "the", " ", "stabilizer", " ", 
    "calculations", " ", "above", " ", "the", " ", "mod", " ", "p", " ", 
    "orbit", " ", "OD2"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Orbit", " ", "1", " ", "calculation"}], ",", " ", 
    RowBox[{
     RowBox[{"throughout", " ", "eps"}], " ", "=", " ", 
     RowBox[{"+", 
      RowBox[{"/", 
       RowBox[{"-", " ", "1"}]}]}]}], ",", " ", 
    RowBox[{
    "the", " ", "form", " ", "is", " ", "stabilized", " ", "if", " ", "the", 
     " ", "final", " ", "matrix", " ", "is", " ", "in", " ", "the", " ", 
     "space", " ", "V_x"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", "a", ",", " ", "b", ",", " ", "c", ",", " ", "e", ",", " ", 
      "r", ",", " ", "s", ",", " ", "t", ",", " ", "eps", ",", "A11", ",", 
      " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", "A22", ",", " ",
       "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", 
      "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "z", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{
          RowBox[{"-", "ell"}], "*", "z"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "x", ",", " ", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "c", ",", " ", "e"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", 
         RowBox[{"eps", "*", "ell", " ", "*", " ", "e"}], ",", " ", 
         RowBox[{"eps", "*", "c"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"r", " ", "*", " ", "A1"}], " ", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"s", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{"t", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"Solve", " ", "s"}], " ", "=", " ", "0"}], ",", " ", 
     RowBox[{"r", " ", "=", " ", 
      RowBox[{"1", "/", 
       RowBox[{"x", "^", "2"}]}]}], ",", " ", 
     RowBox[{"a", "=", " ", "0"}], ",", " ", 
     RowBox[{"b", "=", "0"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"s", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"x", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.733603881811367*^9, 3.733604137603126*^9}, {
   3.733604170891293*^9, 3.733604198122884*^9}, {3.7336054403800087`*^9, 
   3.7336054762674303`*^9}, {3.733673632099154*^9, 3.733673683457472*^9}, {
   3.7336737722487803`*^9, 3.733673780336542*^9}, {3.733690015157235*^9, 
   3.7336900196212273`*^9}, {3.733690071261084*^9, 3.733690159956675*^9}, 
   3.733690431181098*^9, {3.733691984370245*^9, 3.733692041601634*^9}, {
   3.7336938092877293`*^9, 3.733693882845791*^9}, {3.7337371089756193`*^9, 
   3.7337371639099083`*^9}, {3.741185676050025*^9, 3.741185692313531*^9}, {
   3.741185732409416*^9, 3.741185826800582*^9}, {3.74118601782763*^9, 
   3.741186067506692*^9}, {3.741186108850984*^9, 3.7411861189782543`*^9}, {
   3.741186236449318*^9, 3.7411862660248833`*^9}, {3.741186304369566*^9, 
   3.741186323240671*^9}, {3.7411863532969837`*^9, 3.741186367746326*^9}, {
   3.741187226402659*^9, 3.741187232706555*^9}, {3.741187981797529*^9, 
   3.741187994813689*^9}, {3.7415279165269814`*^9, 
   3.741527919548704*^9}},ExpressionUUID->"05da4a64-7e44-473a-8ba9-\
81ac36ceb309"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "z", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", "ell"}], " ", "z"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, $CellContext`z, 0}, {
     0, 0, -$CellContext`ell $CellContext`z}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733605477720667*^9, 3.733673782399786*^9, 3.733690161316215*^9, 
   3.7336920469496527`*^9, 3.73369388646804*^9, 3.733737165454852*^9, 
   3.74118582851364*^9, 3.74118606962116*^9, 3.741186206892971*^9, 
   3.7411862667813787`*^9, {3.741186307385397*^9, 3.741186323663493*^9}, 
   3.741527920163233*^9},ExpressionUUID->"8a0e217f-f562-4fb4-a991-\
24f9ab0b3105"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"r", " ", 
          SuperscriptBox["x", "2"]}]}], 
        RowBox[{"a", " ", "r", " ", "x"}], 
        RowBox[{"b", " ", "r", " ", "x"}]},
       {
        RowBox[{"a", " ", "r", " ", "x"}], 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "r"}], 
        RowBox[{"a", " ", "b", " ", "r"}]},
       {
        RowBox[{"b", " ", "r", " ", "x"}], 
        RowBox[{"a", " ", "b", " ", "r"}], 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "r"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"s", " ", 
         SuperscriptBox["x", "2"]}], 
        RowBox[{"a", " ", "s", " ", "x"}], 
        RowBox[{"b", " ", "s", " ", "x"}]},
       {
        RowBox[{"a", " ", "s", " ", "x"}], 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "s"}], 
        RowBox[{"a", " ", "b", " ", "s"}]},
       {
        RowBox[{"b", " ", "s", " ", "x"}], 
        RowBox[{"a", " ", "b", " ", "s"}], 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "s"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{-1 + $CellContext`r $CellContext`x^2, $CellContext`a \
$CellContext`r $CellContext`x, $CellContext`b $CellContext`r $CellContext`x}, \
{$CellContext`a $CellContext`r $CellContext`x, $CellContext`a^2 \
$CellContext`r, $CellContext`a $CellContext`b $CellContext`r}, \
{$CellContext`b $CellContext`r $CellContext`x, $CellContext`a $CellContext`b \
$CellContext`r, $CellContext`b^2 $CellContext`r}}], 
   MatrixForm[{{$CellContext`s $CellContext`x^2, $CellContext`a \
$CellContext`s $CellContext`x, $CellContext`b $CellContext`s $CellContext`x}, \
{$CellContext`a $CellContext`s $CellContext`x, $CellContext`a^2 \
$CellContext`s, $CellContext`a $CellContext`b $CellContext`s}, \
{$CellContext`b $CellContext`s $CellContext`x, $CellContext`a $CellContext`b \
$CellContext`s, $CellContext`b^2 $CellContext`s}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733605477720667*^9, 3.733673782399786*^9, 3.733690161316215*^9, 
   3.7336920469496527`*^9, 3.73369388646804*^9, 3.733737165454852*^9, 
   3.74118582851364*^9, 3.74118606962116*^9, 3.741186206892971*^9, 
   3.7411862667813787`*^9, {3.741186307385397*^9, 3.741186323663493*^9}, 
   3.7415279201665583`*^9},ExpressionUUID->"00a14ea6-8f1d-4654-a1c4-\
7fab0992935a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733605477720667*^9, 3.733673782399786*^9, 3.733690161316215*^9, 
   3.7336920469496527`*^9, 3.73369388646804*^9, 3.733737165454852*^9, 
   3.74118582851364*^9, 3.74118606962116*^9, 3.741186206892971*^9, 
   3.7411862667813787`*^9, {3.741186307385397*^9, 3.741186323663493*^9}, 
   3.741527920168529*^9},ExpressionUUID->"fbc59c1f-4618-44e3-90ee-\
d9034f7adade"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Orbit", " ", "2", " ", "calculation"}], " ", "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", "a", ",", " ", "b", ",", " ", "c", ",", " ", "e", ",", " ", 
      "r", ",", " ", "s", ",", " ", "t", ",", " ", "eps", ",", "A11", ",", 
      " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", "A22", ",", " ",
       "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", 
      "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], 
    ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "c", ",", " ", "e"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", 
         RowBox[{"eps", "*", "ell", " ", "*", " ", "e"}], ",", " ", 
         RowBox[{"eps", "*", "c"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"r", " ", "*", " ", "A1"}], " ", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"s", "*", "A1"}], " ", "+", " ", 
       RowBox[{"t", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Solve", " ", "s"}], " ", "=", " ", "0"}], ",", " ", 
     RowBox[{"r", " ", "=", " ", 
      RowBox[{"1", "/", 
       RowBox[{"x", "^", "2"}]}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"s", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r", "=", 
     RowBox[{"1", "/", 
      RowBox[{"x", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Solve", " ", "a", 
       RowBox[{"(", 
        RowBox[{"a", " ", "+", " ", 
         RowBox[{"2", "c"}]}], ")"}]}], " ", "=", " ", "0"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"case", " ", "1"}], ":", " ", "a"}], " ", "=", " ", "0"}], ",",
      " ", 
     RowBox[{"c", "=", "x"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", "=", "x"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"In", " ", "this", " ", "case"}], ",", " ", 
     RowBox[{
      RowBox[{"Solve", " ", "b"}], " ", "=", " ", "0"}], ",", " ", 
     RowBox[{"e", "=", " ", "0"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Case", " ", "a"}], " ", "=", " ", 
      RowBox[{
       RowBox[{"-", "2"}], "c"}]}], ",", " ", 
     RowBox[{"c", " ", "=", " ", 
      RowBox[{"-", "x"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", "=", 
     RowBox[{"-", "x"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", 
     RowBox[{
      RowBox[{"-", "2"}], "*", "c"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"In", " ", "this", " ", "case"}], ",", " ", "also", ",", " ", 
     RowBox[{
      RowBox[{"solve", " ", "b"}], " ", "=", " ", 
      RowBox[{"e", "=", " ", "0"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"e", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.733737382332027*^9, 3.733737428299911*^9}, 
   3.7411858430405188`*^9, 3.74118592172513*^9, 3.7411861309783077`*^9, {
   3.741186395322205*^9, 3.7411864216073303`*^9}, {3.741186537607553*^9, 
   3.7411866033509073`*^9}, {3.7411867393263073`*^9, 
   3.7411867473176527`*^9}, {3.741186779349921*^9, 3.741186783165844*^9}, 
   3.741186884110922*^9, {3.74118696671749*^9, 3.74118696693358*^9}, 
   3.741187005397956*^9, {3.7411870672761393`*^9, 3.7411872060188913`*^9}, {
   3.741187243043562*^9, 3.741187261147357*^9}, {3.7411873146742907`*^9, 
   3.741187317851577*^9}},ExpressionUUID->"2e519b60-ba9f-4c34-a4a7-\
3e02c25b6d7d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "z", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", "ell"}], " ", "z"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, $CellContext`z, 0}, {
     0, 0, -$CellContext`ell $CellContext`z}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7337374292133417`*^9, {3.741186581473988*^9, 3.7411866038342237`*^9}, 
   3.741186783919759*^9, 3.741186886772872*^9, 3.7411869677011414`*^9, 
   3.741187005964576*^9, 3.7411871262078342`*^9, 3.741187209992128*^9, 
   3.7411872619390793`*^9, 
   3.741527922895851*^9},ExpressionUUID->"fa17ae65-a1e1-4aca-a049-\
0f7b4e1bfd02"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"r", " ", 
          SuperscriptBox["x", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"a", " ", "r", " ", "x"}], "+", 
         RowBox[{"c", " ", "r", " ", "x"}]}], 
        RowBox[{
         RowBox[{"b", " ", "r", " ", "x"}], "+", 
         RowBox[{"e", " ", "ell", " ", "eps", " ", "r", " ", "x"}]}]},
       {
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"a", " ", "r", " ", "x"}], "+", 
         RowBox[{"c", " ", "r", " ", "x"}]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "r"}], "+", 
         RowBox[{"2", " ", "a", " ", "c", " ", "r"}]}], 
        RowBox[{
         RowBox[{"a", " ", "b", " ", "r"}], "+", 
         RowBox[{"b", " ", "c", " ", "r"}], "+", 
         RowBox[{"a", " ", "e", " ", "ell", " ", "eps", " ", "r"}]}]},
       {
        RowBox[{
         RowBox[{"b", " ", "r", " ", "x"}], "+", 
         RowBox[{"e", " ", "ell", " ", "eps", " ", "r", " ", "x"}]}], 
        RowBox[{
         RowBox[{"a", " ", "b", " ", "r"}], "+", 
         RowBox[{"b", " ", "c", " ", "r"}], "+", 
         RowBox[{"a", " ", "e", " ", "ell", " ", "eps", " ", "r"}]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r"}], "+", 
         RowBox[{"2", " ", "b", " ", "e", " ", "ell", " ", "eps", " ", "r"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"s", " ", 
         SuperscriptBox["x", "2"]}], 
        RowBox[{
         RowBox[{"a", " ", "s", " ", "x"}], "+", 
         RowBox[{"c", " ", "s", " ", "x"}]}], 
        RowBox[{
         RowBox[{"b", " ", "s", " ", "x"}], "+", 
         RowBox[{"e", " ", "ell", " ", "eps", " ", "s", " ", "x"}]}]},
       {
        RowBox[{
         RowBox[{"a", " ", "s", " ", "x"}], "+", 
         RowBox[{"c", " ", "s", " ", "x"}]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "s"}], "+", 
         RowBox[{"2", " ", "a", " ", "c", " ", "s"}]}], 
        RowBox[{
         RowBox[{"a", " ", "b", " ", "s"}], "+", 
         RowBox[{"b", " ", "c", " ", "s"}], "+", 
         RowBox[{"a", " ", "e", " ", "ell", " ", "eps", " ", "s"}]}]},
       {
        RowBox[{
         RowBox[{"b", " ", "s", " ", "x"}], "+", 
         RowBox[{"e", " ", "ell", " ", "eps", " ", "s", " ", "x"}]}], 
        RowBox[{
         RowBox[{"a", " ", "b", " ", "s"}], "+", 
         RowBox[{"b", " ", "c", " ", "s"}], "+", 
         RowBox[{"a", " ", "e", " ", "ell", " ", "eps", " ", "s"}]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "s"}], "+", 
         RowBox[{"2", " ", "b", " ", "e", " ", "ell", " ", "eps", " ", "s"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{-1 + $CellContext`r $CellContext`x^2, -1 + $CellContext`a \
$CellContext`r $CellContext`x + $CellContext`c $CellContext`r $CellContext`x, \
$CellContext`b $CellContext`r $CellContext`x + $CellContext`e \
$CellContext`ell $CellContext`eps $CellContext`r $CellContext`x}, {-1 + \
$CellContext`a $CellContext`r $CellContext`x + $CellContext`c $CellContext`r \
$CellContext`x, $CellContext`a^2 $CellContext`r + 
      2 $CellContext`a $CellContext`c $CellContext`r, $CellContext`a \
$CellContext`b $CellContext`r + $CellContext`b $CellContext`c $CellContext`r + \
$CellContext`a $CellContext`e $CellContext`ell $CellContext`eps \
$CellContext`r}, {$CellContext`b $CellContext`r $CellContext`x + \
$CellContext`e $CellContext`ell $CellContext`eps $CellContext`r \
$CellContext`x, $CellContext`a $CellContext`b $CellContext`r + $CellContext`b \
$CellContext`c $CellContext`r + $CellContext`a $CellContext`e \
$CellContext`ell $CellContext`eps $CellContext`r, $CellContext`b^2 \
$CellContext`r + 
      2 $CellContext`b $CellContext`e $CellContext`ell $CellContext`eps \
$CellContext`r}}], 
   MatrixForm[{{$CellContext`s $CellContext`x^2, $CellContext`a \
$CellContext`s $CellContext`x + $CellContext`c $CellContext`s $CellContext`x, \
$CellContext`b $CellContext`s $CellContext`x + $CellContext`e \
$CellContext`ell $CellContext`eps $CellContext`s $CellContext`x}, \
{$CellContext`a $CellContext`s $CellContext`x + $CellContext`c $CellContext`s \
$CellContext`x, $CellContext`a^2 $CellContext`s + 
      2 $CellContext`a $CellContext`c $CellContext`s, $CellContext`a \
$CellContext`b $CellContext`s + $CellContext`b $CellContext`c $CellContext`s + \
$CellContext`a $CellContext`e $CellContext`ell $CellContext`eps \
$CellContext`s}, {$CellContext`b $CellContext`s $CellContext`x + \
$CellContext`e $CellContext`ell $CellContext`eps $CellContext`s \
$CellContext`x, $CellContext`a $CellContext`b $CellContext`s + $CellContext`b \
$CellContext`c $CellContext`s + $CellContext`a $CellContext`e \
$CellContext`ell $CellContext`eps $CellContext`s, $CellContext`b^2 \
$CellContext`s + 
      2 $CellContext`b $CellContext`e $CellContext`ell $CellContext`eps \
$CellContext`s}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7337374292133417`*^9, {3.741186581473988*^9, 3.7411866038342237`*^9}, 
   3.741186783919759*^9, 3.741186886772872*^9, 3.7411869677011414`*^9, 
   3.741187005964576*^9, 3.7411871262078342`*^9, 3.741187209992128*^9, 
   3.7411872619390793`*^9, 
   3.741527922898819*^9},ExpressionUUID->"036095f9-b0d3-444f-983b-\
6c5ada6931b7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         FractionBox["a", "x"], "+", 
         FractionBox["c", "x"]}], 
        RowBox[{
         FractionBox["b", "x"], "+", 
         FractionBox[
          RowBox[{"e", " ", "ell", " ", "eps"}], "x"]}]},
       {
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         FractionBox["a", "x"], "+", 
         FractionBox["c", "x"]}], 
        RowBox[{
         FractionBox[
          SuperscriptBox["a", "2"], 
          SuperscriptBox["x", "2"]], "+", 
         FractionBox[
          RowBox[{"2", " ", "a", " ", "c"}], 
          SuperscriptBox["x", "2"]]}], 
        RowBox[{
         FractionBox[
          RowBox[{"a", " ", "b"}], 
          SuperscriptBox["x", "2"]], "+", 
         FractionBox[
          RowBox[{"b", " ", "c"}], 
          SuperscriptBox["x", "2"]], "+", 
         FractionBox[
          RowBox[{"a", " ", "e", " ", "ell", " ", "eps"}], 
          SuperscriptBox["x", "2"]]}]},
       {
        RowBox[{
         FractionBox["b", "x"], "+", 
         FractionBox[
          RowBox[{"e", " ", "ell", " ", "eps"}], "x"]}], 
        RowBox[{
         FractionBox[
          RowBox[{"a", " ", "b"}], 
          SuperscriptBox["x", "2"]], "+", 
         FractionBox[
          RowBox[{"b", " ", "c"}], 
          SuperscriptBox["x", "2"]], "+", 
         FractionBox[
          RowBox[{"a", " ", "e", " ", "ell", " ", "eps"}], 
          SuperscriptBox["x", "2"]]}], 
        RowBox[{
         FractionBox[
          SuperscriptBox["b", "2"], 
          SuperscriptBox["x", "2"]], "+", 
         FractionBox[
          RowBox[{"2", " ", "b", " ", "e", " ", "ell", " ", "eps"}], 
          SuperscriptBox["x", "2"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     0, -1 + $CellContext`a/$CellContext`x + $CellContext`c/$CellContext`x, \
$CellContext`b/$CellContext`x + $CellContext`e $CellContext`ell \
$CellContext`eps/$CellContext`x}, {-1 + $CellContext`a/$CellContext`x + \
$CellContext`c/$CellContext`x, $CellContext`a^2 $CellContext`x^(-2) + 
      2 $CellContext`a $CellContext`c $CellContext`x^(-2), $CellContext`a \
$CellContext`b $CellContext`x^(-2) + $CellContext`b $CellContext`c \
$CellContext`x^(-2) + $CellContext`a $CellContext`e $CellContext`ell \
$CellContext`eps $CellContext`x^(-2)}, {$CellContext`b/$CellContext`x + \
$CellContext`e $CellContext`ell $CellContext`eps/$CellContext`x, \
$CellContext`a $CellContext`b $CellContext`x^(-2) + $CellContext`b \
$CellContext`c $CellContext`x^(-2) + $CellContext`a $CellContext`e \
$CellContext`ell $CellContext`eps $CellContext`x^(-2), $CellContext`b^2 \
$CellContext`x^(-2) + 
      2 $CellContext`b $CellContext`e $CellContext`ell $CellContext`eps \
$CellContext`x^(-2)}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7337374292133417`*^9, {3.741186581473988*^9, 3.7411866038342237`*^9}, 
   3.741186783919759*^9, 3.741186886772872*^9, 3.7411869677011414`*^9, 
   3.741187005964576*^9, 3.7411871262078342`*^9, 3.741187209992128*^9, 
   3.7411872619390793`*^9, 
   3.741527922902079*^9},ExpressionUUID->"3372213a-f2cc-49c7-9bf8-\
a27e2dcdde7c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{
         FractionBox["b", "x"], "+", 
         FractionBox[
          RowBox[{"e", " ", "ell", " ", "eps"}], "x"]}]},
       {"0", "0", 
        FractionBox["b", "x"]},
       {
        RowBox[{
         FractionBox["b", "x"], "+", 
         FractionBox[
          RowBox[{"e", " ", "ell", " ", "eps"}], "x"]}], 
        FractionBox["b", "x"], 
        RowBox[{
         FractionBox[
          SuperscriptBox["b", "2"], 
          SuperscriptBox["x", "2"]], "+", 
         FractionBox[
          RowBox[{"2", " ", "b", " ", "e", " ", "ell", " ", "eps"}], 
          SuperscriptBox["x", "2"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     0, 0, $CellContext`b/$CellContext`x + $CellContext`e $CellContext`ell \
$CellContext`eps/$CellContext`x}, {
     0, 0, $CellContext`b/$CellContext`x}, {$CellContext`b/$CellContext`x + \
$CellContext`e $CellContext`ell $CellContext`eps/$CellContext`x, \
$CellContext`b/$CellContext`x, $CellContext`b^2 $CellContext`x^(-2) + 
      2 $CellContext`b $CellContext`e $CellContext`ell $CellContext`eps \
$CellContext`x^(-2)}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7337374292133417`*^9, {3.741186581473988*^9, 3.7411866038342237`*^9}, 
   3.741186783919759*^9, 3.741186886772872*^9, 3.7411869677011414`*^9, 
   3.741187005964576*^9, 3.7411871262078342`*^9, 3.741187209992128*^9, 
   3.7411872619390793`*^9, 
   3.741527922905138*^9},ExpressionUUID->"5de2d66f-97e1-4cef-a640-\
650144e96c42"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{
         FractionBox["b", "x"], "+", 
         FractionBox[
          RowBox[{"e", " ", "ell", " ", "eps"}], "x"]}]},
       {"0", "0", 
        RowBox[{
         FractionBox["b", "x"], "+", 
         FractionBox[
          RowBox[{"2", " ", "e", " ", "ell", " ", "eps"}], "x"]}]},
       {
        RowBox[{
         FractionBox["b", "x"], "+", 
         FractionBox[
          RowBox[{"e", " ", "ell", " ", "eps"}], "x"]}], 
        RowBox[{
         FractionBox["b", "x"], "+", 
         FractionBox[
          RowBox[{"2", " ", "e", " ", "ell", " ", "eps"}], "x"]}], 
        RowBox[{
         FractionBox[
          SuperscriptBox["b", "2"], 
          SuperscriptBox["x", "2"]], "+", 
         FractionBox[
          RowBox[{"2", " ", "b", " ", "e", " ", "ell", " ", "eps"}], 
          SuperscriptBox["x", "2"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     0, 0, $CellContext`b/$CellContext`x + $CellContext`e $CellContext`ell \
$CellContext`eps/$CellContext`x}, {
     0, 0, $CellContext`b/$CellContext`x + 
      2 $CellContext`e $CellContext`ell $CellContext`eps/$CellContext`x}, \
{$CellContext`b/$CellContext`x + $CellContext`e $CellContext`ell \
$CellContext`eps/$CellContext`x, $CellContext`b/$CellContext`x + 
      2 $CellContext`e $CellContext`ell $CellContext`eps/$CellContext`x, \
$CellContext`b^2 $CellContext`x^(-2) + 
      2 $CellContext`b $CellContext`e $CellContext`ell $CellContext`eps \
$CellContext`x^(-2)}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7337374292133417`*^9, {3.741186581473988*^9, 3.7411866038342237`*^9}, 
   3.741186783919759*^9, 3.741186886772872*^9, 3.7411869677011414`*^9, 
   3.741187005964576*^9, 3.7411871262078342`*^9, 3.741187209992128*^9, 
   3.7411872619390793`*^9, 
   3.7415279229076557`*^9},ExpressionUUID->"23995f00-e92b-45e2-9c03-\
59368be7c2a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7337374292133417`*^9, {3.741186581473988*^9, 3.7411866038342237`*^9}, 
   3.741186783919759*^9, 3.741186886772872*^9, 3.7411869677011414`*^9, 
   3.741187005964576*^9, 3.7411871262078342`*^9, 3.741187209992128*^9, 
   3.7411872619390793`*^9, 
   3.741527922909882*^9},ExpressionUUID->"d048b119-20ed-4367-aa85-\
e58e668fc906"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Orbit", " ", "3", "a", " ", "calculation"}], " ", "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", "a", ",", " ", "b", ",", " ", "c", ",", " ", "e", ",", " ", 
      "r", ",", " ", "s", ",", " ", "t", ",", " ", "eps", ",", "A11", ",", 
      " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", "A22", ",", " ",
       "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", 
      "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], 
    ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "c", ",", " ", "e"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", 
         RowBox[{"eps", "*", " ", "ell", " ", "*", " ", "e"}], ",", 
         RowBox[{"eps", "*", " ", "c"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"r", " ", "*", " ", "A1"}], " ", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"s", "*", "A1"}], " ", "+", " ", 
       RowBox[{"t", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Solve", " ", "s"}], " ", "=", " ", "0"}], ",", " ", 
     RowBox[{"a", "=", "0"}], ",", " ", 
     RowBox[{"b", "=", "0"}], ",", " ", 
     RowBox[{"r", " ", "=", " ", 
      RowBox[{"1", "/", 
       RowBox[{"x", "^", "2"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"s", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r", "=", 
     RowBox[{"1", "/", 
      RowBox[{"x", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Solve", " ", "ce"}], "=", "0"}], ",", " ", 
     RowBox[{
      RowBox[{"forces", " ", "e"}], " ", "=", " ", "0"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"e", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.733737952441201*^9, 3.733737979648933*^9}, {
   3.733738095265587*^9, 3.733738106192995*^9}, 3.7411858559115973`*^9, 
   3.7411859295234756`*^9, 3.7411861401061687`*^9, 3.7411864448088007`*^9, {
   3.741187303466297*^9, 3.741187331018648*^9}, {3.74118736764999*^9, 
   3.741187415730793*^9}, {3.741187483521358*^9, 3.741187544248664*^9}, 
   3.741187587784342*^9},ExpressionUUID->"7a54a7ac-476b-4365-8e95-\
8419cbc45c79"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "z", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", "ell"}], " ", "z"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, $CellContext`z, 0}, {
     0, 0, -$CellContext`ell $CellContext`z}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733737980469129*^9, 3.7337381407221622`*^9, 
  3.741187353156337*^9, 3.7411874165440693`*^9, 3.7411875447499847`*^9, 
  3.741527926027766*^9},ExpressionUUID->"f8e0bd9d-1d25-427f-a0bc-\
e84f0e0de5e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"r", " ", 
          SuperscriptBox["x", "2"]}]}], 
        RowBox[{"a", " ", "r", " ", "x"}], 
        RowBox[{"b", " ", "r", " ", "x"}]},
       {
        RowBox[{"a", " ", "r", " ", "x"}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "r"}], "+", 
         RowBox[{"2", " ", "c", " ", "e", " ", "r"}]}], 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"a", " ", "b", " ", "r"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "eps", " ", "r"}], "+", 
         RowBox[{
          SuperscriptBox["e", "2"], " ", "ell", " ", "eps", " ", "r"}]}]},
       {
        RowBox[{"b", " ", "r", " ", "x"}], 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"a", " ", "b", " ", "r"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "eps", " ", "r"}], "+", 
         RowBox[{
          SuperscriptBox["e", "2"], " ", "ell", " ", "eps", " ", "r"}]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "r"}], "+", 
         RowBox[{"2", " ", "c", " ", "e", " ", "ell", " ", 
          SuperscriptBox["eps", "2"], " ", "r"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"s", " ", 
         SuperscriptBox["x", "2"]}], 
        RowBox[{"a", " ", "s", " ", "x"}], 
        RowBox[{"b", " ", "s", " ", "x"}]},
       {
        RowBox[{"a", " ", "s", " ", "x"}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "s"}], "+", 
         RowBox[{"2", " ", "c", " ", "e", " ", "s"}]}], 
        RowBox[{
         RowBox[{"a", " ", "b", " ", "s"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "eps", " ", "s"}], "+", 
         RowBox[{
          SuperscriptBox["e", "2"], " ", "ell", " ", "eps", " ", "s"}]}]},
       {
        RowBox[{"b", " ", "s", " ", "x"}], 
        RowBox[{
         RowBox[{"a", " ", "b", " ", "s"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "eps", " ", "s"}], "+", 
         RowBox[{
          SuperscriptBox["e", "2"], " ", "ell", " ", "eps", " ", "s"}]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "s"}], "+", 
         RowBox[{"2", " ", "c", " ", "e", " ", "ell", " ", 
          SuperscriptBox["eps", "2"], " ", "s"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{-1 + $CellContext`r $CellContext`x^2, $CellContext`a \
$CellContext`r $CellContext`x, $CellContext`b $CellContext`r $CellContext`x}, \
{$CellContext`a $CellContext`r $CellContext`x, $CellContext`a^2 \
$CellContext`r + 
      2 $CellContext`c $CellContext`e $CellContext`r, -1 + $CellContext`a \
$CellContext`b $CellContext`r + $CellContext`c^2 $CellContext`eps \
$CellContext`r + $CellContext`e^2 $CellContext`ell $CellContext`eps \
$CellContext`r}, {$CellContext`b $CellContext`r $CellContext`x, -1 + \
$CellContext`a $CellContext`b $CellContext`r + $CellContext`c^2 \
$CellContext`eps $CellContext`r + $CellContext`e^2 $CellContext`ell \
$CellContext`eps $CellContext`r, $CellContext`b^2 $CellContext`r + 
      2 $CellContext`c $CellContext`e $CellContext`ell $CellContext`eps^2 \
$CellContext`r}}], 
   MatrixForm[{{$CellContext`s $CellContext`x^2, $CellContext`a \
$CellContext`s $CellContext`x, $CellContext`b $CellContext`s $CellContext`x}, \
{$CellContext`a $CellContext`s $CellContext`x, $CellContext`a^2 \
$CellContext`s + 
      2 $CellContext`c $CellContext`e $CellContext`s, $CellContext`a \
$CellContext`b $CellContext`s + $CellContext`c^2 $CellContext`eps \
$CellContext`s + $CellContext`e^2 $CellContext`ell $CellContext`eps \
$CellContext`s}, {$CellContext`b $CellContext`s $CellContext`x, \
$CellContext`a $CellContext`b $CellContext`s + $CellContext`c^2 \
$CellContext`eps $CellContext`s + $CellContext`e^2 $CellContext`ell \
$CellContext`eps $CellContext`s, $CellContext`b^2 $CellContext`s + 
      2 $CellContext`c $CellContext`e $CellContext`ell $CellContext`eps^2 \
$CellContext`s}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733737980469129*^9, 3.7337381407221622`*^9, 
  3.741187353156337*^9, 3.7411874165440693`*^9, 3.7411875447499847`*^9, 
  3.741527926030827*^9},ExpressionUUID->"20cd1ede-d027-4ee0-9135-\
67a256d4a307"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        FractionBox[
         RowBox[{"2", " ", "c", " ", "e"}], 
         SuperscriptBox["x", "2"]], 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         FractionBox[
          RowBox[{
           SuperscriptBox["c", "2"], " ", "eps"}], 
          SuperscriptBox["x", "2"]], "+", 
         FractionBox[
          RowBox[{
           SuperscriptBox["e", "2"], " ", "ell", " ", "eps"}], 
          SuperscriptBox["x", "2"]]}]},
       {"0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         FractionBox[
          RowBox[{
           SuperscriptBox["c", "2"], " ", "eps"}], 
          SuperscriptBox["x", "2"]], "+", 
         FractionBox[
          RowBox[{
           SuperscriptBox["e", "2"], " ", "ell", " ", "eps"}], 
          SuperscriptBox["x", "2"]]}], 
        FractionBox[
         RowBox[{"2", " ", "c", " ", "e", " ", "ell", " ", 
          SuperscriptBox["eps", "2"]}], 
         SuperscriptBox["x", "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {
     0, 2 $CellContext`c $CellContext`e $CellContext`x^(-2), -1 + \
$CellContext`c^2 $CellContext`eps $CellContext`x^(-2) + $CellContext`e^2 \
$CellContext`ell $CellContext`eps $CellContext`x^(-2)}, {
     0, -1 + $CellContext`c^2 $CellContext`eps $CellContext`x^(-2) + \
$CellContext`e^2 $CellContext`ell $CellContext`eps $CellContext`x^(-2), 
      2 $CellContext`c $CellContext`e $CellContext`ell $CellContext`eps^2 \
$CellContext`x^(-2)}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733737980469129*^9, 3.7337381407221622`*^9, 
  3.741187353156337*^9, 3.7411874165440693`*^9, 3.7411875447499847`*^9, 
  3.74152792603378*^9},ExpressionUUID->"1c4e0611-d641-49d1-8056-913eff913dff"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         FractionBox[
          RowBox[{
           SuperscriptBox["c", "2"], " ", "eps"}], 
          SuperscriptBox["x", "2"]]}]},
       {"0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         FractionBox[
          RowBox[{
           SuperscriptBox["c", "2"], " ", "eps"}], 
          SuperscriptBox["x", "2"]]}], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {
     0, 0, -1 + $CellContext`c^2 $CellContext`eps $CellContext`x^(-2)}, {
     0, -1 + $CellContext`c^2 $CellContext`eps $CellContext`x^(-2), 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733737980469129*^9, 3.7337381407221622`*^9, 
  3.741187353156337*^9, 3.7411874165440693`*^9, 3.7411875447499847`*^9, 
  3.741527926036212*^9},ExpressionUUID->"28d1caf2-f14c-4f57-8193-\
1c144d136df7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Orbit", " ", "4", " ", "calculation"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", "a", ",", " ", "b", ",", " ", "c", ",", " ", "e", ",", " ", 
      "r", ",", " ", "s", ",", " ", "t", ",", " ", "eps", ",", "A11", ",", 
      " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", "A22", ",", " ",
       "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", 
      "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], 
    ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "c", ",", " ", "e"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", 
         RowBox[{"eps", "*", " ", "ell", " ", "*", " ", "e"}], ",", 
         RowBox[{"eps", "*", " ", "c"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]",
    
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"r", " ", "*", " ", "A1"}], " ", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"s", "*", "A1"}], " ", "+", " ", 
       RowBox[{"t", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"Solve", " ", "e"}], " ", "=", " ", "0"}], ",", " ", 
     RowBox[{"r", " ", "=", " ", 
      RowBox[{
       RowBox[{"1", "/", "c"}], "*", "x"}]}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"e", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r", "=", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", "x"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Solve", " ", "a"}], " ", "=", " ", 
     RowBox[{"b", "=", " ", "0"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.733738252111473*^9, 3.7337382603431664`*^9}, 
   3.741185861329463*^9, 3.7411859403149757`*^9, 3.741186149122369*^9, 
   3.741186453880561*^9, {3.741187641560038*^9, 
   3.7411877762311068`*^9}},ExpressionUUID->"2f513c3d-5988-464a-8db1-\
6dfeffd8acf0"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "z", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", "ell"}], " ", "z"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, $CellContext`z, 0}, {
     0, 0, -$CellContext`ell $CellContext`z}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733738260890893*^9, 3.741187660592555*^9, {3.741187747586308*^9, 
   3.741187776773944*^9}, 
   3.7415279293358183`*^9},ExpressionUUID->"727970a6-23c1-40d9-a4c1-\
60c05227df2d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"c", " ", "r", " ", "x"}]}], 
        RowBox[{"e", " ", "ell", " ", "eps", " ", "r", " ", "x"}]},
       {
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"c", " ", "r", " ", "x"}]}], 
        RowBox[{"2", " ", "a", " ", "c", " ", "r"}], 
        RowBox[{
         RowBox[{"b", " ", "c", " ", "r"}], "+", 
         RowBox[{"a", " ", "e", " ", "ell", " ", "eps", " ", "r"}]}]},
       {
        RowBox[{"e", " ", "ell", " ", "eps", " ", "r", " ", "x"}], 
        RowBox[{
         RowBox[{"b", " ", "c", " ", "r"}], "+", 
         RowBox[{"a", " ", "e", " ", "ell", " ", "eps", " ", "r"}]}], 
        RowBox[{"2", " ", "b", " ", "e", " ", "ell", " ", "eps", " ", "r"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{"c", " ", "s", " ", "x"}], 
        RowBox[{"e", " ", "ell", " ", "eps", " ", "s", " ", "x"}]},
       {
        RowBox[{"c", " ", "s", " ", "x"}], 
        RowBox[{"2", " ", "a", " ", "c", " ", "s"}], 
        RowBox[{
         RowBox[{"b", " ", "c", " ", "s"}], "+", 
         RowBox[{"a", " ", "e", " ", "ell", " ", "eps", " ", "s"}]}]},
       {
        RowBox[{"e", " ", "ell", " ", "eps", " ", "s", " ", "x"}], 
        RowBox[{
         RowBox[{"b", " ", "c", " ", "s"}], "+", 
         RowBox[{"a", " ", "e", " ", "ell", " ", "eps", " ", "s"}]}], 
        RowBox[{"2", " ", "b", " ", "e", " ", "ell", " ", "eps", " ", "s"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     0, -1 + $CellContext`c $CellContext`r $CellContext`x, $CellContext`e \
$CellContext`ell $CellContext`eps $CellContext`r $CellContext`x}, {-1 + \
$CellContext`c $CellContext`r $CellContext`x, 
      2 $CellContext`a $CellContext`c $CellContext`r, $CellContext`b \
$CellContext`c $CellContext`r + $CellContext`a $CellContext`e \
$CellContext`ell $CellContext`eps $CellContext`r}, {$CellContext`e \
$CellContext`ell $CellContext`eps $CellContext`r $CellContext`x, \
$CellContext`b $CellContext`c $CellContext`r + $CellContext`a $CellContext`e \
$CellContext`ell $CellContext`eps $CellContext`r, 
      2 $CellContext`b $CellContext`e $CellContext`ell $CellContext`eps \
$CellContext`r}}], 
   MatrixForm[{{
     0, $CellContext`c $CellContext`s $CellContext`x, $CellContext`e \
$CellContext`ell $CellContext`eps $CellContext`s $CellContext`x}, \
{$CellContext`c $CellContext`s $CellContext`x, 
      2 $CellContext`a $CellContext`c $CellContext`s, $CellContext`b \
$CellContext`c $CellContext`s + $CellContext`a $CellContext`e \
$CellContext`ell $CellContext`eps $CellContext`s}, {$CellContext`e \
$CellContext`ell $CellContext`eps $CellContext`s $CellContext`x, \
$CellContext`b $CellContext`c $CellContext`s + $CellContext`a $CellContext`e \
$CellContext`ell $CellContext`eps $CellContext`s, 
      2 $CellContext`b $CellContext`e $CellContext`ell $CellContext`eps \
$CellContext`s}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733738260890893*^9, 3.741187660592555*^9, {3.741187747586308*^9, 
   3.741187776773944*^9}, 
   3.741527929338862*^9},ExpressionUUID->"3bf82e62-be96-4852-b70d-\
63e8698b6bf8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        FractionBox[
         RowBox[{"2", " ", "a"}], "x"], 
        FractionBox["b", "x"]},
       {"0", 
        FractionBox["b", "x"], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{"c", " ", "s", " ", "x"}], "0"},
       {
        RowBox[{"c", " ", "s", " ", "x"}], 
        RowBox[{"2", " ", "a", " ", "c", " ", "s"}], 
        RowBox[{"b", " ", "c", " ", "s"}]},
       {"0", 
        RowBox[{"b", " ", "c", " ", "s"}], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {
     0, 2 $CellContext`a/$CellContext`x, $CellContext`b/$CellContext`x}, {
     0, $CellContext`b/$CellContext`x, 0}}], 
   MatrixForm[{{
     0, $CellContext`c $CellContext`s $CellContext`x, 
      0}, {$CellContext`c $CellContext`s $CellContext`x, 
      2 $CellContext`a $CellContext`c $CellContext`s, $CellContext`b \
$CellContext`c $CellContext`s}, {
     0, $CellContext`b $CellContext`c $CellContext`s, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733738260890893*^9, 3.741187660592555*^9, {3.741187747586308*^9, 
   3.741187776773944*^9}, 
   3.7415279293416443`*^9},ExpressionUUID->"9ce5b0f0-c879-4d85-9814-\
a65666e3339f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{"c", " ", "s", " ", "x"}], "0"},
       {
        RowBox[{"c", " ", "s", " ", "x"}], "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{
     0, $CellContext`c $CellContext`s $CellContext`x, 
      0}, {$CellContext`c $CellContext`s $CellContext`x, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733738260890893*^9, 3.741187660592555*^9, {3.741187747586308*^9, 
   3.741187776773944*^9}, 
   3.741527929344047*^9},ExpressionUUID->"5b00de6b-5374-4c4a-b761-\
dea2f11d3688"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Orbit", " ", "5", " ", "calculation"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", "a", ",", " ", "b", ",", " ", "c", ",", " ", "e", ",", " ", 
      "r", ",", " ", "s", ",", " ", "t", ",", " ", "eps", ",", "A11", ",", 
      " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", "A22", ",", " ",
       "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", 
      "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], 
    ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "c", ",", " ", "e"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", 
         RowBox[{"eps", "*", " ", "ell", " ", "*", " ", "e"}], ",", 
         RowBox[{"eps", "*", " ", "c"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]",
    
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"r", " ", "*", " ", "A1"}], " ", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"s", "*", "A1"}], " ", "+", " ", 
       RowBox[{"t", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Solve", " ", "e"}], "=", " ", "0"}], ",", " ", 
     RowBox[{"t", " ", "=", " ", 
      RowBox[{"1", "/", 
       RowBox[{"x", "^", "2"}]}]}], ",", " ", 
     RowBox[{"r", " ", "=", " ", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"c", "*", "x"}], ")"}]}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"e", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"t", "=", 
     RowBox[{"1", "/", 
      RowBox[{"x", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r", "=", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", "x"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Solve", " ", "a"}], "=", " ", 
     RowBox[{"b", "=", " ", "0"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.7337387846202087`*^9, 3.741185867925517*^9, 3.741185948155231*^9, 
   3.7411861550427227`*^9, 3.741186481152092*^9, {3.741187821983099*^9, 
   3.741187931255094*^9}},ExpressionUUID->"970ef9a9-5363-49d8-a34e-\
50d628d8a3c6"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "z", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", "ell"}], " ", "z"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, $CellContext`z, 0}, {
     0, 0, -$CellContext`ell $CellContext`z}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733738790304944*^9, 3.741187838032607*^9, {3.7411879027624197`*^9, 
   3.741187931666799*^9}, 
   3.7415279321684504`*^9},ExpressionUUID->"cf6bc69c-e629-46d9-8374-\
c08d2a5dfbe2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"c", " ", "r", " ", "x"}]}], 
        RowBox[{"e", " ", "ell", " ", "eps", " ", "r", " ", "x"}]},
       {
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"c", " ", "r", " ", "x"}]}], 
        RowBox[{"2", " ", "a", " ", "c", " ", "r"}], 
        RowBox[{
         RowBox[{"b", " ", "c", " ", "r"}], "+", 
         RowBox[{"a", " ", "e", " ", "ell", " ", "eps", " ", "r"}]}]},
       {
        RowBox[{"e", " ", "ell", " ", "eps", " ", "r", " ", "x"}], 
        RowBox[{
         RowBox[{"b", " ", "c", " ", "r"}], "+", 
         RowBox[{"a", " ", "e", " ", "ell", " ", "eps", " ", "r"}]}], 
        RowBox[{"2", " ", "b", " ", "e", " ", "ell", " ", "eps", " ", "r"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"t", " ", 
          SuperscriptBox["x", "2"]}]}], 
        RowBox[{
         RowBox[{"c", " ", "s", " ", "x"}], "+", 
         RowBox[{"a", " ", "t", " ", "x"}]}], 
        RowBox[{
         RowBox[{"e", " ", "ell", " ", "eps", " ", "s", " ", "x"}], "+", 
         RowBox[{"b", " ", "t", " ", "x"}]}]},
       {
        RowBox[{
         RowBox[{"c", " ", "s", " ", "x"}], "+", 
         RowBox[{"a", " ", "t", " ", "x"}]}], 
        RowBox[{
         RowBox[{"2", " ", "a", " ", "c", " ", "s"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "t"}]}], 
        RowBox[{
         RowBox[{"b", " ", "c", " ", "s"}], "+", 
         RowBox[{"a", " ", "e", " ", "ell", " ", "eps", " ", "s"}], "+", 
         RowBox[{"a", " ", "b", " ", "t"}]}]},
       {
        RowBox[{
         RowBox[{"e", " ", "ell", " ", "eps", " ", "s", " ", "x"}], "+", 
         RowBox[{"b", " ", "t", " ", "x"}]}], 
        RowBox[{
         RowBox[{"b", " ", "c", " ", "s"}], "+", 
         RowBox[{"a", " ", "e", " ", "ell", " ", "eps", " ", "s"}], "+", 
         RowBox[{"a", " ", "b", " ", "t"}]}], 
        RowBox[{
         RowBox[{"2", " ", "b", " ", "e", " ", "ell", " ", "eps", " ", "s"}], 
         "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "t"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     0, -1 + $CellContext`c $CellContext`r $CellContext`x, $CellContext`e \
$CellContext`ell $CellContext`eps $CellContext`r $CellContext`x}, {-1 + \
$CellContext`c $CellContext`r $CellContext`x, 
      2 $CellContext`a $CellContext`c $CellContext`r, $CellContext`b \
$CellContext`c $CellContext`r + $CellContext`a $CellContext`e \
$CellContext`ell $CellContext`eps $CellContext`r}, {$CellContext`e \
$CellContext`ell $CellContext`eps $CellContext`r $CellContext`x, \
$CellContext`b $CellContext`c $CellContext`r + $CellContext`a $CellContext`e \
$CellContext`ell $CellContext`eps $CellContext`r, 
      2 $CellContext`b $CellContext`e $CellContext`ell $CellContext`eps \
$CellContext`r}}], 
   MatrixForm[{{-1 + $CellContext`t $CellContext`x^2, $CellContext`c \
$CellContext`s $CellContext`x + $CellContext`a $CellContext`t $CellContext`x, \
$CellContext`e $CellContext`ell $CellContext`eps $CellContext`s \
$CellContext`x + $CellContext`b $CellContext`t $CellContext`x}, \
{$CellContext`c $CellContext`s $CellContext`x + $CellContext`a $CellContext`t \
$CellContext`x, 
      2 $CellContext`a $CellContext`c $CellContext`s + $CellContext`a^2 \
$CellContext`t, $CellContext`b $CellContext`c $CellContext`s + $CellContext`a \
$CellContext`e $CellContext`ell $CellContext`eps $CellContext`s + \
$CellContext`a $CellContext`b $CellContext`t}, {$CellContext`e \
$CellContext`ell $CellContext`eps $CellContext`s $CellContext`x + \
$CellContext`b $CellContext`t $CellContext`x, $CellContext`b $CellContext`c \
$CellContext`s + $CellContext`a $CellContext`e $CellContext`ell \
$CellContext`eps $CellContext`s + $CellContext`a $CellContext`b \
$CellContext`t, 
      2 $CellContext`b $CellContext`e $CellContext`ell $CellContext`eps \
$CellContext`s + $CellContext`b^2 $CellContext`t}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733738790304944*^9, 3.741187838032607*^9, {3.7411879027624197`*^9, 
   3.741187931666799*^9}, 
   3.741527932171256*^9},ExpressionUUID->"0b400dc8-fedd-48e8-ba74-\
deee4f7e3183"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        FractionBox[
         RowBox[{"2", " ", "a"}], "x"], 
        FractionBox["b", "x"]},
       {"0", 
        FractionBox["b", "x"], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{
         FractionBox["a", "x"], "+", 
         RowBox[{"c", " ", "s", " ", "x"}]}], 
        FractionBox["b", "x"]},
       {
        RowBox[{
         FractionBox["a", "x"], "+", 
         RowBox[{"c", " ", "s", " ", "x"}]}], 
        RowBox[{
         RowBox[{"2", " ", "a", " ", "c", " ", "s"}], "+", 
         FractionBox[
          SuperscriptBox["a", "2"], 
          SuperscriptBox["x", "2"]]}], 
        RowBox[{
         RowBox[{"b", " ", "c", " ", "s"}], "+", 
         FractionBox[
          RowBox[{"a", " ", "b"}], 
          SuperscriptBox["x", "2"]]}]},
       {
        FractionBox["b", "x"], 
        RowBox[{
         RowBox[{"b", " ", "c", " ", "s"}], "+", 
         FractionBox[
          RowBox[{"a", " ", "b"}], 
          SuperscriptBox["x", "2"]]}], 
        FractionBox[
         SuperscriptBox["b", "2"], 
         SuperscriptBox["x", "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {
     0, 2 $CellContext`a/$CellContext`x, $CellContext`b/$CellContext`x}, {
     0, $CellContext`b/$CellContext`x, 0}}], 
   MatrixForm[{{
     0, $CellContext`a/$CellContext`x + $CellContext`c $CellContext`s \
$CellContext`x, $CellContext`b/$CellContext`x}, \
{$CellContext`a/$CellContext`x + $CellContext`c $CellContext`s $CellContext`x,
       2 $CellContext`a $CellContext`c $CellContext`s + $CellContext`a^2 \
$CellContext`x^(-2), $CellContext`b $CellContext`c $CellContext`s + \
$CellContext`a $CellContext`b $CellContext`x^(-2)}, \
{$CellContext`b/$CellContext`x, $CellContext`b $CellContext`c $CellContext`s + \
$CellContext`a $CellContext`b $CellContext`x^(-2), $CellContext`b^2 \
$CellContext`x^(-2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733738790304944*^9, 3.741187838032607*^9, {3.7411879027624197`*^9, 
   3.741187931666799*^9}, 
   3.741527932174004*^9},ExpressionUUID->"e3d512ae-9e58-4b41-b5ab-\
390632608778"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{"c", " ", "s", " ", "x"}], "0"},
       {
        RowBox[{"c", " ", "s", " ", "x"}], "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{
     0, $CellContext`c $CellContext`s $CellContext`x, 
      0}, {$CellContext`c $CellContext`s $CellContext`x, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733738790304944*^9, 3.741187838032607*^9, {3.7411879027624197`*^9, 
   3.741187931666799*^9}, 
   3.7415279321765013`*^9},ExpressionUUID->"ca363439-369c-4251-b1d1-\
ca7816503238"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Orbit", " ", "6", " ", "calculation"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", "a", ",", " ", "b", ",", " ", "c", ",", " ", "e", ",", " ", 
      "r", ",", " ", "s", ",", " ", "t", ",", " ", "eps", ",", "A11", ",", 
      " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", "A22", ",", " ",
       "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", 
      "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], 
    ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "c", ",", " ", "e"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", 
         RowBox[{"eps", "*", " ", "ell", " ", "*", " ", "e"}], ",", 
         RowBox[{"eps", "*", " ", "c"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"r", " ", "*", " ", "A1"}], " ", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"s", "*", "A1"}], " ", "+", " ", 
       RowBox[{"t", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Solve", " ", "ce"}], " ", "=", " ", "0."}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Case", " ", "e"}], "=", " ", "0"}], ",", " ", 
     RowBox[{"r", "=", 
      RowBox[{"1", "/", 
       RowBox[{"c", "^", "2"}]}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"e", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r", "=", 
     RowBox[{"1", "/", 
      RowBox[{"c", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Case", " ", "c"}], " ", "=", " ", "0"}], ",", " ", 
     RowBox[{"r", " ", "=", " ", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"ell", " ", 
         RowBox[{"e", "^", "2"}]}], ")"}]}]}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", "e", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"ell", "*", 
        RowBox[{"e", "^", "2"}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7337389774429407`*^9, 3.7337389941946*^9}, 
   3.7411858746567802`*^9, 3.741185959067246*^9, 3.741186161345756*^9, 
   3.741186488096553*^9, {3.7411879661580563`*^9, 3.7411879729741907`*^9}, {
   3.741188057309795*^9, 
   3.741188204012185*^9}},ExpressionUUID->"fb3cf9d5-f464-4f54-afd4-\
0c3c8e1cf016"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "z", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", "ell"}], " ", "z"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, $CellContext`z, 0}, {
     0, 0, -$CellContext`ell $CellContext`z}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733739011142187*^9, 3.741188019981412*^9, {3.741188078840221*^9, 
   3.7411881060818233`*^9}, {3.741188193477252*^9, 3.741188204423382*^9}, 
   3.74152793555322*^9},ExpressionUUID->"c127e07e-735f-4035-8af8-\
077ba08817c3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "r"}]}], 
        RowBox[{"c", " ", "e", " ", "ell", " ", "eps", " ", "r"}]},
       {"0", 
        RowBox[{"c", " ", "e", " ", "ell", " ", "eps", " ", "r"}], 
        RowBox[{
         SuperscriptBox["e", "2"], " ", 
         SuperscriptBox["ell", "2"], " ", 
         SuperscriptBox["eps", "2"], " ", "r"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "s"}], 
        RowBox[{"c", " ", "e", " ", "ell", " ", "eps", " ", "s"}]},
       {"0", 
        RowBox[{"c", " ", "e", " ", "ell", " ", "eps", " ", "s"}], 
        RowBox[{
         SuperscriptBox["e", "2"], " ", 
         SuperscriptBox["ell", "2"], " ", 
         SuperscriptBox["eps", "2"], " ", "s"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {
     0, -1 + $CellContext`c^2 $CellContext`r, $CellContext`c $CellContext`e \
$CellContext`ell $CellContext`eps $CellContext`r}, {
     0, $CellContext`c $CellContext`e $CellContext`ell $CellContext`eps \
$CellContext`r, $CellContext`e^2 $CellContext`ell^2 $CellContext`eps^2 \
$CellContext`r}}], 
   MatrixForm[{{0, 0, 0}, {
     0, $CellContext`c^2 $CellContext`s, $CellContext`c $CellContext`e \
$CellContext`ell $CellContext`eps $CellContext`s}, {
     0, $CellContext`c $CellContext`e $CellContext`ell $CellContext`eps \
$CellContext`s, $CellContext`e^2 $CellContext`ell^2 $CellContext`eps^2 \
$CellContext`s}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733739011142187*^9, 3.741188019981412*^9, {3.741188078840221*^9, 
   3.7411881060818233`*^9}, {3.741188193477252*^9, 3.741188204423382*^9}, 
   3.7415279355562477`*^9},ExpressionUUID->"afd640f8-254d-45f5-9a74-\
3527ceb44ffb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "s"}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, $CellContext`c^2 $CellContext`s, 0}, {0, 0, 
     0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733739011142187*^9, 3.741188019981412*^9, {3.741188078840221*^9, 
   3.7411881060818233`*^9}, {3.741188193477252*^9, 3.741188204423382*^9}, 
   3.741527935558197*^9},ExpressionUUID->"5b86e88f-44b0-4377-a290-\
66ed3c6d0b6b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"-", "1"}], "0"},
       {"0", "0", 
        RowBox[{"ell", " ", 
         SuperscriptBox["eps", "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", 
        RowBox[{
         SuperscriptBox["e", "2"], " ", 
         SuperscriptBox["ell", "2"], " ", 
         SuperscriptBox["eps", "2"], " ", "s"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, -1, 0}, {
     0, 0, $CellContext`ell $CellContext`eps^2}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {
     0, 0, $CellContext`e^2 $CellContext`ell^2 $CellContext`eps^2 \
$CellContext`s}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733739011142187*^9, 3.741188019981412*^9, {3.741188078840221*^9, 
   3.7411881060818233`*^9}, {3.741188193477252*^9, 3.741188204423382*^9}, 
   3.7415279355603867`*^9},ExpressionUUID->"1e4cc5e9-bc4e-4b28-9089-\
4eff6cd0e49f"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.741188400043499*^9, 
  3.741188420194392*^9}},ExpressionUUID->"b66549ab-0e31-455f-95e5-\
24e3fc45f3dc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Orbit", " ", "7", " ", "calculation"}], " ", "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", "a", ",", " ", "b", ",", " ", "c", ",", " ", "e", ",", " ", 
      "r", ",", " ", "s", ",", " ", "t", ",", " ", "eps", ",", "A11", ",", 
      " ", "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", "A22", ",", " ",
       "A23", ",", " ", "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", 
      "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], 
    ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "c", ",", " ", "e"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", 
         RowBox[{"eps", "*", " ", "ell", " ", "*", " ", "e"}], ",", 
         RowBox[{"eps", "*", " ", "c"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"r", " ", "*", " ", "A1"}], " ", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"s", "*", "A1"}], " ", "+", " ", 
       RowBox[{"t", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"Solve", " ", "t"}], " ", "=", " ", 
      RowBox[{"1", "/", 
       RowBox[{"x", "^", "2"}]}]}], ",", " ", 
     RowBox[{"ce", " ", "=", " ", "0"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"t", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"x", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"Case", " ", "e"}], " ", "=", " ", "0"}], ",", " ", 
     RowBox[{"r", " ", "=", " ", 
      RowBox[{"1", "/", 
       RowBox[{"c", "^", "2"}]}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"e", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r", "=", 
     RowBox[{"1", "/", 
      RowBox[{"c", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Case", " ", "c"}], " ", "=", " ", "0"}], ",", " ", 
     RowBox[{"r", " ", "=", " ", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"ell", "*", 
         RowBox[{"e", "^", "2"}]}], ")"}]}]}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", "e", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"ell", " ", "*", " ", 
        RowBox[{"e", "^", "2"}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.733740559920783*^9, 3.7337405650725393`*^9}, 
   3.741185882628325*^9, 3.741185970827816*^9, 3.7411861722818604`*^9, 
   3.741186497512858*^9, {3.741188422316074*^9, 
   3.74118855959482*^9}},ExpressionUUID->"4d0c5d6d-263a-4d0e-a391-\
6f566ab0b8a2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "z", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", "ell"}], " ", "z"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, $CellContext`z, 0}, {
     0, 0, -$CellContext`ell $CellContext`z}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733740567099358*^9, 3.741188434342721*^9, {3.741188490499845*^9, 
   3.741188499442058*^9}, {3.741188556383863*^9, 3.741188560425562*^9}, 
   3.741527938191143*^9},ExpressionUUID->"a68e75fd-0faa-467c-b781-\
fd673b896391"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "r"}]}], 
        RowBox[{"c", " ", "e", " ", "ell", " ", "eps", " ", "r"}]},
       {"0", 
        RowBox[{"c", " ", "e", " ", "ell", " ", "eps", " ", "r"}], 
        RowBox[{
         SuperscriptBox["e", "2"], " ", 
         SuperscriptBox["ell", "2"], " ", 
         SuperscriptBox["eps", "2"], " ", "r"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"t", " ", 
          SuperscriptBox["x", "2"]}]}], 
        RowBox[{"a", " ", "t", " ", "x"}], 
        RowBox[{"b", " ", "t", " ", "x"}]},
       {
        RowBox[{"a", " ", "t", " ", "x"}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "s"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "t"}]}], 
        RowBox[{
         RowBox[{"c", " ", "e", " ", "ell", " ", "eps", " ", "s"}], "+", 
         RowBox[{"a", " ", "b", " ", "t"}]}]},
       {
        RowBox[{"b", " ", "t", " ", "x"}], 
        RowBox[{
         RowBox[{"c", " ", "e", " ", "ell", " ", "eps", " ", "s"}], "+", 
         RowBox[{"a", " ", "b", " ", "t"}]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["e", "2"], " ", 
          SuperscriptBox["ell", "2"], " ", 
          SuperscriptBox["eps", "2"], " ", "s"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "t"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {
     0, -1 + $CellContext`c^2 $CellContext`r, $CellContext`c $CellContext`e \
$CellContext`ell $CellContext`eps $CellContext`r}, {
     0, $CellContext`c $CellContext`e $CellContext`ell $CellContext`eps \
$CellContext`r, $CellContext`e^2 $CellContext`ell^2 $CellContext`eps^2 \
$CellContext`r}}], 
   MatrixForm[{{-1 + $CellContext`t $CellContext`x^2, $CellContext`a \
$CellContext`t $CellContext`x, $CellContext`b $CellContext`t $CellContext`x}, \
{$CellContext`a $CellContext`t $CellContext`x, $CellContext`c^2 \
$CellContext`s + $CellContext`a^2 $CellContext`t, $CellContext`c \
$CellContext`e $CellContext`ell $CellContext`eps $CellContext`s + \
$CellContext`a $CellContext`b $CellContext`t}, {$CellContext`b $CellContext`t \
$CellContext`x, $CellContext`c $CellContext`e $CellContext`ell \
$CellContext`eps $CellContext`s + $CellContext`a $CellContext`b \
$CellContext`t, $CellContext`e^2 $CellContext`ell^2 $CellContext`eps^2 \
$CellContext`s + $CellContext`b^2 $CellContext`t}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733740567099358*^9, 3.741188434342721*^9, {3.741188490499845*^9, 
   3.741188499442058*^9}, {3.741188556383863*^9, 3.741188560425562*^9}, 
   3.741527938194119*^9},ExpressionUUID->"bab321d9-327d-4fe6-89d2-\
5808d574f77e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["a", "x"], 
        FractionBox["b", "x"]},
       {
        FractionBox["a", "x"], 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "s"}], "+", 
         FractionBox[
          SuperscriptBox["a", "2"], 
          SuperscriptBox["x", "2"]]}], 
        FractionBox[
         RowBox[{"a", " ", "b"}], 
         SuperscriptBox["x", "2"]]},
       {
        FractionBox["b", "x"], 
        FractionBox[
         RowBox[{"a", " ", "b"}], 
         SuperscriptBox["x", "2"]], 
        FractionBox[
         SuperscriptBox["b", "2"], 
         SuperscriptBox["x", "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{
     0, $CellContext`a/$CellContext`x, $CellContext`b/$CellContext`x}, \
{$CellContext`a/$CellContext`x, $CellContext`c^2 $CellContext`s + \
$CellContext`a^2 $CellContext`x^(-2), $CellContext`a $CellContext`b \
$CellContext`x^(-2)}, {$CellContext`b/$CellContext`x, $CellContext`a \
$CellContext`b $CellContext`x^(-2), $CellContext`b^2 $CellContext`x^(-2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733740567099358*^9, 3.741188434342721*^9, {3.741188490499845*^9, 
   3.741188499442058*^9}, {3.741188556383863*^9, 3.741188560425562*^9}, 
   3.74152793819694*^9},ExpressionUUID->"d24241b1-0fa3-4dd6-9d1f-\
6fa93da9d4ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"-", "1"}], "0"},
       {"0", "0", 
        RowBox[{"ell", " ", 
         SuperscriptBox["eps", "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["a", "x"], 
        FractionBox["b", "x"]},
       {
        FractionBox["a", "x"], 
        FractionBox[
         SuperscriptBox["a", "2"], 
         SuperscriptBox["x", "2"]], 
        FractionBox[
         RowBox[{"a", " ", "b"}], 
         SuperscriptBox["x", "2"]]},
       {
        FractionBox["b", "x"], 
        FractionBox[
         RowBox[{"a", " ", "b"}], 
         SuperscriptBox["x", "2"]], 
        RowBox[{
         RowBox[{
          SuperscriptBox["e", "2"], " ", 
          SuperscriptBox["ell", "2"], " ", 
          SuperscriptBox["eps", "2"], " ", "s"}], "+", 
         FractionBox[
          SuperscriptBox["b", "2"], 
          SuperscriptBox["x", "2"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, -1, 0}, {
     0, 0, $CellContext`ell $CellContext`eps^2}}], 
   MatrixForm[{{
     0, $CellContext`a/$CellContext`x, $CellContext`b/$CellContext`x}, \
{$CellContext`a/$CellContext`x, $CellContext`a^2 $CellContext`x^(-2), \
$CellContext`a $CellContext`b $CellContext`x^(-2)}, \
{$CellContext`b/$CellContext`x, $CellContext`a $CellContext`b \
$CellContext`x^(-2), $CellContext`e^2 $CellContext`ell^2 $CellContext`eps^2 \
$CellContext`s + $CellContext`b^2 $CellContext`x^(-2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733740567099358*^9, 3.741188434342721*^9, {3.741188490499845*^9, 
   3.741188499442058*^9}, {3.741188556383863*^9, 3.741188560425562*^9}, 
   3.741527938199651*^9},ExpressionUUID->"95d042d5-ff69-42dd-84d7-\
40c9b30ab753"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "x", ",", "a", ",", " ", "b", ",", " ", "c", ",", " ", "e", ",", " ", "r", 
    ",", " ", "s", ",", " ", "t", ",", " ", "eps", ",", "A11", ",", " ", 
    "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", "A22", ",", " ", "A23",
     ",", " ", "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", "B11", ",", 
    " ", "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"A", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], 
   ";"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["B",
    FontWeight->"Plain"], "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g3", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"a", ",", " ", "c", ",", " ", "e"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"b", ",", 
       RowBox[{"eps", "*", " ", "ell", " ", "*", " ", "e"}], ",", 
       RowBox[{"eps", "*", " ", "c"}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A1", " ", "=", " ", 
   RowBox[{"g3", ".", "A", ".", 
    RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B1", " ", "=", " ", 
   RowBox[{"g3", ".", "B", ".", 
    RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A2", " ", "=", " ", 
   RowBox[{"Expand", "[", 
    RowBox[{"r", " ", "*", " ", "A1"}], " ", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B2", " ", "=", " ", 
   RowBox[{"Expand", "[", " ", 
    RowBox[{
     RowBox[{"s", "*", "A1"}], " ", "+", " ", 
     RowBox[{"t", " ", "*", " ", "B1"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A3", " ", "=", " ", 
   RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B3", " ", "=", " ", 
   RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
    RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
    RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Solve", " ", "ce"}], " ", "=", " ", 
    RowBox[{
     RowBox[{"0.", "  ", "r"}], " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"eps", " ", "*", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", "^", "2"}], " ", "+", " ", 
          RowBox[{"ell", " ", "*", 
           RowBox[{"e", "^", "2"}]}]}], ")"}]}], ")"}]}]}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r", "=", " ", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"eps", " ", "*", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "^", "2"}], " ", "+", " ", 
        RowBox[{"ell", " ", "*", " ", 
         RowBox[{"e", "^", "2"}]}]}], ")"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
    RowBox[{"MatrixForm", "[", 
     RowBox[{"Simplify", "[", "A3", "]"}], "]"}], ",", " ", 
    RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", " ", "[", "c", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"e", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
    RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
    RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.7337411679497347`*^9, 3.733741174333309*^9}, 
   3.73374121845995*^9, 3.741185890644041*^9, 3.741185982098789*^9, 
   3.741186182801848*^9, 3.741186507520769*^9, {3.741188669905048*^9, 
   3.7411888983924828`*^9}},ExpressionUUID->"2bd23020-7a0a-49ef-9284-\
19f0f97652f6"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "z", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", "ell"}], " ", "z"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, $CellContext`z, 0}, {
     0, 0, -$CellContext`ell $CellContext`z}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733741175162702*^9, 3.7337412200999193`*^9, 3.741188631823866*^9, {
   3.741188787885407*^9, 3.7411888611142263`*^9}, 3.7411888997304077`*^9, 
   3.741527941233612*^9},ExpressionUUID->"eac2a9b4-a80d-4cba-aaa9-\
54d00251f9ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"2", " ", "c", " ", "e", " ", "r"}], 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "eps", " ", "r"}], "+", 
         RowBox[{
          SuperscriptBox["e", "2"], " ", "ell", " ", "eps", " ", "r"}]}]},
       {"0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "eps", " ", "r"}], "+", 
         RowBox[{
          SuperscriptBox["e", "2"], " ", "ell", " ", "eps", " ", "r"}]}], 
        RowBox[{"2", " ", "c", " ", "e", " ", "ell", " ", 
         SuperscriptBox["eps", "2"], " ", "r"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"2", " ", "c", " ", "e", " ", "s"}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "eps", " ", "s"}], "+", 
         RowBox[{
          SuperscriptBox["e", "2"], " ", "ell", " ", "eps", " ", "s"}]}]},
       {"0", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "eps", " ", "s"}], "+", 
         RowBox[{
          SuperscriptBox["e", "2"], " ", "ell", " ", "eps", " ", "s"}]}], 
        RowBox[{"2", " ", "c", " ", "e", " ", "ell", " ", 
         SuperscriptBox["eps", "2"], " ", "s"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {
     0, 2 $CellContext`c $CellContext`e $CellContext`r, -1 + $CellContext`c^2 \
$CellContext`eps $CellContext`r + $CellContext`e^2 $CellContext`ell \
$CellContext`eps $CellContext`r}, {
     0, -1 + $CellContext`c^2 $CellContext`eps $CellContext`r + \
$CellContext`e^2 $CellContext`ell $CellContext`eps $CellContext`r, 
      2 $CellContext`c $CellContext`e $CellContext`ell $CellContext`eps^2 \
$CellContext`r}}], 
   MatrixForm[{{0, 0, 0}, {
     0, 2 $CellContext`c $CellContext`e $CellContext`s, $CellContext`c^2 \
$CellContext`eps $CellContext`s + $CellContext`e^2 $CellContext`ell \
$CellContext`eps $CellContext`s}, {
     0, $CellContext`c^2 $CellContext`eps $CellContext`s + $CellContext`e^2 \
$CellContext`ell $CellContext`eps $CellContext`s, 
      2 $CellContext`c $CellContext`e $CellContext`ell $CellContext`eps^2 \
$CellContext`s}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733741175162702*^9, 3.7337412200999193`*^9, 3.741188631823866*^9, {
   3.741188787885407*^9, 3.7411888611142263`*^9}, 3.7411888997304077`*^9, 
   3.741527941236239*^9},ExpressionUUID->"6241f499-ce79-48f6-a092-\
6847d595761b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", 
        RowBox[{
         SuperscriptBox["e", "2"], " ", "ell", " ", "eps", " ", "s"}]},
       {"0", 
        RowBox[{
         SuperscriptBox["e", "2"], " ", "ell", " ", "eps", " ", "s"}], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {
     0, 0, $CellContext`e^2 $CellContext`ell $CellContext`eps \
$CellContext`s}, {
     0, $CellContext`e^2 $CellContext`ell $CellContext`eps $CellContext`s, 
      0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733741175162702*^9, 3.7337412200999193`*^9, 3.741188631823866*^9, {
   3.741188787885407*^9, 3.7411888611142263`*^9}, 3.7411888997304077`*^9, 
   3.741527941238784*^9},ExpressionUUID->"6064aa0e-7738-40dc-8489-\
7c497351b348"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "eps", " ", "s"}]},
       {"0", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "eps", " ", "s"}], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {
     0, 0, $CellContext`c^2 $CellContext`eps $CellContext`s}, {
     0, $CellContext`c^2 $CellContext`eps $CellContext`s, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733741175162702*^9, 3.7337412200999193`*^9, 3.741188631823866*^9, {
   3.741188787885407*^9, 3.7411888611142263`*^9}, 3.7411888997304077`*^9, 
   3.741527941240897*^9},ExpressionUUID->"c7159441-6fdd-4a8f-88bc-\
76d7fe024c17"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "x", ",", "a", ",", " ", "b", ",", " ", "c", ",", " ", "e", ",", " ", "r", 
    ",", " ", "s", ",", " ", "t", ",", " ", "eps", ",", "A11", ",", " ", 
    "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", "A22", ",", " ", "A23",
     ",", " ", "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", "B11", ",", 
    " ", "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"A", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], 
   ";"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["B",
    FontWeight->"Plain"], "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g3", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"a", ",", " ", "c", ",", " ", "e"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"b", ",", 
       RowBox[{"eps", "*", " ", "ell", " ", "*", " ", "e"}], ",", 
       RowBox[{"eps", "*", " ", "c"}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A1", " ", "=", " ", 
   RowBox[{"g3", ".", "A", ".", 
    RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B1", " ", "=", " ", 
   RowBox[{"g3", ".", "B", ".", 
    RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A2", " ", "=", " ", 
   RowBox[{"Expand", "[", 
    RowBox[{"r", " ", "*", " ", "A1"}], " ", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B2", " ", "=", " ", 
   RowBox[{"Expand", "[", " ", 
    RowBox[{
     RowBox[{"s", "*", "A1"}], " ", "+", " ", 
     RowBox[{"t", " ", "*", " ", "B1"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A3", " ", "=", " ", 
   RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B3", " ", "=", " ", 
   RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
    RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
    RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Solve", " ", "ce"}], " ", "=", " ", "0"}], ",", " ", 
    RowBox[{"t", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"x", "^", "2"}]}]}], ",", " ", 
    RowBox[{"r", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"eps", " ", "*", " ", 
        RowBox[{"(", " ", 
         RowBox[{
          RowBox[{"c", "^", "2"}], "  ", "+", " ", 
          RowBox[{
           RowBox[{"e", "^", "2"}], " ", "*", " ", "ell"}]}], ")"}]}], 
       ")"}]}]}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t", " ", "=", " ", 
   RowBox[{"1", "/", 
    RowBox[{"x", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r", " ", "=", " ", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"eps", " ", "*", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "^", "2"}], " ", "+", " ", 
        RowBox[{
         RowBox[{"e", "^", "2"}], " ", "*", " ", "ell"}]}], ")"}]}], 
     ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
    RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
    RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "c", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"e", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
    RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
    RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{
  3.733741808065836*^9, 3.741185898332266*^9, 3.741185990906413*^9, 
   3.741186193130665*^9, 3.7411865205526333`*^9, {3.741188983526957*^9, 
   3.741189054527486*^9}},ExpressionUUID->"3a6948b9-98a9-4c66-ad04-\
327c6789ed87"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "z", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", "ell"}], " ", "z"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, $CellContext`z, 0}, {
     0, 0, -$CellContext`ell $CellContext`z}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733741812190136*^9, 3.741188931307836*^9, 
  3.741189055428479*^9, 
  3.74152794436095*^9},ExpressionUUID->"73698a57-5bb8-489b-943f-0a25611b64fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"2", " ", "c", " ", "e", " ", "r"}], 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "eps", " ", "r"}], "+", 
         RowBox[{
          SuperscriptBox["e", "2"], " ", "ell", " ", "eps", " ", "r"}]}]},
       {"0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "eps", " ", "r"}], "+", 
         RowBox[{
          SuperscriptBox["e", "2"], " ", "ell", " ", "eps", " ", "r"}]}], 
        RowBox[{"2", " ", "c", " ", "e", " ", "ell", " ", 
         SuperscriptBox["eps", "2"], " ", "r"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"t", " ", 
          SuperscriptBox["x", "2"]}]}], 
        RowBox[{"a", " ", "t", " ", "x"}], 
        RowBox[{"b", " ", "t", " ", "x"}]},
       {
        RowBox[{"a", " ", "t", " ", "x"}], 
        RowBox[{
         RowBox[{"2", " ", "c", " ", "e", " ", "s"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "t"}]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "eps", " ", "s"}], "+", 
         RowBox[{
          SuperscriptBox["e", "2"], " ", "ell", " ", "eps", " ", "s"}], "+", 
         RowBox[{"a", " ", "b", " ", "t"}]}]},
       {
        RowBox[{"b", " ", "t", " ", "x"}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "eps", " ", "s"}], "+", 
         RowBox[{
          SuperscriptBox["e", "2"], " ", "ell", " ", "eps", " ", "s"}], "+", 
         RowBox[{"a", " ", "b", " ", "t"}]}], 
        RowBox[{
         RowBox[{"2", " ", "c", " ", "e", " ", "ell", " ", 
          SuperscriptBox["eps", "2"], " ", "s"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "t"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {
     0, 2 $CellContext`c $CellContext`e $CellContext`r, -1 + $CellContext`c^2 \
$CellContext`eps $CellContext`r + $CellContext`e^2 $CellContext`ell \
$CellContext`eps $CellContext`r}, {
     0, -1 + $CellContext`c^2 $CellContext`eps $CellContext`r + \
$CellContext`e^2 $CellContext`ell $CellContext`eps $CellContext`r, 
      2 $CellContext`c $CellContext`e $CellContext`ell $CellContext`eps^2 \
$CellContext`r}}], 
   MatrixForm[{{-1 + $CellContext`t $CellContext`x^2, $CellContext`a \
$CellContext`t $CellContext`x, $CellContext`b $CellContext`t $CellContext`x}, \
{$CellContext`a $CellContext`t $CellContext`x, 
      2 $CellContext`c $CellContext`e $CellContext`s + $CellContext`a^2 \
$CellContext`t, $CellContext`c^2 $CellContext`eps $CellContext`s + \
$CellContext`e^2 $CellContext`ell $CellContext`eps $CellContext`s + \
$CellContext`a $CellContext`b $CellContext`t}, {$CellContext`b $CellContext`t \
$CellContext`x, $CellContext`c^2 $CellContext`eps $CellContext`s + \
$CellContext`e^2 $CellContext`ell $CellContext`eps $CellContext`s + \
$CellContext`a $CellContext`b $CellContext`t, 
      2 $CellContext`c $CellContext`e $CellContext`ell $CellContext`eps^2 \
$CellContext`s + $CellContext`b^2 $CellContext`t}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733741812190136*^9, 3.741188931307836*^9, 
  3.741189055428479*^9, 
  3.741527944363678*^9},ExpressionUUID->"08c1e642-06c5-4151-adc1-\
70ea54334203"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["a", "x"], 
        FractionBox["b", "x"]},
       {
        FractionBox["a", "x"], 
        FractionBox[
         SuperscriptBox["a", "2"], 
         SuperscriptBox["x", "2"]], 
        RowBox[{
         RowBox[{
          SuperscriptBox["e", "2"], " ", "ell", " ", "eps", " ", "s"}], "+", 
         FractionBox[
          RowBox[{"a", " ", "b"}], 
          SuperscriptBox["x", "2"]]}]},
       {
        FractionBox["b", "x"], 
        RowBox[{
         RowBox[{
          SuperscriptBox["e", "2"], " ", "ell", " ", "eps", " ", "s"}], "+", 
         FractionBox[
          RowBox[{"a", " ", "b"}], 
          SuperscriptBox["x", "2"]]}], 
        FractionBox[
         SuperscriptBox["b", "2"], 
         SuperscriptBox["x", "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{
     0, $CellContext`a/$CellContext`x, $CellContext`b/$CellContext`x}, \
{$CellContext`a/$CellContext`x, $CellContext`a^2 $CellContext`x^(-2), \
$CellContext`e^2 $CellContext`ell $CellContext`eps $CellContext`s + \
$CellContext`a $CellContext`b $CellContext`x^(-2)}, \
{$CellContext`b/$CellContext`x, $CellContext`e^2 $CellContext`ell \
$CellContext`eps $CellContext`s + $CellContext`a $CellContext`b \
$CellContext`x^(-2), $CellContext`b^2 $CellContext`x^(-2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733741812190136*^9, 3.741188931307836*^9, 
  3.741189055428479*^9, 
  3.7415279443665323`*^9},ExpressionUUID->"1f915657-ba38-4a4c-9b68-\
9aff049a1649"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["a", "x"], 
        FractionBox["b", "x"]},
       {
        FractionBox["a", "x"], 
        FractionBox[
         SuperscriptBox["a", "2"], 
         SuperscriptBox["x", "2"]], 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "eps", " ", "s"}], "+", 
         FractionBox[
          RowBox[{"a", " ", "b"}], 
          SuperscriptBox["x", "2"]]}]},
       {
        FractionBox["b", "x"], 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "eps", " ", "s"}], "+", 
         FractionBox[
          RowBox[{"a", " ", "b"}], 
          SuperscriptBox["x", "2"]]}], 
        FractionBox[
         SuperscriptBox["b", "2"], 
         SuperscriptBox["x", "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{
     0, $CellContext`a/$CellContext`x, $CellContext`b/$CellContext`x}, \
{$CellContext`a/$CellContext`x, $CellContext`a^2 $CellContext`x^(-2), \
$CellContext`c^2 $CellContext`eps $CellContext`s + $CellContext`a \
$CellContext`b $CellContext`x^(-2)}, {$CellContext`b/$CellContext`x, \
$CellContext`c^2 $CellContext`eps $CellContext`s + $CellContext`a \
$CellContext`b $CellContext`x^(-2), $CellContext`b^2 $CellContext`x^(-2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733741812190136*^9, 3.741188931307836*^9, 
  3.741189055428479*^9, 
  3.741527944369132*^9},ExpressionUUID->"1ae92670-f813-4501-ad62-\
51267efe3919"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "x", ",", "a", ",", " ", "b", ",", " ", "c", ",", " ", "e", ",", " ", "r", 
    ",", " ", "s", ",", " ", "t", ",", " ", "eps", ",", "A11", ",", " ", 
    "A12", ",", " ", "A13", ",", " ", "A21", ",", " ", "A22", ",", " ", "A23",
     ",", " ", "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", "B11", ",", 
    " ", "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"A", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
   ";"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["B",
    FontWeight->"Plain"], "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g3", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"a", ",", " ", "c", ",", " ", "e"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"b", ",", 
       RowBox[{"eps", "*", " ", "ell", " ", "*", " ", "e"}], ",", 
       RowBox[{"eps", "*", "c"}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A1", " ", "=", " ", 
   RowBox[{"g3", ".", "A", ".", 
    RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B1", " ", "=", " ", 
   RowBox[{"g3", ".", "B", ".", 
    RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A2", " ", "=", " ", 
   RowBox[{"Expand", "[", 
    RowBox[{"r", " ", "*", " ", "A1"}], " ", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B2", " ", "=", " ", 
   RowBox[{"Expand", "[", " ", 
    RowBox[{
     RowBox[{"s", "*", "A1"}], " ", "+", " ", 
     RowBox[{"t", "*", " ", "B1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A3", " ", "=", " ", 
   RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B3", " ", "=", " ", 
   RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
    RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
    RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Solve", " ", "t"}], " ", "=", " ", 
    RowBox[{"1", "/", 
     RowBox[{"x", "^", "2"}]}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t", " ", "=", " ", 
   RowBox[{"1", "/", 
    RowBox[{"x", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
    RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
    RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.733741976096754*^9, 3.733742021752705*^9}, 
   3.7411859025722113`*^9, 3.741185998603127*^9, 3.7411861996733713`*^9, 
   3.7411865270475483`*^9, {3.741189108373836*^9, 
   3.741189184958603*^9}},ExpressionUUID->"cb31d240-de52-4640-85e5-\
6c75acff431c"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "z", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", "ell"}], " ", "z"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, $CellContext`z, 0}, {
     0, 0, -$CellContext`ell $CellContext`z}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733742023495167*^9, {3.74118911544655*^9, 3.741189136819386*^9}, {
   3.741189172559938*^9, 3.741189185891691*^9}, 
   3.74152794740554*^9},ExpressionUUID->"d50f7baf-a1df-42a6-a5c5-\
9d8745c19c33"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"t", " ", 
          SuperscriptBox["x", "2"]}]}], 
        RowBox[{"a", " ", "t", " ", "x"}], 
        RowBox[{"b", " ", "t", " ", "x"}]},
       {
        RowBox[{"a", " ", "t", " ", "x"}], 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "t"}], 
        RowBox[{"a", " ", "b", " ", "t"}]},
       {
        RowBox[{"b", " ", "t", " ", "x"}], 
        RowBox[{"a", " ", "b", " ", "t"}], 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "t"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{-1 + $CellContext`t $CellContext`x^2, $CellContext`a \
$CellContext`t $CellContext`x, $CellContext`b $CellContext`t $CellContext`x}, \
{$CellContext`a $CellContext`t $CellContext`x, $CellContext`a^2 \
$CellContext`t, $CellContext`a $CellContext`b $CellContext`t}, \
{$CellContext`b $CellContext`t $CellContext`x, $CellContext`a $CellContext`b \
$CellContext`t, $CellContext`b^2 $CellContext`t}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733742023495167*^9, {3.74118911544655*^9, 3.741189136819386*^9}, {
   3.741189172559938*^9, 3.741189185891691*^9}, 
   3.741527947407835*^9},ExpressionUUID->"372d5f9a-1be6-492c-9ad5-\
08b48b426bcf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["a", "x"], 
        FractionBox["b", "x"]},
       {
        FractionBox["a", "x"], 
        FractionBox[
         SuperscriptBox["a", "2"], 
         SuperscriptBox["x", "2"]], 
        FractionBox[
         RowBox[{"a", " ", "b"}], 
         SuperscriptBox["x", "2"]]},
       {
        FractionBox["b", "x"], 
        FractionBox[
         RowBox[{"a", " ", "b"}], 
         SuperscriptBox["x", "2"]], 
        FractionBox[
         SuperscriptBox["b", "2"], 
         SuperscriptBox["x", "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{
     0, $CellContext`a/$CellContext`x, $CellContext`b/$CellContext`x}, \
{$CellContext`a/$CellContext`x, $CellContext`a^2 $CellContext`x^(-2), \
$CellContext`a $CellContext`b $CellContext`x^(-2)}, \
{$CellContext`b/$CellContext`x, $CellContext`a $CellContext`b \
$CellContext`x^(-2), $CellContext`b^2 $CellContext`x^(-2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733742023495167*^9, {3.74118911544655*^9, 3.741189136819386*^9}, {
   3.741189172559938*^9, 3.741189185891691*^9}, 
   3.7415279474100857`*^9},ExpressionUUID->"1cce2ce1-dba6-4ae4-a24d-\
4507b525da6f"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{Automatic, 327}, {3, Automatic}},
FrontEndVersion->"11.1 for Linux x86 (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 6575, 168, 584, "Input", "ExpressionUUID" -> \
"05da4a64-7e44-473a-8ba9-81ac36ceb309"],
Cell[CellGroupData[{
Cell[7180, 194, 2077, 54, 59, "Print", "ExpressionUUID" -> \
"8a0e217f-f562-4fb4-a991-24f9ab0b3105"],
Cell[9260, 250, 3466, 85, 68, "Print", "ExpressionUUID" -> \
"00a14ea6-8f1d-4654-a1c4-7fab0992935a"],
Cell[12729, 337, 1859, 49, 59, "Print", "ExpressionUUID" -> \
"fbc59c1f-4618-44e3-90ee-d9034f7adade"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14637, 392, 6721, 182, 745, "Input", "ExpressionUUID" -> \
"2e519b60-ba9f-4c34-a4a7-3e02c25b6d7d"],
Cell[CellGroupData[{
Cell[21383, 578, 2042, 54, 59, "Print", "ExpressionUUID" -> \
"fa17ae65-a1e1-4aca-a049-0f7b4e1bfd02"],
Cell[23428, 634, 6465, 145, 141, "Print", "ExpressionUUID" -> \
"036095f9-b0d3-444f-983b-6c5ada6931b7"],
Cell[29896, 781, 4410, 114, 99, "Print", "ExpressionUUID" -> \
"3372213a-f2cc-49c7-9bf8-a27e2dcdde7c"],
Cell[34309, 897, 2778, 73, 94, "Print", "ExpressionUUID" -> \
"5de2d66f-97e1-4cef-a640-650144e96c42"],
Cell[37090, 972, 3158, 82, 94, "Print", "ExpressionUUID" -> \
"23995f00-e92b-45e2-9c03-59368be7c2a7"],
Cell[40251, 1056, 1824, 49, 59, "Print", "ExpressionUUID" -> \
"d048b119-20ed-4367-aa85-e58e668fc906"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42124, 1111, 4965, 134, 539, "Input", "ExpressionUUID" -> \
"7a54a7ac-476b-4365-8e95-8419cbc45c79"],
Cell[CellGroupData[{
Cell[47114, 1249, 1913, 51, 59, "Print", "ExpressionUUID" -> \
"f8e0bd9d-1d25-427f-a0bc-e84f0e0de5e3"],
Cell[49030, 1302, 5408, 128, 141, "Print", "ExpressionUUID" -> \
"20cd1ede-d027-4ee0-9135-67a256d4a307"],
Cell[54441, 1432, 3023, 79, 89, "Print", "ExpressionUUID" -> \
"1c4e0611-d641-49d1-8056-913eff913dff"],
Cell[57467, 1513, 2181, 60, 89, "Print", "ExpressionUUID" -> \
"28d1caf2-f14c-4f57-8193-1c144d136df7"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[59697, 1579, 4589, 128, 515, "Input", "ExpressionUUID" -> \
"2f513c3d-5988-464a-8db1-6dfeffd8acf0"],
Cell[CellGroupData[{
Cell[64311, 1711, 1894, 52, 59, "Print", "ExpressionUUID" -> \
"727970a6-23c1-40d9-a4c1-60c05227df2d"],
Cell[66208, 1765, 4274, 97, 121, "Print", "ExpressionUUID" -> \
"3bf82e62-be96-4852-b70d-63e8698b6bf8"],
Cell[70485, 1864, 2335, 63, 79, "Print", "ExpressionUUID" -> \
"9ce5b0f0-c879-4d85-9814-a65666e3339f"],
Cell[72823, 1929, 1851, 51, 59, "Print", "ExpressionUUID" -> \
"5b00de6b-5374-4c4a-b761-dea2f11d3688"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[74723, 1986, 4840, 136, 560, "Input", "ExpressionUUID" -> \
"970ef9a9-5363-49d8-a34e-50d628d8a3c6"],
Cell[CellGroupData[{
Cell[79588, 2126, 1896, 52, 59, "Print", "ExpressionUUID" -> \
"cf6bc69c-e629-46d9-8374-c08d2a5dfbe2"],
Cell[81487, 2180, 5357, 123, 131, "Print", "ExpressionUUID" -> \
"0b400dc8-fedd-48e8-ba74-deee4f7e3183"],
Cell[86847, 2305, 3255, 88, 99, "Print", "ExpressionUUID" -> \
"e3d512ae-9e58-4b41-b5ab-390632608778"],
Cell[90105, 2395, 1855, 51, 59, "Print", "ExpressionUUID" -> \
"ca363439-369c-4251-b1d1-ca7816503238"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[92009, 2452, 5081, 142, 561, "Input", "ExpressionUUID" -> \
"fb3cf9d5-f464-4f54-afd4-0c3c8e1cf016"],
Cell[CellGroupData[{
Cell[97115, 2598, 1939, 52, 59, "Print", "ExpressionUUID" -> \
"c127e07e-735f-4035-8af8-077ba08817c3"],
Cell[99057, 2652, 2989, 75, 65, "Print", "ExpressionUUID" -> \
"afd640f8-254d-45f5-9a74-3527ceb44ffb"],
Cell[102049, 2729, 1818, 50, 62, "Print", "ExpressionUUID" -> \
"5b86e88f-44b0-4377-a290-66ed3c6d0b6b"],
Cell[103870, 2781, 2075, 57, 62, "Print", "ExpressionUUID" -> \
"1e4cc5e9-bc4e-4b28-9089-4eff6cd0e49f"]
}, Open  ]]
}, Open  ]],
Cell[105972, 2842, 152, 3, 32, "Input", "ExpressionUUID" -> \
"b66549ab-0e31-455f-95e5-24e3fc45f3dc"],
Cell[CellGroupData[{
Cell[106149, 2849, 5333, 149, 607, "Input", "ExpressionUUID" -> \
"4d0c5d6d-263a-4d0e-a391-6f566ab0b8a2"],
Cell[CellGroupData[{
Cell[111507, 3002, 1938, 52, 59, "Print", "ExpressionUUID" -> \
"a68e75fd-0faa-467c-b781-fd673b896391"],
Cell[113448, 3056, 3954, 97, 68, "Print", "ExpressionUUID" -> \
"bab321d9-327d-4fe6-89d2-5808d574f77e"],
Cell[117405, 3155, 2601, 71, 99, "Print", "ExpressionUUID" -> \
"d24241b1-0fa3-4dd6-9d1f-6fa93da9d4ce"],
Cell[120009, 3228, 2859, 78, 99, "Print", "ExpressionUUID" -> \
"95d042d5-ff69-42dd-84d7-40c9b30ab753"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[122917, 3312, 4668, 135, 492, "Input", "ExpressionUUID" -> \
"2bd23020-7a0a-49ef-9284-19f0f97652f6"],
Cell[CellGroupData[{
Cell[127610, 3451, 1942, 52, 59, "Print", "ExpressionUUID" -> \
"eac2a9b4-a80d-4cba-aaa9-54d00251f9ed"],
Cell[129555, 3505, 3632, 89, 134, "Print", "ExpressionUUID" -> \
"6241f499-ce79-48f6-a092-6847d595761b"],
Cell[133190, 3596, 2041, 55, 65, "Print", "ExpressionUUID" -> \
"6064aa0e-7738-40dc-8489-7c497351b348"],
Cell[135234, 3653, 1974, 53, 65, "Print", "ExpressionUUID" -> \
"c7159441-6fdd-4a8f-88bc-76d7fe024c17"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[137257, 3712, 4818, 141, 516, "Input", "ExpressionUUID" -> \
"3a6948b9-98a9-4c66-ad04-327c6789ed87"],
Cell[CellGroupData[{
Cell[142100, 3857, 1860, 50, 59, "Print", "ExpressionUUID" -> \
"73698a57-5bb8-489b-943f-0a25611b64fb"],
Cell[143963, 3909, 4484, 108, 138, "Print", "ExpressionUUID" -> \
"08c1e642-06c5-4151-adc1-70ea54334203"],
Cell[148450, 4019, 2777, 75, 99, "Print", "ExpressionUUID" -> \
"1f915657-ba38-4a4c-9b68-9aff049a1649"],
Cell[151230, 4096, 2715, 74, 99, "Print", "ExpressionUUID" -> \
"1ae92670-f813-4501-ad62-51267efe3919"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[153994, 4176, 3695, 105, 400, "Input", "ExpressionUUID" -> \
"cb31d240-de52-4640-85e5-6c75acff431c"],
Cell[CellGroupData[{
Cell[157714, 4285, 1914, 52, 59, "Print", "ExpressionUUID" -> \
"d50f7baf-a1df-42a6-a5c5-9d8745c19c33"],
Cell[159631, 4339, 2530, 66, 68, "Print", "ExpressionUUID" -> \
"372d5f9a-1be6-492c-9ad5-08b48b426bcf"],
Cell[162164, 4407, 2453, 68, 99, "Print", "ExpressionUUID" -> \
"1cce2ce1-dba6-4ae4-a24d-4507b525da6f"]
}, Open  ]]
}, Open  ]]
}
]
*)

