(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    208110,       6075]
NotebookOptionsPosition[    198302,       5819]
NotebookOutlinePosition[    198638,       5834]
CellTagsIndexPosition[    198595,       5831]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "This", " ", "file", " ", "verifies", " ", "that", " ", "the", " ", 
    "claimed", " ", "stabilizer", " ", "fixes", " ", "the", " ", "form", " ", 
    "in", " ", "the", " ", "case", " ", "of", " ", "orbits", " ", "of", " ", 
    RowBox[{"OD11", ".", "  ", "The"}], " ", "verification", " ", "that", " ",
     "the", " ", "stabilizer", " ", "is", " ", "no", " ", "larger", " ", "is",
     " ", "given", " ", "as", " ", "a", " ", "proof", " ", "in", " ", "the", 
    " ", "main", " ", 
    RowBox[{"text", ".", " ", "The"}], " ", "condition", " ", "that", " ", 
    "the", " ", "form", " ", "is", " ", "stabilized", " ", "amounts", " ", 
    "to", " ", "the", " ", "final", " ", "matrix", " ", "lies", " ", "in", 
    " ", "the", " ", "space", " ", 
    RowBox[{"(", 
     RowBox[{"Vx1", ",", " ", "Vx2"}], ")"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Vx1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.7411944122546453`*^9, 3.741194435856625*^9}, {
  3.7411946310226603`*^9, 
  3.741194652286292*^9}},ExpressionUUID->"35ccf8f4-e3c7-4ee2-8dab-\
78c4569c64c8"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.741194708718646*^9, 3.741194715973772*^9}, 
   3.741194850527972*^9},ExpressionUUID->"bdf5668b-9399-411f-9d58-\
b956b9d2bc8b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "2"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "b", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "d", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"e", ",", " ", "f", ",", " ", "g"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"x", " ", "*", " ", "A1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"s", "^", "2"}]}], " ", "*", " ", "B1"}], ")"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.733603881811367*^9, 3.733604137603126*^9}, {
   3.733604170891293*^9, 3.733604198122884*^9}, {3.7336054403800087`*^9, 
   3.7336054762674303`*^9}, {3.733673632099154*^9, 3.733673683457472*^9}, {
   3.7336737722487803`*^9, 3.733673780336542*^9}, {3.733690015157235*^9, 
   3.7336900196212273`*^9}, {3.733690071261084*^9, 3.733690159956675*^9}, 
   3.733690431181098*^9, {3.733691984370245*^9, 3.733692041601634*^9}, {
   3.7336938092877293`*^9, 3.733693882845791*^9}, {3.7337371089756193`*^9, 
   3.7337371639099083`*^9}, {3.7337478695101337`*^9, 3.733747902316284*^9}, {
   3.73375296356738*^9, 3.733752977829774*^9}, {3.7337530287986917`*^9, 
   3.733753031613069*^9}, {3.7411947045218573`*^9, 
   3.741194852070835*^9}},ExpressionUUID->"adcff66d-c664-484d-8ebd-\
608a3d1a6706"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "x"},
       {"0", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`x}}], 
   MatrixForm[{{0, 0, $CellContext`x}, {
     0, 0, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733605477720667*^9, 3.733673782399786*^9, 3.733690161316215*^9, 
   3.7336920469496527`*^9, 3.73369388646804*^9, 3.733737165454852*^9, 
   3.733747904261256*^9, 3.73375300172473*^9, 3.733753033316269*^9, {
   3.7411947945588408`*^9, 
   3.741194822482682*^9}},ExpressionUUID->"abd638b8-99e5-4601-99f2-\
c6664d09bbc9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        FractionBox["e", "s"]},
       {"0", "0", "0"},
       {
        FractionBox["e", "s"], "0", 
        FractionBox[
         SuperscriptBox["e", "2"], 
         SuperscriptBox["s", "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, $CellContext`e/$CellContext`s}, {0, 0, 
     0}, {$CellContext`e/$CellContext`s, 
      0, $CellContext`e^2 $CellContext`s^(-2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733605477720667*^9, 3.733673782399786*^9, 3.733690161316215*^9, 
   3.7336920469496527`*^9, 3.73369388646804*^9, 3.733737165454852*^9, 
   3.733747904261256*^9, 3.73375300172473*^9, 3.733753033316269*^9, {
   3.7411947945588408`*^9, 
   3.741194822484976*^9}},ExpressionUUID->"7175d4a2-65fc-4c79-8b20-\
84fa59688594"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7336040005819197`*^9, 
  3.733604001915707*^9}},ExpressionUUID->"cd4d0252-c084-4465-a80c-\
7d76797a79c7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "3"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "t", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"e", ",", " ", "f", ",", " ", "g"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"x", " ", "*", " ", "A1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"s", "*", "t"}], ")"}]}], " ", "*", " ", "B1"}], ")"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";", 
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"t", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"e", ",", " ", "f", ",", " ", "g"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"x", " ", "*", " ", "A1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"s", "*", "t"}], ")"}]}], " ", "*", " ", "B1"}], ")"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.7411948874433928`*^9, 
  3.741194967421525*^9}},ExpressionUUID->"99ffd8f0-b1a2-4665-92e2-\
f5530460aafc"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "x"},
       {"0", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`x}}], 
   MatrixForm[{{0, 0, $CellContext`x}, {
     0, 0, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.741194962522891*^9, 
  3.7411949716088037`*^9}},ExpressionUUID->"1e487099-31e7-4142-ad81-\
73bada98fb10"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        FractionBox["f", "t"]},
       {"0", "0", 
        FractionBox["e", "s"]},
       {
        FractionBox["f", "t"], 
        FractionBox["e", "s"], 
        FractionBox[
         RowBox[{"2", " ", "e", " ", "f"}], 
         RowBox[{"s", " ", "t"}]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, $CellContext`f/$CellContext`t}, {
     0, 0, $CellContext`e/$CellContext`s}, {$CellContext`f/$CellContext`t, \
$CellContext`e/$CellContext`s, 
      2 $CellContext`e $CellContext`f $CellContext`s^(-1)/$CellContext`t}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.741194962522891*^9, 
  3.7411949716116*^9}},ExpressionUUID->"61360d33-40ab-4d05-a510-52ad5418f888"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        FractionBox["e", "t"]},
       {"0", "0", 
        FractionBox["f", "s"]},
       {
        FractionBox["e", "t"], 
        FractionBox["f", "s"], 
        FractionBox[
         RowBox[{"2", " ", "e", " ", "f"}], 
         RowBox[{"s", " ", "t"}]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, $CellContext`e/$CellContext`t}, {
     0, 0, $CellContext`f/$CellContext`s}, {$CellContext`e/$CellContext`t, \
$CellContext`f/$CellContext`s, 
      2 $CellContext`e $CellContext`f $CellContext`s^(-1)/$CellContext`t}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.741194962522891*^9, 
  3.7411949716143713`*^9}},ExpressionUUID->"bce76d5e-a8af-4a7c-ab52-\
329115f6160b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "4"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"c", ",", " ", "e", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"e", "*", "ell"}], ",", " ", "c", ",", " ", "0"}], "}"}], 
       ",", " ", 
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "f", ",", " ", "g"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"x", " ", "*", " ", "A1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"c", "^", "2"}], "-", 
            RowBox[{
             RowBox[{"e", "^", "2"}], "*", "ell"}]}], ")"}]}], " ", "*", " ", 
         "B1"}], ")"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";", 
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"c", ",", " ", "e", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "e"}], "*", "ell"}], ",", " ", 
         RowBox[{"-", "c"}], ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "f", ",", " ", "g"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"x", " ", "*", " ", "A1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"c", "^", "2"}], " ", "-", " ", 
            RowBox[{
             RowBox[{"e", "^", "2"}], " ", "*", "ell"}]}], ")"}]}], " ", "*", 
         " ", "B1"}], ")"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741195034572331*^9, 3.741195105883779*^9}, {
  3.741195140628982*^9, 
  3.741195168243597*^9}},ExpressionUUID->"fd8af744-6cef-40f4-b167-\
3535f9ebca68"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "x"},
       {"0", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`x}}], 
   MatrixForm[{{0, 0, $CellContext`x}, {
     0, 0, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741195106884932*^9, {3.741195142751103*^9, 
   3.741195147520607*^9}},ExpressionUUID->"970d57d2-a9ca-4119-847a-\
00d7171ba466"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "e"}], " ", "ell", " ", "f"}], "+", 
          RowBox[{"c", " ", "s"}]}], 
         RowBox[{
          SuperscriptBox["c", "2"], "-", 
          RowBox[{
           SuperscriptBox["e", "2"], " ", "ell"}]}]]},
       {"0", "0", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "c"}], " ", "ell", " ", "f"}], "+", 
          RowBox[{"e", " ", "ell", " ", "s"}]}], 
         RowBox[{
          SuperscriptBox["c", "2"], "-", 
          RowBox[{
           SuperscriptBox["e", "2"], " ", "ell"}]}]]},
       {
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "e"}], " ", "ell", " ", "f"}], "+", 
          RowBox[{"c", " ", "s"}]}], 
         RowBox[{
          SuperscriptBox["c", "2"], "-", 
          RowBox[{
           SuperscriptBox["e", "2"], " ", "ell"}]}]], 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "c"}], " ", "ell", " ", "f"}], "+", 
          RowBox[{"e", " ", "ell", " ", "s"}]}], 
         RowBox[{
          SuperscriptBox["c", "2"], "-", 
          RowBox[{
           SuperscriptBox["e", "2"], " ", "ell"}]}]], 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "ell"}], " ", 
           SuperscriptBox["f", "2"]}], "+", 
          SuperscriptBox["s", "2"]}], 
         RowBox[{
          SuperscriptBox["c", "2"], "-", 
          RowBox[{
           SuperscriptBox["e", "2"], " ", "ell"}]}]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{
     0, 0, ($CellContext`c^2 - $CellContext`e^2 $CellContext`ell)^(-1) \
(-$CellContext`e $CellContext`ell $CellContext`f + $CellContext`c \
$CellContext`s)}, {
     0, 0, ($CellContext`c^2 - $CellContext`e^2 $CellContext`ell)^(-1) \
(-$CellContext`c $CellContext`ell $CellContext`f + $CellContext`e \
$CellContext`ell $CellContext`s)}, {($CellContext`c^2 - $CellContext`e^2 \
$CellContext`ell)^(-1) (-$CellContext`e $CellContext`ell $CellContext`f + \
$CellContext`c $CellContext`s), ($CellContext`c^2 - $CellContext`e^2 \
$CellContext`ell)^(-1) (-$CellContext`c $CellContext`ell $CellContext`f + \
$CellContext`e $CellContext`ell $CellContext`s), ($CellContext`c^2 - \
$CellContext`e^2 $CellContext`ell)^(-1) (-$CellContext`ell $CellContext`f^2 + \
$CellContext`s^2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741195106884932*^9, {3.741195142751103*^9, 
   3.741195147523275*^9}},ExpressionUUID->"9b6c9050-bfc1-465f-8289-\
012c47c4c956"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "e"}], " ", "ell", " ", "f"}], "+", 
          RowBox[{"c", " ", "s"}]}], 
         RowBox[{
          SuperscriptBox["c", "2"], "-", 
          RowBox[{
           SuperscriptBox["e", "2"], " ", "ell"}]}]]},
       {"0", "0", 
        FractionBox[
         RowBox[{"ell", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"c", " ", "f"}], "-", 
            RowBox[{"e", " ", "s"}]}], ")"}]}], 
         RowBox[{
          SuperscriptBox["c", "2"], "-", 
          RowBox[{
           SuperscriptBox["e", "2"], " ", "ell"}]}]]},
       {
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "e"}], " ", "ell", " ", "f"}], "+", 
          RowBox[{"c", " ", "s"}]}], 
         RowBox[{
          SuperscriptBox["c", "2"], "-", 
          RowBox[{
           SuperscriptBox["e", "2"], " ", "ell"}]}]], 
        FractionBox[
         RowBox[{"ell", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"c", " ", "f"}], "-", 
            RowBox[{"e", " ", "s"}]}], ")"}]}], 
         RowBox[{
          SuperscriptBox["c", "2"], "-", 
          RowBox[{
           SuperscriptBox["e", "2"], " ", "ell"}]}]], 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "ell"}], " ", 
           SuperscriptBox["f", "2"]}], "+", 
          SuperscriptBox["s", "2"]}], 
         RowBox[{
          SuperscriptBox["c", "2"], "-", 
          RowBox[{
           SuperscriptBox["e", "2"], " ", "ell"}]}]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{
     0, 0, ($CellContext`c^2 - $CellContext`e^2 $CellContext`ell)^(-1) \
(-$CellContext`e $CellContext`ell $CellContext`f + $CellContext`c \
$CellContext`s)}, {
     0, 0, $CellContext`ell ($CellContext`c^2 - $CellContext`e^2 \
$CellContext`ell)^(-1) ($CellContext`c $CellContext`f - $CellContext`e \
$CellContext`s)}, {($CellContext`c^2 - $CellContext`e^2 \
$CellContext`ell)^(-1) (-$CellContext`e $CellContext`ell $CellContext`f + \
$CellContext`c $CellContext`s), $CellContext`ell ($CellContext`c^2 - \
$CellContext`e^2 $CellContext`ell)^(-1) ($CellContext`c $CellContext`f - \
$CellContext`e $CellContext`s), ($CellContext`c^2 - $CellContext`e^2 \
$CellContext`ell)^(-1) (-$CellContext`ell $CellContext`f^2 + \
$CellContext`s^2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741195106884932*^9, {3.741195142751103*^9, 
   3.741195147527391*^9}},ExpressionUUID->"4d789ee9-a215-4a04-b486-\
27cac3f38c0b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "5"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "a", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "b", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"e", ",", " ", "f", ",", " ", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", "t"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"s", "^", "2"}], ")"}]}], " ", "*", " ", "B1"}], ")"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7411951769474277`*^9, 
  3.741195260090619*^9}},ExpressionUUID->"d6060784-658d-4138-a999-\
201330ce2c0e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "x"},
       {"0", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`x}}], 
   MatrixForm[{{0, 0, $CellContext`x}, {
     0, 0, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741195261762968*^9},ExpressionUUID->"f316b77b-1db0-47d5-ad85-\
8ca4fe5fe9b5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", 
        FractionBox[
         RowBox[{"2", " ", "e"}], "s"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{
         FractionBox["e", "s"], "+", 
         RowBox[{"s", " ", "t", " ", "y"}]}]},
       {"0", "0", "0"},
       {
        RowBox[{
         FractionBox["e", "s"], "+", 
         RowBox[{"s", " ", "t", " ", "y"}]}], "0", 
        RowBox[{"e", " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox["e", 
            SuperscriptBox["s", "2"]], "+", 
           RowBox[{"2", " ", "t", " ", "y"}]}], ")"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {
     0, 0, 2 $CellContext`e/$CellContext`s}}], 
   MatrixForm[{{
     0, 0, $CellContext`e/$CellContext`s + $CellContext`s $CellContext`t \
$CellContext`y}, {0, 0, 
     0}, {$CellContext`e/$CellContext`s + $CellContext`s $CellContext`t \
$CellContext`y, 
      0, $CellContext`e ($CellContext`e $CellContext`s^(-2) + 
       2 $CellContext`t $CellContext`y)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741195261765275*^9},ExpressionUUID->"b762f760-6b35-429d-9d94-\
15121e900d3d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "6"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "t", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"e", ",", " ", "f", ",", " ", "r"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"r", "*", "s"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"t", "^", "2"}], ")"}]}], " ", "*", " ", "B1"}], ")"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741195284378577*^9, 
  3.741195365898053*^9}},ExpressionUUID->"4c802a30-046a-46cc-8444-\
5562be3552b0"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "x"},
       {"0", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`x}}], 
   MatrixForm[{{0, 0, $CellContext`x}, {
     0, 0, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.741195351280613*^9, 
  3.741195366263401*^9}},ExpressionUUID->"82bcdb85-537a-4696-8698-\
c8a83b822530"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", 
        FractionBox[
         RowBox[{"2", " ", "e"}], "s"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{"r", " ", "s", " ", "y"}]},
       {"0", "0", 
        FractionBox["f", "t"]},
       {
        RowBox[{"r", " ", "s", " ", "y"}], 
        FractionBox["f", "t"], 
        RowBox[{
         FractionBox[
          SuperscriptBox["f", "2"], 
          SuperscriptBox["t", "2"]], "+", 
         RowBox[{"2", " ", "e", " ", "r", " ", "y"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {
     0, 0, 2 $CellContext`e/$CellContext`s}}], 
   MatrixForm[{{0, 0, $CellContext`r $CellContext`s $CellContext`y}, {
     0, 0, $CellContext`f/$CellContext`t}, {$CellContext`r $CellContext`s \
$CellContext`y, $CellContext`f/$CellContext`t, $CellContext`f^2 \
$CellContext`t^(-2) + 2 $CellContext`e $CellContext`r $CellContext`y}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.741195351280613*^9, 
  3.741195366265634*^9}},ExpressionUUID->"c0507ee0-e27f-46e4-b8fa-\
7f0373e76070"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "7"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "t", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"e", ",", " ", "f", ",", " ", "r"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"r", "*", "s"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"s", "*", "t"}], ")"}]}], " ", "*", " ", "B1"}], ")"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741195391537825*^9, 
  3.741195422065425*^9}},ExpressionUUID->"b735c89f-62dc-4eb3-b926-\
9bdbd7fe91c9"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "x"},
       {"0", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`x}}], 
   MatrixForm[{{0, 0, $CellContext`x}, {
     0, 0, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7411954226211443`*^9},ExpressionUUID->"e5e29c18-b97c-41b1-bac6-\
cf027d654db5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", 
        FractionBox[
         RowBox[{"2", " ", "e"}], "s"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{
         FractionBox["f", "t"], "+", 
         RowBox[{"r", " ", "s", " ", "y"}]}]},
       {"0", "0", 
        FractionBox["e", "s"]},
       {
        RowBox[{
         FractionBox["f", "t"], "+", 
         RowBox[{"r", " ", "s", " ", "y"}]}], 
        FractionBox["e", "s"], 
        RowBox[{"2", " ", "e", " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox["f", 
            RowBox[{"s", " ", "t"}]], "+", 
           RowBox[{"r", " ", "y"}]}], ")"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {
     0, 0, 2 $CellContext`e/$CellContext`s}}], 
   MatrixForm[{{
     0, 0, $CellContext`f/$CellContext`t + $CellContext`r $CellContext`s \
$CellContext`y}, {
     0, 0, $CellContext`e/$CellContext`s}, {$CellContext`f/$CellContext`t + \
$CellContext`r $CellContext`s $CellContext`y, $CellContext`e/$CellContext`s, 
      2 $CellContext`e ($CellContext`f $CellContext`s^(-1)/$CellContext`t + \
$CellContext`r $CellContext`y)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741195422623371*^9},ExpressionUUID->"150da60e-9699-4353-9725-\
e212929b01c5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "8"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"e", ",", " ", "f", ",", " ", "r"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"r", "*", "s"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"s", "^", "2"}], ")"}]}], " ", "*", " ", "B1"}], ")"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";", 
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "s"}], ",", " ", 
         RowBox[{"2", "*", "s"}], ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"e", ",", " ", "f", ",", " ", "r"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "/", 
         RowBox[{"(", 
          RowBox[{"r", "*", "s"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"s", "^", "2"}], ")"}]}], " ", "*", " ", "B1"}], ")"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741195459761394*^9, 
  3.7411955526005983`*^9}},ExpressionUUID->"605b7a29-f2f0-49ed-aca2-\
a736477bbc3e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "x"},
       {"0", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`x}}], 
   MatrixForm[{{0, 0, $CellContext`x}, {
     0, 0, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741195555646082*^9},ExpressionUUID->"a20c2d79-f7c3-402c-bbef-\
6c364ea64738"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", 
        FractionBox[
         RowBox[{"2", " ", "e"}], "s"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{
         FractionBox["f", "s"], "+", 
         RowBox[{"r", " ", "s", " ", "y"}]}]},
       {"0", "0", 
        FractionBox[
         RowBox[{"e", "+", "f"}], "s"]},
       {
        RowBox[{
         FractionBox["f", "s"], "+", 
         RowBox[{"r", " ", "s", " ", "y"}]}], 
        FractionBox[
         RowBox[{"e", "+", "f"}], "s"], 
        RowBox[{
         FractionBox[
          RowBox[{"f", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "e"}], "+", "f"}], ")"}]}], 
          SuperscriptBox["s", "2"]], "+", 
         RowBox[{"2", " ", "e", " ", "r", " ", "y"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {
     0, 0, 2 $CellContext`e/$CellContext`s}}], 
   MatrixForm[{{
     0, 0, $CellContext`f/$CellContext`s + $CellContext`r $CellContext`s \
$CellContext`y}, {
     0, 0, ($CellContext`e + $CellContext`f)/$CellContext`s}, \
{$CellContext`f/$CellContext`s + $CellContext`r $CellContext`s \
$CellContext`y, ($CellContext`e + $CellContext`f)/$CellContext`s, \
$CellContext`f (2 $CellContext`e + $CellContext`f) $CellContext`s^(-2) + 
      2 $CellContext`e $CellContext`r $CellContext`y}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741195555647827*^9},ExpressionUUID->"359cecf4-6dc3-44e5-becb-\
be95d6b3aea5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", "e"}], "s"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        FractionBox[
         RowBox[{
          RowBox[{"2", " ", "e"}], "+", "f", "-", 
          RowBox[{"r", " ", 
           SuperscriptBox["s", "2"], " ", "y"}]}], "s"]},
       {"0", "0", 
        FractionBox[
         RowBox[{"e", "+", "f"}], "s"]},
       {
        FractionBox[
         RowBox[{
          RowBox[{"2", " ", "e"}], "+", "f", "-", 
          RowBox[{"r", " ", 
           SuperscriptBox["s", "2"], " ", "y"}]}], "s"], 
        FractionBox[
         RowBox[{"e", "+", "f"}], "s"], 
        RowBox[{
         FractionBox[
          RowBox[{"f", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "e"}], "+", "f"}], ")"}]}], 
          SuperscriptBox["s", "2"]], "+", 
         RowBox[{"2", " ", "e", " ", "r", " ", "y"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {
     0, 0, (-2) $CellContext`e/$CellContext`s}}], 
   MatrixForm[{{
     0, 0, $CellContext`s^(-1) (
       2 $CellContext`e + $CellContext`f - $CellContext`r $CellContext`s^2 \
$CellContext`y)}, {
     0, 0, ($CellContext`e + $CellContext`f)/$CellContext`s}, \
{$CellContext`s^(-1) (
       2 $CellContext`e + $CellContext`f - $CellContext`r $CellContext`s^2 \
$CellContext`y), ($CellContext`e + $CellContext`f)/$CellContext`s, \
$CellContext`f (2 $CellContext`e + $CellContext`f) $CellContext`s^(-2) + 
      2 $CellContext`e $CellContext`r $CellContext`y}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741195555650351*^9},ExpressionUUID->"808ccf64-9e92-46b3-a5b8-\
a988d7bc7052"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "9"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"e", ",", " ", "f", ",", " ", "r"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"r", "*", "s"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"s", "^", "2"}], ")"}]}], " ", "*", " ", "B1"}], ")"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";", 
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{"-", "s"}], ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"e", ",", " ", "f", ",", " ", "r"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"r", "*", "s"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"s", "^", "2"}], ")"}]}], " ", "*", " ", "B1"}], ")"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7411955854406013`*^9, 
  3.7411956309524307`*^9}},ExpressionUUID->"b2f8a1b1-e10b-44b6-a44a-\
a291ba967c63"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "x"},
       {"0", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`x}}], 
   MatrixForm[{{0, 0, $CellContext`x}, {
     0, 0, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.74119563590425*^9},ExpressionUUID->"0f0fa11c-65c5-4ffc-bad2-b618adc1dc41"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", 
        FractionBox[
         RowBox[{"2", " ", "e"}], "s"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{
         FractionBox["e", "s"], "+", 
         RowBox[{"r", " ", "s", " ", "y"}]}]},
       {"0", "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"ell", " ", "f"}], "s"]}]},
       {
        RowBox[{
         FractionBox["e", "s"], "+", 
         RowBox[{"r", " ", "s", " ", "y"}]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"ell", " ", "f"}], "s"]}], 
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox["e", "2"], "-", 
           RowBox[{"ell", " ", 
            SuperscriptBox["f", "2"]}]}], 
          SuperscriptBox["s", "2"]], "+", 
         RowBox[{"2", " ", "e", " ", "r", " ", "y"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {
     0, 0, 2 $CellContext`e/$CellContext`s}}], 
   MatrixForm[{{
     0, 0, $CellContext`e/$CellContext`s + $CellContext`r $CellContext`s \
$CellContext`y}, {
     0, 0, -$CellContext`ell $CellContext`f/$CellContext`s}, \
{$CellContext`e/$CellContext`s + $CellContext`r $CellContext`s \
$CellContext`y, -$CellContext`ell $CellContext`f/$CellContext`s, \
($CellContext`e^2 - $CellContext`ell $CellContext`f^2) $CellContext`s^(-2) + 
      2 $CellContext`e $CellContext`r $CellContext`y}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741195635906148*^9},ExpressionUUID->"ca9b7a4d-64d4-43c6-8d44-\
6268ffe44803"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", 
        FractionBox[
         RowBox[{"2", " ", "e"}], "s"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{
         FractionBox["e", "s"], "+", 
         RowBox[{"r", " ", "s", " ", "y"}]}]},
       {"0", "0", 
        FractionBox[
         RowBox[{"ell", " ", "f"}], "s"]},
       {
        RowBox[{
         FractionBox["e", "s"], "+", 
         RowBox[{"r", " ", "s", " ", "y"}]}], 
        FractionBox[
         RowBox[{"ell", " ", "f"}], "s"], 
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox["e", "2"], "-", 
           RowBox[{"ell", " ", 
            SuperscriptBox["f", "2"]}]}], 
          SuperscriptBox["s", "2"]], "+", 
         RowBox[{"2", " ", "e", " ", "r", " ", "y"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {
     0, 0, 2 $CellContext`e/$CellContext`s}}], 
   MatrixForm[{{
     0, 0, $CellContext`e/$CellContext`s + $CellContext`r $CellContext`s \
$CellContext`y}, {
     0, 0, $CellContext`ell $CellContext`f/$CellContext`s}, \
{$CellContext`e/$CellContext`s + $CellContext`r $CellContext`s \
$CellContext`y, $CellContext`ell $CellContext`f/$CellContext`s, \
($CellContext`e^2 - $CellContext`ell $CellContext`f^2) $CellContext`s^(-2) + 
      2 $CellContext`e $CellContext`r $CellContext`y}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7411956359091673`*^9},ExpressionUUID->"3f97e383-8f77-4c44-ab3d-\
edc3001d69bd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "10"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "a", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "r", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"e", ",", " ", "f", ",", " ", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", "t"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{"z", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741195659760099*^9, 3.741195696407749*^9}, {
  3.741539141179599*^9, 
  3.7415391413628893`*^9}},ExpressionUUID->"a7ccb7f2-d42e-4a12-911b-\
922fc2670bf8"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "x"},
       {"0", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`x}}], 
   MatrixForm[{{0, 0, $CellContext`x}, {
     0, 0, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741195698171332*^9, {3.741539142036482*^9, 
   3.74153916784137*^9}},ExpressionUUID->"c19988e9-6b81-4114-90a4-\
08ae1b7e39da"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", 
        FractionBox[
         RowBox[{"2", " ", "e"}], "s"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{"s", " ", "t", " ", "y"}]},
       {"0", "0", "0"},
       {
        RowBox[{"s", " ", "t", " ", "y"}], "0", 
        RowBox[{"2", " ", "e", " ", "t", " ", "y"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {
     0, 0, 2 $CellContext`e/$CellContext`s}}], 
   MatrixForm[{{0, 0, $CellContext`s $CellContext`t $CellContext`y}, {0, 0, 
     0}, {$CellContext`s $CellContext`t $CellContext`y, 0, 
      2 $CellContext`e $CellContext`t $CellContext`y}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741195698171332*^9, {3.741539142036482*^9, 
   3.741539167843649*^9}},ExpressionUUID->"0ee101c1-f705-4e24-92cd-\
bc662d0dd7d0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "11"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "a", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "b", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "c", ",", " ", "d"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"s", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{"z", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741195731471562*^9, 
  3.741195774671135*^9}},ExpressionUUID->"1f1966c2-49a3-4d09-b3b2-\
617e28461a74"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "x"},
       {"0", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`x}}], 
   MatrixForm[{{0, 0, $CellContext`x}, {
     0, 0, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741195786804759*^9},ExpressionUUID->"56d8d3f9-6fa7-43e6-9926-\
7b8c2c326474"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741195786806755*^9},ExpressionUUID->"c5495997-9f48-4666-ac48-\
de68f6f4df26"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "12"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "a", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "t", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "c", ",", " ", "d"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"s", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"2", "*", 
           RowBox[{"a", "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"s", "^", "2"}], "*", "t"}], ")"}]}]}], ")"}]}], "*", 
        "A1"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"s", "*", "t"}], ")"}]}], ")"}], " ", "*", " ", "B1"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741195802671139*^9, 3.741195855150579*^9}, {
  3.74119589912784*^9, 
  3.741195900769588*^9}},ExpressionUUID->"30f71b9c-a771-40ea-a833-\
3a6a5299dba1"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "x"},
       {"0", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`x}}], 
   MatrixForm[{{0, 0, $CellContext`x}, {
     0, 0, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7411958594937563`*^9, 
  3.7411959011813602`*^9},ExpressionUUID->"6f12842e-11af-4ddd-96aa-\
abdcdea48b02"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        FractionBox["c", "t"]},
       {"0", "0", "0"},
       {
        FractionBox["c", "t"], "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, $CellContext`c/$CellContext`t}, {0, 0, 
     0}, {$CellContext`c/$CellContext`t, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7411958594937563`*^9, 
  3.741195901183908*^9},ExpressionUUID->"3d507bcc-3109-4298-9f46-\
d1d12ee27656"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "13"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "t", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "c", ",", " ", "d"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"s", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"t", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "B1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7411959235103283`*^9, 
  3.741195958357744*^9}},ExpressionUUID->"ec1c5f27-7ecc-4da4-9857-\
dc0427b98f81"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "x"},
       {"0", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`x}}], 
   MatrixForm[{{0, 0, $CellContext`x}, {
     0, 0, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7411959594822702`*^9},ExpressionUUID->"047e7f9f-bde8-4f80-844a-\
3b3045c6430a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", 
        FractionBox["c", "t"]},
       {"0", 
        FractionBox["c", "t"], 
        FractionBox[
         SuperscriptBox["c", "2"], 
         SuperscriptBox["t", "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`c/$CellContext`t}, {
     0, $CellContext`c/$CellContext`t, $CellContext`c^2 \
$CellContext`t^(-2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7411959594837112`*^9},ExpressionUUID->"5260c491-5a7d-42b1-90be-\
ee4b680abf6c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "14"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", 
         RowBox[{
          RowBox[{"-", "a"}], "*", 
          RowBox[{"t", "/", "s"}]}], ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "t", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "c", ",", " ", 
         RowBox[{
          RowBox[{"s", "^", "2"}], "/", "t"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"s", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"t", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "B1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741195983357855*^9, 
  3.741196029205558*^9}},ExpressionUUID->"e0ccf67c-40a0-44cf-bd65-\
b5f9051c8329"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "x"},
       {"0", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`x}}], 
   MatrixForm[{{0, 0, $CellContext`x}, {
     0, 0, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741196039851653*^9},ExpressionUUID->"a64a69e3-47b9-4952-8f7a-\
0641314798ae"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", 
        RowBox[{
         FractionBox[
          SuperscriptBox["a", "2"], 
          SuperscriptBox["s", "2"]], "+", 
         FractionBox[
          RowBox[{"2", " ", "c"}], "t"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {
     0, 0, $CellContext`a^2 $CellContext`s^(-2) + 
      2 $CellContext`c/$CellContext`t}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7411960398530684`*^9},ExpressionUUID->"366d28a2-8414-4d7f-b7ce-\
a05fa6d065be"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "15"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", 
         RowBox[{
          RowBox[{"-", "a"}], "*", 
          RowBox[{"t", "/", "s"}]}], ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "t", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "c", ",", " ", 
         RowBox[{
          RowBox[{"s", "^", "2"}], "/", "t"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"s", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "*", 
          RowBox[{"a", "/", 
           RowBox[{"s", "^", "3"}]}]}], ")"}], "*", "A1"}], "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"s", "*", "t"}], ")"}]}], ")"}], " ", "*", " ", "B1"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741196058813531*^9, 
  3.7411960988849983`*^9}},ExpressionUUID->"11ea9510-97ae-4a40-a84f-\
390a9586a979"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "x"},
       {"0", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`x}}], 
   MatrixForm[{{0, 0, $CellContext`x}, {
     0, 0, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7411961066741667`*^9},ExpressionUUID->"24a3062d-c4b9-4051-bfc5-\
e9bf731ae82e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", 
        RowBox[{
         FractionBox[
          SuperscriptBox["a", "2"], 
          SuperscriptBox["s", "2"]], "+", 
         FractionBox[
          RowBox[{"2", " ", "c"}], "t"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox["a", "2"], 
           SuperscriptBox["s", "2"]]}], "+", 
         FractionBox["c", "t"]}]},
       {"0", "0", 
        FractionBox[
         RowBox[{"3", " ", "a"}], "s"]},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox["a", "2"], 
           SuperscriptBox["s", "2"]]}], "+", 
         FractionBox["c", "t"]}], 
        FractionBox[
         RowBox[{"3", " ", "a"}], "s"], 
        FractionBox[
         RowBox[{"2", " ", "a", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["a", "2"], "+", 
            FractionBox[
             RowBox[{"3", " ", "c", " ", 
              SuperscriptBox["s", "2"]}], "t"]}], ")"}]}], 
         SuperscriptBox["s", "3"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {
     0, 0, $CellContext`a^2 $CellContext`s^(-2) + 
      2 $CellContext`c/$CellContext`t}}], 
   MatrixForm[{{
     0, 0, -$CellContext`a^2 $CellContext`s^(-2) + \
$CellContext`c/$CellContext`t}, {
     0, 0, 3 $CellContext`a/$CellContext`s}, {-$CellContext`a^2 \
$CellContext`s^(-2) + $CellContext`c/$CellContext`t, 
      3 $CellContext`a/$CellContext`s, 
      2 $CellContext`a $CellContext`s^(-3) ($CellContext`a^2 + 
       3 $CellContext`c $CellContext`s^2/$CellContext`t)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7411961066762123`*^9},ExpressionUUID->"920defc2-a39b-4ab4-8955-\
13161e76c719"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "16"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "t", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "c", ",", " ", 
         RowBox[{
          RowBox[{"s", "^", "2"}], "/", "t"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"s", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"t", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "B1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741196131332971*^9, 
  3.741196171612338*^9}},ExpressionUUID->"549bfb62-ffae-4e0b-b39c-\
cf4b384c5965"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "x"},
       {"0", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`x}}], 
   MatrixForm[{{0, 0, $CellContext`x}, {
     0, 0, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7411961730830917`*^9},ExpressionUUID->"84bb64f2-1ce7-46ff-ba10-\
6fd0c0a7957e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", 
        FractionBox[
         RowBox[{"2", " ", "c"}], "t"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", 
        FractionBox["c", "t"]},
       {"0", 
        FractionBox["c", "t"], 
        FractionBox[
         SuperscriptBox["c", "2"], 
         SuperscriptBox["t", "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {
     0, 0, 2 $CellContext`c/$CellContext`t}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`c/$CellContext`t}, {
     0, $CellContext`c/$CellContext`t, $CellContext`c^2 \
$CellContext`t^(-2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741196173085058*^9},ExpressionUUID->"85b9f342-5c26-4dd5-875c-\
b30f42a83b4e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "17"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "t", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "r"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", "t"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{"z", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";", 
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"t", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "r"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", "t"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{"z", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7411961957725773`*^9, 
  3.74119628091018*^9}},ExpressionUUID->"5f87122c-f80e-47da-a8dc-\
4a5e261a2dfd"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "x"},
       {"0", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`x}}], 
   MatrixForm[{{0, 0, $CellContext`x}, {
     0, 0, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.741196276734933*^9, 
  3.7411962812173767`*^9}},ExpressionUUID->"0be2cad9-272e-4ef3-b38f-\
397da1082faa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.741196276734933*^9, 
  3.741196281219511*^9}},ExpressionUUID->"814bba79-83d6-4e2c-aa0e-\
6d58e407ec7b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.741196276734933*^9, 
  3.741196281221385*^9}},ExpressionUUID->"5ce20311-81b3-42e7-8b05-\
4ecebe74f2e1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "18"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "t", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "r"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", "t"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"s", "^", "2"}]}], ")"}], " ", "*", " ", "B1"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741196301804083*^9, 
  3.741196331259347*^9}},ExpressionUUID->"5c52a119-fe91-463a-b710-\
3ddac1166bcd"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "x"},
       {"0", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`x}}], 
   MatrixForm[{{0, 0, $CellContext`x}, {
     0, 0, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741196331851585*^9},ExpressionUUID->"41ed7239-7d43-49c6-85c4-\
bcc2a3ae604d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741196331853457*^9},ExpressionUUID->"48087282-5e14-4ec9-991e-\
7305876730af"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "19"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{"eps", "*", "s"}], ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "r"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"eps", "/", 
         RowBox[{"(", 
          RowBox[{"s", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"s", "^", "2"}]}], ")"}], " ", "*", " ", "B1"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";", 
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", " ", 
        RowBox[{
         RowBox[{"eps", "*", "s"}], ",", "0", ",", " ", "0"}], "}"}], ",", 
       " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "r"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"eps", "/", 
         RowBox[{"(", 
          RowBox[{"s", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"s", "^", "2"}]}], ")"}], " ", "*", " ", "B1"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741196350323441*^9, 
  3.7411964442506332`*^9}},ExpressionUUID->"658077b2-e931-49cc-992d-\
7a28d12ef440"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "x"},
       {"0", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`x}}], 
   MatrixForm[{{0, 0, $CellContext`x}, {
     0, 0, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7411964536502333`*^9},ExpressionUUID->"ce9d697b-47fd-44b5-ae1c-\
de85acc7dc32"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["eps", "2"]}], "0"},
       {
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["eps", "2"]}], "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["eps", "2"]}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     0, -1 + $CellContext`eps^2, 0}, {-1 + $CellContext`eps^2, 0, 0}, {0, 0, 
     0}}], 
   MatrixForm[{{0, 0, 0}, {0, -1 + $CellContext`eps^2, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7411964536520243`*^9},ExpressionUUID->"cd55012a-f240-4dcb-b4d5-\
46e5829c7605"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["eps", "2"]}], "0"},
       {
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["eps", "2"]}], "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["eps", "2"]}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     0, -1 + $CellContext`eps^2, 0}, {-1 + $CellContext`eps^2, 0, 0}, {0, 0, 
     0}}], 
   MatrixForm[{{0, 0, 0}, {0, -1 + $CellContext`eps^2, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7411964536545677`*^9},ExpressionUUID->"f7a553a9-6434-4cad-9d43-\
950b24c42634"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "20"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "ell", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{"eps", "*", "s"}], ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "r"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"eps", "/", 
         RowBox[{"(", 
          RowBox[{"s", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"s", "^", "2"}]}], ")"}], " ", "*", " ", "B1"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";", 
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{"eps", "*", "s"}], ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", " ", 
        RowBox[{
         RowBox[{"s", "*", "ell"}], ",", "0", ",", " ", "0"}], "}"}], ",", 
       " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "r"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"eps", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"s", "^", "2"}], "*", "ell"}], ")"}]}], ")"}], " ", "*", 
       " ", "A1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"s", "^", "2"}], "*", "ell"}], ")"}]}], ")"}], " ", "*", 
       " ", "B1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741196487858788*^9, 
  3.741196580922215*^9}},ExpressionUUID->"099b5e15-dd03-4fac-99f3-\
451a21a9f904"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "x"},
       {"0", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`x}}], 
   MatrixForm[{{0, 0, $CellContext`x}, {
     0, 0, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.741196521968032*^9, 3.7411965496682863`*^9}, 
   3.741196581395612*^9},ExpressionUUID->"4d1a4049-fe1c-4df3-9c40-\
0278217b79df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["eps", "2"]}], "0"},
       {
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["eps", "2"]}], "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{
         RowBox[{"-", "ell"}], "+", 
         RowBox[{"ell", " ", 
          SuperscriptBox["eps", "2"]}]}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     0, -1 + $CellContext`eps^2, 0}, {-1 + $CellContext`eps^2, 0, 0}, {0, 0, 
     0}}], 
   MatrixForm[{{0, 0, 0}, {
     0, -$CellContext`ell + $CellContext`ell $CellContext`eps^2, 0}, {0, 0, 
     0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.741196521968032*^9, 3.7411965496682863`*^9}, 
   3.741196581397702*^9},ExpressionUUID->"9c30fdf5-d8e7-43bc-ba23-\
01c4a494332e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["eps", "2"]}], "0"},
       {
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["eps", "2"]}], "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["eps", "2"]}], "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     0, -1 + $CellContext`eps^2, 0}, {-1 + $CellContext`eps^2, 0, 0}, {0, 0, 
     0}}], 
   MatrixForm[{{-1 + $CellContext`eps^2, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.741196521968032*^9, 3.7411965496682863`*^9}, 
   3.741196581399848*^9},ExpressionUUID->"29c056f7-f990-4d22-a2a3-\
983124b8c304"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "21"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"c", ",", " ", "e", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"eps", "*", "e", "*", "ell"}], ",", " ", 
         RowBox[{"eps", "*", "c"}], ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "r"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", "^", "2"}], " ", "-", 
           RowBox[{"ell", "*", 
            RowBox[{"e", "^", "2"}]}]}], ")"}]}], ")"}], " ", "*", " ", 
       "A1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{"z", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7411966446416283`*^9, 
  3.741196715884112*^9}},ExpressionUUID->"4c6d4c9f-1117-467b-9290-\
5c272ed624a5"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "x"},
       {"0", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`x}}], 
   MatrixForm[{{0, 0, $CellContext`x}, {
     0, 0, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741196723042576*^9},ExpressionUUID->"1222dd46-4f23-4e01-a718-\
0be4668ad69d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"ell", "-", 
         RowBox[{"ell", " ", 
          SuperscriptBox["eps", "2"]}]}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {
     0, $CellContext`ell - $CellContext`ell $CellContext`eps^2, 0}, {0, 0, 
     0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.74119672304418*^9},ExpressionUUID->"28cd75ca-5da9-4924-8987-2f59d2c83870"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "22"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"c", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{"eps", "*", "c"}], ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "r"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"c", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"c", "^", "2"}], ")"}]}], ")"}], "*", " ", "B1"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{"eps", "*", "e"}], ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"e", "*", "ell"}], ",", " ", "0", ",", " ", "0"}], "}"}], 
       ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "r"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"e", "^", "2"}], "*", "ell"}], ")"}]}], ")"}], " ", "*", 
       " ", "A1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"e", "^", "2"}], "*", 
            RowBox[{"ell", "^", "2"}]}], ")"}]}], ")"}], "*", "A1"}], " ", 
       "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"e", "^", "2"}], "*", "ell"}], ")"}]}], ")"}], "*", " ", 
        "B1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741196740059828*^9, 
  3.741196865795115*^9}},ExpressionUUID->"d18543f0-6a1e-447e-a753-\
0c90a1e73233"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "x"},
       {"0", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`x}}], 
   MatrixForm[{{0, 0, $CellContext`x}, {
     0, 0, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741196867037466*^9},ExpressionUUID->"f8f48a9f-e96b-4fc4-a06f-\
cf6915347179"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"ell", "-", 
         RowBox[{"ell", " ", 
          SuperscriptBox["eps", "2"]}]}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["eps", "2"]}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {
     0, $CellContext`ell - $CellContext`ell $CellContext`eps^2, 0}, {0, 0, 
     0}}], 
   MatrixForm[{{0, 0, 0}, {0, -1 + $CellContext`eps^2, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741196867038918*^9},ExpressionUUID->"4329125d-b002-4708-add3-\
cd3bebf3a34a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["eps", "2"]}], "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{-1 + $CellContext`eps^2, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.741196867040969*^9},ExpressionUUID->"dd4246e8-0b77-4f8c-b95e-\
efeff1727aea"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "23", "a"}], "*)"}], 
  
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"c", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{"eps", "*", "c"}], ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "r"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"c", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"eps", "/", 
         RowBox[{"(", 
          RowBox[{"c", "^", "2"}], ")"}]}], ")"}], "*", " ", "B1"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "e", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"eps", "*", "e", "*", "ell"}], ",", " ", "0", ",", " ", 
         "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "r"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"e", "^", "2"}], "*", "ell"}], ")"}]}], ")"}], " ", "*", 
       " ", "A1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Simplify", "[", "   ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"eps", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"e", "^", "2"}], "*", "ell"}], ")"}]}], ")"}], "*", " ", 
       "B1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7411968913710012`*^9, 3.7411968996747313`*^9}, {
  3.7411969346027737`*^9, 3.741196947882267*^9}, {3.7415396549120417`*^9, 
  3.741539658303516*^9}},ExpressionUUID->"03e82dfd-bf69-4336-b7f6-\
f1371b4ff84b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "x"},
       {"0", "0", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, $CellContext`x}}], 
   MatrixForm[{{0, 0, $CellContext`x}, {
     0, 0, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741196951451817*^9, 
  3.741539668101486*^9},ExpressionUUID->"4a453523-e335-43e4-b95c-\
0357c0a7eb4a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"ell", "-", 
         RowBox[{"ell", " ", 
          SuperscriptBox["eps", "2"]}]}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["eps", "2"]}], "0"},
       {
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["eps", "2"]}], "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {
     0, $CellContext`ell - $CellContext`ell $CellContext`eps^2, 0}, {0, 0, 
     0}}], 
   MatrixForm[{{
     0, -1 + $CellContext`eps^2, 0}, {-1 + $CellContext`eps^2, 0, 0}, {0, 0, 
     0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741196951451817*^9, 
  3.741539668103496*^9},ExpressionUUID->"db940eb6-909d-401a-a223-\
b3c4388c1f93"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"ell", "-", 
         RowBox[{"ell", " ", 
          SuperscriptBox["eps", "2"]}]}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["eps", "2"]}], "0"},
       {
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["eps", "2"]}], "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {
     0, $CellContext`ell - $CellContext`ell $CellContext`eps^2, 0}, {0, 0, 
     0}}], 
   MatrixForm[{{
     0, -1 + $CellContext`eps^2, 0}, {-1 + $CellContext`eps^2, 0, 0}, {0, 0, 
     0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741196951451817*^9, 
  3.741539668105385*^9},ExpressionUUID->"0d7b6358-6b20-4aa1-af47-\
6aaaaeadda6b"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{199, Automatic}, {43, Automatic}},
FrontEndVersion->"11.1 for Linux x86 (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1850, 44, 247, "Input", "ExpressionUUID" -> \
"35ccf8f4-e3c7-4ee2-8dab-78c4569c64c8"],
Cell[2411, 66, 175, 3, 32, "Input", "ExpressionUUID" -> \
"bdf5668b-9399-411f-9d58-b956b9d2bc8b"],
Cell[CellGroupData[{
Cell[2611, 73, 3880, 99, 353, "Input", "ExpressionUUID" -> \
"adcff66d-c664-484d-8ebd-608a3d1a6706"],
Cell[CellGroupData[{
Cell[6516, 176, 1902, 51, 59, "Print", "ExpressionUUID" -> \
"abd638b8-99e5-4601-99f2-c6664d09bbc9"],
Cell[8421, 229, 2063, 56, 82, "Print", "ExpressionUUID" -> \
"7175d4a2-65fc-4c79-8b20-84fa59688594"]
}, Open  ]]
}, Open  ]],
Cell[10511, 289, 154, 3, 32, "Input", "ExpressionUUID" -> \
"cd4d0252-c084-4465-a80c-7d76797a79c7"],
Cell[CellGroupData[{
Cell[10690, 296, 4846, 136, 537, "Input", "ExpressionUUID" -> \
"99ffd8f0-b1a2-4665-92e2-f5530460aafc"],
Cell[CellGroupData[{
Cell[15561, 436, 1688, 47, 59, "Print", "ExpressionUUID" -> \
"1e487099-31e7-4142-ad81-73bada98fb10"],
Cell[17252, 485, 1993, 54, 87, "Print", "ExpressionUUID" -> \
"61360d33-40ab-4d05-a510-52ad5418f888"],
Cell[19248, 541, 1999, 55, 87, "Print", "ExpressionUUID" -> \
"bce76d5e-a8af-4a7c-ab52-329115f6160b"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21296, 602, 5222, 148, 493, "Input", "ExpressionUUID" -> \
"fd8af744-6cef-40f4-b167-3535f9ebca68"],
Cell[CellGroupData[{
Cell[26543, 754, 1712, 48, 59, "Print", "ExpressionUUID" -> \
"970d57d2-a9ca-4119-847a-00d7171ba466"],
Cell[28258, 804, 3844, 104, 96, "Print", "ExpressionUUID" -> \
"9b6c9050-bfc1-465f-8289-012c47c4c956"],
Cell[32105, 910, 3844, 106, 96, "Print", "ExpressionUUID" -> \
"4d789ee9-a215-4a04-b486-27cac3f38c0b"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35998, 1022, 3313, 94, 309, "Input", "ExpressionUUID" -> \
"d6060784-658d-4138-a999-201330ce2c0e"],
Cell[CellGroupData[{
Cell[39336, 1120, 1662, 47, 59, "Print", "ExpressionUUID" -> \
"f316b77b-1db0-47d5-ad85-8ca4fe5fe9b5"],
Cell[41001, 1169, 2324, 66, 79, "Print", "ExpressionUUID" -> \
"b762f760-6b35-429d-9d94-15121e900d3d"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43374, 1241, 3311, 94, 309, "Input", "ExpressionUUID" -> \
"4c802a30-046a-46cc-8444-5562be3552b0"],
Cell[CellGroupData[{
Cell[46710, 1339, 1686, 47, 59, "Print", "ExpressionUUID" -> \
"82bcdb85-537a-4696-8698-c8a83b822530"],
Cell[48399, 1388, 2232, 60, 84, "Print", "ExpressionUUID" -> \
"c0507ee0-e27f-46e4-b8fa-7f0373e76070"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50680, 1454, 3311, 94, 309, "Input", "ExpressionUUID" -> \
"b735c89f-62dc-4eb3-b926-9bdbd7fe91c9"],
Cell[CellGroupData[{
Cell[54016, 1552, 1664, 47, 59, "Print", "ExpressionUUID" -> \
"e5e29c18-b97c-41b1-bac6-cf027d654db5"],
Cell[55683, 1601, 2442, 68, 88, "Print", "ExpressionUUID" -> \
"150da60e-9699-4353-9725-e212929b01c5"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[58174, 1675, 5122, 146, 493, "Input", "ExpressionUUID" -> \
"605b7a29-f2f0-49ed-aca2-a736477bbc3e"],
Cell[CellGroupData[{
Cell[63321, 1825, 1662, 47, 59, "Print", "ExpressionUUID" -> \
"a20c2d79-f7c3-402c-bbef-6c364ea64738"],
Cell[64986, 1874, 2635, 73, 90, "Print", "ExpressionUUID" -> \
"359cecf4-6dc3-44e5-becb-be95d6b3aea5"],
Cell[67624, 1949, 2886, 80, 98, "Print", "ExpressionUUID" -> \
"808ccf64-9e92-46b3-a5b8-a988d7bc7052"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[70559, 2035, 5096, 145, 493, "Input", "ExpressionUUID" -> \
"b2f8a1b1-e10b-44b6-a44a-a291ba967c63"],
Cell[CellGroupData[{
Cell[75680, 2184, 1659, 46, 59, "Print", "ExpressionUUID" -> \
"0f0fa11c-65c5-4ffc-bad2-b618adc1dc41"],
Cell[77342, 2232, 2695, 75, 92, "Print", "ExpressionUUID" -> \
"ca9b7a4d-64d4-43c6-8d44-6268ffe44803"],
Cell[80040, 2309, 2643, 73, 92, "Print", "ExpressionUUID" -> \
"3f97e383-8f77-4c44-ab3d-edc3001d69bd"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[82732, 2388, 3238, 91, 309, "Input", "ExpressionUUID" -> \
"a7ccb7f2-d42e-4a12-911b-922fc2670bf8"],
Cell[CellGroupData[{
Cell[85995, 2483, 1711, 48, 59, "Print", "ExpressionUUID" -> \
"c19988e9-6b81-4114-90a4-08ae1b7e39da"],
Cell[87709, 2533, 1990, 54, 69, "Print", "ExpressionUUID" -> \
"0ee101c1-f705-4e24-92cd-bc662d0dd7d0"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[89748, 2593, 3125, 88, 309, "Input", "ExpressionUUID" -> \
"1f1966c2-49a3-4d09-b3b2-617e28461a74"],
Cell[CellGroupData[{
Cell[92898, 2685, 1662, 47, 59, "Print", "ExpressionUUID" -> \
"56d8d3f9-6fa7-43e6-9926-7b8c2c326474"],
Cell[94563, 2734, 1576, 45, 59, "Print", "ExpressionUUID" -> \
"c5495997-9f48-4666-ac48-de68f6f4df26"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[96188, 2785, 3588, 103, 309, "Input", "ExpressionUUID" -> \
"30f71b9c-a771-40ea-a833-3a6a5299dba1"],
Cell[CellGroupData[{
Cell[99801, 2892, 1688, 47, 59, "Print", "ExpressionUUID" -> \
"6f12842e-11af-4ddd-96aa-abdcdea48b02"],
Cell[101492, 2941, 1716, 48, 75, "Print", "ExpressionUUID" -> \
"3d507bcc-3109-4298-9f46-d1d12ee27656"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[103257, 2995, 3248, 92, 309, "Input", "ExpressionUUID" -> \
"ec1c5f27-7ecc-4da4-9857-dc0427b98f81"],
Cell[CellGroupData[{
Cell[106530, 3091, 1664, 47, 59, "Print", "ExpressionUUID" -> \
"047e7f9f-bde8-4f80-844a-3b3045c6430a"],
Cell[108197, 3140, 1820, 52, 82, "Print", "ExpressionUUID" -> \
"5260c491-5a7d-42b1-90be-ee4b680abf6c"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[110066, 3198, 3394, 97, 309, "Input", "ExpressionUUID" -> \
"e0ccf67c-40a0-44cf-bd65-b5f9051c8329"],
Cell[CellGroupData[{
Cell[113485, 3299, 1662, 47, 59, "Print", "ExpressionUUID" -> \
"a64a69e3-47b9-4952-8f7a-0641314798ae"],
Cell[115150, 3348, 1840, 53, 74, "Print", "ExpressionUUID" -> \
"366d28a2-8414-4d7f-b7ce-a05fa6d065be"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[117039, 3407, 3579, 103, 309, "Input", "ExpressionUUID" -> \
"11ea9510-97ae-4a40-a84f-390a9586a979"],
Cell[CellGroupData[{
Cell[120643, 3514, 1664, 47, 59, "Print", "ExpressionUUID" -> \
"24a3062d-c4b9-4051-bfc5-e9bf731ae82e"],
Cell[122310, 3563, 2953, 85, 115, "Print", "ExpressionUUID" -> \
"920defc2-a39b-4ab4-8955-13161e76c719"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[125312, 3654, 3307, 94, 309, "Input", "ExpressionUUID" -> \
"549bfb62-ffae-4e0b-b39c-cf4b384c5965"],
Cell[CellGroupData[{
Cell[128644, 3752, 1664, 47, 59, "Print", "ExpressionUUID" -> \
"84bb64f2-1ce7-46ff-ba10-6fd0c0a7957e"],
Cell[130311, 3801, 1911, 55, 82, "Print", "ExpressionUUID" -> \
"85b9f342-5c26-4dd5-875c-b30f42a83b4e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[132271, 3862, 4668, 131, 493, "Input", "ExpressionUUID" -> \
"5f87122c-f80e-47da-a8dc-4a5e261a2dfd"],
Cell[CellGroupData[{
Cell[136964, 3997, 1688, 47, 59, "Print", "ExpressionUUID" -> \
"0be2cad9-272e-4ef3-b38f-397da1082faa"],
Cell[138655, 4046, 1600, 45, 59, "Print", "ExpressionUUID" -> \
"814bba79-83d6-4e2c-aa0e-6d58e407ec7b"],
Cell[140258, 4093, 1600, 45, 59, "Print", "ExpressionUUID" -> \
"5ce20311-81b3-42e7-8b05-4ecebe74f2e1"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[141907, 4144, 3213, 91, 309, "Input", "ExpressionUUID" -> \
"5c52a119-fe91-463a-b710-3ddac1166bcd"],
Cell[CellGroupData[{
Cell[145145, 4239, 1662, 47, 59, "Print", "ExpressionUUID" -> \
"41ed7239-7d43-49c6-85c4-bcc2a3ae604d"],
Cell[146810, 4288, 1576, 45, 59, "Print", "ExpressionUUID" -> \
"48087282-5e14-4ec9-991e-7305876730af"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[148435, 4339, 4921, 140, 493, "Input", "ExpressionUUID" -> \
"658077b2-e931-49cc-992d-7a28d12ef440"],
Cell[CellGroupData[{
Cell[153381, 4483, 1664, 47, 59, "Print", "ExpressionUUID" -> \
"ce9d697b-47fd-44b5-ae1c-de85acc7dc32"],
Cell[155048, 4532, 1917, 56, 65, "Print", "ExpressionUUID" -> \
"cd55012a-f240-4dcb-b4d5-46e5829c7605"],
Cell[156968, 4590, 1917, 56, 65, "Print", "ExpressionUUID" -> \
"f7a553a9-6434-4cad-9d43-950b24c42634"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[158934, 4652, 5056, 144, 493, "Input", "ExpressionUUID" -> \
"099b5e15-dd03-4fac-99f3-451a21a9f904"],
Cell[CellGroupData[{
Cell[164015, 4800, 1711, 47, 59, "Print", "ExpressionUUID" -> \
"4d1a4049-fe1c-4df3-9c40-0278217b79df"],
Cell[165729, 4849, 2043, 59, 65, "Print", "ExpressionUUID" -> \
"9c30fdf5-d8e7-43bc-ba23-01c4a494332e"],
Cell[167775, 4910, 1964, 56, 65, "Print", "ExpressionUUID" -> \
"29c056f7-f990-4d22-a2a3-983124b8c304"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[169788, 4972, 3337, 94, 309, "Input", "ExpressionUUID" -> \
"4c6d4c9f-1117-467b-9290-5c272ed624a5"],
Cell[CellGroupData[{
Cell[173150, 5070, 1662, 47, 59, "Print", "ExpressionUUID" -> \
"1222dd46-4f23-4e01-a718-0be4668ad69d"],
Cell[174815, 5119, 1735, 49, 62, "Print", "ExpressionUUID" -> \
"28cd75ca-5da9-4924-8987-2f59d2c83870"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[176599, 5174, 5439, 158, 493, "Input", "ExpressionUUID" -> \
"d18543f0-6a1e-447e-a753-0c90a1e73233"],
Cell[CellGroupData[{
Cell[182063, 5336, 1662, 47, 59, "Print", "ExpressionUUID" -> \
"f8f48a9f-e96b-4fc4-a06f-cf6915347179"],
Cell[183728, 5385, 1847, 53, 62, "Print", "ExpressionUUID" -> \
"4329125d-b002-4708-add3-cd3bebf3a34a"],
Cell[185578, 5440, 1685, 48, 62, "Print", "ExpressionUUID" -> \
"dd4246e8-0b77-4f8c-b95e-efeff1727aea"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[187312, 5494, 5267, 150, 493, "Input", "ExpressionUUID" -> \
"03e82dfd-bf69-4336-b7f6-f1371b4ff84b"],
Cell[CellGroupData[{
Cell[192604, 5648, 1684, 47, 59, "Print", "ExpressionUUID" -> \
"4a453523-e335-43e4-b95c-0357c0a7eb4a"],
Cell[194291, 5697, 1990, 58, 65, "Print", "ExpressionUUID" -> \
"db940eb6-909d-401a-a223-b3c4388c1f93"],
Cell[196284, 5757, 1990, 58, 65, "Print", "ExpressionUUID" -> \
"0d7b6358-6b20-4aa1-af47-6aaaaeadda6b"]
}, Open  ]]
}, Open  ]]
}
]
*)

