(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    224816,       6416]
NotebookOptionsPosition[    215090,       6170]
NotebookOutlinePosition[    215426,       6185]
CellTagsIndexPosition[    215383,       6182]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "This", " ", "file", " ", "verifies", " ", "that", " ", "the", " ", 
    "claimed", " ", "stabilizer", " ", "fixes", " ", "the", " ", "form", " ", 
    "in", " ", "the", " ", "case", " ", "of", " ", "orbits", " ", "of", " ", 
    RowBox[{"OD11", ".", "  ", "The"}], " ", "verification", " ", "that", " ",
     "the", " ", "stabilizer", " ", "is", " ", "no", " ", "larger", " ", "is",
     " ", "given", " ", "as", " ", "a", " ", "proof", " ", "in", " ", "the", 
    " ", "main", " ", 
    RowBox[{"text", ".", " ", "The"}], " ", "condition", " ", "that", " ", 
    "the", " ", "form", " ", "is", " ", "stabilized", " ", "amounts", " ", 
    "to", " ", "the", " ", "final", " ", "matrix", " ", "lies", " ", "in", 
    " ", "the", " ", "space", " ", 
    RowBox[{"(", 
     RowBox[{"Vx1", ",", " ", "Vx2"}], ")"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Vx1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "x", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "x", ",", " ", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Verification", " ", "of", " ", "orbit", " ", "1"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", "d", ",", 
      " ", "r", ",", " ", "s", ",", " ", "tA11", ",", " ", "A12", ",", " ", 
      "A13", ",", " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", 
      "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", 
      "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "c", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "d"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "A1"}], " ", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", "  ", 
      RowBox[{"t", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "c"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "d", ",", " ", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "A1"}], " ", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", "  ", 
      RowBox[{"t", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.733603881811367*^9, 3.733604137603126*^9}, {
   3.733604170891293*^9, 3.733604198122884*^9}, {3.7336054403800087`*^9, 
   3.7336054762674303`*^9}, {3.733673632099154*^9, 3.733673683457472*^9}, {
   3.7336737722487803`*^9, 3.733673780336542*^9}, {3.733690015157235*^9, 
   3.7336900196212273`*^9}, {3.733690071261084*^9, 3.733690159956675*^9}, 
   3.733690431181098*^9, {3.733691984370245*^9, 3.733692041601634*^9}, {
   3.7336938092877293`*^9, 3.733693882845791*^9}, {3.7337371089756193`*^9, 
   3.7337371639099083`*^9}, {3.7337478695101337`*^9, 3.733747902316284*^9}, {
   3.741191461432852*^9, 3.741191510776518*^9}, {3.741191752320649*^9, 
   3.7411917670708447`*^9}, 3.7411918358789454`*^9, {3.741192157988414*^9, 
   3.741192301355195*^9}, {3.74119240537992*^9, 3.7411925096664457`*^9}, {
   3.741194487074191*^9, 
   3.74119449440027*^9}},ExpressionUUID->"3a9fe989-7f0e-4d43-8335-\
bfe6306b570e"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "x"},
       {"0", "x", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`x}, {0, $CellContext`x, 0}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733605477720667*^9, 3.733673782399786*^9, 3.733690161316215*^9, 
   3.7336920469496527`*^9, 3.73369388646804*^9, 3.733737165454852*^9, 
   3.733747904261256*^9, {3.741192394097343*^9, 3.741192406531364*^9}, 
   3.741192479038548*^9, 3.741192510127993*^9, {3.7411944950150833`*^9, 
   3.741194498035461*^9}},ExpressionUUID->"3385478a-9728-4908-b20a-\
334570cb8cad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733605477720667*^9, 3.733673782399786*^9, 3.733690161316215*^9, 
   3.7336920469496527`*^9, 3.73369388646804*^9, 3.733737165454852*^9, 
   3.733747904261256*^9, {3.741192394097343*^9, 3.741192406531364*^9}, 
   3.741192479038548*^9, 3.741192510127993*^9, {3.7411944950150833`*^9, 
   3.741194498036757*^9}},ExpressionUUID->"59e31aac-f844-4bf1-bfc5-\
ffc15614838b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733605477720667*^9, 3.733673782399786*^9, 3.733690161316215*^9, 
   3.7336920469496527`*^9, 3.73369388646804*^9, 3.733737165454852*^9, 
   3.733747904261256*^9, {3.741192394097343*^9, 3.741192406531364*^9}, 
   3.741192479038548*^9, 3.741192510127993*^9, {3.7411944950150833`*^9, 
   3.741194498037923*^9}},ExpressionUUID->"19dd6a2d-56a1-4e76-8924-\
0f3f7db5f34c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "2"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", "d", ",", 
      " ", "r", ",", " ", "s", ",", " ", "tA11", ",", " ", "A12", ",", " ", 
      "A13", ",", " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", 
      "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", 
      "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "r", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "d"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "A1"}], " ", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", "  ", 
      RowBox[{"t", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", "*", "r"}], ",", " ", 
         RowBox[{"-", "r"}], ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "d"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "A1"}], " ", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", "  ", 
      RowBox[{"t", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741192541258119*^9, 
  3.741192582145461*^9}},ExpressionUUID->"055c22e1-c1f6-4267-b777-\
b91c65034344"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "x"},
       {"0", "x", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`x}, {0, $CellContext`x, 0}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741192583309943*^9, 
  3.741194500877305*^9},ExpressionUUID->"15c564fe-ee07-4498-a76e-\
ec00f03d7e3f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741192583309943*^9, 
  3.741194500879343*^9},ExpressionUUID->"de85ad74-667b-4981-956b-\
4a9d04febf38"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741192583309943*^9, 
  3.741194500881247*^9},ExpressionUUID->"0e9d8237-321b-433a-bd14-\
4836c8fbae7f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "3"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", "d", ",", 
      " ", "r", ",", " ", "s", ",", " ", "tA11", ",", " ", "A12", ",", " ", 
      "A13", ",", " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", 
      "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", 
      "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "1", ",", " ", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "r", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "r"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "A1"}], " ", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", "  ", 
      RowBox[{"t", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "r"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "r", ",", " ", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "A1"}], " ", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", "  ", 
      RowBox[{"t", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";", 
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", "*", "r"}], ",", " ", 
         RowBox[{"-", "r"}], ",", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", "*", "r"}], ",", " ", "0", ",", " ", 
         RowBox[{"-", "r"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "A1"}], " ", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", "  ", 
      RowBox[{"t", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";", 
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", "*", "r"}], ",", " ", "0", ",", " ", 
         RowBox[{"-", "r"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", "*", "r"}], ",", " ", 
         RowBox[{"-", "r"}], ",", " ", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "A1"}], " ", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", "  ", 
      RowBox[{"t", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";", 
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", "*", "r"}], ",", " ", 
         RowBox[{"-", "r"}], ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "r"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "A1"}], " ", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", "  ", 
      RowBox[{"t", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";", 
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", "*", "r"}], ",", " ", "0", ",", " ", 
         RowBox[{"-", "r"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "r", ",", " ", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "A1"}], " ", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", "  ", 
      RowBox[{"t", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";", 
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "r", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", "*", "r"}], ",", " ", "0", ",", " ", 
         RowBox[{"-", "r"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "A1"}], " ", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", "  ", 
      RowBox[{"t", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "r"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", "*", "r"}], ",", " ", 
         RowBox[{"-", "r"}], ",", " ", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "A1"}], " ", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", "  ", 
      RowBox[{"t", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.741192595841955*^9, 3.741192634233099*^9}, {
  3.741192668251575*^9, 
  3.7411928049204407`*^9}},ExpressionUUID->"fc807d64-c974-4f1f-b5a0-\
f1951d05dcc9"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "x"},
       {"0", "x", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`x}, {0, $CellContext`x, 0}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741192805557073*^9, 
  3.741194504465007*^9},ExpressionUUID->"dd230697-1ea9-4d0b-b0a1-\
730c6749fcc7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741192805557073*^9, 
  3.741194504466918*^9},ExpressionUUID->"b5ff61f3-8a6f-4158-bcec-\
e4b772150c5b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741192805557073*^9, 
  3.741194504469191*^9},ExpressionUUID->"4bc9005e-18f6-45be-9cfa-\
2c55358d2bc4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741192805557073*^9, 
  3.741194504471171*^9},ExpressionUUID->"f92101ad-55f9-4dbc-a3aa-\
65ca29cc4304"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741192805557073*^9, 
  3.741194504472911*^9},ExpressionUUID->"aa5dd2e6-018c-44fd-a165-\
cc73e046772e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "2"},
       {"0", "2", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 2}, {0, 2, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741192805557073*^9, 
  3.741194504474753*^9},ExpressionUUID->"b85b9aad-66e7-4231-ab20-\
4278b3d56480"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "2"},
       {"0", "2", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 2}, {0, 2, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741192805557073*^9, 
  3.741194504476645*^9},ExpressionUUID->"0d0f9b81-fa17-41ea-806d-\
223b5dc5f579"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "2"},
       {"0", "2", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 2}, {0, 2, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741192805557073*^9, 
  3.741194504478499*^9},ExpressionUUID->"92ba575f-161d-4463-b506-\
b0d96b95b5a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "2"},
       {"0", "2", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 2}, {0, 2, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741192805557073*^9, 
  3.741194504480384*^9},ExpressionUUID->"664b8185-0d69-4d48-b74f-\
008eb1212edd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "4"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", "d", ",", 
      " ", "r", ",", " ", "s", ",", " ", "tA11", ",", " ", "A12", ",", " ", 
      "A13", ",", " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", 
      "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", 
      "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "r", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "d"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "A1"}], " ", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", "  ", 
      RowBox[{"t", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{"-", "r"}], ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "d"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "A1"}], " ", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", "  ", 
      RowBox[{"t", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7336040005819197`*^9, 3.733604001915707*^9}, {
  3.741192856602807*^9, 
  3.741192885311974*^9}},ExpressionUUID->"941b7081-266f-479b-93ba-\
ca13f82cfbb7"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "x"},
       {"0", "x", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`x}, {0, $CellContext`x, 0}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7411928968887978`*^9, 
  3.7411945084531384`*^9},ExpressionUUID->"3b04303f-6698-4f2b-b199-\
ce958cd11ecf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7411928968887978`*^9, 
  3.741194508455245*^9},ExpressionUUID->"ea69fe18-05b0-4595-a21e-\
9a430c4f66fb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7411928968887978`*^9, 
  3.7411945084576674`*^9},ExpressionUUID->"2fcb2c2b-2b45-4558-8a7b-\
d96b0e05bd5a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "5"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", "d", ",", 
      " ", "r", ",", " ", "s", ",", " ", "tA11", ",", " ", "A12", ",", " ", 
      "A13", ",", " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", 
      "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", 
      "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "r", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "r"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "A1"}], " ", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", "  ", 
      RowBox[{"t", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{"-", "r"}], ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "r"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "A1"}], " ", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", "  ", 
      RowBox[{"t", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";", 
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "r", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", "*", "r"}], ",", " ", "0", ",", " ", 
         RowBox[{"-", "r"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "A1"}], " ", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", "  ", 
      RowBox[{"t", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{"-", "r"}], ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", "*", "r"}], ",", " ", "0", ",", " ", 
         RowBox[{"-", "r"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "A1"}], " ", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", "  ", 
      RowBox[{"t", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741192922231572*^9, 3.7411930132548018`*^9}, {
  3.741193053972488*^9, 
  3.74119305405179*^9}},ExpressionUUID->"5dfca301-d4bc-4ae1-b061-\
70fc3c465994"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "x"},
       {"0", "x", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`x}, {0, $CellContext`x, 0}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741193014206059*^9, 
  3.7411945119744463`*^9},ExpressionUUID->"cb4afddd-eaa8-4380-b72e-\
5fefe51d829a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741193014206059*^9, 
  3.741194511976569*^9},ExpressionUUID->"fba9f366-c2c7-4e14-a526-\
a3cd18b1f967"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741193014206059*^9, 
  3.741194511978615*^9},ExpressionUUID->"57708341-1ca4-4cd5-a1c2-\
c6b2cec00c8f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741193014206059*^9, 
  3.74119451198055*^9},ExpressionUUID->"89304581-66a0-483b-9b7f-60a0554b7555"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741193014206059*^9, 
  3.7411945119825573`*^9},ExpressionUUID->"1a63ccc3-ed14-4903-8f18-\
8d6a6b93ba6b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "6"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", "d", ",", 
      " ", "r", ",", " ", "s", ",", " ", "tA11", ",", " ", "A12", ",", " ", 
      "A13", ",", " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", 
      "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", 
      "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", "ell"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{"eps1", " ", "*", "r"}], ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", 
         RowBox[{"eps2", "*", "r"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "A1"}], " ", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", "  ", 
      RowBox[{"t", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", 
         RowBox[{"eps1", "*", "r"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", 
         RowBox[{"eps2", "*", "r"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "A1"}], " ", 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", "  ", 
      RowBox[{"t", " ", "*", " ", "B1"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.733747954307736*^9, 3.733747981347906*^9}, 
   3.7411923080777817`*^9, {3.741193059997666*^9, 3.74119311217712*^9}, {
   3.741193148179438*^9, 
   3.741193151712762*^9}},ExpressionUUID->"ee3b5200-da36-41a1-b81c-\
22ddee0aeca4"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "x"},
       {"0", "x", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`x}, {0, $CellContext`x, 0}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.733747958244269*^9, 3.733747981947329*^9}, 
   3.741193114083714*^9, 3.7411931551926403`*^9, 
   3.7411945149277887`*^9},ExpressionUUID->"c63ceb1a-5e06-4f2f-aa46-\
021cc3325a78"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"ell", "-", 
         RowBox[{"ell", " ", 
          SuperscriptBox["eps1", "2"]}]}], "0"},
       {"0", "0", 
        RowBox[{"ell", "-", 
         RowBox[{"ell", " ", 
          SuperscriptBox["eps2", "2"]}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {
     0, $CellContext`ell - $CellContext`ell $CellContext`eps1^2, 0}, {
     0, 0, $CellContext`ell - $CellContext`ell $CellContext`eps2^2}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.733747958244269*^9, 3.733747981947329*^9}, 
   3.741193114083714*^9, 3.7411931551926403`*^9, 
   3.7411945149301558`*^9},ExpressionUUID->"7b1c0408-d038-40ea-b429-\
10d594ae52cf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"ell", "-", 
         RowBox[{"ell", " ", 
          SuperscriptBox["eps1", "2"]}]}], 
        RowBox[{
         RowBox[{"-", "ell"}], " ", "eps1", " ", "eps2"}]},
       {"0", 
        RowBox[{
         RowBox[{"-", "ell"}], " ", "eps1", " ", "eps2"}], 
        RowBox[{"ell", "-", 
         RowBox[{"ell", " ", 
          SuperscriptBox["eps2", "2"]}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {
     0, $CellContext`ell - $CellContext`ell $CellContext`eps1^2, \
-$CellContext`ell $CellContext`eps1 $CellContext`eps2}, {
     0, -$CellContext`ell $CellContext`eps1 $CellContext`eps2, \
$CellContext`ell - $CellContext`ell $CellContext`eps2^2}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.733747958244269*^9, 3.733747981947329*^9}, 
   3.741193114083714*^9, 3.7411931551926403`*^9, 
   3.7411945149325247`*^9},ExpressionUUID->"9d0792a3-131b-4cd3-9652-\
ab389fcc53e3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "7"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", "d", ",", 
      " ", "r", ",", " ", "s", ",", " ", "tA11", ",", " ", "A12", ",", " ", 
      "A13", ",", " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", 
      "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", 
      "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "0", ",", " ", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"r", "*", "s"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], " ",
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{"z", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.733748102066744*^9, 3.733748103978759*^9}, 
   3.7411923105957203`*^9, {3.741193197742371*^9, 
   3.7411933332398043`*^9}},ExpressionUUID->"be75f54c-5713-4182-807e-\
246f9eb97386"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "x"},
       {"0", "x", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`x}, {0, $CellContext`x, 0}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733748140862772*^9, {3.7411932886214533`*^9, 3.741193309709909*^9}, 
   3.741194522841024*^9},ExpressionUUID->"b95f8659-3eac-4a02-a47c-\
cc39acf82b59"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", 
        FractionBox["b", "r"]},
       {"0", 
        FractionBox["b", "r"], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{"r", " ", "s", " ", "y"}], "0"},
       {
        RowBox[{"r", " ", "s", " ", "y"}], "0", 
        RowBox[{"b", " ", "s", " ", "y"}]},
       {"0", 
        RowBox[{"b", " ", "s", " ", "y"}], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`b/$CellContext`r}, {
     0, $CellContext`b/$CellContext`r, 0}}], 
   MatrixForm[{{
     0, $CellContext`r $CellContext`s $CellContext`y, 
      0}, {$CellContext`r $CellContext`s $CellContext`y, 
      0, $CellContext`b $CellContext`s $CellContext`y}, {
     0, $CellContext`b $CellContext`s $CellContext`y, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733748140862772*^9, {3.7411932886214533`*^9, 3.741193309709909*^9}, 
   3.741194522843615*^9},ExpressionUUID->"ed7fc7d7-d84e-4df5-b8e2-\
8098b1fe0749"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "8"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", "d", ",", 
      " ", "r", ",", " ", "s", ",", " ", "tA11", ",", " ", "A12", ",", " ", 
      "A13", ",", " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", 
      "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", 
      "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1", ",", " ", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "s"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"r", "*", "s"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], " ",
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{"z", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";", 
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "s"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "s", ",", " ", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"r", "*", "s"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], " ",
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{"z", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741193354855774*^9, 
  3.7411934154629383`*^9}},ExpressionUUID->"fc253e25-d4fe-455b-8269-\
44afba4b58a0"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "x"},
       {"0", "x", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`x}, {0, $CellContext`x, 0}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741193416109989*^9, 
  3.741194527782177*^9},ExpressionUUID->"8db82844-c70f-4c1c-9e2b-\
6fc99effcdeb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{"r", " ", "s", " ", "y"}], 
        RowBox[{"r", " ", "s", " ", "y"}]},
       {
        RowBox[{"r", " ", "s", " ", "y"}], "0", "0"},
       {
        RowBox[{"r", " ", "s", " ", "y"}], "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{
     0, $CellContext`r $CellContext`s $CellContext`y, $CellContext`r \
$CellContext`s $CellContext`y}, {$CellContext`r $CellContext`s $CellContext`y,
       0, 0}, {$CellContext`r $CellContext`s $CellContext`y, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741193416109989*^9, 
  3.741194527784387*^9},ExpressionUUID->"ce5e7a9b-5f64-43e2-95cc-\
4269f414c9d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{"r", " ", "s", " ", "y"}], 
        RowBox[{"r", " ", "s", " ", "y"}]},
       {
        RowBox[{"r", " ", "s", " ", "y"}], "0", "0"},
       {
        RowBox[{"r", " ", "s", " ", "y"}], "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{
     0, $CellContext`r $CellContext`s $CellContext`y, $CellContext`r \
$CellContext`s $CellContext`y}, {$CellContext`r $CellContext`s $CellContext`y,
       0, 0}, {$CellContext`r $CellContext`s $CellContext`y, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741193416109989*^9, 
  3.7411945277861547`*^9},ExpressionUUID->"66aec3fd-4184-441a-86b0-\
0a9d2164593d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "9"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", "d", ",", 
      " ", "r", ",", " ", "s", ",", " ", "tA11", ",", " ", "A12", ",", " ", 
      "A13", ",", " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", 
      "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", 
      "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{
          RowBox[{"s", "^", "2"}], "/", "r"}], ",", " ", "0"}], "}"}], ",", 
       " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "0", ",", " ", "s"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"s", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], " ",
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{"z", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.7411934517111597`*^9, 
  3.74119349478268*^9}},ExpressionUUID->"5f317901-0f69-4fc3-9389-\
eab794f1fb47"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "x"},
       {"0", "x", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`x}, {0, $CellContext`x, 0}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741193495557378*^9, 
  3.7411945308170633`*^9},ExpressionUUID->"b1e4f6b8-67d5-4b8d-bdcd-\
7f58fba37124"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", 
        FractionBox["b", "r"]},
       {"0", 
        FractionBox["b", "r"], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", "y"}], "0"},
       {
        RowBox[{
         SuperscriptBox["s", "2"], " ", "y"}], "0", 
        FractionBox[
         RowBox[{"b", " ", 
          SuperscriptBox["s", "2"], " ", "y"}], "r"]},
       {"0", 
        FractionBox[
         RowBox[{"b", " ", 
          SuperscriptBox["s", "2"], " ", "y"}], "r"], 
        RowBox[{
         SuperscriptBox["s", "2"], " ", "y"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`b/$CellContext`r}, {
     0, $CellContext`b/$CellContext`r, 0}}], 
   MatrixForm[{{
     0, $CellContext`s^2 $CellContext`y, 0}, {$CellContext`s^2 $CellContext`y,
       0, $CellContext`b $CellContext`r^(-1) $CellContext`s^2 \
$CellContext`y}, {
     0, $CellContext`b $CellContext`r^(-1) $CellContext`s^2 $CellContext`y, \
$CellContext`s^2 $CellContext`y}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741193495557378*^9, 
  3.7411945308197412`*^9},ExpressionUUID->"8fcd3720-21f2-4cac-a163-\
c1bffc54630d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "10"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", "d", ",", 
      " ", "r", ",", " ", "s", ",", " ", "tA11", ",", " ", "A12", ",", " ", 
      "A13", ",", " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", 
      "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", 
      "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "0", ",", " ", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"r", "*", "s"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], " ",
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", 
          RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741193523502437*^9, 
  3.7411935715978327`*^9}},ExpressionUUID->"c67d68ad-6a20-4126-bf69-\
b807e85feb94"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "x"},
       {"0", "x", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`x}, {0, $CellContext`x, 0}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741193572595642*^9, 
  3.741194533721586*^9},ExpressionUUID->"d5af7e9c-cbd4-49dc-9a62-\
523a8210bcde"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", 
        FractionBox["b", "r"]},
       {"0", 
        FractionBox["b", "r"], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{"r", " ", "s", " ", "y"}], 
        FractionBox["b", "r"]},
       {
        RowBox[{"r", " ", "s", " ", "y"}], "0", 
        RowBox[{"b", " ", "s", " ", "y"}]},
       {
        FractionBox["b", "r"], 
        RowBox[{"b", " ", "s", " ", "y"}], 
        FractionBox[
         SuperscriptBox["b", "2"], 
         SuperscriptBox["r", "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`b/$CellContext`r}, {
     0, $CellContext`b/$CellContext`r, 0}}], 
   MatrixForm[{{
     0, $CellContext`r $CellContext`s $CellContext`y, \
$CellContext`b/$CellContext`r}, {$CellContext`r $CellContext`s $CellContext`y,
       0, $CellContext`b $CellContext`s $CellContext`y}, \
{$CellContext`b/$CellContext`r, $CellContext`b $CellContext`s $CellContext`y, \
$CellContext`b^2 $CellContext`r^(-2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741193572595642*^9, 
  3.741194533724271*^9},ExpressionUUID->"70a40a88-2b5e-460f-94cf-\
c8a282e670e9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "11"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", "d", ",", 
      " ", "r", ",", " ", "s", ",", " ", "tA11", ",", " ", "A12", ",", " ", 
      "A13", ",", " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", 
      "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", 
      "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1", ",", " ", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "s"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"r", "*", "s"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], " ",
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", 
          RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";", 
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "s"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "s", ",", " ", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"r", "*", "s"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], " ",
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", 
          RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741193613669868*^9, 
  3.741193668125247*^9}},ExpressionUUID->"2dbafe1a-f64c-4fb7-8209-\
a0ed2f5d5910"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "x"},
       {"0", "x", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`x}, {0, $CellContext`x, 0}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741193668748947*^9, 
  3.741194537277293*^9},ExpressionUUID->"96d01e19-2935-424b-95e1-\
3cdfc84e810c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{"r", " ", "s", " ", "y"}], 
        RowBox[{"r", " ", "s", " ", "y"}]},
       {
        RowBox[{"r", " ", "s", " ", "y"}], "0", "0"},
       {
        RowBox[{"r", " ", "s", " ", "y"}], "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{
     0, $CellContext`r $CellContext`s $CellContext`y, $CellContext`r \
$CellContext`s $CellContext`y}, {$CellContext`r $CellContext`s $CellContext`y,
       0, 0}, {$CellContext`r $CellContext`s $CellContext`y, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741193668748947*^9, 
  3.741194537279676*^9},ExpressionUUID->"35a88cf1-a874-4cdc-ad15-\
55340a163aa2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{"r", " ", "s", " ", "y"}], 
        RowBox[{"r", " ", "s", " ", "y"}]},
       {
        RowBox[{"r", " ", "s", " ", "y"}], "0", "0"},
       {
        RowBox[{"r", " ", "s", " ", "y"}], "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{
     0, $CellContext`r $CellContext`s $CellContext`y, $CellContext`r \
$CellContext`s $CellContext`y}, {$CellContext`r $CellContext`s $CellContext`y,
       0, 0}, {$CellContext`r $CellContext`s $CellContext`y, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741193668748947*^9, 
  3.741194537282239*^9},ExpressionUUID->"92282218-ddaf-45a6-8930-\
e678d2beb5f0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "12"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", "d", ",", 
      " ", "r", ",", " ", "s", ",", " ", "tA11", ",", " ", "A12", ",", " ", 
      "A13", ",", " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", 
      "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", 
      "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{
          RowBox[{"s", "^", "2"}], "/", "r"}], ",", " ", "0"}], "}"}], ",", 
       " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "0", ",", " ", "s"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"s", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], " ",
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", 
          RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741193697101417*^9, 
  3.741193773028605*^9}},ExpressionUUID->"15e85f80-04e9-4835-9f48-\
646ab239e44a"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "x"},
       {"0", "x", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`x}, {0, $CellContext`x, 0}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.741193758675514*^9, 3.7411937735344563`*^9}, 
   3.741194540469676*^9},ExpressionUUID->"28941ba2-e446-4a5b-92e6-\
75c93dc08937"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", 
        FractionBox["b", "r"]},
       {"0", 
        FractionBox["b", "r"], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", "y"}], 
        FractionBox["b", "r"]},
       {
        RowBox[{
         SuperscriptBox["s", "2"], " ", "y"}], "0", 
        FractionBox[
         RowBox[{"b", " ", 
          SuperscriptBox["s", "2"], " ", "y"}], "r"]},
       {
        FractionBox["b", "r"], 
        FractionBox[
         RowBox[{"b", " ", 
          SuperscriptBox["s", "2"], " ", "y"}], "r"], 
        RowBox[{
         FractionBox[
          SuperscriptBox["b", "2"], 
          SuperscriptBox["r", "2"]], "+", 
         RowBox[{
          SuperscriptBox["s", "2"], " ", "y"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`b/$CellContext`r}, {
     0, $CellContext`b/$CellContext`r, 0}}], 
   MatrixForm[{{
     0, $CellContext`s^2 $CellContext`y, $CellContext`b/$CellContext`r}, \
{$CellContext`s^2 $CellContext`y, 
      0, $CellContext`b $CellContext`r^(-1) $CellContext`s^2 $CellContext`y}, \
{$CellContext`b/$CellContext`r, $CellContext`b $CellContext`r^(-1) \
$CellContext`s^2 $CellContext`y, $CellContext`b^2 $CellContext`r^(-2) + \
$CellContext`s^2 $CellContext`y}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.741193758675514*^9, 3.7411937735344563`*^9}, 
   3.741194540472602*^9},ExpressionUUID->"23c1dd7d-8552-4a81-b3fe-\
5540e8f4f836"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "13"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", "d", ",", 
      " ", "r", ",", " ", "s", ",", " ", "tA11", ",", " ", "A12", ",", " ", 
      "A13", ",", " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", 
      "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", 
      "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "0", ",", " ", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"s", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], " ",
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{"z", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741193807940444*^9, 
  3.741193845260158*^9}},ExpressionUUID->"e621adc4-5211-41cb-abcc-\
85ce1a5dd607"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "x"},
       {"0", "x", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`x}, {0, $CellContext`x, 0}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7411938458534727`*^9, 
  3.741194544753476*^9},ExpressionUUID->"0342b7a5-e5de-448f-8f16-\
9e06ba16a962"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", "y"}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, $CellContext`s^2 $CellContext`y, 0}, {0, 0, 
     0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7411938458534727`*^9, 
  3.741194544755947*^9},ExpressionUUID->"1f5bd444-0299-4b96-97fe-\
f4c9d441967e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "14"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", "d", ",", 
      " ", "r", ",", " ", "s", ",", " ", "tA11", ",", " ", "A12", ",", " ", 
      "A13", ",", " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", 
      "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", 
      "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "0", ",", " ", 
         RowBox[{"eps", " ", "*", " ", "s"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"s", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], " ",
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{"z", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";", 
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "0", ",", " ", "s"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", 
         RowBox[{"eps", " ", "*", " ", "s"}], ",", "0"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"s", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], " ",
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{"z", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741193874228194*^9, 
  3.741193919771734*^9}},ExpressionUUID->"ab7e509f-8da0-4fea-846f-\
cb27d4439b1b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "x"},
       {"0", "x", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`x}, {0, $CellContext`x, 0}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741193920474304*^9, 
  3.74119454714541*^9},ExpressionUUID->"cbb2fba1-ded9-41e6-8ab9-8c124ae4a5ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["eps", "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", "y"}], "0"},
       {"0", "0", 
        RowBox[{
         SuperscriptBox["eps", "2"], " ", 
         SuperscriptBox["s", "2"], " ", "y"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, -1 + $CellContext`eps^2}}], 
   MatrixForm[{{0, 0, 0}, {0, $CellContext`s^2 $CellContext`y, 0}, {
     0, 0, $CellContext`eps^2 $CellContext`s^2 $CellContext`y}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741193920474304*^9, 
  3.741194547147893*^9},ExpressionUUID->"d2efb29b-65a5-4726-b25d-\
da95088ebfd7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["eps", "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", "y"}], "0"},
       {"0", "0", 
        RowBox[{
         SuperscriptBox["eps", "2"], " ", 
         SuperscriptBox["s", "2"], " ", "y"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, -1 + $CellContext`eps^2}}], 
   MatrixForm[{{0, 0, 0}, {0, $CellContext`s^2 $CellContext`y, 0}, {
     0, 0, $CellContext`eps^2 $CellContext`s^2 $CellContext`y}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741193920474304*^9, 
  3.741194547150036*^9},ExpressionUUID->"6ed04d13-b435-4819-9063-\
761634efd5ed"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "15"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", "d", ",", 
      " ", "r", ",", " ", "s", ",", " ", "tA11", ",", " ", "A12", ",", " ", 
      "A13", ",", " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", 
      "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", 
      "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "ell"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "0", ",", " ", 
         RowBox[{"eps", " ", "*", " ", "s"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"s", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], " ",
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{"z", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";", 
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "0", ",", " ", 
         RowBox[{"eps", "*", "s"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", "  ", 
         RowBox[{"ell", "*", "s"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"s", "^", "2"}], "*", "ell"}], ")"}]}], ")"}], " ", "*", 
       " ", "A1"}], " ", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{"z", " ", "*", " ", "B1"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741193941099986*^9, 
  3.741194012019353*^9}},ExpressionUUID->"0e6e1694-1c06-45ab-9d44-\
2b5e5728b884"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "x"},
       {"0", "x", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`x}, {0, $CellContext`x, 0}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.741193974037236*^9, 3.741194012503356*^9}, 
   3.741194550298973*^9},ExpressionUUID->"149aa3f8-4c25-469f-9518-\
1470a09593bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", "ell"}], "+", 
         RowBox[{"ell", " ", 
          SuperscriptBox["eps", "2"]}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{
         SuperscriptBox["s", "2"], " ", "y"}], "0"},
       {"0", "0", 
        RowBox[{"ell", " ", 
         SuperscriptBox["eps", "2"], " ", 
         SuperscriptBox["s", "2"], " ", "y"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {
     0, 0, -$CellContext`ell + $CellContext`ell $CellContext`eps^2}}], 
   MatrixForm[{{0, 0, 0}, {0, $CellContext`s^2 $CellContext`y, 0}, {
     0, 0, $CellContext`ell $CellContext`eps^2 $CellContext`s^2 \
$CellContext`y}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.741193974037236*^9, 3.741194012503356*^9}, 
   3.7411945503015957`*^9},ExpressionUUID->"904aecfe-134f-4da8-8d3d-\
59997984eaf1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["eps", "2"]}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"ell", " ", 
         SuperscriptBox["eps", "2"], " ", 
         SuperscriptBox["s", "2"], " ", "y"}], "0"},
       {"0", "0", 
        RowBox[{
         SuperscriptBox["ell", "2"], " ", 
         SuperscriptBox["s", "2"], " ", "y"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, -1 + $CellContext`eps^2, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {
     0, $CellContext`ell $CellContext`eps^2 $CellContext`s^2 $CellContext`y, 
      0}, {0, 0, $CellContext`ell^2 $CellContext`s^2 $CellContext`y}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.741193974037236*^9, 3.741194012503356*^9}, 
   3.741194550303919*^9},ExpressionUUID->"25c1c078-b298-4d24-8da4-\
52bbd27c1086"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7411940418583107`*^9, 
  3.741194042210268*^9}},ExpressionUUID->"0f980a42-8336-4ffd-a8f5-\
0ee66097c391"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "16"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", "d", ",", 
      " ", "r", ",", " ", "s", ",", " ", "tA11", ",", " ", "A12", ",", " ", 
      "A13", ",", " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", 
      "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", 
      "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "0", ",", " ", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"s", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], " ",
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"r", "^", "2"}], ")"}]}], " ", "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741194053235083*^9, 
  3.741194093458597*^9}},ExpressionUUID->"1d58d308-5981-4f6d-801b-\
8d314c09fee3"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "x"},
       {"0", "x", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`x}, {0, $CellContext`x, 0}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7411940940039043`*^9, 
  3.741194554054098*^9},ExpressionUUID->"68265e3c-f6bd-422a-aadb-\
56545e9ed448"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["a", "r"], 
        FractionBox["b", "r"]},
       {
        FractionBox["a", "r"], 
        RowBox[{
         FractionBox[
          SuperscriptBox["a", "2"], 
          SuperscriptBox["r", "2"]], "+", 
         RowBox[{
          SuperscriptBox["s", "2"], " ", "y"}]}], 
        FractionBox[
         RowBox[{"a", " ", "b"}], 
         SuperscriptBox["r", "2"]]},
       {
        FractionBox["b", "r"], 
        FractionBox[
         RowBox[{"a", " ", "b"}], 
         SuperscriptBox["r", "2"]], 
        FractionBox[
         SuperscriptBox["b", "2"], 
         SuperscriptBox["r", "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{
     0, $CellContext`a/$CellContext`r, $CellContext`b/$CellContext`r}, \
{$CellContext`a/$CellContext`r, $CellContext`a^2 $CellContext`r^(-2) + \
$CellContext`s^2 $CellContext`y, $CellContext`a $CellContext`b \
$CellContext`r^(-2)}, {$CellContext`b/$CellContext`r, $CellContext`a \
$CellContext`b $CellContext`r^(-2), $CellContext`b^2 $CellContext`r^(-2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7411940940039043`*^9, 
  3.741194554056568*^9},ExpressionUUID->"fda3a96f-823f-4dcc-a1a9-\
bb19c9a5c977"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "17"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", "d", ",", 
      " ", "r", ",", " ", "s", ",", " ", "tA11", ",", " ", "A12", ",", " ", 
      "A13", ",", " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", 
      "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", 
      "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "0", ",", " ", 
         RowBox[{"eps", " ", "*", " ", "s"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"s", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], " ",
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", 
          RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";", 
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "0", ",", " ", "s"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", 
         RowBox[{"eps", " ", "*", " ", "s"}], ",", "0"}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"s", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], " ",
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", 
          RowBox[{"r", "^", "2"}]}], ")"}], "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741194139834547*^9, 
  3.741194168291131*^9}},ExpressionUUID->"37888cfc-a2d4-43d6-9ee2-\
b55be2412d06"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "x"},
       {"0", "x", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`x}, {0, $CellContext`x, 0}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741194168663612*^9, 
  3.741194556826766*^9},ExpressionUUID->"c989a493-2b85-4dfd-9312-\
95a4888ff9c8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["eps", "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["a", "r"], 
        FractionBox["b", "r"]},
       {
        FractionBox["a", "r"], 
        RowBox[{
         FractionBox[
          SuperscriptBox["a", "2"], 
          SuperscriptBox["r", "2"]], "+", 
         RowBox[{
          SuperscriptBox["s", "2"], " ", "y"}]}], 
        FractionBox[
         RowBox[{"a", " ", "b"}], 
         SuperscriptBox["r", "2"]]},
       {
        FractionBox["b", "r"], 
        FractionBox[
         RowBox[{"a", " ", "b"}], 
         SuperscriptBox["r", "2"]], 
        RowBox[{
         FractionBox[
          SuperscriptBox["b", "2"], 
          SuperscriptBox["r", "2"]], "+", 
         RowBox[{
          SuperscriptBox["eps", "2"], " ", 
          SuperscriptBox["s", "2"], " ", "y"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, -1 + $CellContext`eps^2}}], 
   MatrixForm[{{
     0, $CellContext`a/$CellContext`r, $CellContext`b/$CellContext`r}, \
{$CellContext`a/$CellContext`r, $CellContext`a^2 $CellContext`r^(-2) + \
$CellContext`s^2 $CellContext`y, $CellContext`a $CellContext`b \
$CellContext`r^(-2)}, {$CellContext`b/$CellContext`r, $CellContext`a \
$CellContext`b $CellContext`r^(-2), $CellContext`b^2 $CellContext`r^(-2) + \
$CellContext`eps^2 $CellContext`s^2 $CellContext`y}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741194168663612*^9, 
  3.741194556829959*^9},ExpressionUUID->"76eda679-ca27-4d48-a311-\
47a289bcbbb4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["eps", "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["a", "r"], 
        FractionBox["b", "r"]},
       {
        FractionBox["a", "r"], 
        RowBox[{
         FractionBox[
          SuperscriptBox["a", "2"], 
          SuperscriptBox["r", "2"]], "+", 
         RowBox[{
          SuperscriptBox["s", "2"], " ", "y"}]}], 
        FractionBox[
         RowBox[{"a", " ", "b"}], 
         SuperscriptBox["r", "2"]]},
       {
        FractionBox["b", "r"], 
        FractionBox[
         RowBox[{"a", " ", "b"}], 
         SuperscriptBox["r", "2"]], 
        RowBox[{
         FractionBox[
          SuperscriptBox["b", "2"], 
          SuperscriptBox["r", "2"]], "+", 
         RowBox[{
          SuperscriptBox["eps", "2"], " ", 
          SuperscriptBox["s", "2"], " ", "y"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, -1 + $CellContext`eps^2}}], 
   MatrixForm[{{
     0, $CellContext`a/$CellContext`r, $CellContext`b/$CellContext`r}, \
{$CellContext`a/$CellContext`r, $CellContext`a^2 $CellContext`r^(-2) + \
$CellContext`s^2 $CellContext`y, $CellContext`a $CellContext`b \
$CellContext`r^(-2)}, {$CellContext`b/$CellContext`r, $CellContext`a \
$CellContext`b $CellContext`r^(-2), $CellContext`b^2 $CellContext`r^(-2) + \
$CellContext`eps^2 $CellContext`s^2 $CellContext`y}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741194168663612*^9, 
  3.741194556832211*^9},ExpressionUUID->"fad37f64-9446-4ce9-b819-\
63e3ad69d172"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "18"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", "d", ",", 
      " ", "r", ",", " ", "s", ",", " ", "tA11", ",", " ", "A12", ",", " ", 
      "A13", ",", " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", 
      "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", 
      "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "ell"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "0", ",", " ", 
         RowBox[{"eps", " ", "*", " ", "s"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"s", "^", "2"}], ")"}]}], ")"}], " ", "*", " ", "A1"}], " ",
       "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", 
          RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";", 
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "0", ",", " ", 
         RowBox[{"eps", "*", "s"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", "  ", 
         RowBox[{"ell", "*", "s"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"s", "^", "2"}], "*", "ell"}], ")"}]}], ")"}], " ", "*", 
       " ", "A1"}], " ", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", 
          RowBox[{"r", "^", "2"}]}], ")"}], "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741194201450152*^9, 
  3.741194223305936*^9}},ExpressionUUID->"0db0839e-d20e-4fc4-aad5-\
cfcee07eb7e3"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "x"},
       {"0", "x", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`x}, {0, $CellContext`x, 0}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741194225984877*^9, 
  3.741194559664627*^9},ExpressionUUID->"9ba9542e-61dc-4cbf-84a1-\
4b1ef5874f07"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", "ell"}], "+", 
         RowBox[{"ell", " ", 
          SuperscriptBox["eps", "2"]}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["a", "r"], 
        FractionBox["b", "r"]},
       {
        FractionBox["a", "r"], 
        RowBox[{
         FractionBox[
          SuperscriptBox["a", "2"], 
          SuperscriptBox["r", "2"]], "+", 
         RowBox[{
          SuperscriptBox["s", "2"], " ", "y"}]}], 
        FractionBox[
         RowBox[{"a", " ", "b"}], 
         SuperscriptBox["r", "2"]]},
       {
        FractionBox["b", "r"], 
        FractionBox[
         RowBox[{"a", " ", "b"}], 
         SuperscriptBox["r", "2"]], 
        RowBox[{
         FractionBox[
          SuperscriptBox["b", "2"], 
          SuperscriptBox["r", "2"]], "+", 
         RowBox[{"ell", " ", 
          SuperscriptBox["eps", "2"], " ", 
          SuperscriptBox["s", "2"], " ", "y"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {
     0, 0, -$CellContext`ell + $CellContext`ell $CellContext`eps^2}}], 
   MatrixForm[{{
     0, $CellContext`a/$CellContext`r, $CellContext`b/$CellContext`r}, \
{$CellContext`a/$CellContext`r, $CellContext`a^2 $CellContext`r^(-2) + \
$CellContext`s^2 $CellContext`y, $CellContext`a $CellContext`b \
$CellContext`r^(-2)}, {$CellContext`b/$CellContext`r, $CellContext`a \
$CellContext`b $CellContext`r^(-2), $CellContext`b^2 $CellContext`r^(-2) + \
$CellContext`ell $CellContext`eps^2 $CellContext`s^2 $CellContext`y}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741194225984877*^9, 
  3.741194559666853*^9},ExpressionUUID->"d084c37f-0898-4179-bfca-\
a4646e0a9c8f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["eps", "2"]}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["a", "r"], 
        FractionBox["b", "r"]},
       {
        FractionBox["a", "r"], 
        RowBox[{
         FractionBox[
          SuperscriptBox["a", "2"], 
          SuperscriptBox["r", "2"]], "+", 
         RowBox[{"ell", " ", 
          SuperscriptBox["eps", "2"], " ", 
          SuperscriptBox["s", "2"], " ", "y"}]}], 
        FractionBox[
         RowBox[{"a", " ", "b"}], 
         SuperscriptBox["r", "2"]]},
       {
        FractionBox["b", "r"], 
        FractionBox[
         RowBox[{"a", " ", "b"}], 
         SuperscriptBox["r", "2"]], 
        RowBox[{
         FractionBox[
          SuperscriptBox["b", "2"], 
          SuperscriptBox["r", "2"]], "+", 
         RowBox[{
          SuperscriptBox["ell", "2"], " ", 
          SuperscriptBox["s", "2"], " ", "y"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, -1 + $CellContext`eps^2, 0}, {0, 0, 0}}], 
   MatrixForm[{{
     0, $CellContext`a/$CellContext`r, $CellContext`b/$CellContext`r}, \
{$CellContext`a/$CellContext`r, $CellContext`a^2 $CellContext`r^(-2) + \
$CellContext`ell $CellContext`eps^2 $CellContext`s^2 $CellContext`y, \
$CellContext`a $CellContext`b $CellContext`r^(-2)}, \
{$CellContext`b/$CellContext`r, $CellContext`a $CellContext`b \
$CellContext`r^(-2), $CellContext`b^2 $CellContext`r^(-2) + \
$CellContext`ell^2 $CellContext`s^2 $CellContext`y}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741194225984877*^9, 
  3.741194559669841*^9},ExpressionUUID->"3d623f6e-4727-4503-92cb-\
aed9c5d6dcb2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verification", " ", "of", " ", "orbit", " ", "19"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "a", ",", " ", "b", ",", " ", "c", ",", " ", "d", ",", 
      " ", "r", ",", " ", "s", ",", " ", "tA11", ",", " ", "A12", ",", " ", 
      "A13", ",", " ", "A21", ",", " ", "A22", ",", " ", "A23", ",", " ", 
      "A31", ",", " ", "A32", ",", " ", "A33", ",", " ", "B11", ",", " ", 
      "B12", ",", " ", "B21", ",", " ", "B22"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "0", ",", " ", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"x", " ", "*", " ", "A1"}], " ", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", 
          RowBox[{"r", "^", "2"}]}], ")"}], " ", "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";", 
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "0", ",", " ", "s"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "t", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{"x", " ", "*", " ", "A1"}], " ", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{"y", "*", "A1"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", 
          RowBox[{"r", "^", "2"}]}], ")"}], "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", "=", " ", 
     RowBox[{"A2", "-", "A"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B3", " ", "=", " ", 
     RowBox[{"B2", "-", "B"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A3", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B3", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.741194261497755*^9, 
  3.7411942976732483`*^9}},ExpressionUUID->"e86598d1-c697-409e-95a7-\
d09fd10ac4a2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "x"},
       {"0", "x", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, $CellContext`x}, {0, $CellContext`x, 0}}], 
   MatrixForm[{{
     0, $CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741194299434105*^9, 
  3.7411945622419777`*^9},ExpressionUUID->"83f6efdd-2e44-478c-9dde-\
42b735d68b9b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["a", "r"], 
        FractionBox["b", "r"]},
       {
        FractionBox["a", "r"], 
        FractionBox[
         SuperscriptBox["a", "2"], 
         SuperscriptBox["r", "2"]], 
        FractionBox[
         RowBox[{"a", " ", "b"}], 
         SuperscriptBox["r", "2"]]},
       {
        FractionBox["b", "r"], 
        FractionBox[
         RowBox[{"a", " ", "b"}], 
         SuperscriptBox["r", "2"]], 
        FractionBox[
         SuperscriptBox["b", "2"], 
         SuperscriptBox["r", "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{
     0, $CellContext`a/$CellContext`r, $CellContext`b/$CellContext`r}, \
{$CellContext`a/$CellContext`r, $CellContext`a^2 $CellContext`r^(-2), \
$CellContext`a $CellContext`b $CellContext`r^(-2)}, \
{$CellContext`b/$CellContext`r, $CellContext`a $CellContext`b \
$CellContext`r^(-2), $CellContext`b^2 $CellContext`r^(-2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741194299434105*^9, 
  3.741194562244133*^9},ExpressionUUID->"65decbe4-5c92-43f6-9b93-\
bff028a13633"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["a", "r"], 
        FractionBox["b", "r"]},
       {
        FractionBox["a", "r"], 
        FractionBox[
         SuperscriptBox["a", "2"], 
         SuperscriptBox["r", "2"]], 
        FractionBox[
         RowBox[{"a", " ", "b"}], 
         SuperscriptBox["r", "2"]]},
       {
        FractionBox["b", "r"], 
        FractionBox[
         RowBox[{"a", " ", "b"}], 
         SuperscriptBox["r", "2"]], 
        FractionBox[
         SuperscriptBox["b", "2"], 
         SuperscriptBox["r", "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{
     0, $CellContext`a/$CellContext`r, $CellContext`b/$CellContext`r}, \
{$CellContext`a/$CellContext`r, $CellContext`a^2 $CellContext`r^(-2), \
$CellContext`a $CellContext`b $CellContext`r^(-2)}, \
{$CellContext`b/$CellContext`r, $CellContext`a $CellContext`b \
$CellContext`r^(-2), $CellContext`b^2 $CellContext`r^(-2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.741194299434105*^9, 
  3.741194562247216*^9},ExpressionUUID->"6aad2364-87f3-4a78-8955-\
a04ae1d27a0b"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{Automatic, 209}, {34, Automatic}},
FrontEndVersion->"11.1 for Linux x86 (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 7229, 184, 695, "Input", "ExpressionUUID" -> \
"3a9fe989-7f0e-4d43-8335-bfe6306b570e"],
Cell[CellGroupData[{
Cell[7834, 210, 2001, 51, 59, "Print", "ExpressionUUID" -> \
"3385478a-9728-4908-b20a-334570cb8cad"],
Cell[9838, 263, 1863, 49, 59, "Print", "ExpressionUUID" -> \
"59e31aac-f844-4bf1-bfc5-ffc15614838b"],
Cell[11704, 314, 1863, 49, 59, "Print", "ExpressionUUID" -> \
"19dd6a2d-56a1-4e76-8924-0f3f7db5f34c"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13616, 369, 4831, 136, 516, "Input", "ExpressionUUID" -> \
"055c22e1-c1f6-4267-b777-b91c65034344"],
Cell[CellGroupData[{
Cell[18472, 509, 1736, 47, 59, "Print", "ExpressionUUID" -> \
"15c564fe-ee07-4498-a76e-ec00f03d7e3f"],
Cell[20211, 558, 1598, 45, 59, "Print", "ExpressionUUID" -> \
"de85ad74-667b-4981-956b-4a9d04febf38"],
Cell[21812, 605, 1598, 45, 59, "Print", "ExpressionUUID" -> \
"0e9d8237-321b-433a-bd14-4836c8fbae7f"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23459, 656, 14382, 404, 1642, "Input", "ExpressionUUID" -> \
"fc807d64-c974-4f1f-b5a0-f1951d05dcc9"],
Cell[CellGroupData[{
Cell[37866, 1064, 1736, 47, 59, "Print", "ExpressionUUID" -> \
"dd230697-1ea9-4d0b-b0a1-730c6749fcc7"],
Cell[39605, 1113, 1598, 45, 59, "Print", "ExpressionUUID" -> \
"b5ff61f3-8a6f-4158-bcec-e4b772150c5b"],
Cell[41206, 1160, 1598, 45, 59, "Print", "ExpressionUUID" -> \
"4bc9005e-18f6-45be-9cfa-2c55358d2bc4"],
Cell[42807, 1207, 1598, 45, 59, "Print", "ExpressionUUID" -> \
"f92101ad-55f9-4dbc-a3aa-65ca29cc4304"],
Cell[44408, 1254, 1598, 45, 59, "Print", "ExpressionUUID" -> \
"aa5dd2e6-018c-44fd-a165-cc73e046772e"],
Cell[46009, 1301, 1598, 45, 59, "Print", "ExpressionUUID" -> \
"b85b9aad-66e7-4231-ab20-4278b3d56480"],
Cell[47610, 1348, 1598, 45, 59, "Print", "ExpressionUUID" -> \
"0d0f9b81-fa17-41ea-806d-223b5dc5f579"],
Cell[49211, 1395, 1598, 45, 59, "Print", "ExpressionUUID" -> \
"92ba575f-161d-4463-b506-b0d96b95b5a4"],
Cell[50812, 1442, 1598, 45, 59, "Print", "ExpressionUUID" -> \
"664b8185-0d69-4d48-b74f-008eb1212edd"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[52459, 1493, 4879, 137, 516, "Input", "ExpressionUUID" -> \
"941b7081-266f-479b-93ba-ca13f82cfbb7"],
Cell[CellGroupData[{
Cell[57363, 1634, 1740, 47, 59, "Print", "ExpressionUUID" -> \
"3b04303f-6698-4f2b-b199-ce958cd11ecf"],
Cell[59106, 1683, 1600, 45, 59, "Print", "ExpressionUUID" -> \
"ea69fe18-05b0-4595-a21e-9a430c4f66fb"],
Cell[60709, 1730, 1602, 45, 59, "Print", "ExpressionUUID" -> \
"2fcb2c2b-2b45-4558-8a7b-d96b0e05bd5a"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[62360, 1781, 8066, 226, 884, "Input", "ExpressionUUID" -> \
"5dfca301-d4bc-4ae1-b061-70fc3c465994"],
Cell[CellGroupData[{
Cell[70451, 2011, 1738, 47, 59, "Print", "ExpressionUUID" -> \
"cb4afddd-eaa8-4380-b72e-5fefe51d829a"],
Cell[72192, 2060, 1598, 45, 59, "Print", "ExpressionUUID" -> \
"fba9f366-c2c7-4e14-a526-a3cd18b1f967"],
Cell[73793, 2107, 1598, 45, 59, "Print", "ExpressionUUID" -> \
"57708341-1ca4-4cd5-a1c2-c6b2cec00c8f"],
Cell[75394, 2154, 1595, 44, 59, "Print", "ExpressionUUID" -> \
"89304581-66a0-483b-9b7f-60a0554b7555"],
Cell[76992, 2200, 1600, 45, 59, "Print", "ExpressionUUID" -> \
"1a63ccc3-ed14-4903-8f18-8d6a6b93ba6b"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[78641, 2251, 5118, 143, 538, "Input", "ExpressionUUID" -> \
"ee3b5200-da36-41a1-b81c-22ddee0aeca4"],
Cell[CellGroupData[{
Cell[83784, 2398, 1813, 48, 59, "Print", "ExpressionUUID" -> \
"c63ceb1a-5e06-4f2f-aa46-021cc3325a78"],
Cell[85600, 2448, 1991, 54, 65, "Print", "ExpressionUUID" -> \
"7b1c0408-d038-40ea-b429-10d594ae52cf"],
Cell[87594, 2504, 2243, 60, 65, "Print", "ExpressionUUID" -> \
"9d0792a3-131b-4cd3-9652-ab389fcc53e3"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[89886, 2570, 3499, 96, 420, "Input", "ExpressionUUID" -> \
"be75f54c-5713-4182-807e-246f9eb97386"],
Cell[CellGroupData[{
Cell[93410, 2670, 1788, 48, 59, "Print", "ExpressionUUID" -> \
"b95f8659-3eac-4a02-a47c-cc39acf82b59"],
Cell[95201, 2720, 2120, 57, 79, "Print", "ExpressionUUID" -> \
"ed7fc7d7-d84e-4df5-b8e2-8098b1fe0749"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[97370, 2783, 4931, 138, 516, "Input", "ExpressionUUID" -> \
"fc253e25-d4fe-455b-8269-44afba4b58a0"],
Cell[CellGroupData[{
Cell[102326, 2925, 1736, 47, 59, "Print", "ExpressionUUID" -> \
"8db82844-c70f-4c1c-9e2b-6fc99effcdeb"],
Cell[104065, 2974, 1941, 52, 59, "Print", "ExpressionUUID" -> \
"ce5e7a9b-5f64-43e2-95cc-4269f414c9d2"],
Cell[106009, 3028, 1943, 52, 59, "Print", "ExpressionUUID" -> \
"66aec3fd-4184-441a-86b0-0a9d2164593d"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[108001, 3086, 3392, 96, 332, "Input", "ExpressionUUID" -> \
"5f317901-0f69-4fc3-9389-eab794f1fb47"],
Cell[CellGroupData[{
Cell[111418, 3186, 1738, 47, 59, "Print", "ExpressionUUID" -> \
"b1e4f6b8-67d5-4b8d-bdcd-7f58fba37124"],
Cell[113159, 3235, 2337, 65, 90, "Print", "ExpressionUUID" -> \
"8fcd3720-21f2-4cac-a163-c1bffc54630d"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[115545, 3306, 3416, 96, 332, "Input", "ExpressionUUID" -> \
"c67d68ad-6a20-4126-bf69-b807e85feb94"],
Cell[CellGroupData[{
Cell[118986, 3406, 1736, 47, 59, "Print", "ExpressionUUID" -> \
"d5af7e9c-cbd4-49dc-9a62-523a8210bcde"],
Cell[120725, 3455, 2295, 62, 84, "Print", "ExpressionUUID" -> \
"70a40a88-2b5e-460f-94cf-c8a282e670e9"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[123069, 3523, 5112, 144, 516, "Input", "ExpressionUUID" -> \
"2dbafe1a-f64c-4fb7-8209-a0ed2f5d5910"],
Cell[CellGroupData[{
Cell[128206, 3671, 1736, 47, 59, "Print", "ExpressionUUID" -> \
"96d01e19-2935-424b-95e1-3cdfc84e810c"],
Cell[129945, 3720, 1941, 52, 59, "Print", "ExpressionUUID" -> \
"35a88cf1-a874-4cdc-ad15-55340a163aa2"],
Cell[131889, 3774, 1941, 52, 59, "Print", "ExpressionUUID" -> \
"92282218-ddaf-45a6-8930-e678d2beb5f0"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[133879, 3832, 3483, 99, 332, "Input", "ExpressionUUID" -> \
"15e85f80-04e9-4835-9f48-646ab239e44a"],
Cell[CellGroupData[{
Cell[137387, 3935, 1763, 47, 59, "Print", "ExpressionUUID" -> \
"28941ba2-e446-4a5b-92e6-75c93dc08937"],
Cell[139153, 3984, 2632, 72, 98, "Print", "ExpressionUUID" -> \
"23c1dd7d-8552-4a81-b3fe-5540e8f4f836"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[141834, 4062, 3323, 93, 332, "Input", "ExpressionUUID" -> \
"e621adc4-5211-41cb-abcc-85ce1a5dd607"],
Cell[CellGroupData[{
Cell[145182, 4159, 1738, 47, 59, "Print", "ExpressionUUID" -> \
"0342b7a5-e5de-448f-8f16-9e06ba16a962"],
Cell[146923, 4208, 1696, 48, 62, "Print", "ExpressionUUID" -> \
"1f5bd444-0299-4b96-97fe-f4c9d441967e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[148668, 4262, 5010, 140, 516, "Input", "ExpressionUUID" -> \
"ab7e509f-8da0-4fea-846f-cb27d4439b1b"],
Cell[CellGroupData[{
Cell[153703, 4406, 1733, 46, 59, "Print", "ExpressionUUID" -> \
"cbb2fba1-ded9-41e6-8ab9-8c124ae4a5ef"],
Cell[155439, 4454, 1955, 54, 65, "Print", "ExpressionUUID" -> \
"d2efb29b-65a5-4726-b25d-da95088ebfd7"],
Cell[157397, 4510, 1955, 54, 65, "Print", "ExpressionUUID" -> \
"6ed04d13-b435-4819-9063-761634efd5ed"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[159401, 4570, 5069, 142, 516, "Input", "ExpressionUUID" -> \
"0e6e1694-1c06-45ab-9d44-2b5e5728b884"],
Cell[CellGroupData[{
Cell[164495, 4716, 1761, 47, 59, "Print", "ExpressionUUID" -> \
"149aa3f8-4c25-469f-9518-1470a09593bf"],
Cell[166259, 4765, 2086, 57, 65, "Print", "ExpressionUUID" -> \
"904aecfe-134f-4da8-8d3d-59997984eaf1"],
Cell[168348, 4824, 2078, 56, 65, "Print", "ExpressionUUID" -> \
"25c1c078-b298-4d24-8da4-52bbd27c1086"]
}, Open  ]]
}, Open  ]],
Cell[170453, 4884, 154, 3, 32, "Input", "ExpressionUUID" -> \
"0f980a42-8336-4ffd-a8f5-0ee66097c391"],
Cell[CellGroupData[{
Cell[170632, 4891, 3414, 96, 332, "Input", "ExpressionUUID" -> \
"1d58d308-5981-4f6d-801b-8d314c09fee3"],
Cell[CellGroupData[{
Cell[174071, 4991, 1738, 47, 59, "Print", "ExpressionUUID" -> \
"68265e3c-f6bd-422a-aadb-56545e9ed448"],
Cell[175812, 5040, 2482, 69, 99, "Print", "ExpressionUUID" -> \
"fda3a96f-823f-4dcc-a1a9-bb19c9a5c977"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[178343, 5115, 5187, 146, 516, "Input", "ExpressionUUID" -> \
"37888cfc-a2d4-43d6-9ee2-b55be2412d06"],
Cell[CellGroupData[{
Cell[183555, 5265, 1736, 47, 59, "Print", "ExpressionUUID" -> \
"c989a493-2b85-4dfd-9312-95a4888ff9c8"],
Cell[185294, 5314, 2782, 77, 99, "Print", "ExpressionUUID" -> \
"76eda679-ca27-4d48-a311-47a289bcbbb4"],
Cell[188079, 5393, 2782, 77, 99, "Print", "ExpressionUUID" -> \
"fad37f64-9446-4ce9-b819-63e3ad69d172"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[190910, 5476, 5241, 148, 516, "Input", "ExpressionUUID" -> \
"0db0839e-d20e-4fc4-aad5-cfcee07eb7e3"],
Cell[CellGroupData[{
Cell[196176, 5628, 1736, 47, 59, "Print", "ExpressionUUID" -> \
"9ba9542e-61dc-4cbf-84a1-4b1ef5874f07"],
Cell[197915, 5677, 2884, 79, 99, "Print", "ExpressionUUID" -> \
"d084c37f-0898-4179-bfca-a4646e0a9c8f"],
Cell[200802, 5758, 2876, 79, 99, "Print", "ExpressionUUID" -> \
"3d623f6e-4727-4503-92cb-aed9c5d6dcb2"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[203727, 5843, 4862, 136, 516, "Input", "ExpressionUUID" -> \
"e86598d1-c697-409e-95a7-d09fd10ac4a2"],
Cell[CellGroupData[{
Cell[208614, 5983, 1738, 47, 59, "Print", "ExpressionUUID" -> \
"83f6efdd-2e44-478c-9dde-42b735d68b9b"],
Cell[210355, 6032, 2352, 66, 99, "Print", "ExpressionUUID" -> \
"65decbe4-5c92-43f6-9b93-bff028a13633"],
Cell[212710, 6100, 2352, 66, 99, "Print", "ExpressionUUID" -> \
"6aad2364-87f3-4a78-8955-a04ae1d27a0b"]
}, Open  ]]
}, Open  ]]
}
]
*)

