(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    182927,       5053]
NotebookOptionsPosition[    176831,       4901]
NotebookOutlinePosition[    177167,       4916]
CellTagsIndexPosition[    177124,       4913]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "This", " ", "file", " ", "verifies", " ", "the", " ", "stabilizer", " ", 
    "calculations", " ", "above", " ", "the", " ", "mod", " ", "p", " ", 
    "orbit", " ", "OCs"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Orbit", " ", "1", " ", "Calculation"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22", ",", " ", "lam", ",", " ", "r", ",", " ", "s", ",", " ", 
      "t", ",", " ", "a", ",", " ", "b", ",", " ", "c"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "t"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "x", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"t", "/", "2"}], ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"t", "/", "2"}], ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "c", ",", " ", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"lam", "/", 
        RowBox[{"t", "^", "2"}]}], " ", "*", " ", "A1"}], " ", "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], " ", "*", 
        RowBox[{"lam", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", 
           RowBox[{"t", "^", "2"}]}], ")"}]}], " ", "*", " ", "A1"}], " ", 
       "+", " ", 
       RowBox[{
        RowBox[{"lam", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", "t"}], ")"}]}], " ", "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Solve", " ", "a"}], " ", "=", " ", 
     RowBox[{"b", "=", " ", 
      RowBox[{"c", " ", "=", " ", "0"}]}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", " ", "0"}], ";"}], " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Solve", " ", "lam"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"t", "^", "2"}], "/", 
      RowBox[{"r", "^", "2"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lam", " ", "=", " ", 
     RowBox[{
      RowBox[{"t", "^", "2"}], "/", 
      RowBox[{"r", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.733603881811367*^9, 3.733604137603126*^9}, {
   3.733604170891293*^9, 3.733604198122884*^9}, {3.7336054403800087`*^9, 
   3.7336054762674303`*^9}, {3.733673632099154*^9, 3.733673683457472*^9}, {
   3.7336737722487803`*^9, 3.733673780336542*^9}, {3.733690015157235*^9, 
   3.7336900196212273`*^9}, {3.733690071261084*^9, 3.733690159956675*^9}, 
   3.733690431181098*^9, {3.733691984370245*^9, 3.733692041601634*^9}, {
   3.7336938092877293`*^9, 3.733693882845791*^9}, {3.741182727101821*^9, 
   3.7411827274613333`*^9}, {3.7411828836539373`*^9, 
   3.7411829231653843`*^9}, {3.741182954219943*^9, 3.7411830232915287`*^9}, 
   3.7411838018247643`*^9, {3.7411838605979567`*^9, 3.741183896990212*^9}, 
   3.7411839940959682`*^9, {3.7411840477727947`*^9, 
   3.741184069660901*^9}},ExpressionUUID->"0e488e49-726f-4185-b1ac-\
02561b59a832"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "t"},
       {"0", "0", "x"},
       {"t", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["t", "2"], "x"},
       {
        FractionBox["t", "2"], "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, $CellContext`t}, {
     0, 0, $CellContext`x}, {$CellContext`t, $CellContext`x, \
$CellContext`x}}], 
   MatrixForm[{{0, Rational[1, 2] $CellContext`t, $CellContext`x}, {
     Rational[1, 
        2] $CellContext`t, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733605477720667*^9, 3.733673782399786*^9, 3.733690161316215*^9, 
   3.7336920469496527`*^9, 3.73369388646804*^9, 3.741182821155851*^9, 
   3.7411830239821253`*^9, 3.741183117012203*^9, {3.74118387588046*^9, 
   3.741183899115539*^9}, 
   3.741184071631751*^9},ExpressionUUID->"e0068e45-9653-4e74-9720-\
77bb8a6f713d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         RowBox[{"lam", " ", 
          SuperscriptBox["r", "2"]}], 
         SuperscriptBox["t", "2"]], 
        FractionBox[
         RowBox[{"a", " ", "lam", " ", "r"}], 
         SuperscriptBox["t", "2"]], 
        FractionBox[
         RowBox[{"b", " ", "lam", " ", "r"}], 
         SuperscriptBox["t", "2"]]},
       {
        FractionBox[
         RowBox[{"a", " ", "lam", " ", "r"}], 
         SuperscriptBox["t", "2"]], 
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], " ", "lam"}], 
         SuperscriptBox["t", "2"]], 
        FractionBox[
         RowBox[{"a", " ", "b", " ", "lam"}], 
         SuperscriptBox["t", "2"]]},
       {
        FractionBox[
         RowBox[{"b", " ", "lam", " ", "r"}], 
         SuperscriptBox["t", "2"]], 
        FractionBox[
         RowBox[{"a", " ", "b", " ", "lam"}], 
         SuperscriptBox["t", "2"]], 
        FractionBox[
         RowBox[{
          SuperscriptBox["b", "2"], " ", "lam"}], 
         SuperscriptBox["t", "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"c", " ", "lam", " ", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"a", " ", "c", " ", "lam", " ", "r"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"b", " ", "c", " ", "lam", " ", "r"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}]},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"a", " ", "c", " ", "lam", " ", "r"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], " ", "c", " ", "lam"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"a", " ", "b", " ", "c", " ", "lam"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}]},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"b", " ", "c", " ", "lam", " ", "r"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"a", " ", "b", " ", "c", " ", "lam"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["b", "2"], " ", "c", " ", "lam"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`lam $CellContext`r^2 $CellContext`t^(-2), \
$CellContext`a $CellContext`lam $CellContext`r $CellContext`t^(-2), \
$CellContext`b $CellContext`lam $CellContext`r $CellContext`t^(-2)}, \
{$CellContext`a $CellContext`lam $CellContext`r $CellContext`t^(-2), \
$CellContext`a^2 $CellContext`lam $CellContext`t^(-2), $CellContext`a \
$CellContext`b $CellContext`lam $CellContext`t^(-2)}, {$CellContext`b \
$CellContext`lam $CellContext`r $CellContext`t^(-2), $CellContext`a \
$CellContext`b $CellContext`lam $CellContext`t^(-2), $CellContext`b^2 \
$CellContext`lam $CellContext`t^(-2)}}], 
   MatrixForm[{{-$CellContext`c $CellContext`lam $CellContext`r^2 \
$CellContext`s^(-1) $CellContext`t^(-2), -$CellContext`a $CellContext`c \
$CellContext`lam $CellContext`r $CellContext`s^(-1) $CellContext`t^(-2), \
-$CellContext`b $CellContext`c $CellContext`lam $CellContext`r \
$CellContext`s^(-1) $CellContext`t^(-2)}, {-$CellContext`a $CellContext`c \
$CellContext`lam $CellContext`r $CellContext`s^(-1) $CellContext`t^(-2), \
-$CellContext`a^2 $CellContext`c $CellContext`lam $CellContext`s^(-1) \
$CellContext`t^(-2), -$CellContext`a $CellContext`b $CellContext`c \
$CellContext`lam $CellContext`s^(-1) $CellContext`t^(-2)}, {-$CellContext`b \
$CellContext`c $CellContext`lam $CellContext`r $CellContext`s^(-1) \
$CellContext`t^(-2), -$CellContext`a $CellContext`b $CellContext`c \
$CellContext`lam $CellContext`s^(-1) $CellContext`t^(-2), -$CellContext`b^2 \
$CellContext`c $CellContext`lam $CellContext`s^(-1) $CellContext`t^(-2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733605477720667*^9, 3.733673782399786*^9, 3.733690161316215*^9, 
   3.7336920469496527`*^9, 3.73369388646804*^9, 3.741182821155851*^9, 
   3.7411830239821253`*^9, 3.741183117012203*^9, {3.74118387588046*^9, 
   3.741183899115539*^9}, 
   3.741184071634615*^9},ExpressionUUID->"4ba354e8-48b6-4c19-9c65-\
6e73181e55bc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         RowBox[{"lam", " ", 
          SuperscriptBox["r", "2"]}], 
         SuperscriptBox["t", "2"]], "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`lam $CellContext`r^2 $CellContext`t^(-2), 0, 
      0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733605477720667*^9, 3.733673782399786*^9, 3.733690161316215*^9, 
   3.7336920469496527`*^9, 3.73369388646804*^9, 3.741182821155851*^9, 
   3.7411830239821253`*^9, 3.741183117012203*^9, {3.74118387588046*^9, 
   3.741183899115539*^9}, 
   3.741184071637556*^9},ExpressionUUID->"040d7783-3dcf-4c78-9836-\
3bb532b74154"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{1, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733605477720667*^9, 3.733673782399786*^9, 3.733690161316215*^9, 
   3.7336920469496527`*^9, 3.73369388646804*^9, 3.741182821155851*^9, 
   3.7411830239821253`*^9, 3.741183117012203*^9, {3.74118387588046*^9, 
   3.741183899115539*^9}, 
   3.741184071639278*^9},ExpressionUUID->"3c006be7-83a0-4ca2-803e-\
31138a1994cd"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7336040005819197`*^9, 
  3.733604001915707*^9}},ExpressionUUID->"6763bfb3-ce06-41f5-ac09-\
a426d1db0c8b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Orbit", " ", "2", " ", "Calculation"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22", ",", " ", "lam", ",", " ", "r", ",", " ", "s", ",", " ", 
      "t", ",", " ", "a", ",", " ", "b", ",", " ", "c"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "c", ",", " ", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"lam", "/", 
        RowBox[{"t", "^", "2"}]}], " ", "*", " ", "A1"}], " ", "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], " ", "*", 
        RowBox[{"lam", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", 
           RowBox[{"t", "^", "2"}]}], ")"}]}], " ", "*", " ", "A1"}], " ", 
       "+", " ", 
       RowBox[{
        RowBox[{"lam", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", "t"}], ")"}]}], " ", "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Solve", " ", "lam"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"t", "^", "2"}], "/", 
      RowBox[{"s", "^", "2"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lam", " ", "=", " ", 
     RowBox[{
      RowBox[{"t", "^", "2"}], "/", 
      RowBox[{"s", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.7336940558203917`*^9, 3.733694059500164*^9}, {
   3.7411827360375032`*^9, 3.7411827361731567`*^9}, 3.741183079668103*^9, {
   3.741183225699017*^9, 3.741183237217942*^9}, {3.741183788375443*^9, 
   3.741183788854369*^9}, {3.7411839363732433`*^9, 3.741183945143045*^9}, 
   3.741183989607789*^9, {3.741184076340529*^9, 
   3.7411840828367567`*^9}},ExpressionUUID->"8f18d29d-1335-4ebd-b003-\
26393740552f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "t"},
       {"0", "0", "x"},
       {"t", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["t", "2"], "x"},
       {
        FractionBox["t", "2"], "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, $CellContext`t}, {
     0, 0, $CellContext`x}, {$CellContext`t, $CellContext`x, \
$CellContext`x}}], 
   MatrixForm[{{0, Rational[1, 2] $CellContext`t, $CellContext`x}, {
     Rational[1, 
        2] $CellContext`t, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733694061331737*^9, 3.7411828263254347`*^9, 
  3.741183238195388*^9, 3.741183946005657*^9, 
  3.74118408494429*^9},ExpressionUUID->"0f28bece-ca09-4366-9ec0-c3e71e1242aa"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        FractionBox[
         RowBox[{"lam", " ", 
          SuperscriptBox["s", "2"]}], 
         SuperscriptBox["t", "2"]], 
        FractionBox[
         RowBox[{"c", " ", "lam", " ", "s"}], 
         SuperscriptBox["t", "2"]]},
       {"0", 
        FractionBox[
         RowBox[{"c", " ", "lam", " ", "s"}], 
         SuperscriptBox["t", "2"]], 
        FractionBox[
         RowBox[{
          SuperscriptBox["c", "2"], " ", "lam"}], 
         SuperscriptBox["t", "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"c", " ", "lam", " ", "s"}], 
          SuperscriptBox["t", "2"]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["c", "2"], " ", "lam"}], 
          SuperscriptBox["t", "2"]]}]},
       {"0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["c", "2"], " ", "lam"}], 
          SuperscriptBox["t", "2"]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["c", "3"], " ", "lam"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {
     0, $CellContext`lam $CellContext`s^2 $CellContext`t^(-2), $CellContext`c \
$CellContext`lam $CellContext`s $CellContext`t^(-2)}, {
     0, $CellContext`c $CellContext`lam $CellContext`s $CellContext`t^(-2), \
$CellContext`c^2 $CellContext`lam $CellContext`t^(-2)}}], 
   MatrixForm[{{0, 0, 0}, {
     0, -$CellContext`c $CellContext`lam $CellContext`s $CellContext`t^(-2), \
-$CellContext`c^2 $CellContext`lam $CellContext`t^(-2)}, {
     0, -$CellContext`c^2 $CellContext`lam $CellContext`t^(-2), \
-$CellContext`c^3 $CellContext`lam $CellContext`s^(-1) $CellContext`t^(-2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733694061331737*^9, 3.7411828263254347`*^9, 
  3.741183238195388*^9, 3.741183946005657*^9, 
  3.7411840849473963`*^9},ExpressionUUID->"05db5b9e-9d1f-4a67-b044-\
288bd835119a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", 
        FractionBox["c", "s"]},
       {"0", 
        FractionBox["c", "s"], 
        FractionBox[
         SuperscriptBox["c", "2"], 
         SuperscriptBox["s", "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        RowBox[{"-", 
         FractionBox["c", "s"]}], 
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["c", "2"], 
          SuperscriptBox["s", "2"]]}]},
       {"0", 
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["c", "2"], 
          SuperscriptBox["s", "2"]]}], 
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["c", "3"], 
          SuperscriptBox["s", "3"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 1, $CellContext`c/$CellContext`s}, {
     0, $CellContext`c/$CellContext`s, $CellContext`c^2 \
$CellContext`s^(-2)}}], 
   MatrixForm[{{0, 0, 0}, {
     0, -$CellContext`c/$CellContext`s, -$CellContext`c^2 \
$CellContext`s^(-2)}, {
     0, -$CellContext`c^2 $CellContext`s^(-2), -$CellContext`c^3 \
$CellContext`s^(-3)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733694061331737*^9, 3.7411828263254347`*^9, 
  3.741183238195388*^9, 3.741183946005657*^9, 
  3.7411840849498167`*^9},ExpressionUUID->"5720545c-f4de-44b5-9f5a-\
bbd2588a8b21"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Orbit", " ", "3", " ", "Calculation"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22", ",", " ", "lam", ",", " ", "r", ",", " ", "s", ",", " ", 
      "t", ",", " ", "a", ",", " ", "b", ",", " ", "c"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "c", ",", " ", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"lam", "/", 
        RowBox[{"t", "^", "2"}]}], " ", "*", " ", "A1"}], " ", "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], " ", "*", 
        RowBox[{"lam", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", 
           RowBox[{"t", "^", "2"}]}], ")"}]}], " ", "*", " ", "A1"}], " ", 
       "+", " ", 
       RowBox[{
        RowBox[{"lam", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", "t"}], ")"}]}], " ", "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Solve", " ", "lam"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"t", "^", "2"}], "/", 
      RowBox[{"s", "^", "2"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lam", " ", "=", " ", 
     RowBox[{
      RowBox[{"t", "^", "2"}], "/", 
      RowBox[{"s", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Solve", " ", "r"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"s", "^", "2"}], "/", "t"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r", " ", "=", " ", 
     RowBox[{
      RowBox[{"s", "^", "2"}], "/", "t"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.733694123556045*^9, 3.733694125692024*^9}, {
   3.741182739989409*^9, 3.741182740077194*^9}, 3.741183082724061*^9, {
   3.741183256443055*^9, 3.741183259177754*^9}, 3.7411838083598948`*^9, {
   3.741183950989304*^9, 3.741183982805274*^9}, {3.741184100756279*^9, 
   3.741184132533746*^9}},ExpressionUUID->"c6c2f7c7-ef4b-4b1f-b119-\
6692748579c2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "t"},
       {"0", "0", "x"},
       {"t", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["t", "2"], "x"},
       {
        FractionBox["t", "2"], "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, $CellContext`t}, {
     0, 0, $CellContext`x}, {$CellContext`t, $CellContext`x, \
$CellContext`x}}], 
   MatrixForm[{{0, Rational[1, 2] $CellContext`t, $CellContext`x}, {
     Rational[1, 
        2] $CellContext`t, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733694127737323*^9, 3.741182830395007*^9, 3.7411832597169313`*^9, 
   3.741183965499498*^9, {3.7411841106487083`*^9, 
   3.7411841330277567`*^9}},ExpressionUUID->"e74fe360-da33-436e-b84b-\
79355159b4a5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        FractionBox[
         RowBox[{"lam", " ", "r"}], "t"]},
       {"0", 
        FractionBox[
         RowBox[{"lam", " ", 
          SuperscriptBox["s", "2"]}], 
         SuperscriptBox["t", "2"]], 
        RowBox[{
         FractionBox[
          RowBox[{"c", " ", "lam", " ", "s"}], 
          SuperscriptBox["t", "2"]], "+", 
         FractionBox[
          RowBox[{"a", " ", "lam"}], "t"]}]},
       {
        FractionBox[
         RowBox[{"lam", " ", "r"}], "t"], 
        RowBox[{
         FractionBox[
          RowBox[{"c", " ", "lam", " ", "s"}], 
          SuperscriptBox["t", "2"]], "+", 
         FractionBox[
          RowBox[{"a", " ", "lam"}], "t"]}], 
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox["c", "2"], " ", "lam"}], 
          SuperscriptBox["t", "2"]], "+", 
         FractionBox[
          RowBox[{"2", " ", "b", " ", "lam"}], "t"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"c", " ", "lam", " ", "r"}], 
          RowBox[{"s", " ", "t"}]]}]},
       {"0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"c", " ", "lam", " ", "s"}], 
          SuperscriptBox["t", "2"]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["c", "2"], " ", "lam"}], 
           SuperscriptBox["t", "2"]]}], "-", 
         FractionBox[
          RowBox[{"a", " ", "c", " ", "lam"}], 
          RowBox[{"s", " ", "t"}]]}]},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"c", " ", "lam", " ", "r"}], 
          RowBox[{"s", " ", "t"}]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["c", "2"], " ", "lam"}], 
           SuperscriptBox["t", "2"]]}], "-", 
         FractionBox[
          RowBox[{"a", " ", "c", " ", "lam"}], 
          RowBox[{"s", " ", "t"}]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["c", "3"], " ", "lam"}], 
           RowBox[{"s", " ", 
            SuperscriptBox["t", "2"]}]]}], "-", 
         FractionBox[
          RowBox[{"2", " ", "b", " ", "c", " ", "lam"}], 
          RowBox[{"s", " ", "t"}]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, $CellContext`lam $CellContext`r/$CellContext`t}, {
     0, $CellContext`lam $CellContext`s^2 $CellContext`t^(-2), $CellContext`c \
$CellContext`lam $CellContext`s $CellContext`t^(-2) + $CellContext`a \
$CellContext`lam/$CellContext`t}, {$CellContext`lam \
$CellContext`r/$CellContext`t, $CellContext`c $CellContext`lam $CellContext`s \
$CellContext`t^(-2) + $CellContext`a $CellContext`lam/$CellContext`t, \
$CellContext`c^2 $CellContext`lam $CellContext`t^(-2) + 
      2 $CellContext`b $CellContext`lam/$CellContext`t}}], 
   MatrixForm[{{
     0, 0, -$CellContext`c $CellContext`lam $CellContext`r \
$CellContext`s^(-1)/$CellContext`t}, {
     0, -$CellContext`c $CellContext`lam $CellContext`s $CellContext`t^(-2), \
-$CellContext`c^2 $CellContext`lam $CellContext`t^(-2) - $CellContext`a \
$CellContext`c $CellContext`lam $CellContext`s^(-1)/$CellContext`t}, \
{-$CellContext`c $CellContext`lam $CellContext`r \
$CellContext`s^(-1)/$CellContext`t, -$CellContext`c^2 $CellContext`lam \
$CellContext`t^(-2) - $CellContext`a $CellContext`c $CellContext`lam \
$CellContext`s^(-1)/$CellContext`t, -$CellContext`c^3 $CellContext`lam \
$CellContext`s^(-1) $CellContext`t^(-2) - 
      2 $CellContext`b $CellContext`c $CellContext`lam \
$CellContext`s^(-1)/$CellContext`t}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733694127737323*^9, 3.741182830395007*^9, 3.7411832597169313`*^9, 
   3.741183965499498*^9, {3.7411841106487083`*^9, 
   3.74118413303188*^9}},ExpressionUUID->"dd66a5e1-7c4f-4386-aa36-\
a202211a5353"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        FractionBox[
         RowBox[{"r", " ", "t"}], 
         SuperscriptBox["s", "2"]]},
       {"0", "1", 
        RowBox[{
         FractionBox["c", "s"], "+", 
         FractionBox[
          RowBox[{"a", " ", "t"}], 
          SuperscriptBox["s", "2"]]}]},
       {
        FractionBox[
         RowBox[{"r", " ", "t"}], 
         SuperscriptBox["s", "2"]], 
        RowBox[{
         FractionBox["c", "s"], "+", 
         FractionBox[
          RowBox[{"a", " ", "t"}], 
          SuperscriptBox["s", "2"]]}], 
        RowBox[{
         FractionBox[
          SuperscriptBox["c", "2"], 
          SuperscriptBox["s", "2"]], "+", 
         FractionBox[
          RowBox[{"2", " ", "b", " ", "t"}], 
          SuperscriptBox["s", "2"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"c", " ", "r", " ", "t"}], 
          SuperscriptBox["s", "3"]]}]},
       {"0", 
        RowBox[{"-", 
         FractionBox["c", "s"]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox["c", "2"], 
           SuperscriptBox["s", "2"]]}], "-", 
         FractionBox[
          RowBox[{"a", " ", "c", " ", "t"}], 
          SuperscriptBox["s", "3"]]}]},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"c", " ", "r", " ", "t"}], 
          SuperscriptBox["s", "3"]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox["c", "2"], 
           SuperscriptBox["s", "2"]]}], "-", 
         FractionBox[
          RowBox[{"a", " ", "c", " ", "t"}], 
          SuperscriptBox["s", "3"]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox["c", "3"], 
           SuperscriptBox["s", "3"]]}], "-", 
         FractionBox[
          RowBox[{"2", " ", "b", " ", "c", " ", "t"}], 
          SuperscriptBox["s", "3"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, $CellContext`r $CellContext`s^(-2) $CellContext`t}, {
     0, 1, $CellContext`c/$CellContext`s + $CellContext`a $CellContext`s^(-2) \
$CellContext`t}, {$CellContext`r $CellContext`s^(-2) $CellContext`t, \
$CellContext`c/$CellContext`s + $CellContext`a $CellContext`s^(-2) \
$CellContext`t, $CellContext`c^2 $CellContext`s^(-2) + 
      2 $CellContext`b $CellContext`s^(-2) $CellContext`t}}], 
   MatrixForm[{{
     0, 0, -$CellContext`c $CellContext`r $CellContext`s^(-3) \
$CellContext`t}, {
     0, -$CellContext`c/$CellContext`s, -$CellContext`c^2 $CellContext`s^(-2) - \
$CellContext`a $CellContext`c $CellContext`s^(-3) $CellContext`t}, \
{-$CellContext`c $CellContext`r $CellContext`s^(-3) $CellContext`t, \
-$CellContext`c^2 $CellContext`s^(-2) - $CellContext`a $CellContext`c \
$CellContext`s^(-3) $CellContext`t, -$CellContext`c^3 $CellContext`s^(-3) - 
      2 $CellContext`b $CellContext`c $CellContext`s^(-3) $CellContext`t}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733694127737323*^9, 3.741182830395007*^9, 3.7411832597169313`*^9, 
   3.741183965499498*^9, {3.7411841106487083`*^9, 
   3.741184133035267*^9}},ExpressionUUID->"46398fad-3c13-4aed-8a48-\
46d72b1bca06"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "1", 
        RowBox[{
         FractionBox["c", "s"], "+", 
         FractionBox[
          RowBox[{"a", " ", "t"}], 
          SuperscriptBox["s", "2"]]}]},
       {"1", 
        RowBox[{
         FractionBox["c", "s"], "+", 
         FractionBox[
          RowBox[{"a", " ", "t"}], 
          SuperscriptBox["s", "2"]]}], 
        RowBox[{
         FractionBox[
          SuperscriptBox["c", "2"], 
          SuperscriptBox["s", "2"]], "+", 
         FractionBox[
          RowBox[{"2", " ", "b", " ", "t"}], 
          SuperscriptBox["s", "2"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{"-", 
         FractionBox["c", "s"]}]},
       {"0", 
        RowBox[{"-", 
         FractionBox["c", "s"]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox["c", "2"], 
           SuperscriptBox["s", "2"]]}], "-", 
         FractionBox[
          RowBox[{"a", " ", "c", " ", "t"}], 
          SuperscriptBox["s", "3"]]}]},
       {
        RowBox[{"-", 
         FractionBox["c", "s"]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox["c", "2"], 
           SuperscriptBox["s", "2"]]}], "-", 
         FractionBox[
          RowBox[{"a", " ", "c", " ", "t"}], 
          SuperscriptBox["s", "3"]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox["c", "3"], 
           SuperscriptBox["s", "3"]]}], "-", 
         FractionBox[
          RowBox[{"2", " ", "b", " ", "c", " ", "t"}], 
          SuperscriptBox["s", "3"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 1}, {
     0, 1, $CellContext`c/$CellContext`s + $CellContext`a $CellContext`s^(-2) \
$CellContext`t}, {
     1, $CellContext`c/$CellContext`s + $CellContext`a $CellContext`s^(-2) \
$CellContext`t, $CellContext`c^2 $CellContext`s^(-2) + 
      2 $CellContext`b $CellContext`s^(-2) $CellContext`t}}], 
   MatrixForm[{{0, 0, -$CellContext`c/$CellContext`s}, {
     0, -$CellContext`c/$CellContext`s, -$CellContext`c^2 $CellContext`s^(-2) - \
$CellContext`a $CellContext`c $CellContext`s^(-3) $CellContext`t}, \
{-$CellContext`c/$CellContext`s, -$CellContext`c^2 $CellContext`s^(-2) - \
$CellContext`a $CellContext`c $CellContext`s^(-3) $CellContext`t, \
-$CellContext`c^3 $CellContext`s^(-3) - 
      2 $CellContext`b $CellContext`c $CellContext`s^(-3) $CellContext`t}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733694127737323*^9, 3.741182830395007*^9, 3.7411832597169313`*^9, 
   3.741183965499498*^9, {3.7411841106487083`*^9, 
   3.741184133038498*^9}},ExpressionUUID->"fda8da7e-9e9b-4972-be3d-\
8095fc6cb4df"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Orbit", " ", "4", " ", "Calculation"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22", ",", " ", "lam", ",", " ", "r", ",", " ", "s", ",", " ", 
      "t", ",", " ", "a", ",", " ", "b", ",", " ", "c"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "c", ",", " ", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"lam", "/", 
        RowBox[{"t", "^", "2"}]}], " ", "*", " ", "A1"}], " ", "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], " ", "*", 
        RowBox[{"lam", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", 
           RowBox[{"t", "^", "2"}]}], ")"}]}], " ", "*", " ", "A1"}], " ", 
       "+", " ", 
       RowBox[{
        RowBox[{"lam", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", "t"}], ")"}]}], " ", "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"Solve", " ", "a"}], " ", "=", " ", "0"}], ",", " ", 
     RowBox[{"lam", " ", "=", " ", 
      RowBox[{"st", "/", 
       RowBox[{"r", "^", "2"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lam", " ", "=", " ", 
     RowBox[{"s", "*", 
      RowBox[{"t", "/", 
       RowBox[{"r", "^", "2"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Solve", " ", "t"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"s", "^", "3"}], "/", 
      RowBox[{"r", "^", "2"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"t", " ", "=", " ", 
     RowBox[{
      RowBox[{"s", "^", "3"}], "/", 
      RowBox[{"r", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.733694266894409*^9, 3.733694288987425*^9}, {
   3.741182743749393*^9, 3.741182743917056*^9}, 3.7411830850934143`*^9, {
   3.741183302946804*^9, 3.7411833054975033`*^9}, 3.7411838119061117`*^9, 
   3.741184000453971*^9, {3.7411841415079536`*^9, 3.741184291163561*^9}, {
   3.741184338939506*^9, 3.741184388498487*^9}, {3.741184456499263*^9, 
   3.7411844780502043`*^9}, {3.7411845104765663`*^9, 3.74118463872199*^9}, {
   3.741184686673197*^9, 
   3.741184698616385*^9}},ExpressionUUID->"9cf163a4-504e-46fe-84a1-\
d7debc26edd6"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "t"},
       {"0", "0", "x"},
       {"t", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["t", "2"], "x"},
       {
        FractionBox["t", "2"], "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, $CellContext`t}, {
     0, 0, $CellContext`x}, {$CellContext`t, $CellContext`x, \
$CellContext`x}}], 
   MatrixForm[{{0, Rational[1, 2] $CellContext`t, $CellContext`x}, {
     Rational[1, 
        2] $CellContext`t, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733694290568157*^9, 3.741182835777418*^9, 3.741183306207921*^9, 
   3.741184185718898*^9, 3.741184248565728*^9, 3.741184291645425*^9, {
   3.741184360066537*^9, 3.741184389173183*^9}, {3.741184478509892*^9, 
   3.741184510807364*^9}, 3.741184566107717*^9, {3.741184617960259*^9, 
   3.741184638992663*^9}, 
   3.741184699081231*^9},ExpressionUUID->"76f76cef-7625-41ef-a916-\
52b59df5180b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        FractionBox[
         RowBox[{"lam", " ", 
          SuperscriptBox["s", "2"]}], 
         SuperscriptBox["t", "2"]], 
        FractionBox[
         RowBox[{"c", " ", "lam", " ", "s"}], 
         SuperscriptBox["t", "2"]]},
       {"0", 
        FractionBox[
         RowBox[{"c", " ", "lam", " ", "s"}], 
         SuperscriptBox["t", "2"]], 
        FractionBox[
         RowBox[{
          SuperscriptBox["c", "2"], " ", "lam"}], 
         SuperscriptBox["t", "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         RowBox[{"lam", " ", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{"s", " ", "t"}]], 
        FractionBox[
         RowBox[{"a", " ", "lam", " ", "r"}], 
         RowBox[{"s", " ", "t"}]], 
        FractionBox[
         RowBox[{"b", " ", "lam", " ", "r"}], 
         RowBox[{"s", " ", "t"}]]},
       {
        FractionBox[
         RowBox[{"a", " ", "lam", " ", "r"}], 
         RowBox[{"s", " ", "t"}]], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"c", " ", "lam", " ", "s"}], 
           SuperscriptBox["t", "2"]]}], "+", 
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], " ", "lam"}], 
          RowBox[{"s", " ", "t"}]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["c", "2"], " ", "lam"}], 
           SuperscriptBox["t", "2"]]}], "+", 
         FractionBox[
          RowBox[{"a", " ", "b", " ", "lam"}], 
          RowBox[{"s", " ", "t"}]]}]},
       {
        FractionBox[
         RowBox[{"b", " ", "lam", " ", "r"}], 
         RowBox[{"s", " ", "t"}]], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["c", "2"], " ", "lam"}], 
           SuperscriptBox["t", "2"]]}], "+", 
         FractionBox[
          RowBox[{"a", " ", "b", " ", "lam"}], 
          RowBox[{"s", " ", "t"}]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["c", "3"], " ", "lam"}], 
           RowBox[{"s", " ", 
            SuperscriptBox["t", "2"]}]]}], "+", 
         FractionBox[
          RowBox[{
           SuperscriptBox["b", "2"], " ", "lam"}], 
          RowBox[{"s", " ", "t"}]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {
     0, $CellContext`lam $CellContext`s^2 $CellContext`t^(-2), $CellContext`c \
$CellContext`lam $CellContext`s $CellContext`t^(-2)}, {
     0, $CellContext`c $CellContext`lam $CellContext`s $CellContext`t^(-2), \
$CellContext`c^2 $CellContext`lam $CellContext`t^(-2)}}], 
   MatrixForm[{{$CellContext`lam $CellContext`r^2 \
$CellContext`s^(-1)/$CellContext`t, $CellContext`a $CellContext`lam \
$CellContext`r $CellContext`s^(-1)/$CellContext`t, $CellContext`b \
$CellContext`lam $CellContext`r $CellContext`s^(-1)/$CellContext`t}, \
{$CellContext`a $CellContext`lam $CellContext`r \
$CellContext`s^(-1)/$CellContext`t, -$CellContext`c $CellContext`lam \
$CellContext`s $CellContext`t^(-2) + $CellContext`a^2 $CellContext`lam \
$CellContext`s^(-1)/$CellContext`t, -$CellContext`c^2 $CellContext`lam \
$CellContext`t^(-2) + $CellContext`a $CellContext`b $CellContext`lam \
$CellContext`s^(-1)/$CellContext`t}, {$CellContext`b $CellContext`lam \
$CellContext`r $CellContext`s^(-1)/$CellContext`t, -$CellContext`c^2 \
$CellContext`lam $CellContext`t^(-2) + $CellContext`a $CellContext`b \
$CellContext`lam $CellContext`s^(-1)/$CellContext`t, -$CellContext`c^3 \
$CellContext`lam $CellContext`s^(-1) $CellContext`t^(-2) + $CellContext`b^2 \
$CellContext`lam $CellContext`s^(-1)/$CellContext`t}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733694290568157*^9, 3.741182835777418*^9, 3.741183306207921*^9, 
   3.741184185718898*^9, 3.741184248565728*^9, 3.741184291645425*^9, {
   3.741184360066537*^9, 3.741184389173183*^9}, {3.741184478509892*^9, 
   3.741184510807364*^9}, 3.741184566107717*^9, {3.741184617960259*^9, 
   3.741184638992663*^9}, 
   3.741184699085474*^9},ExpressionUUID->"87354b09-4b2e-4e46-ab94-\
f6556754dc1b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", 
        FractionBox[
         SuperscriptBox["s", "3"], 
         RowBox[{
          SuperscriptBox["r", "2"], " ", "t"}]], 
        FractionBox[
         RowBox[{"c", " ", 
          SuperscriptBox["s", "2"]}], 
         RowBox[{
          SuperscriptBox["r", "2"], " ", "t"}]]},
       {"0", 
        FractionBox[
         RowBox[{"c", " ", 
          SuperscriptBox["s", "2"]}], 
         RowBox[{
          SuperscriptBox["r", "2"], " ", "t"}]], 
        FractionBox[
         RowBox[{
          SuperscriptBox["c", "2"], " ", "s"}], 
         RowBox[{
          SuperscriptBox["r", "2"], " ", "t"}]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", 
        FractionBox["b", "r"]},
       {"0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"c", " ", 
           SuperscriptBox["s", "2"]}], 
          RowBox[{
           SuperscriptBox["r", "2"], " ", "t"}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["c", "2"], " ", "s"}], 
          RowBox[{
           SuperscriptBox["r", "2"], " ", "t"}]]}]},
       {
        FractionBox["b", "r"], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["c", "2"], " ", "s"}], 
          RowBox[{
           SuperscriptBox["r", "2"], " ", "t"}]]}], 
        RowBox[{
         FractionBox[
          SuperscriptBox["b", "2"], 
          SuperscriptBox["r", "2"]], "-", 
         FractionBox[
          SuperscriptBox["c", "3"], 
          RowBox[{
           SuperscriptBox["r", "2"], " ", "t"}]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {
     0, $CellContext`r^(-2) $CellContext`s^3/$CellContext`t, $CellContext`c \
$CellContext`r^(-2) $CellContext`s^2/$CellContext`t}, {
     0, $CellContext`c $CellContext`r^(-2) $CellContext`s^2/$CellContext`t, \
$CellContext`c^2 $CellContext`r^(-2) $CellContext`s/$CellContext`t}}], 
   MatrixForm[{{1, 0, $CellContext`b/$CellContext`r}, {
     0, -$CellContext`c $CellContext`r^(-2) $CellContext`s^2/$CellContext`t, \
-$CellContext`c^2 $CellContext`r^(-2) $CellContext`s/$CellContext`t}, \
{$CellContext`b/$CellContext`r, -$CellContext`c^2 $CellContext`r^(-2) \
$CellContext`s/$CellContext`t, $CellContext`b^2 $CellContext`r^(-2) - \
$CellContext`c^3 $CellContext`r^(-2)/$CellContext`t}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733694290568157*^9, 3.741182835777418*^9, 3.741183306207921*^9, 
   3.741184185718898*^9, 3.741184248565728*^9, 3.741184291645425*^9, {
   3.741184360066537*^9, 3.741184389173183*^9}, {3.741184478509892*^9, 
   3.741184510807364*^9}, 3.741184566107717*^9, {3.741184617960259*^9, 
   3.741184638992663*^9}, 
   3.741184699088587*^9},ExpressionUUID->"377b0de8-c526-43b3-b391-\
664e598071d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "1", 
        FractionBox["c", "s"]},
       {"0", 
        FractionBox["c", "s"], 
        FractionBox[
         SuperscriptBox["c", "2"], 
         SuperscriptBox["s", "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", 
        FractionBox["b", "r"]},
       {"0", 
        RowBox[{"-", 
         FractionBox["c", "s"]}], 
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["c", "2"], 
          SuperscriptBox["s", "2"]]}]},
       {
        FractionBox["b", "r"], 
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["c", "2"], 
          SuperscriptBox["s", "2"]]}], 
        RowBox[{
         FractionBox[
          SuperscriptBox["b", "2"], 
          SuperscriptBox["r", "2"]], "-", 
         FractionBox[
          SuperscriptBox["c", "3"], 
          SuperscriptBox["s", "3"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 1, $CellContext`c/$CellContext`s}, {
     0, $CellContext`c/$CellContext`s, $CellContext`c^2 \
$CellContext`s^(-2)}}], 
   MatrixForm[{{1, 0, $CellContext`b/$CellContext`r}, {
     0, -$CellContext`c/$CellContext`s, -$CellContext`c^2 \
$CellContext`s^(-2)}, {$CellContext`b/$CellContext`r, -$CellContext`c^2 \
$CellContext`s^(-2), $CellContext`b^2 $CellContext`r^(-2) - $CellContext`c^3 \
$CellContext`s^(-3)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733694290568157*^9, 3.741182835777418*^9, 3.741183306207921*^9, 
   3.741184185718898*^9, 3.741184248565728*^9, 3.741184291645425*^9, {
   3.741184360066537*^9, 3.741184389173183*^9}, {3.741184478509892*^9, 
   3.741184510807364*^9}, 3.741184566107717*^9, {3.741184617960259*^9, 
   3.741184638992663*^9}, 
   3.741184699091185*^9},ExpressionUUID->"cfef23fb-7b85-45f4-aab3-\
8453596d5671"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.741184186979899*^9, 
  3.741184189803175*^9}},ExpressionUUID->"fcc33aa7-1868-499f-a17e-\
151b16644881"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Orbit", " ", "5", " ", "Calculation"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22", ",", " ", "lam", ",", " ", "r", ",", " ", "s", ",", " ", 
      "t", ",", " ", "a", ",", " ", "b", ",", " ", "c"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", 
         RowBox[{"1", "/", "2"}], ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "c", ",", " ", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"lam", "/", 
        RowBox[{"t", "^", "2"}]}], " ", "*", " ", "A1"}], " ", "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], " ", "*", 
        RowBox[{"lam", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", 
           RowBox[{"t", "^", "2"}]}], ")"}]}], " ", "*", " ", "A1"}], " ", 
       "+", " ", 
       RowBox[{
        RowBox[{"lam", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", "t"}], ")"}]}], " ", "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Solve", " ", "b"}], " ", "=", " ", 
      RowBox[{"c", "=", " ", "0"}]}], ",", " ", 
     RowBox[{"lam", " ", "=", " ", 
      RowBox[{
       RowBox[{"t", "^", "2"}], "/", 
       RowBox[{"r", "^", "2"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", " ", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lam", " ", "=", " ", 
     RowBox[{
      RowBox[{"t", "^", "2"}], "/", 
      RowBox[{"r", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Case", " ", "a"}], " ", "=", " ", "0"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"This", " ", "case", " ", "obtains", " ", "s"}], " ", "=", " ", 
     "r"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", 
     RowBox[{"-", "s"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"This", " ", "case", " ", "obtains", " ", "s"}], " ", "=", " ", 
     RowBox[{"-", "r"}]}], " ", "*)"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.733694466018618*^9, 3.7336944887545853`*^9}, {
   3.741182748757246*^9, 3.741182749005067*^9}, 3.741183087356922*^9, {
   3.741183342842618*^9, 3.741183345297242*^9}, 3.7411838160086927`*^9, 
   3.741184004117468*^9, {3.7411847068082113`*^9, 3.741184731201339*^9}, {
   3.741184772464653*^9, 
   3.7411849228110037`*^9}},ExpressionUUID->"db2ecbcc-f901-4d7d-bf9f-\
023ab4b7cad2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "t"},
       {"0", "0", "x"},
       {"t", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["t", "2"], "x"},
       {
        FractionBox["t", "2"], "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, $CellContext`t}, {
     0, 0, $CellContext`x}, {$CellContext`t, $CellContext`x, \
$CellContext`x}}], 
   MatrixForm[{{0, Rational[1, 2] $CellContext`t, $CellContext`x}, {
     Rational[1, 
        2] $CellContext`t, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.741184876925*^9, 
  3.7411849239976*^9}},ExpressionUUID->"cae501bb-9cba-4972-949c-556305512ac2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         RowBox[{"lam", " ", 
          SuperscriptBox["r", "2"]}], 
         SuperscriptBox["t", "2"]], 
        RowBox[{
         FractionBox[
          RowBox[{"a", " ", "lam", " ", "r"}], 
          SuperscriptBox["t", "2"]], "+", 
         FractionBox[
          RowBox[{"lam", " ", "r", " ", "s"}], 
          RowBox[{"2", " ", 
           SuperscriptBox["t", "2"]}]]}], 
        RowBox[{
         FractionBox[
          RowBox[{"b", " ", "lam", " ", "r"}], 
          SuperscriptBox["t", "2"]], "+", 
         FractionBox[
          RowBox[{"c", " ", "lam", " ", "r"}], 
          RowBox[{"2", " ", 
           SuperscriptBox["t", "2"]}]]}]},
       {
        RowBox[{
         FractionBox[
          RowBox[{"a", " ", "lam", " ", "r"}], 
          SuperscriptBox["t", "2"]], "+", 
         FractionBox[
          RowBox[{"lam", " ", "r", " ", "s"}], 
          RowBox[{"2", " ", 
           SuperscriptBox["t", "2"]}]]}], 
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], " ", "lam"}], 
          SuperscriptBox["t", "2"]], "+", 
         FractionBox[
          RowBox[{"a", " ", "lam", " ", "s"}], 
          SuperscriptBox["t", "2"]]}], 
        RowBox[{
         FractionBox[
          RowBox[{"a", " ", "b", " ", "lam"}], 
          SuperscriptBox["t", "2"]], "+", 
         FractionBox[
          RowBox[{"a", " ", "c", " ", "lam"}], 
          RowBox[{"2", " ", 
           SuperscriptBox["t", "2"]}]], "+", 
         FractionBox[
          RowBox[{"b", " ", "lam", " ", "s"}], 
          RowBox[{"2", " ", 
           SuperscriptBox["t", "2"]}]]}]},
       {
        RowBox[{
         FractionBox[
          RowBox[{"b", " ", "lam", " ", "r"}], 
          SuperscriptBox["t", "2"]], "+", 
         FractionBox[
          RowBox[{"c", " ", "lam", " ", "r"}], 
          RowBox[{"2", " ", 
           SuperscriptBox["t", "2"]}]]}], 
        RowBox[{
         FractionBox[
          RowBox[{"a", " ", "b", " ", "lam"}], 
          SuperscriptBox["t", "2"]], "+", 
         FractionBox[
          RowBox[{"a", " ", "c", " ", "lam"}], 
          RowBox[{"2", " ", 
           SuperscriptBox["t", "2"]}]], "+", 
         FractionBox[
          RowBox[{"b", " ", "lam", " ", "s"}], 
          RowBox[{"2", " ", 
           SuperscriptBox["t", "2"]}]]}], 
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox["b", "2"], " ", "lam"}], 
          SuperscriptBox["t", "2"]], "+", 
         FractionBox[
          RowBox[{"b", " ", "c", " ", "lam"}], 
          SuperscriptBox["t", "2"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"c", " ", "lam", " ", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"c", " ", "lam", " ", "r"}], 
           RowBox[{"2", " ", 
            SuperscriptBox["t", "2"]}]]}], "-", 
         FractionBox[
          RowBox[{"a", " ", "c", " ", "lam", " ", "r"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"b", " ", "c", " ", "lam", " ", "r"}], 
           RowBox[{"s", " ", 
            SuperscriptBox["t", "2"]}]]}], "-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["c", "2"], " ", "lam", " ", "r"}], 
          RowBox[{"2", " ", "s", " ", 
           SuperscriptBox["t", "2"]}]]}]},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"c", " ", "lam", " ", "r"}], 
           RowBox[{"2", " ", 
            SuperscriptBox["t", "2"]}]]}], "-", 
         FractionBox[
          RowBox[{"a", " ", "c", " ", "lam", " ", "r"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"a", " ", "c", " ", "lam"}], 
           SuperscriptBox["t", "2"]]}], "-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], " ", "c", " ", "lam"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"b", " ", "c", " ", "lam"}], 
           RowBox[{"2", " ", 
            SuperscriptBox["t", "2"]}]]}], "-", 
         FractionBox[
          RowBox[{"a", " ", "b", " ", "c", " ", "lam"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]], "-", 
         FractionBox[
          RowBox[{"a", " ", 
           SuperscriptBox["c", "2"], " ", "lam"}], 
          RowBox[{"2", " ", "s", " ", 
           SuperscriptBox["t", "2"]}]]}]},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"b", " ", "c", " ", "lam", " ", "r"}], 
           RowBox[{"s", " ", 
            SuperscriptBox["t", "2"]}]]}], "-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["c", "2"], " ", "lam", " ", "r"}], 
          RowBox[{"2", " ", "s", " ", 
           SuperscriptBox["t", "2"]}]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"b", " ", "c", " ", "lam"}], 
           RowBox[{"2", " ", 
            SuperscriptBox["t", "2"]}]]}], "-", 
         FractionBox[
          RowBox[{"a", " ", "b", " ", "c", " ", "lam"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]], "-", 
         FractionBox[
          RowBox[{"a", " ", 
           SuperscriptBox["c", "2"], " ", "lam"}], 
          RowBox[{"2", " ", "s", " ", 
           SuperscriptBox["t", "2"]}]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["b", "2"], " ", "c", " ", "lam"}], 
           RowBox[{"s", " ", 
            SuperscriptBox["t", "2"]}]]}], "-", 
         FractionBox[
          RowBox[{"b", " ", 
           SuperscriptBox["c", "2"], " ", "lam"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`lam $CellContext`r^2 $CellContext`t^(-2), \
$CellContext`a $CellContext`lam $CellContext`r $CellContext`t^(-2) + 
      Rational[1, 
         2] $CellContext`lam $CellContext`r $CellContext`s \
$CellContext`t^(-2), $CellContext`b $CellContext`lam $CellContext`r \
$CellContext`t^(-2) + 
      Rational[1, 
         2] $CellContext`c $CellContext`lam $CellContext`r \
$CellContext`t^(-2)}, {$CellContext`a $CellContext`lam $CellContext`r \
$CellContext`t^(-2) + 
      Rational[1, 
         2] $CellContext`lam $CellContext`r $CellContext`s \
$CellContext`t^(-2), $CellContext`a^2 $CellContext`lam $CellContext`t^(-2) + \
$CellContext`a $CellContext`lam $CellContext`s $CellContext`t^(-2), \
$CellContext`a $CellContext`b $CellContext`lam $CellContext`t^(-2) + 
      Rational[1, 
         2] $CellContext`a $CellContext`c $CellContext`lam \
$CellContext`t^(-2) + 
      Rational[1, 
         2] $CellContext`b $CellContext`lam $CellContext`s \
$CellContext`t^(-2)}, {$CellContext`b $CellContext`lam $CellContext`r \
$CellContext`t^(-2) + 
      Rational[1, 
         2] $CellContext`c $CellContext`lam $CellContext`r \
$CellContext`t^(-2), $CellContext`a $CellContext`b $CellContext`lam \
$CellContext`t^(-2) + 
      Rational[1, 
         2] $CellContext`a $CellContext`c $CellContext`lam \
$CellContext`t^(-2) + 
      Rational[1, 
         2] $CellContext`b $CellContext`lam $CellContext`s \
$CellContext`t^(-2), $CellContext`b^2 $CellContext`lam $CellContext`t^(-2) + \
$CellContext`b $CellContext`c $CellContext`lam $CellContext`t^(-2)}}], 
   MatrixForm[{{-$CellContext`c $CellContext`lam $CellContext`r^2 \
$CellContext`s^(-1) $CellContext`t^(-2), 
      Rational[-1, 
         2] $CellContext`c $CellContext`lam $CellContext`r \
$CellContext`t^(-2) - $CellContext`a $CellContext`c $CellContext`lam \
$CellContext`r $CellContext`s^(-1) $CellContext`t^(-2), -$CellContext`b \
$CellContext`c $CellContext`lam $CellContext`r $CellContext`s^(-1) \
$CellContext`t^(-2) + 
      Rational[-1, 
         2] $CellContext`c^2 $CellContext`lam $CellContext`r \
$CellContext`s^(-1) $CellContext`t^(-2)}, {
     Rational[-1, 
         2] $CellContext`c $CellContext`lam $CellContext`r \
$CellContext`t^(-2) - $CellContext`a $CellContext`c $CellContext`lam \
$CellContext`r $CellContext`s^(-1) $CellContext`t^(-2), -$CellContext`a \
$CellContext`c $CellContext`lam $CellContext`t^(-2) - $CellContext`a^2 \
$CellContext`c $CellContext`lam $CellContext`s^(-1) $CellContext`t^(-2), 
      Rational[-1, 
         2] $CellContext`b $CellContext`c $CellContext`lam \
$CellContext`t^(-2) - $CellContext`a $CellContext`b $CellContext`c \
$CellContext`lam $CellContext`s^(-1) $CellContext`t^(-2) + 
      Rational[-1, 
         2] $CellContext`a $CellContext`c^2 $CellContext`lam \
$CellContext`s^(-1) $CellContext`t^(-2)}, {-$CellContext`b $CellContext`c \
$CellContext`lam $CellContext`r $CellContext`s^(-1) $CellContext`t^(-2) + 
      Rational[-1, 
         2] $CellContext`c^2 $CellContext`lam $CellContext`r \
$CellContext`s^(-1) $CellContext`t^(-2), 
      Rational[-1, 
         2] $CellContext`b $CellContext`c $CellContext`lam \
$CellContext`t^(-2) - $CellContext`a $CellContext`b $CellContext`c \
$CellContext`lam $CellContext`s^(-1) $CellContext`t^(-2) + 
      Rational[-1, 
         2] $CellContext`a $CellContext`c^2 $CellContext`lam \
$CellContext`s^(-1) $CellContext`t^(-2), -$CellContext`b^2 $CellContext`c \
$CellContext`lam $CellContext`s^(-1) $CellContext`t^(-2) - $CellContext`b \
$CellContext`c^2 $CellContext`lam $CellContext`s^(-1) $CellContext`t^(-2)}}]],
  
  Editable->False]], "Print",
 CellChangeTimes->{{3.741184876925*^9, 
  3.741184924004429*^9}},ExpressionUUID->"3b4000fe-067f-4cb4-877c-\
10d7b7baf9d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", 
        RowBox[{
         FractionBox["a", "r"], "+", 
         FractionBox["s", 
          RowBox[{"2", " ", "r"}]]}], "0"},
       {
        RowBox[{
         FractionBox["a", "r"], "+", 
         FractionBox["s", 
          RowBox[{"2", " ", "r"}]]}], 
        RowBox[{
         FractionBox[
          SuperscriptBox["a", "2"], 
          SuperscriptBox["r", "2"]], "+", 
         FractionBox[
          RowBox[{"a", " ", "s"}], 
          SuperscriptBox["r", "2"]]}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     1, $CellContext`a/$CellContext`r + 
      Rational[1, 2] $CellContext`r^(-1) $CellContext`s, 
      0}, {$CellContext`a/$CellContext`r + 
      Rational[1, 
         2] $CellContext`r^(-1) $CellContext`s, $CellContext`a^2 \
$CellContext`r^(-2) + $CellContext`a $CellContext`r^(-2) $CellContext`s, 0}, {
     0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.741184876925*^9, 
  3.7411849240072823`*^9}},ExpressionUUID->"dd82a2a0-5077-43f7-9cb6-\
10daa0ae1a88"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", 
        FractionBox["s", 
         RowBox[{"2", " ", "r"}]], "0"},
       {
        FractionBox["s", 
         RowBox[{"2", " ", "r"}]], "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{1, Rational[1, 2] $CellContext`r^(-1) $CellContext`s, 0}, {
     Rational[1, 2] $CellContext`r^(-1) $CellContext`s, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.741184876925*^9, 
  3.7411849240095873`*^9}},ExpressionUUID->"9d5af02b-8d21-4963-b3c0-\
13c67127e845"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", 
        RowBox[{"-", 
         FractionBox["s", 
          RowBox[{"2", " ", "r"}]]}], "0"},
       {
        RowBox[{"-", 
         FractionBox["s", 
          RowBox[{"2", " ", "r"}]]}], "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{1, Rational[-1, 2] $CellContext`r^(-1) $CellContext`s, 0}, {
     Rational[-1, 2] $CellContext`r^(-1) $CellContext`s, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.741184876925*^9, 
  3.7411849240119247`*^9}},ExpressionUUID->"6068428c-d74f-41cc-9057-\
6c679a4eb54e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Orbit", " ", "6", " ", "Calculation"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22", ",", " ", "lam", ",", " ", "r", ",", " ", "s", ",", " ", 
      "t", ",", " ", "a", ",", " ", "b", ",", " ", "c"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "c", ",", " ", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"lam", "/", 
        RowBox[{"t", "^", "2"}]}], " ", "*", " ", "A1"}], " ", "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], " ", "*", 
        RowBox[{"lam", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", 
           RowBox[{"t", "^", "2"}]}], ")"}]}], " ", "*", " ", "A1"}], " ", 
       "+", " ", 
       RowBox[{
        RowBox[{"lam", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", "t"}], ")"}]}], " ", "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Solve", " ", "a"}], "=", "0"}], ",", " ", 
     RowBox[{"lam", " ", "=", " ", 
      RowBox[{
       RowBox[{"t", "^", "2"}], "/", "rs"}]}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", " ", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lam", " ", "=", " ", 
     RowBox[{
      RowBox[{"t", "^", "2"}], "/", 
      RowBox[{"(", 
       RowBox[{"r", "*", "s"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Solve", " ", "c"}], " ", "=", " ", "0"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.733694854704175*^9, 3.733694858680668*^9}, {
   3.741182778965135*^9, 3.7411827792049437`*^9}, 3.7411830937482224`*^9, 
   3.741183823982752*^9, 3.741184013222535*^9, {3.7411849575276003`*^9, 
   3.741185064992985*^9}},ExpressionUUID->"6fe7fc4f-4a3d-48b2-a5eb-\
f07e4d151acc"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "t"},
       {"0", "0", "x"},
       {"t", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["t", "2"], "x"},
       {
        FractionBox["t", "2"], "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, $CellContext`t}, {
     0, 0, $CellContext`x}, {$CellContext`t, $CellContext`x, \
$CellContext`x}}], 
   MatrixForm[{{0, Rational[1, 2] $CellContext`t, $CellContext`x}, {
     Rational[1, 
        2] $CellContext`t, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7336948615416727`*^9, 3.7411828469206333`*^9, {3.7411849781004744`*^9, 
   3.7411850659086742`*^9}},ExpressionUUID->"b954a576-bb1f-4b97-898a-\
16a7d22bf951"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox[
         RowBox[{"lam", " ", "r", " ", "s"}], 
         SuperscriptBox["t", "2"]], 
        FractionBox[
         RowBox[{"c", " ", "lam", " ", "r"}], 
         SuperscriptBox["t", "2"]]},
       {
        FractionBox[
         RowBox[{"lam", " ", "r", " ", "s"}], 
         SuperscriptBox["t", "2"]], 
        FractionBox[
         RowBox[{"2", " ", "a", " ", "lam", " ", "s"}], 
         SuperscriptBox["t", "2"]], 
        RowBox[{
         FractionBox[
          RowBox[{"a", " ", "c", " ", "lam"}], 
          SuperscriptBox["t", "2"]], "+", 
         FractionBox[
          RowBox[{"b", " ", "lam", " ", "s"}], 
          SuperscriptBox["t", "2"]]}]},
       {
        FractionBox[
         RowBox[{"c", " ", "lam", " ", "r"}], 
         SuperscriptBox["t", "2"]], 
        RowBox[{
         FractionBox[
          RowBox[{"a", " ", "c", " ", "lam"}], 
          SuperscriptBox["t", "2"]], "+", 
         FractionBox[
          RowBox[{"b", " ", "lam", " ", "s"}], 
          SuperscriptBox["t", "2"]]}], 
        FractionBox[
         RowBox[{"2", " ", "b", " ", "c", " ", "lam"}], 
         SuperscriptBox["t", "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"c", " ", "lam", " ", "r"}], 
          SuperscriptBox["t", "2"]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["c", "2"], " ", "lam", " ", "r"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}]},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"c", " ", "lam", " ", "r"}], 
          SuperscriptBox["t", "2"]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", "a", " ", "c", " ", "lam"}], 
          SuperscriptBox["t", "2"]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"b", " ", "c", " ", "lam"}], 
           SuperscriptBox["t", "2"]]}], "-", 
         FractionBox[
          RowBox[{"a", " ", 
           SuperscriptBox["c", "2"], " ", "lam"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}]},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["c", "2"], " ", "lam", " ", "r"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"b", " ", "c", " ", "lam"}], 
           SuperscriptBox["t", "2"]]}], "-", 
         FractionBox[
          RowBox[{"a", " ", 
           SuperscriptBox["c", "2"], " ", "lam"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", "b", " ", 
           SuperscriptBox["c", "2"], " ", "lam"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     0, $CellContext`lam $CellContext`r $CellContext`s $CellContext`t^(-2), \
$CellContext`c $CellContext`lam $CellContext`r $CellContext`t^(-2)}, \
{$CellContext`lam $CellContext`r $CellContext`s $CellContext`t^(-2), 
      2 $CellContext`a $CellContext`lam $CellContext`s $CellContext`t^(-2), \
$CellContext`a $CellContext`c $CellContext`lam $CellContext`t^(-2) + \
$CellContext`b $CellContext`lam $CellContext`s $CellContext`t^(-2)}, \
{$CellContext`c $CellContext`lam $CellContext`r $CellContext`t^(-2), \
$CellContext`a $CellContext`c $CellContext`lam $CellContext`t^(-2) + \
$CellContext`b $CellContext`lam $CellContext`s $CellContext`t^(-2), 
      2 $CellContext`b $CellContext`c $CellContext`lam $CellContext`t^(-2)}}], 
   MatrixForm[{{
     0, -$CellContext`c $CellContext`lam $CellContext`r $CellContext`t^(-2), \
-$CellContext`c^2 $CellContext`lam $CellContext`r $CellContext`s^(-1) \
$CellContext`t^(-2)}, {-$CellContext`c $CellContext`lam $CellContext`r \
$CellContext`t^(-2), (-2) $CellContext`a $CellContext`c $CellContext`lam \
$CellContext`t^(-2), -$CellContext`b $CellContext`c $CellContext`lam \
$CellContext`t^(-2) - $CellContext`a $CellContext`c^2 $CellContext`lam \
$CellContext`s^(-1) $CellContext`t^(-2)}, {-$CellContext`c^2 $CellContext`lam \
$CellContext`r $CellContext`s^(-1) $CellContext`t^(-2), -$CellContext`b \
$CellContext`c $CellContext`lam $CellContext`t^(-2) - $CellContext`a \
$CellContext`c^2 $CellContext`lam $CellContext`s^(-1) $CellContext`t^(-2), \
(-2) $CellContext`b $CellContext`c^2 $CellContext`lam $CellContext`s^(-1) \
$CellContext`t^(-2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7336948615416727`*^9, 3.7411828469206333`*^9, {3.7411849781004744`*^9, 
   3.741185065914568*^9}},ExpressionUUID->"e48d22dd-df46-43f1-8d9a-\
0b5eed0f5f04"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1", 
        FractionBox["c", "s"]},
       {"1", "0", 
        FractionBox["b", "r"]},
       {
        FractionBox["c", "s"], 
        FractionBox["b", "r"], 
        FractionBox[
         RowBox[{"2", " ", "b", " ", "c"}], 
         RowBox[{"r", " ", "s"}]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{"-", 
         FractionBox["c", "s"]}], 
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["c", "2"], 
          SuperscriptBox["s", "2"]]}]},
       {
        RowBox[{"-", 
         FractionBox["c", "s"]}], "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"b", " ", "c"}], 
          RowBox[{"r", " ", "s"}]]}]},
       {
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["c", "2"], 
          SuperscriptBox["s", "2"]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"b", " ", "c"}], 
          RowBox[{"r", " ", "s"}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", "b", " ", 
           SuperscriptBox["c", "2"]}], 
          RowBox[{"r", " ", 
           SuperscriptBox["s", "2"]}]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 1, $CellContext`c/$CellContext`s}, {
     1, 0, $CellContext`b/$CellContext`r}, {$CellContext`c/$CellContext`s, \
$CellContext`b/$CellContext`r, 
      2 $CellContext`b $CellContext`c $CellContext`r^(-1)/$CellContext`s}}], 
   MatrixForm[{{
     0, -$CellContext`c/$CellContext`s, -$CellContext`c^2 \
$CellContext`s^(-2)}, {-$CellContext`c/$CellContext`s, 
      0, -$CellContext`b $CellContext`c $CellContext`r^(-1)/$CellContext`s}, \
{-$CellContext`c^2 $CellContext`s^(-2), -$CellContext`b $CellContext`c \
$CellContext`r^(-1)/$CellContext`s, (-2) $CellContext`b $CellContext`c^2 \
$CellContext`r^(-1) $CellContext`s^(-2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7336948615416727`*^9, 3.7411828469206333`*^9, {3.7411849781004744`*^9, 
   3.741185065918497*^9}},ExpressionUUID->"f1bbc122-e127-4fec-9ade-\
5217e13f30ad"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1", "0"},
       {"1", "0", 
        FractionBox["b", "r"]},
       {"0", 
        FractionBox["b", "r"], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 1, 0}, {1, 0, $CellContext`b/$CellContext`r}, {
     0, $CellContext`b/$CellContext`r, 0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7336948615416727`*^9, 3.7411828469206333`*^9, {3.7411849781004744`*^9, 
   3.7411850659211693`*^9}},ExpressionUUID->"a9f18783-1cf1-44ac-969e-\
d88e198afd91"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Orbit", " ", "7", " ", "calculation"}], " ", "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22", ",", " ", "lam", ",", " ", "r", ",", " ", "s", ",", " ", 
      "t", ",", " ", "a", ",", " ", "b", ",", " ", "c"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "c", ",", " ", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"lam", "/", 
        RowBox[{"t", "^", "2"}]}], " ", "*", " ", "A1"}], " ", "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], " ", "*", 
        RowBox[{"lam", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", 
           RowBox[{"t", "^", "2"}]}], ")"}]}], " ", "*", " ", "A1"}], " ", 
       "+", " ", 
       RowBox[{
        RowBox[{"lam", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", "t"}], ")"}]}], " ", "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Solve", " ", "lam"}], " ", "=", " ", 
      RowBox[{"s", "*", 
       RowBox[{"t", "/", 
        RowBox[{"r", "^", "2"}]}]}]}], ",", " ", 
     RowBox[{"a", "=", " ", "0"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lam", " ", "=", " ", 
     RowBox[{"s", "*", 
      RowBox[{"t", "/", 
       RowBox[{"r", "^", "2"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Solve", " ", "t"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"s", "^", "2"}], "/", "r"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"t", " ", "=", " ", 
     RowBox[{
      RowBox[{"s", "^", "2"}], "/", "r"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Solve", " ", "c"}], " ", "=", " ", "0"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.733695568907744*^9, 3.733695593486348*^9}, {
   3.741182789365123*^9, 3.741182789564803*^9}, 3.741183098748617*^9, 
   3.7411838296069603`*^9, 3.741184019373476*^9, {3.741185146350369*^9, 
   3.741185201277277*^9}, {3.741185244405702*^9, 
   3.741185289382083*^9}},ExpressionUUID->"b23feb67-8910-46eb-959e-\
9aaa5f83f572"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "t"},
       {"0", "0", "x"},
       {"t", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["t", "2"], "x"},
       {
        FractionBox["t", "2"], "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, $CellContext`t}, {
     0, 0, $CellContext`x}, {$CellContext`t, $CellContext`x, \
$CellContext`x}}], 
   MatrixForm[{{0, Rational[1, 2] $CellContext`t, $CellContext`x}, {
     Rational[1, 
        2] $CellContext`t, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.73369559766706*^9, 3.7411828532496843`*^9, 3.741185156555217*^9, {
   3.7411851937460403`*^9, 3.741185201765973*^9}, {3.741185265307918*^9, 
   3.741185290220356*^9}},ExpressionUUID->"133b3521-292d-4639-b779-\
0837719a7a4d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox[
         RowBox[{"lam", " ", "r", " ", "s"}], 
         SuperscriptBox["t", "2"]], 
        FractionBox[
         RowBox[{"c", " ", "lam", " ", "r"}], 
         SuperscriptBox["t", "2"]]},
       {
        FractionBox[
         RowBox[{"lam", " ", "r", " ", "s"}], 
         SuperscriptBox["t", "2"]], 
        FractionBox[
         RowBox[{"2", " ", "a", " ", "lam", " ", "s"}], 
         SuperscriptBox["t", "2"]], 
        RowBox[{
         FractionBox[
          RowBox[{"a", " ", "c", " ", "lam"}], 
          SuperscriptBox["t", "2"]], "+", 
         FractionBox[
          RowBox[{"b", " ", "lam", " ", "s"}], 
          SuperscriptBox["t", "2"]]}]},
       {
        FractionBox[
         RowBox[{"c", " ", "lam", " ", "r"}], 
         SuperscriptBox["t", "2"]], 
        RowBox[{
         FractionBox[
          RowBox[{"a", " ", "c", " ", "lam"}], 
          SuperscriptBox["t", "2"]], "+", 
         FractionBox[
          RowBox[{"b", " ", "lam", " ", "s"}], 
          SuperscriptBox["t", "2"]]}], 
        FractionBox[
         RowBox[{"2", " ", "b", " ", "c", " ", "lam"}], 
         SuperscriptBox["t", "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         RowBox[{"lam", " ", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{"s", " ", "t"}]], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"c", " ", "lam", " ", "r"}], 
           SuperscriptBox["t", "2"]]}], "+", 
         FractionBox[
          RowBox[{"a", " ", "lam", " ", "r"}], 
          RowBox[{"s", " ", "t"}]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["c", "2"], " ", "lam", " ", "r"}], 
           RowBox[{"s", " ", 
            SuperscriptBox["t", "2"]}]]}], "+", 
         FractionBox[
          RowBox[{"b", " ", "lam", " ", "r"}], 
          RowBox[{"s", " ", "t"}]]}]},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"c", " ", "lam", " ", "r"}], 
           SuperscriptBox["t", "2"]]}], "+", 
         FractionBox[
          RowBox[{"a", " ", "lam", " ", "r"}], 
          RowBox[{"s", " ", "t"}]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"2", " ", "a", " ", "c", " ", "lam"}], 
           SuperscriptBox["t", "2"]]}], "+", 
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], " ", "lam"}], 
          RowBox[{"s", " ", "t"}]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"b", " ", "c", " ", "lam"}], 
           SuperscriptBox["t", "2"]]}], "-", 
         FractionBox[
          RowBox[{"a", " ", 
           SuperscriptBox["c", "2"], " ", "lam"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]], "+", 
         FractionBox[
          RowBox[{"a", " ", "b", " ", "lam"}], 
          RowBox[{"s", " ", "t"}]]}]},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["c", "2"], " ", "lam", " ", "r"}], 
           RowBox[{"s", " ", 
            SuperscriptBox["t", "2"]}]]}], "+", 
         FractionBox[
          RowBox[{"b", " ", "lam", " ", "r"}], 
          RowBox[{"s", " ", "t"}]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"b", " ", "c", " ", "lam"}], 
           SuperscriptBox["t", "2"]]}], "-", 
         FractionBox[
          RowBox[{"a", " ", 
           SuperscriptBox["c", "2"], " ", "lam"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]], "+", 
         FractionBox[
          RowBox[{"a", " ", "b", " ", "lam"}], 
          RowBox[{"s", " ", "t"}]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"2", " ", "b", " ", 
            SuperscriptBox["c", "2"], " ", "lam"}], 
           RowBox[{"s", " ", 
            SuperscriptBox["t", "2"]}]]}], "+", 
         FractionBox[
          RowBox[{
           SuperscriptBox["b", "2"], " ", "lam"}], 
          RowBox[{"s", " ", "t"}]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     0, $CellContext`lam $CellContext`r $CellContext`s $CellContext`t^(-2), \
$CellContext`c $CellContext`lam $CellContext`r $CellContext`t^(-2)}, \
{$CellContext`lam $CellContext`r $CellContext`s $CellContext`t^(-2), 
      2 $CellContext`a $CellContext`lam $CellContext`s $CellContext`t^(-2), \
$CellContext`a $CellContext`c $CellContext`lam $CellContext`t^(-2) + \
$CellContext`b $CellContext`lam $CellContext`s $CellContext`t^(-2)}, \
{$CellContext`c $CellContext`lam $CellContext`r $CellContext`t^(-2), \
$CellContext`a $CellContext`c $CellContext`lam $CellContext`t^(-2) + \
$CellContext`b $CellContext`lam $CellContext`s $CellContext`t^(-2), 
      2 $CellContext`b $CellContext`c $CellContext`lam $CellContext`t^(-2)}}], 
   MatrixForm[{{$CellContext`lam $CellContext`r^2 \
$CellContext`s^(-1)/$CellContext`t, -$CellContext`c $CellContext`lam \
$CellContext`r $CellContext`t^(-2) + $CellContext`a $CellContext`lam \
$CellContext`r $CellContext`s^(-1)/$CellContext`t, -$CellContext`c^2 \
$CellContext`lam $CellContext`r $CellContext`s^(-1) $CellContext`t^(-2) + \
$CellContext`b $CellContext`lam $CellContext`r \
$CellContext`s^(-1)/$CellContext`t}, {-$CellContext`c $CellContext`lam \
$CellContext`r $CellContext`t^(-2) + $CellContext`a $CellContext`lam \
$CellContext`r $CellContext`s^(-1)/$CellContext`t, (-2) $CellContext`a \
$CellContext`c $CellContext`lam $CellContext`t^(-2) + $CellContext`a^2 \
$CellContext`lam $CellContext`s^(-1)/$CellContext`t, -$CellContext`b \
$CellContext`c $CellContext`lam $CellContext`t^(-2) - $CellContext`a \
$CellContext`c^2 $CellContext`lam $CellContext`s^(-1) $CellContext`t^(-2) + \
$CellContext`a $CellContext`b $CellContext`lam \
$CellContext`s^(-1)/$CellContext`t}, {-$CellContext`c^2 $CellContext`lam \
$CellContext`r $CellContext`s^(-1) $CellContext`t^(-2) + $CellContext`b \
$CellContext`lam $CellContext`r $CellContext`s^(-1)/$CellContext`t, \
-$CellContext`b $CellContext`c $CellContext`lam $CellContext`t^(-2) - \
$CellContext`a $CellContext`c^2 $CellContext`lam $CellContext`s^(-1) \
$CellContext`t^(-2) + $CellContext`a $CellContext`b $CellContext`lam \
$CellContext`s^(-1)/$CellContext`t, (-2) $CellContext`b $CellContext`c^2 \
$CellContext`lam $CellContext`s^(-1) $CellContext`t^(-2) + $CellContext`b^2 \
$CellContext`lam $CellContext`s^(-1)/$CellContext`t}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.73369559766706*^9, 3.7411828532496843`*^9, 3.741185156555217*^9, {
   3.7411851937460403`*^9, 3.741185201765973*^9}, {3.741185265307918*^9, 
   3.741185290227605*^9}},ExpressionUUID->"fb040db1-081b-4f8f-9697-\
f7c3f8134222"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox[
         SuperscriptBox["s", "2"], 
         RowBox[{"r", " ", "t"}]], 
        FractionBox[
         RowBox[{"c", " ", "s"}], 
         RowBox[{"r", " ", "t"}]]},
       {
        FractionBox[
         SuperscriptBox["s", "2"], 
         RowBox[{"r", " ", "t"}]], "0", 
        FractionBox[
         RowBox[{"b", " ", 
          SuperscriptBox["s", "2"]}], 
         RowBox[{
          SuperscriptBox["r", "2"], " ", "t"}]]},
       {
        FractionBox[
         RowBox[{"c", " ", "s"}], 
         RowBox[{"r", " ", "t"}]], 
        FractionBox[
         RowBox[{"b", " ", 
          SuperscriptBox["s", "2"]}], 
         RowBox[{
          SuperscriptBox["r", "2"], " ", "t"}]], 
        FractionBox[
         RowBox[{"2", " ", "b", " ", "c", " ", "s"}], 
         RowBox[{
          SuperscriptBox["r", "2"], " ", "t"}]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"c", " ", "s"}], 
          RowBox[{"r", " ", "t"}]]}], 
        RowBox[{
         FractionBox["b", "r"], "-", 
         FractionBox[
          SuperscriptBox["c", "2"], 
          RowBox[{"r", " ", "t"}]]}]},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"c", " ", "s"}], 
          RowBox[{"r", " ", "t"}]]}], "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"b", " ", "c", " ", "s"}], 
          RowBox[{
           SuperscriptBox["r", "2"], " ", "t"}]]}]},
       {
        RowBox[{
         FractionBox["b", "r"], "-", 
         FractionBox[
          SuperscriptBox["c", "2"], 
          RowBox[{"r", " ", "t"}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"b", " ", "c", " ", "s"}], 
          RowBox[{
           SuperscriptBox["r", "2"], " ", "t"}]]}], 
        RowBox[{
         FractionBox[
          SuperscriptBox["b", "2"], 
          SuperscriptBox["r", "2"]], "-", 
         FractionBox[
          RowBox[{"2", " ", "b", " ", 
           SuperscriptBox["c", "2"]}], 
          RowBox[{
           SuperscriptBox["r", "2"], " ", "t"}]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     0, $CellContext`r^(-1) $CellContext`s^2/$CellContext`t, $CellContext`c \
$CellContext`r^(-1) $CellContext`s/$CellContext`t}, {$CellContext`r^(-1) \
$CellContext`s^2/$CellContext`t, 
      0, $CellContext`b $CellContext`r^(-2) $CellContext`s^2/$CellContext`t}, \
{$CellContext`c $CellContext`r^(-1) $CellContext`s/$CellContext`t, \
$CellContext`b $CellContext`r^(-2) $CellContext`s^2/$CellContext`t, 
      2 $CellContext`b $CellContext`c $CellContext`r^(-2) \
$CellContext`s/$CellContext`t}}], 
   MatrixForm[{{
     1, -$CellContext`c $CellContext`r^(-1) $CellContext`s/$CellContext`t, \
$CellContext`b/$CellContext`r - $CellContext`c^2 \
$CellContext`r^(-1)/$CellContext`t}, {-$CellContext`c $CellContext`r^(-1) \
$CellContext`s/$CellContext`t, 
      0, -$CellContext`b $CellContext`c $CellContext`r^(-2) \
$CellContext`s/$CellContext`t}, {$CellContext`b/$CellContext`r - \
$CellContext`c^2 $CellContext`r^(-1)/$CellContext`t, -$CellContext`b \
$CellContext`c $CellContext`r^(-2) $CellContext`s/$CellContext`t, \
$CellContext`b^2 $CellContext`r^(-2) - 
      2 $CellContext`b $CellContext`c^2 $CellContext`r^(-2)/$CellContext`t}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.73369559766706*^9, 3.7411828532496843`*^9, 3.741185156555217*^9, {
   3.7411851937460403`*^9, 3.741185201765973*^9}, {3.741185265307918*^9, 
   3.74118529023247*^9}},ExpressionUUID->"ede80ef3-d199-40ec-b52b-\
0bd958153c28"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1", 
        FractionBox["c", "s"]},
       {"1", "0", 
        FractionBox["b", "r"]},
       {
        FractionBox["c", "s"], 
        FractionBox["b", "r"], 
        FractionBox[
         RowBox[{"2", " ", "b", " ", "c"}], 
         RowBox[{"r", " ", "s"}]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", 
        RowBox[{"-", 
         FractionBox["c", "s"]}], 
        RowBox[{
         FractionBox["b", "r"], "-", 
         FractionBox[
          SuperscriptBox["c", "2"], 
          SuperscriptBox["s", "2"]]}]},
       {
        RowBox[{"-", 
         FractionBox["c", "s"]}], "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"b", " ", "c"}], 
          RowBox[{"r", " ", "s"}]]}]},
       {
        RowBox[{
         FractionBox["b", "r"], "-", 
         FractionBox[
          SuperscriptBox["c", "2"], 
          SuperscriptBox["s", "2"]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"b", " ", "c"}], 
          RowBox[{"r", " ", "s"}]]}], 
        RowBox[{
         FractionBox[
          SuperscriptBox["b", "2"], 
          SuperscriptBox["r", "2"]], "-", 
         FractionBox[
          RowBox[{"2", " ", "b", " ", 
           SuperscriptBox["c", "2"]}], 
          RowBox[{"r", " ", 
           SuperscriptBox["s", "2"]}]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 1, $CellContext`c/$CellContext`s}, {
     1, 0, $CellContext`b/$CellContext`r}, {$CellContext`c/$CellContext`s, \
$CellContext`b/$CellContext`r, 
      2 $CellContext`b $CellContext`c $CellContext`r^(-1)/$CellContext`s}}], 
   MatrixForm[{{
     1, -$CellContext`c/$CellContext`s, $CellContext`b/$CellContext`r - \
$CellContext`c^2 $CellContext`s^(-2)}, {-$CellContext`c/$CellContext`s, 
      0, -$CellContext`b $CellContext`c $CellContext`r^(-1)/$CellContext`s}, \
{$CellContext`b/$CellContext`r - $CellContext`c^2 $CellContext`s^(-2), \
-$CellContext`b $CellContext`c $CellContext`r^(-1)/$CellContext`s, \
$CellContext`b^2 $CellContext`r^(-2) - 
      2 $CellContext`b $CellContext`c^2 $CellContext`r^(-1) \
$CellContext`s^(-2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.73369559766706*^9, 3.7411828532496843`*^9, 3.741185156555217*^9, {
   3.7411851937460403`*^9, 3.741185201765973*^9}, {3.741185265307918*^9, 
   3.741185290236341*^9}},ExpressionUUID->"86351963-4862-49f7-8f9e-\
daff3611b318"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1", "0"},
       {"1", "0", 
        FractionBox["b", "r"]},
       {"0", 
        FractionBox["b", "r"], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", 
        FractionBox["b", "r"]},
       {"0", "0", "0"},
       {
        FractionBox["b", "r"], "0", 
        FractionBox[
         SuperscriptBox["b", "2"], 
         SuperscriptBox["r", "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 1, 0}, {1, 0, $CellContext`b/$CellContext`r}, {
     0, $CellContext`b/$CellContext`r, 0}}], 
   MatrixForm[{{1, 0, $CellContext`b/$CellContext`r}, {0, 0, 
     0}, {$CellContext`b/$CellContext`r, 
      0, $CellContext`b^2 $CellContext`r^(-2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.73369559766706*^9, 3.7411828532496843`*^9, 3.741185156555217*^9, {
   3.7411851937460403`*^9, 3.741185201765973*^9}, {3.741185265307918*^9, 
   3.74118529023912*^9}},ExpressionUUID->"f815451d-c37b-429b-a0ca-\
9ebbd1e3a697"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Orbit", " ", "8", " ", "calculation"}], " ", "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22", ",", " ", "lam", ",", " ", "r", ",", " ", "s", ",", " ", 
      "t", ",", " ", "a", ",", " ", "b", ",", " ", "c"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "ell"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "c", ",", " ", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"lam", "/", 
        RowBox[{"t", "^", "2"}]}], " ", "*", " ", "A1"}], " ", "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], " ", "*", 
        RowBox[{"lam", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", 
           RowBox[{"t", "^", "2"}]}], ")"}]}], " ", "*", " ", "A1"}], " ", 
       "+", " ", 
       RowBox[{
        RowBox[{"lam", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", "t"}], ")"}]}], " ", "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Solve", " ", "a"}], "=", " ", 
      RowBox[{"b", " ", "=", " ", 
       RowBox[{"c", " ", "=", " ", "0"}]}]}], ",", " ", 
     RowBox[{"lam", " ", "=", " ", 
      RowBox[{
       RowBox[{"t", "^", "2"}], "/", 
       RowBox[{"r", "^", "2"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lam", " ", "=", " ", 
     RowBox[{
      RowBox[{"t", "^", "2"}], "/", 
      RowBox[{"r", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"This", " ", "obtains", " ", "s"}], "=", " ", 
     RowBox[{"pm", " ", "r"}]}], " ", "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.733695746770568*^9, 3.733695761778666*^9}, {
   3.741182799132964*^9, 3.741182799436805*^9}, 3.741183104532578*^9, 
   3.7411838362862597`*^9, 3.741184025461116*^9, {3.7411853336129*^9, 
   3.741185420163589*^9}},ExpressionUUID->"e659b6b1-47e4-4521-a177-\
18d933139978"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "t"},
       {"0", "0", "x"},
       {"t", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["t", "2"], "x"},
       {
        FractionBox["t", "2"], "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, $CellContext`t}, {
     0, 0, $CellContext`x}, {$CellContext`t, $CellContext`x, \
$CellContext`x}}], 
   MatrixForm[{{0, Rational[1, 2] $CellContext`t, $CellContext`x}, {
     Rational[1, 
        2] $CellContext`t, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7336957623426123`*^9, 3.7411828592543592`*^9, 
  3.741185392213722*^9, 
  3.7411854227565527`*^9},ExpressionUUID->"e3a1a197-aebf-4f84-becc-\
8291a1434b7b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         RowBox[{"lam", " ", 
          SuperscriptBox["r", "2"]}], 
         SuperscriptBox["t", "2"]], 
        FractionBox[
         RowBox[{"a", " ", "lam", " ", "r"}], 
         SuperscriptBox["t", "2"]], 
        FractionBox[
         RowBox[{"b", " ", "lam", " ", "r"}], 
         SuperscriptBox["t", "2"]]},
       {
        FractionBox[
         RowBox[{"a", " ", "lam", " ", "r"}], 
         SuperscriptBox["t", "2"]], 
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], " ", "lam"}], 
          SuperscriptBox["t", "2"]], "-", 
         FractionBox[
          RowBox[{"ell", " ", "lam", " ", 
           SuperscriptBox["s", "2"]}], 
          SuperscriptBox["t", "2"]]}], 
        RowBox[{
         FractionBox[
          RowBox[{"a", " ", "b", " ", "lam"}], 
          SuperscriptBox["t", "2"]], "-", 
         FractionBox[
          RowBox[{"c", " ", "ell", " ", "lam", " ", "s"}], 
          SuperscriptBox["t", "2"]]}]},
       {
        FractionBox[
         RowBox[{"b", " ", "lam", " ", "r"}], 
         SuperscriptBox["t", "2"]], 
        RowBox[{
         FractionBox[
          RowBox[{"a", " ", "b", " ", "lam"}], 
          SuperscriptBox["t", "2"]], "-", 
         FractionBox[
          RowBox[{"c", " ", "ell", " ", "lam", " ", "s"}], 
          SuperscriptBox["t", "2"]]}], 
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox["b", "2"], " ", "lam"}], 
          SuperscriptBox["t", "2"]], "-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["c", "2"], " ", "ell", " ", "lam"}], 
          SuperscriptBox["t", "2"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"c", " ", "lam", " ", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"a", " ", "c", " ", "lam", " ", "r"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"b", " ", "c", " ", "lam", " ", "r"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}]},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"a", " ", "c", " ", "lam", " ", "r"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["a", "2"], " ", "c", " ", "lam"}], 
           RowBox[{"s", " ", 
            SuperscriptBox["t", "2"]}]]}], "+", 
         FractionBox[
          RowBox[{"c", " ", "ell", " ", "lam", " ", "s"}], 
          SuperscriptBox["t", "2"]]}], 
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox["c", "2"], " ", "ell", " ", "lam"}], 
          SuperscriptBox["t", "2"]], "-", 
         FractionBox[
          RowBox[{"a", " ", "b", " ", "c", " ", "lam"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}]},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"b", " ", "c", " ", "lam", " ", "r"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}], 
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox["c", "2"], " ", "ell", " ", "lam"}], 
          SuperscriptBox["t", "2"]], "-", 
         FractionBox[
          RowBox[{"a", " ", "b", " ", "c", " ", "lam"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["b", "2"], " ", "c", " ", "lam"}], 
           RowBox[{"s", " ", 
            SuperscriptBox["t", "2"]}]]}], "+", 
         FractionBox[
          RowBox[{
           SuperscriptBox["c", "3"], " ", "ell", " ", "lam"}], 
          RowBox[{"s", " ", 
           SuperscriptBox["t", "2"]}]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`lam $CellContext`r^2 $CellContext`t^(-2), \
$CellContext`a $CellContext`lam $CellContext`r $CellContext`t^(-2), \
$CellContext`b $CellContext`lam $CellContext`r $CellContext`t^(-2)}, \
{$CellContext`a $CellContext`lam $CellContext`r $CellContext`t^(-2), \
$CellContext`a^2 $CellContext`lam $CellContext`t^(-2) - $CellContext`ell \
$CellContext`lam $CellContext`s^2 $CellContext`t^(-2), $CellContext`a \
$CellContext`b $CellContext`lam $CellContext`t^(-2) - $CellContext`c \
$CellContext`ell $CellContext`lam $CellContext`s $CellContext`t^(-2)}, \
{$CellContext`b $CellContext`lam $CellContext`r $CellContext`t^(-2), \
$CellContext`a $CellContext`b $CellContext`lam $CellContext`t^(-2) - \
$CellContext`c $CellContext`ell $CellContext`lam $CellContext`s \
$CellContext`t^(-2), $CellContext`b^2 $CellContext`lam $CellContext`t^(-2) - \
$CellContext`c^2 $CellContext`ell $CellContext`lam $CellContext`t^(-2)}}], 
   MatrixForm[{{-$CellContext`c $CellContext`lam $CellContext`r^2 \
$CellContext`s^(-1) $CellContext`t^(-2), -$CellContext`a $CellContext`c \
$CellContext`lam $CellContext`r $CellContext`s^(-1) $CellContext`t^(-2), \
-$CellContext`b $CellContext`c $CellContext`lam $CellContext`r \
$CellContext`s^(-1) $CellContext`t^(-2)}, {-$CellContext`a $CellContext`c \
$CellContext`lam $CellContext`r $CellContext`s^(-1) $CellContext`t^(-2), \
-$CellContext`a^2 $CellContext`c $CellContext`lam $CellContext`s^(-1) \
$CellContext`t^(-2) + $CellContext`c $CellContext`ell $CellContext`lam \
$CellContext`s $CellContext`t^(-2), $CellContext`c^2 $CellContext`ell \
$CellContext`lam $CellContext`t^(-2) - $CellContext`a $CellContext`b \
$CellContext`c $CellContext`lam $CellContext`s^(-1) $CellContext`t^(-2)}, \
{-$CellContext`b $CellContext`c $CellContext`lam $CellContext`r \
$CellContext`s^(-1) $CellContext`t^(-2), $CellContext`c^2 $CellContext`ell \
$CellContext`lam $CellContext`t^(-2) - $CellContext`a $CellContext`b \
$CellContext`c $CellContext`lam $CellContext`s^(-1) $CellContext`t^(-2), \
-$CellContext`b^2 $CellContext`c $CellContext`lam $CellContext`s^(-1) \
$CellContext`t^(-2) + $CellContext`c^3 $CellContext`ell $CellContext`lam \
$CellContext`s^(-1) $CellContext`t^(-2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7336957623426123`*^9, 3.7411828592543592`*^9, 
  3.741185392213722*^9, 
  3.7411854227616167`*^9},ExpressionUUID->"76d368fc-47d7-4bc8-bc5c-\
19f7863f0b54"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0"},
       {"0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"ell", " ", 
           SuperscriptBox["s", "2"]}], 
          SuperscriptBox["r", "2"]]}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{1, 0, 0}, {
     0, -$CellContext`ell $CellContext`r^(-2) $CellContext`s^2, 0}, {0, 0, 
     0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7336957623426123`*^9, 3.7411828592543592`*^9, 
  3.741185392213722*^9, 
  3.7411854227636137`*^9},ExpressionUUID->"339f521b-80a3-437e-b03a-\
25bb831dea62"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Orbit", " ", "9", " ", "calculation"}], " ", "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22", ",", " ", "lam", ",", " ", "r", ",", " ", "s", ",", " ", 
      "t", ",", " ", "a", ",", " ", "b", ",", " ", "c"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "c", ",", " ", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"lam", "/", 
        RowBox[{"t", "^", "2"}]}], " ", "*", " ", "A1"}], " ", "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], " ", "*", 
        RowBox[{"lam", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", 
           RowBox[{"t", "^", "2"}]}], ")"}]}], " ", "*", " ", "A1"}], " ", 
       "+", " ", 
       RowBox[{
        RowBox[{"lam", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", "t"}], ")"}]}], " ", "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Solve", " ", "t"}], " ", "=", " ", 
     RowBox[{"r", " ", "*", "lam"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"t", " ", "=", " ", 
     RowBox[{"r", "*", "lam"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.733695997728838*^9, 3.733696005720743*^9}, {
   3.7411828093569593`*^9, 3.741182809548739*^9}, 3.7411831100048113`*^9, 
   3.741183842822421*^9, 3.741184033621138*^9, {3.741185452339261*^9, 
   3.741185512412518*^9}},ExpressionUUID->"305ddbb1-2cf2-462a-abef-\
c0ae9ddcc410"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "t"},
       {"0", "0", "x"},
       {"t", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["t", "2"], "x"},
       {
        FractionBox["t", "2"], "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, $CellContext`t}, {
     0, 0, $CellContext`x}, {$CellContext`t, $CellContext`x, \
$CellContext`x}}], 
   MatrixForm[{{0, Rational[1, 2] $CellContext`t, $CellContext`x}, {
     Rational[1, 
        2] $CellContext`t, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733696008316361*^9, 3.7411828662259827`*^9, 
  3.7411854538233128`*^9, 
  3.7411854984563103`*^9},ExpressionUUID->"1d2e9f84-8f31-4390-80e3-\
61b4168f8e22"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        FractionBox[
         RowBox[{"lam", " ", "r"}], "t"]},
       {"0", "0", 
        FractionBox[
         RowBox[{"a", " ", "lam"}], "t"]},
       {
        FractionBox[
         RowBox[{"lam", " ", "r"}], "t"], 
        FractionBox[
         RowBox[{"a", " ", "lam"}], "t"], 
        FractionBox[
         RowBox[{"2", " ", "b", " ", "lam"}], "t"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"c", " ", "lam", " ", "r"}], 
          RowBox[{"s", " ", "t"}]]}]},
       {"0", "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"a", " ", "c", " ", "lam"}], 
          RowBox[{"s", " ", "t"}]]}]},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"c", " ", "lam", " ", "r"}], 
          RowBox[{"s", " ", "t"}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"a", " ", "c", " ", "lam"}], 
          RowBox[{"s", " ", "t"}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", "b", " ", "c", " ", "lam"}], 
          RowBox[{"s", " ", "t"}]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, $CellContext`lam $CellContext`r/$CellContext`t}, {
     0, 0, $CellContext`a $CellContext`lam/$CellContext`t}, {$CellContext`lam \
$CellContext`r/$CellContext`t, $CellContext`a $CellContext`lam/$CellContext`t,
       2 $CellContext`b $CellContext`lam/$CellContext`t}}], 
   MatrixForm[{{
     0, 0, -$CellContext`c $CellContext`lam $CellContext`r \
$CellContext`s^(-1)/$CellContext`t}, {
     0, 0, -$CellContext`a $CellContext`c $CellContext`lam \
$CellContext`s^(-1)/$CellContext`t}, {-$CellContext`c $CellContext`lam \
$CellContext`r $CellContext`s^(-1)/$CellContext`t, -$CellContext`a \
$CellContext`c $CellContext`lam $CellContext`s^(-1)/$CellContext`t, (-2) \
$CellContext`b $CellContext`c $CellContext`lam \
$CellContext`s^(-1)/$CellContext`t}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733696008316361*^9, 3.7411828662259827`*^9, 
  3.7411854538233128`*^9, 
  3.74118549845984*^9},ExpressionUUID->"b025bce5-0b58-49de-b8aa-4ff8e9c52f2f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1"},
       {"0", "0", 
        FractionBox["a", "r"]},
       {"1", 
        FractionBox["a", "r"], 
        FractionBox[
         RowBox[{"2", " ", "b"}], "r"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{"-", 
         FractionBox["c", "s"]}]},
       {"0", "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"a", " ", "c"}], 
          RowBox[{"r", " ", "s"}]]}]},
       {
        RowBox[{"-", 
         FractionBox["c", "s"]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"a", " ", "c"}], 
          RowBox[{"r", " ", "s"}]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", "b", " ", "c"}], 
          RowBox[{"r", " ", "s"}]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 1}, {0, 0, $CellContext`a/$CellContext`r}, {
     1, $CellContext`a/$CellContext`r, 2 $CellContext`b/$CellContext`r}}], 
   MatrixForm[{{0, 0, -$CellContext`c/$CellContext`s}, {
     0, 0, -$CellContext`a $CellContext`c \
$CellContext`r^(-1)/$CellContext`s}, {-$CellContext`c/$CellContext`s, \
-$CellContext`a $CellContext`c $CellContext`r^(-1)/$CellContext`s, (-2) \
$CellContext`b $CellContext`c $CellContext`r^(-1)/$CellContext`s}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733696008316361*^9, 3.7411828662259827`*^9, 
  3.7411854538233128`*^9, 
  3.7411854984625597`*^9},ExpressionUUID->"f1165bae-02bb-416f-8e29-\
2a407a57b1e1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Orbit", " ", "10", " ", "calculation"}], " ", "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22", ",", " ", "lam", ",", " ", "r", ",", " ", "s", ",", " ", 
      "t", ",", " ", "a", ",", " ", "b", ",", " ", "c"}], "]"}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "s", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "c", ",", " ", "t"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"lam", "/", 
        RowBox[{"t", "^", "2"}]}], " ", "*", " ", "A1"}], " ", "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], " ", "*", 
        RowBox[{"lam", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", 
           RowBox[{"t", "^", "2"}]}], ")"}]}], " ", "*", " ", "A1"}], " ", 
       "+", " ", 
       RowBox[{
        RowBox[{"lam", "/", 
         RowBox[{"(", 
          RowBox[{"s", "*", "t"}], ")"}]}], " ", "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Solve", " ", "lam"}], " ", "=", " ", 
      RowBox[{"s", "*", 
       RowBox[{"t", "/", 
        RowBox[{"r", "^", "2"}]}]}]}], ",", " ", 
     RowBox[{"a", "=", "0"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lam", " ", "=", " ", 
     RowBox[{"s", "*", 
      RowBox[{"t", "/", 
       RowBox[{"r", "^", "2"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.733696186551684*^9, 3.733696199439424*^9}, {
   3.741182813853012*^9, 3.74118281403675*^9}, 3.741183112020756*^9, 
   3.741183846494545*^9, 3.7411840398377657`*^9, {3.741185533323537*^9, 
   3.741185589579526*^9}},ExpressionUUID->"6682998e-b0d4-40b3-86f1-\
8890dad5d5e3"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "t"},
       {"0", "0", "x"},
       {"t", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["t", "2"], "x"},
       {
        FractionBox["t", "2"], "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, $CellContext`t}, {
     0, 0, $CellContext`x}, {$CellContext`t, $CellContext`x, \
$CellContext`x}}], 
   MatrixForm[{{0, Rational[1, 2] $CellContext`t, $CellContext`x}, {
     Rational[1, 
        2] $CellContext`t, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7336962012105713`*^9, 3.741182869441977*^9, {3.7411855570527077`*^9, 
   3.741185589945114*^9}},ExpressionUUID->"25aac70f-8cf7-4a62-bbfb-\
020f38a9d468"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         RowBox[{"lam", " ", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{"s", " ", "t"}]], 
        FractionBox[
         RowBox[{"a", " ", "lam", " ", "r"}], 
         RowBox[{"s", " ", "t"}]], 
        FractionBox[
         RowBox[{"b", " ", "lam", " ", "r"}], 
         RowBox[{"s", " ", "t"}]]},
       {
        FractionBox[
         RowBox[{"a", " ", "lam", " ", "r"}], 
         RowBox[{"s", " ", "t"}]], 
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], " ", "lam"}], 
         RowBox[{"s", " ", "t"}]], 
        FractionBox[
         RowBox[{"a", " ", "b", " ", "lam"}], 
         RowBox[{"s", " ", "t"}]]},
       {
        FractionBox[
         RowBox[{"b", " ", "lam", " ", "r"}], 
         RowBox[{"s", " ", "t"}]], 
        FractionBox[
         RowBox[{"a", " ", "b", " ", "lam"}], 
         RowBox[{"s", " ", "t"}]], 
        FractionBox[
         RowBox[{
          SuperscriptBox["b", "2"], " ", "lam"}], 
         RowBox[{"s", " ", "t"}]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{$CellContext`lam $CellContext`r^2 \
$CellContext`s^(-1)/$CellContext`t, $CellContext`a $CellContext`lam \
$CellContext`r $CellContext`s^(-1)/$CellContext`t, $CellContext`b \
$CellContext`lam $CellContext`r $CellContext`s^(-1)/$CellContext`t}, \
{$CellContext`a $CellContext`lam $CellContext`r \
$CellContext`s^(-1)/$CellContext`t, $CellContext`a^2 $CellContext`lam \
$CellContext`s^(-1)/$CellContext`t, $CellContext`a $CellContext`b \
$CellContext`lam $CellContext`s^(-1)/$CellContext`t}, {$CellContext`b \
$CellContext`lam $CellContext`r $CellContext`s^(-1)/$CellContext`t, \
$CellContext`a $CellContext`b $CellContext`lam \
$CellContext`s^(-1)/$CellContext`t, $CellContext`b^2 $CellContext`lam \
$CellContext`s^(-1)/$CellContext`t}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7336962012105713`*^9, 3.741182869441977*^9, {3.7411855570527077`*^9, 
   3.741185589947489*^9}},ExpressionUUID->"2511a3c3-dc1a-4cea-87a9-\
88b6e86a48a7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", 
        FractionBox["b", "r"]},
       {"0", "0", "0"},
       {
        FractionBox["b", "r"], "0", 
        FractionBox[
         SuperscriptBox["b", "2"], 
         SuperscriptBox["r", "2"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}], 
   MatrixForm[{{1, 0, $CellContext`b/$CellContext`r}, {0, 0, 
     0}, {$CellContext`b/$CellContext`r, 
      0, $CellContext`b^2 $CellContext`r^(-2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7336962012105713`*^9, 3.741182869441977*^9, {3.7411855570527077`*^9, 
   3.7411855899498653`*^9}},ExpressionUUID->"f2dd35c0-c807-4a24-a3e4-\
27d1f7c5e215"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{205, Automatic}, {13, Automatic}},
FrontEndVersion->"11.1 for Linux x86 (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 6307, 169, 558, "Input", "ExpressionUUID" -> \
"0e488e49-726f-4185-b1ac-02561b59a832"],
Cell[CellGroupData[{
Cell[6912, 195, 2094, 56, 79, "Print", "ExpressionUUID" -> \
"e0068e45-9653-4e74-9720-77bb8a6f713d"],
Cell[9009, 253, 5828, 147, 104, "Print", "ExpressionUUID" -> \
"4ba354e8-48b6-4c19-9c65-6e73181e55bc"],
Cell[14840, 402, 1997, 54, 74, "Print", "ExpressionUUID" -> \
"040d7783-3dcf-4c78-9836-3bb532b74154"],
Cell[16840, 458, 1816, 49, 59, "Print", "ExpressionUUID" -> \
"3c006be7-83a0-4ca2-803e-31138a1994cd"]
}, Open  ]]
}, Open  ]],
Cell[18683, 511, 154, 3, 32, "Input", "ExpressionUUID" -> \
"c9c24adc-a524-4799-af92-746040865bfa"],
Cell[CellGroupData[{
Cell[18862, 518, 4190, 115, 376, "Input", "ExpressionUUID" -> \
"8f18d29d-1335-4ebd-b003-26393740552f"],
Cell[CellGroupData[{
Cell[23077, 637, 1944, 52, 79, "Print", "ExpressionUUID" -> \
"0f28bece-ca09-4366-9ec0-c3e71e1242aa"],
Cell[25024, 691, 3235, 88, 89, "Print", "ExpressionUUID" -> \
"05db5b9e-9d1f-4a67-b044-288bd835119a"],
Cell[28262, 781, 2466, 71, 89, "Print", "ExpressionUUID" -> \
"5720545c-f4de-44b5-9f5a-bbd2588a8b21"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30777, 858, 4658, 130, 444, "Input", "ExpressionUUID" -> \
"c6c2f7c7-ef4b-4b1f-b119-6692748579c2"],
Cell[CellGroupData[{
Cell[35460, 992, 1980, 54, 79, "Print", "ExpressionUUID" -> \
"e74fe360-da33-436e-b84b-79355159b4a5"],
Cell[37443, 1048, 5025, 133, 99, "Print", "ExpressionUUID" -> \
"dd66a5e1-7c4f-4386-aa36-a202211a5353"],
Cell[42471, 1183, 4317, 117, 100, "Print", "ExpressionUUID" -> \
"46398fad-3c13-4aed-8a48-46d72b1bca06"],
Cell[46791, 1302, 3825, 105, 97, "Print", "ExpressionUUID" -> \
"fda8da7e-9e9b-4972-be3d-8095fc6cb4df"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50665, 1413, 5011, 137, 468, "Input", "ExpressionUUID" -> \
"9cf163a4-504e-46fe-84a1-d7debc26edd6"],
Cell[CellGroupData[{
Cell[55701, 1554, 2166, 57, 79, "Print", "ExpressionUUID" -> \
"76f76cef-7625-41ef-a916-52b59df5180b"],
Cell[57870, 1613, 5268, 136, 103, "Print", "ExpressionUUID" -> \
"87354b09-4b2e-4e46-ab94-f6556754dc1b"],
Cell[63141, 1751, 3918, 106, 99, "Print", "ExpressionUUID" -> \
"377b0de8-c526-43b3-b391-664e598071d9"],
Cell[67062, 1859, 2924, 80, 99, "Print", "ExpressionUUID" -> \
"cfef23fb-7b85-45f4-aab3-8453596d5671"]
}, Open  ]]
}, Open  ]],
Cell[70013, 1943, 152, 3, 32, "Input", "ExpressionUUID" -> \
"fcc33aa7-1868-499f-a17e-151b16644881"],
Cell[CellGroupData[{
Cell[70190, 1950, 5534, 153, 581, "Input", "ExpressionUUID" -> \
"db2ecbcc-f901-4d7d-bf9f-023ab4b7cad2"],
Cell[CellGroupData[{
Cell[75749, 2107, 1871, 51, 79, "Print", "ExpressionUUID" -> \
"cae501bb-9cba-4972-949c-556305512ac2"],
Cell[77623, 2160, 11028, 290, 222, "Print", "ExpressionUUID" -> \
"3b4000fe-067f-4cb4-877c-10d7b7baf9d9"],
Cell[88654, 2452, 2335, 67, 82, "Print", "ExpressionUUID" -> \
"dd82a2a0-5077-43f7-9cb6-10daa0ae1a88"],
Cell[90992, 2521, 1815, 50, 75, "Print", "ExpressionUUID" -> \
"9d5af02b-8d21-4963-b3c0-13c67127e845"],
Cell[92810, 2573, 1869, 52, 75, "Print", "ExpressionUUID" -> \
"6068428c-d74f-41cc-9057-6c679a4eb54e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[94728, 2631, 4593, 129, 446, "Input", "ExpressionUUID" -> \
"6fe7fc4f-4a3d-48b2-a5eb-f07e4d151acc"],
Cell[CellGroupData[{
Cell[99346, 2764, 1934, 53, 79, "Print", "ExpressionUUID" -> \
"b954a576-bb1f-4b97-898a-16a7d22bf951"],
Cell[101283, 2819, 5885, 150, 104, "Print", "ExpressionUUID" -> \
"e48d22dd-df46-43f1-8d9a-0b5eed0f5f04"],
Cell[107171, 2971, 3159, 88, 99, "Print", "ExpressionUUID" -> \
"f1bbc122-e127-4fec-9ade-5217e13f30ad"],
Cell[110333, 3061, 1772, 49, 79, "Print", "ExpressionUUID" -> \
"a9f18783-1cf1-44ac-969e-d88e198afd91"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[112154, 3116, 5167, 145, 514, "Input", "ExpressionUUID" -> \
"b23feb67-8910-46eb-959e-9aaa5f83f572"],
Cell[CellGroupData[{
Cell[117346, 3265, 2001, 54, 79, "Print", "ExpressionUUID" -> \
"133b3521-292d-4639-b779-0837719a7a4d"],
Cell[119350, 3321, 7890, 197, 208, "Print", "ExpressionUUID" -> \
"fb040db1-081b-4f8f-9697-f7c3f8134222"],
Cell[127243, 3520, 4694, 128, 103, "Print", "ExpressionUUID" -> \
"ede80ef3-d199-40ec-b52b-0bd958153c28"],
Cell[131940, 3650, 3498, 96, 99, "Print", "ExpressionUUID" -> \
"86351963-4862-49f7-8f9e-daff3611b318"],
Cell[135441, 3748, 2085, 57, 84, "Print", "ExpressionUUID" -> \
"f815451d-c37b-429b-a0ca-9ebbd1e3a697"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[137575, 3811, 4608, 128, 446, "Input", "ExpressionUUID" -> \
"e659b6b1-47e4-4521-a177-18d933139978"],
Cell[CellGroupData[{
Cell[142208, 3943, 1929, 53, 79, "Print", "ExpressionUUID" -> \
"e3a1a197-aebf-4f84-becc-8291a1434b7b"],
Cell[144140, 3998, 7599, 189, 222, "Print", "ExpressionUUID" -> \
"76d368fc-47d7-4bc8-bc5c-19f7863f0b54"],
Cell[151742, 4189, 1866, 53, 74, "Print", "ExpressionUUID" -> \
"339f521b-80a3-437e-b03a-25bb831dea62"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[153657, 4248, 3945, 108, 354, "Input", "ExpressionUUID" -> \
"305ddbb1-2cf2-462a-abef-c0ae9ddcc410"],
Cell[CellGroupData[{
Cell[157627, 4360, 1929, 53, 79, "Print", "ExpressionUUID" -> \
"1d2e9f84-8f31-4390-80e3-61b4168f8e22"],
Cell[159559, 4415, 3266, 86, 89, "Print", "ExpressionUUID" -> \
"b025bce5-0b58-49de-b8aa-4ff8e9c52f2f"],
Cell[162828, 4503, 2576, 71, 85, "Print", "ExpressionUUID" -> \
"f1165bae-02bb-416f-8e29-2a407a57b1e1"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[165453, 4580, 4176, 116, 378, "Input", "ExpressionUUID" -> \
"6682998e-b0d4-40b3-86f1-8890dad5d5e3"],
Cell[CellGroupData[{
Cell[169654, 4700, 1930, 53, 79, "Print", "ExpressionUUID" -> \
"25aac70f-8cf7-4a62-bbfb-020f38a9d468"],
Cell[171587, 4755, 3312, 87, 101, "Print", "ExpressionUUID" -> \
"2511a3c3-dc1a-4cea-87a9-88b6e86a48a7"],
Cell[174902, 4844, 1901, 53, 84, "Print", "ExpressionUUID" -> \
"f2dd35c0-c807-4a24-a3e4-27d1f7c5e215"]
}, Open  ]]
}, Open  ]]
}
]
*)

