(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     69981,       2001]
NotebookOptionsPosition[     67214,       1923]
NotebookOutlinePosition[     67550,       1938]
CellTagsIndexPosition[     67507,       1935]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "This", " ", "file", " ", "verifies", " ", "the", " ", "calculation", " ", 
    "of", " ", "stabilizers", " ", "above", " ", "the", " ", "mod", " ", "p", 
    " ", "orbit", " ", "O14"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Stabilizer", " ", "calculation", " ", "of", " ", "orbit", " ", "with", 
    " ", "representative", " ", "v1"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", 
         RowBox[{"y", "+", 
          RowBox[{"z", "/", "2"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "z", ",", " ", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"y", " ", "+", " ", 
          RowBox[{"z", "/", "2"}]}], ",", " ", "x", ",", " ", "x"}], "}"}]}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Vx2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"y", ",", " ", "x", ",", " ", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], "*", "a", "*", 
          RowBox[{"s", "/", "t"}]}], ",", " ", "t", ",", " ", "0"}], "}"}], 
       ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "a", ",", " ", 
         RowBox[{
          RowBox[{"t", "^", "2"}], "/", "s"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"s", "^", "2"}], "/", 
        RowBox[{"t", "^", "4"}]}], " ", "*", " ", "A1"}], " ", "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "^", "2"}], "/", 
            RowBox[{"t", "^", "2"}]}], " ", "+", " ", 
           RowBox[{"b", "/", "s"}]}], ")"}]}], "*", 
        RowBox[{
         RowBox[{"s", "^", "2"}], "/", 
         RowBox[{"t", "^", "4"}]}], " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", 
          RowBox[{"t", "^", "2"}]}], ")"}], " ", "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.733603881811367*^9, 3.733604137603126*^9}, {
   3.733604170891293*^9, 3.733604198122884*^9}, {3.7336054403800087`*^9, 
   3.7336054762674303`*^9}, {3.733673632099154*^9, 3.733673683457472*^9}, {
   3.7336737722487803`*^9, 3.733673780336542*^9}, {3.733690015157235*^9, 
   3.7336900196212273`*^9}, {3.733690071261084*^9, 3.733690159956675*^9}, 
   3.733690431181098*^9, {3.741182109814707*^9, 
   3.7411822558110237`*^9}},ExpressionUUID->"f0da6a9e-c909-4a23-a141-\
427768ef3d40"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{"y", "+", 
         FractionBox["z", "2"]}]},
       {"0", "z", "x"},
       {
        RowBox[{"y", "+", 
         FractionBox["z", "2"]}], "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"y", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, $CellContext`y + Rational[1, 2] $CellContext`z}, {
     0, $CellContext`z, $CellContext`x}, {$CellContext`y + 
      Rational[1, 2] $CellContext`z, $CellContext`x, $CellContext`x}}], 
   MatrixForm[{{$CellContext`y, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733605477720667*^9, 3.733673782399786*^9, 
  3.733690161316215*^9, 
  3.7411822570969343`*^9},ExpressionUUID->"89946bce-70ee-4a82-9adf-\
18d9c32c7a3c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         SuperscriptBox["s", "4"], 
         SuperscriptBox["t", "4"]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", "a", " ", 
           SuperscriptBox["s", "4"]}], 
          SuperscriptBox["t", "5"]]}], 
        FractionBox[
         RowBox[{"b", " ", 
          SuperscriptBox["s", "3"]}], 
         SuperscriptBox["t", "4"]]},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", "a", " ", 
           SuperscriptBox["s", "4"]}], 
          SuperscriptBox["t", "5"]]}], 
        FractionBox[
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["s", "4"]}], 
         SuperscriptBox["t", "6"]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", "a", " ", "b", " ", 
           SuperscriptBox["s", "3"]}], 
          SuperscriptBox["t", "5"]]}]},
       {
        FractionBox[
         RowBox[{"b", " ", 
          SuperscriptBox["s", "3"]}], 
         SuperscriptBox["t", "4"]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", "a", " ", "b", " ", 
           SuperscriptBox["s", "3"]}], 
          SuperscriptBox["t", "5"]]}], 
        FractionBox[
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["s", "2"]}], 
         SuperscriptBox["t", "4"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["s", "4"]}], 
           SuperscriptBox["t", "6"]]}], "-", 
         FractionBox[
          RowBox[{"b", " ", 
           SuperscriptBox["s", "3"]}], 
          SuperscriptBox["t", "4"]]}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "3"], " ", 
           SuperscriptBox["s", "4"]}], 
          SuperscriptBox["t", "7"]], "+", 
         FractionBox[
          RowBox[{"2", " ", "a", " ", "b", " ", 
           SuperscriptBox["s", "3"]}], 
          SuperscriptBox["t", "5"]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["a", "2"], " ", "b", " ", 
            SuperscriptBox["s", "3"]}], 
           SuperscriptBox["t", "6"]]}], "-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["s", "2"]}], 
          SuperscriptBox["t", "4"]]}]},
       {
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "3"], " ", 
           SuperscriptBox["s", "4"]}], 
          SuperscriptBox["t", "7"]], "+", 
         FractionBox[
          RowBox[{"2", " ", "a", " ", "b", " ", 
           SuperscriptBox["s", "3"]}], 
          SuperscriptBox["t", "5"]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"4", " ", 
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["s", "4"]}], 
           SuperscriptBox["t", "8"]]}], "-", 
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"], " ", "b", " ", 
           SuperscriptBox["s", "3"]}], 
          SuperscriptBox["t", "6"]]}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "3"], " ", "b", " ", 
           SuperscriptBox["s", "3"]}], 
          SuperscriptBox["t", "7"]], "+", 
         FractionBox[
          RowBox[{"2", " ", "a", " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["s", "2"]}], 
          SuperscriptBox["t", "5"]]}]},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["a", "2"], " ", "b", " ", 
            SuperscriptBox["s", "3"]}], 
           SuperscriptBox["t", "6"]]}], "-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["s", "2"]}], 
          SuperscriptBox["t", "4"]]}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "3"], " ", "b", " ", 
           SuperscriptBox["s", "3"]}], 
          SuperscriptBox["t", "7"]], "+", 
         FractionBox[
          RowBox[{"2", " ", "a", " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["s", "2"]}], 
          SuperscriptBox["t", "5"]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["s", "2"]}], 
           SuperscriptBox["t", "6"]]}], "-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["b", "3"], " ", "s"}], 
          SuperscriptBox["t", "4"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`s^4 $CellContext`t^(-4), (-2) $CellContext`a \
$CellContext`s^4 $CellContext`t^(-5), $CellContext`b $CellContext`s^3 \
$CellContext`t^(-4)}, {(-2) $CellContext`a $CellContext`s^4 \
$CellContext`t^(-5), 
      4 $CellContext`a^2 $CellContext`s^4 $CellContext`t^(-6), (-2) \
$CellContext`a $CellContext`b $CellContext`s^3 $CellContext`t^(-5)}, \
{$CellContext`b $CellContext`s^3 $CellContext`t^(-4), (-2) $CellContext`a \
$CellContext`b $CellContext`s^3 $CellContext`t^(-5), $CellContext`b^2 \
$CellContext`s^2 $CellContext`t^(-4)}}], 
   MatrixForm[{{-$CellContext`a^2 $CellContext`s^4 $CellContext`t^(-6) - \
$CellContext`b $CellContext`s^3 $CellContext`t^(-4), 
      2 $CellContext`a^3 $CellContext`s^4 $CellContext`t^(-7) + 
      2 $CellContext`a $CellContext`b $CellContext`s^3 $CellContext`t^(-5), \
-$CellContext`a^2 $CellContext`b $CellContext`s^3 $CellContext`t^(-6) - \
$CellContext`b^2 $CellContext`s^2 $CellContext`t^(-4)}, {
     2 $CellContext`a^3 $CellContext`s^4 $CellContext`t^(-7) + 
      2 $CellContext`a $CellContext`b $CellContext`s^3 $CellContext`t^(-5), \
(-4) $CellContext`a^4 $CellContext`s^4 $CellContext`t^(-8) - 
      4 $CellContext`a^2 $CellContext`b $CellContext`s^3 $CellContext`t^(-6), 
      2 $CellContext`a^3 $CellContext`b $CellContext`s^3 $CellContext`t^(-7) + 
      2 $CellContext`a $CellContext`b^2 $CellContext`s^2 \
$CellContext`t^(-5)}, {-$CellContext`a^2 $CellContext`b $CellContext`s^3 \
$CellContext`t^(-6) - $CellContext`b^2 $CellContext`s^2 $CellContext`t^(-4), 
      2 $CellContext`a^3 $CellContext`b $CellContext`s^3 $CellContext`t^(-7) + 
      2 $CellContext`a $CellContext`b^2 $CellContext`s^2 $CellContext`t^(-5), \
-$CellContext`a^2 $CellContext`b^2 $CellContext`s^2 $CellContext`t^(-6) - \
$CellContext`b^3 $CellContext`s $CellContext`t^(-4)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733605477720667*^9, 3.733673782399786*^9, 
  3.733690161316215*^9, 
  3.741182257101254*^9},ExpressionUUID->"d1e04578-f553-4eea-91c2-\
2a6724c17c71"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7336040005819197`*^9, 
  3.733604001915707*^9}},ExpressionUUID->"6763bfb3-ce06-41f5-ac09-\
a426d1db0c8b"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Solve", " ", "a"}], " ", "=", " ", "0"}], "*)"}]], "Input",
 CellChangeTimes->{{3.741182272066422*^9, 
  3.741182289167975*^9}},ExpressionUUID->"1ffaf3c9-d4d1-45da-b16b-\
4930464ec8d9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
    ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", 
    " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
    "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"A", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
   ";"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["B",
    FontWeight->"Plain"], "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g3", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"s", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "t", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"b", ",", " ", "0", ",", " ", 
       RowBox[{
        RowBox[{"t", "^", "2"}], "/", "s"}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A1", " ", "=", " ", 
   RowBox[{"g3", ".", "A", ".", 
    RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B1", " ", "=", " ", 
   RowBox[{"g3", ".", "B", ".", 
    RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A2", " ", "=", " ", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"s", "^", "2"}], "/", 
      RowBox[{"t", "^", "4"}]}], " ", "*", " ", "A1"}], " ", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B2", " ", "=", " ", 
   RowBox[{"Expand", "[", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", " ", 
        RowBox[{"b", "/", "s"}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"s", "^", "2"}], "/", 
       RowBox[{"t", "^", "4"}]}], " ", "*", " ", "A1"}], " ", "+", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", 
        RowBox[{"t", "^", "2"}]}], ")"}], " ", "*", " ", "B1"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
    RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
    RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{
   RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
   RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.733690191612406*^9, 3.733690212854271*^9}, 
   3.733690436045176*^9, {3.74118230778459*^9, 
   3.7411823079457483`*^9}},ExpressionUUID->"9a88b698-3728-4956-b176-\
7ce1d4a0733f"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{"y", "+", 
         FractionBox["z", "2"]}]},
       {"0", "z", "x"},
       {
        RowBox[{"y", "+", 
         FractionBox["z", "2"]}], "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"y", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, $CellContext`y + Rational[1, 2] $CellContext`z}, {
     0, $CellContext`z, $CellContext`x}, {$CellContext`y + 
      Rational[1, 2] $CellContext`z, $CellContext`x, $CellContext`x}}], 
   MatrixForm[{{$CellContext`y, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.733690195553651*^9, 3.733690214288007*^9}, {
  3.741182305433818*^9, 
  3.7411823159218903`*^9}},ExpressionUUID->"b75fccd7-646e-4f64-9957-\
b640b3c08473"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         SuperscriptBox["s", "4"], 
         SuperscriptBox["t", "4"]], "0", 
        FractionBox[
         RowBox[{"b", " ", 
          SuperscriptBox["s", "3"]}], 
         SuperscriptBox["t", "4"]]},
       {"0", "0", "0"},
       {
        FractionBox[
         RowBox[{"b", " ", 
          SuperscriptBox["s", "3"]}], 
         SuperscriptBox["t", "4"]], "0", 
        FractionBox[
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["s", "2"]}], 
         SuperscriptBox["t", "4"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"b", " ", 
           SuperscriptBox["s", "3"]}], 
          SuperscriptBox["t", "4"]]}], "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["s", "2"]}], 
          SuperscriptBox["t", "4"]]}]},
       {"0", "0", "0"},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["s", "2"]}], 
          SuperscriptBox["t", "4"]]}], "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["b", "3"], " ", "s"}], 
          SuperscriptBox["t", "4"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`s^4 $CellContext`t^(-4), 
      0, $CellContext`b $CellContext`s^3 $CellContext`t^(-4)}, {0, 0, 
     0}, {$CellContext`b $CellContext`s^3 $CellContext`t^(-4), 
      0, $CellContext`b^2 $CellContext`s^2 $CellContext`t^(-4)}}], 
   MatrixForm[{{-$CellContext`b $CellContext`s^3 $CellContext`t^(-4), 
      0, -$CellContext`b^2 $CellContext`s^2 $CellContext`t^(-4)}, {0, 0, 
     0}, {-$CellContext`b^2 $CellContext`s^2 $CellContext`t^(-4), 
      0, -$CellContext`b^3 $CellContext`s $CellContext`t^(-4)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.733690195553651*^9, 3.733690214288007*^9}, {
  3.741182305433818*^9, 
  3.741182315924376*^9}},ExpressionUUID->"4fef8d07-332c-4cfd-a5a6-\
a8e5c2902c71"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Solve", " ", "b"}], " ", "=", " ", "0"}], "*)"}]], "Input",
 CellChangeTimes->{{3.741182294525729*^9, 
  3.741182298575841*^9}},ExpressionUUID->"3b9fe6f8-9352-442e-978c-\
902e8f670422"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
    ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",", 
    " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", " ", 
    "B22"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{
   RowBox[{"A", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
   ";"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["B",
    FontWeight->"Plain"], "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g3", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"s", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "t", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "0", ",", " ", 
       RowBox[{
        RowBox[{"t", "^", "2"}], "/", "s"}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A1", " ", "=", " ", 
   RowBox[{"g3", ".", "A", ".", 
    RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B1", " ", "=", " ", 
   RowBox[{"g3", ".", "B", ".", 
    RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A2", " ", "=", " ", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"s", "^", "2"}], "/", 
      RowBox[{"t", "^", "4"}]}], " ", "*", " ", "A1"}], " ", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B2", " ", "=", " ", 
   RowBox[{"Expand", "[", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "/", 
       RowBox[{"t", "^", "2"}]}], ")"}], " ", "*", " ", "B1"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
    RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
    RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{
   RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
   RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.733690318395397*^9, 3.7336903270832644`*^9}, 
   3.7336904416048603`*^9, {3.741182311479905*^9, 
   3.7411823116487617`*^9}},ExpressionUUID->"06dad99d-2bd9-47b0-a427-\
116aace28b50"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{"y", "+", 
         FractionBox["z", "2"]}]},
       {"0", "z", "x"},
       {
        RowBox[{"y", "+", 
         FractionBox["z", "2"]}], "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"y", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, $CellContext`y + Rational[1, 2] $CellContext`z}, {
     0, $CellContext`z, $CellContext`x}, {$CellContext`y + 
      Rational[1, 2] $CellContext`z, $CellContext`x, $CellContext`x}}], 
   MatrixForm[{{$CellContext`y, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7336903276649313`*^9, 
  3.741182312534155*^9},ExpressionUUID->"6aebb951-edbb-4202-9f45-\
6a7dc4d7ca6b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         SuperscriptBox["s", "4"], 
         SuperscriptBox["t", "4"]], "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`s^4 $CellContext`t^(-4), 0, 0}, {0, 0, 0}, {0, 0,
      0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.7336903276649313`*^9, 
  3.741182312535973*^9},ExpressionUUID->"2b54b317-a728-48d5-8721-\
ca62e5efadc0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Stabilizer", " ", "calculation", " ", "of", " ", "orbit", " ", "with", 
    " ", "representative", " ", "v2"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{"1", "/", "2"}], ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], "*", "a", "*", 
          RowBox[{"s", "/", "t"}]}], ",", " ", "t", ",", " ", "0"}], "}"}], 
       ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "a", ",", " ", 
         RowBox[{
          RowBox[{"t", "^", "2"}], "/", "s"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"s", "^", "2"}], "/", 
        RowBox[{"t", "^", "4"}]}], " ", "*", " ", "A1"}], " ", "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "^", "2"}], "/", 
            RowBox[{"t", "^", "2"}]}], " ", "+", " ", 
           RowBox[{"b", "/", "s"}]}], ")"}]}], "*", 
        RowBox[{
         RowBox[{"s", "^", "2"}], "/", 
         RowBox[{"t", "^", "4"}]}], " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", 
          RowBox[{"t", "^", "2"}]}], ")"}], " ", "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7336905889774227`*^9, 3.7336905978416357`*^9}, 
   3.741182372104623*^9, {3.741182405841527*^9, 
   3.741182452943452*^9}},ExpressionUUID->"1cf4da18-634e-426b-b654-\
2861bf20b73b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{"y", "+", 
         FractionBox["z", "2"]}]},
       {"0", "z", "x"},
       {
        RowBox[{"y", "+", 
         FractionBox["z", "2"]}], "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"y", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, $CellContext`y + Rational[1, 2] $CellContext`z}, {
     0, $CellContext`z, $CellContext`x}, {$CellContext`y + 
      Rational[1, 2] $CellContext`z, $CellContext`x, $CellContext`x}}], 
   MatrixForm[{{$CellContext`y, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733690598641879*^9, 3.7411823857485332`*^9, 
  3.741182455312015*^9},ExpressionUUID->"121cc745-d904-447b-8f9d-\
675cfa3aa6df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox[
         SuperscriptBox["s", "3"], 
         RowBox[{"2", " ", 
          SuperscriptBox["t", "3"]}]], 
        FractionBox[
         RowBox[{"a", " ", 
          SuperscriptBox["s", "3"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["t", "4"]}]]},
       {
        FractionBox[
         SuperscriptBox["s", "3"], 
         RowBox[{"2", " ", 
          SuperscriptBox["t", "3"]}]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", "a", " ", 
           SuperscriptBox["s", "3"]}], 
          SuperscriptBox["t", "4"]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["s", "3"]}], 
           SuperscriptBox["t", "5"]]}], "+", 
         FractionBox[
          RowBox[{"b", " ", 
           SuperscriptBox["s", "2"]}], 
          RowBox[{"2", " ", 
           SuperscriptBox["t", "3"]}]]}]},
       {
        FractionBox[
         RowBox[{"a", " ", 
          SuperscriptBox["s", "3"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["t", "4"]}]], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["s", "3"]}], 
           SuperscriptBox["t", "5"]]}], "+", 
         FractionBox[
          RowBox[{"b", " ", 
           SuperscriptBox["s", "2"]}], 
          RowBox[{"2", " ", 
           SuperscriptBox["t", "3"]}]]}], 
        FractionBox[
         RowBox[{"a", " ", "b", " ", 
          SuperscriptBox["s", "2"]}], 
         SuperscriptBox["t", "4"]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["s", "3"]}], 
           RowBox[{"2", " ", 
            SuperscriptBox["t", "5"]}]]}], "-", 
         FractionBox[
          RowBox[{"b", " ", 
           SuperscriptBox["s", "2"]}], 
          RowBox[{"2", " ", 
           SuperscriptBox["t", "3"]}]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["a", "3"], " ", 
            SuperscriptBox["s", "3"]}], 
           RowBox[{"2", " ", 
            SuperscriptBox["t", "6"]}]]}], "-", 
         FractionBox[
          RowBox[{"a", " ", "b", " ", 
           SuperscriptBox["s", "2"]}], 
          RowBox[{"2", " ", 
           SuperscriptBox["t", "4"]}]]}]},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["s", "3"]}], 
           RowBox[{"2", " ", 
            SuperscriptBox["t", "5"]}]]}], "-", 
         FractionBox[
          RowBox[{"b", " ", 
           SuperscriptBox["s", "2"]}], 
          RowBox[{"2", " ", 
           SuperscriptBox["t", "3"]}]]}], 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["a", "3"], " ", 
           SuperscriptBox["s", "3"]}], 
          SuperscriptBox["t", "6"]], "+", 
         FractionBox[
          RowBox[{"2", " ", "a", " ", "b", " ", 
           SuperscriptBox["s", "2"]}], 
          SuperscriptBox["t", "4"]]}], 
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           SuperscriptBox["s", "3"]}], 
          SuperscriptBox["t", "7"]], "+", 
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], " ", "b", " ", 
           SuperscriptBox["s", "2"]}], 
          RowBox[{"2", " ", 
           SuperscriptBox["t", "5"]}]], "-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["b", "2"], " ", "s"}], 
          RowBox[{"2", " ", 
           SuperscriptBox["t", "3"]}]]}]},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["a", "3"], " ", 
            SuperscriptBox["s", "3"]}], 
           RowBox[{"2", " ", 
            SuperscriptBox["t", "6"]}]]}], "-", 
         FractionBox[
          RowBox[{"a", " ", "b", " ", 
           SuperscriptBox["s", "2"]}], 
          RowBox[{"2", " ", 
           SuperscriptBox["t", "4"]}]]}], 
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           SuperscriptBox["s", "3"]}], 
          SuperscriptBox["t", "7"]], "+", 
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], " ", "b", " ", 
           SuperscriptBox["s", "2"]}], 
          RowBox[{"2", " ", 
           SuperscriptBox["t", "5"]}]], "-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["b", "2"], " ", "s"}], 
          RowBox[{"2", " ", 
           SuperscriptBox["t", "3"]}]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["a", "3"], " ", "b", " ", 
            SuperscriptBox["s", "2"]}], 
           SuperscriptBox["t", "6"]]}], "-", 
         FractionBox[
          RowBox[{"a", " ", 
           SuperscriptBox["b", "2"], " ", "s"}], 
          SuperscriptBox["t", "4"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{
     0, Rational[1, 2] $CellContext`s^3 $CellContext`t^(-3), 
      Rational[1, 2] $CellContext`a $CellContext`s^3 $CellContext`t^(-4)}, {
     Rational[1, 
        2] $CellContext`s^3 $CellContext`t^(-3), (-2) $CellContext`a \
$CellContext`s^3 $CellContext`t^(-4), -$CellContext`a^2 $CellContext`s^3 \
$CellContext`t^(-5) + 
      Rational[1, 2] $CellContext`b $CellContext`s^2 $CellContext`t^(-3)}, {
     Rational[1, 
        2] $CellContext`a $CellContext`s^3 $CellContext`t^(-4), \
-$CellContext`a^2 $CellContext`s^3 $CellContext`t^(-5) + 
      Rational[1, 
         2] $CellContext`b $CellContext`s^2 $CellContext`t^(-3), \
$CellContext`a $CellContext`b $CellContext`s^2 $CellContext`t^(-4)}}], 
   MatrixForm[{{
     0, Rational[-1, 2] $CellContext`a^2 $CellContext`s^3 $CellContext`t^(-5) + 
      Rational[-1, 2] $CellContext`b $CellContext`s^2 $CellContext`t^(-3), 
      Rational[-1, 2] $CellContext`a^3 $CellContext`s^3 $CellContext`t^(-6) + 
      Rational[-1, 
         2] $CellContext`a $CellContext`b $CellContext`s^2 \
$CellContext`t^(-4)}, {
     Rational[-1, 2] $CellContext`a^2 $CellContext`s^3 $CellContext`t^(-5) + 
      Rational[-1, 2] $CellContext`b $CellContext`s^2 $CellContext`t^(-3), 
      2 $CellContext`a^3 $CellContext`s^3 $CellContext`t^(-6) + 
      2 $CellContext`a $CellContext`b $CellContext`s^2 $CellContext`t^(-4), \
$CellContext`a^4 $CellContext`s^3 $CellContext`t^(-7) + 
      Rational[1, 
         2] $CellContext`a^2 $CellContext`b $CellContext`s^2 \
$CellContext`t^(-5) + 
      Rational[-1, 2] $CellContext`b^2 $CellContext`s $CellContext`t^(-3)}, {
     Rational[-1, 2] $CellContext`a^3 $CellContext`s^3 $CellContext`t^(-6) + 
      Rational[-1, 
         2] $CellContext`a $CellContext`b $CellContext`s^2 \
$CellContext`t^(-4), $CellContext`a^4 $CellContext`s^3 $CellContext`t^(-7) + 
      Rational[1, 
         2] $CellContext`a^2 $CellContext`b $CellContext`s^2 \
$CellContext`t^(-5) + 
      Rational[-1, 
         2] $CellContext`b^2 $CellContext`s $CellContext`t^(-3), \
-$CellContext`a^3 $CellContext`b $CellContext`s^2 $CellContext`t^(-6) - \
$CellContext`a $CellContext`b^2 $CellContext`s $CellContext`t^(-4)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733690598641879*^9, 3.7411823857485332`*^9, 
  3.741182455318173*^9},ExpressionUUID->"a9d7d04f-bb86-4181-b913-\
9bedee7d68c2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Solve", " ", "a"}], " ", "=", " ", "0"}], " ", "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", 
         RowBox[{"1", "/", "2"}], ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "t", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "0", ",", " ", 
         RowBox[{
          RowBox[{"t", "^", "2"}], "/", "s"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"s", "^", "2"}], "/", 
        RowBox[{"t", "^", "4"}]}], " ", "*", " ", "A1"}], " ", "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", " ", 
          RowBox[{"b", "/", "s"}], ")"}]}], "*", 
        RowBox[{
         RowBox[{"s", "^", "2"}], "/", 
         RowBox[{"t", "^", "4"}]}], " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", 
          RowBox[{"t", "^", "2"}]}], ")"}], " ", "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.733690777425356*^9, 3.733690796363173*^9}, 
   3.7411823750568867`*^9, {3.741182462464637*^9, 
   3.741182466648552*^9}},ExpressionUUID->"7cd08c94-cb69-44e7-b861-\
505450c85978"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{"y", "+", 
         FractionBox["z", "2"]}]},
       {"0", "z", "x"},
       {
        RowBox[{"y", "+", 
         FractionBox["z", "2"]}], "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"y", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, $CellContext`y + Rational[1, 2] $CellContext`z}, {
     0, $CellContext`z, $CellContext`x}, {$CellContext`y + 
      Rational[1, 2] $CellContext`z, $CellContext`x, $CellContext`x}}], 
   MatrixForm[{{$CellContext`y, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7336907831341476`*^9, 3.733690798552589*^9}, 
   3.741182381661038*^9, 
   3.741182468351315*^9},ExpressionUUID->"06182592-0eb0-4135-96ff-\
3d67368210e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox[
         SuperscriptBox["s", "3"], 
         RowBox[{"2", " ", 
          SuperscriptBox["t", "3"]}]], "0"},
       {
        FractionBox[
         SuperscriptBox["s", "3"], 
         RowBox[{"2", " ", 
          SuperscriptBox["t", "3"]}]], "0", 
        FractionBox[
         RowBox[{"b", " ", 
          SuperscriptBox["s", "2"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["t", "3"]}]]},
       {"0", 
        FractionBox[
         RowBox[{"b", " ", 
          SuperscriptBox["s", "2"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["t", "3"]}]], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"b", " ", 
           SuperscriptBox["s", "2"]}], 
          RowBox[{"2", " ", 
           SuperscriptBox["t", "3"]}]]}], "0"},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"b", " ", 
           SuperscriptBox["s", "2"]}], 
          RowBox[{"2", " ", 
           SuperscriptBox["t", "3"]}]]}], "0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["b", "2"], " ", "s"}], 
          RowBox[{"2", " ", 
           SuperscriptBox["t", "3"]}]]}]},
       {"0", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["b", "2"], " ", "s"}], 
          RowBox[{"2", " ", 
           SuperscriptBox["t", "3"]}]]}], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, Rational[1, 2] $CellContext`s^3 $CellContext`t^(-3), 0}, {
     Rational[1, 2] $CellContext`s^3 $CellContext`t^(-3), 0, 
      Rational[1, 2] $CellContext`b $CellContext`s^2 $CellContext`t^(-3)}, {
     0, Rational[1, 2] $CellContext`b $CellContext`s^2 $CellContext`t^(-3), 
      0}}], 
   MatrixForm[{{
     0, Rational[-1, 2] $CellContext`b $CellContext`s^2 $CellContext`t^(-3), 
      0}, {Rational[-1, 
        2] $CellContext`b $CellContext`s^2 $CellContext`t^(-3), 0, 
      Rational[-1, 2] $CellContext`b^2 $CellContext`s $CellContext`t^(-3)}, {
     0, Rational[-1, 2] $CellContext`b^2 $CellContext`s $CellContext`t^(-3), 
      0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7336907831341476`*^9, 3.733690798552589*^9}, 
   3.741182381661038*^9, 
   3.741182468353878*^9},ExpressionUUID->"06db6c7c-480b-4452-baec-\
5f92b942e463"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Stabilizer", " ", "calculation", " ", "of", " ", "orbit", " ", "with", 
    " ", "representative", " ", "v3"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], "*", "a", "*", 
          RowBox[{"s", "/", "t"}]}], ",", " ", "t", ",", " ", "0"}], "}"}], 
       ",", " ", 
       RowBox[{"{", 
        RowBox[{"b", ",", " ", "a", ",", " ", 
         RowBox[{
          RowBox[{"t", "^", "2"}], "/", "s"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"s", "^", "2"}], "/", 
        RowBox[{"t", "^", "4"}]}], " ", "*", " ", "A1"}], " ", "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "^", "2"}], "/", 
            RowBox[{"t", "^", "2"}]}], " ", "+", " ", 
           RowBox[{"b", "/", "s"}]}], ")"}]}], "*", 
        RowBox[{
         RowBox[{"s", "^", "2"}], "/", 
         RowBox[{"t", "^", "4"}]}], " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", 
          RowBox[{"t", "^", "2"}]}], ")"}], " ", "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "Vx1", "]"}], ",", " ", 
      RowBox[{"MatrixForm", "[", "Vx2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.7336910231355658`*^9, 3.733691059159173*^9}, {
   3.7336911904885807`*^9, 3.733691193422719*^9}, 3.741182377601067*^9, {
   3.7411824870164022`*^9, 
   3.741182491639167*^9}},ExpressionUUID->"0f126974-ff0a-4e97-b991-\
528cc174721b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{"y", "+", 
         FractionBox["z", "2"]}]},
       {"0", "z", "x"},
       {
        RowBox[{"y", "+", 
         FractionBox["z", "2"]}], "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"y", "x", "x"},
       {"x", "x", "x"},
       {"x", "x", "x"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, $CellContext`y + Rational[1, 2] $CellContext`z}, {
     0, $CellContext`z, $CellContext`x}, {$CellContext`y + 
      Rational[1, 2] $CellContext`z, $CellContext`x, $CellContext`x}}], 
   MatrixForm[{{$CellContext`y, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733691110240316*^9, 3.7336911988367167`*^9, 
  3.741182378893854*^9, 
  3.741182492182991*^9},ExpressionUUID->"1f7b39a4-f962-4581-becf-\
3e352c036242"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["s", "2"], 
          SuperscriptBox["t", "2"]]}]},
       {"0", 
        FractionBox[
         SuperscriptBox["s", "2"], 
         SuperscriptBox["t", "2"]], 
        FractionBox[
         RowBox[{"3", " ", "a", " ", 
          SuperscriptBox["s", "2"]}], 
         SuperscriptBox["t", "3"]]},
       {
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["s", "2"], 
          SuperscriptBox["t", "2"]]}], 
        FractionBox[
         RowBox[{"3", " ", "a", " ", 
          SuperscriptBox["s", "2"]}], 
         SuperscriptBox["t", "3"]], 
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["s", "2"]}], 
          SuperscriptBox["t", "4"]], "-", 
         FractionBox[
          RowBox[{"2", " ", "b", " ", "s"}], 
          SuperscriptBox["t", "2"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         RowBox[{"2", " ", 
          SuperscriptBox["s", "2"]}], 
         SuperscriptBox["t", "2"]], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"4", " ", "a", " ", 
           SuperscriptBox["s", "2"]}], 
          SuperscriptBox["t", "3"]]}], 
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["s", "2"]}], 
          SuperscriptBox["t", "4"]], "+", 
         FractionBox[
          RowBox[{"3", " ", "b", " ", "s"}], 
          SuperscriptBox["t", "2"]]}]},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"4", " ", "a", " ", 
           SuperscriptBox["s", "2"]}], 
          SuperscriptBox["t", "3"]]}], 
        RowBox[{
         FractionBox[
          RowBox[{"7", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["s", "2"]}], 
          SuperscriptBox["t", "4"]], "-", 
         FractionBox[
          RowBox[{"b", " ", "s"}], 
          SuperscriptBox["t", "2"]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"3", " ", 
            SuperscriptBox["a", "3"], " ", 
            SuperscriptBox["s", "2"]}], 
           SuperscriptBox["t", "5"]]}], "-", 
         FractionBox[
          RowBox[{"7", " ", "a", " ", "b", " ", "s"}], 
          SuperscriptBox["t", "3"]]}]},
       {
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["s", "2"]}], 
          SuperscriptBox["t", "4"]], "+", 
         FractionBox[
          RowBox[{"3", " ", "b", " ", "s"}], 
          SuperscriptBox["t", "2"]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{"3", " ", 
            SuperscriptBox["a", "3"], " ", 
            SuperscriptBox["s", "2"]}], 
           SuperscriptBox["t", "5"]]}], "-", 
         FractionBox[
          RowBox[{"7", " ", "a", " ", "b", " ", "s"}], 
          SuperscriptBox["t", "3"]]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["s", "2"]}], 
           SuperscriptBox["t", "6"]]}], "+", 
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], " ", "b", " ", "s"}], 
          SuperscriptBox["t", "4"]], "+", 
         FractionBox[
          RowBox[{"4", " ", 
           SuperscriptBox["b", "2"]}], 
          SuperscriptBox["t", "2"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{0, 0, -$CellContext`s^2 $CellContext`t^(-2)}, {
     0, $CellContext`s^2 $CellContext`t^(-2), 
      3 $CellContext`a $CellContext`s^2 $CellContext`t^(-3)}, \
{-$CellContext`s^2 $CellContext`t^(-2), 
      3 $CellContext`a $CellContext`s^2 $CellContext`t^(-3), $CellContext`a^2 \
$CellContext`s^2 $CellContext`t^(-4) - 
      2 $CellContext`b $CellContext`s $CellContext`t^(-2)}}], 
   MatrixForm[{{
     2 $CellContext`s^2 $CellContext`t^(-2), (-4) $CellContext`a \
$CellContext`s^2 $CellContext`t^(-3), $CellContext`a^2 $CellContext`s^2 \
$CellContext`t^(-4) + 
      3 $CellContext`b $CellContext`s $CellContext`t^(-2)}, {(-4) \
$CellContext`a $CellContext`s^2 $CellContext`t^(-3), 
      7 $CellContext`a^2 $CellContext`s^2 $CellContext`t^(-4) - \
$CellContext`b $CellContext`s $CellContext`t^(-2), (-3) $CellContext`a^3 \
$CellContext`s^2 $CellContext`t^(-5) - 
      7 $CellContext`a $CellContext`b $CellContext`s $CellContext`t^(-3)}, \
{$CellContext`a^2 $CellContext`s^2 $CellContext`t^(-4) + 
      3 $CellContext`b $CellContext`s $CellContext`t^(-2), (-3) \
$CellContext`a^3 $CellContext`s^2 $CellContext`t^(-5) - 
      7 $CellContext`a $CellContext`b $CellContext`s $CellContext`t^(-3), \
-$CellContext`a^4 $CellContext`s^2 $CellContext`t^(-6) + $CellContext`a^2 \
$CellContext`b $CellContext`s $CellContext`t^(-4) + 
      4 $CellContext`b^2 $CellContext`t^(-2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733691110240316*^9, 3.7336911988367167`*^9, 
  3.741182378893854*^9, 
  3.741182492186306*^9},ExpressionUUID->"109ab83a-56ca-41e8-b92d-\
ffa39fa8a819"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{205, Automatic}, {13, Automatic}},
FrontEndVersion->"11.1 for Linux x86 (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 5149, 140, 375, "Input", "ExpressionUUID" -> \
"f0da6a9e-c909-4a23-a141-427768ef3d40"],
Cell[CellGroupData[{
Cell[5754, 166, 2037, 54, 75, "Print", "ExpressionUUID" -> \
"89946bce-70ee-4a82-9adf-18d9c32c7a3c"],
Cell[7794, 222, 8012, 213, 104, "Print", "ExpressionUUID" -> \
"d1e04578-f553-4eea-91c2-2a6724c17c71"]
}, Open  ]]
}, Open  ]],
Cell[15833, 439, 154, 3, 32, "Input", "ExpressionUUID" -> \
"4b32317b-9f53-49e0-abfc-edd4289e9345"],
Cell[15990, 444, 238, 6, 32, "Input", "ExpressionUUID" -> \
"1ffaf3c9-d4d1-45da-b16b-4930464ec8d9"],
Cell[CellGroupData[{
Cell[16253, 454, 3084, 91, 241, "Input", "ExpressionUUID" -> \
"9a88b698-3728-4956-b176-7ce1d4a0733f"],
Cell[CellGroupData[{
Cell[19362, 549, 2041, 54, 75, "Print", "ExpressionUUID" -> \
"b75fccd7-646e-4f64-9957-b640b3c08473"],
Cell[21406, 605, 3223, 90, 89, "Print", "ExpressionUUID" -> \
"4fef8d07-332c-4cfd-a5a6-a8e5c2902c71"]
}, Open  ]]
}, Open  ]],
Cell[24656, 699, 243, 6, 32, "Input", "ExpressionUUID" -> \
"3b9fe6f8-9352-442e-978c-902e8f670422"],
Cell[CellGroupData[{
Cell[24924, 709, 2837, 83, 241, "Input", "ExpressionUUID" -> \
"06dad99d-2bd9-47b0-a427-116aace28b50"],
Cell[CellGroupData[{
Cell[27786, 796, 1990, 53, 75, "Print", "ExpressionUUID" -> \
"6aebb951-edbb-4202-9f45-6a7dc4d7ca6b"],
Cell[29779, 851, 1730, 49, 74, "Print", "ExpressionUUID" -> \
"2b54b317-a728-48d5-8721-ca62e5efadc0"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31558, 906, 3731, 106, 263, "Input", "ExpressionUUID" -> \
"1cf4da18-634e-426b-b654-2861bf20b73b"],
Cell[CellGroupData[{
Cell[35314, 1016, 2012, 53, 75, "Print", "ExpressionUUID" -> \
"121cc745-d904-447b-8f9d-675cfa3aa6df"],
Cell[37329, 1071, 8726, 242, 222, "Print", "ExpressionUUID" -> \
"a9d7d04f-bb86-4181-b913-9bedee7d68c2"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[46104, 1319, 3410, 97, 263, "Input", "ExpressionUUID" -> \
"7cd08c94-cb69-44e7-b861-505450c85978"],
Cell[CellGroupData[{
Cell[49539, 1420, 2041, 54, 75, "Print", "ExpressionUUID" -> \
"06182592-0eb0-4135-96ff-3d67368210e4"],
Cell[51583, 1476, 3475, 98, 104, "Print", "ExpressionUUID" -> \
"06db6c7c-480b-4452-baec-5f92b942e463"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[55107, 1580, 3750, 107, 263, "Input", "ExpressionUUID" -> \
"0f126974-ff0a-4e97-b991-528cc174721b"],
Cell[CellGroupData[{
Cell[58882, 1691, 2037, 54, 75, "Print", "ExpressionUUID" -> \
"1f7b39a4-f962-4581-becf-3e352c036242"],
Cell[60922, 1747, 6264, 172, 104, "Print", "ExpressionUUID" -> \
"109ab83a-56ca-41e8-b92d-ffa39fa8a819"]
}, Open  ]]
}, Open  ]]
}
]
*)

