(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     12717,        373]
NotebookOptionsPosition[     11947,        347]
NotebookOutlinePosition[     12283,        362]
CellTagsIndexPosition[     12240,        359]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "file", " ", "verifies", " ", "the", " ", "stabilizer", " ", 
    "calculation", " ", "for", " ", "the", " ", "maximal", " ", "orbit", " ", 
    "above", " ", "O131"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"a", ",", " ", "t", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", 
         RowBox[{
          RowBox[{"t", "^", "2"}], "/", "s"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"s", "/", 
        RowBox[{"t", "^", "3"}]}], " ", "*", " ", "A1"}], " ", "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], "/", 
         RowBox[{"t", "^", "3"}]}], " ", "*", " ", "A1"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", 
          RowBox[{"t", "^", "2"}]}], ")"}], " ", "*", " ", "B1"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.733603881811367*^9, 3.733604137603126*^9}, {
   3.733604170891293*^9, 3.733604198122884*^9}, {3.7336054403800087`*^9, 
   3.7336054762674303`*^9}, {3.733673632099154*^9, 3.733673683457472*^9}, {
   3.7336737722487803`*^9, 3.733673780336542*^9}, {3.733690015157235*^9, 
   3.7336900196212273`*^9}, {3.733690071261084*^9, 3.733690159956675*^9}, 
   3.733690431181098*^9, {3.733691984370245*^9, 3.733692041601634*^9}, {
   3.74118262743003*^9, 
   3.741182647390889*^9}},ExpressionUUID->"c2857497-d14f-4b87-8d6c-\
f785f24754ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         SuperscriptBox["s", "3"], 
         SuperscriptBox["t", "3"]], 
        FractionBox[
         RowBox[{"a", " ", 
          SuperscriptBox["s", "2"]}], 
         SuperscriptBox["t", "3"]], "0"},
       {
        FractionBox[
         RowBox[{"a", " ", 
          SuperscriptBox["s", "2"]}], 
         SuperscriptBox["t", "3"]], 
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], " ", "s"}], 
         SuperscriptBox["t", "3"]], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"a", " ", 
           SuperscriptBox["s", "2"]}], 
          SuperscriptBox["t", "3"]]}], 
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], " ", "s"}], 
          SuperscriptBox["t", "3"]]}], "0"},
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], " ", "s"}], 
          SuperscriptBox["t", "3"]]}], 
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["a", "3"], 
          SuperscriptBox["t", "3"]]}], "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`s^3 $CellContext`t^(-3), $CellContext`a \
$CellContext`s^2 $CellContext`t^(-3), 
      0}, {$CellContext`a $CellContext`s^2 $CellContext`t^(-3), \
$CellContext`a^2 $CellContext`s $CellContext`t^(-3), 0}, {0, 0, 0}}], 
   MatrixForm[{{-$CellContext`a $CellContext`s^2 $CellContext`t^(-3), \
-$CellContext`a^2 $CellContext`s $CellContext`t^(-3), 
      0}, {-$CellContext`a^2 $CellContext`s $CellContext`t^(-3), \
-$CellContext`a^3 $CellContext`t^(-3), 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.733605477720667*^9, 3.733673782399786*^9, 
  3.733690161316215*^9, 
  3.7336920469496527`*^9},ExpressionUUID->"370b6cd9-ab32-42ce-b251-\
e605a68d1728"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7336040005819197`*^9, 
  3.733604001915707*^9}},ExpressionUUID->"6763bfb3-ce06-41f5-ac09-\
a426d1db0c8b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Solve", " ", "a"}], " ", "=", " ", "0"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{
     "x", ",", " ", "A11", ",", " ", "A12", ",", " ", "A13", ",", " ", "A21", 
      ",", " ", "A22", ",", " ", "A23", ",", " ", "A31", ",", " ", "A32", ",",
       " ", "A33", ",", " ", "B11", ",", " ", "B12", ",", " ", "B21", ",", 
      " ", "B22"}], "]"}], ";"}], "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"A", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     StyleBox["B",
      FontWeight->"Plain"], "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "t", ",", " ", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", 
         RowBox[{
          RowBox[{"t", "^", "2"}], "/", "s"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"g3", ".", "A", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B1", " ", "=", " ", 
     RowBox[{"g3", ".", "B", ".", 
      RowBox[{"Transpose", "[", "g3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"s", "/", 
        RowBox[{"t", "^", "3"}]}], " ", "*", " ", "A1"}], " ", "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"B2", " ", "=", " ", 
     RowBox[{"Expand", "[", "  ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", 
         RowBox[{"t", "^", "2"}]}], ")"}], " ", "*", " ", "B1"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "A2", "]"}], ",", " ", 
     RowBox[{"MatrixForm", "[", "B2", "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.733692069257202*^9, 3.7336920757689667`*^9}, {
  3.741182651598196*^9, 
  3.7411826562465363`*^9}},ExpressionUUID->"1d40762a-ffc0-4d46-9c18-\
770c9ab4106e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         SuperscriptBox["s", "3"], 
         SuperscriptBox["t", "3"]], "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "0"},
       {"0", "0", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{$CellContext`s^3 $CellContext`t^(-3), 0, 0}, {0, 0, 0}, {0, 0,
      0}}], 
   MatrixForm[{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.733692076555978*^9},ExpressionUUID->"d1414f49-c9e0-46aa-b70b-\
ffd7c563f04e"]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{205, Automatic}, {13, Automatic}},
FrontEndVersion->"11.1 for Linux x86 (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 3569, 93, 306, "Input", "ExpressionUUID" -> \
"c2857497-d14f-4b87-8d6c-f785f24754ca"],
Cell[4152, 117, 3052, 86, 89, "Print", "ExpressionUUID" -> \
"faedcb5b-fc64-47a3-85ef-fca7da6490b6"]
}, Open  ]],
Cell[7219, 206, 154, 3, 32, "Input", "ExpressionUUID" -> \
"a89cfdbf-3946-433f-bb6d-4cacb4de2d23"],
Cell[CellGroupData[{
Cell[7398, 213, 2824, 80, 240, "Input", "ExpressionUUID" -> \
"1d40762a-ffc0-4d46-9c18-770c9ab4106e"],
Cell[10225, 295, 1706, 49, 74, "Print", "ExpressionUUID" -> \
"1610ef4c-fc86-4d49-8f85-126c02f1b919"]
}, Open  ]]
}
]
*)

